/* umockdev-record.c generated by valac 0.22.1, the Vala compiler
 * generated from umockdev-record.vala, do not modify */

/*
 * Record Linux devices and their ancestors from sysfs/udev.
 * All attributes and properties are included, non-ASCII ones get printed in hex.
 * The record is written to the standard output.
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/types.h>
#include <glib/gstdio.h>
#include <fcntl.h>
#include <unistd.h>
#include "config.h"

#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);


extern guint record_script_counter;
guint record_script_counter = (guint) 0;
extern gchar** opt_devices;
gchar** opt_devices = NULL;
extern gboolean opt_all;
gboolean opt_all = FALSE;
extern gchar* opt_ioctl;
gchar* opt_ioctl = NULL;
extern gchar** opt_script;
gchar** opt_script = NULL;
extern gchar** opt_evemu_events;
gchar** opt_evemu_events = NULL;
extern gboolean opt_version;
gboolean opt_version = FALSE;

void exit_error (const gchar* message, ...);
void devices_from_dir (const gchar* dir, GPtrArray** devs);
gchar** all_devices (void);
static void _g_free0_ (gpointer var);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar* resolve (const gchar* dev);
gchar* parent (const gchar* dev);
gchar* format_hex (guint8* bytes, int bytes_length1, gint len);
void write_attr (const gchar* name, guint8* val, int val_length1);
gchar* dev_contents (const gchar* dev);
void record_device (const gchar* dev);
static void _g_list_free__g_free0_ (GList* self);
void dump_devices (gchar** devices, int devices_length1);
void split_devfile_arg (const gchar* arg, gchar** dev, gchar** devnum, gchar** fname);
void record_ioctl (const gchar* arg);
void record_script (const gchar* arg, const gchar* format);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[7] = {{"all", 'a', 0, G_OPTION_ARG_NONE, &opt_all, "Record all devices"}, {"ioctl", 'i', 0, G_OPTION_ARG_FILENAME, &opt_ioctl, "Trace ioctls on the device, record into given file. In this case, all " \
"positional arguments are a command (and its arguments) to run that get" \
"s traced.", "devname=FILE"}, {"script", 's', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_script, "Trace reads and writes on the device, record into given file. In this " \
"case, all positional arguments are a command (and its arguments) to ru" \
"n that gets traced. Can be specified multiple times.", "devname=FILE"}, {"evemu-events", 'e', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_evemu_events, "Trace evdev event reads on the device, record into given file in EVEMU" \
" event format. In this case, all positional arguments are a command (a" \
"nd its arguments) to run that gets traced. Can be specified multiple t" \
"imes.", "devname=FILE"}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &opt_devices, "Path of a device in /dev or /sys, or command and arguments with --ioct" \
"l.", "DEVICE [...]"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &opt_version, "Output version information and exit"}, {NULL}};

void exit_error (const gchar* message, ...) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	FILE* _tmp3_ = NULL;
	g_return_if_fail (message != NULL);
	_tmp0_ = stderr;
	_tmp1_ = message;
	va_start (_tmp2_, message);
	vfprintf (_tmp0_, _tmp1_, _tmp2_);
	va_end (_tmp2_);
	_tmp3_ = stderr;
	fputs ("\n", _tmp3_);
	exit (1);
}


void devices_from_dir (const gchar* dir, GPtrArray** devs) {
	GDir* d = NULL;
	gboolean has_uevent = FALSE;
	gboolean has_subsystem = FALSE;
	gchar* entry = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dir != NULL);
	g_return_if_fail (*devs != NULL);
	{
		GDir* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GDir* _tmp2_ = NULL;
		_tmp1_ = dir;
		_tmp2_ = g_dir_open (_tmp1_, (guint) 0, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_dir_close0 (d);
		d = _tmp0_;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
		_g_dir_close0 (d);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	has_uevent = FALSE;
	has_subsystem = FALSE;
	while (TRUE) {
		GDir* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp3_ = d;
		_tmp4_ = g_dir_read_name (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (entry);
		entry = _tmp5_;
		_tmp6_ = entry;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = entry;
		if (g_strcmp0 (_tmp7_, "uevent") == 0) {
			has_uevent = TRUE;
		} else {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = entry;
			if (g_strcmp0 (_tmp8_, "subsystem") == 0) {
				has_subsystem = TRUE;
			} else {
				gchar* p = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				struct stat st = {0};
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_ = NULL;
				struct stat _tmp15_ = {0};
				gint _tmp16_ = 0;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp24_ = FALSE;
				_tmp9_ = dir;
				_tmp10_ = entry;
				_tmp11_ = g_build_filename (_tmp9_, _tmp10_, NULL);
				p = _tmp11_;
				_tmp14_ = p;
				_tmp16_ = lstat (_tmp14_, &_tmp15_);
				st = _tmp15_;
				if (_tmp16_ == 0) {
					struct stat _tmp17_ = {0};
					mode_t _tmp18_ = {0};
					gboolean _tmp19_ = FALSE;
					_tmp17_ = st;
					_tmp18_ = _tmp17_.st_mode;
					_tmp19_ = S_ISDIR (_tmp18_);
					_tmp13_ = _tmp19_;
				} else {
					_tmp13_ = FALSE;
				}
				_tmp20_ = _tmp13_;
				if (_tmp20_) {
					struct stat _tmp21_ = {0};
					mode_t _tmp22_ = {0};
					gboolean _tmp23_ = FALSE;
					_tmp21_ = st;
					_tmp22_ = _tmp21_.st_mode;
					_tmp23_ = S_ISLNK (_tmp22_);
					_tmp12_ = !_tmp23_;
				} else {
					_tmp12_ = FALSE;
				}
				_tmp24_ = _tmp12_;
				if (_tmp24_) {
					const gchar* _tmp25_ = NULL;
					_tmp25_ = p;
					devices_from_dir (_tmp25_, devs);
				}
				_g_free0 (p);
			}
		}
	}
	_tmp27_ = has_uevent;
	if (_tmp27_) {
		gboolean _tmp28_ = FALSE;
		_tmp28_ = has_subsystem;
		_tmp26_ = _tmp28_;
	} else {
		_tmp26_ = FALSE;
	}
	_tmp29_ = _tmp26_;
	if (_tmp29_) {
		GPtrArray* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp30_ = *devs;
		_tmp31_ = dir;
		_tmp32_ = g_strdup (_tmp31_);
		g_ptr_array_add (_tmp30_, _tmp32_);
	}
	_g_free0 (entry);
	_g_dir_close0 (d);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** all_devices (void) {
	gchar** result = NULL;
	GPtrArray* devs = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	gpointer* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = g_ptr_array_new_with_free_func (_g_free0_);
	devs = _tmp0_;
	devices_from_dir ("/sys/devices", &devs);
	_tmp1_ = devs;
	_tmp2_ = _tmp1_->pdata;
	_tmp2__length1 = (gint) _tmp1_->len;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	result = _tmp3_;
	_g_ptr_array_unref0 (devs);
	return result;
}


gchar* resolve (const gchar* dev) {
	gchar* result = NULL;
	struct stat st = {0};
	const gchar* _tmp0_ = NULL;
	struct stat _tmp1_ = {0};
	gint _tmp2_ = 0;
	guint major = 0U;
	struct stat _tmp6_ = {0};
	dev_t _tmp7_ = {0};
	guint _tmp8_ = 0U;
	guint minor = 0U;
	struct stat _tmp9_ = {0};
	dev_t _tmp10_ = {0};
	guint _tmp11_ = 0U;
	gchar* link = NULL;
	struct stat _tmp12_ = {0};
	mode_t _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	gchar* real = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = dev;
	_tmp2_ = stat (_tmp0_, &_tmp1_);
	st = _tmp1_;
	if (_tmp2_ != 0) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = dev;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		exit_error ("Cannot access device %s: %s", _tmp3_, _tmp5_, NULL);
	}
	_tmp6_ = st;
	_tmp7_ = _tmp6_.st_rdev;
	_tmp8_ = major (_tmp7_);
	major = _tmp8_;
	_tmp9_ = st;
	_tmp10_ = _tmp9_.st_rdev;
	_tmp11_ = minor (_tmp10_);
	minor = _tmp11_;
	_tmp12_ = st;
	_tmp13_ = _tmp12_.st_mode;
	_tmp14_ = S_ISCHR (_tmp13_);
	if (_tmp14_) {
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		gchar* _tmp17_ = NULL;
		_tmp15_ = major;
		_tmp16_ = minor;
		_tmp17_ = g_strdup_printf ("/sys/dev/char/%u:%u", _tmp15_, _tmp16_);
		_g_free0 (link);
		link = _tmp17_;
	} else {
		struct stat _tmp18_ = {0};
		mode_t _tmp19_ = {0};
		gboolean _tmp20_ = FALSE;
		_tmp18_ = st;
		_tmp19_ = _tmp18_.st_mode;
		_tmp20_ = S_ISBLK (_tmp19_);
		if (_tmp20_) {
			guint _tmp21_ = 0U;
			guint _tmp22_ = 0U;
			gchar* _tmp23_ = NULL;
			_tmp21_ = major;
			_tmp22_ = minor;
			_tmp23_ = g_strdup_printf ("/sys/dev/block/%u:%u", _tmp21_, _tmp22_);
			_g_free0 (link);
			link = _tmp23_;
		} else {
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			_tmp24_ = dev;
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (link);
			link = _tmp25_;
		}
	}
	_tmp26_ = link;
	_tmp27_ = realpath (_tmp26_, NULL);
	real = _tmp27_;
	_tmp28_ = real;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp29_ = link;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (real);
		real = _tmp30_;
	}
	_tmp31_ = real;
	_tmp32_ = g_build_filename (_tmp31_, "uevent", NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_file_test (_tmp33_, G_FILE_TEST_EXISTS);
	_tmp35_ = !_tmp34_;
	_g_free0 (_tmp33_);
	if (_tmp35_) {
		const gchar* _tmp36_ = NULL;
		_tmp36_ = real;
		exit_error ("Invalid device %s, has no uevent attribute", _tmp36_, NULL);
	}
	result = real;
	_g_free0 (link);
	return result;
}


gchar* parent (const gchar* dev) {
	gchar* result = NULL;
	gchar* p = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = dev;
	_tmp1_ = g_path_get_dirname (_tmp0_);
	p = _tmp1_;
	_tmp2_ = p;
	_tmp3_ = g_str_has_prefix (_tmp2_, "/sys");
	if (!_tmp3_) {
		result = NULL;
		_g_free0 (p);
		return result;
	}
	_tmp5_ = p;
	_tmp6_ = g_build_filename (_tmp5_, "uevent", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	if (_tmp9_) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = p;
		_tmp11_ = g_build_filename (_tmp10_, "subsystem", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_test (_tmp12_, G_FILE_TEST_EXISTS);
		_tmp4_ = _tmp13_;
		_g_free0 (_tmp12_);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp14_ = _tmp4_;
	if (_tmp14_) {
		result = p;
		return result;
	}
	_tmp15_ = p;
	_tmp16_ = parent (_tmp15_);
	result = _tmp16_;
	_g_free0 (p);
	return result;
}


gchar* format_hex (guint8* bytes, int bytes_length1, gint len) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	GString* _result_ = NULL;
	GString* _tmp2_ = NULL;
	GString* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	_tmp0_ = len;
	if (_tmp0_ < 0) {
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp1_ = bytes;
		_tmp1__length1 = bytes_length1;
		len = _tmp1__length1;
	}
	_tmp2_ = g_string_new ("");
	_result_ = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GString* _tmp8_ = NULL;
				guint8* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				guint8 _tmp11_ = 0U;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = len;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _result_;
				_tmp9_ = bytes;
				_tmp9__length1 = bytes_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				g_string_append_printf (_tmp8_, "%02X", (guint) _tmp11_);
			}
		}
	}
	_tmp12_ = _result_;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_string_free0 (_result_);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}


void write_attr (const gchar* name, guint8* val, int val_length1) {
	gchar* strval = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp9_ = FALSE;
	FILE* _tmp22_ = NULL;
	g_return_if_fail (name != NULL);
	_tmp0_ = val;
	_tmp0__length1 = val_length1;
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	strval = _tmp1_;
	_tmp3_ = val;
	_tmp3__length1 = val_length1;
	_tmp4_ = strval;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp3__length1 == _tmp6_) {
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = strval;
		_tmp8_ = g_utf8_validate (_tmp7_, (gssize) (-1), NULL);
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp9_ = _tmp2_;
	if (_tmp9_) {
		FILE* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp10_ = stdout;
		_tmp11_ = name;
		_tmp12_ = strval;
		_tmp13_ = string_chomp (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strescape (_tmp14_, "");
		_tmp16_ = _tmp15_;
		fprintf (_tmp10_, "A: %s=%s", _tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
	} else {
		FILE* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		guint8* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = name;
		_tmp19_ = val;
		_tmp19__length1 = val_length1;
		_tmp20_ = format_hex (_tmp19_, _tmp19__length1, -1);
		_tmp21_ = _tmp20_;
		fprintf (_tmp17_, "H: %s=%s", _tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = stdout;
	fputc ('\n', _tmp22_);
	_g_free0 (strval);
}


gchar* dev_contents (const gchar* dev) {
	gchar* result = NULL;
	struct stat st = {0};
	const gchar* _tmp0_ = NULL;
	struct stat _tmp1_ = {0};
	gint _tmp2_ = 0;
	gboolean _tmp4_ = FALSE;
	struct stat _tmp5_ = {0};
	mode_t _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint fd = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	guint8* buffer = NULL;
	guint8* _tmp17_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gssize len = 0L;
	gint _tmp18_ = 0;
	guint8* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gssize _tmp20_ = 0L;
	gchar* _result_ = NULL;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gssize _tmp23_ = 0L;
	gboolean _tmp25_ = FALSE;
	gint _tmp31_ = 0;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = dev;
	_tmp2_ = lstat (_tmp0_, &_tmp1_);
	st = _tmp1_;
	if (_tmp2_ != 0) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp5_ = st;
	_tmp6_ = _tmp5_.st_mode;
	_tmp7_ = S_ISCHR (_tmp6_);
	if (!_tmp7_) {
		_tmp4_ = TRUE;
	} else {
		struct stat _tmp8_ = {0};
		dev_t _tmp9_ = {0};
		guint _tmp10_ = 0U;
		_tmp8_ = st;
		_tmp9_ = _tmp8_.st_rdev;
		_tmp10_ = major (_tmp9_);
		_tmp4_ = _tmp10_ != ((guint) 189);
	}
	_tmp11_ = _tmp4_;
	if (_tmp11_) {
		gchar* _tmp12_ = NULL;
		_tmp12_ = g_strdup ("");
		result = _tmp12_;
		return result;
	}
	_tmp13_ = dev;
	_tmp14_ = open (_tmp13_, O_RDONLY | O_NONBLOCK, (mode_t) 0);
	fd = _tmp14_;
	_tmp15_ = fd;
	if (_tmp15_ < 0) {
		gchar* _tmp16_ = NULL;
		_tmp16_ = g_strdup ("");
		result = _tmp16_;
		return result;
	}
	_tmp17_ = g_new0 (guint8, 1025);
	buffer = _tmp17_;
	buffer_length1 = 1025;
	_buffer_size_ = buffer_length1;
	_tmp18_ = fd;
	_tmp19_ = buffer;
	_tmp19__length1 = buffer_length1;
	_tmp20_ = read (_tmp18_, _tmp19_, (gsize) 1025);
	len = _tmp20_;
	_tmp21_ = g_strdup ("");
	_result_ = _tmp21_;
	_tmp23_ = len;
	if (_tmp23_ > ((gssize) 0)) {
		gssize _tmp24_ = 0L;
		_tmp24_ = len;
		_tmp22_ = _tmp24_ <= ((gssize) 1024);
	} else {
		_tmp22_ = FALSE;
	}
	_tmp25_ = _tmp22_;
	if (_tmp25_) {
		guint8* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		gssize _tmp27_ = 0L;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp26_ = buffer;
		_tmp26__length1 = buffer_length1;
		_tmp27_ = len;
		_tmp28_ = format_hex (_tmp26_, _tmp26__length1, (gint) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat ("=", _tmp29_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp30_;
		_g_free0 (_tmp29_);
	}
	_tmp31_ = fd;
	close (_tmp31_);
	result = _result_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


void record_device (const gchar* dev) {
	const gchar* _tmp0_ = NULL;
	gchar* u_out = NULL;
	gint exitcode = 0;
	const gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	const gchar* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	GDir* d = NULL;
	GList* attributes = NULL;
	gchar* entry = NULL;
	GCompareFunc _tmp80_ = NULL;
	GList* _tmp81_ = NULL;
	FILE* _tmp104_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dev != NULL);
	_tmp0_ = dev;
	g_debug ("umockdev-record.vala:170: recording device %s", _tmp0_);
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp1_ = g_strdup ("udevadm");
		_tmp2_ = g_strdup ("info");
		_tmp3_ = g_strdup ("--query=all");
		_tmp4_ = g_strdup ("--path");
		_tmp5_ = dev;
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = g_new0 (gchar*, 5 + 1);
		_tmp7_[0] = _tmp1_;
		_tmp7_[1] = _tmp2_;
		_tmp7_[2] = _tmp3_;
		_tmp7_[3] = _tmp4_;
		_tmp7_[4] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 5;
		g_spawn_sync (NULL, _tmp8_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, NULL, &_tmp10_, &_inner_error_);
		_g_free0 (u_out);
		u_out = _tmp9_;
		exitcode = _tmp10_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp11_ = exitcode;
		if (_tmp11_ != 0) {
			gint _tmp12_ = 0;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			GError* _tmp16_ = NULL;
			_tmp12_ = exitcode;
			_tmp13_ = g_strdup_printf ("udevadm exited with code %i", _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			_inner_error_ = _tmp16_;
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		exit_error ("Cannot call udevadm: %s", _tmp18_, NULL);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (u_out);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp19_ = u_out;
	_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp21_;
		line_collection_length1 = _vala_array_length (_tmp20_);
		for (line_it = 0; line_it < _vala_array_length (_tmp20_); line_it = line_it + 1) {
			gchar* _tmp22_ = NULL;
			gchar* line = NULL;
			_tmp22_ = g_strdup (line_collection[line_it]);
			line = _tmp22_;
			{
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				const gchar* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gboolean _tmp32_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gboolean _tmp38_ = FALSE;
				gboolean _tmp41_ = FALSE;
				const gchar* _tmp42_ = NULL;
				gboolean _tmp43_ = FALSE;
				FILE* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				FILE* _tmp57_ = NULL;
				_tmp27_ = line;
				_tmp28_ = strlen (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == 0) {
					_tmp26_ = TRUE;
				} else {
					const gchar* _tmp30_ = NULL;
					gboolean _tmp31_ = FALSE;
					_tmp30_ = line;
					_tmp31_ = g_str_has_prefix (_tmp30_, "E: DEVPATH=");
					_tmp26_ = _tmp31_;
				}
				_tmp32_ = _tmp26_;
				if (_tmp32_) {
					_tmp25_ = TRUE;
				} else {
					const gchar* _tmp33_ = NULL;
					gboolean _tmp34_ = FALSE;
					_tmp33_ = line;
					_tmp34_ = g_str_has_prefix (_tmp33_, "E: UDEV_LOG=");
					_tmp25_ = _tmp34_;
				}
				_tmp35_ = _tmp25_;
				if (_tmp35_) {
					_tmp24_ = TRUE;
				} else {
					const gchar* _tmp36_ = NULL;
					gboolean _tmp37_ = FALSE;
					_tmp36_ = line;
					_tmp37_ = g_str_has_prefix (_tmp36_, "E: USEC_INITIALIZED=");
					_tmp24_ = _tmp37_;
				}
				_tmp38_ = _tmp24_;
				if (_tmp38_) {
					_tmp23_ = TRUE;
				} else {
					const gchar* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					_tmp39_ = line;
					_tmp40_ = g_str_has_prefix (_tmp39_, "L: ");
					_tmp23_ = _tmp40_;
				}
				_tmp41_ = _tmp23_;
				if (_tmp41_) {
					_g_free0 (line);
					continue;
				}
				_tmp42_ = line;
				_tmp43_ = g_str_has_prefix (_tmp42_, "N: ");
				if (_tmp43_) {
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					gchar* _tmp54_ = NULL;
					_tmp44_ = line;
					_tmp45_ = line;
					_tmp46_ = string_substring (_tmp45_, (glong) 3, (glong) (-1));
					_tmp47_ = _tmp46_;
					_tmp48_ = string_chomp (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_strconcat ("/dev/", _tmp49_, NULL);
					_tmp51_ = _tmp50_;
					_tmp52_ = dev_contents (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strconcat (_tmp44_, _tmp53_, NULL);
					_g_free0 (line);
					line = _tmp54_;
					_g_free0 (_tmp53_);
					_g_free0 (_tmp51_);
					_g_free0 (_tmp49_);
					_g_free0 (_tmp47_);
				}
				_tmp55_ = stdout;
				_tmp56_ = line;
				fputs (_tmp56_, _tmp55_);
				_tmp57_ = stdout;
				fputc ('\n', _tmp57_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp58_ = dev;
	_tmp59_ = string_contains (_tmp58_, "tegra");
	if (_tmp59_) {
		FILE* _tmp60_ = NULL;
		_tmp60_ = stdout;
		fputc ('\n', _tmp60_);
		_g_free0 (u_out);
		return;
	}
	{
		GDir* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		GDir* _tmp63_ = NULL;
		_tmp62_ = dev;
		_tmp63_ = g_dir_open (_tmp62_, (guint) 0, &_inner_error_);
		_tmp61_ = _tmp63_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_dir_close0 (d);
		d = _tmp61_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp64_ = NULL;
		GError* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp64_ = dev;
		_tmp65_ = e;
		_tmp66_ = _tmp65_->message;
		exit_error ("Cannot open directory %s: %s", _tmp64_, _tmp66_, NULL);
		_g_error_free0 (e);
		_g_dir_close0 (d);
		_g_free0 (u_out);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (d);
		_g_free0 (u_out);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	attributes = NULL;
	while (TRUE) {
		GDir* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		gchar* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		gboolean _tmp71_ = FALSE;
		gboolean _tmp72_ = FALSE;
		const gchar* _tmp73_ = NULL;
		gboolean _tmp75_ = FALSE;
		gboolean _tmp77_ = FALSE;
		_tmp67_ = d;
		_tmp68_ = g_dir_read_name (_tmp67_);
		_tmp69_ = g_strdup (_tmp68_);
		_g_free0 (entry);
		entry = _tmp69_;
		_tmp70_ = entry;
		if (!(_tmp70_ != NULL)) {
			break;
		}
		_tmp73_ = entry;
		if (g_strcmp0 (_tmp73_, "subsystem") != 0) {
			const gchar* _tmp74_ = NULL;
			_tmp74_ = entry;
			_tmp72_ = g_strcmp0 (_tmp74_, "firmware_node") != 0;
		} else {
			_tmp72_ = FALSE;
		}
		_tmp75_ = _tmp72_;
		if (_tmp75_) {
			const gchar* _tmp76_ = NULL;
			_tmp76_ = entry;
			_tmp71_ = g_strcmp0 (_tmp76_, "uevent") != 0;
		} else {
			_tmp71_ = FALSE;
		}
		_tmp77_ = _tmp71_;
		if (_tmp77_) {
			const gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			_tmp78_ = entry;
			_tmp79_ = g_strdup (_tmp78_);
			attributes = g_list_append (attributes, _tmp79_);
		}
	}
	_tmp80_ = g_strcmp0;
	attributes = g_list_sort (attributes, _tmp80_);
	_tmp81_ = attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp81_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			gchar* _tmp82_ = NULL;
			gchar* attr = NULL;
			_tmp82_ = g_strdup ((const gchar*) attr_it->data);
			attr = _tmp82_;
			{
				gchar* attr_path = NULL;
				const gchar* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
				gchar* _tmp85_ = NULL;
				const gchar* _tmp86_ = NULL;
				gboolean _tmp87_ = FALSE;
				_tmp83_ = dev;
				_tmp84_ = attr;
				_tmp85_ = g_build_filename (_tmp83_, _tmp84_, NULL);
				attr_path = _tmp85_;
				_tmp86_ = attr_path;
				_tmp87_ = g_file_test (_tmp86_, G_FILE_TEST_IS_SYMLINK);
				if (_tmp87_) {
					{
						gchar* _tmp88_ = NULL;
						const gchar* _tmp89_ = NULL;
						gchar* _tmp90_ = NULL;
						FILE* _tmp91_ = NULL;
						const gchar* _tmp92_ = NULL;
						gchar* _tmp93_ = NULL;
						_tmp89_ = attr_path;
						_tmp90_ = g_file_read_link (_tmp89_, &_inner_error_);
						_tmp88_ = _tmp90_;
						if (_inner_error_ != NULL) {
							goto __catch3_g_error;
						}
						_tmp91_ = stdout;
						_tmp92_ = attr;
						_tmp93_ = _tmp88_;
						fprintf (_tmp91_, "L: %s=%s\n", _tmp92_, _tmp93_);
						_g_free0 (_tmp93_);
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp94_ = NULL;
						GError* _tmp95_ = NULL;
						const gchar* _tmp96_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp94_ = attr;
						_tmp95_ = e;
						_tmp96_ = _tmp95_->message;
						exit_error ("Cannot read link %s: %s", _tmp94_, _tmp96_, NULL);
						_g_error_free0 (e);
					}
					__finally3:
					if (_inner_error_ != NULL) {
						_g_free0 (attr_path);
						_g_free0 (attr);
						_g_free0 (entry);
						__g_list_free__g_free0_0 (attributes);
						_g_dir_close0 (d);
						_g_free0 (u_out);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					const gchar* _tmp97_ = NULL;
					gboolean _tmp98_ = FALSE;
					_tmp97_ = attr_path;
					_tmp98_ = g_file_test (_tmp97_, G_FILE_TEST_IS_REGULAR);
					if (_tmp98_) {
						guint8* contents = NULL;
						gint contents_length1 = 0;
						gint _contents_size_ = 0;
						{
							const gchar* _tmp99_ = NULL;
							guint8* _tmp100_ = NULL;
							size_t _tmp101_;
							const gchar* _tmp102_ = NULL;
							guint8* _tmp103_ = NULL;
							gint _tmp103__length1 = 0;
							_tmp99_ = attr_path;
							g_file_get_contents (_tmp99_, (gchar**) (&_tmp100_), &_tmp101_, &_inner_error_);
							contents = (g_free (contents), NULL);
							contents = _tmp100_;
							contents_length1 = _tmp101_;
							_contents_size_ = contents_length1;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_FILE_ERROR) {
									goto __catch4_g_file_error;
								}
								contents = (g_free (contents), NULL);
								_g_free0 (attr_path);
								_g_free0 (attr);
								_g_free0 (entry);
								__g_list_free__g_free0_0 (attributes);
								_g_dir_close0 (d);
								_g_free0 (u_out);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp102_ = attr;
							_tmp103_ = contents;
							_tmp103__length1 = contents_length1;
							write_attr (_tmp102_, _tmp103_, _tmp103__length1);
						}
						goto __finally4;
						__catch4_g_file_error:
						{
							GError* e = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (e);
						}
						__finally4:
						if (_inner_error_ != NULL) {
							contents = (g_free (contents), NULL);
							_g_free0 (attr_path);
							_g_free0 (attr);
							_g_free0 (entry);
							__g_list_free__g_free0_0 (attributes);
							_g_dir_close0 (d);
							_g_free0 (u_out);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						contents = (g_free (contents), NULL);
					}
				}
				_g_free0 (attr_path);
				_g_free0 (attr);
			}
		}
	}
	_tmp104_ = stdout;
	fputc ('\n', _tmp104_);
	_g_free0 (entry);
	__g_list_free__g_free0_0 (attributes);
	_g_dir_close0 (d);
	_g_free0 (u_out);
}


void dump_devices (gchar** devices, int devices_length1) {
	GHashTable* seen = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	seen = _tmp2_;
	_tmp3_ = devices;
	_tmp3__length1 = devices_length1;
	{
		gchar** device_collection = NULL;
		gint device_collection_length1 = 0;
		gint _device_collection_size_ = 0;
		gint device_it = 0;
		device_collection = _tmp3_;
		device_collection_length1 = _tmp3__length1;
		for (device_it = 0; device_it < _tmp3__length1; device_it = device_it + 1) {
			gchar* _tmp4_ = NULL;
			gchar* device = NULL;
			_tmp4_ = g_strdup (device_collection[device_it]);
			device = _tmp4_;
			{
				while (TRUE) {
					const gchar* _tmp5_ = NULL;
					GHashTable* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp5_ = device;
					if (!(_tmp5_ != NULL)) {
						break;
					}
					_tmp6_ = seen;
					_tmp7_ = device;
					_tmp8_ = g_hash_table_contains (_tmp6_, _tmp7_);
					if (!_tmp8_) {
						GHashTable* _tmp9_ = NULL;
						const gchar* _tmp10_ = NULL;
						gchar* _tmp11_ = NULL;
						const gchar* _tmp12_ = NULL;
						_tmp9_ = seen;
						_tmp10_ = device;
						_tmp11_ = g_strdup (_tmp10_);
						g_hash_table_add (_tmp9_, _tmp11_);
						_tmp12_ = device;
						record_device (_tmp12_);
					}
					_tmp13_ = device;
					_tmp14_ = parent (_tmp13_);
					_g_free0 (device);
					device = _tmp14_;
				}
				_g_free0 (device);
			}
		}
	}
	_g_hash_table_unref0 (seen);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void split_devfile_arg (const gchar* arg, gchar** dev, gchar** devnum, gchar** fname) {
	gchar* _vala_dev = NULL;
	gchar* _vala_devnum = NULL;
	gchar* _vala_fname = NULL;
	gchar** parts = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	struct stat st = {0};
	const gchar* _tmp10_ = NULL;
	struct stat _tmp11_ = {0};
	gint _tmp12_ = 0;
	gboolean _tmp16_ = FALSE;
	struct stat _tmp17_ = {0};
	mode_t _tmp18_ = {0};
	gboolean _tmp19_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (arg != NULL);
	_tmp0_ = arg;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "=", 2);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	if (_tmp3__length1 != 2) {
		exit_error ("--ioctl argument must be devname=filename", NULL);
	}
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_vala_dev);
	_vala_dev = _tmp6_;
	_tmp7_ = parts;
	_tmp7__length1 = parts_length1;
	_tmp8_ = _tmp7_[1];
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (_vala_fname);
	_vala_fname = _tmp9_;
	_tmp10_ = _vala_dev;
	_tmp12_ = stat (_tmp10_, &_tmp11_);
	st = _tmp11_;
	if (_tmp12_ != 0) {
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		const gchar* _tmp15_ = NULL;
		_tmp13_ = _vala_dev;
		_tmp14_ = errno;
		_tmp15_ = g_strerror (_tmp14_);
		exit_error ("Cannot access device %s: %s", _tmp13_, _tmp15_, NULL);
	}
	_tmp17_ = st;
	_tmp18_ = _tmp17_.st_mode;
	_tmp19_ = S_ISCHR (_tmp18_);
	if (_tmp19_) {
		_tmp16_ = TRUE;
	} else {
		struct stat _tmp20_ = {0};
		mode_t _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
		_tmp20_ = st;
		_tmp21_ = _tmp20_.st_mode;
		_tmp22_ = S_ISBLK (_tmp21_);
		_tmp16_ = _tmp22_;
	}
	_tmp23_ = _tmp16_;
	if (_tmp23_) {
		struct stat _tmp24_ = {0};
		dev_t _tmp25_ = {0};
		guint _tmp26_ = 0U;
		struct stat _tmp27_ = {0};
		dev_t _tmp28_ = {0};
		guint _tmp29_ = 0U;
		gchar* _tmp30_ = NULL;
		_tmp24_ = st;
		_tmp25_ = _tmp24_.st_rdev;
		_tmp26_ = major (_tmp25_);
		_tmp27_ = st;
		_tmp28_ = _tmp27_.st_rdev;
		_tmp29_ = minor (_tmp28_);
		_tmp30_ = g_strdup_printf ("%u", (_tmp26_ << 8) + _tmp29_);
		_g_free0 (_vala_devnum);
		_vala_devnum = _tmp30_;
	} else {
		struct stat _tmp31_ = {0};
		mode_t _tmp32_ = {0};
		gboolean _tmp33_ = FALSE;
		_tmp31_ = st;
		_tmp32_ = _tmp31_.st_mode;
		_tmp33_ = S_ISSOCK (_tmp32_);
		if (_tmp33_) {
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp34_ = _vala_dev;
			_tmp35_ = g_strdup (_tmp34_);
			_g_free0 (_vala_devnum);
			_vala_devnum = _tmp35_;
		} else {
			gchar* contents = NULL;
			gchar** fields = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar** _tmp46_ = NULL;
			gchar** _tmp47_ = NULL;
			gchar** _tmp48_ = NULL;
			gint _tmp48__length1 = 0;
			gint fields_length1 = 0;
			gint _fields_size_ = 0;
			gchar** _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			gchar** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			const gchar* _tmp51_ = NULL;
			gint _tmp52_ = 0;
			gchar** _tmp53_ = NULL;
			gint _tmp53__length1 = 0;
			const gchar* _tmp54_ = NULL;
			gint _tmp55_ = 0;
			gchar* _tmp56_ = NULL;
			{
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				_tmp36_ = _vala_dev;
				_tmp37_ = g_build_filename (_tmp36_, "dev", NULL);
				_tmp38_ = _tmp37_;
				g_file_get_contents (_tmp38_, &_tmp39_, NULL, &_inner_error_);
				_g_free0 (contents);
				contents = _tmp39_;
				_g_free0 (_tmp38_);
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp40_ = NULL;
				GError* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp40_ = _vala_dev;
				_tmp41_ = e;
				_tmp42_ = _tmp41_->message;
				exit_error ("Cannot open %s/dev: %s", _tmp40_, _tmp42_, NULL);
				_g_error_free0 (e);
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_free0 (contents);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp43_ = contents;
			_tmp44_ = string_strip (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, ":", 0);
			_tmp48_ = _tmp47_;
			_tmp48__length1 = _vala_array_length (_tmp46_);
			_g_free0 (_tmp45_);
			fields = _tmp48_;
			fields_length1 = _tmp48__length1;
			_fields_size_ = fields_length1;
			_tmp49_ = fields;
			_tmp49__length1 = fields_length1;
			_vala_assert (_tmp49__length1 == 2, "fields.length == 2");
			_tmp50_ = fields;
			_tmp50__length1 = fields_length1;
			_tmp51_ = _tmp50_[0];
			_tmp52_ = atoi (_tmp51_);
			_tmp53_ = fields;
			_tmp53__length1 = fields_length1;
			_tmp54_ = _tmp53_[1];
			_tmp55_ = atoi (_tmp54_);
			_tmp56_ = g_strdup_printf ("%i", (_tmp52_ << 8) | _tmp55_);
			_g_free0 (_vala_devnum);
			_vala_devnum = _tmp56_;
			fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (contents);
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (dev) {
		*dev = _vala_dev;
	} else {
		_g_free0 (_vala_dev);
	}
	if (devnum) {
		*devnum = _vala_devnum;
	} else {
		_g_free0 (_vala_devnum);
	}
	if (fname) {
		*fname = _vala_fname;
	} else {
		_g_free0 (_vala_fname);
	}
}


void record_ioctl (const gchar* arg) {
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (arg != NULL);
	_tmp0_ = arg;
	split_devfile_arg (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (dev);
	dev = _tmp1_;
	_g_free0 (devnum);
	devnum = _tmp2_;
	_g_free0 (outfile);
	outfile = _tmp3_;
	g_setenv ("UMOCKDEV_IOCTL_RECORD_FILE", outfile, TRUE);
	g_setenv ("UMOCKDEV_IOCTL_RECORD_DEV", devnum, TRUE);
	g_setenv ("UMOCKDEV_IOCTL_RECORD_DEVICE_PATH", dev, TRUE);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
}


void record_script (const gchar* arg, const gchar* format) {
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* c = NULL;
	guint _tmp4_ = 0U;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	g_return_if_fail (arg != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = arg;
	split_devfile_arg (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (dev);
	dev = _tmp1_;
	_g_free0 (devnum);
	devnum = _tmp2_;
	_g_free0 (outfile);
	outfile = _tmp3_;
	_tmp4_ = record_script_counter;
	_tmp5_ = g_strdup_printf ("%u", _tmp4_);
	c = _tmp5_;
	_tmp6_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FILE_", c, NULL);
	_tmp7_ = _tmp6_;
	g_setenv (_tmp7_, outfile, TRUE);
	_g_free0 (_tmp7_);
	_tmp8_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEV_", c, NULL);
	_tmp9_ = _tmp8_;
	g_setenv (_tmp9_, devnum, TRUE);
	_g_free0 (_tmp9_);
	_tmp10_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEVICE_PATH_", c, NULL);
	_tmp11_ = _tmp10_;
	g_setenv (_tmp11_, dev, TRUE);
	_g_free0 (_tmp11_);
	_tmp12_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FORMAT_", c, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = format;
	g_setenv (_tmp13_, _tmp14_, TRUE);
	_g_free0 (_tmp13_);
	_tmp15_ = record_script_counter;
	record_script_counter = _tmp15_ + 1;
	_g_free0 (c);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_ = NULL;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gchar* preload = NULL;
	const gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	const gchar* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	gchar** _tmp65_ = NULL;
	gint _tmp65__length1 = 0;
	gchar** _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	gchar** _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	const gchar* _tmp72_ = NULL;
	gchar** _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gchar** _tmp74_ = NULL;
	gint _tmp74__length1 = 0;
	const gchar* _tmp75_ = NULL;
	gint _tmp76_ = 0;
	const gchar* _tmp77_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("");
	oc = _tmp0_;
	_tmp1_ = oc;
	g_option_context_set_summary (_tmp1_, "Record Linux devices and their ancestors from sysfs/udev, or record io" \
"ctls for a device.");
	_tmp2_ = oc;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	{
		GOptionContext* _tmp3_ = NULL;
		_tmp3_ = oc;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		exit_error ("Error: %s\nRun %s --help for how to use this program", _tmp5_, _tmp7_, NULL);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = opt_version;
	if (_tmp8_) {
		FILE* _tmp9_ = NULL;
		_tmp9_ = stdout;
		fprintf (_tmp9_, "%s\n", VERSION);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp11_ = opt_all;
	if (_tmp11_) {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		_tmp12_ = opt_devices;
		_tmp12__length1 = _vala_array_length (opt_devices);
		_tmp10_ = _tmp12__length1 > 0;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = _tmp10_;
	if (_tmp13_) {
		exit_error ("Specifying a device list together with --all is invalid.", NULL);
	}
	_tmp15_ = opt_all;
	if (!_tmp15_) {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp16_ = opt_devices;
		_tmp16__length1 = _vala_array_length (opt_devices);
		_tmp14_ = _tmp16__length1 == 0;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp17_ = _tmp14_;
	if (_tmp17_) {
		exit_error ("Need to specify at least one device or --all.", NULL);
	}
	_tmp21_ = opt_ioctl;
	if (_tmp21_ != NULL) {
		_tmp20_ = TRUE;
	} else {
		gchar** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		_tmp22_ = opt_script;
		_tmp22__length1 = _vala_array_length (opt_script);
		_tmp20_ = _tmp22__length1 > 0;
	}
	_tmp23_ = _tmp20_;
	if (_tmp23_) {
		_tmp19_ = TRUE;
	} else {
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		_tmp24_ = opt_evemu_events;
		_tmp24__length1 = _vala_array_length (opt_evemu_events);
		_tmp19_ = _tmp24__length1 > 0;
	}
	_tmp25_ = _tmp19_;
	if (_tmp25_) {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp27_ = opt_all;
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			_tmp28_ = opt_devices;
			_tmp28__length1 = _vala_array_length (opt_devices);
			_tmp26_ = _tmp28__length1 < 1;
		}
		_tmp29_ = _tmp26_;
		_tmp18_ = _tmp29_;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp30_ = _tmp18_;
	if (_tmp30_) {
		exit_error ("For recording ioctls or scripts you have to specify a command to run", NULL);
	}
	_tmp33_ = opt_ioctl;
	if (_tmp33_ == NULL) {
		gchar** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		_tmp34_ = opt_script;
		_tmp34__length1 = _vala_array_length (opt_script);
		_tmp32_ = _tmp34__length1 == 0;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp35_ = _tmp32_;
	if (_tmp35_) {
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		_tmp36_ = opt_evemu_events;
		_tmp36__length1 = _vala_array_length (opt_evemu_events);
		_tmp31_ = _tmp36__length1 == 0;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp37_ = _tmp31_;
	if (_tmp37_) {
		gboolean _tmp38_ = FALSE;
		gchar** _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		_tmp38_ = opt_all;
		if (_tmp38_) {
			gchar** _tmp39_ = NULL;
			gchar** _tmp40_ = NULL;
			_tmp40_ = _tmp39_ = all_devices ();
			opt_devices = (_vala_array_free (opt_devices, _vala_array_length (opt_devices), (GDestroyNotify) g_free), NULL);
			opt_devices = _tmp40_;
		} else {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp41_ = FALSE;
					_tmp41_ = TRUE;
					while (TRUE) {
						gboolean _tmp42_ = FALSE;
						gint _tmp44_ = 0;
						gchar** _tmp45_ = NULL;
						gint _tmp45__length1 = 0;
						gchar** _tmp46_ = NULL;
						gint _tmp46__length1 = 0;
						gint _tmp47_ = 0;
						gchar** _tmp48_ = NULL;
						gint _tmp48__length1 = 0;
						gint _tmp49_ = 0;
						const gchar* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						gchar* _tmp52_ = NULL;
						_tmp42_ = _tmp41_;
						if (!_tmp42_) {
							gint _tmp43_ = 0;
							_tmp43_ = i;
							i = _tmp43_ + 1;
						}
						_tmp41_ = FALSE;
						_tmp44_ = i;
						_tmp45_ = opt_devices;
						_tmp45__length1 = _vala_array_length (opt_devices);
						if (!(_tmp44_ < _tmp45__length1)) {
							break;
						}
						_tmp46_ = opt_devices;
						_tmp46__length1 = _vala_array_length (opt_devices);
						_tmp47_ = i;
						_tmp48_ = opt_devices;
						_tmp48__length1 = _vala_array_length (opt_devices);
						_tmp49_ = i;
						_tmp50_ = _tmp48_[_tmp49_];
						_tmp51_ = resolve (_tmp50_);
						_g_free0 (_tmp46_[_tmp47_]);
						_tmp46_[_tmp47_] = _tmp51_;
						_tmp52_ = _tmp46_[_tmp47_];
					}
				}
			}
		}
		_tmp53_ = opt_devices;
		_tmp53__length1 = _vala_array_length (opt_devices);
		dump_devices (_tmp53_, _tmp53__length1);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp54_ = g_getenv ("LD_PRELOAD");
	_tmp55_ = g_strdup (_tmp54_);
	preload = _tmp55_;
	_tmp56_ = preload;
	if (_tmp56_ == NULL) {
		gchar* _tmp57_ = NULL;
		_tmp57_ = g_strdup ("");
		_g_free0 (preload);
		preload = _tmp57_;
	} else {
		const gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		_tmp58_ = preload;
		_tmp59_ = g_strconcat (_tmp58_, ":", NULL);
		_g_free0 (preload);
		preload = _tmp59_;
	}
	_tmp60_ = preload;
	_tmp61_ = g_strconcat (_tmp60_, "libumockdev-preload.so.0", NULL);
	_tmp62_ = _tmp61_;
	g_setenv ("LD_PRELOAD", _tmp62_, TRUE);
	_g_free0 (_tmp62_);
	_tmp63_ = opt_ioctl;
	if (_tmp63_ != NULL) {
		const gchar* _tmp64_ = NULL;
		_tmp64_ = opt_ioctl;
		record_ioctl (_tmp64_);
	}
	_tmp65_ = opt_script;
	_tmp65__length1 = _vala_array_length (opt_script);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp65_;
		s_collection_length1 = _tmp65__length1;
		for (s_it = 0; s_it < _tmp65__length1; s_it = s_it + 1) {
			gchar* _tmp66_ = NULL;
			gchar* s = NULL;
			_tmp66_ = g_strdup (s_collection[s_it]);
			s = _tmp66_;
			{
				const gchar* _tmp67_ = NULL;
				_tmp67_ = s;
				record_script (_tmp67_, "default");
				_g_free0 (s);
			}
		}
	}
	_tmp68_ = opt_evemu_events;
	_tmp68__length1 = _vala_array_length (opt_evemu_events);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp68_;
		s_collection_length1 = _tmp68__length1;
		for (s_it = 0; s_it < _tmp68__length1; s_it = s_it + 1) {
			gchar* _tmp69_ = NULL;
			gchar* s = NULL;
			_tmp69_ = g_strdup (s_collection[s_it]);
			s = _tmp69_;
			{
				const gchar* _tmp70_ = NULL;
				_tmp70_ = s;
				record_script (_tmp70_, "evemu");
				_g_free0 (s);
			}
		}
	}
	_tmp71_ = opt_devices;
	_tmp71__length1 = _vala_array_length (opt_devices);
	_tmp72_ = _tmp71_[0];
	_tmp73_ = opt_devices;
	_tmp73__length1 = _vala_array_length (opt_devices);
	execvp (_tmp72_, _tmp73_);
	_tmp74_ = opt_devices;
	_tmp74__length1 = _vala_array_length (opt_devices);
	_tmp75_ = _tmp74_[0];
	_tmp76_ = errno;
	_tmp77_ = g_strerror (_tmp76_);
	exit_error ("Cannot run program %s: %s", _tmp75_, _tmp77_, NULL);
	result = 0;
	_g_free0 (preload);
	_g_option_context_free0 (oc);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



