#pragma once
#ifndef MESSMER_FSPP_TEST_FUSE_OPENFILE_TESTUTILS_FUSEOPENTEST_H_
#define MESSMER_FSPP_TEST_FUSE_OPENFILE_TESTUTILS_FUSEOPENTEST_H_

#include "../../../testutils/FuseTest.h"
#include "../../../testutils/OpenFileHandle.h"

class FuseOpenTest: public FuseTest {
public:
  const char *FILENAME = "/myfile";

  void OpenFile(const char *FILENAME, int flags);
  int OpenFileReturnError(const char *FILENAME, int flags);
private:
  cpputils::unique_ref<OpenFileHandle> OpenFileAllowError(const TempTestFS *fs, const char *FILENAME, int flags);
};

//NOLINTNEXTLINE(cppcoreguidelines-avoid-const-or-ref-data-members)
MATCHER_P(OpenFlagsEq, expectedFlags, "") {
  return expectedFlags == (O_ACCMODE & arg);
}

#endif
