;# mysql.tcl -- Gerwin
;#
;# Mysql SQL generation routine
;#
;# Copyright (C) Jose E. Marchesi
;#
;# Time-stamp: "2003-11-11 15:08:57 jemarch"


;# This program is free software; you can redistribute it and/or
;# modify it under the terms of the GNU General Public License as
;# published by the Free Software Foundation; either version 2 of
;# the License, or (at your option) any later version.

;# This program is distributed in the hope that it will be useful,
;# but WITHOUT ANY WARRANTY; without even the implied warranty of
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;# GNU General Public License for more details.

;# You should have received a copy of the GNU General Public
;# License along with this program; if not, write to the Free
;# Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
;# MA 02111-1307 USA

;# Register the format
lappend gerwin_output_formats mysql

;# Set the color scheme for this output format
set output_colors(mysql) {

    {CREATE blue}
    {TABLE blue}
    {ALTER blue}
    {ADD blue}
    {KEY blue}
    {FOREIGN blue}
    {REFERENCES blue}
    {PRIMARY blue}
    {{NOT NULL} darkgreen}
    {{\(} blue}
    {{\)} blue}
    {{,} orange}
    {{;} orange}
    {{--.*$} red}
    {{\".*?\"} orange}

}


;# Set the type scheme for this output format

set gerwin_output_format_types(mysql) {

    {{DYNAMIC_STRING(%d)}  {VARCHAR(%d)}}
    {{FIXED_STRING(%d)} {CHAR(%d)}}
    {INTEGER INTEGER}
    {FLOAT FLOAT}
    {NATURAL INTEGER}
    {CHARACTER {CHAR(1)}}
}


;# The generation routine

proc gen_TD_to_format_mysql {} {

    global gerwin_cproject_name
    global gerwin_cproject_author
    global gerwin_cproject_file
    global gerwin_output_active_format
    global gerwin_tables
    global gerwin_table

    ;# Generate some comments
    omit_line "-- Automatically generated by Gerwin"
    omit_line "--"
    omit_line "-- Project $gerwin_cproject_name"
    omit_line "-- From file: $gerwin_cproject_file"
    omit_line "-- By: $gerwin_cproject_author"
    omit_line "--"
    omit_line "-- Using output format: $gerwin_output_active_format"

    ;# Ok, generate the SQL

    ;# Iterate on the tables
    foreach t $gerwin_tables {

	set table_name $t

	;# Some blank space before each table
	omit_line ""
	omit_line ""
	omit_line ""

	omit_line "CREATE TABLE $t ("
	
	;# Iterate on the table attributes
	set nattributes [gob_table_get_nattributes $t]
	set i 0
	foreach a [gob_table_get_attributes $t] {
	    incr i

	    ;# See if the name contain any #
	    ;# If it is the case, then this is a repeated foreign key
	    ;# and the name in gob_table_get_foreign_keys is without the #!

	    if {[regexp \% $a]} then {

		;# Convert the % to an underscore
		set nname [string map "% _" $a]

	    } else {
		set nname $a
	    }

	    ;# Write the attribute name and the attribute domain
	    append line  "      $nname     [gob_table_get_attribute_domain $t $a]"

	    ;# Write NULL or NOT NULL
	    if {! [gob_table_get_attribute_null $t $a]} then {

		;# The attribute  is not anullable
		append line " NOT NULL"
	    }


	    if {$i != $nattributes} then {
		;# End of the column line
		append line ","
	    }
	    
	    ;# Ok, omit the line
	    omit_line $line
	    set line {}
	}

	;# End of the table
	omit_line ");"

	omit_line ""
	omit_line ""
	
	;# Emit the primary key for $t
	set pkey "ALTER TABLE $t ADD PRIMARY KEY ("
	set nattributes [llength [gob_table_get_key $t]]
	set i 0
	foreach a [gob_table_get_key $t] {

	    incr i

	    ;# See if the name contain any #
	    ;# If it is the case, then this is a repeated foreign key
	    ;# and the name in gob_table_get_foreign_keys is without the #!

	    if {[regexp \% $a]} then {

		;# Convert the # to an underscore
		set nname [string map "% _" $a]

	    } else {
		set nname $a
	    }


	    if {$i == $nattributes} then {
		append pkey "${nname}\);"
	    } else {
		append pkey "${nname},"
	    }
	}


	omit_line $pkey

    }

        omit_line ""

    ;# Generate foreign keys on the tables
    foreach t $gerwin_tables {

	omit_line ""
	omit_line ""


	;# Emit foreign keys for $t
	set rtables {}
	foreach fkd [gob_table_get_foreign_keys $t] {

	    set rtable [lindex $fkd 1]

	    if {[lsearch $rtables $rtable] == -1} then {
		lappend rtables $rtable
	    }
	}
	;# Ok, now we have all the rtables that $t references into $rtables

	foreach rtable $rtables {


	    set lattrs {}
	    set rattrs {}

	    set fkline "ALTER TABLE $t ADD FOREIGN KEY"


	    ;# Emit the foreign keys for this rtable
	    foreach a [gob_table_get_attributes $t] {




		;# Get the remote name for the attribute
		regsub {.+%([^%]+)} $a "\\1" nname
		set nname [string map "% _" $nname]


		if {[gob_table_is_foreign_key $t $a]} then {



		    ;# Get the foreign key for the attribute
		    set art [gob_table_get_foreign_key_rtable $t $a]

		    if {$art == $rtable} then {

			set a [string map "% _" $a]
			;# Begin foreign_key_attribute
			lappend lattrs $a
			lappend rattrs $nname
		    }
		}
	    }

	    append fkline " \("
	    set i 0
	    foreach la $lattrs {
		incr i
		if {$i == [llength $lattrs]} then {
		    append fkline $la
		} else {
		    append fkline "$la,"
		}

	    }

	    append fkline "\) REFERENCES $rtable \("

	    set i 0
	    foreach ra $rattrs {
		incr i
		if {$i == [llength $rattrs]} then {
		    append fkline $ra
		} else {
		    append fkline "$ra,"
		}
		
	    }

	    append fkline "\);"

	    ;# Ok, emit the line
	    omit_line $fkline
	}

    }


}
	
	