//
// Code dialogs for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2023 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     https://www.fltk.org/COPYING.php
//
// Please see the following page on how to report bugs and issues:
//
//     https://www.fltk.org/bugs.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0402

#include "function_panel.h"
#include "fluid.h"
#include "custom_widgets.h"
#include "pixmaps.h"
#include "factory.h"
#include "Fl_Type.h"
#include "widget_browser.h"
#include "undo.h"

/**
 Allow widget navigation on text fields with Tab.
*/
static int use_tab_navigation(int, Fl_Text_Editor*) {
  return 0;
}

Fl_Double_Window *function_panel=(Fl_Double_Window *)0;

Fl_Choice *f_public_member_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_f_public_member_choice[] = {
 {"private", 0,  0, (void*)(0), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"public", 0,  0, (void*)(1), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"protected", 0,  0, (void*)(2), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *f_public_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_f_public_choice[] = {
 {"static", 0,  0, (void*)(0), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"global", 0,  0, (void*)(1), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"local", 0,  0, (void*)(2), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Light_Button *f_c_button=(Fl_Light_Button *)0;

Fl_Input *f_name_input=(Fl_Input *)0;

Fl_Input *f_return_type_input=(Fl_Input *)0;

Fl_Text_Editor *f_comment_input=(Fl_Text_Editor *)0;

Fl_Return_Button *f_panel_ok=(Fl_Return_Button *)0;

Fl_Button *f_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_function_panel() {
  { function_panel = new Fl_Double_Window(343, 232, "Function/Method Properties");
    function_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { Fl_Group* o = new Fl_Group(10, 10, 270, 20);
      { f_public_member_choice = new Fl_Choice(10, 10, 75, 20);
        f_public_member_choice->tooltip("Change member access attribute.");
        f_public_member_choice->down_box(FL_BORDER_BOX);
        f_public_member_choice->labelsize(11);
        f_public_member_choice->textsize(11);
        f_public_member_choice->when(FL_WHEN_CHANGED);
        f_public_member_choice->menu(menu_f_public_member_choice);
      } // Fl_Choice* f_public_member_choice
      { f_public_choice = new Fl_Choice(10, 10, 75, 20);
        f_public_choice->tooltip("Change widget accessibility.");
        f_public_choice->down_box(FL_BORDER_BOX);
        f_public_choice->labelsize(11);
        f_public_choice->textsize(11);
        f_public_choice->when(FL_WHEN_CHANGED);
        f_public_choice->menu(menu_f_public_choice);
      } // Fl_Choice* f_public_choice
      { f_c_button = new Fl_Light_Button(95, 10, 120, 20, "C declaration");
        f_c_button->tooltip("Declare with a C interface instead of C++.");
        f_c_button->labelsize(11);
      } // Fl_Light_Button* f_c_button
      { Fl_Box* o = new Fl_Box(235, 10, 45, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { f_name_input = new Fl_Input(10, 50, 320, 20, "Name(args): (blank for main())");
      f_name_input->tooltip("The name of the function or method.");
      f_name_input->labelfont(1);
      f_name_input->labelsize(11);
      f_name_input->textfont(4);
      f_name_input->textsize(11);
      f_name_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      f_name_input->when(FL_WHEN_NEVER);
    } // Fl_Input* f_name_input
    { f_return_type_input = new Fl_Input(10, 90, 320, 20, "Return Type: (blank to return outermost widget)");
      f_return_type_input->tooltip("The return type of the function or method.");
      f_return_type_input->labelfont(1);
      f_return_type_input->labelsize(11);
      f_return_type_input->textfont(4);
      f_return_type_input->textsize(11);
      f_return_type_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      f_return_type_input->when(FL_WHEN_NEVER);
    } // Fl_Input* f_return_type_input
    { f_comment_input = new Fl_Text_Editor(10, 125, 320, 65, "Comment:");
      f_comment_input->tooltip("Function comment in Doxygen format");
      f_comment_input->box(FL_DOWN_BOX);
      f_comment_input->labelfont(1);
      f_comment_input->labelsize(11);
      f_comment_input->textfont(4);
      f_comment_input->textsize(11);
      f_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      Fl_Group::current()->resizable(f_comment_input);
      f_comment_input->buffer(new Fl_Text_Buffer());
      f_comment_input->add_key_binding(FL_Tab, 0, use_tab_navigation);
    } // Fl_Text_Editor* f_comment_input
    { Fl_Group* o = new Fl_Group(10, 200, 320, 20);
      { f_panel_ok = new Fl_Return_Button(220, 200, 50, 20, "OK");
        f_panel_ok->tooltip("Apply the changes.");
        f_panel_ok->labelsize(11);
        f_panel_ok->window()->hotspot(f_panel_ok);
      } // Fl_Return_Button* f_panel_ok
      { f_panel_cancel = new Fl_Button(280, 200, 50, 20, "Cancel");
        f_panel_cancel->tooltip("Cancel the changes.");
        f_panel_cancel->labelsize(11);
      } // Fl_Button* f_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 200, 205, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    function_panel->set_modal();
    function_panel->end();
  } // Fl_Double_Window* function_panel
  return function_panel;
}

Fl_Double_Window *code_panel=(Fl_Double_Window *)0;

static void cb_code_panel(Fl_Double_Window*, void*) {
  if (Fl::event()==FL_SHORTCUT && Fl::event_key()==FL_Escape)
    return; // ignore Escape
  code_panel->hide(); // otherwise hide..;
}

CodeEditor *code_input=(CodeEditor *)0;

Fl_Return_Button *code_panel_ok=(Fl_Return_Button *)0;

Fl_Button *code_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_code_panel() {
  { Fl_Double_Window* o = code_panel = new Fl_Double_Window(540, 180, "Code Properties");
    code_panel->labelsize(11);
    code_panel->callback((Fl_Callback*)cb_code_panel);
    { CodeEditor* o = code_input = new CodeEditor(10, 10, 520, 130);
      code_input->box(FL_DOWN_BOX);
      code_input->color(FL_BACKGROUND2_COLOR);
      code_input->selection_color(FL_SELECTION_COLOR);
      code_input->labeltype(FL_NORMAL_LABEL);
      code_input->labelfont(0);
      code_input->labelsize(11);
      code_input->labelcolor(FL_FOREGROUND_COLOR);
      code_input->textfont(4);
      code_input->textsize(11);
      code_input->align(Fl_Align(FL_ALIGN_TOP));
      code_input->when(FL_WHEN_RELEASE);
      Fl_Group::current()->resizable(code_input);
      o->when(FL_WHEN_ENTER_KEY_CHANGED|FL_WHEN_RELEASE);
    } // CodeEditor* code_input
    { Fl_Group* o = new Fl_Group(10, 150, 520, 20);
      o->labelsize(11);
      { code_panel_ok = new Fl_Return_Button(400, 150, 60, 20, "OK");
        code_panel_ok->labelsize(11);
        code_panel_ok->window()->hotspot(code_panel_ok);
      } // Fl_Return_Button* code_panel_ok
      { code_panel_cancel = new Fl_Button(470, 150, 60, 20, "Cancel");
        code_panel_cancel->labelsize(11);
      } // Fl_Button* code_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 150, 380, 20);
        o->labelsize(11);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    code_panel->set_modal();
    o->size_range(200, 150);
    code_panel->end();
  } // Fl_Double_Window* code_panel
  // Enable line numbers
  code_input->linenumber_width(60);
  code_input->linenumber_size(code_input->Fl_Text_Display::textsize());
  return code_panel;
}

Fl_Double_Window *codeblock_panel=(Fl_Double_Window *)0;

Fl_Input *code_before_input=(Fl_Input *)0;

Fl_Input *code_after_input=(Fl_Input *)0;

Fl_Return_Button *codeblock_panel_ok=(Fl_Return_Button *)0;

Fl_Button *codeblock_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_codeblock_panel() {
  { Fl_Double_Window* o = codeblock_panel = new Fl_Double_Window(300, 115, "Code Block Properties");
    codeblock_panel->labelsize(11);
    { code_before_input = new Fl_Input(10, 15, 280, 20, "Conditional code block");
      code_before_input->tooltip("#ifdef or similar conditional code block.");
      code_before_input->labelsize(11);
      code_before_input->textfont(4);
      code_before_input->textsize(11);
      code_before_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      code_before_input->when(FL_WHEN_NEVER);
    } // Fl_Input* code_before_input
    { code_after_input = new Fl_Input(10, 55, 280, 20, "\"{...child code...}\" is inserted here");
      code_after_input->tooltip("#endif or similar conditional code block.");
      code_after_input->labelsize(11);
      code_after_input->textfont(4);
      code_after_input->textsize(11);
      code_after_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      code_after_input->when(FL_WHEN_NEVER);
      Fl_Group::current()->resizable(code_after_input);
    } // Fl_Input* code_after_input
    { Fl_Group* o = new Fl_Group(10, 85, 280, 20);
      { codeblock_panel_ok = new Fl_Return_Button(160, 85, 60, 20, "OK");
        codeblock_panel_ok->labelsize(11);
        codeblock_panel_ok->window()->hotspot(codeblock_panel_ok);
      } // Fl_Return_Button* codeblock_panel_ok
      { codeblock_panel_cancel = new Fl_Button(230, 85, 60, 20, "Cancel");
        codeblock_panel_cancel->shortcut(0xff1b);
        codeblock_panel_cancel->labelsize(11);
      } // Fl_Button* codeblock_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 85, 140, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    codeblock_panel->set_modal();
    o->size_range(o->w(), o->h(), Fl::w(), o->h());
    codeblock_panel->end();
  } // Fl_Double_Window* codeblock_panel
  return codeblock_panel;
}

Fl_Double_Window *declblock_panel=(Fl_Double_Window *)0;

Fl_Input *declblock_before_input=(Fl_Input *)0;

Fl_Input *declblock_after_input=(Fl_Input *)0;

Fl_Check_Button *declblock_code_source=(Fl_Check_Button *)0;

Fl_Check_Button *declblock_static_source=(Fl_Check_Button *)0;

Fl_Check_Button *declblock_code_header=(Fl_Check_Button *)0;

Fl_Check_Button *declblock_static_header=(Fl_Check_Button *)0;

Fl_Text_Editor *declblock_comment_input=(Fl_Text_Editor *)0;

Fl_Return_Button *declblock_panel_ok=(Fl_Return_Button *)0;

Fl_Button *declblock_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_declblock_panel() {
  { Fl_Double_Window* o = declblock_panel = new Fl_Double_Window(300, 355, "Declaration Block Properties");
    declblock_panel->labelsize(11);
    declblock_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { declblock_before_input = new Fl_Input(10, 23, 280, 20, "Start Code:");
      declblock_before_input->tooltip("#ifdef or similar conditional declaration block.");
      declblock_before_input->labelfont(1);
      declblock_before_input->labelsize(11);
      declblock_before_input->textfont(4);
      declblock_before_input->textsize(11);
      declblock_before_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      declblock_before_input->when(FL_WHEN_NEVER);
    } // Fl_Input* declblock_before_input
    { Fl_Box* o = new Fl_Box(10, 48, 280, 20, "\"\\n...child code...\\n\" is inserted here");
      o->labelsize(11);
    } // Fl_Box* o
    { declblock_after_input = new Fl_Input(10, 80, 280, 20, "End Code:");
      declblock_after_input->tooltip("#endif or similar declaration code block.");
      declblock_after_input->labelfont(1);
      declblock_after_input->labelsize(11);
      declblock_after_input->textfont(4);
      declblock_after_input->textsize(11);
      declblock_after_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      declblock_after_input->when(FL_WHEN_NEVER);
    } // Fl_Input* declblock_after_input
    { Fl_Group* o = new Fl_Group(10, 105, 280, 120);
      { Fl_Box* o = new Fl_Box(10, 105, 270, 20, "Enclose code generated by children in source file:");
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { declblock_code_source = new Fl_Check_Button(20, 125, 260, 20, "implementations");
        declblock_code_source->down_box(FL_DOWN_BOX);
        declblock_code_source->labelsize(11);
      } // Fl_Check_Button* declblock_code_source
      { declblock_static_source = new Fl_Check_Button(20, 145, 260, 20, "static initializations and callbacks");
        declblock_static_source->down_box(FL_DOWN_BOX);
        declblock_static_source->labelsize(11);
      } // Fl_Check_Button* declblock_static_source
      { Fl_Box* o = new Fl_Box(10, 165, 270, 20, "Enclose code in header file:");
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { declblock_code_header = new Fl_Check_Button(20, 185, 260, 20, "forward declarations");
        declblock_code_header->down_box(FL_DOWN_BOX);
        declblock_code_header->labelsize(11);
      } // Fl_Check_Button* declblock_code_header
      { declblock_static_header = new Fl_Check_Button(20, 205, 260, 20, "preprecessor and callback declarations");
        declblock_static_header->down_box(FL_DOWN_BOX);
        declblock_static_header->labelsize(11);
      } // Fl_Check_Button* declblock_static_header
      { Fl_Box* o = new Fl_Box(280, 105, 10, 120);
        o->labelsize(11);
        o->hide();
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { declblock_comment_input = new Fl_Text_Editor(10, 242, 280, 65, "Comment:");
      declblock_comment_input->tooltip("Declaration comment in Doxygen format");
      declblock_comment_input->box(FL_DOWN_BOX);
      declblock_comment_input->labelfont(1);
      declblock_comment_input->labelsize(11);
      declblock_comment_input->textfont(4);
      declblock_comment_input->textsize(11);
      declblock_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      Fl_Group::current()->resizable(declblock_comment_input);
      declblock_comment_input->buffer(new Fl_Text_Buffer());
      declblock_comment_input->add_key_binding(FL_Tab, 0, use_tab_navigation);
    } // Fl_Text_Editor* declblock_comment_input
    { Fl_Group* o = new Fl_Group(10, 321, 280, 20);
      { declblock_panel_ok = new Fl_Return_Button(160, 321, 60, 20, "OK");
        declblock_panel_ok->labelsize(11);
        declblock_panel_ok->window()->hotspot(declblock_panel_ok);
      } // Fl_Return_Button* declblock_panel_ok
      { declblock_panel_cancel = new Fl_Button(230, 321, 60, 20, "Cancel");
        declblock_panel_cancel->shortcut(0xff1b);
        declblock_panel_cancel->labelsize(11);
      } // Fl_Button* declblock_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 321, 140, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    declblock_panel->set_modal();
    declblock_panel->size_range(300, 355);
    o->size_range(o->w(), o->h(), Fl::w(), o->h());
    declblock_panel->end();
  } // Fl_Double_Window* declblock_panel
  return declblock_panel;
}

Fl_Double_Window *decl_panel=(Fl_Double_Window *)0;

Fl_Choice *decl_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_decl_choice[] = {
 {"in source file only", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"in header file only", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"\"static\" in source file", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"in source and \"extern\" in header", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *decl_class_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_decl_class_choice[] = {
 {"private", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"public", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"protected", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

CodeEditor *decl_input=(CodeEditor *)0;

Fl_Text_Editor *decl_comment_input=(Fl_Text_Editor *)0;

Fl_Return_Button *decl_panel_ok=(Fl_Return_Button *)0;

Fl_Button *decl_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_decl_panel() {
  { decl_panel = new Fl_Double_Window(343, 262, "Declaration Properties");
    decl_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { Fl_Group* o = new Fl_Group(10, 10, 270, 20);
      { Fl_Box* o = new Fl_Box(200, 10, 80, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      { decl_choice = new Fl_Choice(10, 10, 185, 20);
        decl_choice->down_box(FL_BORDER_BOX);
        decl_choice->labelsize(11);
        decl_choice->textsize(11);
        decl_choice->menu(menu_decl_choice);
      } // Fl_Choice* decl_choice
      { decl_class_choice = new Fl_Choice(10, 10, 75, 20);
        decl_class_choice->down_box(FL_BORDER_BOX);
        decl_class_choice->labelsize(11);
        decl_class_choice->textsize(11);
        decl_class_choice->menu(menu_decl_class_choice);
      } // Fl_Choice* decl_class_choice
      o->end();
    } // Fl_Group* o
    { Fl_Tile* o = new Fl_Tile(10, 40, 320, 180);
      { Fl_Group* o = new Fl_Group(10, 40, 320, 100);
        o->box(FL_FLAT_BOX);
        { decl_input = new CodeEditor(10, 40, 320, 45, "This can be any declaration, like \"int x;\", an external symbol like \"exter"
"n int foo();\", a #directive like \"#include <foo.h>\", a comment like \"//foo"
"\" or \"/*foo*/\", or typedef like \"typedef char byte;\" or \"using std::list"
";\".");
          decl_input->box(FL_DOWN_FRAME);
          decl_input->color(FL_BACKGROUND2_COLOR);
          decl_input->selection_color(FL_SELECTION_COLOR);
          decl_input->labeltype(FL_NORMAL_LABEL);
          decl_input->labelfont(0);
          decl_input->labelsize(11);
          decl_input->labelcolor(FL_FOREGROUND_COLOR);
          decl_input->align(Fl_Align(134));
          decl_input->when(FL_WHEN_RELEASE);
          Fl_Group::current()->resizable(decl_input);
        } // CodeEditor* decl_input
        { Fl_Box* o = new Fl_Box(20, 139, 300, 1);
          o->box(FL_BORDER_FRAME);
          o->color((Fl_Color)43);
        } // Fl_Box* o
        o->end();
        Fl_Group::current()->resizable(o);
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(10, 140, 320, 80);
        o->box(FL_FLAT_BOX);
        { decl_comment_input = new Fl_Text_Editor(10, 155, 320, 64, "Comment:");
          decl_comment_input->tooltip("Declaration comment in Doxygen format");
          decl_comment_input->box(FL_DOWN_BOX);
          decl_comment_input->labelfont(1);
          decl_comment_input->labelsize(11);
          decl_comment_input->textfont(4);
          decl_comment_input->textsize(11);
          decl_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          Fl_Group::current()->resizable(decl_comment_input);
          decl_comment_input->buffer(new Fl_Text_Buffer());
          decl_comment_input->add_key_binding(FL_Tab, 0, use_tab_navigation);
        } // Fl_Text_Editor* decl_comment_input
        o->end();
      } // Fl_Group* o
      o->size_range(0, 320, 100);
      o->size_range(1, 320, 60);
      o->end();
      Fl_Group::current()->resizable(o);
    } // Fl_Tile* o
    { Fl_Group* o = new Fl_Group(10, 230, 320, 20);
      { decl_panel_ok = new Fl_Return_Button(200, 230, 60, 20, "OK");
        decl_panel_ok->labelsize(11);
        decl_panel_ok->window()->hotspot(decl_panel_ok);
      } // Fl_Return_Button* decl_panel_ok
      { decl_panel_cancel = new Fl_Button(270, 230, 60, 20, "Cancel");
        decl_panel_cancel->shortcut(0xff1b);
        decl_panel_cancel->labelsize(11);
      } // Fl_Button* decl_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 230, 185, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    decl_panel->size_range(343, 262);
    decl_panel->end();
  } // Fl_Double_Window* decl_panel
  return decl_panel;
}

Fl_Double_Window *data_panel=(Fl_Double_Window *)0;

Fl_Choice *data_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_data_choice[] = {
 {"in source file only", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"in header file only", 0,  0, 0, 16, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"\"static\" in source file", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"in source and \"extern\" in header", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *data_class_choice=(Fl_Choice *)0;

Fl_Menu_Item menu_data_class_choice[] = {
 {"private", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"public", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"protected", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *data_mode=(Fl_Choice *)0;

Fl_Menu_Item menu_data_mode[] = {
 {"binary mode", 0,  0, (void*)(0), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"text mode", 0,  0, (void*)(1), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"compressed binary", 0,  0, (void*)(2), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Input *data_input=(Fl_Input *)0;

Fl_Input *data_filename=(Fl_Input *)0;

Fl_Button *data_filebrowser=(Fl_Button *)0;

Fl_Text_Editor *data_comment_input=(Fl_Text_Editor *)0;

Fl_Return_Button *data_panel_ok=(Fl_Return_Button *)0;

Fl_Button *data_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_data_panel() {
  { data_panel = new Fl_Double_Window(343, 264, "Inline Data Properties");
    data_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { Fl_Group* o = new Fl_Group(10, 10, 320, 48);
      { Fl_Box* o = new Fl_Box(288, 10, 42, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      { data_choice = new Fl_Choice(10, 10, 185, 20);
        data_choice->down_box(FL_BORDER_BOX);
        data_choice->labelsize(11);
        data_choice->textsize(11);
        data_choice->menu(menu_data_choice);
      } // Fl_Choice* data_choice
      { data_class_choice = new Fl_Choice(10, 10, 75, 20);
        data_class_choice->down_box(FL_BORDER_BOX);
        data_class_choice->labelsize(11);
        data_class_choice->textsize(11);
        data_class_choice->menu(menu_data_class_choice);
      } // Fl_Choice* data_class_choice
      { data_mode = new Fl_Choice(10, 38, 185, 20);
        data_mode->tooltip("text mode generates a \"const char*\" and a trailing NUL, compressed mode use"
"s zlib to generate a binary block");
        data_mode->down_box(FL_BORDER_BOX);
        data_mode->labelsize(11);
        data_mode->textsize(11);
        data_mode->menu(menu_data_mode);
      } // Fl_Choice* data_mode
      o->end();
    } // Fl_Group* o
    { data_input = new Fl_Input(10, 78, 320, 20, "Variable Name:");
      data_input->tooltip("Inline Data variables are declared \"const unsigned char []\" in binary mode "
"and \"const char*\" in text mode.");
      data_input->labelfont(1);
      data_input->labelsize(11);
      data_input->textfont(4);
      data_input->textsize(11);
      data_input->align(Fl_Align(133));
      data_input->when(FL_WHEN_NEVER);
    } // Fl_Input* data_input
    { data_filename = new Fl_Input(10, 116, 280, 20, "Filename:");
      data_filename->tooltip("Name and path of file that will be inlined.");
      data_filename->labelfont(1);
      data_filename->labelsize(11);
      data_filename->textfont(4);
      data_filename->textsize(11);
      data_filename->align(Fl_Align(133));
      data_filename->when(FL_WHEN_NEVER);
    } // Fl_Input* data_filename
    { data_filebrowser = new Fl_Button(290, 116, 40, 20, "@fileopen");
      data_filebrowser->labelcolor((Fl_Color)134);
    } // Fl_Button* data_filebrowser
    { data_comment_input = new Fl_Text_Editor(10, 156, 320, 65, "Comment:");
      data_comment_input->tooltip("Declaration comment in Doxygen format");
      data_comment_input->box(FL_DOWN_BOX);
      data_comment_input->labelfont(1);
      data_comment_input->labelsize(11);
      data_comment_input->textfont(4);
      data_comment_input->textsize(11);
      data_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      Fl_Group::current()->resizable(data_comment_input);
      data_comment_input->buffer(new Fl_Text_Buffer());
      data_comment_input->add_key_binding(FL_Tab, 0, use_tab_navigation);
    } // Fl_Text_Editor* data_comment_input
    { Fl_Group* o = new Fl_Group(10, 231, 320, 20);
      { data_panel_ok = new Fl_Return_Button(200, 231, 60, 20, "OK");
        data_panel_ok->labelsize(11);
        data_panel_ok->window()->hotspot(data_panel_ok);
      } // Fl_Return_Button* data_panel_ok
      { data_panel_cancel = new Fl_Button(270, 231, 60, 20, "Cancel");
        data_panel_cancel->shortcut(0xff1b);
        data_panel_cancel->labelsize(11);
      } // Fl_Button* data_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 231, 185, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    data_panel->size_range(343, 237);
    data_panel->end();
  } // Fl_Double_Window* data_panel
  return data_panel;
}

Fl_Double_Window *class_panel=(Fl_Double_Window *)0;

Fl_Light_Button *c_public_button=(Fl_Light_Button *)0;

Fl_Input *c_name_input=(Fl_Input *)0;

Fl_Input *c_subclass_input=(Fl_Input *)0;

Fl_Text_Editor *c_comment_input=(Fl_Text_Editor *)0;

Fl_Return_Button *c_panel_ok=(Fl_Return_Button *)0;

Fl_Button *c_panel_cancel=(Fl_Button *)0;

Fl_Double_Window* make_class_panel() {
  { class_panel = new Fl_Double_Window(342, 196, "Class Properties");
    class_panel->labelsize(11);
    { Fl_Group* o = new Fl_Group(10, 10, 280, 20);
      o->hide();
      { c_public_button = new Fl_Light_Button(10, 10, 60, 20, "public");
        c_public_button->tooltip("Make the class publicly accessible.");
        c_public_button->labelsize(11);
        c_public_button->when(FL_WHEN_NEVER);
        c_public_button->hide();
      } // Fl_Light_Button* c_public_button
      { Fl_Box* o = new Fl_Box(80, 10, 210, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { c_name_input = new Fl_Input(10, 20, 320, 20, "Name:");
      c_name_input->tooltip("Name of class.");
      c_name_input->labelfont(1);
      c_name_input->labelsize(11);
      c_name_input->textfont(4);
      c_name_input->textsize(11);
      c_name_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      c_name_input->when(FL_WHEN_NEVER);
    } // Fl_Input* c_name_input
    { c_subclass_input = new Fl_Input(10, 55, 320, 20, "Subclass of (text between : and {)");
      c_subclass_input->tooltip("Name of subclass.");
      c_subclass_input->labelfont(1);
      c_subclass_input->labelsize(11);
      c_subclass_input->textfont(4);
      c_subclass_input->textsize(11);
      c_subclass_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      c_subclass_input->when(FL_WHEN_NEVER);
    } // Fl_Input* c_subclass_input
    { c_comment_input = new Fl_Text_Editor(10, 90, 320, 65, "Comment:");
      c_comment_input->tooltip("Class comment in Doxygen format");
      c_comment_input->box(FL_DOWN_BOX);
      c_comment_input->labelfont(1);
      c_comment_input->labelsize(11);
      c_comment_input->textfont(4);
      c_comment_input->textsize(11);
      c_comment_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      Fl_Group::current()->resizable(c_comment_input);
      c_comment_input->buffer(new Fl_Text_Buffer());
      c_comment_input->add_key_binding(FL_Tab, 0, use_tab_navigation);
    } // Fl_Text_Editor* c_comment_input
    { Fl_Group* o = new Fl_Group(10, 165, 320, 20);
      { c_panel_ok = new Fl_Return_Button(200, 165, 60, 20, "OK");
        c_panel_ok->labelsize(11);
        c_panel_ok->window()->hotspot(c_panel_ok);
      } // Fl_Return_Button* c_panel_ok
      { c_panel_cancel = new Fl_Button(270, 165, 60, 20, "Cancel");
        c_panel_cancel->shortcut(0xff1b);
        c_panel_cancel->labelsize(11);
      } // Fl_Button* c_panel_cancel
      { Fl_Box* o = new Fl_Box(10, 165, 185, 20);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    class_panel->set_modal();
    class_panel->size_range(343, 188);
    class_panel->end();
  } // Fl_Double_Window* class_panel
  return class_panel;
}

Fl_Double_Window *comment_panel=(Fl_Double_Window *)0;

Fl_Text_Editor *comment_input=(Fl_Text_Editor *)0;

Fl_Return_Button *comment_panel_ok=(Fl_Return_Button *)0;

Fl_Button *comment_panel_cancel=(Fl_Button *)0;

Fl_Light_Button *comment_in_source=(Fl_Light_Button *)0;

Fl_Light_Button *comment_in_header=(Fl_Light_Button *)0;

Fl_Menu_Button *comment_predefined=(Fl_Menu_Button *)0;

Fl_Button *comment_load=(Fl_Button *)0;

Fl_Double_Window* make_comment_panel() {
  { Fl_Double_Window* o = comment_panel = new Fl_Double_Window(550, 280, "Comment Properties");
    comment_panel->labelsize(11);
    { Fl_Text_Editor* o = comment_input = new Fl_Text_Editor(110, 10, 430, 230);
      comment_input->box(FL_DOWN_BOX);
      comment_input->labelsize(11);
      comment_input->textfont(4);
      comment_input->textsize(11);
      comment_input->textcolor((Fl_Color)58);
      Fl_Group::current()->resizable(comment_input);
      o->when(FL_WHEN_ENTER_KEY_CHANGED|FL_WHEN_RELEASE);
      o->buffer(new Fl_Text_Buffer());
    } // Fl_Text_Editor* comment_input
    { Fl_Group* o = new Fl_Group(110, 250, 430, 20);
      o->labelsize(11);
      { comment_panel_ok = new Fl_Return_Button(370, 250, 80, 20, "OK");
        comment_panel_ok->labelsize(11);
        comment_panel_ok->window()->hotspot(comment_panel_ok);
      } // Fl_Return_Button* comment_panel_ok
      { comment_panel_cancel = new Fl_Button(460, 250, 80, 20, "Cancel");
        comment_panel_cancel->shortcut(0xff1b);
        comment_panel_cancel->labelsize(11);
      } // Fl_Button* comment_panel_cancel
      { Fl_Box* o = new Fl_Box(110, 250, 250, 20);
        o->labelsize(11);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(10, 10, 90, 243);
      o->labelsize(11);
      { comment_in_source = new Fl_Light_Button(10, 10, 90, 20, "In Source");
        comment_in_source->tooltip("Put the comment into the source (.cxx) file.");
        comment_in_source->labelsize(11);
        comment_in_source->when(FL_WHEN_NEVER);
      } // Fl_Light_Button* comment_in_source
      { comment_in_header = new Fl_Light_Button(10, 40, 90, 20, "In Header");
        comment_in_header->tooltip("Put the comment into the header (.h) file.");
        comment_in_header->labelsize(11);
        comment_in_header->when(FL_WHEN_NEVER);
      } // Fl_Light_Button* comment_in_header
      { comment_predefined = new Fl_Menu_Button(10, 70, 90, 20, "Predefined");
        comment_predefined->labelsize(11);
        comment_predefined->textsize(11);
      } // Fl_Menu_Button* comment_predefined
      { comment_load = new Fl_Button(10, 100, 90, 20, "Import...");
        comment_load->labelsize(11);
      } // Fl_Button* comment_load
      { Fl_Box* o = new Fl_Box(10, 132, 90, 121);
        o->labelsize(11);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      o->end();
    } // Fl_Group* o
    comment_panel->set_modal();
    o->size_range(320, 180);
    comment_panel->end();
  } // Fl_Double_Window* comment_panel
  return comment_panel;
}

void type_make_cb(Fl_Widget*,void*d) {
  const char *type_name = (const char*)d;
  if (Fl_Type::current && Fl_Type::current->can_have_children())
    add_new_widget_from_user(type_name, Strategy::AS_LAST_CHILD);
  else
    add_new_widget_from_user(type_name, Strategy::AFTER_CURRENT);
}

Fl_Window *widgetbin_panel=(Fl_Window *)0;

static void cb_widgetbin_panel(Fl_Window* o, void* v) {
  if (Fl::event()==FL_SHORTCUT && Fl::event_key()==FL_Escape)
    exit_cb((Fl_Widget*)o, v);
  else
    toggle_widgetbin_cb((Fl_Widget*)o, v);
}

Fl_Window* make_widgetbin() {
  { widgetbin_panel = new Fl_Window(600, 102, "Widget Bin");
    widgetbin_panel->callback((Fl_Callback*)cb_widgetbin_panel);
    widgetbin_panel->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { Fl_Group* o = new Fl_Group(3, 19, 79, 79, "Code");
      o->labelsize(12);
      { Fl_Button* o = new Fl_Button(5, 21, 24, 24);
        o->tooltip("Function");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Function"));
        o->image(pixmap[ID_Function]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(30, 21, 24, 24);
        o->tooltip("Class");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Class"));
        o->image(pixmap[ID_Class]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(55, 21, 24, 24);
        o->tooltip("Comment");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("comment"));
        o->image(pixmap[ID_Comment]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(5, 46, 24, 24);
        o->tooltip("Code");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Code"));
        o->image(pixmap[ID_Code]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(30, 46, 24, 24);
        o->tooltip("Code Block");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("CodeBlock"));
        o->image(pixmap[ID_CodeBlock]);
      } // Fl_Button* o
      { Widget_Bin_Window_Button* o = new Widget_Bin_Window_Button(55, 46, 24, 24);
        o->tooltip("Widget Class");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("widget_class"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Widget_Class]);
      } // Widget_Bin_Window_Button* o
      { Fl_Button* o = new Fl_Button(5, 71, 24, 24);
        o->tooltip("Declaration");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("decl"));
        o->image(pixmap[ID_Decl]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(30, 71, 24, 24);
        o->tooltip("Declaration Block");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("declblock"));
        o->image(pixmap[ID_DeclBlock]);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(55, 71, 24, 24);
        o->tooltip("Inline Data");
        o->box(FL_THIN_UP_BOX);
        o->callback((Fl_Callback*)type_make_cb, (void*)("data"));
        o->image(pixmap[ID_Data]);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(87, 19, 79, 79, "Groups");
      o->labelsize(12);
      { Widget_Bin_Window_Button* o = new Widget_Bin_Window_Button(89, 21, 24, 24);
        o->tooltip("Window");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Window"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Window]);
      } // Widget_Bin_Window_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(114, 21, 24, 24);
        o->tooltip("Group");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Group"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Group]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(139, 21, 24, 24);
        o->tooltip("Pack");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Pack"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Pack]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(89, 46, 24, 24);
        o->tooltip("Tabs");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Tabs"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Tabs]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(114, 46, 24, 24);
        o->tooltip("Scroll");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Scroll"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Scroll]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(139, 46, 24, 24);
        o->tooltip("Flex");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Flex"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Flex]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(89, 71, 24, 24);
        o->tooltip("Tile");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Tile"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Tile]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(114, 71, 24, 24);
        o->tooltip("Wizard");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Wizard"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Wizard]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(139, 71, 24, 24);
        o->tooltip("Grid");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Grid"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Grid]);
      } // Widget_Bin_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(171, 19, 54, 79, "Buttons");
      o->labelsize(12);
      { Widget_Bin_Button* o = new Widget_Bin_Button(173, 21, 24, 24);
        o->tooltip("Button");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Button"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Button]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(198, 21, 24, 24);
        o->tooltip("Return Button");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Return_Button"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Return_Button]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(173, 46, 24, 24);
        o->tooltip("Light Button");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Light_Button"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Light_Button]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(198, 46, 24, 24);
        o->tooltip("Repeat Button");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Repeat_Button"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Repeat_Button]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(173, 71, 24, 24);
        o->tooltip("Check Button");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Check_Button"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Check_Button]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(198, 71, 24, 24);
        o->tooltip("Round Button");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Round_Button"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Round_Button]);
      } // Widget_Bin_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(230, 19, 104, 79, "Valuators");
      o->labelsize(12);
      { Widget_Bin_Button* o = new Widget_Bin_Button(232, 21, 24, 24);
        o->tooltip("Slider");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Slider"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Slider]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(257, 21, 24, 24);
        o->tooltip("Scroll Bar");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Scrollbar"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Scrollbar]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(282, 21, 24, 24);
        o->tooltip("Value Slider");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Value_Slider"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Value_Slider]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(307, 21, 24, 24);
        o->tooltip("Value Output");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Value_Output"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Value_Output]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(232, 46, 24, 24);
        o->tooltip("Adjuster");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Adjuster"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Adjuster]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(257, 46, 24, 24);
        o->tooltip("Counter");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Counter"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Counter]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(282, 46, 24, 24);
        o->tooltip("Dial");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Dial"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Dial]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(232, 71, 24, 24);
        o->tooltip("Roller");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Roller"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Roller]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(257, 71, 24, 24);
        o->tooltip("Spinner");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Spinner"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Spinner]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(282, 71, 24, 24);
        o->tooltip("Value Input");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Value_Input"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Value_Input]);
      } // Widget_Bin_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(339, 19, 54, 79, "Text");
      o->labelsize(12);
      { Widget_Bin_Button* o = new Widget_Bin_Button(341, 21, 24, 24);
        o->tooltip("Input");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Input"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Input]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(366, 21, 24, 24);
        o->tooltip("Output");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Output"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Output]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(341, 46, 24, 24);
        o->tooltip("Text Edit");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Text_Editor"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Text_Editor]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(366, 46, 24, 24);
        o->tooltip("Text Display");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Text_Display"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Text_Display]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(341, 71, 24, 24);
        o->tooltip("File Input");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_File_Input"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_File_Input]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(366, 71, 24, 24);
        o->tooltip("Terminal");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Terminal"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Terminal]);
      } // Widget_Bin_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(398, 19, 79, 79, "Menus");
      o->labelsize(12);
      { Widget_Bin_Button* o = new Widget_Bin_Button(400, 22, 24, 24);
        o->tooltip("Input Choice");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Input_Choice"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Input_Choice]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(425, 21, 24, 24);
        o->tooltip("Menu Item");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("menuitem"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Menu_Item]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(450, 21, 24, 24);
        o->tooltip("Menu Bar");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Menu_Bar"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Menu_Bar]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(400, 46, 24, 24);
        o->tooltip("Menu Button");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Menu_Button"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Menu_Button]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(425, 46, 24, 24);
        o->tooltip("Checkbox Menu Item");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("checkmenuitem"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Checkbox_Menu_Item]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(450, 46, 24, 24);
        o->tooltip("Sub Menu");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("submenu"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Submenu]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(400, 71, 24, 24);
        o->tooltip("Choice");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Choice"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Choice]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(425, 71, 24, 24);
        o->tooltip("Radio Menu Item");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("radiomenuitem"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Radio_Menu_Item]);
      } // Widget_Bin_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(482, 19, 54, 79, "Browsers");
      o->labelsize(12);
      { Widget_Bin_Button* o = new Widget_Bin_Button(484, 21, 24, 24);
        o->tooltip("Browser");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Browser"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Browser]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(509, 21, 24, 24);
        o->tooltip("Tree");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Tree"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Tree]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(484, 46, 24, 24);
        o->tooltip("Check Browser");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Check_Browser"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Check_Browser]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(509, 46, 24, 24);
        o->tooltip("Help Browser");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Help_View"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Help_View]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(484, 71, 24, 24);
        o->tooltip("File Browser");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_File_Browser"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_File_Browser]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(509, 71, 24, 24);
        o->tooltip("Table");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Table"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Table]);
      } // Widget_Bin_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(540, 19, 55, 79, "Misc");
      o->labelsize(12);
      { Widget_Bin_Button* o = new Widget_Bin_Button(542, 21, 24, 24);
        o->tooltip("Box");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Box"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Box]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(567, 21, 24, 24);
        o->tooltip("Clock");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Clock"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Clock]);
      } // Widget_Bin_Button* o
      { Widget_Bin_Button* o = new Widget_Bin_Button(542, 46, 24, 24);
        o->tooltip("Progress");
        o->box(FL_THIN_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->callback((Fl_Callback*)type_make_cb, (void*)("Fl_Progress"));
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->image(pixmap[ID_Progress]);
      } // Widget_Bin_Button* o
      o->end();
    } // Fl_Group* o
    widgetbin_panel->set_non_modal();
    widgetbin_panel->end();
  } // Fl_Window* widgetbin_panel
  return widgetbin_panel;
}

//
