```
% pandoc -f latex -t native
\SI[round-precision=2]{1}{m} is equal to \SI{1000}{mm}
^D
[ Para
    [ Str "1\160m"
    , Space
    , Str "is"
    , Space
    , Str "equal"
    , Space
    , Str "to"
    , Space
    , Str "1000\160mm"
    ]
]
```

```
% pandoc -f latex -t native
\SI[round-precision=2]{1}[\$]{} is equal to \SI{0.938094}{\euro}
^D
[ Para
    [ Str "$\160\&1"
    , Space
    , Str "is"
    , Space
    , Str "equal"
    , Space
    , Str "to"
    , Space
    , Str "0.938094\160\8364"
    ]
]
```


```
% pandoc -f latex -t native
\SI{30}{\milli\meter}
^D
[ Para [ Str "30\160mm" ] ]
```

```
% pandoc -f latex -t native
\SI{6}{\gram}
^D
[ Para [ Str "6\160g" ] ]
```

```
% pandoc -f latex -t native
\SI{25}{\square\meter}
^D
[ Para [ Str "25\160m" , Superscript [ Str "2" ] ] ]
```

```
% pandoc -f latex -t native
\SI{18.2}{\degreeCelsius}
^D
[ Para [ Str "18.2\160\176C" ] ]
```

```
% pandoc -f latex -t native
\SI{18.2}{\celsius}
^D
[ Para [ Str "18.2\160\176C" ] ]
```

# SIrange tests

## Integer range with simple common units

```
% pandoc -f latex -t native
\SIrange{10}{20}{\gram}
^D
[ Para [ Str "10\160g\8211\&20\160g" ] ]
```
```
% pandoc -f latex -t native
\SIrange{35}{9}{\milli\meter}
^D
[ Para [ Str "35\160mm\8211\&9\160mm" ] ]
```
```
% pandoc -f latex -t native
\SIrange{4}{97367265}{\celsius}
^D
[ Para [ Str "4\160\176C\8211\&97367265\160\176C" ] ]
```

## Decimal range with simple units

```
% pandoc -f latex -t native
\SIrange{4.5}{97367265.5}{\celsius}
^D
[ Para [ Str "4.5\160\176C\8211\&97367265.5\160\176C" ] ]
```

## Squared, cubed etc. units

```
% pandoc -f latex -t native
\SIrange{10}{20}{\square\meter}
^D
[ Para
    [ Str "10\160m"
    , Superscript [ Str "2" ]
    , Str "\8211\&20\160m"
    , Superscript [ Str "2" ]
    ]
]
```

```
% pandoc -f latex -t native
\SIrange{10}{20}{\cubic\meter}
^D
[ Para
    [ Str "10\160m"
    , Superscript [ Str "3" ]
    , Str "\8211\&20\160m"
    , Superscript [ Str "3" ]
    ]
]
```

```
% pandoc -f latex -t native
\SIrange{10}{20}{\raisetothe{4}\meter}
^D
[ Para
    [ Str "10\160m"
    , Superscript [ Str "4" ]
    , Str "\8211\&20\160m"
    , Superscript [ Str "4" ]
    ]
]
```


```
% pandoc -f latex -t native
\SIrange{10}{20}{\meter\squared}
^D
[ Para
    [ Str "10\160m"
    , Superscript [ Str "2" ]
    , Str "\8211\&20\160m"
    , Superscript [ Str "2" ]
    ]
]
```

```
% pandoc -f latex -t native
\SIrange{10}{20}{\meter\cubed}
^D
[ Para
    [ Str "10\160m"
    , Superscript [ Str "3" ]
    , Str "\8211\&20\160m"
    , Superscript [ Str "3" ]
    ]
]
```

```
% pandoc -f latex -t native
\SIrange{10}{20}{\meter\tothe{4}}
^D
[ Para
    [ Str "10\160m"
    , Superscript [ Str "4" ]
    , Str "\8211\&20\160m"
    , Superscript [ Str "4" ]
    ]
]
```



## Ignore round precision

`round-precision` option appears to be ignored by `\SI` as of 7c6dbd37e, so
`\SIrange` will ignore it as well.

```
% pandoc -f latex -t native
\SIrange[round-precision=2]{10}{20}{\gram}
^D
[ Para [ Str "10\160g\8211\&20\160g" ] ]
```
```
% pandoc -f latex -t native
\SIrange[round-precision=2]{10.0}{20.25}{\gram}
^D
[ Para [ Str "10.0\160g\8211\&20.25\160g" ] ]
```

