/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2013  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef TSVOUTPUTSTREAM_H
#define TSVOUTPUTSTREAM_H

#include "tsvdirectorywriter.h"

class TsvOutputStream: public TsvDirectoryWriter
{
public:
    TsvOutputStream(QTextStream & otxtstream);
    ~TsvOutputStream();

    void close() override;
    virtual void writeSheet(const QString & sheetName) override;

    /** @brief toggle writing sheet name in text stream to off
     * usefull if you only need one sheet
     * the wrisheet function can also be overloaded in a derived class
     * */
    void setNoSheetName(bool no_sheet_name);
private:
    bool _no_sheet_name = false;

};

#endif // TSVOUTPUTSTREAM_H
