/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.servlet;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.ServletService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServletUtils;

public class TurbineServletService
extends TurbineBaseService
implements ServletService {
    private ServletContext servletContext = null;
    private ServletConfig servletConfig = null;
    private String serverName = null;
    private String serverPort = null;
    private String serverScheme = null;
    private String contextPath = null;
    private static /* synthetic */ Class class$Ljavax$servlet$http$HttpServletRequest;

    public void init(ServletConfig servletConfig) {
        try {
            this.servletConfig = servletConfig;
            this.servletContext = servletConfig.getServletContext();
            Log.debug("[TurbineServletService] Initializing with ServletConfig");
        }
        catch (Exception e) {
            Log.error("Cannot initialize TurbineServletService.");
            Log.error(e);
        }
    }

    public void init(RunData data) {
        this.serverName = data.getRequest().getServerName();
        this.serverPort = Integer.toString(data.getRequest().getServerPort());
        this.serverScheme = data.getRequest().getScheme();
        Class jsdkClass = class$Ljavax$servlet$http$HttpServletRequest != null ? class$Ljavax$servlet$http$HttpServletRequest : (class$Ljavax$servlet$http$HttpServletRequest = TurbineServletService.class$("javax.servlet.http.HttpServletRequest"));
        try {
            Method meth = jsdkClass.getDeclaredMethod("getContextPath", null);
            this.contextPath = (String)meth.invoke((Object)data.getRequest(), null);
        }
        catch (Exception ex) {
            this.contextPath = "";
        }
        Log.debug("[TurbineServletService] serverName: " + this.serverName);
        Log.debug("[TurbineServletService] serverScheme: " + this.serverScheme);
        Log.debug("[TurbineServletService] serverPort: " + this.serverPort);
        Log.debug("[TurbineServletService] contextPath: " + this.contextPath);
        this.setInit(true);
    }

    public URL getResource(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        URL url = null;
        try {
            url = this.getServletContext().getResource(uri);
            if (url != null && url.toString().startsWith("classloader:")) {
                url = new URL("file:" + url.toString().substring(12));
            } else if (url == null) {
                url = new URL("file:" + this.getServletContext().getRealPath(uri));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public InputStream getResourceAsStream(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        InputStream is = null;
        is = this.servletContext.getResourceAsStream(uri);
        return is;
    }

    public String getRealPath(String uri) {
        if (this.getServletContext() == null || uri == null) {
            return null;
        }
        return this.getServletContext().getRealPath(uri);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServerScheme() {
        return this.serverScheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String expandRelative(String path) {
        return ServletUtils.expandRelative(this.getServletConfig(), path);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

