/*
 *  Copyright (c) 2007 Mockito contributors
 *  This program is made available under the terms of the MIT License.
 */
package org.powermock.api.mockito.repackaged.cglib.core;

/**
 * The <code>GeneratorStrategy</code. is responsible for taking a
 * {@link ClassGenerator} and producing a byte array containing the
 * data for the generated <code>Class</code>.  By providing your
 * own strategy you may examine or modify the generated class before
 * it is loaded. Typically this will be accomplished by subclassing
 * {@link DefaultGeneratorStrategy} and overriding the appropriate
 * protected method.
 * @see AbstractClassGenerator#setStrategy
 */
public interface GeneratorStrategy {
    /**
     * Generate the class.
     * @param cg a class generator on which you can call {@link ClassGenerator#generateClass}
     * @return a byte array containing the bits of a valid Class
     */
    byte[] generate(ClassGenerator cg) throws Exception;

    /**
     * The <code>GeneratorStrategy</code> in use does not currently, but may
     * in the future, affect the caching of classes generated by {@link
     * AbstractClassGenerator}, so this is a reminder that you should
     * correctly implement <code>equals</code> and <code>hashCode</code>
     * to avoid generating too many classes.
     */
    boolean equals(Object o);
}
