/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Global variables
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#include <glib.h>

#define FILEPATH_MAX 1024
#define DEF_PUREFTPD_PIDFILE "/var/run/pure-ftpd.pid"

#ifndef LINE_MAX
# define LINE_MAX 4096
#endif

#ifndef G_LIKELY
# define G_LIKELY(expr) (expr)
#endif

#ifndef G_UNLIKELY
# define G_UNLIKELY(expr) (expr)
#endif

#ifndef G_MAXINT32
# define G_MAXINT32 ((gint32) 0x7fffffff)
#endif

extern gboolean debug;
/* Set _CRITICAL since _ERR will terminate the program by glib */
#define pur_log_err(...) \
  g_log (NULL, G_LOG_LEVEL_CRITICAL, __VA_ARGS__);
#define pur_log_wrn(...) \
  g_log (NULL, G_LOG_LEVEL_WARNING, __VA_ARGS__);
#define pur_log_dbg(...) \
G_STMT_START { \
if (debug) \
 g_log (NULL, G_LOG_LEVEL_DEBUG, __VA_ARGS__); \
} G_STMT_END 
#define pur_log_nfo(...) \
  g_log (NULL, G_LOG_LEVEL_INFO, __VA_ARGS__);

#define gpointer_diff(a,b) (gint) (GPOINTER_TO_INT(a) - GPOINTER_TO_INT(b))

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  define Q_(String) g_strip_context ((String), gettext (String))
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define Q_(String) g_strip_context ((String), (String))
#  define N_(String) (String)
#endif

typedef enum {
	RUNMODE_STOPPED = 0, /* Server is stopped */
	RUNMODE_STANDALONE, /* Running in standalone mode */
	RUNMODE_INETD    /* Running through inetd or similar */
} ftp_runmode_t;

ftp_runmode_t ftp_runmode;

void exit_program (void);

extern gchar *datadir;
extern gchar *selfname;
extern gchar *pixmapdir;
extern gchar *docdir;
#endif /* __GLOBALS_H__ */
