# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import ResourcePropertiesObjectType

if TYPE_CHECKING:
    from .. import models as _models


class DeleteOption(_Model):
    """Delete Option.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AbsoluteDeleteOption

    :ivar duration: Duration of deletion after given timespan. Required.
    :vartype duration: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    duration: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Duration of deletion after given timespan. Required."""
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        duration: str,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AbsoluteDeleteOption(DeleteOption, discriminator="AbsoluteDeleteOption"):
    """Delete option with duration.

    :ivar duration: Duration of deletion after given timespan. Required.
    :vartype duration: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "AbsoluteDeleteOption".
    :vartype object_type: str
    """

    object_type: Literal["AbsoluteDeleteOption"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"AbsoluteDeleteOption\"."""

    @overload
    def __init__(
        self,
        *,
        duration: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AbsoluteDeleteOption"  # type: ignore


class AdHocBackupRuleOptions(_Model):
    """Adhoc backup rules.

    :ivar rule_name: Required.
    :vartype rule_name: str
    :ivar trigger_option: Adhoc backup trigger option. Required.
    :vartype trigger_option: ~azure.mgmt.dataprotection.models.AdhocBackupTriggerOption
    """

    rule_name: str = rest_field(name="ruleName", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    trigger_option: "_models.AdhocBackupTriggerOption" = rest_field(
        name="triggerOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Adhoc backup trigger option. Required."""

    @overload
    def __init__(
        self,
        *,
        rule_name: str,
        trigger_option: "_models.AdhocBackupTriggerOption",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdhocBackupTriggerOption(_Model):
    """Adhoc backup trigger option.

    :ivar retention_tag_override:
    :vartype retention_tag_override: str
    """

    retention_tag_override: Optional[str] = rest_field(
        name="retentionTagOverride", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        retention_tag_override: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdhocBasedTaggingCriteria(_Model):
    """Adhoc backup tagging criteria.

    :ivar tag_info: Retention tag information.
    :vartype tag_info: ~azure.mgmt.dataprotection.models.RetentionTag
    """

    tag_info: Optional["_models.RetentionTag"] = rest_field(
        name="tagInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retention tag information."""

    @overload
    def __init__(
        self,
        *,
        tag_info: Optional["_models.RetentionTag"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TriggerContext(_Model):
    """Trigger context.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AdhocBasedTriggerContext, ScheduleBasedTriggerContext

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdhocBasedTriggerContext(TriggerContext, discriminator="AdhocBasedTriggerContext"):
    """Adhoc trigger context.

    :ivar tagging_criteria: Tagging Criteria containing retention tag for adhoc backup. Required.
    :vartype tagging_criteria: ~azure.mgmt.dataprotection.models.AdhocBasedTaggingCriteria
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "AdhocBasedTriggerContext".
    :vartype object_type: str
    """

    tagging_criteria: "_models.AdhocBasedTaggingCriteria" = rest_field(
        name="taggingCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """Tagging Criteria containing retention tag for adhoc backup. Required."""
    object_type: Literal["AdhocBasedTriggerContext"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"AdhocBasedTriggerContext\"."""

    @overload
    def __init__(
        self,
        *,
        tagging_criteria: "_models.AdhocBasedTaggingCriteria",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AdhocBasedTriggerContext"  # type: ignore


class BackupDatasourceParameters(_Model):
    """Parameters for Backup Datasource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AdlsBlobBackupDatasourceParameters, BlobBackupDatasourceParameters,
    KubernetesClusterBackupDatasourceParameters

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BlobBackupDatasourceParameters(BackupDatasourceParameters, discriminator="BlobBackupDatasourceParameters"):
    """Parameters to be used during configuration of backup of blobs.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AdlsBlobBackupDatasourceParameters

    :ivar containers_list: List of containers to be backed up during configuration of backup of
     blobs. Required.
    :vartype containers_list: list[str]
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "BlobBackupDatasourceParameters".
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    containers_list: list[str] = rest_field(
        name="containersList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of containers to be backed up during configuration of backup of blobs. Required."""
    object_type: Literal["BlobBackupDatasourceParameters"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"BlobBackupDatasourceParameters\"."""

    @overload
    def __init__(
        self,
        *,
        containers_list: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "BlobBackupDatasourceParameters"  # type: ignore


class AdlsBlobBackupDatasourceParameters(
    BlobBackupDatasourceParameters, discriminator="AdlsBlobBackupDatasourceParameters"
):
    """Parameters to be used during configuration of backup of azure data lake storage account blobs.

    :ivar containers_list: List of containers to be backed up during configuration of backup of
     blobs. Required.
    :vartype containers_list: list[str]
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "AdlsBlobBackupDatasourceParameters".
    :vartype object_type: str
    """

    object_type: Literal["AdlsBlobBackupDatasourceParameters"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"AdlsBlobBackupDatasourceParameters\"."""

    @overload
    def __init__(
        self,
        *,
        containers_list: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AdlsBlobBackupDatasourceParameters"  # type: ignore


class AuthCredentials(_Model):
    """Base class for different types of authentication credentials.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SecretStoreBasedAuthCredentials

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupRecoveryPoint(_Model):
    """Azure backup recoveryPoint.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupDiscreteRecoveryPoint

    :ivar object_type: Required. Default value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupDiscreteRecoveryPoint(AzureBackupRecoveryPoint, discriminator="AzureBackupDiscreteRecoveryPoint"):
    """Azure backup discrete RecoveryPoint.

    :ivar friendly_name:
    :vartype friendly_name: str
    :ivar recovery_point_data_stores_details:
    :vartype recovery_point_data_stores_details:
     list[~azure.mgmt.dataprotection.models.RecoveryPointDataStoreDetails]
    :ivar recovery_point_time: Required.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar policy_name:
    :vartype policy_name: str
    :ivar policy_version:
    :vartype policy_version: str
    :ivar recovery_point_id:
    :vartype recovery_point_id: str
    :ivar recovery_point_type:
    :vartype recovery_point_type: str
    :ivar retention_tag_name:
    :vartype retention_tag_name: str
    :ivar retention_tag_version:
    :vartype retention_tag_version: str
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar recovery_point_state: Specifies recovery point completeness. Partial (i.e., only some of
     the intended items were backed up), or Completed (i.e., ALL intended items were backed up).
     Known values are: "Completed" and "Partial".
    :vartype recovery_point_state: str or
     ~azure.mgmt.dataprotection.models.RecoveryPointCompletionState
    :ivar object_type: Required. Default value is "AzureBackupDiscreteRecoveryPoint".
    :vartype object_type: str
    """

    friendly_name: Optional[str] = rest_field(
        name="friendlyName", visibility=["read", "create", "update", "delete", "query"]
    )
    recovery_point_data_stores_details: Optional[list["_models.RecoveryPointDataStoreDetails"]] = rest_field(
        name="recoveryPointDataStoresDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    recovery_point_time: datetime.datetime = rest_field(
        name="recoveryPointTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Required."""
    policy_name: Optional[str] = rest_field(
        name="policyName", visibility=["read", "create", "update", "delete", "query"]
    )
    policy_version: Optional[str] = rest_field(
        name="policyVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    recovery_point_id: Optional[str] = rest_field(
        name="recoveryPointId", visibility=["read", "create", "update", "delete", "query"]
    )
    recovery_point_type: Optional[str] = rest_field(
        name="recoveryPointType", visibility=["read", "create", "update", "delete", "query"]
    )
    retention_tag_name: Optional[str] = rest_field(
        name="retentionTagName", visibility=["read", "create", "update", "delete", "query"]
    )
    retention_tag_version: Optional[str] = rest_field(
        name="retentionTagVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    expiry_time: Optional[datetime.datetime] = rest_field(name="expiryTime", visibility=["read"], format="rfc3339")
    recovery_point_state: Optional[Union[str, "_models.RecoveryPointCompletionState"]] = rest_field(
        name="recoveryPointState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies recovery point completeness. Partial (i.e., only some of the intended items were
     backed up), or Completed (i.e., ALL intended items were backed up). Known values are:
     \"Completed\" and \"Partial\"."""
    object_type: Literal["AzureBackupDiscreteRecoveryPoint"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"AzureBackupDiscreteRecoveryPoint\"."""

    @overload
    def __init__(
        self,
        *,
        recovery_point_time: datetime.datetime,
        friendly_name: Optional[str] = None,
        recovery_point_data_stores_details: Optional[list["_models.RecoveryPointDataStoreDetails"]] = None,
        policy_name: Optional[str] = None,
        policy_version: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        recovery_point_type: Optional[str] = None,
        retention_tag_name: Optional[str] = None,
        retention_tag_version: Optional[str] = None,
        recovery_point_state: Optional[Union[str, "_models.RecoveryPointCompletionState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureBackupDiscreteRecoveryPoint"  # type: ignore


class AzureBackupFindRestorableTimeRangesRequest(_Model):  # pylint: disable=name-too-long
    """List Restore Ranges Request.

    :ivar source_data_store_type: Gets or sets the type of the source data store. Required. Known
     values are: "OperationalStore", "VaultStore", and "ArchiveStore".
    :vartype source_data_store_type: str or
     ~azure.mgmt.dataprotection.models.RestoreSourceDataStoreType
    :ivar start_time: Start time for the List Restore Ranges request. ISO 8601 format.
    :vartype start_time: str
    :ivar end_time: End time for the List Restore Ranges request. ISO 8601 format.
    :vartype end_time: str
    """

    source_data_store_type: Union[str, "_models.RestoreSourceDataStoreType"] = rest_field(
        name="sourceDataStoreType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of the source data store. Required. Known values are:
     \"OperationalStore\", \"VaultStore\", and \"ArchiveStore\"."""
    start_time: Optional[str] = rest_field(name="startTime", visibility=["read", "create", "update", "delete", "query"])
    """Start time for the List Restore Ranges request. ISO 8601 format."""
    end_time: Optional[str] = rest_field(name="endTime", visibility=["read", "create", "update", "delete", "query"])
    """End time for the List Restore Ranges request. ISO 8601 format."""

    @overload
    def __init__(
        self,
        *,
        source_data_store_type: Union[str, "_models.RestoreSourceDataStoreType"],
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupFindRestorableTimeRangesResponse(_Model):  # pylint: disable=name-too-long
    """List Restore Ranges Response.

    :ivar restorable_time_ranges: Returns the Restore Ranges available on the Backup Instance.
    :vartype restorable_time_ranges: list[~azure.mgmt.dataprotection.models.RestorableTimeRange]
    :ivar object_type:
    :vartype object_type: str
    """

    restorable_time_ranges: Optional[list["_models.RestorableTimeRange"]] = rest_field(
        name="restorableTimeRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """Returns the Restore Ranges available on the Backup Instance."""
    object_type: Optional[str] = rest_field(
        name="objectType", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        restorable_time_ranges: Optional[list["_models.RestorableTimeRange"]] = None,
        object_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DppResource(_Model):
    """Resource class.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id represents the complete path to the resource."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name associated with the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/..."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Metadata pertaining to creation and last modification of the resource."""


class AzureBackupFindRestorableTimeRangesResponseResource(DppResource):  # pylint: disable=name-too-long
    """List Restore Ranges Response.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar properties: AzureBackupFindRestorableTimeRangesResponseResource properties.
    :vartype properties:
     ~azure.mgmt.dataprotection.models.AzureBackupFindRestorableTimeRangesResponse
    """

    properties: Optional["_models.AzureBackupFindRestorableTimeRangesResponse"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """AzureBackupFindRestorableTimeRangesResponseResource properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AzureBackupFindRestorableTimeRangesResponse"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupJob(_Model):
    """AzureBackup Job Class.

    :ivar activity_id: Job Activity Id. Required.
    :vartype activity_id: str
    :ivar backup_instance_friendly_name: Name of the Backup Instance. Required.
    :vartype backup_instance_friendly_name: str
    :ivar backup_instance_id: ARM ID of the Backup Instance.
    :vartype backup_instance_id: str
    :ivar data_source_id: ARM ID of the DataSource. Required.
    :vartype data_source_id: str
    :ivar data_source_location: Location of the DataSource. Required.
    :vartype data_source_location: str
    :ivar data_source_name: User Friendly Name of the DataSource. Required.
    :vartype data_source_name: str
    :ivar data_source_set_name: Data Source Set Name of the DataSource.
    :vartype data_source_set_name: str
    :ivar data_source_type: Type of DataSource. Required.
    :vartype data_source_type: str
    :ivar duration: Total run time of the job. ISO 8601 format.
    :vartype duration: str
    :ivar end_time: EndTime of the job(in UTC).
    :vartype end_time: ~datetime.datetime
    :ivar error_details: A List, detailing the errors related to the job.
    :vartype error_details: list[~azure.mgmt.dataprotection.models.UserFacingError]
    :ivar extended_info: Extended Information about the job.
    :vartype extended_info: ~azure.mgmt.dataprotection.models.JobExtendedInfo
    :ivar is_user_triggered: Indicated that whether the job is adhoc(true) or scheduled(false).
     Required.
    :vartype is_user_triggered: bool
    :ivar operation: It indicates the type of Job i.e. Backup:full/log/diff ;Restore:ALR/OLR;
     Tiering:Backup/Archive ; Management:ConfigureProtection/UnConfigure. Required.
    :vartype operation: str
    :ivar operation_category: It indicates the type of Job i.e. Backup/Restore/Tiering/Management.
     Required.
    :vartype operation_category: str
    :ivar policy_id: ARM ID of the policy.
    :vartype policy_id: str
    :ivar policy_name: Name of the policy.
    :vartype policy_name: str
    :ivar progress_enabled: Indicated whether progress is enabled for the job. Required.
    :vartype progress_enabled: bool
    :ivar progress_url: Url which contains job's progress.
    :vartype progress_url: str
    :ivar rehydration_priority: Priority to be used for rehydration.
    :vartype rehydration_priority: str
    :ivar restore_type: It indicates the sub type of operation i.e. in case of Restore it can be
     ALR/OLR.
    :vartype restore_type: str
    :ivar source_resource_group: Resource Group Name of the Datasource. Required.
    :vartype source_resource_group: str
    :ivar source_subscription_id: SubscriptionId corresponding to the DataSource. Required.
    :vartype source_subscription_id: str
    :ivar start_time: StartTime of the job(in UTC). Required.
    :vartype start_time: ~datetime.datetime
    :ivar status: Status of the job like
     InProgress/Completed/Failed/Cancelled/CompletedWithWarnings/Cancelling/Paused. Required.
    :vartype status: str
    :ivar subscription_id: Subscription Id of the corresponding backup vault. Required.
    :vartype subscription_id: str
    :ivar supported_actions: List of supported actions. Required.
    :vartype supported_actions: list[str]
    :ivar vault_name: Name of the vault. Required.
    :vartype vault_name: str
    :ivar etag:
    :vartype etag: str
    :ivar source_data_store_name:
    :vartype source_data_store_name: str
    :ivar destination_data_store_name:
    :vartype destination_data_store_name: str
    """

    activity_id: str = rest_field(name="activityID", visibility=["read", "create", "update", "delete", "query"])
    """Job Activity Id. Required."""
    backup_instance_friendly_name: str = rest_field(
        name="backupInstanceFriendlyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the Backup Instance. Required."""
    backup_instance_id: Optional[str] = rest_field(name="backupInstanceId", visibility=["read"])
    """ARM ID of the Backup Instance."""
    data_source_id: str = rest_field(name="dataSourceId", visibility=["read", "create", "update", "delete", "query"])
    """ARM ID of the DataSource. Required."""
    data_source_location: str = rest_field(
        name="dataSourceLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Location of the DataSource. Required."""
    data_source_name: str = rest_field(
        name="dataSourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """User Friendly Name of the DataSource. Required."""
    data_source_set_name: Optional[str] = rest_field(
        name="dataSourceSetName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Data Source Set Name of the DataSource."""
    data_source_type: str = rest_field(
        name="dataSourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of DataSource. Required."""
    duration: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Total run time of the job. ISO 8601 format."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """EndTime of the job(in UTC)."""
    error_details: Optional[list["_models.UserFacingError"]] = rest_field(name="errorDetails", visibility=["read"])
    """A List, detailing the errors related to the job."""
    extended_info: Optional["_models.JobExtendedInfo"] = rest_field(name="extendedInfo", visibility=["read"])
    """Extended Information about the job."""
    is_user_triggered: bool = rest_field(
        name="isUserTriggered", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicated that whether the job is adhoc(true) or scheduled(false). Required."""
    operation: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """It indicates the type of Job i.e. Backup:full/log/diff ;Restore:ALR/OLR; Tiering:Backup/Archive
     ; Management:ConfigureProtection/UnConfigure. Required."""
    operation_category: str = rest_field(
        name="operationCategory", visibility=["read", "create", "update", "delete", "query"]
    )
    """It indicates the type of Job i.e. Backup/Restore/Tiering/Management. Required."""
    policy_id: Optional[str] = rest_field(name="policyId", visibility=["read"])
    """ARM ID of the policy."""
    policy_name: Optional[str] = rest_field(name="policyName", visibility=["read"])
    """Name of the policy."""
    progress_enabled: bool = rest_field(
        name="progressEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicated whether progress is enabled for the job. Required."""
    progress_url: Optional[str] = rest_field(name="progressUrl", visibility=["read"])
    """Url which contains job's progress."""
    rehydration_priority: Optional[str] = rest_field(name="rehydrationPriority", visibility=["read"])
    """Priority to be used for rehydration."""
    restore_type: Optional[str] = rest_field(name="restoreType", visibility=["read"])
    """It indicates the sub type of operation i.e. in case of Restore it can be ALR/OLR."""
    source_resource_group: str = rest_field(
        name="sourceResourceGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Group Name of the Datasource. Required."""
    source_subscription_id: str = rest_field(
        name="sourceSubscriptionID", visibility=["read", "create", "update", "delete", "query"]
    )
    """SubscriptionId corresponding to the DataSource. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """StartTime of the job(in UTC). Required."""
    status: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Status of the job like
     InProgress/Completed/Failed/Cancelled/CompletedWithWarnings/Cancelling/Paused. Required."""
    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Subscription Id of the corresponding backup vault. Required."""
    supported_actions: list[str] = rest_field(
        name="supportedActions", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of supported actions. Required."""
    vault_name: str = rest_field(name="vaultName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the vault. Required."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    source_data_store_name: Optional[str] = rest_field(
        name="sourceDataStoreName", visibility=["read", "create", "update", "delete", "query"]
    )
    destination_data_store_name: Optional[str] = rest_field(
        name="destinationDataStoreName", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        activity_id: str,
        backup_instance_friendly_name: str,
        data_source_id: str,
        data_source_location: str,
        data_source_name: str,
        data_source_type: str,
        is_user_triggered: bool,
        operation: str,
        operation_category: str,
        progress_enabled: bool,
        source_resource_group: str,
        source_subscription_id: str,
        start_time: datetime.datetime,
        status: str,
        subscription_id: str,
        supported_actions: list[str],
        vault_name: str,
        data_source_set_name: Optional[str] = None,
        duration: Optional[str] = None,
        etag: Optional[str] = None,
        source_data_store_name: Optional[str] = None,
        destination_data_store_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    """


class AzureBackupJobResource(ProxyResource):
    """AzureBackup Job Resource Class.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar properties: AzureBackupJobResource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.AzureBackupJob
    """

    properties: Optional["_models.AzureBackupJob"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """AzureBackupJobResource properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AzureBackupJob"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupParameters(_Model):
    """BackupParameters base.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupParams

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupParams(BackupParameters, discriminator="AzureBackupParams"):
    """Azure backup parameters.

    :ivar backup_type: BackupType ; Full/Incremental etc. Required.
    :vartype backup_type: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "AzureBackupParams".
    :vartype object_type: str
    """

    backup_type: str = rest_field(name="backupType", visibility=["read", "create", "update", "delete", "query"])
    """BackupType ; Full/Incremental etc. Required."""
    object_type: Literal["AzureBackupParams"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"AzureBackupParams\"."""

    @overload
    def __init__(
        self,
        *,
        backup_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureBackupParams"  # type: ignore


class AzureBackupRestoreRequest(_Model):
    """Azure backup restore request.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupRecoveryPointBasedRestoreRequest, AzureBackupRecoveryTimeBasedRestoreRequest,
    AzureBackupRestoreWithRehydrationRequest

    :ivar object_type: Required. Default value is None.
    :vartype object_type: str
    :ivar restore_target_info: Gets or sets the restore target information. Required.
    :vartype restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :ivar source_data_store_type: Gets or sets the type of the source data store. Required. Known
     values are: "ArchiveStore", "SnapshotStore", "OperationalStore", and "VaultStore".
    :vartype source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    :ivar source_resource_id: Fully qualified Azure Resource Manager ID of the datasource which is
     being recovered.
    :vartype source_resource_id: str
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar identity_details: Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned.
    :vartype identity_details: ~azure.mgmt.dataprotection.models.IdentityDetails
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""
    restore_target_info: "_models.RestoreTargetInfoBase" = rest_field(
        name="restoreTargetInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the restore target information. Required."""
    source_data_store_type: Union[str, "_models.SourceDataStoreType"] = rest_field(
        name="sourceDataStoreType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of the source data store. Required. Known values are: \"ArchiveStore\",
     \"SnapshotStore\", \"OperationalStore\", and \"VaultStore\"."""
    source_resource_id: Optional[str] = rest_field(
        name="sourceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fully qualified Azure Resource Manager ID of the datasource which is being recovered."""
    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""
    identity_details: Optional["_models.IdentityDetails"] = rest_field(
        name="identityDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
        restore_target_info: "_models.RestoreTargetInfoBase",
        source_data_store_type: Union[str, "_models.SourceDataStoreType"],
        source_resource_id: Optional[str] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
        identity_details: Optional["_models.IdentityDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupRecoveryPointBasedRestoreRequest(
    AzureBackupRestoreRequest, discriminator="AzureBackupRecoveryPointBasedRestoreRequest"
):  # pylint: disable=name-too-long
    """Azure backup recoveryPoint based restore request.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupRestoreWithRehydrationRequest

    :ivar restore_target_info: Gets or sets the restore target information. Required.
    :vartype restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :ivar source_data_store_type: Gets or sets the type of the source data store. Required. Known
     values are: "ArchiveStore", "SnapshotStore", "OperationalStore", and "VaultStore".
    :vartype source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    :ivar source_resource_id: Fully qualified Azure Resource Manager ID of the datasource which is
     being recovered.
    :vartype source_resource_id: str
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar identity_details: Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned.
    :vartype identity_details: ~azure.mgmt.dataprotection.models.IdentityDetails
    :ivar recovery_point_id: Required.
    :vartype recovery_point_id: str
    :ivar object_type: Required. Default value is "AzureBackupRecoveryPointBasedRestoreRequest".
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    recovery_point_id: str = rest_field(
        name="recoveryPointId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    object_type: Literal["AzureBackupRecoveryPointBasedRestoreRequest"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"AzureBackupRecoveryPointBasedRestoreRequest\"."""

    @overload
    def __init__(
        self,
        *,
        restore_target_info: "_models.RestoreTargetInfoBase",
        source_data_store_type: Union[str, "_models.SourceDataStoreType"],
        recovery_point_id: str,
        source_resource_id: Optional[str] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
        identity_details: Optional["_models.IdentityDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureBackupRecoveryPointBasedRestoreRequest"  # type: ignore


class AzureBackupRecoveryPointResource(ProxyResource):
    """Azure backup recoveryPoint resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar properties: AzureBackupRecoveryPointResource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.AzureBackupRecoveryPoint
    """

    properties: Optional["_models.AzureBackupRecoveryPoint"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """AzureBackupRecoveryPointResource properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AzureBackupRecoveryPoint"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupRecoveryTimeBasedRestoreRequest(
    AzureBackupRestoreRequest, discriminator="AzureBackupRecoveryTimeBasedRestoreRequest"
):  # pylint: disable=name-too-long
    """AzureBackup RecoveryPointTime Based Restore Request.

    :ivar restore_target_info: Gets or sets the restore target information. Required.
    :vartype restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :ivar source_data_store_type: Gets or sets the type of the source data store. Required. Known
     values are: "ArchiveStore", "SnapshotStore", "OperationalStore", and "VaultStore".
    :vartype source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    :ivar source_resource_id: Fully qualified Azure Resource Manager ID of the datasource which is
     being recovered.
    :vartype source_resource_id: str
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar identity_details: Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned.
    :vartype identity_details: ~azure.mgmt.dataprotection.models.IdentityDetails
    :ivar recovery_point_time: The recovery time in ISO 8601 format example -
     2020-08-14T17:30:00.0000000Z. Required.
    :vartype recovery_point_time: str
    :ivar object_type: Required. Default value is "AzureBackupRecoveryTimeBasedRestoreRequest".
    :vartype object_type: str
    """

    recovery_point_time: str = rest_field(
        name="recoveryPointTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The recovery time in ISO 8601 format example - 2020-08-14T17:30:00.0000000Z. Required."""
    object_type: Literal["AzureBackupRecoveryTimeBasedRestoreRequest"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"AzureBackupRecoveryTimeBasedRestoreRequest\"."""

    @overload
    def __init__(
        self,
        *,
        restore_target_info: "_models.RestoreTargetInfoBase",
        source_data_store_type: Union[str, "_models.SourceDataStoreType"],
        recovery_point_time: str,
        source_resource_id: Optional[str] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
        identity_details: Optional["_models.IdentityDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureBackupRecoveryTimeBasedRestoreRequest"  # type: ignore


class AzureBackupRehydrationRequest(_Model):
    """Azure Backup Rehydrate Request.

    :ivar recovery_point_id: Id of the recovery point to be recovered. Required.
    :vartype recovery_point_id: str
    :ivar rehydration_priority: Priority to be used for rehydration. Values High or Standard. Known
     values are: "Invalid", "High", and "Standard".
    :vartype rehydration_priority: str or ~azure.mgmt.dataprotection.models.RehydrationPriority
    :ivar rehydration_retention_duration: Retention duration in ISO 8601 format i.e P10D .
     Required.
    :vartype rehydration_retention_duration: str
    """

    recovery_point_id: str = rest_field(
        name="recoveryPointId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Id of the recovery point to be recovered. Required."""
    rehydration_priority: Optional[Union[str, "_models.RehydrationPriority"]] = rest_field(
        name="rehydrationPriority", visibility=["read", "create", "update", "delete", "query"]
    )
    """Priority to be used for rehydration. Values High or Standard. Known values are: \"Invalid\",
     \"High\", and \"Standard\"."""
    rehydration_retention_duration: str = rest_field(
        name="rehydrationRetentionDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retention duration in ISO 8601 format i.e P10D . Required."""

    @overload
    def __init__(
        self,
        *,
        recovery_point_id: str,
        rehydration_retention_duration: str,
        rehydration_priority: Optional[Union[str, "_models.RehydrationPriority"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupRestoreWithRehydrationRequest(
    AzureBackupRecoveryPointBasedRestoreRequest, discriminator="AzureBackupRestoreWithRehydrationRequest"
):
    """AzureBackup Restore with Rehydration Request.

    :ivar restore_target_info: Gets or sets the restore target information. Required.
    :vartype restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :ivar source_data_store_type: Gets or sets the type of the source data store. Required. Known
     values are: "ArchiveStore", "SnapshotStore", "OperationalStore", and "VaultStore".
    :vartype source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    :ivar source_resource_id: Fully qualified Azure Resource Manager ID of the datasource which is
     being recovered.
    :vartype source_resource_id: str
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar identity_details: Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned.
    :vartype identity_details: ~azure.mgmt.dataprotection.models.IdentityDetails
    :ivar recovery_point_id: Required.
    :vartype recovery_point_id: str
    :ivar rehydration_priority: Priority to be used for rehydration. Values High or Standard.
     Required. Known values are: "Invalid", "High", and "Standard".
    :vartype rehydration_priority: str or ~azure.mgmt.dataprotection.models.RehydrationPriority
    :ivar rehydration_retention_duration: Retention duration in ISO 8601 format i.e P10D .
     Required.
    :vartype rehydration_retention_duration: str
    :ivar object_type: Required. Default value is "AzureBackupRestoreWithRehydrationRequest".
    :vartype object_type: str
    """

    rehydration_priority: Union[str, "_models.RehydrationPriority"] = rest_field(
        name="rehydrationPriority", visibility=["read", "create", "update", "delete", "query"]
    )
    """Priority to be used for rehydration. Values High or Standard. Required. Known values are:
     \"Invalid\", \"High\", and \"Standard\"."""
    rehydration_retention_duration: str = rest_field(
        name="rehydrationRetentionDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retention duration in ISO 8601 format i.e P10D . Required."""
    object_type: Literal["AzureBackupRestoreWithRehydrationRequest"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"AzureBackupRestoreWithRehydrationRequest\"."""

    @overload
    def __init__(
        self,
        *,
        restore_target_info: "_models.RestoreTargetInfoBase",
        source_data_store_type: Union[str, "_models.SourceDataStoreType"],
        recovery_point_id: str,
        rehydration_priority: Union[str, "_models.RehydrationPriority"],
        rehydration_retention_duration: str,
        source_resource_id: Optional[str] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
        identity_details: Optional["_models.IdentityDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureBackupRestoreWithRehydrationRequest"  # type: ignore


class BasePolicyRule(_Model):
    """BasePolicy Rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupRule, AzureRetentionRule

    :ivar name: Required.
    :vartype name: str
    :ivar object_type: Required. Default value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBackupRule(BasePolicyRule, discriminator="AzureBackupRule"):
    """Azure backup rule.

    :ivar name: Required.
    :vartype name: str
    :ivar backup_parameters: BackupParameters base.
    :vartype backup_parameters: ~azure.mgmt.dataprotection.models.BackupParameters
    :ivar data_store: DataStoreInfo base. Required.
    :vartype data_store: ~azure.mgmt.dataprotection.models.DataStoreInfoBase
    :ivar trigger: Trigger context. Required.
    :vartype trigger: ~azure.mgmt.dataprotection.models.TriggerContext
    :ivar object_type: Required. Default value is "AzureBackupRule".
    :vartype object_type: str
    """

    backup_parameters: Optional["_models.BackupParameters"] = rest_field(
        name="backupParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """BackupParameters base."""
    data_store: "_models.DataStoreInfoBase" = rest_field(
        name="dataStore", visibility=["read", "create", "update", "delete", "query"]
    )
    """DataStoreInfo base. Required."""
    trigger: "_models.TriggerContext" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Trigger context. Required."""
    object_type: Literal["AzureBackupRule"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"AzureBackupRule\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        data_store: "_models.DataStoreInfoBase",
        trigger: "_models.TriggerContext",
        backup_parameters: Optional["_models.BackupParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureBackupRule"  # type: ignore


class AzureMonitorAlertSettings(_Model):
    """Settings for Azure Monitor based alerts.

    :ivar alerts_for_all_job_failures: Known values are: "Enabled" and "Disabled".
    :vartype alerts_for_all_job_failures: str or ~azure.mgmt.dataprotection.models.AlertsState
    """

    alerts_for_all_job_failures: Optional[Union[str, "_models.AlertsState"]] = rest_field(
        name="alertsForAllJobFailures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        alerts_for_all_job_failures: Optional[Union[str, "_models.AlertsState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataStoreParameters(_Model):
    """Parameters for DataStore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureOperationalStoreParameters

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    :ivar data_store_type: type of datastore; Operational/Vault/Archive. Required. Known values
     are: "OperationalStore", "VaultStore", and "ArchiveStore".
    :vartype data_store_type: str or ~azure.mgmt.dataprotection.models.DataStoreTypes
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""
    data_store_type: Union[str, "_models.DataStoreTypes"] = rest_field(
        name="dataStoreType", visibility=["read", "create", "update", "delete", "query"]
    )
    """type of datastore; Operational/Vault/Archive. Required. Known values are: \"OperationalStore\",
     \"VaultStore\", and \"ArchiveStore\"."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
        data_store_type: Union[str, "_models.DataStoreTypes"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureOperationalStoreParameters(DataStoreParameters, discriminator="AzureOperationalStoreParameters"):
    """Parameters for Operational-Tier DataStore.

    :ivar data_store_type: type of datastore; Operational/Vault/Archive. Required. Known values
     are: "OperationalStore", "VaultStore", and "ArchiveStore".
    :vartype data_store_type: str or ~azure.mgmt.dataprotection.models.DataStoreTypes
    :ivar resource_group_id: Gets or sets the Snapshot Resource Group Uri.
    :vartype resource_group_id: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "AzureOperationalStoreParameters".
    :vartype object_type: str
    """

    resource_group_id: Optional[str] = rest_field(
        name="resourceGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Snapshot Resource Group Uri."""
    object_type: Literal["AzureOperationalStoreParameters"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"AzureOperationalStoreParameters\"."""

    @overload
    def __init__(
        self,
        *,
        data_store_type: Union[str, "_models.DataStoreTypes"],
        resource_group_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureOperationalStoreParameters"  # type: ignore


class AzureRetentionRule(BasePolicyRule, discriminator="AzureRetentionRule"):
    """Azure retention rule.

    :ivar name: Required.
    :vartype name: str
    :ivar is_default:
    :vartype is_default: bool
    :ivar lifecycles: Required.
    :vartype lifecycles: list[~azure.mgmt.dataprotection.models.SourceLifeCycle]
    :ivar object_type: Required. Default value is "AzureRetentionRule".
    :vartype object_type: str
    """

    is_default: Optional[bool] = rest_field(
        name="isDefault", visibility=["read", "create", "update", "delete", "query"]
    )
    lifecycles: list["_models.SourceLifeCycle"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    object_type: Literal["AzureRetentionRule"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"AzureRetentionRule\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        lifecycles: list["_models.SourceLifeCycle"],
        is_default: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "AzureRetentionRule"  # type: ignore


class BackupCriteria(_Model):
    """BackupCriteria base class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ScheduleBasedBackupCriteria

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupInstance(_Model):
    """Backup Instance.

    :ivar friendly_name: Gets or sets the Backup Instance friendly name.
    :vartype friendly_name: str
    :ivar data_source_info: Gets or sets the data source information. Required.
    :vartype data_source_info: ~azure.mgmt.dataprotection.models.Datasource
    :ivar data_source_set_info: Gets or sets the data source set information.
    :vartype data_source_set_info: ~azure.mgmt.dataprotection.models.DatasourceSet
    :ivar policy_info: Gets or sets the policy information. Required.
    :vartype policy_info: ~azure.mgmt.dataprotection.models.PolicyInfo
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar protection_status: Specifies the protection status of the resource.
    :vartype protection_status: ~azure.mgmt.dataprotection.models.ProtectionStatusDetails
    :ivar current_protection_state: Specifies the current protection state of the resource. Known
     values are: "Invalid", "NotProtected", "ConfiguringProtection", "ProtectionConfigured",
     "BackupSchedulesSuspended", "RetentionSchedulesSuspended", "ProtectionStopped",
     "ProtectionError", "ConfiguringProtectionFailed", "SoftDeleting", "SoftDeleted", and
     "UpdatingProtection".
    :vartype current_protection_state: str or
     ~azure.mgmt.dataprotection.models.CurrentProtectionState
    :ivar protection_error_details: Specifies the protection error of the resource.
    :vartype protection_error_details: ~azure.mgmt.dataprotection.models.UserFacingError
    :ivar provisioning_state: Specifies the provisioning state of the resource i.e.
     provisioning/updating/Succeeded/Failed.
    :vartype provisioning_state: str
    :ivar datasource_auth_credentials: Credentials to use to authenticate with data source
     provider.
    :vartype datasource_auth_credentials: ~azure.mgmt.dataprotection.models.AuthCredentials
    :ivar validation_type: Specifies the type of validation. In case of DeepValidation, all
     validations from /validateForBackup API will run again. Known values are: "ShallowValidation"
     and "DeepValidation".
    :vartype validation_type: str or ~azure.mgmt.dataprotection.models.ValidationType
    :ivar identity_details: Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned.
    :vartype identity_details: ~azure.mgmt.dataprotection.models.IdentityDetails
    :ivar object_type: Required.
    :vartype object_type: str
    """

    friendly_name: Optional[str] = rest_field(
        name="friendlyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Backup Instance friendly name."""
    data_source_info: "_models.Datasource" = rest_field(
        name="dataSourceInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the data source information. Required."""
    data_source_set_info: Optional["_models.DatasourceSet"] = rest_field(
        name="dataSourceSetInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the data source set information."""
    policy_info: "_models.PolicyInfo" = rest_field(
        name="policyInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the policy information. Required."""
    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""
    protection_status: Optional["_models.ProtectionStatusDetails"] = rest_field(
        name="protectionStatus", visibility=["read"]
    )
    """Specifies the protection status of the resource."""
    current_protection_state: Optional[Union[str, "_models.CurrentProtectionState"]] = rest_field(
        name="currentProtectionState", visibility=["read"]
    )
    """Specifies the current protection state of the resource. Known values are: \"Invalid\",
     \"NotProtected\", \"ConfiguringProtection\", \"ProtectionConfigured\",
     \"BackupSchedulesSuspended\", \"RetentionSchedulesSuspended\", \"ProtectionStopped\",
     \"ProtectionError\", \"ConfiguringProtectionFailed\", \"SoftDeleting\", \"SoftDeleted\", and
     \"UpdatingProtection\"."""
    protection_error_details: Optional["_models.UserFacingError"] = rest_field(
        name="protectionErrorDetails", visibility=["read"]
    )
    """Specifies the protection error of the resource."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed."""
    datasource_auth_credentials: Optional["_models.AuthCredentials"] = rest_field(
        name="datasourceAuthCredentials", visibility=["read", "create", "update", "delete", "query"]
    )
    """Credentials to use to authenticate with data source provider."""
    validation_type: Optional[Union[str, "_models.ValidationType"]] = rest_field(
        name="validationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the type of validation. In case of DeepValidation, all validations from
     /validateForBackup API will run again. Known values are: \"ShallowValidation\" and
     \"DeepValidation\"."""
    identity_details: Optional["_models.IdentityDetails"] = rest_field(
        name="identityDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned."""
    object_type: str = rest_field(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        data_source_info: "_models.Datasource",
        policy_info: "_models.PolicyInfo",
        object_type: str,
        friendly_name: Optional[str] = None,
        data_source_set_info: Optional["_models.DatasourceSet"] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
        datasource_auth_credentials: Optional["_models.AuthCredentials"] = None,
        validation_type: Optional[Union[str, "_models.ValidationType"]] = None,
        identity_details: Optional["_models.IdentityDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupInstanceResource(ProxyResource):
    """BackupInstance Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar properties: BackupInstanceResource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.BackupInstance
    :ivar tags: Proxy Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.BackupInstance"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """BackupInstanceResource properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Proxy Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BackupInstance"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseBackupPolicy(_Model):
    """BackupPolicy base.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BackupPolicy

    :ivar datasource_types: Type of datasource for the backup management. Required.
    :vartype datasource_types: list[str]
    :ivar object_type: Required. Default value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    datasource_types: list[str] = rest_field(
        name="datasourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of datasource for the backup management. Required."""
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        datasource_types: list[str],
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupPolicy(BaseBackupPolicy, discriminator="BackupPolicy"):
    """Rule based backup policy.

    :ivar datasource_types: Type of datasource for the backup management. Required.
    :vartype datasource_types: list[str]
    :ivar policy_rules: Policy rule dictionary that contains rules for each backuptype i.e
     Full/Incremental/Logs etc. Required.
    :vartype policy_rules: list[~azure.mgmt.dataprotection.models.BasePolicyRule]
    :ivar object_type: Required. Default value is "BackupPolicy".
    :vartype object_type: str
    """

    policy_rules: list["_models.BasePolicyRule"] = rest_field(
        name="policyRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc.
     Required."""
    object_type: Literal["BackupPolicy"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"BackupPolicy\"."""

    @overload
    def __init__(
        self,
        *,
        datasource_types: list[str],
        policy_rules: list["_models.BasePolicyRule"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "BackupPolicy"  # type: ignore


class BackupSchedule(_Model):
    """Schedule for backup.

    :ivar repeating_time_intervals: Repeating time interval which only support the following ISO
     8601 format [R/startDateTime/Duration]. Example: R/2007-03-01T13:00:00Z/P1Y2M10DT2H30M.
     Required.
    :vartype repeating_time_intervals: list[str]
    :ivar time_zone: Time zone for a schedule. Example: Pacific Standard Time.
    :vartype time_zone: str
    """

    repeating_time_intervals: list[str] = rest_field(
        name="repeatingTimeIntervals", visibility=["read", "create", "update", "delete", "query"]
    )
    """Repeating time interval which only support the following ISO 8601 format
     [R/startDateTime/Duration]. Example: R/2007-03-01T13:00:00Z/P1Y2M10DT2H30M. Required."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create", "update", "delete", "query"])
    """Time zone for a schedule. Example: Pacific Standard Time."""

    @overload
    def __init__(
        self,
        *,
        repeating_time_intervals: list[str],
        time_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupVault(_Model):
    """Backup Vault.

    :ivar monitoring_settings: Monitoring Settings.
    :vartype monitoring_settings: ~azure.mgmt.dataprotection.models.MonitoringSettings
    :ivar provisioning_state: Provisioning state of the BackupVault resource. Known values are:
     "Failed", "Provisioning", "Succeeded", "Unknown", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.dataprotection.models.ProvisioningState
    :ivar resource_move_state: Resource move state for backup vault. Known values are: "Unknown",
     "InProgress", "PrepareFailed", "CommitFailed", "Failed", "PrepareTimedout", "CommitTimedout",
     "CriticalFailure", "PartialSuccess", and "MoveSucceeded".
    :vartype resource_move_state: str or ~azure.mgmt.dataprotection.models.ResourceMoveState
    :ivar resource_move_details: Resource move details for backup vault.
    :vartype resource_move_details: ~azure.mgmt.dataprotection.models.ResourceMoveDetails
    :ivar security_settings: Security Settings.
    :vartype security_settings: ~azure.mgmt.dataprotection.models.SecuritySettings
    :ivar storage_settings: Storage Settings. Required.
    :vartype storage_settings: list[~azure.mgmt.dataprotection.models.StorageSetting]
    :ivar is_vault_protected_by_resource_guard: Is vault protected by resource guard.
    :vartype is_vault_protected_by_resource_guard: bool
    :ivar feature_settings: Feature Settings.
    :vartype feature_settings: ~azure.mgmt.dataprotection.models.FeatureSettings
    :ivar secure_score: Secure Score of Backup Vault. Known values are: "None", "Minimum",
     "Adequate", "Maximum", and "NotSupported".
    :vartype secure_score: str or ~azure.mgmt.dataprotection.models.SecureScoreLevel
    :ivar bcdr_security_level: Security Level of Backup Vault. Known values are: "Poor", "Fair",
     "Good", "Excellent", and "NotSupported".
    :vartype bcdr_security_level: str or ~azure.mgmt.dataprotection.models.BCDRSecurityLevel
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar replicated_regions: List of replicated regions for Backup Vault.
    :vartype replicated_regions: list[str]
    """

    monitoring_settings: Optional["_models.MonitoringSettings"] = rest_field(
        name="monitoringSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Monitoring Settings."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the BackupVault resource. Known values are: \"Failed\", \"Provisioning\",
     \"Succeeded\", \"Unknown\", and \"Updating\"."""
    resource_move_state: Optional[Union[str, "_models.ResourceMoveState"]] = rest_field(
        name="resourceMoveState", visibility=["read"]
    )
    """Resource move state for backup vault. Known values are: \"Unknown\", \"InProgress\",
     \"PrepareFailed\", \"CommitFailed\", \"Failed\", \"PrepareTimedout\", \"CommitTimedout\",
     \"CriticalFailure\", \"PartialSuccess\", and \"MoveSucceeded\"."""
    resource_move_details: Optional["_models.ResourceMoveDetails"] = rest_field(
        name="resourceMoveDetails", visibility=["read"]
    )
    """Resource move details for backup vault."""
    security_settings: Optional["_models.SecuritySettings"] = rest_field(
        name="securitySettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Security Settings."""
    storage_settings: list["_models.StorageSetting"] = rest_field(
        name="storageSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage Settings. Required."""
    is_vault_protected_by_resource_guard: Optional[bool] = rest_field(
        name="isVaultProtectedByResourceGuard", visibility=["read"]
    )
    """Is vault protected by resource guard."""
    feature_settings: Optional["_models.FeatureSettings"] = rest_field(
        name="featureSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Feature Settings."""
    secure_score: Optional[Union[str, "_models.SecureScoreLevel"]] = rest_field(name="secureScore", visibility=["read"])
    """Secure Score of Backup Vault. Known values are: \"None\", \"Minimum\", \"Adequate\",
     \"Maximum\", and \"NotSupported\"."""
    bcdr_security_level: Optional[Union[str, "_models.BCDRSecurityLevel"]] = rest_field(
        name="bcdrSecurityLevel", visibility=["read"]
    )
    """Security Level of Backup Vault. Known values are: \"Poor\", \"Fair\", \"Good\", \"Excellent\",
     and \"NotSupported\"."""
    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""
    replicated_regions: Optional[list[str]] = rest_field(
        name="replicatedRegions", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of replicated regions for Backup Vault."""

    @overload
    def __init__(
        self,
        *,
        storage_settings: list["_models.StorageSetting"],
        monitoring_settings: Optional["_models.MonitoringSettings"] = None,
        security_settings: Optional["_models.SecuritySettings"] = None,
        feature_settings: Optional["_models.FeatureSettings"] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
        replicated_regions: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupVaultResource(TrackedResource):
    """Backup Vault Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: BackupVaultResource properties. Required.
    :vartype properties: ~azure.mgmt.dataprotection.models.BackupVault
    :ivar identity: Input Managed Identity Details.
    :vartype identity: ~azure.mgmt.dataprotection.models.DppIdentityDetails
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    """

    properties: "_models.BackupVault" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """BackupVaultResource properties. Required."""
    identity: Optional["_models.DppIdentityDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input Managed Identity Details."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read", "create", "update", "delete", "query"])
    """Optional ETag."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.BackupVault",
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.DppIdentityDetails"] = None,
        e_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseBackupPolicyResource(ProxyResource):
    """BaseBackupPolicy resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar properties: BaseBackupPolicyResource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.BaseBackupPolicy
    """

    properties: Optional["_models.BaseBackupPolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """BaseBackupPolicyResource properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BaseBackupPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseResourceProperties(_Model):
    """Properties which are specific to datasource/datasourceSets.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DefaultResourceProperties

    :ivar object_type: Type of the specific object - used for deserializing. Required.
     "DefaultResourceProperties"
    :vartype object_type: str or ~azure.mgmt.dataprotection.models.ResourcePropertiesObjectType
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. \"DefaultResourceProperties\""""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityRequest(_Model):
    """CheckNameAvailability Request.

    :ivar name: Resource name for which availability needs to be checked.
    :vartype name: str
    :ivar type: Describes the Resource type: Microsoft.DataProtection/BackupVaults.
    :vartype type: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name for which availability needs to be checked."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Describes the Resource type: Microsoft.DataProtection/BackupVaults."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResult(_Model):
    """CheckNameAvailability Result.

    :ivar message: Gets or sets the message.
    :vartype message: str
    :ivar name_available: Gets or sets a value indicating whether [name available].
    :vartype name_available: bool
    :ivar reason: Gets or sets the reason.
    :vartype reason: str
    """

    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the message."""
    name_available: Optional[bool] = rest_field(
        name="nameAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets a value indicating whether [name available]."""
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the reason."""

    @overload
    def __init__(
        self,
        *,
        message: Optional[str] = None,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudError(_Model):
    """An error response from Azure Backup.

    :ivar error: The resource management error response.
    :vartype error: ~azure.mgmt.dataprotection.models.Error
    """

    error: Optional["_models.Error"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource management error response."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CmkKekIdentity(_Model):
    """The details of the managed identity used for CMK.

    :ivar identity_type: The identity type. 'SystemAssigned' and 'UserAssigned' are mutually
     exclusive. 'SystemAssigned' will use implicitly created managed identity. Known values are:
     "SystemAssigned" and "UserAssigned".
    :vartype identity_type: str or ~azure.mgmt.dataprotection.models.IdentityType
    :ivar identity_id: The managed identity to be used which has access permissions to the Key
     Vault. Provide a value here in case identity types: 'UserAssigned' only.
    :vartype identity_id: str
    """

    identity_type: Optional[Union[str, "_models.IdentityType"]] = rest_field(
        name="identityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity type. 'SystemAssigned' and 'UserAssigned' are mutually exclusive. 'SystemAssigned'
     will use implicitly created managed identity. Known values are: \"SystemAssigned\" and
     \"UserAssigned\"."""
    identity_id: Optional[str] = rest_field(
        name="identityId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed identity to be used which has access permissions to the Key Vault. Provide a value
     here in case identity types: 'UserAssigned' only."""

    @overload
    def __init__(
        self,
        *,
        identity_type: Optional[Union[str, "_models.IdentityType"]] = None,
        identity_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CmkKeyVaultProperties(_Model):
    """The properties of the Key Vault which hosts CMK.

    :ivar key_uri: The key uri of the Customer Managed Key.
    :vartype key_uri: str
    """

    key_uri: Optional[str] = rest_field(name="keyUri", visibility=["read", "create", "update", "delete", "query"])
    """The key uri of the Customer Managed Key."""

    @overload
    def __init__(
        self,
        *,
        key_uri: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CopyOption(_Model):
    """Options to copy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CopyOnExpiryOption, CustomCopyOption, ImmediateCopyOption

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CopyOnExpiryOption(CopyOption, discriminator="CopyOnExpiryOption"):
    """Copy on Expiry Option.

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "CopyOnExpiryOption".
    :vartype object_type: str
    """

    object_type: Literal["CopyOnExpiryOption"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"CopyOnExpiryOption\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "CopyOnExpiryOption"  # type: ignore


class CrossRegionRestoreDetails(_Model):
    """Cross Region Restore details.

    :ivar source_region: Required.
    :vartype source_region: str
    :ivar source_backup_instance_id: Required.
    :vartype source_backup_instance_id: str
    """

    source_region: str = rest_field(name="sourceRegion", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    source_backup_instance_id: str = rest_field(
        name="sourceBackupInstanceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        source_region: str,
        source_backup_instance_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CrossRegionRestoreJobRequest(_Model):
    """Details of CRR Job to be fetched.

    :ivar source_region: Required.
    :vartype source_region: str
    :ivar source_backup_vault_id: Required.
    :vartype source_backup_vault_id: str
    :ivar job_id: Required.
    :vartype job_id: str
    """

    source_region: str = rest_field(name="sourceRegion", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    source_backup_vault_id: str = rest_field(
        name="sourceBackupVaultId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    job_id: str = rest_field(name="jobId", visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        source_region: str,
        source_backup_vault_id: str,
        job_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CrossRegionRestoreJobsRequest(_Model):
    """Details of Backup Vault for which CRR Jobs are to be fetched.

    :ivar source_region: Required.
    :vartype source_region: str
    :ivar source_backup_vault_id: Required.
    :vartype source_backup_vault_id: str
    """

    source_region: str = rest_field(name="sourceRegion", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    source_backup_vault_id: str = rest_field(
        name="sourceBackupVaultId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        source_region: str,
        source_backup_vault_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CrossRegionRestoreRequestObject(_Model):
    """Cross Region Restore Request Object.

    :ivar restore_request_object: Gets or sets the restore request object. Required.
    :vartype restore_request_object: ~azure.mgmt.dataprotection.models.AzureBackupRestoreRequest
    :ivar cross_region_restore_details: Cross region restore details. Required.
    :vartype cross_region_restore_details:
     ~azure.mgmt.dataprotection.models.CrossRegionRestoreDetails
    """

    restore_request_object: "_models.AzureBackupRestoreRequest" = rest_field(
        name="restoreRequestObject", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the restore request object. Required."""
    cross_region_restore_details: "_models.CrossRegionRestoreDetails" = rest_field(
        name="crossRegionRestoreDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cross region restore details. Required."""

    @overload
    def __init__(
        self,
        *,
        restore_request_object: "_models.AzureBackupRestoreRequest",
        cross_region_restore_details: "_models.CrossRegionRestoreDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CrossRegionRestoreSettings(_Model):
    """CrossRegionRestoreSettings.

    :ivar state: CrossRegionRestore state. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.dataprotection.models.CrossRegionRestoreState
    """

    state: Optional[Union[str, "_models.CrossRegionRestoreState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """CrossRegionRestore state. Known values are: \"Disabled\" and \"Enabled\"."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.CrossRegionRestoreState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CrossSubscriptionRestoreSettings(_Model):
    """CrossSubscriptionRestore Settings.

    :ivar state: CrossSubscriptionRestore state. Known values are: "Disabled",
     "PermanentlyDisabled", and "Enabled".
    :vartype state: str or ~azure.mgmt.dataprotection.models.CrossSubscriptionRestoreState
    """

    state: Optional[Union[str, "_models.CrossSubscriptionRestoreState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """CrossSubscriptionRestore state. Known values are: \"Disabled\", \"PermanentlyDisabled\", and
     \"Enabled\"."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.CrossSubscriptionRestoreState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomCopyOption(CopyOption, discriminator="CustomCopyOption"):
    """Duration based custom options to copy.

    :ivar duration: Data copied after given timespan.
    :vartype duration: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "CustomCopyOption".
    :vartype object_type: str
    """

    duration: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Data copied after given timespan."""
    object_type: Literal["CustomCopyOption"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"CustomCopyOption\"."""

    @overload
    def __init__(
        self,
        *,
        duration: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "CustomCopyOption"  # type: ignore


class Datasource(_Model):
    """Datasource to be backed up.

    :ivar datasource_type: DatasourceType of the resource.
    :vartype datasource_type: str
    :ivar object_type: Type of Datasource object, used to initialize the right inherited type.
    :vartype object_type: str
    :ivar resource_id: Full ARM ID of the resource. For azure resources, this is ARM ID. For non
     azure resources, this will be the ID created by backup service via Fabric/Vault. Required.
    :vartype resource_id: str
    :ivar resource_location: Location of datasource.
    :vartype resource_location: str
    :ivar resource_name: Unique identifier of the resource in the context of parent.
    :vartype resource_name: str
    :ivar resource_type: Resource Type of Datasource.
    :vartype resource_type: str
    :ivar resource_uri: Uri of the resource.
    :vartype resource_uri: str
    :ivar resource_properties: Properties specific to data source.
    :vartype resource_properties: ~azure.mgmt.dataprotection.models.BaseResourceProperties
    """

    datasource_type: Optional[str] = rest_field(
        name="datasourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """DatasourceType of the resource."""
    object_type: Optional[str] = rest_field(
        name="objectType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of Datasource object, used to initialize the right inherited type."""
    resource_id: str = rest_field(name="resourceID", visibility=["read", "create", "update", "delete", "query"])
    """Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this
     will be the ID created by backup service via Fabric/Vault. Required."""
    resource_location: Optional[str] = rest_field(
        name="resourceLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Location of datasource."""
    resource_name: Optional[str] = rest_field(
        name="resourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unique identifier of the resource in the context of parent."""
    resource_type: Optional[str] = rest_field(
        name="resourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Type of Datasource."""
    resource_uri: Optional[str] = rest_field(
        name="resourceUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """Uri of the resource."""
    resource_properties: Optional["_models.BaseResourceProperties"] = rest_field(
        name="resourceProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties specific to data source."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
        datasource_type: Optional[str] = None,
        object_type: Optional[str] = None,
        resource_location: Optional[str] = None,
        resource_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_uri: Optional[str] = None,
        resource_properties: Optional["_models.BaseResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DatasourceSet(_Model):
    """DatasourceSet details of datasource to be backed up.

    :ivar datasource_type: DatasourceType of the resource.
    :vartype datasource_type: str
    :ivar object_type: Type of Datasource object, used to initialize the right inherited type.
    :vartype object_type: str
    :ivar resource_id: Full ARM ID of the resource. For azure resources, this is ARM ID. For non
     azure resources, this will be the ID created by backup service via Fabric/Vault. Required.
    :vartype resource_id: str
    :ivar resource_location: Location of datasource.
    :vartype resource_location: str
    :ivar resource_name: Unique identifier of the resource in the context of parent.
    :vartype resource_name: str
    :ivar resource_type: Resource Type of Datasource.
    :vartype resource_type: str
    :ivar resource_uri: Uri of the resource.
    :vartype resource_uri: str
    :ivar resource_properties: Properties specific to data source set.
    :vartype resource_properties: ~azure.mgmt.dataprotection.models.BaseResourceProperties
    """

    datasource_type: Optional[str] = rest_field(
        name="datasourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """DatasourceType of the resource."""
    object_type: Optional[str] = rest_field(
        name="objectType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of Datasource object, used to initialize the right inherited type."""
    resource_id: str = rest_field(name="resourceID", visibility=["read", "create", "update", "delete", "query"])
    """Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this
     will be the ID created by backup service via Fabric/Vault. Required."""
    resource_location: Optional[str] = rest_field(
        name="resourceLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Location of datasource."""
    resource_name: Optional[str] = rest_field(
        name="resourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unique identifier of the resource in the context of parent."""
    resource_type: Optional[str] = rest_field(
        name="resourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Type of Datasource."""
    resource_uri: Optional[str] = rest_field(
        name="resourceUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """Uri of the resource."""
    resource_properties: Optional["_models.BaseResourceProperties"] = rest_field(
        name="resourceProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties specific to data source set."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
        datasource_type: Optional[str] = None,
        object_type: Optional[str] = None,
        resource_location: Optional[str] = None,
        resource_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_uri: Optional[str] = None,
        resource_properties: Optional["_models.BaseResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataStoreInfoBase(_Model):
    """DataStoreInfo base.

    :ivar data_store_type: type of datastore; Operational/Vault/Archive. Required. Known values
     are: "OperationalStore", "VaultStore", and "ArchiveStore".
    :vartype data_store_type: str or ~azure.mgmt.dataprotection.models.DataStoreTypes
    :ivar object_type: Type of Datasource object, used to initialize the right inherited type.
     Required.
    :vartype object_type: str
    """

    data_store_type: Union[str, "_models.DataStoreTypes"] = rest_field(
        name="dataStoreType", visibility=["read", "create", "update", "delete", "query"]
    )
    """type of datastore; Operational/Vault/Archive. Required. Known values are: \"OperationalStore\",
     \"VaultStore\", and \"ArchiveStore\"."""
    object_type: str = rest_field(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of Datasource object, used to initialize the right inherited type. Required."""

    @overload
    def __init__(
        self,
        *,
        data_store_type: Union[str, "_models.DataStoreTypes"],
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Day(_Model):
    """Day of the week.

    :ivar date: Date of the month.
    :vartype date: int
    :ivar is_last: Whether Date is last date of month.
    :vartype is_last: bool
    """

    date: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Date of the month."""
    is_last: Optional[bool] = rest_field(name="isLast", visibility=["read", "create", "update", "delete", "query"])
    """Whether Date is last date of month."""

    @overload
    def __init__(
        self,
        *,
        date: Optional[int] = None,
        is_last: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DefaultResourceProperties(BaseResourceProperties, discriminator="DefaultResourceProperties"):
    """Default source properties.

    :ivar object_type: Type of the specific object - used for deserializing. Required.
    :vartype object_type: str or ~azure.mgmt.dataprotection.models.DEFAULT_RESOURCE_PROPERTIES
    """

    object_type: Literal[ResourcePropertiesObjectType.DEFAULT_RESOURCE_PROPERTIES] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = ResourcePropertiesObjectType.DEFAULT_RESOURCE_PROPERTIES  # type: ignore


class DeletedBackupInstance(BackupInstance):
    """Deleted Backup Instance.

    :ivar friendly_name: Gets or sets the Backup Instance friendly name.
    :vartype friendly_name: str
    :ivar data_source_info: Gets or sets the data source information. Required.
    :vartype data_source_info: ~azure.mgmt.dataprotection.models.Datasource
    :ivar data_source_set_info: Gets or sets the data source set information.
    :vartype data_source_set_info: ~azure.mgmt.dataprotection.models.DatasourceSet
    :ivar policy_info: Gets or sets the policy information. Required.
    :vartype policy_info: ~azure.mgmt.dataprotection.models.PolicyInfo
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar protection_status: Specifies the protection status of the resource.
    :vartype protection_status: ~azure.mgmt.dataprotection.models.ProtectionStatusDetails
    :ivar current_protection_state: Specifies the current protection state of the resource. Known
     values are: "Invalid", "NotProtected", "ConfiguringProtection", "ProtectionConfigured",
     "BackupSchedulesSuspended", "RetentionSchedulesSuspended", "ProtectionStopped",
     "ProtectionError", "ConfiguringProtectionFailed", "SoftDeleting", "SoftDeleted", and
     "UpdatingProtection".
    :vartype current_protection_state: str or
     ~azure.mgmt.dataprotection.models.CurrentProtectionState
    :ivar protection_error_details: Specifies the protection error of the resource.
    :vartype protection_error_details: ~azure.mgmt.dataprotection.models.UserFacingError
    :ivar provisioning_state: Specifies the provisioning state of the resource i.e.
     provisioning/updating/Succeeded/Failed.
    :vartype provisioning_state: str
    :ivar datasource_auth_credentials: Credentials to use to authenticate with data source
     provider.
    :vartype datasource_auth_credentials: ~azure.mgmt.dataprotection.models.AuthCredentials
    :ivar validation_type: Specifies the type of validation. In case of DeepValidation, all
     validations from /validateForBackup API will run again. Known values are: "ShallowValidation"
     and "DeepValidation".
    :vartype validation_type: str or ~azure.mgmt.dataprotection.models.ValidationType
    :ivar identity_details: Contains information of the Identity Details for the BI.
     If it is null, default will be considered as System Assigned.
    :vartype identity_details: ~azure.mgmt.dataprotection.models.IdentityDetails
    :ivar object_type: Required.
    :vartype object_type: str
    :ivar deletion_info: Deletion info of Backup Instance.
    :vartype deletion_info: ~azure.mgmt.dataprotection.models.DeletionInfo
    """

    deletion_info: Optional["_models.DeletionInfo"] = rest_field(name="deletionInfo", visibility=["read"])
    """Deletion info of Backup Instance."""

    @overload
    def __init__(
        self,
        *,
        data_source_info: "_models.Datasource",
        policy_info: "_models.PolicyInfo",
        object_type: str,
        friendly_name: Optional[str] = None,
        data_source_set_info: Optional["_models.DatasourceSet"] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
        datasource_auth_credentials: Optional["_models.AuthCredentials"] = None,
        validation_type: Optional[Union[str, "_models.ValidationType"]] = None,
        identity_details: Optional["_models.IdentityDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedBackupInstanceResource(ProxyResource):
    """Deleted Backup Instance.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar properties: DeletedBackupInstanceResource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.DeletedBackupInstance
    """

    properties: Optional["_models.DeletedBackupInstance"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """DeletedBackupInstanceResource properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DeletedBackupInstance"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletionInfo(_Model):
    """Deletion Info.

    :ivar deletion_time: Specifies time of deletion.
    :vartype deletion_time: str
    :ivar billing_end_date: Specifies billing end date.
    :vartype billing_end_date: str
    :ivar scheduled_purge_time: Specifies purge time.
    :vartype scheduled_purge_time: str
    :ivar delete_activity_id: Delete activity ID for troubleshooting purpose.
    :vartype delete_activity_id: str
    """

    deletion_time: Optional[str] = rest_field(name="deletionTime", visibility=["read"])
    """Specifies time of deletion."""
    billing_end_date: Optional[str] = rest_field(name="billingEndDate", visibility=["read"])
    """Specifies billing end date."""
    scheduled_purge_time: Optional[str] = rest_field(name="scheduledPurgeTime", visibility=["read"])
    """Specifies purge time."""
    delete_activity_id: Optional[str] = rest_field(name="deleteActivityID", visibility=["read"])
    """Delete activity ID for troubleshooting purpose."""


class DppBaseResource(ProxyResource):
    """Base resource under Microsoft.DataProtection provider namespace.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    """


class DppIdentityDetails(_Model):
    """Identity details.

    :ivar principal_id: The object ID of the service principal object for the managed identity that
     is used to grant role-based access to an Azure resource.
    :vartype principal_id: str
    :ivar tenant_id: A Globally Unique Identifier (GUID) that represents the Azure AD tenant where
     the resource is now a member.
    :vartype tenant_id: str
    :ivar type: The identityType which can be either SystemAssigned, UserAssigned,
     'SystemAssigned,UserAssigned' or None.
    :vartype type: str
    :ivar user_assigned_identities: Gets or sets the user assigned identities.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.dataprotection.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The object ID of the service principal object for the managed identity that is used to grant
     role-based access to an Azure resource."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """A Globally Unique Identifier (GUID) that represents the Azure AD tenant where the resource is
     now a member."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identityType which can be either SystemAssigned, UserAssigned,
     'SystemAssigned,UserAssigned' or None."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the user assigned identities."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[str] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DppResourceList(_Model):
    """ListResource.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    """

    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """The uri to fetch the next page of resources. Call ListNext() fetches next page of resources."""

    @overload
    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DppTrackedResourceList(_Model):
    """DppTrackedResourceList.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    """

    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """The uri to fetch the next page of resources. Call ListNext() fetches next page of resources."""

    @overload
    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionSettings(_Model):
    """Customer Managed Key details of the resource.

    :ivar state: Encryption state of the Backup Vault. Known values are: "Enabled", "Disabled", and
     "Inconsistent".
    :vartype state: str or ~azure.mgmt.dataprotection.models.EncryptionState
    :ivar key_vault_properties: The properties of the Key Vault which hosts CMK.
    :vartype key_vault_properties: ~azure.mgmt.dataprotection.models.CmkKeyVaultProperties
    :ivar kek_identity: The details of the managed identity used for CMK.
    :vartype kek_identity: ~azure.mgmt.dataprotection.models.CmkKekIdentity
    :ivar infrastructure_encryption: Enabling/Disabling the Double Encryption state. Known values
     are: "Enabled" and "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.dataprotection.models.InfrastructureEncryptionState
    """

    state: Optional[Union[str, "_models.EncryptionState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption state of the Backup Vault. Known values are: \"Enabled\", \"Disabled\", and
     \"Inconsistent\"."""
    key_vault_properties: Optional["_models.CmkKeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the Key Vault which hosts CMK."""
    kek_identity: Optional["_models.CmkKekIdentity"] = rest_field(
        name="kekIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The details of the managed identity used for CMK."""
    infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryptionState"]] = rest_field(
        name="infrastructureEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enabling/Disabling the Double Encryption state. Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.EncryptionState"]] = None,
        key_vault_properties: Optional["_models.CmkKeyVaultProperties"] = None,
        kek_identity: Optional["_models.CmkKekIdentity"] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryptionState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Error(_Model):
    """The resource management error response.

    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dataprotection.models.ErrorAdditionalInfo]
    :ivar code: The error code.
    :vartype code: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dataprotection.models.Error]
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    """

    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""
    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    details: Optional[list["_models.Error"]] = rest_field(visibility=["read"])
    """The error details."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dataprotection.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dataprotection.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.dataprotection.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportJobsResult(_Model):
    """The result for export jobs containing blob details.

    :ivar blob_url: URL of the blob into which the serialized string of list of jobs is exported.
    :vartype blob_url: str
    :ivar blob_sas_key: SAS key to access the blob.
    :vartype blob_sas_key: str
    :ivar excel_file_blob_url: URL of the blob into which the ExcelFile is uploaded.
    :vartype excel_file_blob_url: str
    :ivar excel_file_blob_sas_key: SAS key to access the ExcelFile blob.
    :vartype excel_file_blob_sas_key: str
    """

    blob_url: Optional[str] = rest_field(name="blobUrl", visibility=["read"])
    """URL of the blob into which the serialized string of list of jobs is exported."""
    blob_sas_key: Optional[str] = rest_field(name="blobSasKey", visibility=["read"])
    """SAS key to access the blob."""
    excel_file_blob_url: Optional[str] = rest_field(name="excelFileBlobUrl", visibility=["read"])
    """URL of the blob into which the ExcelFile is uploaded."""
    excel_file_blob_sas_key: Optional[str] = rest_field(name="excelFileBlobSasKey", visibility=["read"])
    """SAS key to access the ExcelFile blob."""


class FeatureSettings(_Model):
    """Class containing feature settings of vault.

    :ivar cross_subscription_restore_settings: CrossSubscriptionRestore Settings.
    :vartype cross_subscription_restore_settings:
     ~azure.mgmt.dataprotection.models.CrossSubscriptionRestoreSettings
    :ivar cross_region_restore_settings:
    :vartype cross_region_restore_settings:
     ~azure.mgmt.dataprotection.models.CrossRegionRestoreSettings
    """

    cross_subscription_restore_settings: Optional["_models.CrossSubscriptionRestoreSettings"] = rest_field(
        name="crossSubscriptionRestoreSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """CrossSubscriptionRestore Settings."""
    cross_region_restore_settings: Optional["_models.CrossRegionRestoreSettings"] = rest_field(
        name="crossRegionRestoreSettings", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        cross_subscription_restore_settings: Optional["_models.CrossSubscriptionRestoreSettings"] = None,
        cross_region_restore_settings: Optional["_models.CrossRegionRestoreSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FeatureValidationRequestBase(_Model):
    """Base class for Backup Feature support.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FeatureValidationRequest

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FeatureValidationRequest(FeatureValidationRequestBase, discriminator="FeatureValidationRequest"):
    """Base class for feature object.

    :ivar feature_type: backup support feature type. Known values are: "Invalid" and
     "DataSourceType".
    :vartype feature_type: str or ~azure.mgmt.dataprotection.models.FeatureType
    :ivar feature_name: backup support feature name.
    :vartype feature_name: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "FeatureValidationRequest".
    :vartype object_type: str
    """

    feature_type: Optional[Union[str, "_models.FeatureType"]] = rest_field(
        name="featureType", visibility=["read", "create", "update", "delete", "query"]
    )
    """backup support feature type. Known values are: \"Invalid\" and \"DataSourceType\"."""
    feature_name: Optional[str] = rest_field(
        name="featureName", visibility=["read", "create", "update", "delete", "query"]
    )
    """backup support feature name."""
    object_type: Literal["FeatureValidationRequest"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"FeatureValidationRequest\"."""

    @overload
    def __init__(
        self,
        *,
        feature_type: Optional[Union[str, "_models.FeatureType"]] = None,
        feature_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "FeatureValidationRequest"  # type: ignore


class FeatureValidationResponseBase(_Model):
    """Base class for Backup Feature support.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FeatureValidationResponse

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FeatureValidationResponse(FeatureValidationResponseBase, discriminator="FeatureValidationResponse"):
    """Feature Validation Response.

    :ivar feature_type: backup support feature type. Known values are: "Invalid" and
     "DataSourceType".
    :vartype feature_type: str or ~azure.mgmt.dataprotection.models.FeatureType
    :ivar features: Response features.
    :vartype features: list[~azure.mgmt.dataprotection.models.SupportedFeature]
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "FeatureValidationResponse".
    :vartype object_type: str
    """

    feature_type: Optional[Union[str, "_models.FeatureType"]] = rest_field(
        name="featureType", visibility=["read", "create", "update", "delete", "query"]
    )
    """backup support feature type. Known values are: \"Invalid\" and \"DataSourceType\"."""
    features: Optional[list["_models.SupportedFeature"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response features."""
    object_type: Literal["FeatureValidationResponse"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"FeatureValidationResponse\"."""

    @overload
    def __init__(
        self,
        *,
        feature_type: Optional[Union[str, "_models.FeatureType"]] = None,
        features: Optional[list["_models.SupportedFeature"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "FeatureValidationResponse"  # type: ignore


class FetchSecondaryRPsRequestParameters(_Model):
    """Information about BI whose secondary RecoveryPoints are requested
    Source region and
    BI ARM path.

    :ivar source_region: Source region in which BackupInstance is located.
    :vartype source_region: str
    :ivar source_backup_instance_id: ARM Path of BackupInstance.
    :vartype source_backup_instance_id: str
    """

    source_region: Optional[str] = rest_field(
        name="sourceRegion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source region in which BackupInstance is located."""
    source_backup_instance_id: Optional[str] = rest_field(
        name="sourceBackupInstanceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM Path of BackupInstance."""

    @overload
    def __init__(
        self,
        *,
        source_region: Optional[str] = None,
        source_backup_instance_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IdentityDetails(_Model):
    """IdentityDetails.

    :ivar use_system_assigned_identity: Specifies if the BI is protected by System Identity.
    :vartype use_system_assigned_identity: bool
    :ivar user_assigned_identity_arm_url: ARM URL for User Assigned Identity.
    :vartype user_assigned_identity_arm_url: str
    """

    use_system_assigned_identity: Optional[bool] = rest_field(
        name="useSystemAssignedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies if the BI is protected by System Identity."""
    user_assigned_identity_arm_url: Optional[str] = rest_field(
        name="userAssignedIdentityArmUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM URL for User Assigned Identity."""

    @overload
    def __init__(
        self,
        *,
        use_system_assigned_identity: Optional[bool] = None,
        user_assigned_identity_arm_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImmediateCopyOption(CopyOption, discriminator="ImmediateCopyOption"):
    """Immediate copy Option.

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "ImmediateCopyOption".
    :vartype object_type: str
    """

    object_type: Literal["ImmediateCopyOption"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"ImmediateCopyOption\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "ImmediateCopyOption"  # type: ignore


class ImmutabilitySettings(_Model):
    """Immutability Settings at vault level.

    :ivar state: Immutability state. Known values are: "Disabled", "Unlocked", and "Locked".
    :vartype state: str or ~azure.mgmt.dataprotection.models.ImmutabilityState
    """

    state: Optional[Union[str, "_models.ImmutabilityState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Immutability state. Known values are: \"Disabled\", \"Unlocked\", and \"Locked\"."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.ImmutabilityState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InnerError(_Model):
    """Inner Error.

    :ivar additional_info: Any Key value pairs that can be provided to the client for additional
     verbose information.
    :vartype additional_info: dict[str, str]
    :ivar code: Unique code for this error.
    :vartype code: str
    :ivar embedded_inner_error: Child Inner Error, to allow Nesting.
    :vartype embedded_inner_error: ~azure.mgmt.dataprotection.models.InnerError
    """

    additional_info: Optional[dict[str, str]] = rest_field(
        name="additionalInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Any Key value pairs that can be provided to the client for additional  verbose information."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique code for this error."""
    embedded_inner_error: Optional["_models.InnerError"] = rest_field(
        name="embeddedInnerError", visibility=["read", "create", "update", "delete", "query"]
    )
    """Child Inner Error, to allow Nesting."""

    @overload
    def __init__(
        self,
        *,
        additional_info: Optional[dict[str, str]] = None,
        code: Optional[str] = None,
        embedded_inner_error: Optional["_models.InnerError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ItemLevelRestoreCriteria(_Model):
    """Class to contain criteria for item level restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ItemPathBasedRestoreCriteria, KubernetesClusterRestoreCriteria,
    KubernetesClusterVaultTierRestoreCriteria, KubernetesPVRestoreCriteria,
    KubernetesStorageClassRestoreCriteria, RangeBasedItemLevelRestoreCriteria

    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of the specific object - used for deserializing. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestoreTargetInfoBase(_Model):
    """Base class common to RestoreTargetInfo and RestoreFilesTargetInfo.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ItemLevelRestoreTargetInfo, RestoreFilesTargetInfo, RestoreTargetInfo

    :ivar object_type: Type of Datasource object, used to initialize the right inherited type.
     Required. Default value is None.
    :vartype object_type: str
    :ivar recovery_option: Recovery Option. Required. "FailIfExists"
    :vartype recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :ivar restore_location: Target Restore region.
    :vartype restore_location: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """Type of Datasource object, used to initialize the right inherited type. Required. Default value
     is None."""
    recovery_option: Union[str, "_models.RecoveryOption"] = rest_field(
        name="recoveryOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Recovery Option. Required. \"FailIfExists\""""
    restore_location: Optional[str] = rest_field(
        name="restoreLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Target Restore region."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
        recovery_option: Union[str, "_models.RecoveryOption"],
        restore_location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ItemLevelRestoreTargetInfo(RestoreTargetInfoBase, discriminator="ItemLevelRestoreTargetInfo"):
    """Restore target info for Item level restore operation.

    :ivar recovery_option: Recovery Option. Required. "FailIfExists"
    :vartype recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :ivar restore_location: Target Restore region.
    :vartype restore_location: str
    :ivar restore_criteria: Restore Criteria. Required.
    :vartype restore_criteria: list[~azure.mgmt.dataprotection.models.ItemLevelRestoreCriteria]
    :ivar datasource_info: Information of target DS. Required.
    :vartype datasource_info: ~azure.mgmt.dataprotection.models.Datasource
    :ivar datasource_set_info: Information of target DS Set.
    :vartype datasource_set_info: ~azure.mgmt.dataprotection.models.DatasourceSet
    :ivar datasource_auth_credentials: Credentials to use to authenticate with data source
     provider.
    :vartype datasource_auth_credentials: ~azure.mgmt.dataprotection.models.AuthCredentials
    :ivar object_type: Type of Datasource object, used to initialize the right inherited type.
     Required. Default value is "ItemLevelRestoreTargetInfo".
    :vartype object_type: str
    """

    restore_criteria: list["_models.ItemLevelRestoreCriteria"] = rest_field(
        name="restoreCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """Restore Criteria. Required."""
    datasource_info: "_models.Datasource" = rest_field(
        name="datasourceInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information of target DS. Required."""
    datasource_set_info: Optional["_models.DatasourceSet"] = rest_field(
        name="datasourceSetInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information of target DS Set."""
    datasource_auth_credentials: Optional["_models.AuthCredentials"] = rest_field(
        name="datasourceAuthCredentials", visibility=["read", "create", "update", "delete", "query"]
    )
    """Credentials to use to authenticate with data source provider."""
    object_type: Literal["ItemLevelRestoreTargetInfo"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of Datasource object, used to initialize the right inherited type. Required. Default value
     is \"ItemLevelRestoreTargetInfo\"."""

    @overload
    def __init__(
        self,
        *,
        recovery_option: Union[str, "_models.RecoveryOption"],
        restore_criteria: list["_models.ItemLevelRestoreCriteria"],
        datasource_info: "_models.Datasource",
        restore_location: Optional[str] = None,
        datasource_set_info: Optional["_models.DatasourceSet"] = None,
        datasource_auth_credentials: Optional["_models.AuthCredentials"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "ItemLevelRestoreTargetInfo"  # type: ignore


class ItemPathBasedRestoreCriteria(ItemLevelRestoreCriteria, discriminator="ItemPathBasedRestoreCriteria"):
    """Prefix criteria to be used to during restore.

    :ivar item_path: The path of the item to be restored. It could be the full path of the item or
     the path relative to the backup item. Required.
    :vartype item_path: str
    :ivar is_path_relative_to_backup_item: Flag to specify if the path is relative to backup item
     or full path. Required.
    :vartype is_path_relative_to_backup_item: bool
    :ivar sub_item_path_prefix: The list of prefix strings to be used as filter criteria during
     restore. These are relative to the item path specified.
    :vartype sub_item_path_prefix: list[str]
    :ivar rename_to: Rename the item to be restored. Restore will rename the itemPath to this new
     name if the value is specified otherwise the itemPath will be restored as same name.
    :vartype rename_to: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "ItemPathBasedRestoreCriteria".
    :vartype object_type: str
    """

    item_path: str = rest_field(name="itemPath", visibility=["read", "create", "update", "delete", "query"])
    """The path of the item to be restored. It could be the full path of the item or the path relative
     to the backup item. Required."""
    is_path_relative_to_backup_item: bool = rest_field(
        name="isPathRelativeToBackupItem", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag to specify if the path is relative to backup item or full path. Required."""
    sub_item_path_prefix: Optional[list[str]] = rest_field(
        name="subItemPathPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of prefix strings to be used as filter criteria during restore. These are relative to
     the item path specified."""
    rename_to: Optional[str] = rest_field(name="renameTo", visibility=["read", "create", "update", "delete", "query"])
    """Rename the item to be restored. Restore will rename the itemPath to this new name if the value
     is specified otherwise the itemPath will be restored as same name."""
    object_type: Literal["ItemPathBasedRestoreCriteria"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"ItemPathBasedRestoreCriteria\"."""

    @overload
    def __init__(
        self,
        *,
        item_path: str,
        is_path_relative_to_backup_item: bool,
        sub_item_path_prefix: Optional[list[str]] = None,
        rename_to: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "ItemPathBasedRestoreCriteria"  # type: ignore


class JobExtendedInfo(_Model):
    """Extended Information about the job.

    :ivar additional_details: Job's Additional Details.
    :vartype additional_details: dict[str, str]
    :ivar backup_instance_state: State of the Backup Instance.
    :vartype backup_instance_state: str
    :ivar data_transferred_in_bytes: Number of bytes transferred.
    :vartype data_transferred_in_bytes: float
    :ivar recovery_destination: Destination where restore is done.
    :vartype recovery_destination: str
    :ivar source_recover_point: Details of the Source Recovery Point.
    :vartype source_recover_point: ~azure.mgmt.dataprotection.models.RestoreJobRecoveryPointDetails
    :ivar sub_tasks: List of Sub Tasks of the job.
    :vartype sub_tasks: list[~azure.mgmt.dataprotection.models.JobSubTask]
    :ivar target_recover_point: Details of the Target Recovery Point.
    :vartype target_recover_point: ~azure.mgmt.dataprotection.models.RestoreJobRecoveryPointDetails
    :ivar warning_details: A List, detailing the warnings related to the job.
    :vartype warning_details: list[~azure.mgmt.dataprotection.models.UserFacingWarningDetail]
    """

    additional_details: Optional[dict[str, str]] = rest_field(
        name="additionalDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Job's Additional Details."""
    backup_instance_state: Optional[str] = rest_field(name="backupInstanceState", visibility=["read"])
    """State of the Backup Instance."""
    data_transferred_in_bytes: Optional[float] = rest_field(name="dataTransferredInBytes", visibility=["read"])
    """Number of bytes transferred."""
    recovery_destination: Optional[str] = rest_field(name="recoveryDestination", visibility=["read"])
    """Destination where restore is done."""
    source_recover_point: Optional["_models.RestoreJobRecoveryPointDetails"] = rest_field(
        name="sourceRecoverPoint", visibility=["read"]
    )
    """Details of the Source Recovery Point."""
    sub_tasks: Optional[list["_models.JobSubTask"]] = rest_field(name="subTasks", visibility=["read"])
    """List of Sub Tasks of the job."""
    target_recover_point: Optional["_models.RestoreJobRecoveryPointDetails"] = rest_field(
        name="targetRecoverPoint", visibility=["read"]
    )
    """Details of the Target Recovery Point."""
    warning_details: Optional[list["_models.UserFacingWarningDetail"]] = rest_field(
        name="warningDetails", visibility=["read"]
    )
    """A List, detailing the warnings related to the job."""

    @overload
    def __init__(
        self,
        *,
        additional_details: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobSubTask(_Model):
    """Details of Job's Sub Task.

    :ivar additional_details: Additional details of Sub Tasks.
    :vartype additional_details: dict[str, str]
    :ivar task_id: Task Id of the Sub Task. Required.
    :vartype task_id: int
    :ivar task_name: Name of the Sub Task. Required.
    :vartype task_name: str
    :ivar task_progress: Progress of the Sub Task.
    :vartype task_progress: str
    :ivar task_status: Status of the Sub Task. Required.
    :vartype task_status: str
    """

    additional_details: Optional[dict[str, str]] = rest_field(
        name="additionalDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional details of Sub Tasks."""
    task_id: int = rest_field(name="taskId", visibility=["read", "create", "update", "delete", "query"])
    """Task Id of the Sub Task. Required."""
    task_name: str = rest_field(name="taskName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the Sub Task. Required."""
    task_progress: Optional[str] = rest_field(name="taskProgress", visibility=["read"])
    """Progress of the Sub Task."""
    task_status: str = rest_field(name="taskStatus", visibility=["read", "create", "update", "delete", "query"])
    """Status of the Sub Task. Required."""

    @overload
    def __init__(
        self,
        *,
        task_id: int,
        task_name: str,
        task_status: str,
        additional_details: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KubernetesClusterBackupDatasourceParameters(
    BackupDatasourceParameters, discriminator="KubernetesClusterBackupDatasourceParameters"
):  # pylint: disable=name-too-long
    """Parameters for Kubernetes Cluster Backup Datasource.

    :ivar snapshot_volumes: Gets or sets the volume snapshot property. This property if enabled
     will take volume snapshots during backup. Required.
    :vartype snapshot_volumes: bool
    :ivar included_volume_types: Gets or sets the include volume types property. This property sets
     the volume types to be included during backup.
    :vartype included_volume_types: list[str or ~azure.mgmt.dataprotection.models.AKSVolumeTypes]
    :ivar include_cluster_scope_resources: Gets or sets the include cluster resources property.
     This property if enabled will include cluster scope resources during backup. Required.
    :vartype include_cluster_scope_resources: bool
    :ivar included_namespaces: Gets or sets the include namespaces property. This property sets the
     namespaces to be included during backup.
    :vartype included_namespaces: list[str]
    :ivar excluded_namespaces: Gets or sets the exclude namespaces property. This property sets the
     namespaces to be excluded during backup.
    :vartype excluded_namespaces: list[str]
    :ivar included_resource_types: Gets or sets the include resource types property. This property
     sets the resource types to be included during backup.
    :vartype included_resource_types: list[str]
    :ivar excluded_resource_types: Gets or sets the exclude resource types property. This property
     sets the resource types to be excluded during backup.
    :vartype excluded_resource_types: list[str]
    :ivar label_selectors: Gets or sets the LabelSelectors property. This property sets the
     resource with such label selectors to be included during backup.
    :vartype label_selectors: list[str]
    :ivar backup_hook_references: Gets or sets the backup hook references. This property sets the
     hook reference to be executed during backup.
    :vartype backup_hook_references: list[~azure.mgmt.dataprotection.models.NamespacedNameResource]
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "KubernetesClusterBackupDatasourceParameters".
    :vartype object_type: str
    """

    snapshot_volumes: bool = rest_field(
        name="snapshotVolumes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the volume snapshot property. This property if enabled will take volume snapshots
     during backup. Required."""
    included_volume_types: Optional[list[Union[str, "_models.AKSVolumeTypes"]]] = rest_field(
        name="includedVolumeTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include volume types property. This property sets the volume types to be
     included during backup."""
    include_cluster_scope_resources: bool = rest_field(
        name="includeClusterScopeResources", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include cluster resources property. This property if enabled will include
     cluster scope resources during backup. Required."""
    included_namespaces: Optional[list[str]] = rest_field(
        name="includedNamespaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include namespaces property. This property sets the namespaces to be included
     during backup."""
    excluded_namespaces: Optional[list[str]] = rest_field(
        name="excludedNamespaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded
     during backup."""
    included_resource_types: Optional[list[str]] = rest_field(
        name="includedResourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include resource types property. This property sets the resource types to be
     included during backup."""
    excluded_resource_types: Optional[list[str]] = rest_field(
        name="excludedResourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the exclude resource types property. This property sets the resource types to be
     excluded during backup."""
    label_selectors: Optional[list[str]] = rest_field(
        name="labelSelectors", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the LabelSelectors property. This property sets the resource with such label
     selectors to be included during backup."""
    backup_hook_references: Optional[list["_models.NamespacedNameResource"]] = rest_field(
        name="backupHookReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the backup hook references. This property sets the hook reference to be executed
     during backup."""
    object_type: Literal["KubernetesClusterBackupDatasourceParameters"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"KubernetesClusterBackupDatasourceParameters\"."""

    @overload
    def __init__(
        self,
        *,
        snapshot_volumes: bool,
        include_cluster_scope_resources: bool,
        included_volume_types: Optional[list[Union[str, "_models.AKSVolumeTypes"]]] = None,
        included_namespaces: Optional[list[str]] = None,
        excluded_namespaces: Optional[list[str]] = None,
        included_resource_types: Optional[list[str]] = None,
        excluded_resource_types: Optional[list[str]] = None,
        label_selectors: Optional[list[str]] = None,
        backup_hook_references: Optional[list["_models.NamespacedNameResource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "KubernetesClusterBackupDatasourceParameters"  # type: ignore


class KubernetesClusterRestoreCriteria(ItemLevelRestoreCriteria, discriminator="KubernetesClusterRestoreCriteria"):
    """kubernetes Cluster Backup target info for restore operation.

    :ivar include_cluster_scope_resources: Gets or sets the include cluster resources property.
     This property if enabled will include cluster scope resources during restore. Required.
    :vartype include_cluster_scope_resources: bool
    :ivar included_namespaces: Gets or sets the include namespaces property. This property sets the
     namespaces to be included during restore.
    :vartype included_namespaces: list[str]
    :ivar excluded_namespaces: Gets or sets the exclude namespaces property. This property sets the
     namespaces to be excluded during restore.
    :vartype excluded_namespaces: list[str]
    :ivar included_resource_types: Gets or sets the include resource types property. This property
     sets the resource types to be included during restore.
    :vartype included_resource_types: list[str]
    :ivar excluded_resource_types: Gets or sets the exclude resource types property. This property
     sets the resource types to be excluded during restore.
    :vartype excluded_resource_types: list[str]
    :ivar label_selectors: Gets or sets the LabelSelectors property. This property sets the
     resource with such label selectors to be included during restore.
    :vartype label_selectors: list[str]
    :ivar persistent_volume_restore_mode: Gets or sets the PV (Persistent Volume) Restore Mode
     property. This property sets whether volumes needs to be restored. Known values are:
     "RestoreWithVolumeData" and "RestoreWithoutVolumeData".
    :vartype persistent_volume_restore_mode: str or
     ~azure.mgmt.dataprotection.models.PersistentVolumeRestoreMode
    :ivar conflict_policy: Gets or sets the Conflict Policy property. This property sets policy
     during conflict of resources during restore. Known values are: "Skip" and "Patch".
    :vartype conflict_policy: str or ~azure.mgmt.dataprotection.models.ExistingResourcePolicy
    :ivar namespace_mappings: Gets or sets the Namespace Mappings property. This property sets if
     namespace needs to be change during restore.
    :vartype namespace_mappings: dict[str, str]
    :ivar restore_hook_references: Gets or sets the restore hook references. This property sets the
     hook reference to be executed during restore.
    :vartype restore_hook_references:
     list[~azure.mgmt.dataprotection.models.NamespacedNameResource]
    :ivar resource_modifier_reference: Gets or sets the resource modifier reference. This property
     sets the reference for resource modifier during restore.
    :vartype resource_modifier_reference: ~azure.mgmt.dataprotection.models.NamespacedNameResource
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "KubernetesClusterRestoreCriteria".
    :vartype object_type: str
    """

    include_cluster_scope_resources: bool = rest_field(
        name="includeClusterScopeResources", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include cluster resources property. This property if enabled will include
     cluster scope resources during restore. Required."""
    included_namespaces: Optional[list[str]] = rest_field(
        name="includedNamespaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include namespaces property. This property sets the namespaces to be included
     during restore."""
    excluded_namespaces: Optional[list[str]] = rest_field(
        name="excludedNamespaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded
     during restore."""
    included_resource_types: Optional[list[str]] = rest_field(
        name="includedResourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include resource types property. This property sets the resource types to be
     included during restore."""
    excluded_resource_types: Optional[list[str]] = rest_field(
        name="excludedResourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the exclude resource types property. This property sets the resource types to be
     excluded during restore."""
    label_selectors: Optional[list[str]] = rest_field(
        name="labelSelectors", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the LabelSelectors property. This property sets the resource with such label
     selectors to be included during restore."""
    persistent_volume_restore_mode: Optional[Union[str, "_models.PersistentVolumeRestoreMode"]] = rest_field(
        name="persistentVolumeRestoreMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the PV (Persistent Volume) Restore Mode property. This property sets whether
     volumes needs to be restored. Known values are: \"RestoreWithVolumeData\" and
     \"RestoreWithoutVolumeData\"."""
    conflict_policy: Optional[Union[str, "_models.ExistingResourcePolicy"]] = rest_field(
        name="conflictPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Conflict Policy property. This property sets policy during conflict of
     resources during restore. Known values are: \"Skip\" and \"Patch\"."""
    namespace_mappings: Optional[dict[str, str]] = rest_field(
        name="namespaceMappings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Namespace Mappings property. This property sets if namespace needs to be
     change during restore."""
    restore_hook_references: Optional[list["_models.NamespacedNameResource"]] = rest_field(
        name="restoreHookReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the restore hook references. This property sets the hook reference to be executed
     during restore."""
    resource_modifier_reference: Optional["_models.NamespacedNameResource"] = rest_field(
        name="resourceModifierReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the resource modifier reference. This property sets the reference for resource
     modifier during restore."""
    object_type: Literal["KubernetesClusterRestoreCriteria"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"KubernetesClusterRestoreCriteria\"."""

    @overload
    def __init__(
        self,
        *,
        include_cluster_scope_resources: bool,
        included_namespaces: Optional[list[str]] = None,
        excluded_namespaces: Optional[list[str]] = None,
        included_resource_types: Optional[list[str]] = None,
        excluded_resource_types: Optional[list[str]] = None,
        label_selectors: Optional[list[str]] = None,
        persistent_volume_restore_mode: Optional[Union[str, "_models.PersistentVolumeRestoreMode"]] = None,
        conflict_policy: Optional[Union[str, "_models.ExistingResourcePolicy"]] = None,
        namespace_mappings: Optional[dict[str, str]] = None,
        restore_hook_references: Optional[list["_models.NamespacedNameResource"]] = None,
        resource_modifier_reference: Optional["_models.NamespacedNameResource"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "KubernetesClusterRestoreCriteria"  # type: ignore


class KubernetesClusterVaultTierRestoreCriteria(
    ItemLevelRestoreCriteria, discriminator="KubernetesClusterVaultTierRestoreCriteria"
):  # pylint: disable=name-too-long
    """kubernetes Cluster Backup target info for restore operation from vault.

    :ivar include_cluster_scope_resources: Gets or sets the include cluster resources property.
     This property if enabled will include cluster scope resources during restore from vault.
     Required.
    :vartype include_cluster_scope_resources: bool
    :ivar included_namespaces: Gets or sets the include namespaces property. This property sets the
     namespaces to be included during restore from vault.
    :vartype included_namespaces: list[str]
    :ivar excluded_namespaces: Gets or sets the exclude namespaces property. This property sets the
     namespaces to be excluded during restore from vault.
    :vartype excluded_namespaces: list[str]
    :ivar included_resource_types: Gets or sets the include resource types property. This property
     sets the resource types to be included during restore from vault.
    :vartype included_resource_types: list[str]
    :ivar excluded_resource_types: Gets or sets the exclude resource types property. This property
     sets the resource types to be excluded during restore from vault.
    :vartype excluded_resource_types: list[str]
    :ivar label_selectors: Gets or sets the LabelSelectors property. This property sets the
     resource with such label selectors to be included during restore from vault.
    :vartype label_selectors: list[str]
    :ivar persistent_volume_restore_mode: Gets or sets the PV (Persistent Volume) Restore Mode
     property. This property sets whether volumes needs to be restored from vault. Known values are:
     "RestoreWithVolumeData" and "RestoreWithoutVolumeData".
    :vartype persistent_volume_restore_mode: str or
     ~azure.mgmt.dataprotection.models.PersistentVolumeRestoreMode
    :ivar conflict_policy: Gets or sets the Conflict Policy property. This property sets policy
     during conflict of resources during restore from vault. Known values are: "Skip" and "Patch".
    :vartype conflict_policy: str or ~azure.mgmt.dataprotection.models.ExistingResourcePolicy
    :ivar namespace_mappings: Gets or sets the Namespace Mappings property. This property sets if
     namespace needs to be change during restore from vault.
    :vartype namespace_mappings: dict[str, str]
    :ivar restore_hook_references: Gets or sets the restore hook references. This property sets the
     hook reference to be executed during restore from vault.
    :vartype restore_hook_references:
     list[~azure.mgmt.dataprotection.models.NamespacedNameResource]
    :ivar staging_resource_group_id: Gets or sets the staging RG Id for creating staging disks and
     snapshots during restore from vault.
    :vartype staging_resource_group_id: str
    :ivar staging_storage_account_id: Gets or sets the staging Storage Account Id for creating
     backup extension object store data during restore from vault.
    :vartype staging_storage_account_id: str
    :ivar resource_modifier_reference: Gets or sets the resource modifier reference. This property
     sets the reference for resource modifier during restore.
    :vartype resource_modifier_reference: ~azure.mgmt.dataprotection.models.NamespacedNameResource
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "KubernetesClusterVaultTierRestoreCriteria".
    :vartype object_type: str
    """

    include_cluster_scope_resources: bool = rest_field(
        name="includeClusterScopeResources", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include cluster resources property. This property if enabled will include
     cluster scope resources during restore from vault. Required."""
    included_namespaces: Optional[list[str]] = rest_field(
        name="includedNamespaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include namespaces property. This property sets the namespaces to be included
     during restore from vault."""
    excluded_namespaces: Optional[list[str]] = rest_field(
        name="excludedNamespaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded
     during restore from vault."""
    included_resource_types: Optional[list[str]] = rest_field(
        name="includedResourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the include resource types property. This property sets the resource types to be
     included during restore from vault."""
    excluded_resource_types: Optional[list[str]] = rest_field(
        name="excludedResourceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the exclude resource types property. This property sets the resource types to be
     excluded during restore from vault."""
    label_selectors: Optional[list[str]] = rest_field(
        name="labelSelectors", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the LabelSelectors property. This property sets the resource with such label
     selectors to be included during restore from vault."""
    persistent_volume_restore_mode: Optional[Union[str, "_models.PersistentVolumeRestoreMode"]] = rest_field(
        name="persistentVolumeRestoreMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the PV (Persistent Volume) Restore Mode property. This property sets whether
     volumes needs to be restored from vault. Known values are: \"RestoreWithVolumeData\" and
     \"RestoreWithoutVolumeData\"."""
    conflict_policy: Optional[Union[str, "_models.ExistingResourcePolicy"]] = rest_field(
        name="conflictPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Conflict Policy property. This property sets policy during conflict of
     resources during restore from vault. Known values are: \"Skip\" and \"Patch\"."""
    namespace_mappings: Optional[dict[str, str]] = rest_field(
        name="namespaceMappings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Namespace Mappings property. This property sets if namespace needs to be
     change during restore from vault."""
    restore_hook_references: Optional[list["_models.NamespacedNameResource"]] = rest_field(
        name="restoreHookReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the restore hook references. This property sets the hook reference to be executed
     during restore from vault."""
    staging_resource_group_id: Optional[str] = rest_field(
        name="stagingResourceGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the staging RG Id for creating staging disks and snapshots during restore from
     vault."""
    staging_storage_account_id: Optional[str] = rest_field(
        name="stagingStorageAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the staging Storage Account Id for creating backup extension object store data
     during restore from vault."""
    resource_modifier_reference: Optional["_models.NamespacedNameResource"] = rest_field(
        name="resourceModifierReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the resource modifier reference. This property sets the reference for resource
     modifier during restore."""
    object_type: Literal["KubernetesClusterVaultTierRestoreCriteria"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"KubernetesClusterVaultTierRestoreCriteria\"."""

    @overload
    def __init__(
        self,
        *,
        include_cluster_scope_resources: bool,
        included_namespaces: Optional[list[str]] = None,
        excluded_namespaces: Optional[list[str]] = None,
        included_resource_types: Optional[list[str]] = None,
        excluded_resource_types: Optional[list[str]] = None,
        label_selectors: Optional[list[str]] = None,
        persistent_volume_restore_mode: Optional[Union[str, "_models.PersistentVolumeRestoreMode"]] = None,
        conflict_policy: Optional[Union[str, "_models.ExistingResourcePolicy"]] = None,
        namespace_mappings: Optional[dict[str, str]] = None,
        restore_hook_references: Optional[list["_models.NamespacedNameResource"]] = None,
        staging_resource_group_id: Optional[str] = None,
        staging_storage_account_id: Optional[str] = None,
        resource_modifier_reference: Optional["_models.NamespacedNameResource"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "KubernetesClusterVaultTierRestoreCriteria"  # type: ignore


class KubernetesPVRestoreCriteria(ItemLevelRestoreCriteria, discriminator="KubernetesPVRestoreCriteria"):
    """Item Level kubernetes persistent volume target info for restore operation.

    :ivar name: Selected persistent volume claim name.
    :vartype name: str
    :ivar storage_class_name: Selected storage class name for restore operation.
    :vartype storage_class_name: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "KubernetesPVRestoreCriteria".
    :vartype object_type: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Selected persistent volume claim name."""
    storage_class_name: Optional[str] = rest_field(
        name="storageClassName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Selected storage class name for restore operation."""
    object_type: Literal["KubernetesPVRestoreCriteria"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"KubernetesPVRestoreCriteria\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        storage_class_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "KubernetesPVRestoreCriteria"  # type: ignore


class KubernetesStorageClassRestoreCriteria(
    ItemLevelRestoreCriteria, discriminator="KubernetesStorageClassRestoreCriteria"
):
    """Item Level kubernetes storage class target info for restore operation.

    :ivar selected_storage_class_name: Selected storage class name.
    :vartype selected_storage_class_name: str
    :ivar provisioner: Provisioner of the storage class.
    :vartype provisioner: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "KubernetesStorageClassRestoreCriteria".
    :vartype object_type: str
    """

    selected_storage_class_name: Optional[str] = rest_field(
        name="selectedStorageClassName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Selected storage class name."""
    provisioner: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Provisioner of the storage class."""
    object_type: Literal["KubernetesStorageClassRestoreCriteria"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"KubernetesStorageClassRestoreCriteria\"."""

    @overload
    def __init__(
        self,
        *,
        selected_storage_class_name: Optional[str] = None,
        provisioner: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "KubernetesStorageClassRestoreCriteria"  # type: ignore


class MonitoringSettings(_Model):
    """Monitoring Settings.

    :ivar azure_monitor_alert_settings: Settings for Azure Monitor based alerts.
    :vartype azure_monitor_alert_settings:
     ~azure.mgmt.dataprotection.models.AzureMonitorAlertSettings
    """

    azure_monitor_alert_settings: Optional["_models.AzureMonitorAlertSettings"] = rest_field(
        name="azureMonitorAlertSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for Azure Monitor based alerts."""

    @overload
    def __init__(
        self,
        *,
        azure_monitor_alert_settings: Optional["_models.AzureMonitorAlertSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NamespacedNameResource(_Model):
    """Class to refer resources which contains namespace and name.

    :ivar name: Name of the resource.
    :vartype name: str
    :ivar namespace: Namespace in which the resource exists.
    :vartype namespace: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the resource."""
    namespace: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Namespace in which the resource exists."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.dataprotection.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.dataprotection.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.dataprotection.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OperationExtendedInfo(_Model):
    """Operation Extended Info.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OperationJobExtendedInfo

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required. Default value is None.
    :vartype object_type: str
    """

    __mapping__: dict[str, _Model] = {}
    object_type: str = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])
    """This property will be used as the discriminator for deciding the specific types in the
     polymorphic chain of types. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        object_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationJobExtendedInfo(OperationExtendedInfo, discriminator="OperationJobExtendedInfo"):
    """Operation Job Extended Info.

    :ivar job_id: Name or Arm Id of the job created for this operation.
    :vartype job_id: str
    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required. Default value is "OperationJobExtendedInfo".
    :vartype object_type: str
    """

    job_id: Optional[str] = rest_field(name="jobId", visibility=["read", "create", "update", "delete", "query"])
    """Name or Arm Id of the job created for this operation."""
    object_type: Literal["OperationJobExtendedInfo"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """This property will be used as the discriminator for deciding the specific types in the
     polymorphic chain of types. Required. Default value is \"OperationJobExtendedInfo\"."""

    @overload
    def __init__(
        self,
        *,
        job_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "OperationJobExtendedInfo"  # type: ignore


class OperationResource(_Model):
    """Operation Resource.

    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Required if status == failed or status == canceled. This is the OData v4 error
     format, used by the RPC and will go into the v2.2 Azure REST API guidelines.
     The full set of optional properties (e.g. inner errors / details) can be found in the "Error
     Response" section.
    :vartype error: ~azure.mgmt.dataprotection.models.Error
    :ivar id: It should match what is used to GET the operation result.
    :vartype id: str
    :ivar name: It must match the last segment of the "id" field, and will typically be a GUID /
     system generated value.
    :vartype name: str
    :ivar properties: End time of the operation.
    :vartype properties: ~azure.mgmt.dataprotection.models.OperationExtendedInfo
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar status:
    :vartype status: str
    """

    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of the operation."""
    error: Optional["_models.Error"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required if status == failed or status == canceled. This is the OData v4 error format, used by
     the RPC and will go into the v2.2 Azure REST API guidelines.
     The full set of optional properties (e.g. inner errors / details) can be found in the \"Error
     Response\" section."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """It should match what is used to GET the operation result."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """It must match the last segment of the \"id\" field, and will typically be a GUID / system
     generated value."""
    properties: Optional["_models.OperationExtendedInfo"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """End time of the operation."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of the operation."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.Error"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        properties: Optional["_models.OperationExtendedInfo"] = None,
        start_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatchBackupVaultInput(_Model):
    """Backup Vault Contract for Patch Backup Vault API.

    :ivar monitoring_settings: Monitoring Settings.
    :vartype monitoring_settings: ~azure.mgmt.dataprotection.models.MonitoringSettings
    :ivar security_settings: Security Settings.
    :vartype security_settings: ~azure.mgmt.dataprotection.models.SecuritySettings
    :ivar feature_settings: Feature Settings.
    :vartype feature_settings: ~azure.mgmt.dataprotection.models.FeatureSettings
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    """

    monitoring_settings: Optional["_models.MonitoringSettings"] = rest_field(
        name="monitoringSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Monitoring Settings."""
    security_settings: Optional["_models.SecuritySettings"] = rest_field(
        name="securitySettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Security Settings."""
    feature_settings: Optional["_models.FeatureSettings"] = rest_field(
        name="featureSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Feature Settings."""
    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""

    @overload
    def __init__(
        self,
        *,
        monitoring_settings: Optional["_models.MonitoringSettings"] = None,
        security_settings: Optional["_models.SecuritySettings"] = None,
        feature_settings: Optional["_models.FeatureSettings"] = None,
        resource_guard_operation_requests: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatchResourceGuardInput(_Model):
    """Patch Request content for Microsoft.DataProtection Resource Guard resources.

    :ivar tags: Resource Guard tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource Guard tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatchResourceRequestInput(_Model):
    """Patch Request content for Microsoft.DataProtection resources.

    :ivar identity: Input Managed Identity Details.
    :vartype identity: ~azure.mgmt.dataprotection.models.DppIdentityDetails
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.PatchBackupVaultInput
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    identity: Optional["_models.DppIdentityDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input Managed Identity Details."""
    properties: Optional["_models.PatchBackupVaultInput"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.DppIdentityDetails"] = None,
        properties: Optional["_models.PatchBackupVaultInput"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyInfo(_Model):
    """Policy Info in backupInstance.

    :ivar policy_id: Required.
    :vartype policy_id: str
    :ivar policy_version:
    :vartype policy_version: str
    :ivar policy_parameters: Policy parameters for the backup instance.
    :vartype policy_parameters: ~azure.mgmt.dataprotection.models.PolicyParameters
    """

    policy_id: str = rest_field(name="policyId", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    policy_version: Optional[str] = rest_field(name="policyVersion", visibility=["read"])
    policy_parameters: Optional["_models.PolicyParameters"] = rest_field(
        name="policyParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy parameters for the backup instance."""

    @overload
    def __init__(
        self,
        *,
        policy_id: str,
        policy_parameters: Optional["_models.PolicyParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PolicyParameters(_Model):
    """Parameters in Policy.

    :ivar data_store_parameters_list: Gets or sets the DataStore Parameters.
    :vartype data_store_parameters_list:
     list[~azure.mgmt.dataprotection.models.DataStoreParameters]
    :ivar backup_datasource_parameters_list: Gets or sets the Backup Data Source Parameters.
    :vartype backup_datasource_parameters_list:
     list[~azure.mgmt.dataprotection.models.BackupDatasourceParameters]
    """

    data_store_parameters_list: Optional[list["_models.DataStoreParameters"]] = rest_field(
        name="dataStoreParametersList", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the DataStore Parameters."""
    backup_datasource_parameters_list: Optional[list["_models.BackupDatasourceParameters"]] = rest_field(
        name="backupDatasourceParametersList", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the Backup Data Source Parameters."""

    @overload
    def __init__(
        self,
        *,
        data_store_parameters_list: Optional[list["_models.DataStoreParameters"]] = None,
        backup_datasource_parameters_list: Optional[list["_models.BackupDatasourceParameters"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProtectionStatusDetails(_Model):
    """Protection status details.

    :ivar error_details: Specifies the protection status error of the resource.
    :vartype error_details: ~azure.mgmt.dataprotection.models.UserFacingError
    :ivar status: Specifies the protection status of the resource. Known values are:
     "ConfiguringProtection", "ConfiguringProtectionFailed", "ProtectionConfigured",
     "ProtectionStopped", "SoftDeleted", and "SoftDeleting".
    :vartype status: str or ~azure.mgmt.dataprotection.models.Status
    """

    error_details: Optional["_models.UserFacingError"] = rest_field(
        name="errorDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the protection status error of the resource."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the protection status of the resource. Known values are: \"ConfiguringProtection\",
     \"ConfiguringProtectionFailed\", \"ProtectionConfigured\", \"ProtectionStopped\",
     \"SoftDeleted\", and \"SoftDeleting\"."""

    @overload
    def __init__(
        self,
        *,
        error_details: Optional["_models.UserFacingError"] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RangeBasedItemLevelRestoreCriteria(ItemLevelRestoreCriteria, discriminator="RangeBasedItemLevelRestoreCriteria"):
    """Item Level target info for restore operation.

    :ivar min_matching_value: minimum value for range prefix match.
    :vartype min_matching_value: str
    :ivar max_matching_value: maximum value for range prefix match.
    :vartype max_matching_value: str
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "RangeBasedItemLevelRestoreCriteria".
    :vartype object_type: str
    """

    min_matching_value: Optional[str] = rest_field(
        name="minMatchingValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """minimum value for range prefix match."""
    max_matching_value: Optional[str] = rest_field(
        name="maxMatchingValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """maximum value for range prefix match."""
    object_type: Literal["RangeBasedItemLevelRestoreCriteria"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"RangeBasedItemLevelRestoreCriteria\"."""

    @overload
    def __init__(
        self,
        *,
        min_matching_value: Optional[str] = None,
        max_matching_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "RangeBasedItemLevelRestoreCriteria"  # type: ignore


class RecoveryPointDataStoreDetails(_Model):
    """RecoveryPoint datastore details.

    :ivar creation_time:
    :vartype creation_time: ~datetime.datetime
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar id:
    :vartype id: str
    :ivar meta_data:
    :vartype meta_data: str
    :ivar state:
    :vartype state: str
    :ivar type:
    :vartype type: str
    :ivar visible:
    :vartype visible: bool
    :ivar rehydration_expiry_time:
    :vartype rehydration_expiry_time: ~datetime.datetime
    :ivar rehydration_status: Known values are: "CREATE_IN_PROGRESS", "COMPLETED",
     "DELETE_IN_PROGRESS", "DELETED", and "FAILED".
    :vartype rehydration_status: str or ~azure.mgmt.dataprotection.models.RehydrationStatus
    """

    creation_time: Optional[datetime.datetime] = rest_field(
        name="creationTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    expiry_time: Optional[datetime.datetime] = rest_field(
        name="expiryTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    meta_data: Optional[str] = rest_field(name="metaData", visibility=["read", "create", "update", "delete", "query"])
    state: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    visible: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    rehydration_expiry_time: Optional[datetime.datetime] = rest_field(
        name="rehydrationExpiryTime", visibility=["read"], format="rfc3339"
    )
    rehydration_status: Optional[Union[str, "_models.RehydrationStatus"]] = rest_field(
        name="rehydrationStatus", visibility=["read"]
    )
    """Known values are: \"CREATE_IN_PROGRESS\", \"COMPLETED\", \"DELETE_IN_PROGRESS\", \"DELETED\",
     and \"FAILED\"."""

    @overload
    def __init__(
        self,
        *,
        creation_time: Optional[datetime.datetime] = None,
        expiry_time: Optional[datetime.datetime] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta_data: Optional[str] = None,
        state: Optional[str] = None,
        type: Optional[str] = None,
        visible: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceGuard(_Model):
    """ResourceGuard.

    :ivar provisioning_state: Provisioning state of the BackupVault resource. Known values are:
     "Failed", "Provisioning", "Succeeded", "Unknown", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.dataprotection.models.ProvisioningState
    :ivar allow_auto_approvals: This flag indicates whether auto approval is allowed or not.
    :vartype allow_auto_approvals: bool
    :ivar resource_guard_operations: {readonly} List of operation details those are protected by
     the ResourceGuard resource.
    :vartype resource_guard_operations:
     list[~azure.mgmt.dataprotection.models.ResourceGuardOperation]
    :ivar vault_critical_operation_exclusion_list: List of critical operations which are not
     protected by this resourceGuard.
    :vartype vault_critical_operation_exclusion_list: list[str]
    :ivar description: Description about the pre-req steps to perform all the critical operations.
    :vartype description: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the BackupVault resource. Known values are: \"Failed\", \"Provisioning\",
     \"Succeeded\", \"Unknown\", and \"Updating\"."""
    allow_auto_approvals: Optional[bool] = rest_field(name="allowAutoApprovals", visibility=["read"])
    """This flag indicates whether auto approval is allowed or not."""
    resource_guard_operations: Optional[list["_models.ResourceGuardOperation"]] = rest_field(
        name="resourceGuardOperations", visibility=["read"]
    )
    """{readonly} List of operation details those are protected by the ResourceGuard resource."""
    vault_critical_operation_exclusion_list: Optional[list[str]] = rest_field(
        name="vaultCriticalOperationExclusionList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of critical operations which are not protected by this resourceGuard."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Description about the pre-req steps to perform all the critical operations."""

    @overload
    def __init__(
        self,
        *,
        vault_critical_operation_exclusion_list: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceGuardOperation(_Model):
    """This class contains all the details about a critical operation.

    :ivar vault_critical_operation: Name of the critical operation.
    :vartype vault_critical_operation: str
    :ivar request_resource_type: Type of resource request.
    :vartype request_resource_type: str
    """

    vault_critical_operation: Optional[str] = rest_field(name="vaultCriticalOperation", visibility=["read"])
    """Name of the critical operation."""
    request_resource_type: Optional[str] = rest_field(name="requestResourceType", visibility=["read"])
    """Type of resource request."""


class ResourceGuardOperationDetail(_Model):
    """VaultCritical Operation protected by a resource guard.

    :ivar vault_critical_operation:
    :vartype vault_critical_operation: str
    :ivar default_resource_request:
    :vartype default_resource_request: str
    """

    vault_critical_operation: Optional[str] = rest_field(
        name="vaultCriticalOperation", visibility=["read", "create", "update", "delete", "query"]
    )
    default_resource_request: Optional[str] = rest_field(
        name="defaultResourceRequest", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        vault_critical_operation: Optional[str] = None,
        default_resource_request: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceGuardProxyBase(_Model):
    """ResourceGuardProxyBase object, used in ResourceGuardProxyBaseResource.

    :ivar resource_guard_resource_id:
    :vartype resource_guard_resource_id: str
    :ivar resource_guard_operation_details:
    :vartype resource_guard_operation_details:
     list[~azure.mgmt.dataprotection.models.ResourceGuardOperationDetail]
    :ivar last_updated_time:
    :vartype last_updated_time: str
    :ivar description:
    :vartype description: str
    """

    resource_guard_resource_id: Optional[str] = rest_field(
        name="resourceGuardResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    resource_guard_operation_details: Optional[list["_models.ResourceGuardOperationDetail"]] = rest_field(
        name="resourceGuardOperationDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    last_updated_time: Optional[str] = rest_field(
        name="lastUpdatedTime", visibility=["read", "create", "update", "delete", "query"]
    )
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        resource_guard_resource_id: Optional[str] = None,
        resource_guard_operation_details: Optional[list["_models.ResourceGuardOperationDetail"]] = None,
        last_updated_time: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceGuardProxyBaseResource(ProxyResource):
    """ResourceGuardProxyBaseResource object, used for response and request bodies for
    ResourceGuardProxy APIs.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar properties: ResourceGuardProxyBaseResource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.ResourceGuardProxyBase
    """

    properties: Optional["_models.ResourceGuardProxyBase"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardProxyBaseResource properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ResourceGuardProxyBase"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceGuardResource(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: ResourceGuardResource properties.
    :vartype properties: ~azure.mgmt.dataprotection.models.ResourceGuard
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    """

    properties: Optional["_models.ResourceGuard"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardResource properties."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read", "create", "update", "delete", "query"])
    """Optional ETag."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ResourceGuard"] = None,
        e_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceMoveDetails(_Model):
    """ResourceMoveDetails will be returned in response to GetResource call from ARM.

    :ivar operation_id: CorrelationId of latest ResourceMove operation attempted.
    :vartype operation_id: str
    :ivar start_time_utc: Start time in UTC of latest ResourceMove operation attempted. ISO 8601
     format.
    :vartype start_time_utc: str
    :ivar completion_time_utc: Completion time in UTC of latest ResourceMove operation attempted.
     ISO 8601 format.
    :vartype completion_time_utc: str
    :ivar source_resource_path: ARM resource path of source resource.
    :vartype source_resource_path: str
    :ivar target_resource_path: ARM resource path of target resource used in latest ResourceMove
     operation.
    :vartype target_resource_path: str
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """CorrelationId of latest ResourceMove operation attempted."""
    start_time_utc: Optional[str] = rest_field(
        name="startTimeUtc", visibility=["read", "create", "update", "delete", "query"]
    )
    """Start time in UTC of latest ResourceMove operation attempted. ISO 8601 format."""
    completion_time_utc: Optional[str] = rest_field(
        name="completionTimeUtc", visibility=["read", "create", "update", "delete", "query"]
    )
    """Completion time in UTC of latest ResourceMove operation attempted. ISO 8601 format."""
    source_resource_path: Optional[str] = rest_field(
        name="sourceResourcePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM resource path of source resource."""
    target_resource_path: Optional[str] = rest_field(
        name="targetResourcePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM resource path of target resource used in latest ResourceMove operation."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        start_time_utc: Optional[str] = None,
        completion_time_utc: Optional[str] = None,
        source_resource_path: Optional[str] = None,
        target_resource_path: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestorableTimeRange(_Model):
    """RestorableTimeRange.

    :ivar start_time: Start time for the available restore range. Required.
    :vartype start_time: str
    :ivar end_time: End time for the available restore range. Required.
    :vartype end_time: str
    :ivar object_type:
    :vartype object_type: str
    """

    start_time: str = rest_field(name="startTime", visibility=["read", "create", "update", "delete", "query"])
    """Start time for the available restore range. Required."""
    end_time: str = rest_field(name="endTime", visibility=["read", "create", "update", "delete", "query"])
    """End time for the available restore range. Required."""
    object_type: Optional[str] = rest_field(
        name="objectType", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        start_time: str,
        end_time: str,
        object_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestoreFilesTargetInfo(RestoreTargetInfoBase, discriminator="RestoreFilesTargetInfo"):
    """Class encapsulating restore as files target parameters.

    :ivar recovery_option: Recovery Option. Required. "FailIfExists"
    :vartype recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :ivar restore_location: Target Restore region.
    :vartype restore_location: str
    :ivar target_details: Destination of RestoreAsFiles operation, when destination is not a
     datasource. Required.
    :vartype target_details: ~azure.mgmt.dataprotection.models.TargetDetails
    :ivar object_type: Type of Datasource object, used to initialize the right inherited type.
     Required. Default value is "RestoreFilesTargetInfo".
    :vartype object_type: str
    """

    target_details: "_models.TargetDetails" = rest_field(
        name="targetDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Destination of RestoreAsFiles operation, when destination is not a datasource. Required."""
    object_type: Literal["RestoreFilesTargetInfo"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of Datasource object, used to initialize the right inherited type. Required. Default value
     is \"RestoreFilesTargetInfo\"."""

    @overload
    def __init__(
        self,
        *,
        recovery_option: Union[str, "_models.RecoveryOption"],
        target_details: "_models.TargetDetails",
        restore_location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "RestoreFilesTargetInfo"  # type: ignore


class RestoreJobRecoveryPointDetails(_Model):
    """RestoreJobRecoveryPointDetails.

    :ivar recovery_point_id:
    :vartype recovery_point_id: str
    :ivar recovery_point_time:
    :vartype recovery_point_time: ~datetime.datetime
    """

    recovery_point_id: Optional[str] = rest_field(
        name="recoveryPointID", visibility=["read", "create", "update", "delete", "query"]
    )
    recovery_point_time: Optional[datetime.datetime] = rest_field(
        name="recoveryPointTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )

    @overload
    def __init__(
        self,
        *,
        recovery_point_id: Optional[str] = None,
        recovery_point_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestoreTargetInfo(RestoreTargetInfoBase, discriminator="RestoreTargetInfo"):
    """Class encapsulating restore target parameters.

    :ivar recovery_option: Recovery Option. Required. "FailIfExists"
    :vartype recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :ivar restore_location: Target Restore region.
    :vartype restore_location: str
    :ivar datasource_info: Information of target DS. Required.
    :vartype datasource_info: ~azure.mgmt.dataprotection.models.Datasource
    :ivar datasource_set_info: Information of target DS Set.
    :vartype datasource_set_info: ~azure.mgmt.dataprotection.models.DatasourceSet
    :ivar datasource_auth_credentials: Credentials to use to authenticate with data source
     provider.
    :vartype datasource_auth_credentials: ~azure.mgmt.dataprotection.models.AuthCredentials
    :ivar object_type: Type of Datasource object, used to initialize the right inherited type.
     Required. Default value is "RestoreTargetInfo".
    :vartype object_type: str
    """

    datasource_info: "_models.Datasource" = rest_field(
        name="datasourceInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information of target DS. Required."""
    datasource_set_info: Optional["_models.DatasourceSet"] = rest_field(
        name="datasourceSetInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information of target DS Set."""
    datasource_auth_credentials: Optional["_models.AuthCredentials"] = rest_field(
        name="datasourceAuthCredentials", visibility=["read", "create", "update", "delete", "query"]
    )
    """Credentials to use to authenticate with data source provider."""
    object_type: Literal["RestoreTargetInfo"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of Datasource object, used to initialize the right inherited type. Required. Default value
     is \"RestoreTargetInfo\"."""

    @overload
    def __init__(
        self,
        *,
        recovery_option: Union[str, "_models.RecoveryOption"],
        datasource_info: "_models.Datasource",
        restore_location: Optional[str] = None,
        datasource_set_info: Optional["_models.DatasourceSet"] = None,
        datasource_auth_credentials: Optional["_models.AuthCredentials"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "RestoreTargetInfo"  # type: ignore


class RetentionTag(_Model):
    """Retention tag.

    :ivar e_tag: Retention Tag version.
    :vartype e_tag: str
    :ivar id: Retention Tag version.
    :vartype id: str
    :ivar tag_name: Retention Tag Name to relate it to retention rule. Required.
    :vartype tag_name: str
    """

    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """Retention Tag version."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Retention Tag version."""
    tag_name: str = rest_field(name="tagName", visibility=["read", "create", "update", "delete", "query"])
    """Retention Tag Name to relate it to retention rule. Required."""

    @overload
    def __init__(
        self,
        *,
        tag_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScheduleBasedBackupCriteria(BackupCriteria, discriminator="ScheduleBasedBackupCriteria"):
    """Schedule based backup criteria.

    :ivar absolute_criteria: it contains absolute values like "AllBackup" / "FirstOfDay" /
     "FirstOfWeek" / "FirstOfMonth"
     and should be part of AbsoluteMarker enum.
    :vartype absolute_criteria: list[str or ~azure.mgmt.dataprotection.models.AbsoluteMarker]
    :ivar days_of_month: This is day of the month from 1 to 28 other wise last of month.
    :vartype days_of_month: list[~azure.mgmt.dataprotection.models.Day]
    :ivar days_of_the_week: It should be Sunday/Monday/T..../Saturday.
    :vartype days_of_the_week: list[str or ~azure.mgmt.dataprotection.models.DayOfWeek]
    :ivar months_of_year: It should be January/February/....../December.
    :vartype months_of_year: list[str or ~azure.mgmt.dataprotection.models.Month]
    :ivar schedule_times: List of schedule times for backup.
    :vartype schedule_times: list[~datetime.datetime]
    :ivar weeks_of_the_month: It should be First/Second/Third/Fourth/Last.
    :vartype weeks_of_the_month: list[str or ~azure.mgmt.dataprotection.models.WeekNumber]
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "ScheduleBasedBackupCriteria".
    :vartype object_type: str
    """

    absolute_criteria: Optional[list[Union[str, "_models.AbsoluteMarker"]]] = rest_field(
        name="absoluteCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """it contains absolute values like \"AllBackup\" / \"FirstOfDay\" / \"FirstOfWeek\" /
     \"FirstOfMonth\"
     and should be part of AbsoluteMarker enum."""
    days_of_month: Optional[list["_models.Day"]] = rest_field(
        name="daysOfMonth", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is day of the month from 1 to 28 other wise last of month."""
    days_of_the_week: Optional[list[Union[str, "_models.DayOfWeek"]]] = rest_field(
        name="daysOfTheWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """It should be Sunday/Monday/T..../Saturday."""
    months_of_year: Optional[list[Union[str, "_models.Month"]]] = rest_field(
        name="monthsOfYear", visibility=["read", "create", "update", "delete", "query"]
    )
    """It should be January/February/....../December."""
    schedule_times: Optional[list[datetime.datetime]] = rest_field(
        name="scheduleTimes", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """List of schedule times for backup."""
    weeks_of_the_month: Optional[list[Union[str, "_models.WeekNumber"]]] = rest_field(
        name="weeksOfTheMonth", visibility=["read", "create", "update", "delete", "query"]
    )
    """It should be First/Second/Third/Fourth/Last."""
    object_type: Literal["ScheduleBasedBackupCriteria"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"ScheduleBasedBackupCriteria\"."""

    @overload
    def __init__(
        self,
        *,
        absolute_criteria: Optional[list[Union[str, "_models.AbsoluteMarker"]]] = None,
        days_of_month: Optional[list["_models.Day"]] = None,
        days_of_the_week: Optional[list[Union[str, "_models.DayOfWeek"]]] = None,
        months_of_year: Optional[list[Union[str, "_models.Month"]]] = None,
        schedule_times: Optional[list[datetime.datetime]] = None,
        weeks_of_the_month: Optional[list[Union[str, "_models.WeekNumber"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "ScheduleBasedBackupCriteria"  # type: ignore


class ScheduleBasedTriggerContext(TriggerContext, discriminator="ScheduleBasedTriggerContext"):
    """Schedule based trigger context.

    :ivar schedule: Schedule for this backup. Required.
    :vartype schedule: ~azure.mgmt.dataprotection.models.BackupSchedule
    :ivar tagging_criteria: List of tags that can be applicable for given schedule. Required.
    :vartype tagging_criteria: list[~azure.mgmt.dataprotection.models.TaggingCriteria]
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "ScheduleBasedTriggerContext".
    :vartype object_type: str
    """

    schedule: "_models.BackupSchedule" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Schedule for this backup. Required."""
    tagging_criteria: list["_models.TaggingCriteria"] = rest_field(
        name="taggingCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of tags that can be applicable for given schedule. Required."""
    object_type: Literal["ScheduleBasedTriggerContext"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"ScheduleBasedTriggerContext\"."""

    @overload
    def __init__(
        self,
        *,
        schedule: "_models.BackupSchedule",
        tagging_criteria: list["_models.TaggingCriteria"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "ScheduleBasedTriggerContext"  # type: ignore


class SecretStoreBasedAuthCredentials(AuthCredentials, discriminator="SecretStoreBasedAuthCredentials"):
    """Secret store based authentication credentials.

    :ivar secret_store_resource: Secret store resource.
    :vartype secret_store_resource: ~azure.mgmt.dataprotection.models.SecretStoreResource
    :ivar object_type: Type of the specific object - used for deserializing. Required. Default
     value is "SecretStoreBasedAuthCredentials".
    :vartype object_type: str
    """

    secret_store_resource: Optional["_models.SecretStoreResource"] = rest_field(
        name="secretStoreResource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Secret store resource."""
    object_type: Literal["SecretStoreBasedAuthCredentials"] = rest_discriminator(name="objectType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the specific object - used for deserializing. Required. Default value is
     \"SecretStoreBasedAuthCredentials\"."""

    @overload
    def __init__(
        self,
        *,
        secret_store_resource: Optional["_models.SecretStoreResource"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object_type = "SecretStoreBasedAuthCredentials"  # type: ignore


class SecretStoreResource(_Model):
    """Class representing a secret store resource.

    :ivar uri: Uri to get to the resource.
    :vartype uri: str
    :ivar secret_store_type: Gets or sets the type of secret store. Required. Known values are:
     "Invalid" and "AzureKeyVault".
    :vartype secret_store_type: str or ~azure.mgmt.dataprotection.models.SecretStoreType
    :ivar value: Gets or sets value stored in secret store resource.
    :vartype value: str
    """

    uri: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Uri to get to the resource."""
    secret_store_type: Union[str, "_models.SecretStoreType"] = rest_field(
        name="secretStoreType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of secret store. Required. Known values are: \"Invalid\" and
     \"AzureKeyVault\"."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets value stored in secret store resource."""

    @overload
    def __init__(
        self,
        *,
        secret_store_type: Union[str, "_models.SecretStoreType"],
        uri: Optional[str] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecuritySettings(_Model):
    """Class containing security settings of vault.

    :ivar soft_delete_settings: Soft delete related settings.
    :vartype soft_delete_settings: ~azure.mgmt.dataprotection.models.SoftDeleteSettings
    :ivar immutability_settings: Immutability Settings at vault level.
    :vartype immutability_settings: ~azure.mgmt.dataprotection.models.ImmutabilitySettings
    :ivar encryption_settings: Customer Managed Key details of the resource.
    :vartype encryption_settings: ~azure.mgmt.dataprotection.models.EncryptionSettings
    """

    soft_delete_settings: Optional["_models.SoftDeleteSettings"] = rest_field(
        name="softDeleteSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Soft delete related settings."""
    immutability_settings: Optional["_models.ImmutabilitySettings"] = rest_field(
        name="immutabilitySettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Immutability Settings at vault level."""
    encryption_settings: Optional["_models.EncryptionSettings"] = rest_field(
        name="encryptionSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer Managed Key details of the resource."""

    @overload
    def __init__(
        self,
        *,
        soft_delete_settings: Optional["_models.SoftDeleteSettings"] = None,
        immutability_settings: Optional["_models.ImmutabilitySettings"] = None,
        encryption_settings: Optional["_models.EncryptionSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SoftDeleteSettings(_Model):
    """Soft delete related settings.

    :ivar state: State of soft delete. Known values are: "Off", "On", and "AlwaysOn".
    :vartype state: str or ~azure.mgmt.dataprotection.models.SoftDeleteState
    :ivar retention_duration_in_days: Soft delete retention duration.
    :vartype retention_duration_in_days: float
    """

    state: Optional[Union[str, "_models.SoftDeleteState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """State of soft delete. Known values are: \"Off\", \"On\", and \"AlwaysOn\"."""
    retention_duration_in_days: Optional[float] = rest_field(
        name="retentionDurationInDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """Soft delete retention duration."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.SoftDeleteState"]] = None,
        retention_duration_in_days: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceLifeCycle(_Model):
    """Source LifeCycle.

    :ivar delete_after: Delete Option. Required.
    :vartype delete_after: ~azure.mgmt.dataprotection.models.DeleteOption
    :ivar source_data_store: DataStoreInfo base. Required.
    :vartype source_data_store: ~azure.mgmt.dataprotection.models.DataStoreInfoBase
    :ivar target_data_store_copy_settings:
    :vartype target_data_store_copy_settings:
     list[~azure.mgmt.dataprotection.models.TargetCopySetting]
    """

    delete_after: "_models.DeleteOption" = rest_field(
        name="deleteAfter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Delete Option. Required."""
    source_data_store: "_models.DataStoreInfoBase" = rest_field(
        name="sourceDataStore", visibility=["read", "create", "update", "delete", "query"]
    )
    """DataStoreInfo base. Required."""
    target_data_store_copy_settings: Optional[list["_models.TargetCopySetting"]] = rest_field(
        name="targetDataStoreCopySettings", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        delete_after: "_models.DeleteOption",
        source_data_store: "_models.DataStoreInfoBase",
        target_data_store_copy_settings: Optional[list["_models.TargetCopySetting"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StopProtectionRequest(_Model):
    """Request body of Stop protection when MUA is Enabled.

    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    """

    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""

    @overload
    def __init__(
        self,
        *,
        resource_guard_operation_requests: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageSetting(_Model):
    """Storage setting.

    :ivar datastore_type: Gets or sets the type of the datastore. Known values are: "ArchiveStore",
     "OperationalStore", and "VaultStore".
    :vartype datastore_type: str or ~azure.mgmt.dataprotection.models.StorageSettingStoreTypes
    :ivar type: Gets or sets the type. Known values are: "GeoRedundant", "LocallyRedundant", and
     "ZoneRedundant".
    :vartype type: str or ~azure.mgmt.dataprotection.models.StorageSettingTypes
    """

    datastore_type: Optional[Union[str, "_models.StorageSettingStoreTypes"]] = rest_field(
        name="datastoreType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type of the datastore. Known values are: \"ArchiveStore\",
     \"OperationalStore\", and \"VaultStore\"."""
    type: Optional[Union[str, "_models.StorageSettingTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the type. Known values are: \"GeoRedundant\", \"LocallyRedundant\", and
     \"ZoneRedundant\"."""

    @overload
    def __init__(
        self,
        *,
        datastore_type: Optional[Union[str, "_models.StorageSettingStoreTypes"]] = None,
        type: Optional[Union[str, "_models.StorageSettingTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SupportedFeature(_Model):
    """Elements class for feature request.

    :ivar feature_name: support feature type.
    :vartype feature_name: str
    :ivar support_status: feature support status. Known values are: "Invalid", "NotSupported",
     "AlphaPreview", "PrivatePreview", "PublicPreview", and "GenerallyAvailable".
    :vartype support_status: str or ~azure.mgmt.dataprotection.models.FeatureSupportStatus
    :ivar exposure_controlled_features: support feature type.
    :vartype exposure_controlled_features: list[str]
    """

    feature_name: Optional[str] = rest_field(
        name="featureName", visibility=["read", "create", "update", "delete", "query"]
    )
    """support feature type."""
    support_status: Optional[Union[str, "_models.FeatureSupportStatus"]] = rest_field(
        name="supportStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """feature support status. Known values are: \"Invalid\", \"NotSupported\", \"AlphaPreview\",
     \"PrivatePreview\", \"PublicPreview\", and \"GenerallyAvailable\"."""
    exposure_controlled_features: Optional[list[str]] = rest_field(
        name="exposureControlledFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """support feature type."""

    @overload
    def __init__(
        self,
        *,
        feature_name: Optional[str] = None,
        support_status: Optional[Union[str, "_models.FeatureSupportStatus"]] = None,
        exposure_controlled_features: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SuspendBackupRequest(_Model):
    """Request body of Suspend backup when MUA is Enabled.

    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    """

    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""

    @overload
    def __init__(
        self,
        *,
        resource_guard_operation_requests: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SyncBackupInstanceRequest(_Model):
    """Sync BackupInstance Request.

    :ivar sync_type: Field indicating sync type e.g. to sync only in case of failure or in all
     cases. Known values are: "Default" and "ForceResync".
    :vartype sync_type: str or ~azure.mgmt.dataprotection.models.SyncType
    """

    sync_type: Optional[Union[str, "_models.SyncType"]] = rest_field(
        name="syncType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Field indicating sync type e.g. to sync only in case of failure or in all cases. Known values
     are: \"Default\" and \"ForceResync\"."""

    @overload
    def __init__(
        self,
        *,
        sync_type: Optional[Union[str, "_models.SyncType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.dataprotection.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.dataprotection.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaggingCriteria(_Model):
    """Tagging criteria.

    :ivar criteria: Criteria which decides whether the tag can be applied to a triggered backup.
    :vartype criteria: list[~azure.mgmt.dataprotection.models.BackupCriteria]
    :ivar is_default: Specifies if tag is default. Required.
    :vartype is_default: bool
    :ivar tagging_priority: Retention Tag priority. Required.
    :vartype tagging_priority: int
    :ivar tag_info: Retention tag information. Required.
    :vartype tag_info: ~azure.mgmt.dataprotection.models.RetentionTag
    """

    criteria: Optional[list["_models.BackupCriteria"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Criteria which decides whether the tag can be applied to a triggered backup."""
    is_default: bool = rest_field(name="isDefault", visibility=["read", "create", "update", "delete", "query"])
    """Specifies if tag is default. Required."""
    tagging_priority: int = rest_field(
        name="taggingPriority", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retention Tag priority. Required."""
    tag_info: "_models.RetentionTag" = rest_field(
        name="tagInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retention tag information. Required."""

    @overload
    def __init__(
        self,
        *,
        is_default: bool,
        tagging_priority: int,
        tag_info: "_models.RetentionTag",
        criteria: Optional[list["_models.BackupCriteria"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetCopySetting(_Model):
    """Target copy settings.

    :ivar copy_after: It can be CustomCopyOption or ImmediateCopyOption. Required.
    :vartype copy_after: ~azure.mgmt.dataprotection.models.CopyOption
    :ivar data_store: Info of target datastore. Required.
    :vartype data_store: ~azure.mgmt.dataprotection.models.DataStoreInfoBase
    """

    copy_after: "_models.CopyOption" = rest_field(
        name="copyAfter", visibility=["read", "create", "update", "delete", "query"]
    )
    """It can be CustomCopyOption or ImmediateCopyOption. Required."""
    data_store: "_models.DataStoreInfoBase" = rest_field(
        name="dataStore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Info of target datastore. Required."""

    @overload
    def __init__(
        self,
        *,
        copy_after: "_models.CopyOption",
        data_store: "_models.DataStoreInfoBase",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetDetails(_Model):
    """Class encapsulating target details, used where the destination is not a datasource.

    :ivar file_prefix: Restore operation may create multiple files inside location pointed by Url
     Below will be the common prefix for all of them. Required.
    :vartype file_prefix: str
    :ivar restore_target_location_type: Denotes the target location where the data will be
     restored,
     string value for the enum
     {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}.
     Required. Known values are: "Invalid", "AzureBlobs", and "AzureFiles".
    :vartype restore_target_location_type: str or
     ~azure.mgmt.dataprotection.models.RestoreTargetLocationType
    :ivar url: Url denoting the restore destination. It can point to container / file share etc.
     Required.
    :vartype url: str
    :ivar target_resource_arm_id: Full ARM Id denoting the restore destination. It is the ARM Id
     pointing to container / file share
     This is optional if the target subscription can be identified with the URL field. If not
     then this is needed if CrossSubscriptionRestore field of BackupVault is in any of the disabled
     states.
    :vartype target_resource_arm_id: str
    """

    file_prefix: str = rest_field(name="filePrefix", visibility=["read", "create", "update", "delete", "query"])
    """Restore operation may create multiple files inside location pointed by Url
     Below will be the common prefix for all of them. Required."""
    restore_target_location_type: Union[str, "_models.RestoreTargetLocationType"] = rest_field(
        name="restoreTargetLocationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Denotes the target location where the data will be restored,
     string value for the enum
     {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}.
     Required. Known values are: \"Invalid\", \"AzureBlobs\", and \"AzureFiles\"."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Url denoting the restore destination. It can point to container / file share etc. Required."""
    target_resource_arm_id: Optional[str] = rest_field(
        name="targetResourceArmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Full ARM Id denoting the restore destination. It is the ARM Id pointing to container / file
     share
     This is optional if the target subscription can be identified with the URL field. If not
     then this is needed if CrossSubscriptionRestore field of BackupVault is in any of the disabled
     states."""

    @overload
    def __init__(
        self,
        *,
        file_prefix: str,
        restore_target_location_type: Union[str, "_models.RestoreTargetLocationType"],
        url: str,
        target_resource_arm_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TriggerBackupRequest(_Model):
    """Trigger backup request.

    :ivar backup_rule_options: Name for the Rule of the Policy which needs to be applied for this
     backup. Required.
    :vartype backup_rule_options: ~azure.mgmt.dataprotection.models.AdHocBackupRuleOptions
    """

    backup_rule_options: "_models.AdHocBackupRuleOptions" = rest_field(
        name="backupRuleOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name for the Rule of the Policy which needs to be applied for this backup. Required."""

    @overload
    def __init__(
        self,
        *,
        backup_rule_options: "_models.AdHocBackupRuleOptions",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UnlockDeleteRequest(_Model):
    """Request body of unlock delete API.

    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar resource_to_be_deleted:
    :vartype resource_to_be_deleted: str
    """

    resource_guard_operation_requests: Optional[list[str]] = rest_field(
        name="resourceGuardOperationRequests", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGuardOperationRequests on which LAC check will be performed."""
    resource_to_be_deleted: Optional[str] = rest_field(
        name="resourceToBeDeleted", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        resource_guard_operation_requests: Optional[list[str]] = None,
        resource_to_be_deleted: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UnlockDeleteResponse(_Model):
    """Response of Unlock Delete API.

    :ivar unlock_delete_expiry_time: This is the time when unlock delete privileges will get
     expired.
    :vartype unlock_delete_expiry_time: str
    """

    unlock_delete_expiry_time: Optional[str] = rest_field(
        name="unlockDeleteExpiryTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the time when unlock delete privileges will get expired."""

    @overload
    def __init__(
        self,
        *,
        unlock_delete_expiry_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class UserFacingError(_Model):
    """Error object used by layers that have access to localized content, and propagate that to user.

    :ivar code: Unique code for this error.
    :vartype code: str
    :ivar details: Additional related Errors.
    :vartype details: list[~azure.mgmt.dataprotection.models.UserFacingError]
    :ivar inner_error: Inner Error.
    :vartype inner_error: ~azure.mgmt.dataprotection.models.InnerError
    :ivar is_retryable: Whether the operation will be retryable or not.
    :vartype is_retryable: bool
    :ivar is_user_error: Whether the operation is due to a user error or service error.
    :vartype is_user_error: bool
    :ivar properties: Any key value pairs that can be injected inside error object.
    :vartype properties: dict[str, str]
    :ivar message:
    :vartype message: str
    :ivar recommended_action: RecommendedAction � localized.
    :vartype recommended_action: list[str]
    :ivar target: Target of the error.
    :vartype target: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique code for this error."""
    details: Optional[list["_models.UserFacingError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional related Errors."""
    inner_error: Optional["_models.InnerError"] = rest_field(
        name="innerError", visibility=["read", "create", "update", "delete", "query"]
    )
    """Inner Error."""
    is_retryable: Optional[bool] = rest_field(
        name="isRetryable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the operation will be retryable or not."""
    is_user_error: Optional[bool] = rest_field(
        name="isUserError", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the operation is due to a user error or service error."""
    properties: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Any key value pairs that can be injected inside error object."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    recommended_action: Optional[list[str]] = rest_field(
        name="recommendedAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """RecommendedAction � localized."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target of the error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        details: Optional[list["_models.UserFacingError"]] = None,
        inner_error: Optional["_models.InnerError"] = None,
        is_retryable: Optional[bool] = None,
        is_user_error: Optional[bool] = None,
        properties: Optional[dict[str, str]] = None,
        message: Optional[str] = None,
        recommended_action: Optional[list[str]] = None,
        target: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserFacingWarningDetail(_Model):
    """Warning object used by layers that have access to localized content, and propagate that to
    user.

    :ivar resource_name: Name of resource for which warning is raised.
    :vartype resource_name: str
    :ivar warning: Error details for the warning. Required.
    :vartype warning: ~azure.mgmt.dataprotection.models.UserFacingError
    """

    resource_name: Optional[str] = rest_field(
        name="resourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of resource for which warning is raised."""
    warning: "_models.UserFacingError" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details for the warning. Required."""

    @overload
    def __init__(
        self,
        *,
        warning: "_models.UserFacingError",
        resource_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ValidateCrossRegionRestoreRequestObject(_Model):
    """Cross Region Restore Request Object.

    :ivar restore_request_object: Gets or sets the restore request object. Required.
    :vartype restore_request_object: ~azure.mgmt.dataprotection.models.AzureBackupRestoreRequest
    :ivar cross_region_restore_details: Cross region restore details. Required.
    :vartype cross_region_restore_details:
     ~azure.mgmt.dataprotection.models.CrossRegionRestoreDetails
    """

    restore_request_object: "_models.AzureBackupRestoreRequest" = rest_field(
        name="restoreRequestObject", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the restore request object. Required."""
    cross_region_restore_details: "_models.CrossRegionRestoreDetails" = rest_field(
        name="crossRegionRestoreDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cross region restore details. Required."""

    @overload
    def __init__(
        self,
        *,
        restore_request_object: "_models.AzureBackupRestoreRequest",
        cross_region_restore_details: "_models.CrossRegionRestoreDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ValidateForBackupRequest(_Model):
    """Validate for backup request.

    :ivar backup_instance: Backup Instance. Required.
    :vartype backup_instance: ~azure.mgmt.dataprotection.models.BackupInstance
    """

    backup_instance: "_models.BackupInstance" = rest_field(
        name="backupInstance", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Instance. Required."""

    @overload
    def __init__(
        self,
        *,
        backup_instance: "_models.BackupInstance",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ValidateForModifyBackupRequest(_Model):
    """Validate for modify backup request.

    :ivar backup_instance: Backup Instance. Required.
    :vartype backup_instance: ~azure.mgmt.dataprotection.models.BackupInstance
    """

    backup_instance: "_models.BackupInstance" = rest_field(
        name="backupInstance", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Instance. Required."""

    @overload
    def __init__(
        self,
        *,
        backup_instance: "_models.BackupInstance",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ValidateRestoreRequestObject(_Model):
    """Validate restore request object.

    :ivar restore_request_object: Gets or sets the restore request object. Required.
    :vartype restore_request_object: ~azure.mgmt.dataprotection.models.AzureBackupRestoreRequest
    """

    restore_request_object: "_models.AzureBackupRestoreRequest" = rest_field(
        name="restoreRequestObject", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the restore request object. Required."""

    @overload
    def __init__(
        self,
        *,
        restore_request_object: "_models.AzureBackupRestoreRequest",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
