% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vst.R
\name{vst}
\alias{vst}
\title{Quickly estimate dispersion trend and apply a variance stabilizing transformation}
\usage{
vst(object, blind = TRUE, nsub = 1000, fitType = "parametric")
}
\arguments{
\item{object}{a DESeqDataSet or a matrix of counts}

\item{blind}{logical, whether to blind the transformation to the experimental
design (see \code{\link{varianceStabilizingTransformation}})}

\item{nsub}{the number of genes to subset to (default 1000)}

\item{fitType}{for estimation of dispersions: this parameter
is passed on to \code{\link{estimateDispersions}} (options described there)}
}
\value{
a DESeqTranform object or a matrix of transformed, normalized counts
}
\description{
This is a wrapper for the \code{\link{varianceStabilizingTransformation}} (VST)
that provides much faster estimation of the dispersion trend used to determine
the formula for the VST. The speed-up is accomplished by
subsetting to a smaller number of genes in order to estimate this dispersion trend.
The subset of genes is chosen deterministically, to span the range
of genes' mean normalized count.
}
\examples{

dds <- makeExampleDESeqDataSet(n=2000, m=20)
vsd <- vst(dds)

}
