% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_ignorer.R
\name{RequestIgnorer}
\alias{RequestIgnorer}
\title{Request ignorer}
\description{
request ignorer methods
}
\examples{
\dontrun{
(x <- RequestIgnorer$new())
x$LOCALHOST_ALIASES
x$ignored_hosts
x$ignore_hosts(hosts = "google.com")
x$ignored_hosts
x$ignore_localhost()
x$ignored_hosts
x$ignore_localhost_value('127.0.0.1')
x$ignored_hosts
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{LOCALHOST_ALIASES}}{A constant with values: 'localhost', '127.0.0.1',
and '0.0.0.0'}

\item{\code{ignored_hosts}}{vector of ignored host URI's}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RequestIgnorer$new()}}
\item \href{#method-ignore_request}{\code{RequestIgnorer$ignore_request()}}
\item \href{#method-ignore_localhost}{\code{RequestIgnorer$ignore_localhost()}}
\item \href{#method-ignore_localhost_value}{\code{RequestIgnorer$ignore_localhost_value()}}
\item \href{#method-ignore_hosts}{\code{RequestIgnorer$ignore_hosts()}}
\item \href{#method-should_be_ignored}{\code{RequestIgnorer$should_be_ignored()}}
\item \href{#method-clone}{\code{RequestIgnorer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{RequestIgnorer} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestIgnorer$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{RequestIgnorer} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ignore_request"></a>}}
\subsection{Method \code{ignore_request()}}{
Will ignore any request for which the given function
returns \code{TRUE}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestIgnorer$ignore_request()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
no return; defines request ignorer hook
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ignore_localhost"></a>}}
\subsection{Method \code{ignore_localhost()}}{
ignore all localhost values (localhost, 127.0.0.1, 0.0.0.0)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestIgnorer$ignore_localhost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
no return; sets to ignore all localhost aliases
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ignore_localhost_value"></a>}}
\subsection{Method \code{ignore_localhost_value()}}{
ignore a specific named localhost
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestIgnorer$ignore_localhost_value(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{(character) A localhost value to ignore, e.g, 'localhost'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; defines request ignorer hook
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ignore_hosts"></a>}}
\subsection{Method \code{ignore_hosts()}}{
ignore any named host
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestIgnorer$ignore_hosts(hosts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hosts}}{(character) vector of hosts to ignore}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; adds host to ignore
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-should_be_ignored"></a>}}
\subsection{Method \code{should_be_ignored()}}{
method to determine whether to ignore a request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestIgnorer$should_be_ignored(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{request to ignore}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; defines request ignorer hook
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestIgnorer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
