// used for for P2 metric generation
// usage: crach < u.field > norm-grad-u.field
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

int main(int argc, char**argv)
{
    field uh; cin >> uh;
    space Vh = uh.get_space();
    geo omega = Vh.get_geo();
    form m(Vh, Vh, "mass");
    string approx_grad = (Vh.get_approx() == "P1") ? "P0" : "P1d";
    space Th (omega, approx_grad);
    form d_dx0(Vh, Th, "d_dx0");
    form d_dx1(Vh, Th, "d_dx1");
    form inv_mt (Th, Th, "inv_mass");
    field duh_dx0 = inv_mt*(d_dx0*uh);
    field duh_dx1 = inv_mt*(d_dx1*uh);
    field grad_norm = sqrt(duh_dx0*duh_dx0 + duh_dx1*duh_dx1);
    space Wh = space(omega, "P1"); // project on P1 for bamg
    form mw  (Wh, Wh, "mass");
    form proj (Th, Wh, "mass");
    ssk<Float> fact_mw = ldlt(mw.uu);
    field phi(Wh);
    phi.u = fact_mw.solve(proj.uu*grad_norm.u);
    int digits10 = numeric_limits<Float>::digits10;
    cout << setprecision(digits10) << phi;
    return 0;
}
