# -*- coding: utf-8 -*-

project = 'astropy-helpers'
copyright = '2014, The Astropy Developers'
author = 'The Astropy Developers'

# We need to get the version number from the package
import sys  # noqa
sys.path.insert(0, '..')
import astropy_helpers  # noqa
version = astropy_helpers.__version__
release = astropy_helpers.__version__

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'numpydoc',
    'sphinx_automodapi.automodapi'
]

numpydoc_show_class_members = False

intersphinx_mapping = {'https://docs.python.org/': None}

# The suffix(es) of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'bootstrap-astropy'

html_theme_options = {
    'logotext1': 'astropy',  # white,  semi-bold
    'logotext2': '-helpers',  # orange, light
    'logotext3': ':docs'   # white,  light
    }
