/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.util.Enumeration;
import java.util.Vector;

public class TextBlock {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static final char NL = '\r';
    private static final String columnSeparator = " | ";
    private Vector<String> lines = new Vector();
    private String spaces;
    private int width;

    public TextBlock(int n) {
        this.width = n;
        this.spaces = TextBlock.rep(" ", n);
    }

    public TextBlock(int n, String string) {
        this(n);
        this.add(string);
        this.spaces = TextBlock.rep(" ", n);
    }

    public static void main(String[] stringArray) {
        int n = 40;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TextBlock textBlock = new TextBlock(n);
        textBlock.add("Now is the time for all good men to come to the aid of their country");
        textBlock.add("Mary had a little lamb. Its fleece was white as snow.");
        textBlock.add("A veryverylongwordalmomstlikeaGermanwordinlength added here");
        System.out.println("*** left");
        System.out.println(textBlock.toString());
        TextBlock textBlock2 = new TextBlock(20);
        textBlock2.add("The quick brown fox jumped over the lazy white dog.");
        textBlock2.add("She sells sea shells by the sea shore.");
        System.out.println("*** right");
        System.out.println(textBlock2.toString());
        TextBlock textBlock3 = textBlock.join(textBlock2);
        System.out.println("*** together");
        System.out.println(textBlock3.toString());
        textBlock3.add(textBlock);
        System.out.println("*** appended");
        System.out.println(textBlock3.toString());
    }

    private static String rep(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String justifyLeft(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            return string + TextBlock.rep(" ", n - n2);
        }
        return string.substring(0, n);
    }

    public static String justifyRight(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            return TextBlock.rep(" ", n - n2) + string;
        }
        return string.substring(n2 - n);
    }

    public void add(String string) {
        int n = string.length();
        int n2 = 0;
        block0: while (n - n2 > this.width) {
            while (string.charAt(n2) == ' ') {
                if (n - ++n2 <= this.width) continue;
                break block0;
            }
            int n3 = string.lastIndexOf(32);
            while (n3 > n2 + this.width) {
                n3 = string.lastIndexOf(32, n3 - 1);
            }
            if (n3 < n2) {
                this.lines.addElement(string.substring(n2, n2 + this.width));
                n2 += this.width;
                continue;
            }
            this.lines.addElement(this.justifyLeft(string.substring(n2, n3)));
            n2 = n3 + 1;
        }
        this.lines.addElement(this.justifyLeft(string.substring(n2)));
    }

    public void addRight(String string) {
        int n = string.length();
        int n2 = 0;
        block0: while (n - n2 > this.width) {
            while (string.charAt(n2) == ' ') {
                if (n - ++n2 <= this.width) continue;
                break block0;
            }
            int n3 = string.lastIndexOf(32);
            while (n3 > n2 + this.width) {
                n3 = string.lastIndexOf(32, n3 - 1);
            }
            if (n3 < n2) {
                this.lines.addElement(string.substring(n2, n2 + this.width));
                n2 += this.width;
                continue;
            }
            this.lines.addElement(this.justifyRight(string.substring(n2, n3)));
            n2 = n3 + 1;
        }
        this.lines.addElement(this.justifyRight(string.substring(n2)));
    }

    public void add(TextBlock textBlock) {
        Enumeration<String> enumeration = textBlock.lines.elements();
        while (enumeration.hasMoreElements()) {
            this.lines.addElement(enumeration.nextElement());
        }
        this.width = Math.max(this.width, textBlock.width);
    }

    public TextBlock join(TextBlock textBlock) {
        return this.join(textBlock, columnSeparator);
    }

    public TextBlock join(TextBlock textBlock, String string) {
        int n;
        int n2 = this.size();
        int n3 = textBlock.size();
        int n4 = Math.min(n2, n3);
        TextBlock textBlock2 = new TextBlock(this.width + string.length() + textBlock.width);
        for (n = 0; n < n4; ++n) {
            textBlock2.lines.addElement(this.lines.elementAt(n) + string + textBlock.lines.elementAt(n));
        }
        if (n2 < n3) {
            for (n = n4; n < n3; ++n) {
                textBlock2.lines.addElement(this.spaces + string + textBlock.lines.elementAt(n));
            }
        } else {
            for (n = n4; n < n2; ++n) {
                textBlock2.lines.addElement(this.lines.elementAt(n) + string + this.spaces);
            }
        }
        return textBlock2;
    }

    private String justifyLeft(String string) {
        string = string + this.spaces;
        return string.substring(0, this.width);
    }

    private String justifyRight(String string) {
        string = this.spaces + string;
        int n = string.length();
        return string.substring(n - this.width);
    }

    public int size() {
        return this.lines.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<String> enumeration = this.lines.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

