package Daje::Database::View::Super::VToolsObjectsTypes;
use Mojo::Base 'Daje::Database::Model::Super::Common::Base', -base, -signatures, -async_await;
use v5.40;

# NAME
# ====
#
# Daje::Database::View::Super::VToolsObjects - It creates perl code
#
# SYNOPSIS
# ========
#
#     use Daje::Database::View::Super::VToolsObjects;
#
# DESCRIPTION
# ===========
#
# Daje::Database::View::Super::VToolsObjects is a module that retrieves data from a View
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

has 'fields' => "tools_objects_pkey, name, active, type, tools_version_fkey, tools_projects_fkey";
has 'primary_keys' => "tools_objects_pkey";
has 'foreign_keys' => "tools_version_fkey, workflow_fkey, tools_projects_fkey";
has 'view_name' => "v_tools_objects_types";


sub load_objects_type($self, $type, $tools_projects_pkey, $tools_version_pkey) {
    return $self->load_a_list(
        $self->view_name(), $self->fields(),
        {
            tools_projects_fkey => $tools_projects_pkey,
            tools_version_fkey  => $tools_version_pkey,
            type                => $type,
        }
    );
}
1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Database::View::Super::VToolsObjects - It creates perl code



=head1 SYNOPSIS


    use Daje::Database::View::Super::VToolsObjects;



=head1 DESCRIPTION


Daje::Database::View::Super::VToolsObjects is a module that retrieves data from a View



=head1 REQUIRES

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 load_objects_type($self,

 load_objects_type($self,();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

