/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionFork
implements Instruction {
    private final List<InstructionList> forks = new ArrayList<InstructionList>();
    private final Instruction parent;

    public InstructionFork(Instruction instruction) {
        this.parent = instruction;
        this.forks.add(new InstructionList());
    }

    private InstructionList getLast() {
        return this.forks.get(this.forks.size() - 1);
    }

    @Override
    public void add(Instruction instruction) {
        this.getLast().add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (InstructionList instructionList : this.forks) {
            arrayList.add(instructionList.createFtile(ftileFactory));
        }
        return ftileFactory.createFork(arrayList);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void forkAgain() {
        this.forks.add(new InstructionList());
    }

    @Override
    public final boolean kill() {
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return null;
    }

    @Override
    public void addNote(Display display, NotePosition notePosition) {
        this.getLast().addNote(display, notePosition);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.forks);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getLast().getSwimlaneOut();
    }
}

