package Bio::GMOD::Adaptor::FlyBase;

use strict;
use vars qw/@ISA $AUTOLOAD/;
use Bio::GMOD::Adaptor;
use Bio::GMOD::Util::Rearrange;

@ISA = qw/Bio::GMOD::Adaptor/;

# Bio::GMOD::Adaptor::* can optionally read defaults and current versions
# from CGI scripts If not provided, the corresponding values can be
# overridden either as constants or as options passed to the new()
# method.

my %DEFAULTS = (		
		# DEFAULTS_CGI (optional)
		# A CGI script that provides these same values
		# Full URL to CGI that delivers key value pairs of these options This
		# is optional but lets you quickly change paths to system
		# resources. Moreover, these changes willl be invisible to end user.s
		# If not provided -- or if user is working offline -- these values
		# will be populated from this module.
		# DEFAULTS_CGI => 'http://dev.wormbase.org/db/gmod/defaults',
		
		# NAME (required)
		# Symbolic name of the MOD / Adaptor
		NAME             => 'FlyBase',

		# LIVE_NAME, LIVE_URL, LIVE_DESCRIPTION (required)
		# Live public server variables
		LIVE_NAME        => 'FlyBase live server',
		LIVE_URL         => 'http://www.flybase.org',
		LIVE_DESCRIPTION => 'The FlyBase public server',
		
		# DEVELOPMENT_NAME, DEVELOPMENT_URL, DEVELOPMENT_DESCRIPTION (optional)
		# Development server variables, if applicable
		#  DEVELOPMENT_NAME => 'FlyBase development server',
		#  DEVELOPMENT_URL  => 'http://dev.flybase.org',
		#  DEVELOPMENT_DESCRIPTION => 'The FlyBase semi-public development server',		
		
		# VERSION_LIVE, VERSION_DEV (optional, but recommended!)
		# If you would like to provide your users a convenient
		# mechanism for fetching versions specify one or both
		# of these variables. At FlyBase, the version cgi
		# checks the local verison of the database and returns
		# a string.  This script is available in the cgi-bin/
		# directory.

		# Where does the version XML file live?
		# This may be a file or generated by a CGI
		VERSION_LIVE => 'http://www.flybase.org/db/gmod/version',
		# VERSION_DEV  => 'http://dev.flybase.org/db/gmod/version',

		# Where does the Standard URLs XML file live?
		STANDARD_URLS_XML => 'http://www.flybase.org/standard_urls/standard_urls.xml',

		# The FlyBase data mining URL. Generic fetching of objects by name
		DATAMINING_URL => 'http://flybase.bio.indiana.edu/docs/lk/fbhelp/fbdatamine.pl',
		
		# Gene searches
		#  GENE_SEARCH_URL => 'http://www.flybase.org/genes/fbgquery.hform',
		GENE_SEARCH_URL => 'http://www.flybase.org/.bin/fbgenq.html',
	       );


sub defaults {
  my $self = shift;
  return (keys %DEFAULTS);
}


# Automatically create lc data accessor methods
# for each configuration variable
sub AUTOLOAD {
  my $self = shift;
  my $attr = $AUTOLOAD;
  $attr =~ s/.*:://;
  return unless $attr =~ /[^A-Z]/;  # skip DESTROY and all-cap methods
  return if $attr eq 'new'; # Provided by superclass
  #  die "invalid attribute method: ->$attr()" unless $DEFAULTS{uc($attr)};
  $self->{uc($attr)} = shift if @_;
  my $val = $self->{defaults}->{lc($attr)};  # Get what is already there
  $val ||= $DEFAULTS{uc($attr)};  # Perhaps it hasn't been defined yet.
  return $val;
}

__END__

=pod

=head1 NAME

Bio::GMOD::Adaptor::FlyBase - Defaults for programmatically interacting with Wormbase

=head1 SYNPOSIS

  my $adaptor = Bio::GMOD::Adaptor::FlyBase->new();

=head1 DESCRIPTION

STUB DOCUMENTATION - PLEASE EDIT!

Bio::GMOD::Adaptor::FlyBase objects are created internally by the new()
method provided by Bio::GMOD::Adaptor.  Adaptor::* objects contain
appropriate defaults for interacting programmatically with the GMOD of
choice.

Defaults are read dynamically from the FlyBase server at runtime.
This helps to insulate your scripts from changes in the FlyBase
infrastructure.  If using Bio::GMOD offline, defaults will be
populated from those hard-coded in this adaptor.  You may also supply
these defaults as hash=>key pairs to the new method.

For descriptions of all currently known parameters, see
Bio::GMOD::Adaptor::FlyBase.pm or the default list maintained at
http://dev.wormbase.org/db/gmod/defaults

=head1 BUGS

None reported.

=head1 SEE ALSO

L<Bio::GMOD>

=head1 AUTHOR

Todd W. Harris E<lt>harris@cshl.eduE<gt>.

Copyright (c) 2003-2005 Cold Spring Harbor Laboratory.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut



1;
