# Generated by default/object.tt
package Paws::CodeGuruProfiler::AgentConfiguration;
  use Moose;
  has AgentParameters => (is => 'ro', isa => 'Paws::CodeGuruProfiler::AgentParameters', request_name => 'agentParameters', traits => ['NameInRequest']);
  has PeriodInSeconds => (is => 'ro', isa => 'Int', request_name => 'periodInSeconds', traits => ['NameInRequest'], required => 1);
  has ShouldProfile => (is => 'ro', isa => 'Bool', request_name => 'shouldProfile', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::AgentConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::AgentConfiguration object:

  $service_obj->Method(Att1 => { AgentParameters => $value, ..., ShouldProfile => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::AgentConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AgentParameters

=head1 DESCRIPTION

The response of C<ConfigureAgent>
(https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
that specifies if an agent profiles or not and for how long to return
profiling data.

=head1 ATTRIBUTES


=head2 AgentParameters => L<Paws::CodeGuruProfiler::AgentParameters>

Parameters used by the profiler. The valid parameters are:

=over

=item *

C<MaxStackDepth> - The maximum depth of the stacks in the code that is
represented in the profile. For example, if CodeGuru Profiler finds a
method C<A>, which calls method C<B>, which calls method C<C>, which
calls method C<D>, then the depth is 4. If the C<maxDepth> is set to 2,
then the profiler evaluates C<A> and C<B>.

=item *

C<MemoryUsageLimitPercent> - The percentage of memory that is used by
the profiler.

=item *

C<MinimumTimeForReportingInMilliseconds> - The minimum time in
milliseconds between sending reports.

=item *

C<ReportingIntervalInMilliseconds> - The reporting interval in
milliseconds used to report profiles.

=item *

C<SamplingIntervalInMilliseconds> - The sampling interval in
milliseconds that is used to profile samples.

=back



=head2 B<REQUIRED> PeriodInSeconds => Int

How long a profiling agent should send profiling data using
C<ConfigureAgent>
(https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html).
For example, if this is set to 300, the profiling agent calls
C<ConfigureAgent>
(https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
every 5 minutes to submit the profiled data collected during that
period.


=head2 B<REQUIRED> ShouldProfile => Bool

A C<Boolean> that specifies whether the profiling agent collects
profiling data or not. Set to C<true> to enable profiling.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

