package Net::Async::Spotify::Object::Generated::Episode;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Episode - Package representing Spotify Episode Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Episode Object attributes:

=over 4

=item audio_preview_url

Type:String
Description:A URL to a 30 second preview (MP3 format) of the episode. null if not available.

=item description

Type:String
Description:A description of the episode. HTML tags are stripped away from this field, use html_description field in case HTML tags are needed.

=item duration_ms

Type:Integer
Description:The episode length in milliseconds.

=item explicit

Type:Boolean
Description:Whether or not the episode has explicit content (true = yes it does; false = no it does not OR unknown).

=item external_urls

Type:ExternalUrlObject
Description:External URLs for this episode.

=item href

Type:String
Description:A link to the Web API endpoint providing full details of the episode.

=item html_description

Type:String
Description:A description of the episode. This field may contain HTML tags.

=item id

Type:String
Description:The Spotify ID for the episode.

=item images

Type:Array[ImageObject]
Description:The cover art for the episode in various sizes, widest first.

=item is_externally_hosted

Type:Boolean
Description:True if the episode is hosted outside of Spotify’s CDN.

=item is_playable

Type:Boolean
Description:True if the episode is playable in the given market. Otherwise false.

=item language

Type:String
Description:Note: This field is deprecated and might be removed in the future. Please use the languages field instead. The language used in the episode, identified by a ISO 639 code.

=item languages

Type:Array[String]
Description:A list of the languages used in the episode, identified by their ISO 639 code.

=item name

Type:String
Description:The name of the episode.

=item release_date

Type:String
Description:The date the episode was first released, for example "1981-12-15". Depending on the precision, it might be shown as "1981" or "1981-12".

=item release_date_precision

Type:String
Description:The precision with which release_date value is known: "year", "month", or "day".

=item restrictions

Type:EpisodeRestrictionObject
Description:Included in the response when a content restriction is applied.
See Restriction Object for more details.

=item resume_point

Type:ResumePointObject
Description:The user’s most recent position in the episode. Set if the supplied access token is a user token and has the scope user-read-playback-position.

=item show

Type:SimplifiedShowObject
Description:The show on which the episode belongs.

=item type

Type:String
Description:The object type: “episode”.

=item uri

Type:String
Description:The Spotify URI for the episode.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        audio_preview_url => 'String',
        description => 'String',
        duration_ms => 'Integer',
        explicit => 'Boolean',
        external_urls => 'ExternalUrlObject',
        href => 'String',
        html_description => 'String',
        id => 'String',
        images => 'Array[ImageObject]',
        is_externally_hosted => 'Boolean',
        is_playable => 'Boolean',
        language => 'String',
        languages => 'Array[String]',
        name => 'String',
        release_date => 'String',
        release_date_precision => 'String',
        restrictions => 'EpisodeRestrictionObject',
        resume_point => 'ResumePointObject',
        show => 'SimplifiedShowObject',
        type => 'String',
        uri => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
