package SLUB::LZA::Rosetta::TA::common_sru;
use strict;
use warnings;
use Data::Printer;

# VERSION

# ABSTRACT: common query-recipes module for ta-tool


sub prepare_query {
    my $opt = shift;
    my @queries;
    if (exists $opt->{source}) {
        push @queries, "IE.sourceMD.content=\"$opt->{source}\"";
    }
    if (exists $opt->{ie}) {
        push @queries, "IE.dc.identifier==\"$opt->{ie}\"";
    }
    if (exists $opt->{descriptive}) {
        push @queries, "IE.dc.identifier=\"$opt->{descriptive}\"";
    }
    if (exists $opt->{creationdate}) {
        push @queries, "IE.objectCharacteristics.creationDate==$opt->{creationdate}";
    }
    if (exists $opt->{modificationdate}) {
        push @queries, "FILE.objectCharacteristics.modificationDate==$opt->{modificationdate}";
    }
    if (exists $opt->{'with_format'}) {
        push @queries, "FILE.generalFileCharacteristics.formatLibraryId==$opt->{'with_format'}";
    }
    # unsupported by Rosetta <= 7.0
    #if (exists $opt->{'without_format'}) {
    #    push @queries, "FILE.generalFileCharacteristics.formatLibraryId!=$opt->{'without_format'}";
    #}
    if (exists $opt->{'with_valid_files'}) {
        push @queries, "FILE.fileValidation.isValid==true";
    }
    if (exists $opt->{'with_invalid_files'}) {
        push @queries, "FILE.fileValidation.isValid==false";
    }
    if (exists $opt->{'with_passed_viruschecks'}) {
        push @queries, "FILE.fileVirusCheck.status==true";
    }
    if (exists $opt->{'with_failed_viruschecks'}) {
        push @queries, "FILE.fileVirusCheck.status==false";
    }
    if (exists $opt->{'with_missed_viruschecks'}) {
        push @queries, "FILE.fileVirusCheck.status==\"\"";
    }
    #my $query = join(" and ", @queries);
    my $query = join("+", @queries);
    if (exists $opt->{debug}) {
        p( $opt);
        p(@queries);
        p( $query);
    }
    return $query;
}

1;
