#!/usr/bin/perl

use v5.14;
use warnings;

use Test2::V0;

BEGIN { $ENV{PERL_ASSERT_ENABLED} = 1; }  # default, but override test environment

use Syntax::Keyword::Assert;

{
   # We have to do{}-wrap one of the operands to avoid compiletime constant
   # folding before we even see it

   ok( lives { assert(do { 1 } == 1) },
      'assert ok on ==' );
   like( dies { assert(do { 1 } == 2) },     qr/^assertion failed \(got 1, expected 2\) /,
      'assert fails on ==' );

   ok( lives { assert(do { "a" } eq "a") },
      'assert ok on eq' );
   like( dies { assert(do { "a" } eq "b") }, qr/^assertion failed \(got "a", expected "b"\) /,
      'assert fails on eq' );
}

done_testing;
