#!/usr/bin/perl

package eBay::API::XML::DataType::MyMessagesExternalMessageIDArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. MyMessagesExternalMessageIDArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::MyMessagesExternalMessageIDArrayType

=head1 DESCRIPTION

Contains a list of up to 10 External MessageID values.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::MyMessagesExternalMessageIDArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::MyMessagesExternalMessageIDType;


my @gaProperties = ( [ 'ExternalMessageID', 'ns:MyMessagesExternalMessageIDType', '1'
	     ,'eBay::API::XML::DataType::MyMessagesExternalMessageIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setExternalMessageID()

An ID that Uniquely identifies a message for a given user. If provided at the time
of message creation this ID will be used to retrieve messages and will take
precedence over message ID. It can contain upto 10 message IDs.

  Calls: GetMyMessages
  RequiredInput: Conditionally

#    Argument: reference to an array  
                      of 'ns:MyMessagesExternalMessageIDType'

=cut

sub setExternalMessageID {
  my $self = shift;
  $self->{'ExternalMessageID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getExternalMessageID()

#    Returns: reference to an array  
                      of 'ns:MyMessagesExternalMessageIDType'

=cut

sub getExternalMessageID {
  my $self = shift;
  return $self->_getDataTypeArray('ExternalMessageID');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
