#!/usr/bin/perl

package eBay::API::XML::DataType::VerifiedUserRequirementsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. VerifiedUserRequirementsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::VerifiedUserRequirementsType

=head1 DESCRIPTION

Container for verified user requirements.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::VerifiedUserRequirementsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'MinimumFeedbackScore', 'xs:int', '', '', '' ]
	, [ 'VerifiedUser', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setMinimumFeedbackScore()

This field is ignored unless VerifiedUser is true.
If this field is present, the user's feedback score is also considered:
a user is blocked from bidding if the user's feedback score is
less than or equal to the value of this field.

Max: Default: 5
Min: 
  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setMinimumFeedbackScore {
  my $self = shift;
  $self->{'MinimumFeedbackScore'} = shift
}

=head2 getMinimumFeedbackScore()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:int'

=cut

sub getMinimumFeedbackScore {
  my $self = shift;
  return $self->{'MinimumFeedbackScore'};
}


=head2 setVerifiedUser()

If true, blocks bidding by users who do not pass
a simple check (for example, for credit card on file).
See "Buyer Requirements - VerifiedUser" in the chapter
"Field Differences for eBay Sites."

Default: false

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setVerifiedUser {
  my $self = shift;
  $self->{'VerifiedUser'} = shift
}

=head2 isVerifiedUser()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isVerifiedUser {
  my $self = shift;
  return $self->{'VerifiedUser'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
