/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyBuilderCondensed;

public abstract class TreeModel {
    public static final TreeModel TINY_TREE = new TinyTree();
    public static final TreeModel TINY_TREE_CONDENSED = new TinyTreeCondensed();
    public static final TreeModel LINKED_TREE = new LinkedTree();

    public abstract Builder makeBuilder(PipelineConfiguration var1);

    public int getSymbolicValue() {
        return -1;
    }

    public static TreeModel getTreeModel(int symbolicValue) {
        switch (symbolicValue) {
            case 1: {
                return TINY_TREE;
            }
            case 2: {
                return TINY_TREE_CONDENSED;
            }
            case 0: {
                return LINKED_TREE;
            }
        }
        throw new IllegalArgumentException("tree model " + symbolicValue);
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isSchemaAware() {
        return false;
    }

    public String getName() {
        return this.toString();
    }

    private static class LinkedTree
    extends TreeModel {
        private LinkedTree() {
        }

        public Builder makeBuilder(PipelineConfiguration pipe) {
            return new LinkedTreeBuilder(pipe);
        }

        public int getSymbolicValue() {
            return 0;
        }

        public boolean isMutable() {
            return true;
        }

        public boolean isSchemaAware() {
            return true;
        }

        public String getName() {
            return "LinkedTree";
        }
    }

    private static class TinyTreeCondensed
    extends TreeModel {
        private TinyTreeCondensed() {
        }

        public Builder makeBuilder(PipelineConfiguration pipe) {
            TinyBuilderCondensed tbc = new TinyBuilderCondensed(pipe);
            tbc.setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
            return tbc;
        }

        public int getSymbolicValue() {
            return 2;
        }

        public boolean isSchemaAware() {
            return true;
        }

        public String getName() {
            return "TinyTreeCondensed";
        }
    }

    private static class TinyTree
    extends TreeModel {
        private TinyTree() {
        }

        public Builder makeBuilder(PipelineConfiguration pipe) {
            TinyBuilder builder = new TinyBuilder(pipe);
            builder.setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
            return builder;
        }

        public int getSymbolicValue() {
            return 1;
        }

        public boolean isSchemaAware() {
            return true;
        }

        public String getName() {
            return "TinyTree";
        }
    }
}

