#!/usr/bin/perl
# based on fl7.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 63) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer1, "frame is layer I");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 44100, "sample rate");
	ok($frame->stereo, "stereo");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
֞                                    ?      @  %Hp? d  `@o +X	P?}u8OПڟwځ*T(o0`[@>ڼ%wHڮ_ڿɉ͋ڛo4
%xg_                                                                                                                                                                                                    ڎ                            AAڌ2eW %ICڎڿEkڢ׶m$8Hz^%K9su;w9nrڿst#GՏګs2/_8ѓڟvFLp4z3gڿ>DO1b1cڈ̱_                                                                                                                                                                                                ֞                             ڂ ڊoڣE+W3ڎgڿ5j Ap*Mښ!Cژʑڄyөڏ~ڸqS֧8.p_ڿy@1lb4iu(RÑsBәڻws
Aڮ_ڿw&N0`(S0ڦ_|"ECڈo_                                                                                                                                                                                                    ڎ                            00ځsڞO<E%J'Oڿ-Z4:hoPޟڍQNڟڋڃo_2ڜe7bNğڿCh}vkؒ%ڟx2fWktڈ-ڼ[wxڮ_ڿs2eSĨ=txCڈz_                                                                                                                                                                                                ֞                            AAx:(QWN}^<0wO$ڿ%IϻڟxbGڍs__ڋv3$fGGNǮگ]_ڿ7mΫڝX}[ڶ$*HB0_ڂ*U;w_|<yûڿw8qߓڿ(1ڐ_t,X(#0F_                                                                                                                                                                                                    ڎ                            QEQEsB%4iu1'گ_ڿy&M;xqژ~>3f0_ڄ_#G3.f_7mړ(ڰ_ڿ-ZL4˱ڗ_V'dN/_ڊ٫W6nlGKȘ,pXڿv.]ڋ{

l                                                                                                                                                                                                ֞                            aچavX7>}_sڞ>(Kڿsp2<dxQvuڥLzD'K>8gڿ#dFȬ1X_oڌ[ҷ\i0a1_ڿh1%
I˙ڗq_                                                                                                                                                                                                    ڎ                            qqrrNy0a12_ڿu!3hsZڵ#G\ns~#GڋvڤJ=ڑYڿ{pڥgPΟ)QwK._چ
R2DdڦMȻڱw_ڿm#ښHJpڔ	
'>n|                                                                                                                                                                                                ֞                              ڈ.]gď#Hڿ~.]ڳ+W_xڒ'|N6Nlڟt$4Gs8q{ڱ_ڿt,YSw3f3.f_|Q(o#HQڿj&7m+W5j                                                                                                                                                                                                    ڎ                            $I$Iڌk#Gڋڿ*UOژr);w|ΣHBw(ڱ}_ڿtJ3$fG\s6mKڗGtu˟`Pxڌd0Ȱڱa_ڿ}(Qw#Y#GWίڟ                                                                                                                                                                                                ֞                            (ڊ(ڈa{{P-[q<ڿx._clچ
ړQ&w2ڜe8Qڿ{qGavڭs\:ڧO_sR$Inڰ_ڿudSڮOڟy=kמ=                                                                                                                                                                                                    ڎ                            ,,*V0$`Hڷo		Rڐڿ-ڙAnڂUڪgOxڟڌ&1dbñ_=y+X40h_ڿک8p/ ^!COڟz AXʱ_u(ڰ)_ڿs~g3gs1cڗ/_                                                                                                                                                                                                ֞                            00v(R(̱_zگ_ڿo t4h	/_06_ڊcɱ_ڝ9[ϩڿC&L'9sm7:uڄ	I[_~3g/l_ڿyh2eCڇu@ځCڈXp                                                                                                                                                                                                    ڎ                            4M4MsHͫXڴis"'/2_ڿw-Z'Rڥ{#Ht0_ځiKڣG>)ڴSg~ڿ*-f._ډCڈڋڎ_ځ3,fWgڎڿos}._}I(E                                                                                                                                                                                                ֞                            8ڎ8xVt,utڜ:*TTڿs4iܳڹgO.tdhgw,YZp}0bڔ#'DΉڿڛh#EhڋR2e<y_ڻw:.t_ڿM#ڢGүڥ_7Qڟ                                                                                                                                                                                                    ڎ                            <<ڂ/^&lLp:|hڳg4NhڿwZot*/T^ڨ̱_s>~ot3nfڿx%~p1cڄ3e3go)˧7ڎoڿ> D@2db"TDڨQڟ                                                                                                                                                                                                ֞                            AAڊQ;wھO|oګW@ڮ_ڿ1<bxPpڠ{4jDڈqvv˙ڠAsڪV	TNnڿsh0L`lumȨQz5څ_ڴj$ڔI'`ڎڿa
;
Kژ)ڟ                                                                                                                                                                                                    ڎ                            EQEQڌw7mu2ڄevڎڿ t :O
ڝSڨ}FYz
.\'ڿuUد__sbõڈb0_sb(lPHvڄ
1Xڿ{Dڟ{ڈD                                                                                                                                                                                                ֞                            I$ڒI$چ
3f7<yڳeڛ7/_ڿa{ڜǑڏ2t(&Lډ+<Vw5nj!ASگ_ڿ~\ھ1ژ_x+Wh0_t'73.f_s<yC	ڿt5ڗwj3f'                                                                                                                                                                                                    ڎ                            M4M4||5kAK)ڐSڿ"3XƱڍ_Yڲ'OڧƯ_ڌ#G={_ڟ=ګXHPڿ..t\qx7Q_}93gJ._w\epڿt^2\d[_s4i;w                                                                                                                                                                                                ֞                            QEQEtEһw[._xfڌ=ڿ}r#Gؚ5_ssڟڈgp._0ڜa8Q.ڿl؃˙ڗ^Nڟڇ,Wڈ_ڥJ0aUڿ{ӸiӟvջwL                                                                                                                                                                                                    ڎ                            UUUUUUs#Fڤ/H_sLڌ?qtڿuJSڦMښyv?n~~2d7σڷ	nڤHQڿwښ.]Iڒ6mڟڌ6.]YڻxqڿKڲ] ں'N3Nfڟ                                                                                                                                                                                                ֞                            YeږYezj5v9áڑڿs7ݟs2e4i_v Azژ1ڑڿA l$/ڞ_ھ,\Xڷ;vڊI@ړ%[ڱ_ڿQ*Ua_+7FNڟ                                                                                                                                                                                                    ڎ                            ]u]uڄ	ӝ]_-[1d_ڿy"3,fW/(_uZڵVsNϋxsڼ/xQ@ڿv),RWzN{ڑۣGjځ
ڑ1"_
-ڄ[qڿ4 gcǟځ̓_                                                                                                                                                                                                ֞                            aaڋ+XڥKڥJ2ڴehq0_ڿ9SQڢ}ڥѻwo8x|9xڶm_tڲf%tJU0_ڿs4iگBڅtPڡڗsw/_х}
ڔ(7nڿڙ8q_	o                                                                                                                                                                                                    ڎ                            eYeYڋ*1c(Q׸ڐ/ڿcԋک3gN!dBOڟڂ_!<Bx̱_|ڔ)sڏڿw~3gt&N1c8P0ڟs:v	1_tۙگ_ڿx
8q~Bچ/_ژ7o_                                                                                                                                                                                                ֞                            iښiڄ
8±_Ǹqڿ%K'Bڅn98UЫڟڊѫXڶQlڗ
-ڃ7ڿ22ewQnڢ{`qڟv-͋ڥKsڸrd ǁڿs`-lZd._u5x                                                                                                                                                                                                    ڎ                            mmy˷ڐ!_چ)LRiڎڿ7
n/'zڥ{A_ڌm+XxP3,fWUڮ_ڿ	+W)y
Ȳe+]z4j*tTFڿu;ںwobsj#H                                                                                                                                                                                                ֞                            qqsJ,tX?p~vfD$:uڿ{5ڛڟڙȱ_چY2e P@ڙ1s4ڎiڿUڡ'N5̑ډ+V&M P M+W3Nfڿ~y2/^Qڟ                                                                                                                                                                                                    ڎ                            u]u]u"gOs>}6mڿt/P^wHڒ2d(1_|N/_%k?ڮ_ڿk?hMڛCچ"Eڸ1t_ڌգGڣoFڳeLڿ;v1bjp*
U                                                                                                                                                                                                ֞                            yڞy}J˙ڈxڜ7^ڮ_ڿtr0aqs4i-ڟt֓'o_x@$Htnڿ}d<ț16_SڥңHPڟڈkkZ_2ddǍoڿ,X\!A;xd_                                                                                                                                                                                                    ڎ                            }}ڇ5jLIΓ.d\ǩoRڿ|!yw-CڈG_s'O=nzsFڄ3oڿu0a;ڠxڍyNڝ(Qڟ~3f'5kڋ	S͟ڿWKڜژ;v'ژ	                                                                                                                                                                                                ֞                              ڌF+W73.f_s۽
ڿ=sڼ1ژ_+TVڧzL(5njv:us&ڰM_ڿs%Qڎsz3f7ɏu'<yznEڰ_ڿ &2{j(LPڗoV                                                                                                                                                                                                    ڎ                            aaڊ+UڣGHڋ(bşڿ].$\HQ^VڧOڟڄ	KYnD ڜ8}ڐڿyr2|d9utusTcns;Q*ڿv$tH{9`                                                                                                                                                                                                ֞                            (ڢ(ځYچO
0\`QRڿ	$HlP؟y˙ڗNڋtڡC14bh1r_ڿOڟ~ Sڧ@nxF"|Dڿ~t @8ڑڿs6mӳڧh1pbt>}[ڷ7nn                                                                                                                                                                                                    ڎ                            88wb1c/_|\ڿ9ڙ#ڶ,W3nfڋ/D^[ʸڱ_ڿwڱ_ښ&M4Nhڟڂd6<|1_ڿwAڤt8r2e:Ntڟ                                                                                                                                                                                                ֞                            I$I$s8q=Pztӛڱ_ڿxf#of~*,YwE._ڃ([ӹڑgڿ*$TG-_zD,ڇTڊvڿ
}ڛ8DڿG3,fW|{wh                                                                                                                                                                                                    ڎ                            YeYevmKڏ1_s.8ڑڿsX)S7e_u~+WnyKڤQHX-,ZXsڐڿ
!RڥiͣG3ڟڌakڵQjډ2eWЯڿ!ACڇ_Ek׶mڟ                                                                                                                                                                                                ֞                            iڦi$8Hz^%K9sڿu;ڰw9nrst#GՏs2/_8ѓvFLp4ڿzڙ3g>DڇOڟچ1b1c̱_ڃoڿE+ڨW3g5j Aڨp*                                                                                                                                                                                                    ڎ                            yyډM!Cʑyөڏڿ~qS֧8.p_y@ڂ1lb4iu(RÑsBәڏwڿs
Aڃ_w&N0`(S0_|"ECΈڷo_sO<ڿE%J'Oڟ-Z4:hoPڟ                                                                                                                                                                                                ֞                            ((ڌڧQNᗃoڿ_2e7bNğCڅhڟ}vkڒ%x2fڬWkڎڿt-[wx_s2eSڨ=txCz_x:(QWNڿ}^<0wO$%Iϻxb                                                                                                                                                                                                    ڎ                            iiڈGs__ڻv3$fGGNڿǮ]_7mΫX}ڇ[$*HB0_*U;ڮw_ڿ|<yڻښw8qߓ(1_t,X(#0F_sB%4iڿu1ڜ'_y&M;xq                                                                                                                                                                                                ֞                            ڪ~>3f0__#G3.f_ڿ7mГڡ(_-ZL4ژ˱_ڌV'dN/_ڏګW6nlڿGKȘ,pXv.]ڈ{

lvX7>ڮ}_ڿs>(Kږsp2<dxQvڟ                                                                                                                                                                                                    ڎ                            뮺uڦLzD'Kڎڿ>8g#dFȬ1X_ڊڊoځ[ҷ\ڿi0a1_ڒh1ڟڅ%
I˙q_rrNڿy0a12_u!3h                                                                                                                                                                                                ֞                            ,,sZ#G\nsھ~#ڌGڿvJ=Y{pgPڟځ)QwK._ک
R2DdMڿȻw_m#HJpڌ	
'>n|.ڴ]gڏڿ#Hڌ~.]óڈ+W_                                                                                                                                                                                                    ڎ                            mmx'|N6Nlt$4Gڿs8q{ڠ˱ڗ_t,YSڨw3f3.f_|ڨQ(ڿo#ڜHQژj&7ڋm+W5jk#Gڿڻڏ*UOڟ                                                                                                                                                                                                ֞                            ڮڂr);w|ڣHBڿw(}_tJږ3$fG\s6mKGtںu˟`Pڿxd0Ȱa_}(Qw#ڟڃY#GWίڱa{{Pڿ-[q<ڂx._                                                                                                                                                                                                    ڎ                            ڊcl
ȓQ&ڿw2e8Q{qGavڃs\:ڱO_ڿsR$In_udSڧOy=kڞ=*V0$`Hoڿ		Rڥ-әڧAn                                                                                                                                                                                                ڎ                            00ڌUgڼOxړ&1dbڱ_ڿ=y+X40h_ڙ8pڀ/ ^!COzڈ ڬAXڱ_ڿuڨ()_s~g3gs1c/_v(R(ڱ_ڿzڙ_o t4h                                                                                                                                                                                                ֞                            qqچ	/_06_cڱ_ڿ9[ڰکCچ&L'9sډm7:uڥ	I[ڱ_ڿ~3g/l_yh2eڧCu@CXpsHګXiڿs"'/2_w-Z'R                                                                                                                                                                                                    ڎ                            ,ڲ,{#Ht0_ڵiKGڿ>)Sg~*-f._ڌCڍȎڱ_ڿ3,fWgos}._}I(ڢExVt,uڿt:*TTڨs4iܳgO.ڟ                                                                                                                                                                                                ֞                            <<tdhڳgw,YZpڿ}0b#'Dډ˛ڗhڈ#EhکR2e<ڰy_ڿw:.t_Mڙ#Gү_ڇ7Q/^&lLp:ڿ|hسڱg4NhwZڵo                                                                                                                                                                                                    ڎ                            M4M4t*/T^̱_s>~oڿtڙ3nfx%~p1c3e3goڿ)ڧ7o> D@ڈ2dڌb"TDQکQ;wO|ڿoW@ځ_1<bxPp                                                                                                                                                                                                ֞                            ]u]u{4jDڸqvv˙AڿsV	TNnڜsh0L`ژlumڨQz5گ_ڿj$I'`a
;ژ
ډKڔ)w7mڎڿu2ev t :                                                                                                                                                                                                    ڎ                            mڶmڅO
S}ڢFYڿz
.\'uUد__sbõb0_sڰb(lPHڎڿv
1X{Dډ{ڀDځ
3f7<ڎyڿe7/ڔ_a{Ǒ                                                                                                                                                                                                ֞                            }}ڌ2t(&L+<Vw5njڿ!ASڼ_~\ڹ1_x+Wh0_tڜ'73.f_ڿs<yCڜ	t5wj3f'||5kڿAKڠ)S"3XƱ_                                                                                                                                                                                                    ڎ                            88ڋY'OƯ_#G=ڮ{_ڿ=XHPڐ..t\qxڂ7ڨQ_}93gJ._ڿw\ept^ھ2\dڸ[_s4i;wڌtڢEڻw[._ڿxf=}r#Gؚ5_                                                                                                                                                                                                ֞                            yyڃssڍڳgp._ڿ0a8Q.ڊl؃ڟڋ˙^N,Wگ_ڿJ0aU{ڸiڟvջwLs#F/H_ڿsL?qtuJڕSڨM                                                                                                                                                                                                    ڎ                            ں뮺yv?n~~2d7σڿ	nHQڊw.]ڌI6mڛ6.]ڿYxqږKژڀ] 'N3Nfzڴj5ڿv9ڡ̑ڙs7ڟ                                                                                                                                                                                                ֞                            s2e4i_v Aڿz1ڛȑڑA ڂl$/_څ,\X;vI@ڿ%[ں_Qڢ*Ua_ډ+7FN	ӝ]ڰ_ڿ-[1d_y"3,fW/(_                                                                                                                                                                                                    ڎ                            <<uZVsNڋxڿs/xQ@v),RWzNڟ{ۣGjڇ
ȑ1"_ڿ
-[q4 gcڟڌ̓ځ_+XKڿJ2ehq0_9SڧQ                                                                                                                                                                                                ֞                            }}}ѻwڜo8x|ڼ9xڱm_ڿtf%tJU0ڪ_s4i˯ڗBtP͗ڹsw/_хڿ}
(7nڕۙڷ8q_ڇ	oڕ*1ڔc(Qڿ׸/cԋ3gڟ                                                                                                                                                                                                    ڎ                            ھڇN!dBO_!<Bxڱ_ڿ|)sڨw~3gڟt&N1c8P0s:v	1_ڿtڙׯگ_xڲ
ڇ8qڟ~B/_7o_
ڛ8ڱ_ڿگǸq%K'B΅ڟ                                                                                                                                                                                                
