# Generated by default/object.tt
package Paws::AppMesh::OutlierDetection;
  use Moose;
  has BaseEjectionDuration => (is => 'ro', isa => 'Paws::AppMesh::Duration', request_name => 'baseEjectionDuration', traits => ['NameInRequest'], required => 1);
  has Interval => (is => 'ro', isa => 'Paws::AppMesh::Duration', request_name => 'interval', traits => ['NameInRequest'], required => 1);
  has MaxEjectionPercent => (is => 'ro', isa => 'Int', request_name => 'maxEjectionPercent', traits => ['NameInRequest'], required => 1);
  has MaxServerErrors => (is => 'ro', isa => 'Int', request_name => 'maxServerErrors', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::OutlierDetection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::OutlierDetection object:

  $service_obj->Method(Att1 => { BaseEjectionDuration => $value, ..., MaxServerErrors => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::OutlierDetection object:

  $result = $service_obj->Method(...);
  $result->Att1->BaseEjectionDuration

=head1 DESCRIPTION

An object that represents the outlier detection for a virtual node's
listener.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BaseEjectionDuration => L<Paws::AppMesh::Duration>

The base amount of time for which a host is ejected.


=head2 B<REQUIRED> Interval => L<Paws::AppMesh::Duration>

The time interval between ejection sweep analysis.


=head2 B<REQUIRED> MaxEjectionPercent => Int

Maximum percentage of hosts in load balancing pool for upstream service
that can be ejected. Will eject at least one host regardless of the
value.


=head2 B<REQUIRED> MaxServerErrors => Int

Number of consecutive C<5xx> errors required for ejection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

