use strict;
use Test::More tests => 3856;
use Jcode;

BEGIN { use_ok 'Location::Area::DoCoMo::iArea' }

my %scaned;

while (<DATA>) {
  my ($id,$name,$wara,$sara,$eara,$nara,$lat,$long) = split(/,/,$_);
  my $obj = Location::Area::DoCoMo::iArea->create_coord($lat,$long,'tokyo','gpsone');
  next unless ($obj);
  is ($obj->name, $name);
  unless ($scaned{$id})
  {
    $obj = Location::Area::DoCoMo::iArea->create_iarea($id);
    is ($obj->name, $name);
    my $aura = $obj->get_aura;
    my ($s,$w,$n,$e) = map { int($_ * 1000) } $aura->datum_tokyo->format_second->array;
    ok (($s eq $sara) && ($w eq $wara) && ($n eq $nara) && ($e eq $eara));
    $scaned{$id} = 1;
  }
}
__END__
00100,ȡ/,501553125,148856250,508387500,153450000,41.35.08.213,139.58.18.018
00100,ȡ/,501553125,148856250,508387500,153450000,42.07.32.152,140.35.41.769
00100,ȡ/,501553125,148856250,508387500,153450000,42.31.19.153,140.22.41.765
00100,ȡ/,501553125,148856250,508387500,153450000,41.26.15.762,139.57.41.303
00100,ȡ/,501553125,148856250,508387500,153450000,41.30.26.741,139.19.16.692
00100,ȡ/,501553125,148856250,508387500,153450000,41.56.20.363,140.56.20.751
00100,ȡ/,501553125,148856250,508387500,153450000,41.44.30.887,141.05.49.883
00100,ȡ/,501553125,148856250,508387500,153450000,41.29.02.322,139.20.17.258
00100,ȡ/,501553125,148856250,508387500,153450000,41.25.22.126,140.16.30.750
00100,ȡ/,501553125,148856250,508387500,153450000,41.30.43.399,140.30.08.338
00100,ȡ/,501553125,148856250,508387500,153450000,41.32.24.422,140.30.08.121
00100,ȡ/,501553125,148856250,508387500,153450000,41.35.29.337,140.30.07.441
00100,ȡ/,501553125,148856250,508387500,153450000,41.36.08.673,140.30.04.463
00100,ȡ/,501553125,148856250,508387500,153450000,41.43.44.512,140.47.14.160
00100,ȡ/,501553125,148856250,508387500,153450000,41.43.39.780,140.53.01.625
00100,ȡ/,501553125,148856250,508387500,153450000,41.59.39.150,140.56.25.526
00100,ȡ/,501553125,148856250,508387500,153450000,41.45.33.374,141.12.38.220
00100,ȡ/,501553125,148856250,508387500,153450000,41.52.52.339,141.08.28.713
00100,ȡ/,501553125,148856250,508387500,153450000,42.00.38.187,140.55.15.848
00100,ȡ/,501553125,148856250,508387500,153450000,42.02.24.546,140.52.32.075
00100,ȡ/,501553125,148856250,508387500,153450000,42.05.08.630,140.48.47.229
00100,ȡ/,501553125,148856250,508387500,153450000,42.14.24.432,140.19.52.944
00100,ȡ/,501553125,148856250,508387500,153450000,42.13.21.958,140.25.00.815
00101,/ɰ,501806250,149700000,505575000,153450000,41.55.06.574,140.22.42.510
00101,/ɰ,501806250,149700000,505575000,153450000,42.05.39.431,139.23.27.136
00101,/ɰ,501806250,149700000,505575000,153450000,42.12.37.230,139.33.45.915
00101,/ɰ,501806250,149700000,505575000,153450000,41.40.05.703,139.59.12.379
00101,/ɰ,501806250,149700000,505575000,153450000,42.04.49.825,140.02.05.788
00101,/ɰ,501806250,149700000,505575000,153450000,41.43.17.368,139.59.52.817
00101,/ɰ,501806250,149700000,505575000,153450000,42.02.25.162,139.23.49.947
00101,/ɰ,501806250,149700000,505575000,153450000,42.07.32.615,139.52.28.519
00101,/ɰ,501806250,149700000,505575000,153450000,42.13.49.111,139.44.49.245
00101,/ɰ,501806250,149700000,505575000,153450000,42.22.29.128,139.44.53.190
00101,/ɰ,501806250,149700000,505575000,153450000,42.33.34.097,139.48.41.088
00201,î/,503325000,153150000,508500000,156159375,42.37.37.863,140.30.09.401
00201,î/,503325000,153150000,508500000,156159375,42.40.02.531,140.03.56.889
00201,î/,503325000,153150000,508500000,156159375,43.15.43.799,140.42.19.800
00201,î/,503325000,153150000,508500000,156159375,42.50.06.379,140.13.01.711
00201,î/,503325000,153150000,508500000,156159375,42.51.03.153,140.16.57.912
00201,î/,503325000,153150000,508500000,156159375,43.06.12.081,140.20.55.774
00201,î/,503325000,153150000,508500000,156159375,43.06.06.945,140.22.12.056
00201,î/,503325000,153150000,508500000,156159375,43.07.56.405,140.18.40.385
00201,î/,503325000,153150000,508500000,156159375,43.10.22.297,140.18.36.264
00201,î/,503325000,153150000,508500000,156159375,43.11.34.269,140.18.38.381
00201,î/,503325000,153150000,508500000,156159375,43.19.21.889,140.18.43.167
00201,î/,503325000,153150000,508500000,156159375,43.16.02.442,140.43.37.092
00201,î/,503325000,153150000,508500000,156159375,43.15.59.700,140.44.06.672
00201,î/,503325000,153150000,508500000,156159375,43.10.47.763,141.07.38.009
00201,î/,503325000,153150000,508500000,156159375,43.11.57.427,141.11.09.438
00201,î/,503325000,153150000,508500000,156159375,43.20.03.861,140.33.55.566
00202,Ѿ/,506025000,152240625,512325000,154650000,42.45.05.709,142.00.12.310
00202,Ѿ/,506025000,152240625,512325000,154650000,42.24.45.027,141.13.11.250
00202,Ѿ/,506025000,152240625,512325000,154650000,42.29.44.128,141.20.46.350
00202,Ѿ/,506025000,152240625,512325000,154650000,42.32.27.809,140.42.26.600
00202,Ѿ/,506025000,152240625,512325000,154650000,42.32.25.450,140.44.02.019
00202,Ѿ/,506025000,152240625,512325000,154650000,42.17.23.997,141.01.58.955
00203,丫/,509400000,154200000,512550000,160050000,43.12.32.528,141.41.26.495
00204,/,510960937,150900000,516178125,154800000,42.12.31.252,142.30.11.088
00204,/,510960937,150900000,516178125,154800000,42.00.01.814,143.15.03.292
00204,/,510960937,150900000,516178125,154800000,42.09.45.928,143.22.43.132
00204,/,510960937,150900000,516178125,154800000,41.57.47.999,143.18.53.470
00204,/,510960937,150900000,516178125,154800000,42.09.56.705,142.38.07.041
00204,/,510960937,150900000,516178125,154800000,42.12.24.748,142.30.12.393
00204,/,510960937,150900000,516178125,154800000,42.17.23.391,142.24.11.895
00204,/,510960937,150900000,516178125,154800000,42.21.01.361,142.14.48.163
00204,/,510960937,150900000,516178125,154800000,42.24.59.403,142.07.34.888
00205,̹//,508275000,153600000,510525000,154950000,43.01.23.252,141.30.55.477
00206,ڱؼ,508837500,155006250,508907812,155043750,43.03.38.011,141.21.18.400
00207,̸,508809375,154987500,508907812,155015625,43.03.23.649,141.21.10.482
00208,,508865625,154978125,508907812,154996875,43.03.09.522,141.21.35.145
00209,,508865625,154931250,508921875,154978125,43.02.14.725,141.21.42.376
00210,/߻/,508654687,154893750,508837500,155090625,43.03.29.105,141.18.42.680
00211,,508893750,154978125,509020312,155043750,43.03.27.509,141.21.52.888
00212,ɡ/,508753125,154800000,508893750,154987500,43.01.01.232,141.19.53.807
00213,24/,508725000,155043750,508893750,155156250,43.05.39.709,141.20.31.272
00214,/ƻ,508584375,155146875,509189062,155475000,43.08.53.132,141.20.17.531
00215,,508851562,155043750,509259375,155371875,43.06.51.891,141.27.16.568
00216,׻/Ȭ,508626562,154996875,508795312,155165625,43.03.20.485,141.17.21.502
00217,/ܤ/,508190625,154856250,508696875,155353125,43.08.08.587,141.16.01.472
00218,ʿ//,508879687,154556250,509062500,154968750,43.01.13.785,141.23.35.151
00219,˭ʿ//,508921875,154387500,509343750,154996875,43.00.40.012,141.26.19.064
00220,,508935937,154875000,509315625,155156250,43.02.25.652,141.24.02.886
00221,,509217187,154818750,509442187,155128125,43.01.23.603,141.28.10.619
00222,/׷,507600000,154050000,509034375,155100000,43.02.32.275,141.10.20.454
00222,/׷,507600000,154050000,509034375,155100000,42.59.27.752,141.20.41.750
00222,/׷,507600000,154050000,509034375,155100000,43.01.22.507,141.12.23.575
00223,/м,508500000,154950000,510075000,157350000,43.11.23.431,141.18.48.621
00223,/м,508500000,154950000,510075000,157350000,43.06.40.881,141.27.52.627
00223,/м,508500000,154950000,510075000,157350000,43.05.45.003,141.27.14.566
00223,/м,508500000,154950000,510075000,157350000,43.03.09.318,141.30.32.334
00223,/м,508500000,154950000,510075000,157350000,43.15.26.931,141.16.48.934
00223,/м,508500000,154950000,510075000,157350000,43.23.46.942,141.21.56.805
00223,/м,508500000,154950000,510075000,157350000,43.10.16.579,141.25.36.274
00300,/,511200000,154350000,515475000,161700000,43.10.02.990,142.37.39.135
00300,/,511200000,154350000,515475000,161700000,44.00.08.634,142.45.07.434
00300,/,511200000,154350000,515475000,161700000,43.37.38.034,142.18.55.112
00301,/ë,507403125,160500000,514575000,163959375,45.12.33.097,141.33.49.286
00301,/ë,507403125,160500000,514575000,163959375,44.47.37.868,142.18.56.490
00301,/ë,507403125,160500000,514575000,163959375,45.17.33.064,140.57.16.279
00301,/ë,507403125,160500000,514575000,163959375,45.05.26.865,141.09.24.614
00301,/ë,507403125,160500000,514575000,163959375,44.43.31.781,142.48.57.354
00301,/ë,507403125,160500000,514575000,163959375,44.44.29.746,142.48.52.210
00301,/ë,507403125,160500000,514575000,163959375,45.07.31.557,142.28.37.224
00301,/ë,507403125,160500000,514575000,163959375,45.03.57.373,141.37.25.613
00301,/ë,507403125,160500000,514575000,163959375,45.05.17.566,141.17.25.479
00301,/ë,507403125,160500000,514575000,163959375,45.06.47.763,141.33.41.564
00301,/ë,507403125,160500000,514575000,163959375,45.14.13.972,141.21.17.517
00301,/ë,507403125,160500000,514575000,163959375,45.16.14.211,141.33.32.404
00301,/ë,507403125,160500000,514575000,163959375,44.52.56.924,142.41.28.094
00301,/ë,507403125,160500000,514575000,163959375,45.05.02.192,142.31.22.042
00301,/ë,507403125,160500000,514575000,163959375,45.17.16.024,142.18.47.861
00301,/ë,507403125,160500000,514575000,163959375,45.17.34.390,142.15.03.683
00301,/ë,507403125,160500000,514575000,163959375,45.20.00.710,141.35.18.124
00301,/ë,507403125,160500000,514575000,163959375,45.23.02.377,141.37.27.125
00301,/ë,507403125,160500000,514575000,163959375,45.27.35.309,141.43.10.275
00301,/ë,507403125,160500000,514575000,163959375,45.32.38.655,141.53.00.828
00301,/ë,507403125,160500000,514575000,163959375,45.32.32.665,141.55.03.892
00301,/ë,507403125,160500000,514575000,163959375,45.32.31.045,141.56.06.111
00301,/ë,507403125,160500000,514575000,163959375,45.20.04.471,142.14.48.531
00302,α˨,508612500,157350000,511875000,162300000,44.05.08.840,142.00.03.357
00302,α˨,508612500,157350000,511875000,162300000,44.26.22.208,141.23.35.330
00302,α˨,508612500,157350000,511875000,162300000,43.46.01.922,141.18.35.611
00302,α˨,508612500,157350000,511875000,162300000,43.50.04.299,141.22.60.000
00302,α˨,508612500,157350000,511875000,162300000,44.05.02.481,141.37.21.654
00302,α˨,508612500,157350000,511875000,162300000,44.16.08.580,141.37.23.116
00302,α˨,508612500,157350000,511875000,162300000,44.21.57.544,141.37.24.840
00302,α˨,508612500,157350000,511875000,162300000,44.25.42.306,141.41.08.489
00302,α˨,508612500,157350000,511875000,162300000,44.30.52.043,141.44.56.717
00302,α˨,508612500,157350000,511875000,162300000,44.38.53.784,141.44.57.969
00302,α˨,508612500,157350000,511875000,162300000,44.54.00.217,141.41.11.630
00400,/̸/,513450000,156450000,523125000,160800000,43.55.03.412,143.45.10.277
00400,/̸/,513450000,156450000,523125000,160800000,43.37.31.978,143.45.11.420
00500,ӹ/,513675000,151800000,518400000,157050000,43.20.02.788,143.22.36.551
00600,ϩ,517275000,154200000,523125000,157350000,42.57.34.185,144.18.51.702
00601,,520650000,155250000,525150000,159759375,43.30.03.457,145.07.30.822
00601,,520650000,155250000,525150000,159759375,43.32.38.654,144.41.25.193
00700,δ,506685937,139471875,509400000,141553125,38.48.52.171,141.20.43.198
00700,δ,506685937,139471875,509400000,141553125,39.01.18.016,140.47.55.511
00700,δ,506685937,139471875,509400000,141553125,38.49.28.740,141.19.42.814
00700,δ,506685937,139471875,509400000,141553125,38.49.29.684,141.26.26.224
00700,δ,506685937,139471875,509400000,141553125,38.55.08.835,140.54.56.917
00700,δ,506685937,139471875,509400000,141553125,38.55.24.356,140.54.52.902
00700,δ,506685937,139471875,509400000,141553125,39.07.51.889,140.45.37.092
00700,δ,506685937,139471875,509400000,141553125,38.45.56.887,141.25.03.288
00700,δ,506685937,139471875,509400000,141553125,38.49.24.021,141.27.13.512
00700,δ,506685937,139471875,509400000,141553125,39.06.22.299,141.25.51.648
00700,δ,506685937,139471875,509400000,141553125,39.13.51.560,141.04.45.267
00700,δ,506685937,139471875,509400000,141553125,39.17.32.735,141.14.36.639
00700,δ,506685937,139471875,509400000,141553125,38.57.07.306,140.49.57.135
00700,δ,506685937,139471875,509400000,141553125,39.09.54.979,140.46.22.265
00700,δ,506685937,139471875,509400000,141553125,38.44.40.611,141.13.51.034
00700,δ,506685937,139471875,509400000,141553125,38.48.34.225,141.27.45.986
00700,δ,506685937,139471875,509400000,141553125,39.06.35.956,141.25.15.795
00700,δ,506685937,139471875,509400000,141553125,39.11.45.589,141.24.28.453
00800,,506348437,141009375,510693750,145350000,40.00.01.231,141.07.32.410
00800,,506348437,141009375,510693750,145350000,39.32.34.758,141.41.23.854
00800,,506348437,141009375,510693750,145350000,39.12.35.851,140.52.36.335
00800,,506348437,141009375,510693750,145350000,39.42.32.006,141.41.21.023
00800,,506348437,141009375,510693750,145350000,39.12.31.153,141.28.12.017
00800,,506348437,141009375,510693750,145350000,39.28.12.611,141.41.15.999
00800,,506348437,141009375,510693750,145350000,40.11.20.517,140.53.32.377
00800,,506348437,141009375,510693750,145350000,40.17.31.793,141.11.17.746
00800,,506348437,141009375,510693750,145350000,39.12.16.260,140.55.02.234
00800,,506348437,141009375,510693750,145350000,39.15.58.037,141.21.07.568
00800,,506348437,141009375,510693750,145350000,39.30.41.636,140.43.42.966
00800,,506348437,141009375,510693750,145350000,39.22.36.362,141.39.24.658
00800,,506348437,141009375,510693750,145350000,39.44.29.238,141.41.52.023
00800,,506348437,141009375,510693750,145350000,39.45.07.253,141.38.33.497
00800,,506348437,141009375,510693750,145350000,39.57.57.259,141.34.42.631
00800,,506348437,141009375,510693750,145350000,40.13.32.033,141.33.51.489
00800,,506348437,141009375,510693750,145350000,40.19.24.943,141.13.47.020
00800,,506348437,141009375,510693750,145350000,40.20.42.473,141.23.03.475
00800,,506348437,141009375,510693750,145350000,39.14.15.892,140.57.46.668
00800,,506348437,141009375,510693750,145350000,39.15.35.732,140.44.07.893
00800,,506348437,141009375,510693750,145350000,39.17.43.648,140.41.30.521
00800,,506348437,141009375,510693750,145350000,39.14.19.915,141.23.50.755
00800,,506348437,141009375,510693750,145350000,39.17.58.874,141.14.17.034
00800,,506348437,141009375,510693750,145350000,39.18.56.347,141.15.40.987
00800,,506348437,141009375,510693750,145350000,39.26.10.351,140.41.01.776
00800,,506348437,141009375,510693750,145350000,39.30.39.174,140.43.23.570
00800,,506348437,141009375,510693750,145350000,39.46.40.362,140.49.29.266
00800,,506348437,141009375,510693750,145350000,39.53.29.933,140.51.52.045
00800,,506348437,141009375,510693750,145350000,39.54.32.945,140.51.59.201
00800,,506348437,141009375,510693750,145350000,39.20.34.901,141.40.02.103
00800,,506348437,141009375,510693750,145350000,39.23.56.189,141.44.27.319
00800,,506348437,141009375,510693750,145350000,39.36.45.673,141.49.54.541
00800,,506348437,141009375,510693750,145350000,39.43.48.950,141.37.17.615
00800,,506348437,141009375,510693750,145350000,39.43.46.411,141.46.54.167
00800,,506348437,141009375,510693750,145350000,39.45.10.025,141.24.51.780
00800,,506348437,141009375,510693750,145350000,39.48.24.451,141.31.13.228
00800,,506348437,141009375,510693750,145350000,39.55.14.228,141.33.47.744
00800,,506348437,141009375,510693750,145350000,40.08.13.034,140.51.55.026
00800,,506348437,141009375,510693750,145350000,40.14.09.340,141.02.30.676
00800,,506348437,141009375,510693750,145350000,40.17.00.351,141.06.21.590
00800,,506348437,141009375,510693750,145350000,40.19.54.320,141.14.27.087
00800,,506348437,141009375,510693750,145350000,40.21.03.645,141.32.39.202
00900,,509020312,140156250,511495312,145621875,40.12.37.859,141.45.07.578
00900,,509020312,140156250,511495312,145621875,39.15.05.944,141.43.16.347
00900,,509020312,140156250,511495312,145621875,39.23.48.182,141.56.15.833
00900,,509020312,140156250,511495312,145621875,40.11.16.733,141.45.06.915
00900,,509020312,140156250,511495312,145621875,39.01.57.683,141.47.55.410
00900,,509020312,140156250,511495312,145621875,39.06.21.572,141.49.48.202
00900,,509020312,140156250,511495312,145621875,39.11.20.672,141.29.09.363
00900,,509020312,140156250,511495312,145621875,39.16.22.433,141.54.26.306
00900,,509020312,140156250,511495312,145621875,39.27.33.272,141.44.15.896
00900,,509020312,140156250,511495312,145621875,39.52.35.288,141.57.15.435
00900,,509020312,140156250,511495312,145621875,39.37.38.812,142.00.01.320
00900,,509020312,140156250,511495312,145621875,40.03.51.663,141.49.44.211
00900,,509020312,140156250,511495312,145621875,38.56.20.180,141.41.45.558
00900,,509020312,140156250,511495312,145621875,39.02.31.955,141.29.10.112
00900,,509020312,140156250,511495312,145621875,39.05.26.210,141.48.52.187
00900,,509020312,140156250,511495312,145621875,39.09.06.262,141.50.43.454
00900,,509020312,140156250,511495312,145621875,39.22.32.124,141.40.51.308
00900,,509020312,140156250,511495312,145621875,39.22.50.461,141.40.50.334
00900,,509020312,140156250,511495312,145621875,39.26.56.403,141.59.36.149
00900,,509020312,140156250,511495312,145621875,39.44.30.479,141.45.31.112
00900,,509020312,140156250,511495312,145621875,39.46.53.179,141.59.41.057
00900,,509020312,140156250,511495312,145621875,39.48.32.819,141.59.11.177
00900,,509020312,140156250,511495312,145621875,39.49.11.903,141.59.13.816
00900,,509020312,140156250,511495312,145621875,39.27.55.203,142.03.56.509
00900,,509020312,140156250,511495312,145621875,39.31.38.364,142.03.47.929
00900,,509020312,140156250,511495312,145621875,40.07.33.848,141.28.38.627
00900,,509020312,140156250,511495312,145621875,40.16.53.830,141.48.19.656
00900,,509020312,140156250,511495312,145621875,40.25.20.598,141.42.13.742
00900,,509020312,140156250,511495312,145621875,38.59.24.505,141.40.45.295
00900,,509020312,140156250,511495312,145621875,39.03.28.315,141.29.19.160
00900,,509020312,140156250,511495312,145621875,39.06.48.694,141.25.16.483
00900,,509020312,140156250,511495312,145621875,39.05.53.376,141.55.38.312
00900,,509020312,140156250,511495312,145621875,39.12.00.752,141.54.35.397
00900,,509020312,140156250,511495312,145621875,39.12.25.225,141.55.53.557
00900,,509020312,140156250,511495312,145621875,39.14.29.826,141.55.25.902
00900,,509020312,140156250,511495312,145621875,39.17.58.728,141.55.17.505
00900,,509020312,140156250,511495312,145621875,39.21.57.168,141.58.08.796
00900,,509020312,140156250,511495312,145621875,39.25.52.386,141.44.27.617
00900,,509020312,140156250,511495312,145621875,39.26.28.449,141.43.55.482
00900,,509020312,140156250,511495312,145621875,39.34.10.340,141.48.28.614
00900,,509020312,140156250,511495312,145621875,39.36.24.857,141.50.04.287
00900,,509020312,140156250,511495312,145621875,39.38.43.121,141.59.40.384
00900,,509020312,140156250,511495312,145621875,39.42.45.038,141.35.39.714
00900,,509020312,140156250,511495312,145621875,39.47.57.237,141.31.44.215
00900,,509020312,140156250,511495312,145621875,39.49.20.416,141.59.33.069
00900,,509020312,140156250,511495312,145621875,39.56.08.567,141.35.27.713
00900,,509020312,140156250,511495312,145621875,39.57.27.814,141.35.53.479
00900,,509020312,140156250,511495312,145621875,39.29.34.970,142.01.08.391
00900,,509020312,140156250,511495312,145621875,39.33.28.169,142.04.19.487
00900,,509020312,140156250,511495312,145621875,40.03.28.686,141.32.19.755
00900,,509020312,140156250,511495312,145621875,40.04.23.394,141.32.12.409
00900,,509020312,140156250,511495312,145621875,40.00.43.328,141.54.46.730
00900,,509020312,140156250,511495312,145621875,40.06.28.606,141.50.15.704
00900,,509020312,140156250,511495312,145621875,40.12.21.669,141.48.47.533
00900,,509020312,140156250,511495312,145621875,40.23.37.402,141.43.44.680
01000,Ȭ,506742187,144787500,510089062,149596875,40.27.33.954,140.56.17.303
01000,Ȭ,506742187,144787500,510089062,149596875,41.12.35.278,141.00.08.316
01000,Ȭ,506742187,144787500,510089062,149596875,41.16.20.379,141.13.13.656
01000,Ȭ,506742187,144787500,510089062,149596875,40.20.08.636,140.58.11.263
01000,Ȭ,506742187,144787500,510089062,149596875,40.20.07.692,140.59.16.250
01000,Ȭ,506742187,144787500,510089062,149596875,40.21.21.952,141.21.35.739
01000,Ȭ,506742187,144787500,510089062,149596875,40.34.31.165,141.28.09.035
01000,Ȭ,506742187,144787500,510089062,149596875,40.31.17.456,141.30.59.181
01000,Ȭ,506742187,144787500,510089062,149596875,40.30.01.148,141.35.44.052
01000,Ȭ,506742187,144787500,510089062,149596875,40.43.13.986,141.24.26.104
01000,Ȭ,506742187,144787500,510089062,149596875,40.57.30.507,141.22.41.041
01000,Ȭ,506742187,144787500,510089062,149596875,40.13.27.888,140.59.15.551
01000,Ȭ,506742187,144787500,510089062,149596875,40.22.12.658,140.59.43.712
01000,Ȭ,506742187,144787500,510089062,149596875,40.22.13.407,141.30.10.079
01000,Ȭ,506742187,144787500,510089062,149596875,40.25.27.469,141.37.31.906
01000,Ȭ,506742187,144787500,510089062,149596875,40.35.23.792,141.28.13.983
01000,Ȭ,506742187,144787500,510089062,149596875,41.11.57.106,140.46.36.755
01000,Ȭ,506742187,144787500,510089062,149596875,41.11.23.280,140.58.18.538
01000,Ȭ,506742187,144787500,510089062,149596875,41.04.46.296,141.14.37.291
01000,Ȭ,506742187,144787500,510089062,149596875,41.24.10.565,140.50.20.559
01000,Ȭ,506742187,144787500,510089062,149596875,41.27.38.764,140.52.40.607
01000,Ȭ,506742187,144787500,510089062,149596875,41.28.52.645,141.00.12.982
01000,Ȭ,506742187,144787500,510089062,149596875,41.28.16.187,141.05.14.806
01000,Ȭ,506742187,144787500,510089062,149596875,40.19.30.924,140.57.31.423
01000,Ȭ,506742187,144787500,510089062,149596875,40.28.11.437,140.52.24.345
01000,Ȭ,506742187,144787500,510089062,149596875,40.32.55.013,140.51.27.782
01000,Ȭ,506742187,144787500,510089062,149596875,40.39.08.999,140.57.37.308
01000,Ȭ,506742187,144787500,510089062,149596875,40.22.08.299,141.23.48.109
01000,Ȭ,506742187,144787500,510089062,149596875,40.22.07.476,141.24.17.203
01000,Ȭ,506742187,144787500,510089062,149596875,40.23.31.039,141.34.42.831
01000,Ȭ,506742187,144787500,510089062,149596875,40.30.39.252,141.36.37.393
01000,Ȭ,506742187,144787500,510089062,149596875,40.42.08.476,140.57.58.921
01000,Ȭ,506742187,144787500,510089062,149596875,41.07.25.344,140.48.01.395
01000,Ȭ,506742187,144787500,510089062,149596875,41.09.36.628,140.54.03.329
01000,Ȭ,506742187,144787500,510089062,149596875,41.10.53.638,140.57.43.553
01000,Ȭ,506742187,144787500,510089062,149596875,40.52.16.664,141.07.08.529
01000,Ȭ,506742187,144787500,510089062,149596875,40.53.57.614,141.10.43.946
01000,Ȭ,506742187,144787500,510089062,149596875,41.08.14.907,141.16.20.903
01000,Ȭ,506742187,144787500,510089062,149596875,41.09.35.003,141.16.41.267
01000,Ȭ,506742187,144787500,510089062,149596875,41.12.54.995,141.24.24.372
01000,Ȭ,506742187,144787500,510089062,149596875,41.30.55.334,140.54.05.172
01000,Ȭ,506742187,144787500,510089062,149596875,41.21.38.935,141.21.08.435
01000,Ȭ,506742187,144787500,510089062,149596875,41.29.19.280,141.00.08.881
01100,Ŀ,505209375,146156250,507923437,148546875,40.46.23.225,140.52.31.691
01100,Ŀ,505209375,146156250,507923437,148546875,40.47.35.659,140.56.26.307
01100,Ŀ,505209375,146156250,507923437,148546875,41.08.50.061,140.24.25.377
01100,Ŀ,505209375,146156250,507923437,148546875,40.38.53.378,140.56.22.421
01100,Ŀ,505209375,146156250,507923437,148546875,41.08.46.088,140.37.43.315
01100,Ŀ,505209375,146156250,507923437,148546875,40.38.49.833,140.55.57.153
01100,Ŀ,505209375,146156250,507923437,148546875,40.47.12.730,140.57.22.445
01100,Ŀ,505209375,146156250,507923437,148546875,40.59.09.929,140.57.19.416
01100,Ŀ,505209375,146156250,507923437,148546875,41.12.56.265,140.24.30.643
01100,Ŀ,505209375,146156250,507923437,148546875,40.39.04.556,140.57.18.545
01100,Ŀ,505209375,146156250,507923437,148546875,40.41.07.462,140.43.59.258
01100,Ŀ,505209375,146156250,507923437,148546875,40.43.45.931,140.54.15.623
01100,Ŀ,505209375,146156250,507923437,148546875,40.47.46.533,140.35.34.973
01100,Ŀ,505209375,146156250,507923437,148546875,40.52.37.751,140.35.24.348
01100,Ŀ,505209375,146156250,507923437,148546875,40.50.49.341,140.48.36.977
01100,Ŀ,505209375,146156250,507923437,148546875,40.55.01.907,140.40.31.975
01100,Ŀ,505209375,146156250,507923437,148546875,41.04.40.007,140.28.32.518
01100,Ŀ,505209375,146156250,507923437,148546875,41.11.45.918,140.22.22.062
01100,Ŀ,505209375,146156250,507923437,148546875,41.11.02.086,140.28.57.629
01100,Ŀ,505209375,146156250,507923437,148546875,41.13.34.422,140.33.37.550
01200,,503479687,145406250,507150000,148471875,40.52.31.363,140.18.47.038
01200,,503479687,145406250,507150000,148471875,40.43.51.253,140.03.51.026
01200,,503479687,145406250,507150000,148471875,40.40.06.024,140.41.22.150
01200,,503479687,145406250,507150000,148471875,40.26.53.651,140.00.01.208
01200,,503479687,145406250,507150000,148471875,40.41.19.715,139.58.14.653
01200,,503479687,145406250,507150000,148471875,40.52.35.096,140.33.45.909
01200,,503479687,145406250,507150000,148471875,41.09.23.713,140.20.41.514
01200,,503479687,145406250,507150000,148471875,40.24.46.999,140.41.18.522
01200,,503479687,145406250,507150000,148471875,40.25.45.003,140.18.56.904
01200,,503479687,145406250,507150000,148471875,40.38.10.588,140.47.22.591
01200,,503479687,145406250,507150000,148471875,40.47.16.969,140.14.40.447
01200,,503479687,145406250,507150000,148471875,41.07.17.701,140.15.04.881
01200,,503479687,145406250,507150000,148471875,40.26.13.673,139.56.31.798
01200,,503479687,145406250,507150000,148471875,40.24.43.314,140.33.45.802
01200,,503479687,145406250,507150000,148471875,40.27.42.256,140.04.47.125
01200,,503479687,145406250,507150000,148471875,40.25.30.199,140.31.21.559
01200,,503479687,145406250,507150000,148471875,40.25.10.949,140.33.51.923
01200,,503479687,145406250,507150000,148471875,40.25.31.529,140.35.14.670
01200,,503479687,145406250,507150000,148471875,40.32.09.702,140.51.09.657
01200,,503479687,145406250,507150000,148471875,40.40.19.968,139.57.36.774
01200,,503479687,145406250,507150000,148471875,40.43.32.199,140.38.28.302
01200,,503479687,145406250,507150000,148471875,40.45.31.578,140.36.15.210
01200,,503479687,145406250,507150000,148471875,40.46.34.681,140.35.13.973
01200,,503479687,145406250,507150000,148471875,40.52.16.803,140.17.08.376
01200,,503479687,145406250,507150000,148471875,40.50.50.981,140.34.51.842
01200,,503479687,145406250,507150000,148471875,40.56.40.626,140.18.40.885
01200,,503479687,145406250,507150000,148471875,41.02.17.009,140.19.33.368
01200,,503479687,145406250,507150000,148471875,41.08.28.853,140.15.48.055
01300,,503760937,143240625,507585937,145809375,39.52.33.755,140.30.01.326
01300,,503760937,143240625,507585937,145809375,39.53.10.092,140.33.54.448
01300,,503760937,143240625,507585937,145809375,40.10.46.066,140.50.47.255
01300,,503760937,143240625,507585937,145809375,40.24.25.482,140.30.12.061
01300,,503760937,143240625,507585937,145809375,39.48.52.796,140.25.56.567
01300,,503760937,143240625,507585937,145809375,39.51.36.144,140.17.50.979
01300,,503760937,143240625,507585937,145809375,39.52.56.625,140.36.40.577
01300,,503760937,143240625,507585937,145809375,39.53.16.311,140.37.32.412
01300,,503760937,143240625,507585937,145809375,40.03.29.437,140.03.24.617
01300,,503760937,143240625,507585937,145809375,40.13.53.467,140.00.35.809
01300,,503760937,143240625,507585937,145809375,40.15.44.074,140.56.25.819
01300,,503760937,143240625,507585937,145809375,40.23.51.166,140.58.43.967
01300,,503760937,143240625,507585937,145809375,40.24.23.442,140.58.17.927
01300,,503760937,143240625,507585937,145809375,40.26.20.313,140.26.20.429
01300,,503760937,143240625,507585937,145809375,40.28.51.308,140.49.26.319
01300,,503760937,143240625,507585937,145809375,39.47.35.957,140.19.49.728
01300,,503760937,143240625,507585937,145809375,39.47.25.833,140.29.11.977
01300,,503760937,143240625,507585937,145809375,39.50.48.991,140.32.03.635
01300,,503760937,143240625,507585937,145809375,39.58.12.665,140.07.05.880
01300,,503760937,143240625,507585937,145809375,39.55.15.467,140.17.16.479
01300,,503760937,143240625,507585937,145809375,40.04.00.820,139.57.07.697
01300,,503760937,143240625,507585937,145809375,40.06.29.468,139.58.04.559
01300,,503760937,143240625,507585937,145809375,40.25.11.310,139.59.21.205
01300,,503760937,143240625,507585937,145809375,40.03.49.427,140.02.37.270
01300,,503760937,143240625,507585937,145809375,40.00.52.060,140.51.07.499
01300,,503760937,143240625,507585937,145809375,40.12.05.421,140.53.24.622
01300,,503760937,143240625,507585937,145809375,40.12.16.876,140.53.32.311
01300,,503760937,143240625,507585937,145809375,40.19.21.676,140.57.15.036
01300,,503760937,143240625,507585937,145809375,40.24.48.572,140.55.34.145
01300,,503760937,143240625,507585937,145809375,40.26.46.514,140.28.41.545
01300,,503760937,143240625,507585937,145809375,40.26.13.708,140.52.05.157
01400,,502889062,140437500,505884375,144300000,39.22.38.822,140.02.03.063
01400,,502889062,140437500,505884375,144300000,39.46.20.294,140.15.05.613
01400,,502889062,140437500,505884375,144300000,39.14.29.975,140.17.04.712
01400,,502889062,140437500,505884375,144300000,39.29.29.049,140.03.00.101
01400,,502889062,140437500,505884375,144300000,39.52.32.321,140.16.55.131
01400,,502889062,140437500,505884375,144300000,39.07.55.850,139.53.01.190
01400,,502889062,140437500,505884375,144300000,39.02.55.871,140.09.35.168
01400,,502889062,140437500,505884375,144300000,39.11.23.602,140.14.14.715
01400,,502889062,140437500,505884375,144300000,39.53.34.744,139.53.09.235
01400,,502889062,140437500,505884375,144300000,39.23.14.939,140.18.58.136
01400,,502889062,140437500,505884375,144300000,39.37.53.043,140.16.58.169
01400,,502889062,140437500,505884375,144300000,39.47.53.483,140.02.04.823
01400,,502889062,140437500,505884375,144300000,39.59.25.477,140.09.53.731
01400,,502889062,140437500,505884375,144300000,39.06.08.415,139.59.12.956
01400,,502889062,140437500,505884375,144300000,39.01.26.541,140.14.02.065
01400,,502889062,140437500,505884375,144300000,39.07.19.534,140.03.39.572
01400,,502889062,140437500,505884375,144300000,39.18.10.049,140.21.08.258
01400,,502889062,140437500,505884375,144300000,39.52.09.519,139.44.29.554
01400,,502889062,140437500,505884375,144300000,39.51.22.829,139.48.15.421
01400,,502889062,140437500,505884375,144300000,39.56.17.439,139.42.01.020
01400,,502889062,140437500,505884375,144300000,39.21.41.564,140.00.20.885
01400,,502889062,140437500,505884375,144300000,39.27.32.727,140.17.25.515
01400,,502889062,140437500,505884375,144300000,39.28.59.403,140.16.42.644
01400,,502889062,140437500,505884375,144300000,39.38.42.727,140.18.19.609
01400,,502889062,140437500,505884375,144300000,39.41.30.381,140.23.23.465
01400,,502889062,140437500,505884375,144300000,39.42.13.651,140.25.03.492
01400,,502889062,140437500,505884375,144300000,39.45.32.029,140.02.13.610
01400,,502889062,140437500,505884375,144300000,39.45.12.757,140.31.05.365
01400,,502889062,140437500,505884375,144300000,40.00.08.591,139.42.02.568
01500,,504829687,139921875,507150000,143971875,38.53.52.558,140.35.42.021
01500,,504829687,139921875,507150000,143971875,39.40.05.880,140.28.10.699
01500,,504829687,139921875,507150000,143971875,39.13.45.997,140.20.45.744
01500,,504829687,139921875,507150000,143971875,39.42.38.264,140.46.05.920
01500,,504829687,139921875,507150000,143971875,39.53.15.489,140.49.50.851
01500,,504829687,139921875,507150000,143971875,38.54.48.271,140.41.25.347
01500,,504829687,139921875,507150000,143971875,39.08.12.120,140.44.14.965
01500,,504829687,139921875,507150000,143971875,39.08.34.880,140.44.09.346
01500,,504829687,139921875,507150000,143971875,39.12.32.833,140.45.09.865
01500,,504829687,139921875,507150000,143971875,39.32.55.807,140.14.40.953
01500,,504829687,139921875,507150000,143971875,39.36.02.758,140.46.30.271
01500,,504829687,139921875,507150000,143971875,39.52.33.978,140.35.18.330
01500,,504829687,139921875,507150000,143971875,38.54.14.626,140.29.29.460
01500,,504829687,139921875,507150000,143971875,38.59.18.741,140.24.03.400
01500,,504829687,139921875,507150000,143971875,39.00.05.222,140.21.54.933
01500,,504829687,139921875,507150000,143971875,39.00.35.125,140.46.22.834
01500,,504829687,139921875,507150000,143971875,39.05.49.924,140.45.12.532
01500,,504829687,139921875,507150000,143971875,39.10.13.378,140.46.45.965
01500,,504829687,139921875,507150000,143971875,39.17.38.095,140.21.58.620
01500,,504829687,139921875,507150000,143971875,39.19.43.007,140.42.17.842
01500,,504829687,139921875,507150000,143971875,39.21.09.737,140.19.30.764
01500,,504829687,139921875,507150000,143971875,39.26.06.377,140.40.56.525
01500,,504829687,139921875,507150000,143971875,39.35.45.562,140.16.48.083
01500,,504829687,139921875,507150000,143971875,39.35.52.028,140.16.44.556
01500,,504829687,139921875,507150000,143971875,39.43.39.315,140.31.21.407
01500,,504829687,139921875,507150000,143971875,39.48.45.887,140.47.32.446
01500,,504829687,139921875,507150000,143971875,39.56.41.701,140.40.29.086
01600,ʡ,504815625,135000000,506685937,136725000,37.38.11.775,140.18.00.021
01600,ʡ,504815625,135000000,506685937,136725000,37.43.11.967,140.39.33.433
01600,ʡ,504815625,135000000,506685937,136725000,37.56.21.245,140.27.12.211
01600,ʡ,504815625,135000000,506685937,136725000,37.57.37.301,140.23.33.008
01600,ʡ,504815625,135000000,506685937,136725000,37.49.09.115,140.16.07.030
01600,ʡ,504815625,135000000,506685937,136725000,37.33.59.465,140.42.20.848
01600,ʡ,504815625,135000000,506685937,136725000,37.44.00.652,140.41.12.291
01600,ʡ,504815625,135000000,506685937,136725000,37.44.52.487,140.42.40.161
01600,ʡ,504815625,135000000,506685937,136725000,37.52.59.105,140.15.50.710
01600,ʡ,504815625,135000000,506685937,136725000,37.57.38.266,140.21.36.510
01601,,503803125,132431250,507121875,135440625,37.25.05.139,140.22.34.445
01601,,503803125,132431250,507121875,135440625,37.06.19.425,140.07.38.938
01601,,503803125,132431250,507121875,135440625,36.54.29.730,140.18.50.262
01601,,503803125,132431250,507121875,135440625,37.25.45.176,140.50.47.725
01601,,503803125,132431250,507121875,135440625,36.48.14.219,140.29.14.014
01601,,503803125,132431250,507121875,135440625,36.52.50.786,140.21.15.579
01601,,503803125,132431250,507121875,135440625,36.58.48.074,140.33.49.108
01601,,503803125,132431250,507121875,135440625,37.07.56.022,140.02.33.249
01601,,503803125,132431250,507121875,135440625,37.18.33.372,140.41.50.170
01601,,503803125,132431250,507121875,135440625,37.22.31.030,140.46.29.888
01601,,503803125,132431250,507121875,135440625,37.30.42.644,140.42.21.522
01601,,503803125,132431250,507121875,135440625,37.35.40.282,140.15.40.964
01601,,503803125,132431250,507121875,135440625,37.17.00.184,139.59.00.670
01601,,503803125,132431250,507121875,135440625,36.52.39.936,140.21.43.104
01601,,503803125,132431250,507121875,135440625,36.51.32.650,140.34.51.113
01601,,503803125,132431250,507121875,135440625,36.54.54.053,140.34.15.370
01601,,503803125,132431250,507121875,135440625,36.55.48.964,140.15.32.789
01601,,503803125,132431250,507121875,135440625,37.02.58.672,140.38.27.973
01601,,503803125,132431250,507121875,135440625,37.17.56.594,140.42.18.376
01601,,503803125,132431250,507121875,135440625,37.26.32.910,140.04.39.203
01601,,503803125,132431250,507121875,135440625,37.26.59.227,140.11.17.978
01601,,503803125,132431250,507121875,135440625,37.28.12.366,140.49.16.706
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.00.02.439,139.30.08.411
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.17.32.157,139.13.11.349
01700,ż㾾/¿,500990625,133059375,505026562,136275000,36.58.09.790,139.28.17.601
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.26.16.109,139.13.11.235
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.46.15.857,139.42.22.945
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.34.29.486,140.13.10.168
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.02.16.760,139.39.56.073
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.15.24.288,139.57.13.685
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.34.29.067,139.34.18.595
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.50.25.119,139.40.57.970
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.30.07.708,140.10.47.917
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.44.10.333,140.13.13.146
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.01.29.034,139.26.04.426
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.04.54.180,139.47.51.446
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.08.55.382,139.56.45.040
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.10.51.238,139.57.30.278
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.18.37.968,139.59.35.680
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.26.52.988,139.16.27.164
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.37.50.400,139.33.03.899
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.49.39.077,139.52.02.831
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.21.49.961,140.03.15.175
01700,ż㾾/¿,500990625,133059375,505026562,136275000,37.37.59.390,140.16.33.961
01800,來,506067187,132665625,507782812,136462500,37.08.49.856,140.39.34.207
01800,來,506067187,132665625,507782812,136462500,37.36.22.957,140.43.18.298
01800,來,506067187,132665625,507782812,136462500,37.15.02.018,141.00.02.585
01800,來,506067187,132665625,507782812,136462500,37.47.38.633,140.58.16.026
01800,來,506067187,132665625,507782812,136462500,37.02.12.532,140.58.16.023
01800,來,506067187,132665625,507782812,136462500,37.13.53.463,140.41.49.996
01800,來,506067187,132665625,507782812,136462500,37.16.16.732,141.00.59.618
01800,來,506067187,132665625,507782812,136462500,37.29.47.643,140.44.35.760
01800,來,506067187,132665625,507782812,136462500,37.47.00.497,140.41.50.432
01800,來,506067187,132665625,507782812,136462500,37.48.47.367,140.59.05.678
01800,來,506067187,132665625,507782812,136462500,37.49.29.421,140.59.13.659
01800,來,506067187,132665625,507782812,136462500,37.27.57.593,141.01.54.229
01800,來,506067187,132665625,507782812,136462500,36.52.26.444,140.42.33.713
01800,來,506067187,132665625,507782812,136462500,36.51.34.373,140.45.22.293
01800,來,506067187,132665625,507782812,136462500,36.57.44.334,140.58.34.388
01800,來,506067187,132665625,507782812,136462500,37.06.12.455,140.39.54.954
01800,來,506067187,132665625,507782812,136462500,37.18.26.768,140.42.56.134
01800,來,506067187,132665625,507782812,136462500,37.16.10.227,141.01.31.177
01800,來,506067187,132665625,507782812,136462500,37.27.38.780,140.50.54.762
01800,來,506067187,132665625,507782812,136462500,37.36.28.358,140.43.02.089
01800,來,506067187,132665625,507782812,136462500,37.41.20.314,140.40.03.052
01800,來,506067187,132665625,507782812,136462500,37.46.05.144,140.44.56.699
01800,來,506067187,132665625,507782812,136462500,37.52.36.158,140.51.30.680
01800,來,506067187,132665625,507782812,136462500,37.24.11.137,141.02.30.987
01800,來,506067187,132665625,507782812,136462500,37.44.01.931,141.01.09.551
01900,Լ,505687500,136425000,507853125,138656250,38.18.49.650,140.32.03.358
01900,Լ,505687500,136425000,507853125,138656250,38.28.48.112,140.57.17.469
01900,Լ,505687500,136425000,507853125,138656250,37.54.10.597,140.53.02.253
01900,Լ,505687500,136425000,507853125,138656250,38.29.24.539,140.45.40.324
01900,Լ,505687500,136425000,507853125,138656250,38.30.02.950,140.57.41.398
01900,Լ,505687500,136425000,507853125,138656250,38.17.33.822,141.02.05.436
01900,Լ,505687500,136425000,507853125,138656250,38.26.01.377,141.03.52.068
01900,Լ,505687500,136425000,507853125,138656250,37.57.51.510,140.55.24.149
01900,Լ,505687500,136425000,507853125,138656250,38.09.36.982,140.57.40.121
01900,Լ,505687500,136425000,507853125,138656250,38.29.30.636,140.42.56.494
01900,Լ,505687500,136425000,507853125,138656250,38.30.23.415,140.58.11.577
01900,Լ,505687500,136425000,507853125,138656250,38.22.19.753,141.02.50.790
01901,,504984375,136031250,507107812,137775000,37.56.17.991,140.29.09.319
01901,,504984375,136031250,507107812,137775000,38.11.23.029,140.29.14.364
01901,,504984375,136031250,507107812,137775000,37.48.28.226,140.47.25.837
01901,,504984375,136031250,507107812,137775000,37.51.39.506,140.50.40.950
01901,,504984375,136031250,507107812,137775000,37.58.29.296,140.18.27.321
01901,,504984375,136031250,507107812,137775000,37.47.46.286,140.43.55.396
01901,,504984375,136031250,507107812,137775000,37.54.39.442,140.32.54.966
01901,,504984375,136031250,507107812,137775000,37.59.55.214,140.16.44.601
01901,,504984375,136031250,507107812,137775000,37.58.16.160,140.25.14.588
01901,,504984375,136031250,507107812,137775000,38.04.45.071,140.25.02.603
02000,д/,507642187,137653125,510075000,140362500,38.32.31.280,141.15.03.459
02000,д/,507642187,137653125,510075000,140362500,38.17.38.677,141.32.56.642
02000,д/,507642187,137653125,510075000,140362500,38.27.30.811,141.10.29.972
02000,д/,507642187,137653125,510075000,140362500,38.31.56.252,141.31.06.613
02000,д/,507642187,137653125,510075000,140362500,38.38.49.553,141.21.38.616
02000,д/,507642187,137653125,510075000,140362500,38.51.58.557,141.36.45.694
02000,д/,507642187,137653125,510075000,140362500,38.16.20.055,141.30.29.399
02000,д/,507642187,137653125,510075000,140362500,38.21.54.980,141.06.44.092
02000,д/,507642187,137653125,510075000,140362500,38.21.59.653,141.29.41.061
02000,д/,507642187,137653125,510075000,140362500,38.26.18.115,141.05.44.408
02000,д/,507642187,137653125,510075000,140362500,38.30.40.693,141.10.49.965
02000,д/,507642187,137653125,510075000,140362500,38.38.32.191,141.19.15.762
02000,д/,507642187,137653125,510075000,140362500,38.48.48.165,141.34.45.576
02000,д/,507642187,137653125,510075000,140362500,38.55.08.645,141.39.04.198
02000,д/,507642187,137653125,510075000,140362500,38.16.32.621,141.03.42.847
02000,д/,507642187,137653125,510075000,140362500,38.19.03.171,141.11.03.165
02000,д/,507642187,137653125,510075000,140362500,38.16.58.534,141.32.05.390
02000,д/,507642187,137653125,510075000,140362500,38.17.25.916,141.32.03.926
02000,д/,507642187,137653125,510075000,140362500,38.18.28.768,141.33.35.530
02000,д/,507642187,137653125,510075000,140362500,38.22.21.952,141.11.16.084
02000,д/,507642187,137653125,510075000,140362500,38.23.44.409,141.14.23.224
02000,д/,507642187,137653125,510075000,140362500,38.24.18.081,141.19.18.400
02000,д/,507642187,137653125,510075000,140362500,38.24.19.037,141.20.35.288
02000,д/,507642187,137653125,510075000,140362500,38.21.07.791,141.32.03.228
02000,д/,507642187,137653125,510075000,140362500,38.25.55.447,141.32.11.576
02000,д/,507642187,137653125,510075000,140362500,38.33.53.224,141.13.55.482
02000,д/,507642187,137653125,510075000,140362500,38.34.09.845,141.13.51.904
02000,д/,507642187,137653125,510075000,140362500,38.33.20.358,141.29.08.886
02000,д/,507642187,137653125,510075000,140362500,38.35.49.642,141.31.28.187
02000,д/,507642187,137653125,510075000,140362500,38.40.40.316,141.22.20.552
02000,д/,507642187,137653125,510075000,140362500,38.45.41.121,141.31.32.439
02000,д/,507642187,137653125,510075000,140362500,38.51.30.202,141.39.12.875
02000,д/,507642187,137653125,510075000,140362500,38.23.24.050,141.36.41.210
02100,,505940625,138393750,509076562,140250000,38.35.08.892,141.07.38.475
02100,,505940625,138393750,509076562,140250000,38.28.46.942,140.37.39.469
02100,,505940625,138393750,509076562,140250000,38.46.21.967,140.39.28.937
02100,,505940625,138393750,509076562,140250000,38.36.21.610,141.15.03.533
02100,,505940625,138393750,509076562,140250000,38.29.07.630,140.34.47.934
02100,,505940625,138393750,509076562,140250000,38.30.19.996,140.56.47.541
02100,,505940625,138393750,509076562,140250000,38.29.26.447,141.09.31.837
02100,,505940625,138393750,509076562,140250000,38.39.05.138,141.18.49.102
02100,,505940625,138393750,509076562,140250000,38.56.57.360,140.48.29.250
02100,,505940625,138393750,509076562,140250000,38.44.28.851,141.15.36.081
02100,,505940625,138393750,509076562,140250000,38.45.41.485,141.11.53.326
02100,,505940625,138393750,509076562,140250000,38.45.07.378,141.23.38.534
02100,,505940625,138393750,509076562,140250000,38.29.56.951,140.47.30.649
02100,,505940625,138393750,509076562,140250000,38.30.30.453,140.49.58.395
02100,,505940625,138393750,509076562,140250000,38.30.16.361,140.57.22.342
02100,,505940625,138393750,509076562,140250000,38.39.12.497,140.36.32.436
02100,,505940625,138393750,509076562,140250000,38.29.33.016,141.00.12.028
02100,,505940625,138393750,509076562,140250000,38.36.18.832,141.17.32.717
02100,,505940625,138393750,509076562,140250000,38.54.44.046,140.42.01.142
02100,,505940625,138393750,509076562,140250000,38.54.25.027,140.55.22.236
02100,,505940625,138393750,509076562,140250000,38.48.52.194,141.06.07.628
02100,,505940625,138393750,509076562,140250000,38.47.19.455,141.17.38.576
02200,,502650000,135843750,505040625,137793750,38.00.05.241,139.39.35.808
02200,,502650000,135843750,505040625,137793750,37.58.09.504,140.15.13.344
02200,,502650000,135843750,505040625,137793750,38.10.42.229,140.11.20.414
02200,,502650000,135843750,505040625,137793750,37.49.07.147,139.57.24.490
02200,,502650000,135843750,505040625,137793750,37.52.57.328,140.15.01.103
02200,,502650000,135843750,505040625,137793750,38.11.55.656,139.43.37.958
02200,,502650000,135843750,505040625,137793750,38.01.21.275,140.16.03.648
02200,,502650000,135843750,505040625,137793750,38.14.45.771,140.01.32.842
02200,,502650000,135843750,505040625,137793750,37.49.55.566,139.47.41.731
02200,,502650000,135843750,505040625,137793750,37.51.13.835,139.40.14.312
02200,,502650000,135843750,505040625,137793750,37.57.54.764,139.38.13.916
02200,,502650000,135843750,505040625,137793750,37.45.35.300,140.11.24.749
02200,,502650000,135843750,505040625,137793750,38.00.39.818,139.39.09.990
02200,,502650000,135843750,505040625,137793750,38.02.15.754,139.39.32.879
02200,,502650000,135843750,505040625,137793750,38.13.13.826,139.50.08.646
02200,,502650000,135843750,505040625,137793750,38.04.02.713,140.16.06.032
02300,,503535937,137006250,506193750,139387500,38.22.30.811,140.30.09.783
02300,,503535937,137006250,506193750,139387500,38.15.44.360,140.08.33.488
02300,,503535937,137006250,506193750,139387500,38.35.07.464,140.18.01.415
02300,,503535937,137006250,506193750,139387500,38.35.41.921,140.32.01.809
02300,,503535937,137006250,506193750,139387500,38.30.00.577,139.56.24.259
02300,,503535937,137006250,506193750,139387500,38.04.46.016,140.16.32.880
02300,,503535937,137006250,506193750,139387500,38.03.33.026,140.22.11.156
02300,,503535937,137006250,506193750,139387500,38.05.41.114,140.14.44.742
02300,,503535937,137006250,506193750,139387500,38.24.25.376,140.33.48.461
02300,,503535937,137006250,506193750,139387500,38.26.39.993,140.34.42.621
02300,,503535937,137006250,506193750,139387500,38.32.34.385,140.13.17.326
02300,,503535937,137006250,506193750,139387500,38.38.15.199,140.31.54.406
02300,,503535937,137006250,506193750,139387500,38.42.37.617,140.27.17.946
02300,,503535937,137006250,506193750,139387500,38.15.14.891,139.55.43.106
02300,,503535937,137006250,506193750,139387500,38.23.31.316,139.55.09.014
02300,,503535937,137006250,506193750,139387500,38.07.35.144,140.12.16.682
02300,,503535937,137006250,506193750,139387500,38.08.19.441,140.26.22.219
02300,,503535937,137006250,506193750,139387500,38.19.39.657,140.31.01.858
02300,,503535937,137006250,506193750,139387500,38.22.44.142,140.33.36.071
02300,,503535937,137006250,506193750,139387500,38.32.00.825,140.12.00.586
02300,,503535937,137006250,506193750,139387500,38.39.57.778,140.32.59.342
02300,,503535937,137006250,506193750,139387500,38.31.16.557,140.33.19.528
02400,,504084375,138590625,506320312,140578125,38.38.53.288,140.03.49.213
02400,,504084375,138590625,506320312,140578125,38.42.31.418,140.33.49.198
02400,,504084375,138590625,506320312,140578125,38.41.17.910,140.35.47.107
02400,,504084375,138590625,506320312,140578125,38.32.17.635,140.04.22.481
02400,,504084375,138590625,506320312,140578125,38.36.36.067,140.17.26.846
02400,,504084375,138590625,506320312,140578125,38.40.19.247,140.36.35.532
02400,,504084375,138590625,506320312,140578125,38.46.39.875,140.35.42.931
02400,,504084375,138590625,506320312,140578125,38.58.49.989,140.24.05.082
02400,,504084375,138590625,506320312,140578125,38.32.35.825,140.04.17.385
02400,,504084375,138590625,506320312,140578125,38.37.32.900,140.05.02.067
02400,,504084375,138590625,506320312,140578125,38.41.30.152,140.02.41.063
02400,,504084375,138590625,506320312,140578125,38.42.05.463,140.24.14.006
02400,,504084375,138590625,506320312,140578125,38.46.03.098,140.37.10.597
02400,,504084375,138590625,506320312,140578125,38.47.37.255,140.35.38.704
02400,,504084375,138590625,506320312,140578125,38.49.05.220,140.35.22.059
02400,,504084375,138590625,506320312,140578125,38.56.01.010,140.07.22.462
02400,,504084375,138590625,506320312,140578125,38.57.47.177,140.08.23.340
02400,,504084375,138590625,506320312,140578125,39.02.57.505,140.11.46.382
02500,Წ,502284375,137915625,504520312,141150000,38.43.53.821,139.43.14.473
02500,Წ,502284375,137915625,504520312,141150000,38.40.06.630,139.38.28.536
02500,Წ,502284375,137915625,504520312,141150000,39.05.01.175,140.01.09.043
02500,Წ,502284375,137915625,504520312,141150000,38.22.31.029,139.43.38.238
02500,Წ,502284375,137915625,504520312,141150000,38.32.52.237,140.00.37.852
02500,Წ,502284375,137915625,504520312,141150000,39.05.39.230,139.53.05.732
02500,Წ,502284375,137915625,504520312,141150000,39.06.16.347,139.53.28.216
02500,Წ,502284375,137915625,504520312,141150000,38.57.56.506,140.07.37.329
02500,Წ,502284375,137915625,504520312,141150000,39.04.27.823,140.05.12.189
02500,Წ,502284375,137915625,504520312,141150000,38.21.44.672,139.44.12.180
02500,Წ,502284375,137915625,504520312,141150000,38.33.05.765,139.32.38.109
02500,Წ,502284375,137915625,504520312,141150000,38.32.10.218,139.59.12.718
02500,Წ,502284375,137915625,504520312,141150000,38.38.49.062,140.03.19.308
02500,Წ,502284375,137915625,504520312,141150000,38.43.15.892,139.41.03.653
02500,Წ,502284375,137915625,504520312,141150000,39.02.09.300,139.51.57.785
02500,Წ,502284375,137915625,504520312,141150000,38.54.52.396,140.07.07.322
02600,,501707812,130293750,503718750,132168750,36.23.12.223,139.46.58.962
02600,,501707812,130293750,503718750,132168750,36.12.18.181,139.43.42.752
02600,,501707812,130293750,503718750,132168750,36.18.28.986,139.54.29.508
02600,,501707812,130293750,503718750,132168750,36.18.48.464,139.54.28.247
02600,,501707812,130293750,503718750,132168750,36.30.01.964,139.48.50.249
02600,,501707812,130293750,503718750,132168750,36.34.41.908,139.47.57.239
02600,,501707812,130293750,503718750,132168750,36.40.46.051,139.31.30.913
02600,,501707812,130293750,503718750,132168750,36.16.26.325,139.31.30.227
02600,,501707812,130293750,503718750,132168750,36.15.55.356,139.36.48.877
02600,,501707812,130293750,503718750,132168750,36.16.23.213,139.50.46.164
02600,,501707812,130293750,503718750,132168750,36.22.07.290,139.50.41.470
02600,,501707812,130293750,503718750,132168750,36.21.02.324,139.53.05.458
02600,,501707812,130293750,503718750,132168750,36.28.56.371,139.47.42.877
02600,,501707812,130293750,503718750,132168750,36.38.30.477,139.29.52.108
02600,,501707812,130293750,503718750,132168750,36.38.53.190,139.39.13.879
02700,Ե,503085937,130790625,504956250,132487500,36.30.05.976,140.07.34.180
02700,Ե,503085937,130790625,504956250,132487500,36.26.22.642,140.11.17.041
02700,Ե,503085937,130790625,504956250,132487500,36.42.38.694,140.08.29.683
02700,Ե,503085937,130790625,504956250,132487500,36.35.20.760,139.48.45.847
02700,Ե,503085937,130790625,504956250,132487500,36.43.11.692,139.53.34.401
02700,Ե,503085937,130790625,504956250,132487500,36.23.42.685,139.49.11.986
02700,Ե,503085937,130790625,504956250,132487500,36.34.28.274,139.49.12.169
02700,Ե,503085937,130790625,504956250,132487500,36.23.30.385,140.04.19.571
02700,Ե,503085937,130790625,504956250,132487500,36.24.41.924,140.12.19.514
02700,Ե,503085937,130790625,504956250,132487500,36.40.28.725,139.47.04.260
02700,Ե,503085937,130790625,504956250,132487500,36.43.34.202,139.57.08.130
02800,/,501581250,131746875,502860937,132609375,36.42.31.464,139.30.08.184
02800,/,501581250,131746875,502860937,132609375,36.39.49.581,139.29.07.841
02800,/,501581250,131746875,502860937,132609375,36.43.14.476,139.40.25.413
02800,/,501581250,131746875,502860937,132609375,36.37.02.432,139.20.54.400
02800,/,501581250,131746875,502860937,132609375,36.39.01.464,139.36.59.922
02800,/,501581250,131746875,502860937,132609375,36.38.21.140,139.38.29.878
02800,/,501581250,131746875,502860937,132609375,36.42.08.571,139.31.06.679
02800,/,501581250,131746875,502860937,132609375,36.48.47.280,139.28.10.616
02900,/,501651562,131821875,503465625,133509375,36.42.35.263,139.41.17.423
02900,/,501651562,131821875,503465625,133509375,36.43.13.811,139.46.53.915
02900,/,501651562,131821875,503465625,133509375,36.58.53.304,139.34.51.166
02900,/,501651562,131821875,503465625,133509375,36.43.51.012,139.48.54.078
02900,/,501651562,131821875,503465625,133509375,36.56.38.041,139.26.51.664
02900,/,501651562,131821875,503465625,133509375,36.39.52.201,139.40.35.693
02900,/,501651562,131821875,503465625,133509375,36.41.42.584,139.46.55.577
02900,/,501651562,131821875,503465625,133509375,36.49.47.597,139.24.53.824
02900,/,501651562,131821875,503465625,133509375,36.47.31.756,139.44.28.560
02900,/,501651562,131821875,503465625,133509375,36.53.47.270,139.22.55.273
02900,/,501651562,131821875,503465625,133509375,36.50.57.849,139.46.36.639
02900,/,501651562,131821875,503465625,133509375,36.58.12.588,139.31.40.330
02900,/,501651562,131821875,503465625,133509375,36.59.46.005,139.45.33.966
03000,/ĸ,503043750,132018750,505082812,133340625,37.00.42.008,139.46.01.752
03000,/ĸ,503043750,132018750,505082812,133340625,36.44.31.080,139.57.24.393
03000,/ĸ,503043750,132018750,505082812,133340625,36.55.21.395,139.46.37.502
03000,/ĸ,503043750,132018750,505082812,133340625,36.44.31.072,140.16.05.630
03000,/ĸ,503043750,132018750,505082812,133340625,36.54.47.570,140.00.02.184
03000,/ĸ,503043750,132018750,505082812,133340625,36.55.38.073,140.14.14.660
03000,/ĸ,503043750,132018750,505082812,133340625,36.47.44.479,139.58.45.784
03000,/ĸ,503043750,132018750,505082812,133340625,36.54.12.386,139.46.40.189
03000,/ĸ,503043750,132018750,505082812,133340625,37.00.58.788,139.48.20.352
03000,/ĸ,503043750,132018750,505082812,133340625,36.47.15.669,140.00.43.470
03000,/ĸ,503043750,132018750,505082812,133340625,36.54.25.729,140.15.13.080
03100,,503282812,132853125,504900000,133734375,37.07.35.253,139.52.39.842
03100,,503282812,132853125,504900000,133734375,37.03.09.811,139.49.20.515
03100,,503282812,132853125,504900000,133734375,37.06.39.724,139.49.45.322
03100,,503282812,132853125,504900000,133734375,37.05.04.881,140.08.36.959
03100,,503282812,132853125,504900000,133734375,36.59.35.545,139.50.57.598
03100,,503282812,132853125,504900000,133734375,37.04.45.249,139.49.53.511
03100,,503282812,132853125,504900000,133734375,36.56.51.235,140.10.21.902
03200,,500906250,132140625,502045312,133884375,36.55.02.892,139.22.37.371
03200,,500906250,132140625,502045312,133884375,37.01.22.179,139.16.05.331
03200,,500906250,132140625,502045312,133884375,36.44.09.642,139.13.16.640
03200,,500906250,132140625,502045312,133884375,36.49.42.319,139.21.44.653
03200,,500906250,132140625,502045312,133884375,36.50.01.539,139.20.50.556
03200,,500906250,132140625,502045312,133884375,36.57.33.239,139.10.48.417
03200,,500906250,132140625,502045312,133884375,37.02.34.575,139.24.32.886
03200,,500906250,132140625,502045312,133884375,36.44.17.668,139.10.27.758
03200,,500906250,132140625,502045312,133884375,36.48.13.864,139.08.50.596
03200,,500906250,132140625,502045312,133884375,36.53.06.246,139.22.06.819
03200,,500906250,132140625,502045312,133884375,36.57.05.361,139.14.47.231
03200,,500906250,132140625,502045312,133884375,37.01.35.716,139.14.50.268
03200,,500906250,132140625,502045312,133884375,37.09.56.738,139.16.00.104
03300,/,500400000,130406250,502129687,131868750,36.22.32.768,139.02.03.719
03300,/,500400000,130406250,502129687,131868750,36.28.11.605,139.24.24.853
03300,/,500400000,130406250,502129687,131868750,36.14.42.193,139.14.34.322
03300,/,500400000,130406250,502129687,131868750,36.29.41.907,139.24.27.767
03300,/,500400000,130406250,502129687,131868750,36.36.21.622,139.20.49.543
03300,/,500400000,130406250,502129687,131868750,36.18.24.159,139.05.32.329
03300,/,500400000,130406250,502129687,131868750,36.19.17.603,139.05.27.220
03300,/,500400000,130406250,502129687,131868750,36.17.27.921,139.19.29.357
03300,/,500400000,130406250,502129687,131868750,36.21.03.801,139.19.45.376
03300,/,500400000,130406250,502129687,131868750,36.30.47.968,139.01.13.143
03300,/,500400000,130406250,502129687,131868750,36.32.34.591,139.01.50.131
03300,/,500400000,130406250,502129687,131868750,36.35.06.843,139.03.22.182
03400,/,501539062,130256250,502790625,130893750,36.13.15.306,139.24.31.879
03400,/,501539062,130256250,502790625,130893750,36.16.38.001,139.27.15.465
03400,/,501539062,130256250,502790625,130893750,36.16.02.532,139.30.35.197
03400,/,501539062,130256250,502790625,130893750,36.12.41.340,139.25.11.902
03400,/,501539062,130256250,502790625,130893750,36.16.03.413,139.29.52.713
03500,,498881250,129525000,500878125,131100000,36.17.33.983,138.41.26.418
03500,,498881250,129525000,500878125,131100000,36.13.45.894,139.03.48.779
03500,,498881250,129525000,500878125,131100000,36.20.45.505,138.55.30.065
03500,,498881250,129525000,500878125,131100000,36.07.12.362,138.58.12.732
03500,,498881250,129525000,500878125,131100000,36.13.48.672,139.05.46.571
03500,,498881250,129525000,500878125,131100000,35.58.49.143,138.43.18.042
03500,,498881250,129525000,500878125,131100000,36.01.40.073,138.48.55.918
03500,,498881250,129525000,500878125,131100000,36.08.38.733,138.35.29.961
03500,,498881250,129525000,500878125,131100000,36.05.17.642,138.54.59.175
03500,,498881250,129525000,500878125,131100000,36.05.12.777,138.56.28.046
03500,,498881250,129525000,500878125,131100000,36.05.31.925,138.57.04.566
03500,,498881250,129525000,500878125,131100000,36.24.27.699,138.39.48.056
03500,,498881250,129525000,500878125,131100000,36.10.49.431,139.03.50.976
03600,˹/̾/,498220312,130865625,500582812,132346875,36.38.49.495,138.48.51.913
03600,˹/̾/,498220312,130865625,500582812,132346875,36.28.15.268,139.00.11.861
03600,˹/̾/,498220312,130865625,500582812,132346875,36.41.21.882,138.48.55.812
03600,˹/̾/,498220312,130865625,500582812,132346875,36.22.55.846,138.58.16.349
03600,˹/̾/,498220312,130865625,500582812,132346875,36.32.17.918,139.01.04.576
03600,˹/̾/,498220312,130865625,500582812,132346875,36.42.54.809,138.47.58.772
03600,˹/̾/,498220312,130865625,500582812,132346875,36.23.49.861,138.28.54.750
03600,˹/̾/,498220312,130865625,500582812,132346875,36.22.42.068,138.57.40.965
03600,˹/̾/,498220312,130865625,500582812,132346875,36.30.21.343,138.24.15.798
03600,˹/̾/,498220312,130865625,500582812,132346875,36.36.22.873,138.26.41.192
03600,˹/̾/,498220312,130865625,500582812,132346875,36.25.30.940,139.00.03.569
03600,˹/̾/,498220312,130865625,500582812,132346875,36.40.31.780,138.31.20.887
03700,/,499640625,131615625,501721875,133406250,36.40.04.455,138.53.35.661
03700,/,499640625,131615625,501721875,133406250,36.38.31.365,138.59.39.034
03700,/,499640625,131615625,501721875,133406250,36.49.43.938,138.55.57.598
03700,/,499640625,131615625,501721875,133406250,36.54.44.248,138.58.44.222
03700,/,499640625,131615625,501721875,133406250,36.43.47.296,139.21.46.053
03700,/,499640625,131615625,501721875,133406250,36.44.07.267,139.21.46.526
03700,/,499640625,131615625,501721875,133406250,36.59.24.783,139.03.22.070
03700,/,499640625,131615625,501721875,133406250,37.01.01.305,139.08.33.505
03700,/,499640625,131615625,501721875,133406250,36.35.13.060,139.00.51.944
03700,/,499640625,131615625,501721875,133406250,36.46.01.702,138.49.38.984
03700,/,499640625,131615625,501721875,133406250,36.58.46.739,138.58.18.739
03700,/,499640625,131615625,501721875,133406250,36.42.59.225,139.21.55.893
03700,/,499640625,131615625,501721875,133406250,36.51.20.156,139.08.55.578
03700,/,499640625,131615625,501721875,133406250,36.59.05.957,139.01.08.084
03800,/,498684375,132253125,501328125,134690625,37.03.48.331,139.07.35.985
03800,/,498684375,132253125,501328125,134690625,37.05.45.526,138.32.59.705
03800,/,498684375,132253125,501328125,134690625,37.21.15.937,138.59.13.870
03800,/,498684375,132253125,501328125,134690625,36.51.21.655,138.54.24.629
03800,/,498684375,132253125,501328125,134690625,36.56.41.809,138.57.16.562
03800,/,498684375,132253125,501328125,134690625,37.10.20.833,138.39.00.864
03800,/,498684375,132253125,501328125,134690625,37.00.25.028,139.02.56.979
03800,/,498684375,132253125,501328125,134690625,37.02.34.812,139.15.00.977
03800,/,498684375,132253125,501328125,134690625,37.17.35.954,139.12.24.167
03800,/,498684375,132253125,501328125,134690625,36.47.19.947,138.41.13.180
03800,/,498684375,132253125,501328125,134690625,36.48.56.585,138.49.34.138
03800,/,498684375,132253125,501328125,134690625,36.55.58.124,138.57.51.457
03800,/,498684375,132253125,501328125,134690625,36.57.37.916,138.57.47.461
03800,/,498684375,132253125,501328125,134690625,37.10.04.206,138.36.57.781
03800,/,498684375,132253125,501328125,134690625,37.13.12.193,138.40.34.372
03800,/,498684375,132253125,501328125,134690625,36.59.58.738,139.03.13.638
03800,/,498684375,132253125,501328125,134690625,36.58.29.347,139.14.38.126
03800,/,498684375,132253125,501328125,134690625,37.03.33.862,139.14.52.099
03800,/,498684375,132253125,501328125,134690625,37.04.43.604,139.14.28.463
03800,/,498684375,132253125,501328125,134690625,37.02.21.502,139.15.08.426
03800,/,498684375,132253125,501328125,134690625,37.15.16.439,139.10.11.522
03800,/,498684375,132253125,501328125,134690625,37.21.03.961,138.52.07.479
03800,/,498684375,132253125,501328125,134690625,37.24.04.703,139.05.26.058
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.00.01.831,137.47.01.658
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.05.02.050,137.59.13.521
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.56.59.327,138.10.27.186
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.54.05.137,137.57.52.432
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.57.49.866,137.39.05.381
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.54.08.832,138.01.07.435
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.56.35.085,138.05.47.685
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.01.00.287,138.29.17.018
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.16.59.018,138.29.06.019
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.50.00.677,137.44.01.542
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.55.50.412,137.42.55.031
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.00.00.953,137.43.57.547
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.06.21.902,137.59.20.062
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.56.27.766,138.10.43.600
03900,/ľ/̯,495478125,132337500,498867187,134306250,36.55.13.885,138.19.35.814
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.01.17.331,138.31.37.462
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.08.50.782,138.04.09.280
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.09.05.153,138.33.23.915
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.10.04.721,138.13.31.808
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.14.07.493,138.20.00.352
03900,/ľ/̯,495478125,132337500,498867187,134306250,37.18.11.186,138.25.27.570
04000,Ĺ,498318750,133800000,501496875,135759375,37.15.45.016,138.43.15.691
04000,Ĺ,498318750,133800000,501496875,135759375,37.33.50.628,138.44.14.215
04000,Ĺ,498318750,133800000,501496875,135759375,37.24.30.322,139.02.01.031
04000,Ĺ,498318750,133800000,501496875,135759375,37.20.41.129,138.29.35.047
04000,Ĺ,498318750,133800000,501496875,135759375,37.36.59.118,138.49.52.817
04000,Ĺ,498318750,133800000,501496875,135759375,37.38.13.274,138.47.53.087
04000,Ĺ,498318750,133800000,501496875,135759375,37.35.05.219,138.56.15.746
04000,Ĺ,498318750,133800000,501496875,135759375,37.27.14.379,139.13.16.676
04000,Ĺ,498318750,133800000,501496875,135759375,37.10.15.502,138.35.12.311
04000,Ĺ,498318750,133800000,501496875,135759375,37.17.25.559,138.29.20.625
04000,Ĺ,498318750,133800000,501496875,135759375,37.17.27.409,138.29.50.133
04000,Ĺ,498318750,133800000,501496875,135759375,37.20.01.384,138.27.42.151
04000,Ĺ,498318750,133800000,501496875,135759375,37.23.02.342,138.46.44.821
04000,Ĺ,498318750,133800000,501496875,135759375,37.28.15.074,138.36.49.872
04000,Ĺ,498318750,133800000,501496875,135759375,37.39.08.272,138.47.46.087
04000,Ĺ,498318750,133800000,501496875,135759375,37.40.35.583,138.48.52.711
04000,Ĺ,498318750,133800000,501496875,135759375,37.24.33.440,139.06.52.490
04000,Ĺ,498318750,133800000,501496875,135759375,37.28.17.473,139.17.01.751
04100,/,499626562,134821875,503057812,136856250,37.52.32.646,139.03.57.619
04100,/,499626562,134821875,503057812,136856250,37.28.48.067,139.22.32.444
04100,/,499626562,134821875,503057812,136856250,37.53.52.427,139.02.03.942
04100,/,499626562,134821875,503057812,136856250,37.36.54.508,139.02.55.520
04100,/,499626562,134821875,503057812,136856250,37.41.20.932,139.35.45.834
04100,/,499626562,134821875,503057812,136856250,37.40.08.470,138.47.49.501
04100,/,499626562,134821875,503057812,136856250,37.48.52.929,138.51.14.387
04100,/,499626562,134821875,503057812,136856250,37.30.57.516,139.29.37.467
04100,/,499626562,134821875,503057812,136856250,37.39.27.858,139.33.47.001
04100,/,499626562,134821875,503057812,136856250,37.44.29.726,139.17.29.889
04100,/,499626562,134821875,503057812,136856250,37.41.36.911,139.36.41.281
04100,/,499626562,134821875,503057812,136856250,37.49.23.506,139.37.09.463
04100,/,499626562,134821875,503057812,136856250,37.51.20.683,139.10.23.636
04100,/,499626562,134821875,503057812,136856250,37.57.53.012,139.13.16.337
04100,/,499626562,134821875,503057812,136856250,37.36.51.634,138.51.23.321
04100,/,499626562,134821875,503057812,136856250,37.41.58.306,138.49.07.679
04100,/,499626562,134821875,503057812,136856250,37.47.09.455,138.49.09.317
04100,/,499626562,134821875,503057812,136856250,37.52.14.838,138.55.58.205
04100,/,499626562,134821875,503057812,136856250,37.34.58.557,139.07.39.383
04100,/,499626562,134821875,503057812,136856250,37.30.01.089,139.17.38.412
04100,/,499626562,134821875,503057812,136856250,37.30.48.611,139.29.39.137
04100,/,499626562,134821875,503057812,136856250,37.44.28.330,139.14.25.264
04100,/,499626562,134821875,503057812,136856250,37.46.41.403,139.19.57.078
04100,/,499626562,134821875,503057812,136856250,37.47.54.771,139.27.13.482
04100,/,499626562,134821875,503057812,136856250,37.47.26.819,139.41.45.886
04100,/,499626562,134821875,503057812,136856250,37.51.12.436,139.10.29.853
04100,/,499626562,134821875,503057812,136856250,37.56.59.031,139.05.00.463
04200,ȯ/¼,500962500,135853125,503620312,138750000,37.55.00.695,139.30.07.266
04200,ȯ/¼,500962500,135853125,503620312,138750000,37.48.11.557,139.27.21.397
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.03.13.026,139.39.26.688
04200,ȯ/¼,500962500,135853125,503620312,138750000,37.46.05.087,139.18.27.163
04200,ȯ/¼,500962500,135853125,503620312,138750000,37.50.25.736,139.39.52.889
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.06.37.485,139.40.27.427
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.10.59.650,139.25.56.587
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.17.30.505,139.26.52.235
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.29.27.082,139.41.26.608
04200,ȯ/¼,500962500,135853125,503620312,138750000,37.48.53.460,139.21.38.860
04200,ȯ/¼,500962500,135853125,503620312,138750000,37.49.39.348,139.36.59.339
04200,ȯ/¼,500962500,135853125,503620312,138750000,37.59.16.017,139.13.53.065
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.02.40.293,139.18.36.194
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.00.32.118,139.39.00.008
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.01.27.411,139.39.04.795
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.06.44.925,139.40.59.411
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.11.46.932,139.25.36.476
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.10.53.812,139.41.20.783
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.11.26.320,139.41.46.245
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.18.12.360,139.27.07.197
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.21.42.439,139.43.44.242
04200,ȯ/¼,500962500,135853125,503620312,138750000,38.25.38.066,139.42.40.160
04300,,497531250,136068750,498895312,138009375,37.51.59.315,138.17.57.514
04300,,497531250,136068750,498895312,138009375,37.49.11.710,138.19.52.147
04300,,497531250,136068750,498895312,138009375,38.00.03.693,138.32.51.224
04300,,497531250,136068750,498895312,138009375,38.00.23.227,138.33.01.214
04300,,497531250,136068750,498895312,138009375,38.06.03.752,138.26.26.858
04300,,497531250,136068750,498895312,138009375,38.16.36.497,138.30.07.866
04300,,497531250,136068750,498895312,138009375,37.52.16.935,138.17.09.345
04300,,497531250,136068750,498895312,138009375,37.51.37.162,138.24.51.748
04300,,497531250,136068750,498895312,138009375,37.58.22.800,138.31.27.171
04300,,497531250,136068750,498895312,138009375,38.04.40.404,138.32.17.106
04300,,497531250,136068750,498895312,138009375,38.03.31.314,138.34.49.696
04300,,497531250,136068750,498895312,138009375,38.06.39.244,138.26.24.770
04300,,497531250,136068750,498895312,138009375,38.09.48.062,138.28.09.579
04300,,497531250,136068750,498895312,138009375,38.16.45.126,138.26.35.251
04400,,504070312,127753125,505110937,128559375,35.30.06.921,140.15.13.066
04400,,504070312,127753125,505110937,128559375,35.31.59.969,140.09.27.162
04400,,504070312,127753125,505110937,128559375,35.36.58.964,140.03.52.779
04400,,504070312,127753125,505110937,128559375,35.30.24.600,140.17.03.077
04400,,504070312,127753125,505110937,128559375,35.29.40.470,140.15.25.483
04400,,504070312,127753125,505110937,128559375,35.31.39.356,140.10.39.235
04400,,504070312,127753125,505110937,128559375,35.37.47.685,140.02.31.398
04401,/,503535937,128184375,504576562,128868750,35.42.53.114,139.54.56.428
04401,/,503535937,128184375,504576562,128868750,35.46.17.480,140.07.06.461
04401,/,503535937,128184375,504576562,128868750,35.40.39.836,139.54.24.327
04401,/,503535937,128184375,504576562,128868750,35.47.13.761,140.04.02.892
04500,ڹ,503423437,126534375,504942187,127996875,35.30.01.224,140.03.54.022
04500,ڹ,503423437,126534375,504942187,127996875,35.12.37.034,139.59.12.459
04500,ڹ,503423437,126534375,504942187,127996875,35.15.26.402,139.56.44.452
04500,ڹ,503423437,126534375,504942187,127996875,35.23.33.384,140.11.20.394
04500,ڹ,503423437,126534375,504942187,127996875,35.31.36.768,140.11.53.230
04500,ڹ,503423437,126534375,504942187,127996875,35.10.41.755,139.59.53.543
04500,ڹ,503423437,126534375,504942187,127996875,35.10.21.052,140.06.06.356
04500,ڹ,503423437,126534375,504942187,127996875,35.21.49.419,139.50.32.520
04500,ڹ,503423437,126534375,504942187,127996875,35.27.54.631,139.58.00.588
04500,ڹ,503423437,126534375,504942187,127996875,35.25.51.713,140.11.02.442
04600,˼,503071875,125615625,503985937,127284375,34.54.05.477,139.53.55.676
04600,˼,503071875,125615625,503985937,127284375,34.58.08.918,139.47.33.789
04600,˼,503071875,125615625,503985937,127284375,34.58.13.229,139.54.24.044
04600,˼,503071875,125615625,503985937,127284375,35.12.37.094,139.51.13.998
04600,˼,503071875,125615625,503985937,127284375,34.53.57.796,139.51.13.731
04600,˼,503071875,125615625,503985937,127284375,34.53.51.573,139.54.16.058
04600,˼,503071875,125615625,503985937,127284375,35.02.44.518,139.49.42.245
04600,˼,503071875,125615625,503985937,127284375,35.10.17.250,139.49.10.145
04600,˼,503071875,125615625,503985937,127284375,35.17.31.283,139.50.03.470
04700,˼,503676562,125662500,505518750,127237500,35.06.54.299,140.05.48.669
04700,˼,503676562,125662500,505518750,127237500,35.08.51.544,140.06.43.746
04700,˼,503676562,125662500,505518750,127237500,35.13.15.755,140.23.29.838
04700,˼,503676562,125662500,505518750,127237500,35.02.53.510,140.01.55.156
04700,˼,503676562,125662500,505518750,127237500,35.09.04.447,140.19.50.307
04700,˼,503676562,125662500,505518750,127237500,35.18.30.630,140.14.05.414
04700,˼,503676562,125662500,505518750,127237500,34.58.29.075,139.56.10.766
04700,˼,503676562,125662500,505518750,127237500,34.59.43.578,139.58.46.562
04700,˼,503676562,125662500,505518750,127237500,35.03.22.450,139.56.37.000
04700,˼,503676562,125662500,505518750,127237500,35.04.40.635,139.57.00.207
04700,˼,503676562,125662500,505518750,127237500,35.04.00.642,140.05.39.992
04700,˼,503676562,125662500,505518750,127237500,35.06.10.572,140.06.42.705
04700,˼,503676562,125662500,505518750,127237500,35.09.44.133,140.05.55.927
04700,˼,503676562,125662500,505518750,127237500,35.11.27.913,140.10.03.833
04700,˼,503676562,125662500,505518750,127237500,35.13.33.258,140.24.27.334
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.31.59.269,140.26.17.589
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.19.25.551,140.15.39.729
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.36.36.415,140.19.25.686
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.24.27.886,140.23.57.974
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.24.52.842,140.23.55.338
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.27.05.234,140.11.08.832
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.29.07.443,140.16.34.819
04800,и/彽Τ,504646875,127134375,505828125,128268750,35.37.36.483,140.19.59.638
04801,ȬԾ,505504687,128081250,506770312,128859375,35.36.22.647,140.31.56.557
04801,ȬԾ,505504687,128081250,506770312,128859375,35.44.24.757,140.43.17.924
04801,ȬԾ,505504687,128081250,506770312,128859375,35.39.46.021,140.25.14.885
04801,ȬԾ,505504687,128081250,506770312,128859375,35.36.43.944,140.33.08.609
04801,ȬԾ,505504687,128081250,506770312,128859375,35.41.08.639,140.39.52.558
04801,ȬԾ,505504687,128081250,506770312,128859375,35.46.28.340,140.35.27.966
04900,/,504506250,128062500,505659375,129150000,35.35.04.487,140.17.32.663
04900,/,504506250,128062500,505659375,129150000,35.42.53.954,140.09.04.051
04900,/,504506250,128062500,505659375,129150000,35.50.42.910,140.19.16.807
04900,/,504506250,128062500,505659375,129150000,35.35.02.392,140.19.21.188
04900,/,504506250,128062500,505659375,129150000,35.40.23.891,140.25.03.456
04900,/,504506250,128062500,505659375,129150000,35.49.23.163,140.12.07.621
05000,ĸҼ,505153125,128465625,507164062,129450000,35.53.51.029,140.27.18.433
05000,ĸҼ,505153125,128465625,507164062,129450000,35.42.19.001,140.47.32.907
05000,ĸҼ,505153125,128465625,507164062,129450000,35.47.52.912,140.43.12.680
05000,ĸҼ,505153125,128465625,507164062,129450000,35.53.46.270,140.22.31.656
05000,ĸҼ,505153125,128465625,507164062,129450000,35.41.43.664,140.46.33.043
05000,ĸҼ,505153125,128465625,507164062,129450000,35.41.51.005,140.52.04.822
05000,ĸҼ,505153125,128465625,507164062,129450000,35.44.27.146,140.52.06.872
05000,ĸҼ,505153125,128465625,507164062,129450000,35.47.16.707,140.44.38.271
05000,ĸҼ,505153125,128465625,507164062,129450000,35.46.48.876,140.45.07.737
05000,ĸҼ,505153125,128465625,507164062,129450000,35.54.29.281,140.24.03.379
05000,ĸҼ,505153125,128465625,507164062,129450000,35.56.40.048,140.31.55.411
05100,//,503198437,128662500,504717187,129975000,35.44.45.103,139.59.42.466
05100,//,503198437,128662500,504717187,129975000,35.45.27.200,139.56.20.288
05100,//,503198437,128662500,504717187,129975000,35.46.37.639,140.07.41.220
05100,//,503198437,128662500,504717187,129975000,36.00.38.780,139.49.20.846
05100,//,503198437,128662500,504717187,129975000,35.46.55.301,139.53.50.425
05100,//,503198437,128662500,504717187,129975000,35.55.39.441,139.57.48.871
05100,//,503198437,128662500,504717187,129975000,35.55.49.567,139.57.52.215
05100,//,503198437,128662500,504717187,129975000,35.47.55.934,140.10.27.420
05100,//,503198437,128662500,504717187,129975000,35.50.30.716,140.09.51.961
05200,/Ĥ,503760937,129028125,505434375,130753125,36.00.04.932,140.03.53.441
05200,/Ĥ,503760937,129028125,505434375,130753125,36.12.30.924,140.18.52.347
05200,/Ĥ,503760937,129028125,505434375,130753125,36.17.35.616,140.09.31.788
05200,/Ĥ,503760937,129028125,505434375,130753125,36.16.57.603,140.13.09.086
05200,/Ĥ,503760937,129028125,505434375,130753125,35.51.38.657,140.13.12.655
05200,/Ĥ,503760937,129028125,505434375,130753125,36.08.45.877,140.00.37.237
05200,/Ĥ,503760937,129028125,505434375,130753125,36.18.12.308,140.13.19.891
05200,/Ĥ,503760937,129028125,505434375,130753125,35.59.05.592,139.58.28.780
05200,/Ĥ,503760937,129028125,505434375,130753125,35.59.25.829,139.58.28.052
05200,/Ĥ,503760937,129028125,505434375,130753125,35.52.59.719,140.20.39.477
05200,/Ĥ,503760937,129028125,505434375,130753125,35.56.00.510,140.15.34.376
05200,/Ĥ,503760937,129028125,505434375,130753125,36.04.55.366,139.59.50.144
05200,/Ĥ,503760937,129028125,505434375,130753125,36.07.14.278,140.10.59.300
05200,/Ĥ,503760937,129028125,505434375,130753125,36.12.33.013,140.02.46.656
05200,/Ĥ,503760937,129028125,505434375,130753125,36.10.01.651,140.19.18.434
05200,/Ĥ,503760937,129028125,505434375,130753125,36.19.05.969,140.10.23.519
05300,Ų,502875000,129487500,504140625,130912500,35.58.13.929,139.55.25.268
05300,Ų,502875000,129487500,504140625,130912500,36.11.22.456,139.43.12.875
05300,Ų,502875000,129487500,504140625,130912500,35.58.42.108,139.56.08.706
05300,Ų,502875000,129487500,504140625,130912500,36.07.25.839,139.43.05.783
05300,Ų,502875000,129487500,504140625,130912500,36.05.12.061,139.48.43.199
05300,Ų,502875000,129487500,504140625,130912500,36.05.24.690,139.48.40.637
05300,Ų,502875000,129487500,504140625,130912500,36.13.28.718,139.48.37.556
05300,Ų,502875000,129487500,504140625,130912500,36.18.26.751,139.52.19.794
05300,Ų,502875000,129487500,504140625,130912500,36.17.37.499,139.53.39.215
05300,Ų,502875000,129487500,504140625,130912500,36.17.37.702,139.55.17.161
05300,Ų,502875000,129487500,504140625,130912500,36.13.46.518,140.00.12.403
05400,ڱ,504534375,128653125,507065625,130453125,36.00.04.075,140.22.42.852
05400,ڱ,504534375,128653125,507065625,130453125,35.59.23.515,140.16.00.202
05400,ڱ,504534375,128653125,507065625,130453125,35.47.56.168,140.44.07.104
05400,ڱ,504534375,128653125,507065625,130453125,35.54.29.266,140.23.07.541
05400,ڱ,504534375,128653125,507065625,130453125,35.56.22.180,140.41.48.904
05400,ڱ,504534375,128653125,507065625,130453125,36.08.46.534,140.11.54.696
05400,ڱ,504534375,128653125,507065625,130453125,35.47.28.123,140.44.49.260
05400,ڱ,504534375,128653125,507065625,130453125,35.54.34.523,140.24.34.514
05400,ڱ,504534375,128653125,507065625,130453125,35.52.41.491,140.37.36.269
05400,ڱ,504534375,128653125,507065625,130453125,35.55.41.678,140.16.13.505
05400,ڱ,504534375,128653125,507065625,130453125,35.55.12.253,140.34.48.880
05400,ڱ,504534375,128653125,507065625,130453125,35.55.17.020,140.34.57.985
05400,ڱ,504534375,128653125,507065625,130453125,36.01.21.005,140.09.40.143
05400,ڱ,504534375,128653125,507065625,130453125,36.08.33.771,140.11.27.371
05400,ڱ,504534375,128653125,507065625,130453125,36.09.29.670,140.19.08.527
05400,ڱ,504534375,128653125,507065625,130453125,36.14.06.209,140.28.36.881
05500,,504014062,130246875,506179687,131503125,36.20.00.645,140.30.03.792
05500,,504014062,130246875,506179687,131503125,36.18.09.851,140.33.47.440
05500,,504014062,130246875,506179687,131503125,36.13.53.505,140.04.13.837
05500,,504014062,130246875,506179687,131503125,36.12.14.853,140.33.48.489
05500,,504014062,130246875,506179687,131503125,36.23.51.963,140.28.13.272
05500,,504014062,130246875,506179687,131503125,36.27.15.696,140.16.59.046
05500,,504014062,130246875,506179687,131503125,36.25.57.582,140.23.01.175
05500,,504014062,130246875,506179687,131503125,36.27.00.589,140.24.56.431
05500,,504014062,130246875,506179687,131503125,36.12.55.803,140.00.42.951
05500,,504014062,130246875,506179687,131503125,36.13.24.101,140.00.54.214
05500,,504014062,130246875,506179687,131503125,36.14.03.251,140.02.56.446
05500,,504014062,130246875,506179687,131503125,36.11.21.940,140.34.21.124
05500,,504014062,130246875,506179687,131503125,36.16.42.541,140.08.28.865
05500,,504014062,130246875,506179687,131503125,36.18.38.161,140.13.27.152
05500,,504014062,130246875,506179687,131503125,36.22.54.561,140.04.35.027
05500,,504014062,130246875,506179687,131503125,36.24.05.961,140.08.42.559
05500,,504014062,130246875,506179687,131503125,36.24.11.823,140.28.54.415
05500,,504014062,130246875,506179687,131503125,36.26.55.578,140.27.19.484
05600,Ω,504829687,130800000,506925000,132975000,36.36.20.587,140.16.54.300
05600,Ω,504829687,130800000,506925000,132975000,36.24.29.496,140.29.12.300
05600,Ω,504829687,130800000,506925000,132975000,36.28.16.349,140.22.39.989
05600,Ω,504829687,130800000,506925000,132975000,36.43.50.873,140.18.00.967
05600,Ω,504829687,130800000,506925000,132975000,36.20.23.516,140.35.49.075
05600,Ω,504829687,130800000,506925000,132975000,36.21.03.071,140.36.41.774
05600,Ω,504829687,130800000,506925000,132975000,36.37.12.344,140.15.37.539
05600,Ω,504829687,130800000,506925000,132975000,36.47.20.030,140.45.11.446
05600,Ω,504829687,130800000,506925000,132975000,36.21.51.869,140.33.01.574
05600,Ω,504829687,130800000,506925000,132975000,36.20.53.934,140.34.39.671
05600,Ω,504829687,130800000,506925000,132975000,36.31.47.602,140.15.53.056
05600,Ω,504829687,130800000,506925000,132975000,36.40.43.140,140.13.53.812
05600,Ω,504829687,130800000,506925000,132975000,36.46.07.219,140.16.00.147
05600,Ω,504829687,130800000,506925000,132975000,36.48.50.770,140.24.54.248
05600,Ω,504829687,130800000,506925000,132975000,36.52.38.440,140.20.31.756
05600,Ω,504829687,130800000,506925000,132975000,36.53.32.164,140.39.32.515
05700,ؼ,503142187,128418750,503198437,128475000,35.40.23.100,139.46.26.944
05701,ͭĮ/ë,503085937,128400000,503156250,128484375,35.40.58.659,139.45.38.166
05702,ո,503170312,128484375,503254687,128531250,35.41.54.918,139.46.51.632
05703,,503128125,128475000,503226562,128493750,35.41.20.586,139.46.28.508
05704,ο/Į,503114062,128484375,503184375,128521875,35.41.34.479,139.45.34.805
05705,Į/ԥë,503029687,128428125,503114062,128521875,35.41.13.439,139.44.13.052
05800,,503142187,128371875,503198437,128428125,35.39.42.879,139.46.00.503
05802,ܶ,503184375,128400000,503240625,128475000,35.40.13.053,139.46.50.530
05804,ͷĮ/Į,503226562,128428125,503268750,128484375,35.40.32.733,139.47.25.884
05805,,503170312,128362500,503226562,128400000,35.39.23.389,139.46.20.884
05806,//˭,503156250,128287500,503268750,128409375,35.38.09.152,139.46.55.808
05807,,503071875,128353125,503170312,128400000,35.39.23.009,139.44.50.952
05808,;Į/Ǳ,503071875,128268750,503170312,128362500,35.38.51.959,139.45.29.699
05809,Į/,503057812,128287500,503100000,128343750,35.38.30.615,139.44.20.439
05810,,503029687,128240625,503170312,128287500,35.37.23.324,139.45.26.501
05900,ֺ,503015625,128390625,503100000,128446875,35.39.57.625,139.44.27.847
05901,Ļ/ǻĮ,502973437,128371875,503029687,128437500,35.39.42.959,139.43.43.071
05902,ϻ,503029687,128353125,503085937,128390625,35.39.31.086,139.44.00.597
05903,,502973437,128343750,503029687,128381250,35.39.27.190,139.42.58.915
05904,۽,503029687,128343750,503085937,128362500,35.39.11.367,139.44.13.440
05905,/,502973437,128259375,503057812,128362500,35.38.39.940,139.44.06.131
05906,,503170312,128090625,503395312,128325000,35.37.04.469,139.46.17.030
06000,/ȿ,502903125,128146875,503085937,128268750,35.37.29.323,139.42.55.622
06001,ܹ,502889062,128221875,503001562,128296875,35.37.55.535,139.42.21.169
06002,ŷ,503071875,128090625,503198437,128240625,35.34.52.625,139.45.38.500
06003,Į,502973437,128109375,503100000,128184375,35.35.58.833,139.43.55.054
06004,翹,502903125,128006250,503254687,128146875,35.34.55.390,139.46.11.575
06100,,502832812,127884375,503325000,128100000,35.32.43.897,139.48.25.774
06101,ıĴ,502720312,128062500,502931250,128165625,35.35.57.219,139.41.07.034
06200,ëؼ,502875000,128325000,502945312,128400000,35.39.42.790,139.41.55.927
06201,ë̤/ܱ׺,502931250,128334375,502973437,128381250,35.38.58.210,139.42.31.250
06203,ɽƻ/,502931250,128362500,502973437,128437500,35.39.55.017,139.42.49.694
06204,/塹ھ帶,502818750,128381250,502903125,128475000,35.40.40.148,139.40.19.990
06205,/崱,502917187,128287500,503001562,128334375,35.38.30.576,139.42.16.608
06206,ܹ,502846875,128231250,502945312,128343750,35.37.37.013,139.41.03.440
06207,ͳ,502790625,128146875,502903125,128250000,35.37.12.019,139.40.21.899
06208,㲰/,502790625,128250000,502875000,128343750,35.38.14.270,139.40.28.825
06209,Ҷ,502565625,128165625,502692187,128250000,35.36.38.259,139.36.54.946
06210,,502692187,128146875,502790625,128231250,35.36.37.401,139.38.23.844
06211,,502734375,128334375,502875000,128409375,35.39.00.710,139.39.09.302
06212,,502425000,128212500,502706250,128446875,35.39.30.846,139.36.38.298
06213,,502720312,128362500,502818750,128465625,35.40.26.889,139.38.47.031
06214,,502537500,128362500,502734375,128493750,35.40.10.526,139.36.57.557
06215,Ѳ/,502664062,128212500,502832812,128296875,35.37.37.740,139.38.09.698
06216,ë/Ʋ,502635937,128296875,502790625,128362500,35.38.56.343,139.37.16.843
06300,,502931250,128465625,502959375,128484375,35.41.08.588,139.42.16.800
06301,,502875000,128456250,502931250,128503125,35.41.06.428,139.41.19.282
06302,/塹,502889062,128400000,502973437,128465625,35.40.40.649,139.42.46.067
06303,ɲĮ,502931250,128484375,502973437,128503125,35.41.27.050,139.42.47.887
06304,ɣ,502945312,128456250,502987500,128484375,35.40.59.847,139.42.42.283
06305,̥ë/ǻĮ,502973437,128437500,503029687,128465625,35.40.44.425,139.43.17.712
06306,ë,502987500,128437500,503057812,128484375,35.41.06.805,139.43.20.246
06307,Ķ/ں,503043750,128503125,503114062,128550000,35.42.05.893,139.44.11.906
06308,Ͼ/,502903125,128475000,503043750,128568750,35.42.14.887,139.43.57.034
06309,,502720312,128456250,502917187,128606250,35.41.15.493,139.40.13.492
06310,߻/ë,502664062,128446875,502804687,128578125,35.41.32.760,139.37.45.642
06312,/,502509375,128475000,502678125,128587500,35.42.30.672,139.37.08.792
06314,/,502270312,128550000,502720312,128793750,35.43.52.406,139.33.51.116
06400,ܶ,503128125,128521875,503198437,128596875,35.42.08.588,139.45.30.799
06401,/,503128125,128578125,503184375,128625000,35.43.01.031,139.46.17.636
06402,/,503071875,128540625,503128125,128596875,35.42.34.668,139.45.07.815
06403,/,502987500,128540625,503071875,128615625,35.42.54.851,139.43.43.312
06404,ڱ/ƻ,503100000,128512500,503128125,128540625,35.41.54.611,139.45.08.340
06500,,502846875,128578125,503043750,128690625,35.43.32.091,139.41.49.302
06501,,502832812,128550000,502987500,128643750,35.43.12.922,139.42.01.800
06502,,502734375,128596875,502959375,128765625,35.44.07.259,139.40.31.756
06503,˭/˭,502664062,128606250,502818750,128728125,35.44.52.143,139.37.55.300
06504,,502664062,128709375,502917187,128868750,35.47.14.501,139.38.52.968
06505,,503001562,128671875,503142187,128765625,35.45.05.118,139.43.26.073
06506,Τ,503043750,128643750,503142187,128690625,35.44.47.930,139.44.51.203
06507,콽,502903125,128681250,503057812,128775000,35.45.40.526,139.42.00.201
06508,ֱ,502846875,128728125,503057812,128859375,35.47.00.038,139.43.39.939
06509,ü//,503029687,128587500,503254687,128700000,35.43.29.928,139.44.15.675
06600,/Į,503184375,128521875,503282812,128615625,35.42.51.132,139.46.56.174
06601,,503240625,128521875,503325000,128615625,35.42.25.367,139.48.00.881
06602,Τ,503170312,128587500,503268750,128662500,35.43.10.191,139.46.54.526
06603,齻,503057812,128615625,503493750,128934375,35.48.13.342,139.46.25.776
06604,,503339062,128428125,503592187,128746875,35.41.18.430,139.51.53.035
06605,,503451562,128428125,503718750,128850000,35.44.30.149,139.54.15.577
06700,ξ,503254687,128475000,503325000,128540625,35.41.55.559,139.48.09.237
06701,ӻĮ/Ƚ,503296875,128437500,503395312,128634375,35.41.34.248,139.48.47.685
06702,,503367187,128428125,503507812,128615625,35.41.04.820,139.51.03.365
06703,,503254687,128428125,503325000,128475000,35.40.35.603,139.47.50.036
06704,,503240625,128362500,503310937,128428125,35.40.03.903,139.48.20.552
06705,ھ,503310937,128381250,503367187,128437500,35.39.52.300,139.49.22.744
06706,ä̦/ͭ/ھ,503268750,128184375,503465625,128400000,35.36.26.544,139.49.45.909
06707,Į,503367187,128390625,503465625,128484375,35.40.36.143,139.49.37.207
06708,׳,503465625,128259375,503606250,128446875,35.40.40.262,139.51.40.732
06800,Ⱦͻ/,502298437,128362500,502551562,128587500,35.41.04.782,139.31.51.491
06801,ʬ/Ω,501918750,128400000,502340625,128681250,35.43.04.277,139.27.10.069
06802,,501539062,128634375,502368750,129234375,35.46.18.991,139.24.29.819
06802,,501539062,128634375,502368750,129234375,35.50.03.496,139.21.08.670
06802,,501539062,128634375,502368750,129234375,35.45.54.362,139.26.37.731
06900,ǽ/,500765625,128934375,501848437,129571875,35.57.34.474,139.15.05.121
06900,ǽ/,500765625,128934375,501848437,129571875,35.57.31.065,139.10.52.921
06900,ǽ/,500765625,128934375,501848437,129571875,35.51.11.731,139.09.49.685
07000,/쾾,500948437,129018750,502453125,129993750,35.58.16.081,139.21.46.569
07000,/쾾,500948437,129018750,502453125,129993750,35.58.27.777,139.19.18.446
07000,/쾾,500948437,129018750,502453125,129993750,35.56.17.864,139.31.59.639
07000,/쾾,500948437,129018750,502453125,129993750,36.05.43.941,139.21.41.240
07000,/쾾,500948437,129018750,502453125,129993750,35.53.18.462,139.27.46.617
07000,/쾾,500948437,129018750,502453125,129993750,35.56.16.253,139.21.46.295
07000,/쾾,500948437,129018750,502453125,129993750,36.04.30.740,139.26.04.676
07000,/쾾,500948437,129018750,502453125,129993750,36.02.34.779,139.33.08.058
07001,¸/ī/ٻθ,502129687,128700000,502762500,129187500,35.50.08.088,139.35.39.565
07001,¸/ī/ٻθ,502129687,128700000,502762500,129187500,35.47.16.076,139.32.25.924
07001,¸/ī/ٻθ,502129687,128700000,502762500,129187500,35.46.21.233,139.34.47.062
07001,¸/ī/ٻθ,502129687,128700000,502762500,129187500,35.46.32.575,139.37.39.654
07100,,502228125,129131250,503001562,129740625,36.00.03.641,139.31.32.430
07100,,502228125,129131250,503001562,129740625,35.54.39.568,139.32.44.981
07100,,502228125,129131250,503001562,129740625,35.53.28.209,139.43.09.862
07100,,502228125,129131250,503001562,129740625,35.58.01.886,139.40.11.456
07101,,502495312,128868750,503071875,129253125,35.48.08.023,139.41.25.361
07101,,502495312,128868750,503071875,129253125,35.53.12.744,139.37.14.331
07101,,502495312,128868750,503071875,129253125,35.52.59.074,139.36.04.047
07102,,502790625,128793750,503240625,129187500,35.49.07.109,139.46.06.182
07200,/,503170312,128803125,503648437,129121875,35.48.22.752,139.47.09.471
07201,״/,502157812,129571875,503339062,130340625,36.01.55.554,139.35.39.378
07201,״/,502157812,129571875,503339062,130340625,36.04.47.864,139.32.55.325
07201,״/,502157812,129571875,503339062,130340625,36.06.04.749,139.33.18.118
07201,״/,502157812,129571875,503339062,130340625,36.00.15.684,139.40.42.632
07201,״/,502157812,129571875,503339062,130340625,36.04.31.194,139.45.54.125
07201,״/,502157812,129571875,503339062,130340625,36.11.10.662,139.30.36.922
07202,/ë,502804687,129075000,503634375,129703125,35.57.00.034,139.49.50.581
07202,/ë,502804687,129075000,503634375,129703125,35.52.06.721,139.46.04.736
07202,/ë,502804687,129075000,503634375,129703125,35.57.47.013,139.40.34.025
07300,ë/ë,500315625,129721875,502425000,130575000,36.10.02.071,139.27.20.258
07300,ë/ë,500315625,129721875,502425000,130575000,36.03.29.205,139.31.07.102
07300,ë/ë,500315625,129721875,502425000,130575000,36.08.53.130,139.04.20.389
07300,ë/ë,500315625,129721875,502425000,130575000,36.12.01.110,139.24.52.610
07300,ë/ë,500315625,129721875,502425000,130575000,36.06.31.933,138.59.02.434
07300,ë/ë,500315625,129721875,502425000,130575000,36.07.18.591,139.02.42.867
07300,ë/ë,500315625,129721875,502425000,130575000,36.05.54.069,139.20.12.381
07300,ë/ë,500315625,129721875,502425000,130575000,36.08.51.283,139.30.37.218
07400,/Ĺ,499359375,129018750,501440625,130106250,36.02.37.805,138.52.31.332
07400,/Ĺ,499359375,129018750,501440625,130106250,35.51.38.651,138.51.15.859
07400,/Ĺ,499359375,129018750,501440625,130106250,36.05.42.173,138.58.40.131
07400,/Ĺ,499359375,129018750,501440625,130106250,35.51.27.449,138.51.46.514
07400,/Ĺ,499359375,129018750,501440625,130106250,35.59.38.861,138.44.22.068
07400,/Ĺ,499359375,129018750,501440625,130106250,35.52.26.911,139.04.22.206
07400,/Ĺ,499359375,129018750,501440625,130106250,35.54.28.448,139.06.46.696
07400,/Ĺ,499359375,129018750,501440625,130106250,36.05.06.253,138.55.11.410
07400,/Ĺ,499359375,129018750,501440625,130106250,36.04.49.230,139.09.06.926
07400,/Ĺ,499359375,129018750,501440625,130106250,36.05.32.785,139.09.43.801
07500,/Ĵ,501960937,128268750,502537500,128512500,35.40.44.477,139.29.09.489
07501,¿,501707812,128165625,502312500,128484375,35.39.29.706,139.25.56.011
07501,¿,501707812,128165625,502312500,128484375,35.38.53.570,139.28.15.885
07600,Ȭ,500273437,127931250,501960937,128634375,35.40.41.686,139.20.38.443
07600,Ȭ,500273437,127931250,501960937,128634375,35.34.25.683,139.02.27.620
07600,Ȭ,500273437,127931250,501960937,128634375,35.35.24.532,139.03.46.033
07600,Ȭ,500273437,127931250,501960937,128634375,35.36.02.133,139.15.32.875
07600,Ȭ,500273437,127931250,501960937,128634375,35.41.28.167,138.58.54.147
07600,Ȭ,500273437,127931250,501960937,128634375,35.36.27.883,139.16.08.465
07600,Ȭ,500273437,127931250,501960937,128634375,35.38.01.753,139.25.49.427
07600,Ȭ,500273437,127931250,501960937,128634375,35.41.08.764,139.12.37.381
07700,Ω,501609375,128456250,502031250,128756250,35.41.09.785,139.25.24.492
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.41.54.817,139.11.19.579
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.46.40.517,138.52.07.610
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.41.40.936,139.04.45.040
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.52.52.377,139.00.39.591
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.50.41.803,139.08.56.877
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.50.59.151,138.54.58.876
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.42.46.670,139.02.08.925
07701,/ʡ/¿,499739062,128381250,501792187,129225000,35.49.47.399,139.17.04.057
07800,¤θ/ޥץ顼/,502087500,127893750,502720312,128203125,35.33.51.254,139.31.25.205
07800,¤θ/ޥץ顼/,502087500,127893750,502720312,128203125,35.34.02.929,139.30.40.113
07801,̥˥塼,502368750,127809375,502621875,128053125,35.30.43.729,139.35.45.483
07802,ߤʤȤߤ餤,502579687,127575000,502762500,127678125,35.26.49.215,139.38.02.068
07803,Į/ڳ,502720312,127528125,502818750,127621875,35.26.57.161,139.39.46.244
07804,/Į,502635937,127556250,502720312,127603125,35.26.16.217,139.38.24.573
07805,Į,502692187,127509375,502762500,127575000,35.25.17.731,139.38.31.036
07806,/̱,502664062,127425000,502917187,127621875,35.24.28.960,139.39.33.122
07807,/ڥë,502467187,127462500,502692187,127584375,35.24.46.086,139.36.14.274
07808,ڥë,502382812,127556250,502621875,127809375,35.29.50.002,139.35.48.777
07809,,502537500,127256250,502748437,127528125,35.23.48.643,139.37.34.297
07810,Ȭ/ʸ,502523437,127106250,502790625,127406250,35.20.07.535,139.37.39.328
07811,,502579687,127621875,502692187,127781250,35.28.59.176,139.36.26.094
07812,粬/,502410937,127293750,502593750,127500000,35.23.47.981,139.34.42.437
07813,/ܶ,502270312,127200000,502551562,127378125,35.21.54.767,139.32.03.407
07814,,502143750,127265625,502481250,127603125,35.22.49.776,139.32.53.326
07815,/бԻ,502101562,127378125,502312500,127603125,35.23.22.145,139.29.51.240
07816,/ë/Ķ,501862500,127453125,502256250,127856250,35.24.52.003,139.25.17.617
07817,滳/Ĺ,502115625,127762500,502523437,127921875,35.30.14.249,139.29.26.939
07818,˾/,502171875,127584375,502467187,127818750,35.29.40.591,139.33.20.970
07819,,502537500,127762500,502762500,127978125,35.30.29.183,139.35.53.844
07820,/ḫ,502692187,127593750,503592187,128015625,35.29.31.205,139.45.58.277
07820,/ḫ,502692187,127593750,503592187,128015625,35.27.02.944,139.41.14.007
07821,¢/,502621875,127931250,502846875,128137500,35.34.00.387,139.38.19.043
07900,ɴ/и,502031250,128015625,502579687,128296875,35.34.10.391,139.30.11.634
07900,ɴ/и,502031250,128015625,502579687,128296875,35.37.00.666,139.35.24.398
08000,/ͳ/,502157812,127059375,502537500,127312500,35.17.59.609,139.33.47.845
08100,ܲ/,502382812,126440625,503114062,127181250,35.08.31.333,139.40.28.138
08100,ܲ/,502382812,126440625,503114062,127181250,35.12.12.151,139.41.22.587
08100,ܲ/,502382812,126440625,503114062,127181250,35.19.12.587,139.39.27.040
08100,ܲ/,502382812,126440625,503114062,127181250,35.08.03.695,139.39.34.494
08100,ܲ/,502382812,126440625,503114062,127181250,35.11.36.412,139.35.59.184
08100,ܲ/,502382812,126440625,503114062,127181250,35.12.36.979,139.36.55.804
08100,ܲ/,502382812,126440625,503114062,127181250,35.18.26.921,139.36.01.148
08200,ʿ/,501243750,127012500,501764062,127425000,35.17.50.429,139.14.42.066
08200,ʿ/,501243750,127012500,501764062,127425000,35.17.55.492,139.18.02.039
08200,ʿ/,501243750,127012500,501764062,127425000,35.18.27.020,139.19.20.846
08200,ʿ/,501243750,127012500,501764062,127425000,35.20.42.154,139.15.05.782
08200,ʿ/,501243750,127012500,501764062,127425000,35.22.51.946,139.21.00.642
08201,ƣ//,501735937,127050000,502256250,127518750,35.18.46.907,139.22.54.865
08300,Į/,501356250,127753125,502171875,128221875,35.31.09.002,139.22.00.072
08300,Į/,501356250,127753125,502171875,128221875,35.35.43.997,139.22.56.291
08301,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,35.22.14.383,139.09.03.443
08301,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,35.27.32.510,139.24.26.389
08301,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,35.27.54.745,139.25.26.729
08301,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,35.31.20.907,139.13.46.356
08301,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,35.22.41.896,139.21.16.639
08301,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,35.26.34.280,139.09.39.433
08301,ܸ/Ϸ̾,500920312,127096875,501989062,127996875,35.32.35.251,139.15.25.890
08400,/,500835937,123046875,502045312,125268750,34.11.56.460,139.08.09.668
08400,/,500835937,123046875,502045312,125268750,34.43.09.101,139.21.16.398
08400,/,500835937,123046875,502045312,125268750,34.12.09.862,139.11.31.966
08400,/,500835937,123046875,502045312,125268750,34.19.47.575,139.13.26.071
08400,/,500835937,123046875,502045312,125268750,34.40.52.912,139.23.47.364
08500,/Ȭ,502101562,116775000,503521875,122840625,34.03.48.024,139.29.13.977
08500,/Ȭ,502101562,116775000,503521875,122840625,34.05.01.466,139.29.07.512
08500,/Ȭ,502101562,116775000,503521875,122840625,33.02.54.409,139.50.31.044
08500,/Ȭ,502101562,116775000,503521875,122840625,33.05.30.739,139.46.41.334
08500,/Ȭ,502101562,116775000,503521875,122840625,33.07.31.706,139.49.11.598
08600,޸,505040625,87178125,512114062,109781250,26.38.52.641,142.10.30.773
08600,޸,505040625,87178125,512114062,109781250,24.46.02.915,141.18.53.185
08600,޸,505040625,87178125,512114062,109781250,27.05.04.697,142.11.00.213
08600,޸,505040625,87178125,512114062,109781250,27.08.29.447,142.10.30.910
08600,޸,505040625,87178125,512114062,109781250,30.29.31.123,140.17.54.872
08600,޸,505040625,87178125,512114062,109781250,24.47.24.549,141.21.18.477
08600,޸,505040625,87178125,512114062,109781250,24.48.03.196,141.17.12.549
08600,޸,505040625,87178125,512114062,109781250,25.24.54.451,141.16.20.150
08600,޸,505040625,87178125,512114062,109781250,25.26.55.432,141.17.26.938
08600,޸,505040625,87178125,512114062,109781250,26.36.28.554,142.07.22.834
08600,޸,505040625,87178125,512114062,109781250,26.36.48.257,142.10.08.404
08600,޸,505040625,87178125,512114062,109781250,26.41.01.124,142.08.58.246
08600,޸,505040625,87178125,512114062,109781250,27.02.11.902,142.13.53.540
08600,޸,505040625,87178125,512114062,109781250,27.06.54.780,142.10.20.248
08600,޸,505040625,87178125,512114062,109781250,27.10.34.672,142.11.47.934
08700,ĸ,500104687,126628125,501581250,128175000,35.30.07.297,138.59.15.384
08700,ĸ,500104687,126628125,501581250,128175000,35.35.08.272,139.15.04.599
08700,ĸ,500104687,126628125,501581250,128175000,35.25.39.990,138.55.52.132
08700,ĸ,500104687,126628125,501581250,128175000,35.33.47.830,139.13.37.554
08700,ĸ,500104687,126628125,501581250,128175000,35.14.14.914,139.04.16.616
08700,ĸ,500104687,126628125,501581250,128175000,35.18.49.486,139.00.47.215
08700,ĸ,500104687,126628125,501581250,128175000,35.23.58.414,138.58.47.859
08700,ĸ,500104687,126628125,501581250,128175000,35.21.38.011,139.09.32.460
08700,ĸ,500104687,126628125,501581250,128175000,35.30.46.260,139.12.12.858
08800,Ȣ,500315625,126609375,500821875,127040625,35.11.01.520,139.00.35.262
08800,Ȣ,500315625,126609375,500821875,127040625,35.16.55.551,139.00.26.838
08900,/ϸ,500512500,126478125,501018750,126712500,35.09.34.633,139.09.02.397
09000,Ǯ//Ʀ,499964062,124968750,501046875,126525000,35.05.03.461,139.03.01.451
09000,Ǯ//Ʀ,499964062,124968750,501046875,126525000,34.52.54.882,139.07.38.139
09000,Ǯ//Ʀ,499964062,124968750,501046875,126525000,34.58.47.957,139.05.40.231
09000,Ǯ//Ʀ,499964062,124968750,501046875,126525000,34.43.26.984,138.57.57.035
09000,Ǯ//Ʀ,499964062,124968750,501046875,126525000,34.44.32.910,139.00.16.950
09000,Ǯ//Ʀ,499964062,124968750,501046875,126525000,34.56.21.876,139.02.55.701
09000,Ǯ//Ʀ,499964062,124968750,501046875,126525000,35.04.10.069,139.02.16.477
09200,/Ʀ,499457812,124546875,500385937,125175000,34.38.45.645,138.46.26.748
09200,/Ʀ,499457812,124546875,500385937,125175000,34.39.46.695,138.56.26.660
09200,/Ʀ,499457812,124546875,500385937,125175000,34.37.16.111,138.47.39.379
09200,/Ʀ,499457812,124546875,500385937,125175000,34.36.29.356,138.49.39.583
09200,/Ʀ,499457812,124546875,500385937,125175000,34.41.57.490,138.49.14.999
09300,//¾,499443750,125896875,500470312,127434375,35.03.08.668,138.53.31.480
09300,//¾,499443750,125896875,500470312,127434375,35.16.18.383,138.58.18.265
09300,//¾,499443750,125896875,500470312,127434375,34.59.43.073,138.52.37.833
09300,//¾,499443750,125896875,500470312,127434375,35.15.04.106,138.47.26.109
09300,//¾,499443750,125896875,500470312,127434375,35.15.57.155,138.58.14.490
09300,//¾,499443750,125896875,500470312,127434375,35.19.06.184,139.00.40.141
09300,//¾,499443750,125896875,500470312,127434375,35.01.01.381,138.51.53.623
09300,//¾,499443750,125896875,500470312,127434375,35.06.30.030,138.49.05.490
09300,//¾,499443750,125896875,500470312,127434375,35.18.23.561,138.45.47.442
09301,Ʀ,499457812,124912500,500034375,126046875,34.48.45.485,138.45.39.588
09301,Ʀ,499457812,124912500,500034375,126046875,35.00.21.535,138.46.57.287
09301,Ʀ,499457812,124912500,500034375,126046875,34.44.51.349,138.53.03.933
09301,Ʀ,499457812,124912500,500034375,126046875,34.53.09.146,138.45.53.455
09302,Ʀ,499809375,125362500,500653125,126637500,34.56.18.964,138.50.38.581
09302,Ʀ,499809375,125362500,500653125,126637500,35.00.07.462,138.55.30.159
09302,Ʀ,499809375,125362500,500653125,126637500,35.00.46.404,139.01.54.254
09302,Ʀ,499809375,125362500,500653125,126637500,34.54.43.570,138.51.07.454
09302,Ʀ,499809375,125362500,500653125,126637500,35.07.18.751,139.01.59.193
09302,Ʀ,499809375,125362500,500653125,126637500,34.57.35.821,138.50.28.031
09302,Ʀ,499809375,125362500,500653125,126637500,34.57.31.529,139.03.26.946
09400,ٻε,498895312,127265625,500639062,128643750,35.21.20.990,138.41.21.314
09400,ٻε,498895312,127265625,500639062,128643750,35.22.55.923,138.40.25.932
09400,ٻε,498895312,127265625,500639062,128643750,35.29.10.724,138.55.20.565
09400,ٻε,498895312,127265625,500639062,128643750,35.43.48.608,138.54.32.868
09400,ٻε,498895312,127265625,500639062,128643750,35.43.49.773,138.54.51.901
09400,ٻε,498895312,127265625,500639062,128643750,35.34.04.219,139.00.04.534
09400,ٻε,498895312,127265625,500639062,128643750,35.21.32.036,138.42.31.773
09400,ٻε,498895312,127265625,500639062,128643750,35.28.12.347,138.35.00.231
09400,ٻε,498895312,127265625,500639062,128643750,35.26.38.524,138.55.56.496
09400,ٻε,498895312,127265625,500639062,128643750,35.30.34.392,138.58.12.147
09400,ٻε,498895312,127265625,500639062,128643750,35.37.52.718,138.50.03.584
09400,ٻε,498895312,127265625,500639062,128643750,35.41.03.518,138.58.45.211
09500,ٻ/ٻε,498698437,126393750,499739062,127593750,35.24.27.091,138.32.52.319
09500,ٻ/ٻε,498698437,126393750,499739062,127593750,35.08.32.649,138.45.37.276
09500,ٻ/ٻε,498698437,126393750,499739062,127593750,35.07.08.243,138.39.23.287
09500,ٻ/ٻε,498698437,126393750,499739062,127593750,35.15.45.049,138.46.33.806
09600,,497446875,127856250,499921875,129318750,35.34.29.057,138.32.57.024
09600,,497446875,127856250,499921875,129318750,35.36.56.748,138.19.43.643
09600,,497446875,127856250,499921875,129318750,35.34.11.409,138.28.41.771
09600,,497446875,127856250,499921875,129318750,35.37.18.589,138.47.32.077
09600,,497446875,127856250,499921875,129318750,35.42.30.974,138.10.51.951
09600,,497446875,127856250,499921875,129318750,35.54.28.387,138.31.54.141
09600,,497446875,127856250,499921875,129318750,35.51.23.611,138.50.48.032
09600,,497446875,127856250,499921875,129318750,35.33.38.248,138.32.41.440
09600,,497446875,127856250,499921875,129318750,35.32.22.222,138.38.08.888
09600,,497446875,127856250,499921875,129318750,35.34.00.152,138.47.22.160
09600,,497446875,127856250,499921875,129318750,35.38.19.551,138.50.46.876
09600,,497446875,127856250,499921875,129318750,35.45.40.445,138.18.39.121
09600,,497446875,127856250,499921875,129318750,35.52.16.398,138.26.55.579
09600,,497446875,127856250,499921875,129318750,35.54.41.823,138.32.57.621
09600,,497446875,127856250,499921875,129318750,35.53.55.588,138.42.01.017
09700,ȱ,497629687,126590625,498965625,128325000,35.15.03.982,138.30.04.414
09700,ȱ,497629687,126590625,498965625,128325000,35.32.31.381,138.30.02.811
09700,ȱ,497629687,126590625,498965625,128325000,35.29.26.884,138.16.05.906
09700,ȱ,497629687,126590625,498965625,128325000,35.22.15.157,138.30.57.013
09700,ȱ,497629687,126590625,498965625,128325000,35.26.21.012,138.15.32.099
09700,ȱ,497629687,126590625,498965625,128325000,35.12.07.480,138.23.42.339
09700,ȱ,497629687,126590625,498965625,128325000,35.10.41.709,138.30.29.458
09700,ȱ,497629687,126590625,498965625,128325000,35.22.25.812,138.31.37.159
09700,ȱ,497629687,126590625,498965625,128325000,35.29.48.204,138.15.49.383
09700,ȱ,497629687,126590625,498965625,128325000,35.33.32.281,138.14.56.327
09700,ȱ,497629687,126590625,498965625,128325000,35.32.13.934,138.34.19.801
09800,Ų,497109375,125803125,498375000,128306250,35.07.35.722,138.11.16.581
09800,Ų,497109375,125803125,498375000,128306250,35.15.43.201,138.10.19.917
09800,Ų,497109375,125803125,498375000,128306250,35.04.48.936,138.12.51.078
09800,Ų,497109375,125803125,498375000,128306250,35.16.04.246,138.09.04.039
09800,Ų,497109375,125803125,498375000,128306250,35.24.11.583,138.08.58.110
09800,Ų,497109375,125803125,498375000,128306250,34.58.34.817,138.16.18.942
09800,Ų,497109375,125803125,498375000,128306250,35.05.16.420,138.12.03.704
09800,Ų,497109375,125803125,498375000,128306250,35.12.08.335,138.12.59.978
09800,Ų,497109375,125803125,498375000,128306250,35.17.59.219,138.06.20.481
09800,Ų,497109375,125803125,498375000,128306250,35.18.38.469,138.18.10.764
09800,Ų,497109375,125803125,498375000,128306250,35.19.11.387,138.19.35.321
09800,Ų,497109375,125803125,498375000,128306250,35.29.33.299,138.09.15.344
09801,/ƣ/,497362500,125146875,498079687,126037500,34.58.51.335,138.12.12.060
09801,/ƣ/,497362500,125146875,498079687,126037500,35.00.08.060,138.12.14.499
09801,/ƣ/,497362500,125146875,498079687,126037500,34.47.53.154,138.19.18.595
09801,/ƣ/,497362500,125146875,498079687,126037500,34.53.29.964,138.11.02.572
09802,/ø,498234375,125840625,499106250,126750000,34.57.51.193,138.29.36.876
09802,/ø,498234375,125840625,499106250,126750000,34.58.58.823,138.27.26.902
09802,/ø,498234375,125840625,499106250,126750000,35.06.40.694,138.24.12.542
09900,Ųؼ,497868750,125625000,498515625,126037500,34.57.31.755,138.27.15.173
09900,Ųؼ,497868750,125625000,498515625,126037500,35.00.08.653,138.24.24.273
10000,/,496800000,124528125,497882812,127246875,35.16.22.843,138.02.04.294
10000,/,496800000,124528125,497882812,127246875,35.17.35.431,138.02.02.676
10000,/,496800000,124528125,497882812,127246875,34.36.01.123,138.11.22.181
10000,/,496800000,124528125,497882812,127246875,34.48.34.231,138.14.09.186
10000,/,496800000,124528125,497882812,127246875,35.06.39.072,138.03.01.953
10000,/,496800000,124528125,497882812,127246875,35.13.29.123,138.02.28.136
10000,/,496800000,124528125,497882812,127246875,35.14.09.247,138.11.52.899
10000,/,496800000,124528125,497882812,127246875,34.35.53.529,138.12.15.221
10000,/,496800000,124528125,497882812,127246875,34.37.51.993,138.12.19.213
10000,/,496800000,124528125,497882812,127246875,34.48.33.361,138.06.31.135
10000,/,496800000,124528125,497882812,127246875,34.45.32.116,138.17.25.980
10000,/,496800000,124528125,497882812,127246875,34.53.47.977,138.09.56.717
10000,/,496800000,124528125,497882812,127246875,34.54.41.848,138.09.31.270
10000,/,496800000,124528125,497882812,127246875,34.59.14.873,138.10.51.521
10000,/,496800000,124528125,497882812,127246875,35.09.10.073,138.00.21.725
10000,/,496800000,124528125,497882812,127246875,35.08.51.419,138.12.44.798
10000,/,496800000,124528125,497882812,127246875,35.18.31.414,138.01.41.464
10100,/,496589062,124584375,497475000,125700000,34.47.37.375,138.00.07.063
10100,/,496589062,124584375,497475000,125700000,34.37.18.283,138.07.38.662
10100,/,496589062,124584375,497475000,125700000,34.38.03.364,138.05.12.931
10100,/,496589062,124584375,497475000,125700000,34.44.18.030,138.00.45.628
10101,/ް,496040625,124706250,496968750,125896875,34.51.57.439,137.56.21.053
10101,/ް,496040625,124706250,496968750,125896875,34.55.01.350,138.00.02.518
10101,/ް,496040625,124706250,496968750,125896875,34.42.18.277,137.58.09.629
10101,/ް,496040625,124706250,496968750,125896875,34.38.58.444,137.50.21.866
10101,/ް,496040625,124706250,496968750,125896875,34.39.16.578,137.52.00.503
10101,/ް,496040625,124706250,496968750,125896875,34.46.06.745,137.49.40.306
10101,/ް,496040625,124706250,496968750,125896875,34.52.37.332,137.53.38.449
10200,ڰ/,497826562,129871875,499148437,131100000,36.07.36.125,138.30.57.519
10200,ڰ/,497826562,129871875,499148437,131100000,36.12.36.498,138.35.38.983
10200,ڰ/,497826562,129871875,499148437,131100000,36.06.36.269,138.18.25.866
10200,ڰ/,497826562,129871875,499148437,131100000,36.08.28.266,138.34.53.446
10200,ڰ/,497826562,129871875,499148437,131100000,36.18.49.635,138.18.28.776
10200,ڰ/,497826562,129871875,499148437,131100000,36.24.08.318,138.30.03.314
10200,ڰ/,497826562,129871875,499148437,131100000,36.08.02.290,138.17.37.539
10200,ڰ/,497826562,129871875,499148437,131100000,36.07.14.865,138.23.55.479
10200,ڰ/,497826562,129871875,499148437,131100000,36.05.50.413,138.34.07.402
10200,ڰ/,497826562,129871875,499148437,131100000,36.10.30.210,138.17.19.428
10200,ڰ/,497826562,129871875,499148437,131100000,36.10.11.424,138.37.29.240
10200,ڰ/,497826562,129871875,499148437,131100000,36.12.05.170,138.37.41.418
10200,ڰ/,497826562,129871875,499148437,131100000,36.17.27.476,138.37.17.765
10200,ڰ/,497826562,129871875,499148437,131100000,36.22.13.559,138.23.55.260
10300,/ʿ,497025000,130528125,498445312,131587500,36.16.04.230,138.05.39.400
10300,/ʿ,497025000,130528125,498445312,131587500,36.20.43.119,138.22.39.774
10300,/ʿ,497025000,130528125,498445312,131587500,36.31.41.092,138.24.31.241
10300,/ʿ,497025000,130528125,498445312,131587500,36.19.53.094,138.18.52.331
10300,/ʿ,497025000,130528125,498445312,131587500,36.20.28.911,138.21.17.960
10300,/ʿ,497025000,130528125,498445312,131587500,36.22.19.072,138.23.28.519
10300,/ʿ,497025000,130528125,498445312,131587500,36.25.35.671,138.08.59.863
10300,/ʿ,497025000,130528125,498445312,131587500,36.30.45.641,138.13.45.950
10400,Ĺ,496462500,131034375,498389062,132281250,36.25.45.939,138.02.57.811
10400,Ĺ,496462500,131034375,498389062,132281250,36.40.04.993,138.06.36.176
10400,Ĺ,496462500,131034375,498389062,132281250,36.30.58.954,138.15.10.332
10400,Ĺ,496462500,131034375,498389062,132281250,36.42.31.515,138.07.08.768
10400,Ĺ,496462500,131034375,498389062,132281250,36.27.25.381,137.59.06.650
10400,Ĺ,496462500,131034375,498389062,132281250,36.38.38.727,137.54.38.344
10400,Ĺ,496462500,131034375,498389062,132281250,36.39.02.606,137.54.40.977
10400,Ĺ,496462500,131034375,498389062,132281250,36.25.00.659,138.10.09.707
10400,Ĺ,496462500,131034375,498389062,132281250,36.30.49.063,138.13.58.602
10400,Ĺ,496462500,131034375,498389062,132281250,36.38.47.588,138.21.06.598
10400,Ĺ,496462500,131034375,498389062,132281250,36.43.19.947,138.15.16.854
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.39.27.283,138.03.50.992
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.40.23.508,137.57.20.022
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.53.45.920,138.01.36.205
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.40.11.782,137.56.16.341
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.41.18.897,138.06.07.335
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.44.19.941,138.09.00.275
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.54.47.166,138.01.54.352
10500,ͱ/̯,496476562,131925000,497910937,133087500,36.56.19.372,138.14.21.705
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,36.41.54.685,138.30.07.299
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,36.39.05.473,138.30.33.865
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,36.53.09.075,138.18.22.124
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,37.00.40.342,138.31.31.803
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,37.00.44.093,138.32.31.795
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,36.37.43.322,138.27.20.334
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,36.40.59.934,138.21.03.158
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,36.46.22.947,138.18.41.740
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,36.54.45.518,138.20.47.977
10600,ֲ⸶/ӻ,497812500,131793750,499303125,133275000,37.00.57.956,138.30.41.118
10700,/Ȭ,497460937,128671875,499457812,130134375,35.51.18.062,138.22.36.711
10700,/Ȭ,497460937,128671875,499457812,130134375,36.01.54.693,138.21.38.804
10700,/Ȭ,497460937,128671875,499457812,130134375,36.02.33.606,138.21.36.413
10700,/Ȭ,497460937,128671875,499457812,130134375,36.00.01.180,138.38.30.998
10700,/Ȭ,497460937,128671875,499457812,130134375,35.51.00.651,138.25.21.981
10700,/Ȭ,497460937,128671875,499457812,130134375,36.00.07.131,138.39.54.073
10700,/Ȭ,497460937,128671875,499457812,130134375,36.08.09.106,138.28.19.733
10700,/Ȭ,497460937,128671875,499457812,130134375,35.45.38.874,138.18.18.833
10700,/Ȭ,497460937,128671875,499457812,130134375,35.51.47.088,138.14.03.031
10700,/Ȭ,497460937,128671875,499457812,130134375,35.51.23.487,138.25.55.128
10700,/Ȭ,497460937,128671875,499457812,130134375,35.53.24.139,138.36.52.145
10700,/Ȭ,497460937,128671875,499457812,130134375,35.54.54.197,138.36.26.747
10700,/Ȭ,497460937,128671875,499457812,130134375,35.53.31.854,138.40.51.799
10700,/Ȭ,497460937,128671875,499457812,130134375,35.59.39.139,138.40.55.346
10700,/Ȭ,497460937,128671875,499457812,130134375,36.00.14.280,138.21.51.691
10700,/Ȭ,497460937,128671875,499457812,130134375,36.03.14.515,138.38.31.372
10800,ˬ,496771875,128793750,498150000,130734375,36.06.16.017,138.02.04.206
10800,ˬ,496771875,128793750,498150000,130734375,35.50.26.692,138.12.19.560
10800,ˬ,496771875,128793750,498150000,130734375,36.00.23.477,138.00.58.403
10800,ˬ,496771875,128793750,498150000,130734375,36.03.30.197,138.19.46.626
10800,ˬ,496771875,128793750,498150000,130734375,35.47.27.443,138.10.45.253
10800,ˬ,496771875,128793750,498150000,130734375,35.53.41.712,138.18.51.367
10800,ˬ,496771875,128793750,498150000,130734375,35.59.15.720,138.03.09.466
10800,ˬ,496771875,128793750,498150000,130734375,35.56.54.504,138.21.14.729
10800,ˬ,496771875,128793750,498150000,130734375,36.00.25.272,138.00.49.301
10800,ˬ,496771875,128793750,498150000,130734375,36.06.19.255,138.13.31.305
10800,ˬ,496771875,128793750,498150000,130734375,36.08.55.504,138.17.01.984
10900,,495801562,129675000,497868750,131362500,36.05.44.549,137.45.07.005
10900,,495801562,129675000,497868750,131362500,36.07.30.994,137.46.06.304
10900,,495801562,129675000,497868750,131362500,36.05.04.905,138.00.06.252
10900,,495801562,129675000,497868750,131362500,36.07.50.971,137.45.40.161
10900,,495801562,129675000,497868750,131362500,36.06.40.921,138.12.51.033
10900,,495801562,129675000,497868750,131362500,36.10.26.698,138.15.57.005
10900,,495801562,129675000,497868750,131362500,36.04.21.674,137.47.23.047
10900,,495801562,129675000,497868750,131362500,36.08.18.269,137.45.46.550
10900,,495801562,129675000,497868750,131362500,36.08.55.421,137.46.16.279
10900,,495801562,129675000,497868750,131362500,36.11.51.213,137.47.28.872
10900,,495801562,129675000,497868750,131362500,36.19.25.691,137.44.09.755
10900,,495801562,129675000,497868750,131362500,36.18.32.823,137.52.05.940
10900,,495801562,129675000,497868750,131362500,36.20.47.883,137.54.15.686
10900,,495801562,129675000,497868750,131362500,36.28.04.883,137.55.38.578
10900,,495801562,129675000,497868750,131362500,36.08.41.236,138.08.45.932
10900,,495801562,129675000,497868750,131362500,36.16.20.088,138.04.25.569
11000,/,495182812,129618750,496110937,130912500,36.15.44.222,137.47.03.965
11000,/,495182812,129618750,496110937,130912500,36.16.58.209,137.43.17.571
11000,/,495182812,129618750,496110937,130912500,36.01.28.306,137.36.03.047
11000,/,495182812,129618750,496110937,130912500,36.00.29.162,137.40.55.342
11000,/,495182812,129618750,496110937,130912500,36.09.45.613,137.47.02.899
11000,/,495182812,129618750,496110937,130912500,36.10.54.781,137.35.26.935
11000,/,495182812,129618750,496110937,130912500,36.15.50.108,137.37.24.098
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.18.47.373,137.48.47.224
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.27.34.663,137.54.29.352
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.35.44.383,137.45.12.318
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.23.15.523,137.35.50.052
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.44.26.527,137.45.29.516
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.19.37.814,137.45.50.638
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.22.05.014,137.53.46.280
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.25.27.501,137.55.00.037
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.33.05.946,137.54.56.056
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.37.33.250,137.55.00.417
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.45.03.426,137.45.25.603
11100,/َ̎̎ߎ,495309375,130706250,496926562,132890625,36.54.15.629,137.52.23.555
11200,/ŷε,495168750,126693750,497643750,129806250,35.30.05.966,137.41.24.289
11200,/ŷε,495168750,126693750,497643750,129806250,35.55.01.345,138.00.06.489
11200,/ŷε,495168750,126693750,497643750,129806250,35.13.12.730,137.44.05.374
11200,/ŷε,495168750,126693750,497643750,129806250,35.35.42.721,137.44.04.810
11200,/ŷε,495168750,126693750,497643750,129806250,35.45.41.111,138.11.28.072
11200,/ŷε,495168750,126693750,497643750,129806250,35.12.13.282,137.46.55.592
11200,/ŷε,495168750,126693750,497643750,129806250,35.21.40.225,137.36.16.391
11200,/ŷε,495168750,126693750,497643750,129806250,35.55.21.981,137.51.14.748
11200,/ŷε,495168750,126693750,497643750,129806250,35.42.34.729,138.10.31.513
11200,/ŷε,495168750,126693750,497643750,129806250,36.00.05.766,138.00.32.473
11200,/ŷε,495168750,126693750,497643750,129806250,35.13.12.418,137.39.33.645
11200,/ŷε,495168750,126693750,497643750,129806250,35.13.01.619,137.51.55.554
11200,/ŷε,495168750,126693750,497643750,129806250,35.19.39.404,138.02.08.197
11200,/ŷε,495168750,126693750,497643750,129806250,35.36.57.442,137.45.26.758
11200,/ŷε,495168750,126693750,497643750,129806250,35.42.48.013,137.49.08.438
11200,/ŷε,495168750,126693750,497643750,129806250,35.54.49.361,137.51.26.774
11200,/ŷε,495168750,126693750,497643750,129806250,35.55.49.912,137.50.02.182
11200,/ŷε,495168750,126693750,497643750,129806250,35.26.29.720,138.07.11.740
11200,/ŷε,495168750,126693750,497643750,129806250,35.27.53.650,138.09.28.556
11200,/ŷε,495168750,126693750,497643750,129806250,35.32.51.479,138.08.44.674
11200,/ŷε,495168750,126693750,497643750,129806250,35.41.10.681,138.11.20.367
11200,/ŷε,495168750,126693750,497643750,129806250,35.57.30.474,138.05.46.637
11300,,494367187,127818750,496448437,129890625,35.38.47.387,137.33.00.327
11300,,494367187,127818750,496448437,129890625,35.31.20.131,137.33.30.115
11300,,494367187,127818750,496448437,129890625,35.36.03.197,137.31.06.119
11300,,494367187,127818750,496448437,129890625,35.35.07.260,137.42.49.836
11300,,494367187,127818750,496448437,129890625,35.49.46.564,137.20.17.447
11300,,494367187,127818750,496448437,129890625,36.00.39.966,137.37.42.660
11300,,494367187,127818750,496448437,129890625,35.32.03.916,137.32.16.416
11300,,494367187,127818750,496448437,129890625,35.31.31.190,137.35.22.454
11300,,494367187,127818750,496448437,129890625,35.34.52.538,137.42.54.768
11300,,494367187,127818750,496448437,129890625,35.42.42.628,137.48.50.384
11300,,494367187,127818750,496448437,129890625,35.47.41.718,137.21.25.522
11300,,494367187,127818750,496448437,129890625,35.50.20.630,137.21.31.132
11300,,494367187,127818750,496448437,129890625,35.53.04.487,137.50.45.585
11300,,494367187,127818750,496448437,129890625,36.00.25.774,137.41.10.521
11400,/ģ,492693750,126628125,492876562,126834375,35.12.25.705,136.52.36.377
11401,,492848437,126600000,492904687,126628125,35.10.06.779,136.54.34.545
11402,,492848437,126571875,492904687,126600000,35.09.33.588,136.55.03.876
11403,,492904687,126571875,492960937,126637500,35.10.00.878,136.55.20.625
11404,,492820312,126571875,492848437,126628125,35.10.05.503,136.53.44.242
11405,//⻳,492820312,126487500,492904687,126571875,35.08.33.652,136.54.24.095
11406,,492876562,126618750,493087500,126703125,35.10.27.402,136.55.53.320
11407,̶,492820312,126656250,493003125,126862500,35.11.01.018,136.54.20.534
11408,̾Ų,492735937,126553125,492820312,126703125,35.09.39.464,136.53.36.090
11409,¼,492595312,126515625,492778125,126675000,35.10.08.594,136.50.30.060
11410,,492482812,126403125,492834375,126590625,35.08.02.123,136.53.07.108
11411,,492454687,126103125,492890625,126440625,35.05.05.171,136.49.23.545
11412,Ǯ,492792187,126393750,492918750,126496875,35.07.45.037,136.55.01.584
11413,,492848437,126234375,493031250,126412500,35.04.16.048,136.56.25.482
11414,ж,492904687,126140625,493298437,126384375,35.06.04.489,137.00.51.267
11415,,493087500,126431250,493157812,126534375,35.07.17.346,136.58.25.283
11416,/,493031250,126356250,493242187,126525000,35.06.40.364,136.57.59.537
11417,ʿ/,493171875,126356250,493284375,126450000,35.06.13.576,137.00.22.410
11418,,492904687,126421875,493059375,126478125,35.07.31.122,136.56.54.996
11419,,492904687,126393750,493031250,126440625,35.07.08.016,136.55.15.347
11420,,492890625,126496875,492975000,126571875,35.09.27.385,136.55.14.163
11421,,492946875,126506250,493045312,126562500,35.09.12.540,136.56.25.993
11422,۵,493017187,126487500,493087500,126562500,35.09.14.377,136.57.27.678
11423,,492989062,126478125,493045312,126506250,35.08.00.060,136.57.03.834
11424,Ȭ,493031250,126393750,493115625,126534375,35.07.53.207,136.57.46.470
11425,,492904687,126478125,492989062,126515625,35.08.14.048,136.55.07.094
11426,/,492932812,126553125,493003125,126637500,35.09.45.039,136.55.49.633
11427,Ӳ/в,492989062,126553125,493059375,126646875,35.09.23.332,136.57.15.621
11428,ܻ,493045312,126534375,493129687,126675000,35.10.49.044,136.57.36.576
11429,컳/,493101562,126525000,493185937,126684375,35.09.09.490,136.58.43.119
11430,/,493171875,126562500,493270312,126628125,35.09.55.466,136.59.37.249
11431,ܶ/ƣ,493157812,126487500,493312500,126693750,35.09.36.480,137.01.21.981
11432,黳,492960937,126675000,493425000,126918750,35.11.27.139,137.02.02.807
11500,쳤///η,492665625,125878125,493565625,126684375,35.02.56.623,136.58.47.464
11500,쳤///η,492665625,125878125,493565625,126684375,34.59.56.421,136.58.44.752
11500,쳤///η,492665625,125878125,493565625,126684375,35.01.47.856,136.51.51.500
11500,쳤///η,492665625,125878125,493565625,126684375,35.05.05.265,137.03.26.151
11600,//,492032812,125981250,492960937,127321875,35.09.27.670,136.46.56.538
11600,//,492032812,125981250,492960937,127321875,35.06.36.442,136.46.56.634
11600,//,492032812,125981250,492960937,127321875,35.00.43.293,136.48.54.385
11600,//,492032812,125981250,492960937,127321875,35.05.06.955,136.48.49.773
11600,//,492032812,125981250,492960937,127321875,35.12.12.784,136.52.19.465
11600,//,492032812,125981250,492960937,127321875,35.15.30.281,136.52.51.933
11700,Լ,491090625,125625000,492145312,126318750,34.59.09.105,136.26.51.705
11700,Լ,491090625,125625000,492145312,126318750,34.56.00.970,136.38.59.194
11700,Լ,491090625,125625000,492145312,126318750,34.58.49.391,136.40.28.695
11700,Լ,491090625,125625000,492145312,126318750,35.00.26.768,136.41.56.231
11700,Լ,491090625,125625000,492145312,126318750,34.57.31.365,136.39.04.263
11701,̾,491076562,126056250,492384375,126918750,35.01.36.536,136.44.16.411
11701,̾,491076562,126056250,492384375,126918750,35.05.25.411,136.31.28.495
11701,̾,491076562,126056250,492384375,126918750,35.14.46.316,136.31.35.089
11701,̾,491076562,126056250,492384375,126918750,35.05.11.357,136.28.23.740
11701,̾,491076562,126056250,492384375,126918750,35.12.49.663,136.26.19.988
11702,뼯/,490556250,125268750,491920312,125943750,34.55.42.174,136.30.11.346
11702,뼯/,490556250,125268750,491920312,125943750,34.48.52.831,136.16.28.709
11702,뼯/,490556250,125268750,491920312,125943750,34.49.12.276,136.19.18.897
11702,뼯/,490556250,125268750,491920312,125943750,34.49.09.832,136.26.52.876
11702,뼯/,490556250,125268750,491920312,125943750,34.50.24.198,136.36.15.485
11702,뼯/,490556250,125268750,491920312,125943750,34.48.36.529,136.34.46.590
11702,뼯/,490556250,125268750,491920312,125943750,34.58.03.428,136.24.19.975
11800,///,492609375,126637500,493889062,127518750,35.21.18.628,136.51.38.211
11800,///,492609375,126637500,493889062,127518750,35.21.18.526,137.00.12.210
11800,///,492609375,126637500,493889062,127518750,35.19.48.589,137.03.53.777
11800,///,492609375,126637500,493889062,127518750,35.15.33.020,136.54.13.813
11800,///,492609375,126637500,493889062,127518750,35.14.14.344,137.10.52.230
11800,///,492609375,126637500,493889062,127518750,35.24.14.625,136.59.01.468
11900,ǻ,493368750,126787500,495478125,128868750,35.14.26.980,137.23.28.596
11900,ǻ,493368750,126787500,495478125,128868750,35.18.45.683,137.04.51.197
11900,ǻ,493368750,126787500,495478125,128868750,35.28.08.267,137.35.45.481
11900,ǻ,493368750,126787500,495478125,128868750,35.17.19.728,137.17.24.822
11900,ǻ,493368750,126787500,495478125,128868750,35.17.13.062,137.32.59.350
11900,ǻ,493368750,126787500,495478125,128868750,35.27.11.793,137.12.22.177
11900,ǻ,493368750,126787500,495478125,128868750,35.39.05.712,137.24.59.651
11900,ǻ,493368750,126787500,495478125,128868750,35.44.44.187,137.20.11.761
11900,ǻ,493368750,126787500,495478125,128868750,35.16.51.593,137.09.12.664
11900,ǻ,493368750,126787500,495478125,128868750,35.16.25.745,137.19.58.869
11900,ǻ,493368750,126787500,495478125,128868750,35.19.07.356,137.34.54.407
11900,ǻ,493368750,126787500,495478125,128868750,35.22.37.382,137.07.20.694
11900,ǻ,493368750,126787500,495478125,128868750,35.27.51.139,137.12.32.108
11900,ǻ,493368750,126787500,495478125,128868750,35.27.45.525,137.36.35.677
11900,ǻ,493368750,126787500,495478125,128868750,35.33.33.065,137.21.01.619
11900,ǻ,493368750,126787500,495478125,128868750,35.41.08.022,137.22.00.914
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.56.22.240,136.59.11.500
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.45.27.225,136.55.26.524
12000,¿Ⱦ,492525000,124743750,494296875,126028125,35.00.05.670,136.51.13.227
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.42.54.820,137.02.55.298
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.48.30.935,137.14.44.078
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.50.01.821,137.07.34.899
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.51.00.570,137.12.45.305
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.46.27.436,136.50.59.366
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.48.24.145,136.59.47.957
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.50.51.177,136.51.50.300
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.51.32.920,136.56.31.179
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.51.20.898,136.56.59.780
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.40.42.743,137.00.18.569
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.46.17.866,137.10.44.282
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.48.05.850,137.15.06.032
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.50.03.184,137.07.06.559
12000,¿Ⱦ,492525000,124743750,494296875,126028125,34.53.48.934,137.03.57.353
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,35.13.50.955,137.13.20.055
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,35.15.00.487,137.16.08.847
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,34.49.45.931,137.11.26.755
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,34.53.12.912,137.04.19.762
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,34.53.32.480,137.07.32.939
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,35.10.05.660,137.06.07.037
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,34.49.17.081,137.11.13.739
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,34.53.17.538,137.05.32.013
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,34.50.49.632,137.11.55.766
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,34.54.19.438,137.24.33.009
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,35.04.14.924,137.26.53.440
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,35.06.27.270,137.05.29.795
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,35.07.58.661,137.27.51.470
12100,˭/¾/ë/,493129687,125325000,494915625,127031250,35.14.58.838,137.22.59.067
12200,˭//,493256250,124462500,496195312,127021875,34.37.32.592,137.11.18.529
12200,˭//,493256250,124462500,496195312,127021875,34.52.32.813,137.26.28.084
12200,˭//,493256250,124462500,496195312,127021875,35.10.04.398,137.45.03.155
12200,˭//,493256250,124462500,496195312,127021875,35.02.31.051,137.26.26.765
12200,˭//,493256250,124462500,496195312,127021875,34.38.33.808,137.05.41.713
12200,˭//,493256250,124462500,496195312,127021875,34.37.11.875,137.15.12.824
12200,˭//,493256250,124462500,496195312,127021875,34.45.02.095,137.19.16.456
12200,˭//,493256250,124462500,496195312,127021875,34.53.52.789,137.24.59.934
12200,˭//,493256250,124462500,496195312,127021875,34.51.02.192,137.34.22.400
12200,˭//,493256250,124462500,496195312,127021875,35.00.44.985,137.25.47.765
12200,˭//,493256250,124462500,496195312,127021875,35.16.23.289,137.32.50.795
12200,˭//,493256250,124462500,496195312,127021875,35.16.37.774,137.33.25.412
12200,˭//,493256250,124462500,496195312,127021875,34.39.50.047,137.11.05.743
12200,˭//,493256250,124462500,496195312,127021875,34.38.59.213,137.22.47.748
12200,˭//,493256250,124462500,496195312,127021875,34.41.51.563,137.29.38.317
12200,˭//,493256250,124462500,496195312,127021875,34.49.30.170,137.30.11.750
12200,˭//,493256250,124462500,496195312,127021875,34.50.34.147,137.32.02.910
12200,˭//,493256250,124462500,496195312,127021875,34.56.48.309,137.40.29.440
12200,˭//,493256250,124462500,496195312,127021875,35.00.54.934,137.42.36.243
12200,˭//,493256250,124462500,496195312,127021875,35.06.51.443,137.27.08.231
12200,˭//,493256250,124462500,496195312,127021875,35.11.38.503,137.35.31.111
12200,˭//,493256250,124462500,496195312,127021875,35.13.08.591,137.34.14.531
12200,˭//,493256250,124462500,496195312,127021875,35.11.00.400,137.48.28.743
12300,;/̾,494915625,124706250,496195312,125887500,34.44.25.727,137.47.56.367
12300,;/̾,494915625,124706250,496195312,125887500,34.40.23.628,137.31.59.784
12300,;/̾,494915625,124706250,496195312,125887500,34.40.25.632,137.47.03.444
12300,;/̾,494915625,124706250,496195312,125887500,34.49.08.055,137.30.33.094
12300,;/̾,494915625,124706250,496195312,125887500,34.40.11.048,137.29.48.386
12300,;/̾,494915625,124706250,496195312,125887500,34.40.10.710,137.38.44.770
12300,;/̾,494915625,124706250,496195312,125887500,34.52.12.840,137.36.44.838
12301,ŷε/̱,495731250,125418750,497010937,127078125,35.10.04.452,137.50.48.855
12301,ŷε/̱,495731250,125418750,497010937,127078125,34.55.44.187,137.54.32.016
12301,ŷε/̱,495731250,125418750,497010937,127078125,34.55.41.421,137.42.45.360
12301,ŷε/̱,495731250,125418750,497010937,127078125,34.59.47.575,137.42.14.928
12301,ŷε/̱,495731250,125418750,497010937,127078125,34.55.58.187,137.55.21.298
12301,ŷε/̱,495731250,125418750,497010937,127078125,35.12.38.414,137.53.07.534
12301,ŷε/̱,495731250,125418750,497010937,127078125,34.51.12.388,137.48.46.785
12301,ŷε/̱,495731250,125418750,497010937,127078125,34.56.31.714,137.56.01.904
12301,ŷε/̱,495731250,125418750,497010937,127078125,35.12.56.136,137.52.13.657
12301,ŷε/̱,495731250,125418750,497010937,127078125,35.07.36.591,138.00.35.157
12400,,491442187,126862500,493073437,128896875,35.18.15.625,136.40.31.728
12400,,491442187,126862500,493073437,128896875,35.38.47.880,136.45.57.485
12400,,491442187,126862500,493073437,128896875,35.15.04.839,136.40.01.270
12400,,491442187,126862500,493073437,128896875,35.21.20.611,136.45.08.556
12400,,491442187,126862500,493073437,128896875,35.23.31.370,136.56.17.380
12400,,491442187,126862500,493073437,128896875,35.29.12.425,136.39.52.426
12400,,491442187,126862500,493073437,128896875,35.30.39.505,136.50.10.822
12400,,491442187,126862500,493073437,128896875,35.36.34.325,136.34.22.484
12400,,491442187,126862500,493073437,128896875,35.14.38.397,136.40.48.044
12400,,491442187,126862500,493073437,128896875,35.20.05.811,136.38.44.035
12400,,491442187,126862500,493073437,128896875,35.25.52.107,136.38.21.535
12400,,491442187,126862500,493073437,128896875,35.34.12.400,136.37.56.026
12400,,491442187,126862500,493073437,128896875,35.44.24.405,136.32.14.426
12401,ǻ,490598437,126468750,492075000,128859375,35.17.34.633,136.33.48.428
12401,ǻ,490598437,126468750,492075000,128859375,35.10.01.218,136.36.45.345
12401,ǻ,490598437,126468750,492075000,128859375,35.33.10.845,136.22.31.929
12401,ǻ,490598437,126468750,492075000,128859375,35.36.23.801,136.19.43.111
12401,ǻ,490598437,126468750,492075000,128859375,35.09.24.635,136.38.38.204
12401,ǻ,490598437,126468750,492075000,128859375,35.21.19.656,136.25.03.958
12401,ǻ,490598437,126468750,492075000,128859375,35.32.56.951,136.38.01.466
12401,ǻ,490598437,126468750,492075000,128859375,35.42.36.678,136.19.24.001
12401,ǻ,490598437,126468750,492075000,128859375,35.13.03.375,136.26.45.426
12401,ǻ,490598437,126468750,492075000,128859375,35.13.28.070,136.40.55.788
12401,ǻ,490598437,126468750,492075000,128859375,35.20.34.736,136.25.10.546
12401,ǻ,490598437,126468750,492075000,128859375,35.26.00.606,136.25.18.005
12401,ǻ,490598437,126468750,492075000,128859375,35.28.06.101,136.39.00.649
12401,ǻ,490598437,126468750,492075000,128859375,35.28.48.884,136.39.26.370
12401,ǻ,490598437,126468750,492075000,128859375,35.34.06.190,136.37.30.847
12401,ǻ,490598437,126468750,492075000,128859375,35.34.05.354,136.38.11.170
12401,ǻ,490598437,126468750,492075000,128859375,35.42.16.644,136.32.00.582
12500,ǻ,492004687,127303125,494690625,129834375,35.25.45.966,136.56.20.443
12500,ǻ,492004687,127303125,494690625,129834375,35.23.13.799,137.05.42.980
12500,ǻ,492004687,127303125,494690625,129834375,36.02.35.826,136.45.10.060
12500,ǻ,492004687,127303125,494690625,129834375,35.26.41.076,136.54.34.354
12500,ǻ,492004687,127303125,494690625,129834375,35.33.16.103,136.49.25.087
12500,ǻ,492004687,127303125,494690625,129834375,35.40.46.184,136.46.31.249
12500,ǻ,492004687,127303125,494690625,129834375,35.59.23.862,136.43.47.653
12500,ǻ,492004687,127303125,494690625,129834375,35.32.55.322,137.20.19.857
12500,ǻ,492004687,127303125,494690625,129834375,35.54.43.052,137.05.44.367
12500,ǻ,492004687,127303125,494690625,129834375,35.50.59.148,137.08.30.637
12500,ǻ,492004687,127303125,494690625,129834375,35.29.53.263,136.50.56.737
12500,ǻ,492004687,127303125,494690625,129834375,35.25.44.871,136.56.07.416
12500,ǻ,492004687,127303125,494690625,129834375,35.41.16.025,136.44.22.266
12500,ǻ,492004687,127303125,494690625,129834375,35.50.56.979,136.49.59.070
12500,ǻ,492004687,127303125,494690625,129834375,35.56.50.301,136.46.49.224
12500,ǻ,492004687,127303125,494690625,129834375,35.23.22.820,137.00.06.823
12500,ǻ,492004687,127303125,494690625,129834375,35.29.35.826,137.16.11.091
12500,ǻ,492004687,127303125,494690625,129834375,35.31.57.583,137.19.00.709
12500,ǻ,492004687,127303125,494690625,129834375,35.32.04.049,137.18.54.596
12500,ǻ,492004687,127303125,494690625,129834375,35.37.11.772,137.05.48.524
12500,ǻ,492004687,127303125,494690625,129834375,35.40.21.908,137.12.43.150
12500,ǻ,492004687,127303125,494690625,129834375,35.53.53.831,137.07.47.549
12500,ǻ,492004687,127303125,494690625,129834375,35.56.38.500,137.00.43.338
12600,,492314062,128221875,495548437,131268750,35.56.18.293,137.05.39.347
12600,,492314062,128221875,495548437,131268750,35.58.53.451,137.30.04.596
12600,,492314062,128221875,495548437,131268750,35.38.08.373,137.06.34.703
12600,,492314062,128221875,495548437,131268750,35.53.08.167,137.20.41.517
12600,,492314062,128221875,495548437,131268750,36.01.55.302,136.53.28.335
12600,,492314062,128221875,495548437,131268750,36.13.10.356,137.33.49.995
12600,,492314062,128221875,495548437,131268750,36.23.09.307,137.06.35.411
12600,,492314062,128221875,495548437,131268750,35.37.54.953,137.09.05.920
12600,,492314062,128221875,495548437,131268750,35.41.58.846,137.17.56.434
12600,,492314062,128221875,495548437,131268750,35.46.41.802,137.20.44.665
12600,,492314062,128221875,495548437,131268750,35.53.27.094,137.27.50.791
12600,,492314062,128221875,495548437,131268750,35.56.35.871,137.30.34.937
12600,,492314062,128221875,495548437,131268750,36.07.33.114,136.47.23.305
12600,,492314062,128221875,495548437,131268750,36.02.56.759,137.35.45.449
12600,,492314062,128221875,495548437,131268750,36.06.18.013,137.11.15.713
12600,,492314062,128221875,495548437,131268750,36.12.50.862,137.33.50.582
12600,,492314062,128221875,495548437,131268750,36.14.42.152,137.35.40.371
12600,,492314062,128221875,495548437,131268750,36.24.26.887,137.26.17.095
12600,,492314062,128221875,495548437,131268750,36.26.58.428,137.11.27.964
12600,,492314062,128221875,495548437,131268750,35.38.03.993,137.09.34.753
12600,,492314062,128221875,495548437,131268750,35.40.29.876,137.05.38.388
12600,,492314062,128221875,495548437,131268750,35.44.12.016,137.07.50.894
12600,,492314062,128221875,495548437,131268750,35.52.12.524,137.09.14.388
12600,,492314062,128221875,495548437,131268750,35.53.30.244,137.28.17.920
12600,,492314062,128221875,495548437,131268750,35.57.15.218,137.01.04.021
12600,,492314062,128221875,495548437,131268750,36.00.26.367,136.51.11.373
12600,,492314062,128221875,495548437,131268750,36.13.47.651,136.50.56.494
12600,,492314062,128221875,495548437,131268750,36.18.27.098,136.58.19.462
12600,,492314062,128221875,495548437,131268750,36.21.20.181,136.54.23.713
12600,,492314062,128221875,495548437,131268750,36.02.05.195,137.35.39.350
12600,,492314062,128221875,495548437,131268750,36.06.03.236,137.20.33.978
12600,,492314062,128221875,495548437,131268750,36.08.59.062,137.20.22.175
12600,,492314062,128221875,495548437,131268750,36.07.55.216,137.25.55.139
12600,,492314062,128221875,495548437,131268750,36.14.26.560,137.35.40.073
12600,,492314062,128221875,495548437,131268750,36.20.26.363,137.03.06.001
12600,,492314062,128221875,495548437,131268750,36.26.54.491,137.11.50.304
12601,⻳,493748437,129909375,494817187,130275000,36.08.53.414,137.13.13.493
12601,⻳,493748437,129909375,494817187,130275000,36.09.31.281,137.12.49.246
12601,⻳,493748437,129909375,494817187,130275000,36.09.26.316,137.09.16.390
12601,⻳,493748437,129909375,494817187,130275000,36.08.01.774,137.25.42.782
12700,/,489445312,128362500,491273437,129806250,35.41.55.455,136.16.57.024
12700,/,489445312,128362500,491273437,129806250,35.51.55.122,136.01.01.943
12700,/,489445312,128362500,491273437,129806250,35.41.58.964,136.09.06.101
12700,/,489445312,128362500,491273437,129806250,35.50.24.548,136.03.22.824
12700,/,489445312,128362500,491273437,129806250,35.55.46.405,136.19.48.988
12700,/,489445312,128362500,491273437,129806250,36.00.01.375,136.02.59.925
12700,/,489445312,128362500,491273437,129806250,35.54.12.194,135.59.47.310
12700,/,489445312,128362500,491273437,129806250,35.58.44.220,135.57.28.328
12700,/,489445312,128362500,491273437,129806250,35.41.26.731,136.10.16.155
12700,/,489445312,128362500,491273437,129806250,35.46.49.277,136.06.01.579
12700,/,489445312,128362500,491273437,129806250,35.50.14.303,136.03.01.986
12700,/,489445312,128362500,491273437,129806250,35.56.45.695,136.20.17.038
12700,/,489445312,128362500,491273437,129806250,35.56.32.334,136.21.23.386
12800,ʡ,489670312,129459375,491203125,130659375,35.59.26.560,136.13.10.969
12800,ʡ,489670312,129459375,491203125,130659375,36.06.52.978,136.20.43.236
12800,ʡ,489670312,129459375,491203125,130659375,36.09.48.395,136.06.17.871
12800,ʡ,489670312,129459375,491203125,130659375,36.12.01.308,136.07.42.272
12800,ʡ,489670312,129459375,491203125,130659375,36.14.10.651,136.18.52.960
12800,ʡ,489670312,129459375,491203125,130659375,35.58.24.741,136.16.49.827
12800,ʡ,489670312,129459375,491203125,130659375,36.00.51.954,136.05.57.477
12800,ʡ,489670312,129459375,491203125,130659375,36.02.40.192,136.19.20.864
12800,ʡ,489670312,129459375,491203125,130659375,36.11.44.133,136.06.49.789
12800,ʡ,489670312,129459375,491203125,130659375,36.11.21.031,136.07.50.130
12900,ʿ/,490725000,128709375,492595312,130171875,35.54.25.474,136.47.01.787
12900,ʿ/,490725000,128709375,492595312,130171875,35.47.50.587,136.42.40.224
12900,ʿ/,490725000,128709375,492595312,130171875,35.51.57.230,136.26.50.979
12900,ʿ/,490725000,128709375,492595312,130171875,36.00.02.718,136.43.14.629
12900,ʿ/,490725000,128709375,492595312,130171875,35.46.08.438,136.30.33.818
12900,ʿ/,490725000,128709375,492595312,130171875,35.51.29.412,136.26.11.517
12900,ʿ/,490725000,128709375,492595312,130171875,35.57.49.340,136.20.08.475
12900,ʿ/,490725000,128709375,492595312,130171875,36.01.05.012,136.19.12.242
12900,ʿ/,490725000,128709375,492595312,130171875,36.04.44.337,136.18.56.509
12900,ʿ/,490725000,128709375,492595312,130171875,36.07.16.957,136.22.12.464
13000,,490485937,130087500,491892187,131296875,36.14.30.208,136.19.44.983
13000,,490485937,130087500,491892187,131296875,36.10.22.322,136.24.05.942
13000,,490485937,130087500,491892187,131296875,36.18.09.495,136.15.57.784
13000,,490485937,130087500,491892187,131296875,36.20.43.428,136.19.17.870
13000,,490485937,130087500,491892187,131296875,36.22.32.029,136.34.42.494
13000,,490485937,130087500,491892187,131296875,36.10.12.349,136.22.43.091
13000,,490485937,130087500,491892187,131296875,36.18.38.776,136.16.17.241
13000,,490485937,130087500,491892187,131296875,36.22.18.981,136.21.50.902
13101,//,491667187,131625000,492525000,132121875,36.37.33.681,136.41.19.232
13101,//,491667187,131625000,492525000,132121875,36.41.58.130,136.40.11.544
13102,/¢/컳,491821875,131625000,492075000,131775000,36.34.25.008,136.38.02.066
13103,Į/˷,491934375,131587500,491990625,131625000,36.33.33.355,136.39.02.321
13104,ϻ/Ω/Τ/Ͱ,491990625,131250000,492567187,131625000,36.32.02.930,136.48.46.930
13105,/Į/ͭ,491554687,130800000,492525000,131700000,36.26.03.960,136.39.29.975
13105,/Į/ͭ,491554687,130800000,492525000,131700000,36.24.47.951,136.46.53.634
13106,/Ǥ,491287500,131240625,491850000,131587500,36.28.12.129,136.31.56.218
13106,/Ǥ,491287500,131240625,491850000,131587500,36.29.45.839,136.36.08.355
13200,/,491596875,129843750,492693750,131371875,36.23.14.537,136.36.43.728
13200,/,491596875,129843750,492693750,131371875,36.23.48.347,136.38.32.338
13200,/,491596875,129843750,492693750,131371875,36.11.04.937,136.34.24.426
13200,/,491596875,129843750,492693750,131371875,36.14.45.764,136.50.39.196
13200,/,491596875,129843750,492693750,131371875,36.26.38.769,136.37.35.549
13200,/,491596875,129843750,492693750,131371875,36.13.13.665,136.36.24.503
13200,/,491596875,129843750,492693750,131371875,36.17.33.078,136.47.55.980
13200,/,491596875,129843750,492693750,131371875,36.25.00.777,136.39.32.030
13300,,491990625,131831250,492820312,134025000,36.40.38.599,136.42.19.619
13300,,491990625,131831250,492820312,134025000,36.41.55.262,136.40.53.702
13300,,491990625,131831250,492820312,134025000,36.59.10.575,136.50.39.688
13300,,491990625,131831250,492820312,134025000,37.05.59.567,136.43.45.842
13300,,491990625,131831250,492820312,134025000,37.05.06.802,136.47.51.117
13300,,491990625,131831250,492820312,134025000,37.05.19.665,136.47.49.532
13300,,491990625,131831250,492820312,134025000,37.07.55.671,136.47.03.596
13300,,491990625,131831250,492820312,134025000,36.37.54.235,136.47.08.898
13300,,491990625,131831250,492820312,134025000,36.49.45.202,136.44.47.252
13300,,491990625,131831250,492820312,134025000,36.50.06.684,136.44.49.405
13300,,491990625,131831250,492820312,134025000,36.57.26.482,136.51.30.078
13300,,491990625,131831250,492820312,134025000,37.05.25.722,136.48.23.310
13400,,492637500,132890625,493439062,133800000,36.58.10.121,136.58.20.585
13400,,492637500,132890625,493439062,133800000,37.03.53.199,136.51.37.665
13400,,492637500,132890625,493439062,133800000,36.55.26.517,136.53.04.223
13400,,492637500,132890625,493439062,133800000,37.05.40.136,136.56.51.746
13400,,492637500,132890625,493439062,133800000,37.09.43.628,137.02.33.189
13400,,492637500,132890625,493439062,133800000,36.57.47.126,136.51.56.349
13400,,492637500,132890625,493439062,133800000,36.56.35.275,136.55.55.946
13400,,492637500,132890625,493439062,133800000,37.04.25.157,136.51.23.360
13400,,492637500,132890625,493439062,133800000,36.57.23.916,137.02.55.173
13500,ǽ,492117187,133462500,494521875,136275000,37.10.08.703,136.48.48.455
13500,ǽ,492117187,133462500,494521875,136275000,37.04.24.200,136.50.19.748
13500,ǽ,492117187,133462500,494521875,136275000,37.15.20.155,136.43.45.591
13500,ǽ,492117187,133462500,494521875,136275000,37.16.20.436,137.05.41.312
13500,ǽ,492117187,133462500,494521875,136275000,37.23.53.351,136.52.07.213
13500,ǽ,492117187,133462500,494521875,136275000,37.04.56.569,136.52.21.050
13500,ǽ,492117187,133462500,494521875,136275000,37.11.36.357,136.49.57.155
13500,ǽ,492117187,133462500,494521875,136275000,37.13.23.581,136.48.22.294
13500,ǽ,492117187,133462500,494521875,136275000,37.12.59.060,136.56.25.605
13500,ǽ,492117187,133462500,494521875,136275000,37.17.22.840,137.13.32.662
13500,ǽ,492117187,133462500,494521875,136275000,37.24.10.071,136.53.44.685
13500,ǽ,492117187,133462500,494521875,136275000,37.29.06.634,137.06.50.677
13500,ǽ,492117187,133462500,494521875,136275000,37.31.02.676,137.20.03.653
13600,Ⲭ,492609375,131906250,493860937,133068750,36.48.53.734,137.01.04.103
13600,Ⲭ,492609375,131906250,493860937,133068750,36.56.04.369,136.55.59.441
13600,Ⲭ,492609375,131906250,493860937,133068750,36.53.09.070,137.00.11.306
13600,Ⲭ,492609375,131906250,493860937,133068750,36.39.21.436,137.05.27.844
13600,Ⲭ,492609375,131906250,493860937,133068750,36.41.23.501,136.54.40.258
13600,Ⲭ,492609375,131906250,493860937,133068750,36.47.44.637,136.51.56.125
13600,Ⲭ,492609375,131906250,493860937,133068750,36.44.52.504,137.09.46.438
13700,/޲ջ,492384375,130584375,493467187,132253125,36.22.38.525,136.52.36.182
13700,/޲ջ,492384375,130584375,493467187,132253125,36.19.23.988,136.47.52.529
13700,/޲ջ,492384375,130584375,493467187,132253125,36.20.01.836,136.49.48.510
13700,/޲ջ,492384375,130584375,493467187,132253125,36.32.17.625,136.49.15.555
13700,/޲ջ,492384375,130584375,493467187,132253125,36.38.47.023,137.02.00.250
13700,/޲ջ,492384375,130584375,493467187,132253125,36.20.52.655,136.52.18.245
13700,/޲ջ,492384375,130584375,493467187,132253125,36.34.33.434,136.48.06.272
13700,/޲ջ,492384375,130584375,493467187,132253125,36.22.05.934,137.03.25.157
13700,/޲ջ,492384375,130584375,493467187,132253125,36.29.36.902,137.03.21.109
13700,/޲ջ,492384375,130584375,493467187,132253125,36.39.04.505,137.00.33.591
13800,ٻ,493354687,130940625,494845312,132478125,36.26.59.319,137.04.46.465
13800,ٻ,493354687,130940625,494845312,132478125,36.43.14.725,137.25.21.299
13800,ٻ,493354687,130940625,494845312,132478125,36.31.55.015,137.15.07.790
13800,ٻ,493354687,130940625,494845312,132478125,36.37.14.039,137.15.58.957
13800,ٻ,493354687,130940625,494845312,132478125,36.45.07.482,137.12.41.609
13800,ٻ,493354687,130940625,494845312,132478125,36.28.25.745,137.04.07.744
13800,ٻ,493354687,130940625,494845312,132478125,36.28.16.190,137.16.47.038
13800,ٻ,493354687,130940625,494845312,132478125,36.37.28.302,137.16.30.814
13800,ٻ,493354687,130940625,494845312,132478125,36.41.50.379,137.27.07.480
13900,Ω,494085937,130987500,495914062,132215625,36.27.33.531,137.22.34.866
13900,Ω,494085937,130987500,495914062,132215625,36.31.19.906,137.16.01.845
13900,Ω,494085937,130987500,495914062,132215625,36.25.06.734,137.31.31.193
13900,Ω,494085937,130987500,495914062,132215625,36.36.38.165,137.44.10.746
13900,Ω,494085937,130987500,495914062,132215625,36.38.09.235,137.41.20.706
13900,Ω,494085937,130987500,495914062,132215625,36.23.38.342,137.35.46.780
13900,Ω,494085937,130987500,495914062,132215625,36.26.08.914,137.21.10.131
13900,Ω,494085937,130987500,495914062,132215625,36.25.30.901,137.38.01.380
13900,Ω,494085937,130987500,495914062,132215625,36.30.55.682,137.40.48.544
13900,Ω,494085937,130987500,495914062,132215625,36.35.13.922,137.43.17.107
13900,Ω,494085937,130987500,495914062,132215625,36.42.00.190,137.27.26.666
14000,/,494592187,131840625,495942187,133125000,36.51.59.546,137.25.29.963
14000,/,494592187,131840625,495942187,133125000,36.43.13.979,137.30.34.137
14000,/,494592187,131840625,495942187,133125000,36.58.11.087,137.35.15.309
14000,/,494592187,131840625,495942187,133125000,36.40.53.870,137.31.27.600
14000,/,494592187,131840625,495942187,133125000,36.44.40.469,137.45.05.362
14000,/,494592187,131840625,495942187,133125000,36.50.38.851,137.24.28.501
14000,/,494592187,131840625,495942187,133125000,36.55.12.132,137.25.42.815
14100,Ż,488939062,125521875,489768750,127021875,35.03.46.501,135.52.32.292
14100,Ż,488939062,125521875,489768750,127021875,35.06.20.492,135.54.32.679
14100,Ż,488939062,125521875,489768750,127021875,35.13.08.779,135.52.38.874
14100,Ż,488939062,125521875,489768750,127021875,34.52.54.982,135.54.31.178
14100,Ż,488939062,125521875,489768750,127021875,34.59.10.583,135.50.45.215
14100,Ż,488939062,125521875,489768750,127021875,35.00.45.850,135.50.10.927
14100,Ż,488939062,125521875,489768750,127021875,35.11.38.574,135.51.36.002
14100,Ż,488939062,125521875,489768750,127021875,35.16.19.271,135.54.01.446
14100,Ż,488939062,125521875,489768750,127021875,34.55.40.495,136.02.25.773
14100,Ż,488939062,125521875,489768750,127021875,34.55.23.166,135.52.16.930
14100,Ż,488939062,125521875,489768750,127021875,34.59.31.257,135.54.46.277
14100,Ż,488939062,125521875,489768750,127021875,35.00.44.321,135.49.17.343
14100,Ż,488939062,125521875,489768750,127021875,35.11.26.943,135.52.11.881
14200,/,489262500,125231250,491231250,127078125,34.56.16.396,136.18.51.426
14200,/,489262500,125231250,491231250,127078125,35.01.18.748,136.22.32.280
14200,/,489262500,125231250,491231250,127078125,34.53.11.979,136.07.39.096
14200,/,489262500,125231250,491231250,127078125,34.55.01.588,136.03.00.400
14200,/,489262500,125231250,491231250,127078125,35.15.00.691,136.22.38.619
14200,/,489262500,125231250,491231250,127078125,34.52.35.574,135.58.45.882
14200,/,489262500,125231250,491231250,127078125,34.52.14.090,136.11.22.674
14200,/,489262500,125231250,491231250,127078125,34.57.33.608,136.02.05.740
14200,/,489262500,125231250,491231250,127078125,35.16.56.898,136.20.20.401
14200,/,489262500,125231250,491231250,127078125,35.04.18.986,135.55.53.305
14200,/,489262500,125231250,491231250,127078125,34.48.44.104,136.05.48.097
14200,/,489262500,125231250,491231250,127078125,34.50.22.703,136.06.38.799
14200,/,489262500,125231250,491231250,127078125,34.52.01.021,136.12.07.903
14200,/,489262500,125231250,491231250,127078125,34.59.42.920,136.24.56.280
14200,/,489262500,125231250,491231250,127078125,35.12.07.171,136.04.30.942
14200,/,489262500,125231250,491231250,127078125,35.14.42.723,136.11.39.548
14300,,490078125,126993750,491189062,128512500,35.28.48.811,136.12.13.412
14300,,490078125,126993750,491189062,128512500,35.30.03.759,136.22.36.807
14300,,490078125,126993750,491189062,128512500,35.22.51.912,136.14.09.241
14300,,490078125,126993750,491189062,128512500,35.25.40.134,136.24.31.544
14300,,490078125,126993750,491189062,128512500,35.31.54.871,136.22.31.294
14300,,490078125,126993750,491189062,128512500,35.37.38.889,136.09.57.285
14300,,490078125,126993750,491189062,128512500,35.17.47.078,136.18.51.131
14300,,490078125,126993750,491189062,128512500,35.26.11.004,136.11.26.259
14300,,490078125,126993750,491189062,128512500,35.33.49.705,136.10.06.033
14300,,490078125,126993750,491189062,128512500,35.40.06.957,136.08.10.881
14400,,488756250,126487500,490260937,128090625,35.13.53.605,135.55.29.781
14400,,488756250,126487500,490260937,128090625,35.13.08.917,135.54.54.102
14400,,488756250,126487500,490260937,128090625,35.27.18.136,135.54.57.695
14400,,488756250,126487500,490260937,128090625,35.27.18.619,136.09.33.596
14400,,488756250,126487500,490260937,128090625,35.31.21.776,136.04.17.908
14400,,488756250,126487500,490260937,128090625,35.13.40.693,135.54.43.679
14400,,488756250,126487500,490260937,128090625,35.14.57.974,135.58.43.392
14400,,488756250,126487500,490260937,128090625,35.18.36.728,136.04.48.714
14400,,488756250,126487500,490260937,128090625,35.19.30.478,136.05.06.584
14400,,488756250,126487500,490260937,128090625,35.20.16.860,135.46.42.185
14400,,488756250,126487500,490260937,128090625,35.22.45.210,135.47.43.349
14400,,488756250,126487500,490260937,128090625,35.30.04.461,135.58.19.460
14400,,488756250,126487500,490260937,128090625,35.26.53.308,136.09.25.058
14500,ز/޸,488882812,127678125,490232812,128746875,35.34.27.912,135.51.44.498
14500,ز/޸,488882812,127678125,490232812,128746875,35.34.10.147,135.49.23.060
14500,ز/޸,488882812,127678125,490232812,128746875,35.34.11.259,135.51.07.886
14500,ز/޸,488882812,127678125,490232812,128746875,35.30.04.412,135.58.39.374
14500,ز/޸,488882812,127678125,490232812,128746875,35.39.10.056,135.58.48.452
14500,ز/޸,488882812,127678125,490232812,128746875,35.44.22.984,136.06.15.709
14500,ز/޸,488882812,127678125,490232812,128746875,35.34.24.791,135.50.55.994
14500,ز/޸,488882812,127678125,490232812,128746875,35.37.14.295,135.51.44.162
14500,ز/޸,488882812,127678125,490232812,128746875,35.37.45.727,135.48.04.339
14500,ز/޸,488882812,127678125,490232812,128746875,35.40.24.889,135.58.30.684
14500,ز/޸,488882812,127678125,490232812,128746875,35.34.30.641,136.08.41.146
14500,ز/޸,488882812,127678125,490232812,128746875,35.41.07.753,136.02.16.131
14600,ͼ,487617187,127218750,489304687,128071875,35.32.00.348,135.45.58.595
14600,ͼ,487617187,127218750,489304687,128071875,35.28.13.397,135.54.06.367
14600,ͼ,487617187,127218750,489304687,128071875,35.31.18.830,135.31.06.580
14600,ͼ,487617187,127218750,489304687,128071875,35.32.35.654,135.41.28.029
14600,ͼ,487617187,127218750,489304687,128071875,35.31.37.609,135.51.38.170
14600,ͼ,487617187,127218750,489304687,128071875,35.24.17.922,135.31.44.276
14600,ͼ,487617187,127218750,489304687,128071875,35.25.35.917,135.29.48.946
14600,ͼ,487617187,127218750,489304687,128071875,35.29.34.619,135.30.57.195
14600,ͼ,487617187,127218750,489304687,128071875,35.29.12.029,135.39.45.736
14600,ͼ,487617187,127218750,489304687,128071875,35.29.38.818,135.53.09.350
14600,ͼ,487617187,127218750,489304687,128071875,35.30.28.838,135.31.01.680
14600,ͼ,487617187,127218750,489304687,128071875,35.30.43.938,135.36.27.552
14600,ͼ,487617187,127218750,489304687,128071875,35.33.45.656,135.44.35.359
14700,,485479687,126759375,487926562,128803125,35.16.18.550,135.05.42.764
14700,,485479687,126759375,487926562,128803125,35.30.07.266,135.11.27.848
14700,,485479687,126759375,487926562,128803125,35.22.31.993,135.30.07.202
14700,,485479687,126759375,487926562,128803125,35.34.30.506,135.11.15.934
14700,,485479687,126759375,487926562,128803125,35.15.57.989,135.15.39.348
14700,,485479687,126759375,487926562,128803125,35.15.58.906,135.18.29.694
14700,,485479687,126759375,487926562,128803125,35.35.39.995,134.52.12.576
14700,,485479687,126759375,487926562,128803125,35.22.37.721,135.31.00.157
14700,,485479687,126759375,487926562,128803125,35.28.12.079,135.23.03.562
14700,,485479687,126759375,487926562,128803125,35.33.34.702,135.23.55.488
14700,,485479687,126759375,487926562,128803125,35.41.18.521,135.00.30.380
14700,,485479687,126759375,487926562,128803125,35.14.18.262,135.04.09.136
14700,,485479687,126759375,487926562,128803125,35.15.50.601,135.15.19.781
14700,,485479687,126759375,487926562,128803125,35.23.29.419,134.55.43.591
14700,,485479687,126759375,487926562,128803125,35.35.25.915,134.51.26.993
14700,,485479687,126759375,487926562,128803125,35.20.43.733,135.27.13.721
14700,,485479687,126759375,487926562,128803125,35.28.59.169,135.19.54.210
14700,,485479687,126759375,487926562,128803125,35.32.19.903,135.14.33.574
14700,,485479687,126759375,487926562,128803125,35.31.55.094,135.15.59.695
14700,,485479687,126759375,487926562,128803125,35.32.43.413,135.21.24.687
14700,,485479687,126759375,487926562,128803125,35.36.04.915,135.13.42.262
14700,,485479687,126759375,487926562,128803125,35.43.13.766,135.17.30.567
14701,,486660937,125671875,488882812,127340625,35.11.18.138,135.13.19.610
14701,,486660937,125671875,488882812,127340625,35.15.08.032,135.16.01.456
14701,,486660937,125671875,488882812,127340625,35.02.12.217,135.22.42.832
14701,,486660937,125671875,488882812,127340625,35.08.34.930,135.17.50.355
14701,,486660937,125671875,488882812,127340625,35.13.45.523,135.45.01.211
14701,,486660937,125671875,488882812,127340625,35.18.29.601,135.47.33.614
14701,,486660937,125671875,488882812,127340625,35.21.21.858,135.31.25.727
14701,,486660937,125671875,488882812,127340625,34.59.00.603,135.29.22.639
14701,,486660937,125671875,488882812,127340625,35.01.53.406,135.22.52.435
14701,,486660937,125671875,488882812,127340625,35.07.22.364,135.23.15.217
14701,,486660937,125671875,488882812,127340625,35.12.55.270,135.11.26.018
14701,,486660937,125671875,488882812,127340625,35.10.10.994,135.16.48.037
14701,,486660937,125671875,488882812,127340625,35.17.18.363,135.21.41.432
14701,,486660937,125671875,488882812,127340625,35.17.35.489,135.22.26.686
14701,,486660937,125671875,488882812,127340625,35.17.08.277,135.45.34.860
14800,â,483735937,126431250,486182812,128428125,35.30.04.109,134.37.35.822
14800,â,483735937,126431250,486182812,128428125,35.37.33.046,134.45.06.823
14800,â,483735937,126431250,486182812,128428125,35.38.52.064,134.44.10.294
14800,â,483735937,126431250,486182812,128428125,35.10.46.272,134.52.35.460
14800,â,483735937,126431250,486182812,128428125,35.18.34.178,134.33.19.137
14800,â,483735937,126431250,486182812,128428125,35.38.46.930,134.38.55.666
14800,â,483735937,126431250,486182812,128428125,35.37.56.646,134.51.46.460
14800,â,483735937,126431250,486182812,128428125,35.14.19.837,134.40.57.152
14800,â,483735937,126431250,486182812,128428125,35.17.09.898,134.35.00.284
14800,â,483735937,126431250,486182812,128428125,35.21.49.209,134.54.58.023
14800,â,483735937,126431250,486182812,128428125,35.31.38.135,134.59.51.351
14800,â,483735937,126431250,486182812,128428125,35.37.03.487,134.24.07.710
14800,â,483735937,126431250,486182812,128428125,35.37.07.480,134.24.46.306
14800,â,483735937,126431250,486182812,128428125,35.39.27.075,134.33.26.406
14800,â,483735937,126431250,486182812,128428125,35.38.13.010,134.37.22.335
14800,â,483735937,126431250,486182812,128428125,35.39.44.134,134.42.52.042
14800,â,483735937,126431250,486182812,128428125,35.24.40.075,135.02.25.135
14900,Աؼ,488629687,125925000,488770312,125971875,34.59.21.861,135.43.56.534
14901,/;,488714062,126000000,488784375,126028125,35.00.07.463,135.45.35.213
14903,/,488615625,126018750,488784375,126131250,35.01.32.845,135.44.26.037
14904,,488475000,125925000,488643750,126037500,35.00.27.475,135.41.55.656
14905,/컳,488756250,125887500,488854687,126028125,34.58.08.289,135.46.16.058
14907,ջ/,488784375,126009375,489009375,126131250,35.00.53.624,135.49.14.076
14908,ر//Ȭ/縶,488643750,126112500,489093750,127125000,35.07.57.216,135.44.36.197
14908,ر//Ȭ/縶,488643750,126112500,489093750,127125000,35.03.57.126,135.49.42.612
14908,ر//Ȭ/縶,488643750,126112500,489093750,127125000,35.05.54.143,135.44.43.166
14908,ر//Ȭ/縶,488643750,126112500,489093750,127125000,35.15.24.330,135.44.04.460
14912,/,488151562,125718750,488601562,126009375,34.56.55.374,135.41.19.414
14913,/,488137500,125971875,488531250,126356250,35.03.51.503,135.36.39.027
14913,/,488137500,125971875,488531250,126356250,35.04.47.930,135.40.27.155
14914,,488840625,125803125,489107812,126037500,34.58.33.333,135.51.15.047
14915,̻/ջ/м,488362500,126065625,488784375,126590625,35.02.55.320,135.45.28.887
14915,̻/ջ/м,488362500,126065625,488784375,126590625,35.08.09.127,135.40.52.805
14915,̻/ջ/м,488362500,126065625,488784375,126590625,35.01.26.958,135.43.52.770
14917,޾̼,488657812,125971875,488784375,126000000,34.59.47.983,135.45.40.190
14918,/Ⱦͱ,488545312,125775000,488770312,125934375,34.56.55.072,135.44.04.734
14919,;,488643750,125971875,488714062,126028125,34.59.44.174,135.44.11.332
14920,/ͺ,488432812,126018750,488629687,126290625,35.01.58.408,135.42.09.973
14921,//,488531250,125531250,489164062,125906250,34.54.00.942,135.44.36.807
15000,Ĺ/,488320312,125578125,488587500,125868750,34.54.11.934,135.42.24.605
15100,,488446875,124921875,489825000,125831250,34.43.51.783,135.48.47.579
15100,,488446875,124921875,489825000,125831250,34.50.00.819,135.43.17.263
15100,,488446875,124921875,489825000,125831250,34.44.24.940,135.55.28.928
15100,,488446875,124921875,489825000,125831250,34.55.04.062,135.48.01.420
15100,,488446875,124921875,489825000,125831250,34.43.50.345,135.54.24.090
15100,,488446875,124921875,489825000,125831250,34.44.13.868,135.58.28.698
15100,,488446875,124921875,489825000,125831250,34.45.13.680,135.43.58.080
15100,,488446875,124921875,489825000,125831250,34.52.42.661,135.44.26.288
15100,,488446875,124921875,489825000,125831250,34.52.00.145,135.54.09.736
15100,,488446875,124921875,489825000,125831250,34.52.56.234,135.56.09.007
15200,,487321875,123628125,487996875,124584375,34.27.00.359,135.26.52.398
15200,,487321875,123628125,487996875,124584375,34.30.40.789,135.32.32.230
15200,,487321875,123628125,487996875,124584375,34.20.30.627,135.27.44.491
15200,,487321875,123628125,487996875,124584375,34.27.52.555,135.32.25.374
15200,,487321875,123628125,487996875,124584375,34.32.42.655,135.32.27.568
15201,,486337500,123365625,487687500,124190625,34.17.00.493,135.08.30.826
15201,,486337500,123365625,487687500,124190625,34.18.52.765,135.06.14.887
15201,,486337500,123365625,487687500,124190625,34.19.09.302,135.07.40.453
15201,,486337500,123365625,487687500,124190625,34.25.26.312,135.13.38.442
15201,,486337500,123365625,487687500,124190625,34.16.08.607,135.07.00.030
15201,,486337500,123365625,487687500,124190625,34.16.10.821,135.08.14.803
15201,,486337500,123365625,487687500,124190625,34.18.28.806,135.18.50.328
15201,,486337500,123365625,487687500,124190625,34.24.53.214,135.14.17.012
15201,,486337500,123365625,487687500,124190625,34.23.51.523,135.17.16.936
15201,,486337500,123365625,487687500,124190625,34.28.38.240,135.21.54.903
15202,,487757812,123590625,488489062,124546875,34.21.18.039,135.31.02.959
15202,,487757812,123590625,488489062,124546875,34.34.49.574,135.31.29.934
15202,,487757812,123590625,488489062,124546875,34.22.47.430,135.38.29.657
15202,,487757812,123590625,488489062,124546875,34.32.17.974,135.32.36.428
15300,ɻ,488573437,124565625,489557812,125090625,34.37.49.887,135.53.34.944
15300,ɻ,488573437,124565625,489557812,125090625,34.36.58.651,135.51.21.051
15300,ɻ,488573437,124565625,489557812,125090625,34.41.53.794,135.51.02.712
15400,/·,488334375,124378125,488981250,125212500,34.44.23.912,135.42.13.881
15400,/·,488334375,124378125,488981250,125212500,34.35.23.719,135.45.33.463
15400,/·,488334375,124378125,488981250,125212500,34.46.05.057,135.42.41.543
15400,/·,488334375,124378125,488981250,125212500,34.35.48.929,135.40.01.482
15400,/·,488334375,124378125,488981250,125212500,34.36.09.315,135.47.51.076
15400,/·,488334375,124378125,488981250,125212500,34.44.09.901,135.44.52.532
15500,,488362500,123768750,490443750,125043750,34.26.54.607,136.00.08.585
15500,,488362500,123768750,490443750,125043750,34.32.15.905,135.39.54.810
15500,,488362500,123768750,490443750,125043750,34.35.43.128,135.53.04.784
15500,,488362500,123768750,490443750,125043750,34.29.24.018,136.13.42.191
15500,,488362500,123768750,490443750,125043750,34.33.08.518,136.08.31.349
15500,,488362500,123768750,490443750,125043750,34.37.19.386,136.03.51.858
15500,,488362500,123768750,490443750,125043750,34.25.09.933,135.50.10.573
15500,,488362500,123768750,490443750,125043750,34.33.59.333,135.40.13.881
15500,,488362500,123768750,490443750,125043750,34.26.31.949,136.00.52.292
15500,,488362500,123768750,490443750,125043750,34.28.42.551,136.04.57.521
15500,,488362500,123768750,490443750,125043750,34.33.12.268,136.06.38.752
15500,,488362500,123768750,490443750,125043750,34.33.47.770,136.04.47.218
15500,,488362500,123768750,490443750,125043750,34.33.08.147,136.09.37.429
15600,,487940625,121875000,490092187,124115625,33.57.38.483,135.39.32.907
15600,,487940625,121875000,490092187,124115625,34.21.20.556,136.03.46.011
15600,,487940625,121875000,490092187,124115625,34.22.31.301,135.41.28.045
15600,,487940625,121875000,490092187,124115625,33.52.32.186,135.51.18.692
15600,,487940625,121875000,490092187,124115625,34.05.43.729,135.32.59.356
15600,,487940625,121875000,490092187,124115625,34.12.34.255,135.41.46.392
15600,,487940625,121875000,490092187,124115625,34.01.36.183,136.05.39.677
15600,,487940625,121875000,490092187,124115625,34.28.12.147,136.03.57.244
15600,,487940625,121875000,490092187,124115625,33.52.44.713,135.38.34.732
15600,,487940625,121875000,490092187,124115625,33.53.59.620,135.41.50.525
15600,,487940625,121875000,490092187,124115625,33.53.13.533,135.53.58.789
15600,,487940625,121875000,490092187,124115625,33.56.10.883,135.56.27.967
15600,,487940625,121875000,490092187,124115625,33.57.42.684,135.59.36.145
15600,,487940625,121875000,490092187,124115625,34.12.53.540,135.39.01.302
15600,,487940625,121875000,490092187,124115625,34.17.24.763,135.40.43.360
15600,,487940625,121875000,490092187,124115625,34.24.53.447,135.50.02.935
15600,,487940625,121875000,490092187,124115625,34.03.43.248,136.05.49.316
15600,,487940625,121875000,490092187,124115625,34.15.06.744,136.08.05.234
15800,/̾ĥ,489698437,124359375,490851562,125625000,34.33.32.236,136.10.00.811
15800,/̾ĥ,489698437,124359375,490851562,125625000,34.40.41.422,136.16.06.204
15800,/̾ĥ,489698437,124359375,490851562,125625000,34.34.12.154,136.04.00.389
15800,/̾ĥ,489698437,124359375,490851562,125625000,34.37.23.009,136.15.07.444
15800,/̾ĥ,489698437,124359375,490851562,125625000,34.40.33.203,136.05.35.197
15800,/̾ĥ,489698437,124359375,490851562,125625000,34.47.37.285,136.03.54.473
15800,/̾ĥ,489698437,124359375,490851562,125625000,34.48.09.348,136.17.11.162
15900,²λ/,486000000,122718750,487842187,123628125,34.15.01.830,135.26.26.326
15900,²λ/,486000000,122718750,487842187,123628125,34.07.17.719,135.17.04.359
15900,²λ/,486000000,122718750,487842187,123628125,34.10.00.496,135.10.50.997
15900,²λ/,486000000,122718750,487842187,123628125,34.06.19.522,135.04.49.469
15900,²λ/,486000000,122718750,487842187,123628125,34.07.22.694,135.17.56.865
15900,²λ/,486000000,122718750,487842187,123628125,34.12.52.363,135.08.13.044
15900,²λ/,486000000,122718750,487842187,123628125,34.16.22.357,135.08.48.144
15900,²λ/,486000000,122718750,487842187,123628125,34.15.59.765,135.27.50.214
16000,/,487617187,122728125,488629687,123759375,34.15.05.956,135.39.24.596
16000,/,487617187,122728125,488629687,123759375,34.06.17.207,135.32.32.894
16000,/,487617187,122728125,488629687,123759375,34.09.04.551,135.35.19.045
16000,/,487617187,122728125,488629687,123759375,34.14.47.507,135.29.44.363
16000,/,487617187,122728125,488629687,123759375,34.18.51.928,135.39.32.622
16000,/,487617187,122728125,488629687,123759375,34.20.02.915,135.27.23.675
16000,/,487617187,122728125,488629687,123759375,34.07.16.296,135.34.49.326
16000,/,487617187,122728125,488629687,123759375,34.10.54.960,135.38.23.026
16000,/,487617187,122728125,488629687,123759375,34.15.23.378,135.28.33.268
16000,/,487617187,122728125,488629687,123759375,34.20.28.965,135.27.13.514
16100,˷/ͭ,486196875,121584375,487996875,122934375,34.00.04.081,135.22.42.685
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.47.32.562,135.15.06.336
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.53.08.230,135.05.48.368
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.58.47.296,135.07.34.841
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.51.03.659,135.18.54.826
16100,˷/ͭ,486196875,121584375,487996875,122934375,34.03.52.020,135.07.04.364
16100,˷/ͭ,486196875,121584375,487996875,122934375,34.05.05.564,135.08.34.415
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.46.50.996,135.15.37.434
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.52.25.945,135.20.17.416
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.53.00.267,135.21.59.093
16100,˷/ͭ,486196875,121584375,487996875,122934375,33.58.05.075,135.33.15.738
16100,˷/ͭ,486196875,121584375,487996875,122934375,34.02.23.642,135.30.32.190
16100,˷/ͭ,486196875,121584375,487996875,122934375,34.05.24.952,135.10.38.043
16200,,486956250,121106250,488601562,122625000,33.40.38.238,135.25.21.285
16200,,486956250,121106250,488601562,122625000,34.01.15.886,135.31.04.343
16200,,486956250,121106250,488601562,122625000,33.47.37.221,135.39.01.336
16200,,486956250,121106250,488601562,122625000,34.03.11.980,135.33.52.826
16200,,486956250,121106250,488601562,122625000,33.40.57.132,135.30.32.979
16200,,486956250,121106250,488601562,122625000,33.41.13.120,135.31.26.728
16200,,486956250,121106250,488601562,122625000,33.47.55.880,135.39.03.843
16200,,486956250,121106250,488601562,122625000,33.52.13.676,135.20.18.901
16200,,486956250,121106250,488601562,122625000,33.55.57.247,135.25.49.485
16200,,486956250,121106250,488601562,122625000,34.01.37.880,135.36.08.080
16300,ͼ,487181250,120740625,488418750,121312500,33.38.49.068,135.26.25.970
16300,ͼ,487181250,120740625,488418750,121312500,33.37.14.860,135.38.33.635
16300,ͼ,487181250,120740625,488418750,121312500,33.40.38.752,135.22.04.564
16300,ͼ,487181250,120740625,488418750,121312500,33.40.24.484,135.25.31.348
16300,ͼ,487181250,120740625,488418750,121312500,33.35.49.508,135.29.42.293
16300,ͼ,487181250,120740625,488418750,121312500,33.37.44.826,135.33.21.804
16300,ͼ,487181250,120740625,488418750,121312500,33.38.27.773,135.36.51.232
16400,/ܼ,487673437,120337500,489248437,121415625,33.30.43.763,135.32.54.023
16400,/ܼ,487673437,120337500,489248437,121415625,33.27.36.169,135.48.22.992
16400,/ܼ,487673437,120337500,489248437,121415625,33.35.41.841,135.30.39.955
16400,/ܼ,487673437,120337500,489248437,121415625,33.29.36.120,135.35.32.282
16400,/ܼ,487673437,120337500,489248437,121415625,33.26.02.533,135.45.16.617
16400,/ܼ,487673437,120337500,489248437,121415625,33.26.34.301,135.49.15.816
16400,/ܼ,487673437,120337500,489248437,121415625,33.32.36.149,135.28.11.188
16400,/ܼ,487673437,120337500,489248437,121415625,33.34.10.612,135.53.04.342
16400,/ܼ,487673437,120337500,489248437,121415625,33.38.22.016,135.48.25.120
16500,Ҿ,488826562,120740625,489571875,121396875,33.35.39.936,135.50.41.537
16500,Ҿ,488826562,120740625,489571875,121396875,33.41.37.745,135.48.53.680
16500,Ҿ,488826562,120740625,489571875,121396875,33.33.00.543,135.53.32.267
16500,Ҿ,488826562,120740625,489571875,121396875,33.34.34.589,135.53.23.400
16500,Ҿ,488826562,120740625,489571875,121396875,33.38.57.417,135.48.37.341
16500,Ҿ,488826562,120740625,489571875,121396875,33.42.16.705,135.50.25.214
16600,,488348437,121209375,489656250,122043750,33.43.10.997,135.53.31.790
16600,,488348437,121209375,489656250,122043750,33.41.36.280,135.59.33.746
16600,,488348437,121209375,489656250,122043750,33.51.53.437,135.50.47.240
16600,,488348437,121209375,489656250,122043750,33.42.05.589,135.49.42.741
16600,,488348437,121209375,489656250,122043750,33.48.50.323,135.51.35.134
16600,,488348437,121209375,489656250,122043750,33.46.25.671,135.54.28.622
16600,,488348437,121209375,489656250,122043750,33.53.52.590,135.42.46.344
16700,/,489093750,121387500,490964062,123384375,33.56.18.005,136.01.03.038
16700,/,489093750,121387500,490964062,123384375,33.59.26.305,136.15.02.559
16700,/,489093750,121387500,490964062,123384375,33.53.48.212,135.53.29.997
16700,/,489093750,121387500,490964062,123384375,33.51.18.836,136.04.53.804
16700,/,489093750,121387500,490964062,123384375,33.56.01.791,136.12.44.253
16700,/,489093750,121387500,490964062,123384375,34.07.37.371,136.07.06.381
16700,/,489093750,121387500,490964062,123384375,34.06.39.292,136.15.03.068
16700,/,489093750,121387500,490964062,123384375,33.43.47.745,135.58.09.336
16700,/,489093750,121387500,490964062,123384375,33.51.54.343,135.54.17.147
16700,/,489093750,121387500,490964062,123384375,33.54.48.419,135.54.39.507
16700,/,489093750,121387500,490964062,123384375,33.50.58.295,136.04.53.313
16700,/,489093750,121387500,490964062,123384375,33.58.39.440,136.00.54.947
16700,/,489093750,121387500,490964062,123384375,34.00.16.467,136.00.46.781
16700,/,489093750,121387500,490964062,123384375,34.05.33.814,136.06.43.791
16700,/,489093750,121387500,490964062,123384375,34.07.07.867,136.17.24.900
16700,/,489093750,121387500,490964062,123384375,34.13.46.848,136.12.40.503
16700,/,489093750,121387500,490964062,123384375,34.10.36.725,136.19.24.043
16800,/׵,490204687,124003125,491667187,125428125,34.45.07.822,136.22.32.473
16800,/׵,490204687,124003125,491667187,125428125,34.45.00.937,136.26.21.951
16800,/׵,490204687,124003125,491667187,125428125,34.33.08.664,136.22.39.948
16800,/׵,490204687,124003125,491667187,125428125,34.34.28.623,136.23.31.011
16800,/׵,490204687,124003125,491667187,125428125,34.29.42.552,136.19.50.316
16800,/׵,490204687,124003125,491667187,125428125,34.31.01.184,136.13.36.703
16800,/׵,490204687,124003125,491667187,125428125,34.35.22.624,136.30.36.138
16800,/׵,490204687,124003125,491667187,125428125,34.38.34.344,136.32.57.979
16800,/׵,490204687,124003125,491667187,125428125,34.47.36.720,136.29.04.967
16800,/׵,490204687,124003125,491667187,125428125,34.27.13.744,136.12.54.612
16800,/׵,490204687,124003125,491667187,125428125,34.34.30.449,136.14.57.198
16800,/׵,490204687,124003125,491667187,125428125,34.34.25.921,136.15.09.452
16800,/׵,490204687,124003125,491667187,125428125,34.33.50.605,136.26.24.693
16800,/׵,490204687,124003125,491667187,125428125,34.36.27.423,136.29.02.192
16800,/׵,490204687,124003125,491667187,125428125,34.36.23.694,136.30.30.030
16800,/׵,490204687,124003125,491667187,125428125,34.36.19.242,136.30.47.816
16800,/׵,490204687,124003125,491667187,125428125,34.41.02.278,136.17.17.247
16800,/׵,490204687,124003125,491667187,125428125,34.44.45.135,136.19.35.157
16800,/׵,490204687,124003125,491667187,125428125,34.46.09.539,136.32.51.878
16900,/,489867187,122990625,492004687,124612500,34.12.00.785,136.09.25.430
16900,/,489867187,122990625,492004687,124612500,34.15.39.411,136.08.33.267
16900,/,489867187,122990625,492004687,124612500,34.23.11.706,136.30.09.908
16900,/,489867187,122990625,492004687,124612500,34.27.33.213,136.19.45.466
16900,/,489867187,122990625,492004687,124612500,34.12.52.468,136.25.20.222
16900,/,489867187,122990625,492004687,124612500,34.17.18.994,136.26.15.717
16900,/,489867187,122990625,492004687,124612500,34.21.56.078,136.06.08.529
16900,/,489867187,122990625,492004687,124612500,34.32.36.856,136.23.59.419
16900,/,489867187,122990625,492004687,124612500,34.10.10.505,136.08.31.938
16900,/,489867187,122990625,492004687,124612500,34.12.05.531,136.24.31.408
16900,/,489867187,122990625,492004687,124612500,34.17.26.413,136.27.17.288
16900,/,489867187,122990625,492004687,124612500,34.25.46.239,136.06.55.807
16900,/,489867187,122990625,492004687,124612500,34.26.55.235,136.16.57.770
16900,/,489867187,122990625,492004687,124612500,34.33.00.643,136.23.48.844
16900,/,489867187,122990625,492004687,124612500,34.34.45.375,136.27.34.137
17000,/Ļ/,491118750,123168750,493171875,124434375,34.13.45.896,136.26.16.160
17000,/Ļ/,491118750,123168750,493171875,124434375,34.18.50.855,136.42.20.954
17000,/Ļ/,491118750,123168750,493171875,124434375,34.16.21.254,136.25.49.979
17000,/Ļ/,491118750,123168750,493171875,124434375,34.15.45.384,136.35.13.309
17000,/Ļ/,491118750,123168750,493171875,124434375,34.24.05.483,136.32.31.830
17000,/Ļ/,491118750,123168750,493171875,124434375,34.22.19.257,136.54.27.102
17000,/Ļ/,491118750,123168750,493171875,124434375,34.30.00.480,136.46.57.627
17000,/Ļ/,491118750,123168750,493171875,124434375,34.30.44.732,136.51.35.880
17000,/Ļ/,491118750,123168750,493171875,124434375,34.16.54.692,136.49.45.425
17000,/Ļ/,491118750,123168750,493171875,124434375,34.14.15.889,136.33.37.082
17000,/Ļ/,491118750,123168750,493171875,124434375,34.19.28.693,136.30.24.130
17000,/Ļ/,491118750,123168750,493171875,124434375,34.17.27.106,136.42.55.294
17000,/Ļ/,491118750,123168750,493171875,124434375,34.16.27.073,136.50.05.156
17000,/Ļ/,491118750,123168750,493171875,124434375,34.22.32.200,136.54.55.371
17000,/Ļ/,491118750,123168750,493171875,124434375,34.25.13.085,136.32.09.495
17000,/Ļ/,491118750,123168750,493171875,124434375,34.26.12.137,136.33.06.357
17000,/Ļ/,491118750,123168750,493171875,124434375,34.28.28.276,136.52.25.980
17000,/Ļ/,491118750,123168750,493171875,124434375,34.30.43.139,136.37.21.416
17000,/Ļ/,491118750,123168750,493171875,124434375,34.31.37.893,136.39.39.148
17000,/Ļ/,491118750,123168750,493171875,124434375,34.32.49.366,136.41.40.793
17200,/,487715625,124903125,487814062,124987500,34.42.40.308,135.30.01.111
17201,ŷ/ͻ/Į,487814062,124865625,487898437,124940625,34.41.51.689,135.30.19.098
17202,/ıؼ,487771875,124903125,487814062,124940625,34.41.46.884,135.29.42.175
17203,/Į,487800000,124828125,487856250,124875000,34.40.31.740,135.30.03.208
17204,,487870312,124875000,487954687,125025000,34.41.45.964,135.31.40.480
17205,/,487603125,124931250,487842187,125100000,34.44.16.941,135.30.41.361
17206,ض/ٹ,487729687,124790625,487856250,124828125,34.39.56.987,135.29.22.580
17208,ŷ/٤ζ,487828125,124687500,487926562,124762500,34.38.15.574,135.31.02.111
17210,//ʿ,487701562,124500000,488137500,124743750,34.35.30.992,135.30.59.634
17212,,487434375,124546875,487757812,124837500,34.36.21.001,135.27.31.394
17213,̹/,487350000,124696875,487701562,125006250,34.40.02.306,135.25.19.707
17213,̹/,487350000,124696875,487701562,125006250,34.39.30.751,135.23.13.879
17214,/ŷھŹ,487814062,124912500,487884375,124987500,34.42.34.044,135.30.32.430
17215,̿/Ʋ/Ƿ,487729687,124846875,487814062,124912500,34.41.41.374,135.29.53.061
17216,,487856250,124828125,487940625,124875000,34.41.00.545,135.31.14.363
17217,ᶶ/Į/Τ,487856250,124687500,488053125,124846875,34.40.43.453,135.32.35.621
17218,/ܶ,487729687,124725000,487856250,124790625,34.38.59.835,135.30.41.233
17219,,487828125,124837500,488179687,125165625,34.40.50.262,135.32.43.868
17220,ʡ/,487673437,124837500,487771875,124931250,34.40.55.385,135.28.40.986
17221,ں/ټ,487673437,124790625,487800000,124875000,34.40.11.956,135.28.42.263
17300,/̧/˭ǽ,487195312,125240625,487912500,126178125,34.50.07.156,135.30.10.548
17300,/̧/˭ǽ,487195312,125240625,487912500,126178125,34.57.12.873,135.21.36.570
17300,/̧/˭ǽ,487195312,125240625,487912500,126178125,34.49.33.166,135.30.51.910
17300,/̧/˭ǽ,487195312,125240625,487912500,126178125,34.54.57.332,135.26.05.108
17300,/̧/˭ǽ,487195312,125240625,487912500,126178125,34.54.00.161,135.31.06.677
17300,/̧/˭ǽ,487195312,125240625,487912500,126178125,34.58.06.791,135.29.08.192
17301,˭/,487575000,125034375,488025000,125381250,34.45.15.074,135.27.22.468
17302,//,487814062,125109375,488446875,125887500,34.51.41.474,135.31.31.544
17302,//,487814062,125109375,488446875,125887500,34.54.04.539,135.31.37.092
17302,//,487814062,125109375,488446875,125887500,34.46.47.293,135.36.15.178
17302,//,487814062,125109375,488446875,125887500,34.48.36.410,135.38.01.899
17400,/,488010937,124884375,488685937,125550000,34.46.20.045,135.36.40.517
17400,/,488010937,124884375,488685937,125550000,34.50.38.203,135.40.03.610
17400,/,488010937,124884375,488685937,125550000,34.46.04.144,135.36.04.005
17500,,488039062,124368750,488446875,124912500,34.33.50.567,135.39.31.961
17500,,488039062,124368750,488446875,124912500,34.35.15.990,135.36.09.431
17600,,487321875,124818750,487659375,125203125,34.41.13.163,135.23.56.611
17601,/ð//,486337500,125118750,487673437,126121875,34.47.34.804,135.20.46.883
17601,/ð//,486337500,125118750,487673437,126121875,35.00.40.235,135.19.48.189
17601,/ð//,486337500,125118750,487673437,126121875,34.54.27.993,135.24.28.057
17601,/ð//,486337500,125118750,487673437,126121875,35.00.27.374,135.15.02.838
17601,/ð//,486337500,125118750,487673437,126121875,34.48.14.981,135.19.01.908
17601,/ð//,486337500,125118750,487673437,126121875,34.49.44.098,135.19.37.418
17601,/ð//,486337500,125118750,487673437,126121875,34.49.58.187,135.25.29.509
17601,/ð//,486337500,125118750,487673437,126121875,34.51.30.118,135.17.41.988
17601,/ð//,486337500,125118750,487673437,126121875,34.58.05.142,135.08.45.591
17601,/ð//,486337500,125118750,487673437,126121875,34.59.08.590,135.09.06.747
17700,ܻ,486829687,124856250,487378125,125475000,34.50.44.100,135.17.31.508
17700,ܻ,486829687,124856250,487378125,125475000,34.47.04.688,135.16.16.883
17800,,486956250,124921875,487181250,125203125,34.42.16.761,135.19.24.622
17900,/ϡС,486618750,124800000,486703125,124875000,34.40.15.667,135.10.36.261
17901,Į,486618750,124828125,486703125,124893750,34.41.10.256,135.11.08.754
17902,/,486618750,124893750,486773437,125043750,34.43.49.562,135.11.47.653
17903,/ݡȥ,486689062,124725000,486900000,124931250,34.39.16.236,135.14.40.661
17904,,486703125,124875000,486956250,125175000,34.46.04.059,135.14.53.379
17905,ʼ/Ĺ,486450000,124687500,486689062,124968750,34.41.15.631,135.07.44.851
17906,ϻû/ͭϲ,486225000,124884375,487054687,125596875,34.42.55.566,135.06.37.838
17906,ϻû/ͭϲ,486225000,124884375,487054687,125596875,34.42.58.798,135.05.17.039
17906,ϻû/ͭϲ,486225000,124884375,487054687,125596875,34.47.57.457,135.15.14.888
17907,,485676562,124743750,486351562,125184375,34.40.24.750,135.02.27.535
17907,,485676562,124743750,486351562,125184375,34.45.58.680,135.00.10.421
17907,,485676562,124743750,486351562,125184375,34.42.28.456,134.57.51.955
17908,/ϻå,486885937,124818750,487110937,125184375,34.41.13.254,135.15.16.806
17909,/,486070312,124621875,486520312,124968750,34.38.50.518,135.07.40.300
18000,л,485507812,124687500,486098437,125006250,34.39.26.368,134.57.19.237
18000,л,485507812,124687500,486098437,125006250,34.41.22.348,134.52.31.253
18000,л,485507812,124687500,486098437,125006250,34.39.07.224,134.57.17.122
18000,л,485507812,124687500,486098437,125006250,34.39.58.136,134.56.09.796
18100,ʼð,485662500,125831250,487448437,127078125,35.04.26.390,135.00.05.336
18100,ʼð,485662500,125831250,487448437,127078125,35.11.19.202,135.10.25.612
18100,ʼð,485662500,125831250,487448437,127078125,35.03.50.452,135.01.36.474
18100,ʼð,485662500,125831250,487448437,127078125,35.01.01.873,135.17.56.336
18100,ʼð,485662500,125831250,487448437,127078125,35.05.57.565,135.22.33.482
18100,ʼð,485662500,125831250,487448437,127078125,35.07.43.474,134.56.39.738
18100,ʼð,485662500,125831250,487448437,127078125,35.09.05.581,134.57.09.969
18100,ʼð,485662500,125831250,487448437,127078125,35.17.35.324,134.56.42.340
18100,ʼð,485662500,125831250,487448437,127078125,35.00.42.632,135.11.27.878
18100,ʼð,485662500,125831250,487448437,127078125,35.01.37.533,135.20.06.982
18100,ʼð,485662500,125831250,487448437,127078125,35.07.15.280,135.22.37.041
18200,,485085937,124865625,485873437,125512500,34.42.18.633,134.51.36.417
18200,,485085937,124865625,485873437,125512500,34.41.31.046,134.51.31.385
18200,,485085937,124865625,485873437,125512500,34.49.45.473,134.53.05.068
18201,,485226562,125146875,486604687,126759375,34.57.31.029,135.03.45.925
18201,,485226562,125146875,486604687,126759375,34.51.22.042,134.49.20.437
18201,,485226562,125146875,486604687,126759375,34.48.08.748,135.03.56.285
18201,,485226562,125146875,486604687,126759375,35.03.28.263,135.00.58.025
18201,,485226562,125146875,486604687,126759375,35.02.30.645,135.02.54.307
18201,,485226562,125146875,486604687,126759375,34.59.31.371,134.50.07.600
18201,,485226562,125146875,486604687,126759375,35.06.59.862,134.55.58.265
18201,,485226562,125146875,486604687,126759375,34.46.51.425,135.05.31.606
18300,,483300000,124800000,485015625,127200000,34.50.06.997,134.30.07.415
18300,,483300000,124800000,485015625,127200000,34.43.46.073,134.24.35.168
18300,,483300000,124800000,485015625,127200000,34.45.42.504,134.30.07.043
18300,,483300000,124800000,485015625,127200000,34.44.48.050,134.25.47.669
18300,,483300000,124800000,485015625,127200000,35.06.00.526,134.39.26.817
18300,,483300000,124800000,485015625,127200000,34.45.31.572,134.27.49.312
18300,,483300000,124800000,485015625,127200000,34.45.32.741,134.29.06.293
18300,,483300000,124800000,485015625,127200000,34.47.40.020,134.34.19.093
18300,,483300000,124800000,485015625,127200000,34.57.31.037,134.36.39.481
18300,,483300000,124800000,485015625,127200000,35.12.17.393,134.42.28.569
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.48.13.916,134.44.06.210
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.38.09.604,134.30.32.316
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.49.48.774,134.38.06.394
18400,ɱϩ/,483960937,124518750,485662500,126684375,35.01.41.816,134.49.54.324
18400,ɱϩ/,483960937,124518750,485662500,126684375,35.02.12.130,134.49.50.251
18400,ɱϩ/,483960937,124518750,485662500,126684375,35.08.32.530,134.43.15.556
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.39.29.489,134.29.11.560
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.38.51.310,134.34.48.799
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.45.52.204,134.36.52.509
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.46.08.628,134.43.08.493
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.53.49.384,134.34.39.202
18400,ɱϩ/,483960937,124518750,485662500,126684375,34.52.12.615,134.47.23.612
18400,ɱϩ/,483960937,124518750,485662500,126684375,35.00.34.281,134.50.22.625
18400,ɱϩ/,483960937,124518750,485662500,126684375,35.08.38.665,134.52.59.968
18500,øϩ,484762500,122943750,486112500,124584375,34.18.46.618,134.41.26.015
18500,øϩ,484762500,122943750,486112500,124584375,34.12.57.312,134.42.24.479
18500,øϩ,484762500,122943750,486112500,124584375,34.16.05.126,134.40.00.347
18500,øϩ,484762500,122943750,486112500,124584375,34.16.21.904,134.39.55.036
18500,øϩ,484762500,122943750,486112500,124584375,34.15.22.003,134.55.58.041
18500,øϩ,484762500,122943750,486112500,124584375,34.36.01.263,135.00.03.515
18500,øϩ,484762500,122943750,486112500,124584375,34.16.04.630,134.39.41.321
18500,øϩ,484762500,122943750,486112500,124584375,34.17.07.420,134.39.48.883
18500,øϩ,484762500,122943750,486112500,124584375,34.19.56.525,134.43.56.475
18500,øϩ,484762500,122943750,486112500,124584375,34.21.08.712,134.53.56.931
18500,øϩ,484762500,122943750,486112500,124584375,34.26.35.252,134.55.58.531
18600,Ļ,482231250,126600000,484256250,128212500,35.13.52.877,134.08.30.602
18601,ҵ,480825000,126900000,482512500,127912500,35.28.49.633,133.56.23.606
18602,ƻ/,479306250,126187500,480937500,127987500,35.11.22.662,133.28.12.236
18602,ƻ/,479306250,126187500,480937500,127987500,35.12.35.375,133.09.28.798
19100,/,478350000,126750000,480037500,128175000,35.14.23.102,133.04.51.792
19101,б/ʿ,477281250,125812500,479475000,127837500,35.04.24.636,132.40.19.824
19101,б/ʿ,477281250,125812500,479475000,127837500,35.22.00.391,133.01.06.508
19102,,476100000,125212500,477787500,126975000,34.58.53.898,132.18.57.422
19103,/,474806250,124912500,476606250,126196875,34.43.15.412,131.57.18.706
19104,,474018750,123487500,475762500,125409375,34.30.07.229,131.41.20.531
19104,,474018750,123487500,475762500,125409375,34.21.57.680,131.46.07.570
19105,,478575000,129525000,480206250,130875000,36.07.36.575,133.03.46.809
19700,/,482287500,124500000,483581250,125775000,34.35.42.985,134.08.35.501
19800,/,481500000,124003125,482850000,125437500,34.30.44.129,134.01.55.070
19801,/,479756250,124650000,481950000,126675000,34.50.06.670,133.20.48.259
19801,/,479756250,124650000,481950000,126675000,34.53.46.240,133.17.51.733
19802,Ż/,480600000,125362500,483918750,127237500,35.15.04.913,133.41.21.333
19802,Ż/,480600000,125362500,483918750,127237500,35.08.52.371,134.22.33.329
19802,Ż/,480600000,125362500,483918750,127237500,34.49.25.798,133.52.31.863
19802,Ż/,480600000,125362500,483918750,127237500,35.08.14.859,133.34.53.590
19802,Ż/,480600000,125362500,483918750,127237500,34.52.34.687,134.09.28.583
19900,//޲,480150000,123450000,481950000,125175000,34.40.04.638,133.37.41.089
19900,//޲,480150000,123450000,481950000,125175000,34.18.15.711,133.31.03.814
19900,//޲,480150000,123450000,481950000,125175000,34.30.08.824,133.27.24.314
20000,ʡ/,479306250,123375000,480543750,124950000,34.21.19.461,133.26.15.903
20001,/,477506250,124087500,480150000,126375000,34.42.37.951,132.48.56.595
20001,/,477506250,124087500,480150000,126375000,34.47.35.489,133.18.55.368
20001,/,477506250,124087500,480150000,126375000,34.55.05.739,132.40.32.048
20002,/,475368750,122475000,477000000,124462500,34.16.17.947,132.09.25.611
20002,/,475368750,122475000,477000000,124462500,34.10.03.951,132.28.14.783
20003,,476718750,122475000,478012500,123637500,34.13.12.637,132.39.24.306
20004,,476325000,123450000,477675000,124575000,34.32.35.466,132.23.37.991
20005,/ݸ,477393750,122793750,478856250,124650000,34.30.01.039,132.48.55.868
20005,/ݸ,477393750,122793750,478856250,124650000,34.33.51.290,132.45.08.052
20006,ޤʤ߳ƻ,478350000,122550000,479868750,123712500,34.06.20.935,133.01.56.408
20007,/ƻ,478631250,123487500,479868750,124237500,34.18.45.893,133.07.40.178
20008,/Ͳ,475650000,124162500,478125000,125437500,34.36.23.006,132.30.01.142
20008,/Ͳ,475650000,124162500,478125000,125437500,34.35.38.559,132.25.27.211
20500,//,471881250,122100000,474356250,123750000,34.07.31.928,131.16.55.371
20500,//,471881250,122100000,474356250,123750000,34.08.48.386,131.18.56.997
20501,/Ĺ/˧,471318750,122700000,474468750,125287500,34.27.35.818,131.28.20.642
20501,/Ĺ/˧,471318750,122700000,474468750,125287500,34.13.07.998,131.08.34.731
20501,/Ĺ/˧,471318750,122700000,474468750,125287500,34.21.58.362,131.42.22.859
20501,/Ĺ/˧,471318750,122700000,474468750,125287500,34.28.47.099,131.27.12.423
20502,/˭,470700000,122062500,472218750,123750000,34.21.17.410,130.51.36.695
20503,/,473906250,121350000,476985937,124050000,34.01.22.072,131.46.55.003
20503,/,473906250,121350000,476985937,124050000,34.23.46.068,132.02.01.940
20503,/,473906250,121350000,476985937,124050000,33.55.44.954,131.48.49.394
20503,/,473906250,121350000,476985937,124050000,33.48.47.006,132.11.21.153
20503,/,473906250,121350000,476985937,124050000,34.05.39.066,131.38.34.341
20503,/,473906250,121350000,476985937,124050000,34.19.26.412,131.59.08.944
20503,/,473906250,121350000,476985937,124050000,34.20.44.944,131.46.00.241
20503,/,473906250,121350000,476985937,124050000,33.58.31.445,132.25.59.248
20503,/,473906250,121350000,476985937,124050000,33.59.07.266,132.21.20.744
20700,⾾Լ,482118750,122784375,482920312,123956250,34.21.19.874,133.59.16.068
20700,⾾Լ,482118750,122784375,482920312,123956250,34.25.23.243,134.03.47.360
20700,⾾Լ,482118750,122784375,482920312,123956250,34.22.10.480,133.58.24.886
20700,⾾Լ,482118750,122784375,482920312,123956250,34.07.05.424,134.08.03.734
20700,⾾Լ,482118750,122784375,482920312,123956250,34.10.17.123,134.01.41.813
20700,⾾Լ,482118750,122784375,482920312,123956250,34.21.54.141,134.06.35.132
20800,컾,482231250,122934375,484003125,124425000,34.18.49.726,134.09.23.830
20800,컾,482231250,122934375,484003125,124425000,34.27.36.906,134.15.06.671
20800,컾,482231250,122934375,484003125,124425000,34.32.35.680,134.18.50.899
20800,컾,482231250,122934375,484003125,124425000,34.24.10.117,134.06.37.600
20800,컾,482231250,122934375,484003125,124425000,34.20.05.548,134.13.11.911
20800,컾,482231250,122934375,484003125,124425000,34.25.39.611,134.20.14.911
20800,컾,482231250,122934375,484003125,124425000,34.24.43.373,134.07.42.972
20800,컾,482231250,122934375,484003125,124425000,34.10.32.576,134.14.54.051
20800,컾,482231250,122934375,484003125,124425000,34.14.00.013,134.24.54.271
20800,컾,482231250,122934375,484003125,124425000,34.15.03.472,134.20.41.675
20800,컾,482231250,122934375,484003125,124425000,34.22.52.931,134.09.55.391
20800,컾,482231250,122934375,484003125,124425000,34.27.26.358,134.17.09.015
20800,컾,482231250,122934375,484003125,124425000,34.25.47.705,134.20.00.290
20800,컾,482231250,122934375,484003125,124425000,34.31.22.840,134.12.56.206
20900,滾,481021875,122643750,482596875,123946875,34.17.32.412,133.47.01.902
20900,滾,481021875,122643750,482596875,123946875,34.07.11.771,133.49.26.099
20900,滾,481021875,122643750,482596875,123946875,34.11.41.393,133.45.38.990
20900,滾,481021875,122643750,482596875,123946875,34.21.23.378,133.50.47.391
20900,滾,481021875,122643750,482596875,123946875,34.05.53.892,133.51.17.762
20900,滾,481021875,122643750,482596875,123946875,34.14.00.022,133.59.16.225
20900,滾,481021875,122643750,482596875,123946875,34.19.31.125,133.39.56.606
20900,滾,481021875,122643750,482596875,123946875,34.18.29.540,133.47.12.712
20900,滾,481021875,122643750,482596875,123946875,34.19.05.375,133.58.19.820
20900,滾,481021875,122643750,482596875,123946875,34.22.17.792,133.39.33.821
20900,滾,481021875,122643750,482596875,123946875,34.21.10.574,133.46.36.883
20900,滾,481021875,122643750,482596875,123946875,34.22.28.809,133.46.25.677
20900,滾,481021875,122643750,482596875,123946875,34.21.43.597,133.55.58.068
21000,,480684375,122428125,481781250,123431250,34.13.12.765,133.36.46.492
21000,,480684375,122428125,481781250,123431250,34.07.14.433,133.31.57.916
21000,,480684375,122428125,481781250,123431250,34.02.49.889,133.37.27.339
21000,,480684375,122428125,481781250,123431250,34.00.55.728,133.42.59.071
21000,,480684375,122428125,481781250,123431250,34.04.00.255,133.47.51.733
21000,,480684375,122428125,481781250,123431250,34.13.38.983,133.36.20.837
21000,,480684375,122428125,481781250,123431250,34.15.50.490,133.39.04.542
21100,,483918750,122221875,484607812,122868750,34.00.05.694,134.30.09.257
21100,,483918750,122221875,484607812,122868750,34.00.24.445,134.27.49.653
21100,,483918750,122221875,484607812,122868750,34.01.06.237,134.26.14.214
21100,,483918750,122221875,484607812,122868750,34.03.44.296,134.28.25.663
21200,縩,483482812,122690625,484734375,123300000,34.09.27.150,134.27.18.214
21200,縩,483482812,122690625,484734375,123300000,34.13.32.369,134.34.20.586
21200,縩,483482812,122690625,484734375,123300000,34.11.01.414,134.37.40.749
21200,縩,483482812,122690625,484734375,123300000,34.07.41.632,134.18.43.468
21200,縩,483482812,122690625,484734375,123300000,34.09.34.329,134.38.01.713
21200,縩,483482812,122690625,484734375,123300000,34.14.43.106,134.36.10.305
21300,縩,481176562,121631250,484101562,123037500,33.51.20.675,133.50.47.601
21300,縩,481176562,121631250,484101562,123037500,34.05.02.065,133.54.34.431
21300,縩,481176562,121631250,484101562,123037500,33.49.09.766,133.52.06.634
21300,縩,481176562,121631250,484101562,123037500,33.56.54.756,133.41.56.353
21300,縩,481176562,121631250,484101562,123037500,33.57.16.112,133.41.46.026
21300,縩,481176562,121631250,484101562,123037500,33.55.41.834,134.20.15.506
21300,縩,481176562,121631250,484101562,123037500,34.05.07.906,134.01.58.485
21300,縩,481176562,121631250,484101562,123037500,33.48.22.953,133.57.15.081
21300,縩,481176562,121631250,484101562,123037500,33.49.16.592,133.59.38.614
21300,縩,481176562,121631250,484101562,123037500,33.53.38.120,133.40.41.969
21300,縩,481176562,121631250,484101562,123037500,33.54.54.714,134.15.12.369
21300,縩,481176562,121631250,484101562,123037500,33.58.15.446,134.24.33.990
21300,縩,481176562,121631250,484101562,123037500,34.02.33.124,133.44.53.325
21300,縩,481176562,121631250,484101562,123037500,34.04.27.496,133.58.03.165
21300,縩,481176562,121631250,484101562,123037500,34.04.47.069,134.20.48.978
21300,縩,481176562,121631250,484101562,123037500,34.06.59.415,134.08.02.827
21400,縩,482526562,120721875,485381250,122465625,33.42.32.495,134.05.39.759
21400,縩,482526562,120721875,485381250,122465625,33.47.33.272,134.37.37.101
21400,縩,482526562,120721875,485381250,122465625,33.35.08.556,134.20.38.858
21400,縩,482526562,120721875,485381250,122465625,33.56.59.751,134.34.51.925
21400,縩,482526562,120721875,485381250,122465625,33.43.13.101,134.04.24.573
21400,縩,482526562,120721875,485381250,122465625,33.47.34.384,134.39.33.055
21400,縩,482526562,120721875,485381250,122465625,33.55.03.360,134.20.46.683
21400,縩,482526562,120721875,485381250,122465625,33.56.00.936,134.23.04.618
21400,縩,482526562,120721875,485381250,122465625,33.59.23.782,134.35.45.610
21400,縩,482526562,120721875,485381250,122465625,34.00.42.858,134.34.50.589
21400,縩,482526562,120721875,485381250,122465625,33.32.13.507,134.18.49.784
21400,縩,482526562,120721875,485381250,122465625,33.34.57.424,134.11.03.134
21400,縩,482526562,120721875,485381250,122465625,33.32.46.370,134.18.28.893
21400,縩,482526562,120721875,485381250,122465625,33.39.38.105,134.25.49.230
21400,縩,482526562,120721875,485381250,122465625,33.46.34.640,134.03.42.905
21400,縩,482526562,120721875,485381250,122465625,33.52.38.198,134.11.24.251
21400,縩,482526562,120721875,485381250,122465625,33.54.31.043,134.18.12.607
21400,縩,482526562,120721875,485381250,122465625,33.50.40.178,134.49.22.817
21400,縩,482526562,120721875,485381250,122465625,33.57.19.667,134.31.32.340
21400,縩,482526562,120721875,485381250,122465625,33.56.34.413,134.41.45.918
21500,ͽ,476971875,120459375,479404687,122531250,33.50.07.333,132.52.38.395
21500,ͽ,476971875,120459375,479404687,122531250,33.32.38.213,133.00.02.741
21500,ͽ,476971875,120459375,479404687,122531250,33.33.13.512,132.46.06.519
21500,ͽ,476971875,120459375,479404687,122531250,33.46.18.925,133.00.12.933
21500,ͽ,476971875,120459375,479404687,122531250,33.38.09.121,132.36.39.801
21500,ͽ,476971875,120459375,479404687,122531250,33.54.47.801,132.45.31.580
21500,ͽ,476971875,120459375,479404687,122531250,33.54.08.188,132.57.14.872
21500,ͽ,476971875,120459375,479404687,122531250,33.57.17.204,132.37.30.955
21500,ͽ,476971875,120459375,479404687,122531250,33.59.25.848,132.51.42.520
21500,ͽ,476971875,120459375,479404687,122531250,33.43.52.320,133.09.24.079
21500,ͽ,476971875,120459375,479404687,122531250,33.32.44.431,132.44.34.024
21500,ͽ,476971875,120459375,479404687,122531250,33.36.02.833,132.33.52.217
21500,ͽ,476971875,120459375,479404687,122531250,33.37.49.375,132.39.11.312
21500,ͽ,476971875,120459375,479404687,122531250,33.41.56.000,132.39.28.711
21500,ͽ,476971875,120459375,479404687,122531250,33.48.45.904,132.59.15.663
21500,ͽ,476971875,120459375,479404687,122531250,33.52.03.901,132.40.29.975
21500,ͽ,476971875,120459375,479404687,122531250,33.51.51.362,132.42.27.081
21500,ͽ,476971875,120459375,479404687,122531250,33.54.06.210,132.44.39.444
21500,ͽ,476971875,120459375,479404687,122531250,33.57.08.844,132.37.13.277
21500,ͽ,476971875,120459375,479404687,122531250,33.58.47.512,132.32.19.837
21500,ͽ,476971875,120459375,479404687,122531250,33.57.48.258,132.41.49.760
21500,ͽ,476971875,120459375,479404687,122531250,33.59.44.572,132.51.22.627
21500,ͽ,476971875,120459375,479404687,122531250,33.37.10.150,133.04.21.068
21500,ͽ,476971875,120459375,479404687,122531250,33.38.58.213,133.05.05.885
21500,ͽ,476971875,120459375,479404687,122531250,33.45.38.428,133.08.18.867
21600,ͽ,478125000,121490625,481289062,123056250,33.57.30.845,133.37.34.365
21600,ͽ,478125000,121490625,481289062,123056250,34.01.18.978,132.49.48.788
21600,ͽ,478125000,121490625,481289062,123056250,33.47.56.809,133.01.30.059
21600,ͽ,478125000,121490625,481289062,123056250,33.52.14.980,133.32.04.652
21600,ͽ,478125000,121490625,481289062,123056250,33.58.31.738,133.40.20.508
21600,ͽ,478125000,121490625,481289062,123056250,33.54.18.345,132.56.27.349
21600,ͽ,478125000,121490625,481289062,123056250,33.54.14.125,132.58.02.800
21600,ͽ,478125000,121490625,481289062,123056250,33.45.29.425,133.04.44.989
21600,ͽ,478125000,121490625,481289062,123056250,33.45.32.883,133.08.48.473
21600,ͽ,478125000,121490625,481289062,123056250,33.47.23.575,133.12.26.221
21600,ͽ,478125000,121490625,481289062,123056250,33.48.14.739,133.16.05.798
21600,ͽ,478125000,121490625,481289062,123056250,33.51.47.024,133.32.22.683
21600,ͽ,478125000,121490625,481289062,123056250,33.56.51.943,133.06.41.111
21600,ͽ,478125000,121490625,481289062,123056250,33.58.49.314,133.22.20.127
21600,ͽ,478125000,121490625,481289062,123056250,34.03.52.320,132.55.08.549
21600,ͽ,478125000,121490625,481289062,123056250,34.06.26.456,132.54.34.796
21600,ͽ,478125000,121490625,481289062,123056250,34.00.15.387,133.03.23.844
21700,ͽ,475242187,119868750,478434375,121453125,33.21.54.349,132.48.47.177
21700,ͽ,475242187,119868750,478434375,121453125,33.28.45.653,132.50.38.737
21700,ͽ,475242187,119868750,478434375,121453125,33.22.13.281,132.03.50.815
21700,ͽ,475242187,119868750,478434375,121453125,33.22.53.661,132.05.12.053
21700,ͽ,475242187,119868750,478434375,121453125,33.23.33.252,132.05.15.145
21700,ͽ,475242187,119868750,478434375,121453125,33.23.31.575,132.10.02.757
21700,ͽ,475242187,119868750,478434375,121453125,33.26.03.653,132.09.29.284
21700,ͽ,475242187,119868750,478434375,121453125,33.33.11.372,132.25.47.660
21700,ͽ,475242187,119868750,478434375,121453125,33.18.20.538,132.24.13.297
21700,ͽ,475242187,119868750,478434375,121453125,33.20.55.343,132.01.41.409
21700,ͽ,475242187,119868750,478434375,121453125,33.24.34.222,132.08.59.637
21700,ͽ,475242187,119868750,478434375,121453125,33.24.43.489,132.22.46.989
21700,ͽ,475242187,119868750,478434375,121453125,33.20.31.355,132.44.52.280
21700,ͽ,475242187,119868750,478434375,121453125,33.22.27.095,132.50.16.837
21700,ͽ,475242187,119868750,478434375,121453125,33.27.32.667,132.14.00.943
21700,ͽ,475242187,119868750,478434375,121453125,33.25.59.616,132.15.30.893
21700,ͽ,475242187,119868750,478434375,121453125,33.28.45.872,132.17.30.081
21700,ͽ,475242187,119868750,478434375,121453125,33.28.20.532,132.51.25.867
21700,ͽ,475242187,119868750,478434375,121453125,33.32.16.176,132.49.01.774
21700,ͽ,475242187,119868750,478434375,121453125,33.37.00.779,132.36.32.040
21700,ͽ,475242187,119868750,478434375,121453125,33.43.51.682,132.28.26.400
21800,ͽ,476142187,118415625,478476562,120168750,32.55.40.018,132.30.12.491
21800,ͽ,476142187,118415625,478476562,120168750,33.08.13.391,132.27.15.905
21800,ͽ,476142187,118415625,478476562,120168750,33.12.01.324,132.43.09.527
21800,ͽ,476142187,118415625,478476562,120168750,33.13.47.081,132.45.07.274
21800,ͽ,476142187,118415625,478476562,120168750,32.56.39.642,132.33.56.290
21800,ͽ,476142187,118415625,478476562,120168750,33.01.56.323,132.40.23.012
21800,ͽ,476142187,118415625,478476562,120168750,33.12.34.257,132.22.08.054
21800,ͽ,476142187,118415625,478476562,120168750,33.18.51.303,132.36.16.093
21800,ͽ,476142187,118415625,478476562,120168750,33.17.11.754,132.50.41.498
21800,ͽ,476142187,118415625,478476562,120168750,32.54.41.825,132.35.59.182
21800,ͽ,476142187,118415625,478476562,120168750,32.55.00.585,132.31.46.505
21800,ͽ,476142187,118415625,478476562,120168750,32.59.12.111,132.41.19.459
21800,ͽ,476142187,118415625,478476562,120168750,33.01.30.425,132.28.57.708
21800,ͽ,476142187,118415625,478476562,120168750,33.02.32.367,132.26.33.640
21800,ͽ,476142187,118415625,478476562,120168750,33.03.52.727,132.27.06.962
21800,ͽ,476142187,118415625,478476562,120168750,33.06.27.843,132.27.54.391
21800,ͽ,476142187,118415625,478476562,120168750,33.08.56.291,132.25.49.139
21800,ͽ,476142187,118415625,478476562,120168750,33.12.02.537,132.21.00.255
21800,ͽ,476142187,118415625,478476562,120168750,33.12.36.119,132.25.20.847
21800,ͽ,476142187,118415625,478476562,120168750,33.11.07.643,132.44.33.748
21800,ͽ,476142187,118415625,478476562,120168750,33.17.25.618,132.29.25.091
21800,ͽ,476142187,118415625,478476562,120168750,33.16.20.943,132.48.23.330
21800,ͽ,476142187,118415625,478476562,120168750,33.17.07.943,132.50.38.685
21800,ͽ,476142187,118415625,478476562,120168750,33.13.14.445,132.22.00.463
21900,λ,480318750,120525000,481064062,121068750,33.33.49.794,133.33.51.485
21900,λ,480318750,120525000,481064062,121068750,33.30.44.483,133.32.01.775
21900,λ,480318750,120525000,481064062,121068750,33.36.15.686,133.33.51.238
21900,λ,480318750,120525000,481064062,121068750,33.36.18.692,133.32.32.199
21900,λ,480318750,120525000,481064062,121068750,33.31.09.867,133.27.43.463
21900,λ,480318750,120525000,481064062,121068750,33.33.22.620,133.37.41.778
22000,θ,478870312,120009375,482653125,121959375,33.45.06.406,133.33.57.760
22000,θ,478870312,120009375,482653125,121959375,33.35.08.665,133.22.34.933
22000,θ,478870312,120009375,482653125,121959375,33.48.48.334,133.31.59.396
22000,θ,478870312,120009375,482653125,121959375,33.50.06.394,133.35.39.444
22000,θ,478870312,120009375,482653125,121959375,33.28.10.027,133.30.13.301
22000,θ,478870312,120009375,482653125,121959375,33.32.31.368,133.26.20.475
22000,θ,478870312,120009375,482653125,121959375,33.32.31.747,133.37.35.469
22000,θ,478870312,120009375,482653125,121959375,33.40.05.852,133.08.37.071
22000,θ,478870312,120009375,482653125,121959375,33.22.55.224,133.12.19.335
22000,θ,478870312,120009375,482653125,121959375,33.28.28.812,133.02.00.805
22000,θ,478870312,120009375,482653125,121959375,33.31.19.240,133.03.28.484
22000,θ,478870312,120009375,482653125,121959375,33.32.13.909,133.37.04.213
22000,θ,478870312,120009375,482653125,121959375,33.41.22.732,133.08.05.824
22000,θ,478870312,120009375,482653125,121959375,33.48.12.975,133.51.38.145
22000,θ,478870312,120009375,482653125,121959375,33.22.17.865,133.10.51.973
22000,θ,478870312,120009375,482653125,121959375,33.20.43.277,133.15.58.132
22000,θ,478870312,120009375,482653125,121959375,33.22.03.185,133.20.15.152
22000,θ,478870312,120009375,482653125,121959375,33.25.13.926,133.23.24.659
22000,θ,478870312,120009375,482653125,121959375,33.33.55.232,133.03.34.404
22000,θ,478870312,120009375,482653125,121959375,33.34.03.160,133.27.50.075
22000,θ,478870312,120009375,482653125,121959375,33.33.13.735,133.37.39.694
22000,θ,478870312,120009375,482653125,121959375,33.36.07.171,133.30.00.942
22000,θ,478870312,120009375,482653125,121959375,33.39.17.822,133.56.48.016
22000,θ,478870312,120009375,482653125,121959375,33.47.23.464,133.15.53.085
22000,θ,478870312,120009375,482653125,121959375,33.49.08.686,133.17.58.325
22000,θ,478870312,120009375,482653125,121959375,33.49.49.718,133.44.47.203
22000,θ,478870312,120009375,482653125,121959375,33.49.54.261,133.59.12.363
22000,θ,478870312,120009375,482653125,121959375,33.42.33.335,134.01.34.353
22100,θ,481767187,119653125,483510937,121368750,33.27.32.716,133.57.24.214
22100,θ,481767187,119653125,483510937,121368750,33.25.59.605,133.58.41.037
22100,θ,481767187,119653125,483510937,121368750,33.21.20.180,134.12.18.189
22100,θ,481767187,119653125,483510937,121368750,33.36.21.748,134.09.04.217
22100,θ,481767187,119653125,483510937,121368750,33.16.47.001,134.11.23.000
22100,θ,481767187,119653125,483510937,121368750,33.37.45.857,133.53.24.487
22100,θ,481767187,119653125,483510937,121368750,33.22.04.386,134.12.48.135
22100,θ,481767187,119653125,483510937,121368750,33.36.46.072,134.09.00.527
22200,θ,476929687,117712500,479770312,120515625,33.15.02.363,133.11.17.395
22200,θ,476929687,117712500,479770312,120515625,33.23.50.133,133.03.53.957
22200,θ,476929687,117712500,479770312,120515625,32.44.26.296,133.00.03.421
22200,θ,476929687,117712500,479770312,120515625,32.44.28.121,132.33.22.114
22200,θ,476929687,117712500,479770312,120515625,32.46.55.388,132.54.02.076
22200,θ,476929687,117712500,479770312,120515625,32.51.00.122,132.39.35.839
22200,θ,476929687,117712500,479770312,120515625,33.09.50.110,132.37.37.049
22200,θ,476929687,117712500,479770312,120515625,33.15.41.995,132.48.25.366
22200,θ,476929687,117712500,479770312,120515625,32.58.52.571,133.00.03.578
22200,θ,476929687,117712500,479770312,120515625,33.16.00.208,133.15.09.782
22200,θ,476929687,117712500,479770312,120515625,33.24.23.361,133.07.35.106
22200,θ,476929687,117712500,479770312,120515625,32.44.51.460,132.46.56.485
22200,θ,476929687,117712500,479770312,120515625,32.44.39.948,132.47.49.657
22200,θ,476929687,117712500,479770312,120515625,32.43.10.670,132.59.54.859
22200,θ,476929687,117712500,479770312,120515625,32.46.32.242,132.39.26.135
22200,θ,476929687,117712500,479770312,120515625,32.46.47.865,132.40.29.744
22200,θ,476929687,117712500,479770312,120515625,32.45.14.542,132.46.47.547
22200,θ,476929687,117712500,479770312,120515625,32.45.54.362,132.50.20.766
22200,θ,476929687,117712500,479770312,120515625,32.50.35.413,132.40.15.091
22200,θ,476929687,117712500,479770312,120515625,33.01.27.194,132.41.05.144
22200,θ,476929687,117712500,479770312,120515625,33.04.14.386,132.40.25.276
22200,θ,476929687,117712500,479770312,120515625,33.11.58.440,132.46.45.514
22200,θ,476929687,117712500,479770312,120515625,32.55.40.799,133.00.02.917
22200,θ,476929687,117712500,479770312,120515625,33.00.42.786,133.01.01.780
22200,θ,476929687,117712500,479770312,120515625,33.10.39.904,133.12.46.691
22200,θ,476929687,117712500,479770312,120515625,33.25.14.956,132.50.16.977
22200,θ,476929687,117712500,479770312,120515625,33.28.20.939,132.50.57.157
22200,θ,476929687,117712500,479770312,120515625,33.28.08.806,132.51.12.250
22200,θ,476929687,117712500,479770312,120515625,33.28.11.979,133.00.09.685
22300,̶,471037500,121809375,471346875,122100000,33.53.52.186,130.53.38.929
22301,ʶ/,470868750,121387500,471712500,122287500,33.49.49.449,130.57.52.624
22302,㾾/Ȫ/ȬȨ,470418750,121650000,471150000,122475000,33.53.28.027,130.43.17.164
22303,ȬȨ,470475000,121556250,470896875,122025000,33.49.34.127,130.43.55.841
22304,/˭,469968750,120412500,471431250,122100000,33.47.33.646,130.39.28.612
22304,/˭,469968750,120412500,471431250,122100000,33.48.10.115,130.41.19.542
22305,,471150000,120525000,472275000,121800000,33.38.47.867,131.04.44.225
22400,,469293750,120796875,469504687,120984375,33.33.27.147,130.23.02.821
22401,¿/,469012500,120712500,469800000,121350000,33.39.24.913,130.24.03.489
22402,/,469265625,120609375,469631250,120881250,33.32.35.995,130.26.22.315
22403,ɶ/,468112500,120337500,469462500,121950000,33.36.59.128,130.17.55.365
22403,ɶ/,468112500,120337500,469462500,121950000,33.34.45.409,130.13.08.713
22404,/޻,469350000,120225000,470418750,120825000,33.27.38.566,130.30.04.278
22404,/޻,469350000,120225000,470418750,120825000,33.26.56.374,130.23.28.607
22405,/,467929687,120468750,469068750,121275000,33.31.22.697,130.09.33.309
22405,/,467929687,120468750,469068750,121275000,33.31.37.738,130.08.09.678
22406,/Ų/,468337500,120703125,470306250,123300000,33.47.37.675,130.33.51.260
22406,/Ų/,468337500,120703125,470306250,123300000,33.46.21.577,130.35.49.173
22500,α/,469406250,119437500,471262500,120562500,33.13.16.282,130.25.24.962
22501,/̶/޸,469237500,118762500,471150000,119887500,33.06.55.288,130.36.41.536
22600,/Ļ,468112500,119175000,469968750,120525000,33.16.18.198,130.24.28.864
22700,/Τ,466382812,118575000,468900000,121050000,33.27.36.763,129.48.47.423
22700,/Τ,466382812,118575000,468900000,121050000,33.05.07.794,129.56.24.250
22700,/Τ,466382812,118575000,468900000,121050000,33.09.28.121,129.52.32.329
22800,/,464962500,121275000,467718750,124950000,33.44.14.010,129.51.48.586
22900,/ʿ,465581250,118725000,468112500,120637500,33.00.04.678,129.56.27.545
22900,/ʿ,465581250,118725000,468112500,120637500,33.09.29.916,129.22.32.668
22900,/ʿ,465581250,118725000,468112500,120637500,33.14.30.620,129.19.51.008
22900,/ʿ,465581250,118725000,468112500,120637500,33.10.06.266,129.24.27.217
22900,/ʿ,465581250,118725000,468112500,120637500,33.23.46.131,129.24.29.271
23000,,462037500,115143750,465187500,119925000,33.11.15.661,128.54.23.372
23100,Ĺ,465187500,117150000,468787500,119175000,32.57.34.457,129.58.16.213
23200,/縶,468450000,117300000,469406250,118387500,32.40.07.584,130.18.49.488
23300,ŷ,467831250,115687500,469800000,117450000,32.20.04.407,130.00.02.819
23300,ŷ,467831250,115687500,469800000,117450000,32.16.17.002,129.59.05.039
23400,,469631250,117187500,472050000,118425000,32.50.04.562,130.37.33.364
23401,̾/,469462500,118162500,471543750,119400000,32.53.49.672,130.56.22.764
23500,/,470981250,118875000,472781250,121050000,33.14.27.742,131.08.39.403
23600,/,472387500,119925000,474300000,121462500,33.33.52.681,131.17.02.208
23700,/۱/,471993750,118725000,473456250,120075000,33.13.51.175,131.26.22.068
23800,/,471150000,117600000,472781250,119475000,32.47.00.028,130.54.33.572
23900,ʬ,472556250,118875000,475312500,119812500,33.04.27.600,131.25.21.494
23900,ʬ,472556250,118875000,475312500,119812500,33.16.23.299,131.42.15.425
23901,/,472500000,117825000,475537500,119212500,32.48.50.149,131.43.14.296
23901,/,472500000,117825000,475537500,119212500,32.45.38.042,131.55.28.916
24000,䲬/,471600000,116250000,474975000,118200000,32.40.03.368,131.45.12.365
24100,ܺ/,471825000,112875000,473737500,116400000,32.10.06.256,131.15.06.713
24100,ܺ/,471825000,112875000,473737500,116400000,32.11.22.889,131.33.46.242
24200,Ծ/,470531250,113850000,472612500,115800000,31.47.36.855,130.53.38.280
24300,Ȭ/͵/,469237500,115537500,471993750,117412500,32.32.33.870,130.56.17.224
24400,,466762500,113062500,470643750,114787500,31.26.23.361,130.30.04.764
24400,,466762500,113062500,470643750,114787500,31.33.49.056,130.41.22.737
24400,,466762500,113062500,470643750,114787500,31.45.05.996,130.13.19.835
24400,,466762500,113062500,470643750,114787500,31.27.00.032,130.31.56.548
24401,/п,468281250,114187500,470587500,116325000,31.45.07.511,130.22.30.725
24401,/п,468281250,114187500,470587500,116325000,32.08.53.023,130.11.17.732
24401,/п,468281250,114187500,470587500,116325000,31.56.58.344,130.39.30.345
24402,ʬ/Ȼ,469743750,114000000,471262500,115387500,31.40.39.229,130.49.42.976
24500,ؽ/,468337500,112125000,470475000,113287500,31.22.34.841,130.22.30.748
24500,ؽ/,468337500,112125000,470475000,113287500,31.18.16.206,130.14.09.819
24600,/,470250000,111525000,472387500,114450000,31.05.06.739,130.52.35.983
24700,/,464287500,103575000,471937500,112368750,30.25.08.246,130.26.26.492
24700,/,464287500,103575000,471937500,112368750,29.48.49.470,129.50.46.139
24700,/,464287500,103575000,471937500,112368750,30.27.37.529,130.28.14.987
24700,/,464287500,103575000,471937500,112368750,31.11.51.627,129.28.38.405
24800,,462150000,97200000,468225000,102750000,27.45.07.851,129.00.08.729
24900,/ź,455850000,93600000,461700000,100500000,26.20.05.226,126.37.38.609
25000,/̾,459450000,87900000,472950000,97800000,26.20.04.180,128.00.09.152
25100,ܸ/г,442350000,86400000,451800000,90000000,24.15.04.010,123.37.31.488