#!/usr/bin/env perl
#-*-perl-*-
#
#

## make this a module
package ISO::639::5;

# use 5.006;
use strict;
use warnings;

use utf8;
use open ':locale';
use Pod::Usage;
# use ISO::639::3;

=head1 NAME

ISO::639::5 - Language groups

=head1 VERSION

Version 0.04

=cut

our $VERSION      = '0.04';

use Exporter 'import';
our @EXPORT = qw(
    language_group
    language_parent
    language_group_children
);
our %EXPORT_TAGS = ( all => \@EXPORT );


=head1 SYNOPSIS

    use ISO::639::5 qw/:all/;

=cut

our $LanguageGroup;
our $LanguageParent;

$LanguageGroup = {
  'aav' => [
    'irr',
    'kdt',
    'mkh',
    'mun',
    'nyl',
    'sss',
    'tth'
  ],
  'hok' => [
    'acv',
    'atw',
    'boi',
    'cid',
    'coc',
    'crz',
    'esq',
    'inz',
    'kju',
    'klb',
    'kyh',
    'mov',
    'mrc',
    'obi',
    'peb',
    'pef',
    'pej',
    'peq',
    'pom',
    'poo',
    'ppi',
    'puy',
    'sei',
    'sht',
    'sln',
    'veo',
    'was',
    'ynn',
    'yuf',
    'yum'
  ],
  'fox' => [
    'bnn',
    'bzg',
    'ckv',
    'dru',
    'fos',
    'pwn',
    'pyu',
    'ssf',
    'sxr',
    'tay',
    'trv',
    'tsu',
    'uun',
    'xnb',
    'xsy'
  ],
  'phi' => [
    'akl',
    'bik',
    'blf',
    'bno',
    'bnq',
    'ceb',
    'cps',
    'fil',
    'gor',
    'hil',
    'ibg',
    'ibl',
    'ify',
    'ilk',
    'ilo',
    'kak',
    'krj',
    'kyj',
    'kyk',
    'loc',
    'mdh',
    'mno',
    'mog',
    'mrw',
    'msb',
    'pag',
    'pam',
    'rth',
    'sgd',
    'snl',
    'sxn',
    'tbl',
    'tdn',
    'tne',
    'tnt',
    'tnw',
    'tom',
    'txs',
    'war'
  ],
  'map' => [
    'fox',
    'lcl',
    'lnd',
    'poz'
  ],
  'xgn' => [
    'bua',
    'dta',
    'kxs',
    'mhj',
    'mjg',
    'mon',
    'mvf',
    'peh',
    'sce',
    'xal',
    'xwo',
    'yuy'
  ],
  'cel' => [
    'bre',
    'cor',
    'cym',
    'gla',
    'gle',
    'glv',
    'mga',
    'nrc',
    'obt',
    'owl',
    'sga',
    'wlm',
    'xbm',
    'xcb',
    'xce',
    'xga',
    'xpi'
  ],
  'art' => [
    'afh',
    'avk',
    'bzt',
    'dws',
    'epo',
    'ido',
    'igs',
    'ile',
    'ina',
    'jbo',
    'ldn',
    'lfn',
    'neu',
    'nov',
    'qya',
    'rmv',
    'sjn',
    'tlh',
    'tzl',
    'vol',
    'zbl'
  ],
  'esx' => [
    'ale',
    'iku',
    'ipk',
    'kal',
    'ypk',
    'ysr'
  ],
  'zle' => [
    'bel',
    'orv',
    'rue',
    'rus',
    'ukr'
  ],
  'ngf' => [
    'bjz',
    'ekg',
    'uhn'
  ],
  'urj' => [
    'fiu',
    'syd'
  ],
  'bad' => [
    'bbp',
    'bfl',
    'bjo',
    'bpd',
    'bqk',
    'gox',
    'kuw',
    'liy',
    'lna',
    'lnl',
    'mnh',
    'nue',
    'nuu',
    'tor',
    'yaj',
    'zmz'
  ],
  'sdv' => [
    'ach',
    'alz',
    'anu',
    'bfa',
    'ddd',
    'din',
    'enb',
    'eyo',
    'kdj',
    'keo',
    'kln',
    'kpz',
    'lky',
    'lot',
    'lpx',
    'luo',
    'mas',
    'mqu',
    'muz',
    'niq',
    'nsg',
    'nub',
    'nus',
    'saq',
    'sgc',
    'shk',
    'tec',
    'teo',
    'toq',
    'tuv',
    'tuy'
  ],
  'azc' => [
    'chl',
    'com',
    'cup',
    'hch',
    'hop',
    'lui',
    'mfy',
    'mnr',
    'nah',
    'ntp',
    'ood',
    'opt',
    'pao',
    'par',
    'pia',
    'ppl',
    'ser',
    'shh',
    'stp',
    'tac',
    'tar',
    'tla',
    'tub',
    'var',
    'xaw',
    'xgf',
    'yaq'
  ],
  'hyx' => [
    'axm',
    'hye',
    'hyw',
    'xcl'
  ],
  'aqa' => [
    'alc'
  ],
  'gmw' => [
    'afr',
    'ang',
    'cim',
    'deu',
    'dum',
    'eng',
    'enm',
    'frk',
    'frr',
    'fry',
    'gct',
    'gmh',
    'gml',
    'goh',
    'gos',
    'gsw',
    'ksh',
    'lim',
    'lng',
    'ltz',
    'mhn',
    'nds',
    'nld',
    'odt',
    'ofs',
    'osx',
    'pdc',
    'pfl',
    'sco',
    'stq',
    'swg',
    'wae',
    'wep',
    'wym',
    'yec',
    'yid',
    'zea'
  ],
  'aql' => [
    'alg',
    'wiy',
    'yur'
  ],
  'misu1242' => [
    'ccr',
    'miq',
    'mtn',
    'ulw',
    'yan'
  ],
  'dra' => [
    'brh',
    'gon',
    'iru',
    'kan',
    'kfa',
    'kfc',
    'kff',
    'kmj',
    'kru',
    'kxl',
    'kxu',
    'kxv',
    'mal',
    'mjt',
    'mjv',
    'muv',
    'tam',
    'tcx',
    'tcy',
    'tel'
  ],
  'apa' => [
    'apj',
    'apk',
    'apl',
    'apw',
    'nav'
  ],
  'nai' => [
    'aql',
    'azc',
    'cdd',
    'hok',
    'iro',
    'sal',
    'sio',
    'wak',
    'xnd'
  ],
  'awd' => [
    'aca',
    'ame',
    'apu',
    'auf',
    'bae',
    'brg',
    'ccc',
    'cui',
    'gob',
    'guc',
    'guh',
    'guo',
    'ign',
    'inp',
    'kpc',
    'mbn',
    'not',
    'pbg',
    'pib',
    'pio',
    'plu',
    'tae',
    'trn',
    'ycn'
  ],
  'sem' => [
    'aao',
    'acw',
    'acy',
    'aeb',
    'afb',
    'aii',
    'ajt',
    'akk',
    'amh',
    'amw',
    'apc',
    'ara',
    'arc',
    'arq',
    'ary',
    'arz',
    'ayl',
    'gdq',
    'gez',
    'har',
    'heb',
    'jrb',
    'mey',
    'mlt',
    'phn',
    'sam',
    'shu',
    'smp',
    'sqr',
    'syc',
    'tig',
    'tir',
    'tmr',
    'uga',
    'xaa',
    'xeb',
    'xpu'
  ],
  'iir' => [
    'ask',
    'bih',
    'bsh',
    'inc',
    'ira',
    'prn',
    'wbk',
    'xvi'
  ],
  'sla' => [
    'zle',
    'zls',
    'zlw'
  ],
  'tai' => [
    'lao',
    'tha'
  ],
  'auf' => [
    'aru',
    'cul',
    'dny',
    'pad',
    'swx'
  ],
  'zls' => [
    'bos',
    'bul',
    'chu',
    'hrv',
    'mkd',
    'slv',
    'srp'
  ],
  'tuw' => [
    'eve',
    'evn',
    'gld',
    'juc',
    'mnc',
    'neg',
    'oaa',
    'oac',
    'orh',
    'sjo',
    'ude',
    'ulc'
  ],
  'mun' => [
    'hoc',
    'pcj',
    'sat',
    'unr'
  ],
  'smi' => [
    'sia',
    'sjd',
    'sje',
    'sjt',
    'sma',
    'sme',
    'smj',
    'smn',
    'sms'
  ],
  'crp' => [
    'cpe',
    'cpf',
    'cpp'
  ],
  'gmq' => [
    'dan',
    'fao',
    'isl',
    'nno',
    'nob',
    'non',
    'nrn',
    'ovd',
    'rmg',
    'swe'
  ],
  'cdd' => [
    'ari',
    'cad',
    'kii',
    'paw',
    'wic'
  ],
  'pqe' => [
    'agw',
    'ahb',
    'aia',
    'aie',
    'aji',
    'akr',
    'alm',
    'alu',
    'ane',
    'anx',
    'apb',
    'app',
    'apr',
    'asz',
    'aty',
    'aua',
    'aud',
    'aul',
    'auq',
    'aut',
    'baa',
    'bch',
    'bcm',
    'bcu',
    'bgt',
    'bhc',
    'bhw',
    'biq',
    'bjk',
    'blp',
    'blq',
    'bnk',
    'bnr',
    'bpa',
    'brr',
    'btr',
    'buk',
    'bvc',
    'bvd',
    'bwd',
    'bxa',
    'bxf',
    'bzh',
    'bzq',
    'cal',
    'cam',
    'chk',
    'crc',
    'ddi',
    'dgg',
    'dhv',
    'dob',
    'dor',
    'drr',
    'erg',
    'erk',
    'etn',
    'faf',
    'far',
    'fij',
    'frt',
    'fud',
    'fut',
    'fwa',
    'gdd',
    'gei',
    'gfk',
    'gga',
    'ggt',
    'ghn',
    'gil',
    'gli',
    'gmb',
    'goo',
    'gri',
    'grz',
    'gzn',
    'hah',
    'hao',
    'haw',
    'hiw',
    'hla',
    'hoa',
    'hrw',
    'iai',
    'irh',
    'jae',
    'jaj',
    'jaz',
    'kbm',
    'kdk',
    'khl',
    'kij',
    'kji',
    'kkk',
    'klv',
    'koa',
    'kos',
    'kpg',
    'kqw',
    'krf',
    'ksd',
    'ksg',
    'ktm',
    'kvc',
    'kwd',
    'kwf',
    'kxr',
    'kzk',
    'kzu',
    'lbb',
    'lbv',
    'lcm',
    'lek',
    'ler',
    'leu',
    'lga',
    'lgb',
    'lgk',
    'lgl',
    'lgr',
    'lgu',
    'lht',
    'lib',
    'lid',
    'lkn',
    'lle',
    'llf',
    'llp',
    'llu',
    'llx',
    'lmg',
    'lml',
    'lmu',
    'lmv',
    'loj',
    'los',
    'lpa',
    'lrv',
    'lrz',
    'lww',
    'mah',
    'mee',
    'mek',
    'met',
    'meu',
    'mft',
    'mgl',
    'mkj',
    'mkv',
    'mky',
    'mla',
    'mln',
    'mlu',
    'mlv',
    'mme',
    'mmg',
    'mmt',
    'mmw',
    'mmx',
    'mna',
    'mnv',
    'mox',
    'mpr',
    'mpy',
    'mqa',
    'mqm',
    'mrb',
    'mri',
    'mrl',
    'mrm',
    'mrn',
    'mrq',
    'mrv',
    'msq',
    'mte',
    'mtt',
    'mvo',
    'mwc',
    'mwh',
    'mwi',
    'mwo',
    'mxe',
    'nal',
    'nau',
    'ncc',
    'ncf',
    'ncn',
    'nee',
    'nem',
    'nen',
    'nfl',
    'ngr',
    'niu',
    'nke',
    'nkr',
    'nlg',
    'nmb',
    'nmk',
    'nms',
    'nmt',
    'nnd',
    'npn',
    'nsn',
    'nss',
    'nsw',
    'nua',
    'nuw',
    'nwi',
    'olr',
    'omb',
    'onu',
    'ora',
    'pek',
    'pex',
    'pfa',
    'pgk',
    'pif',
    'piv',
    'piz',
    'pkg',
    'pma',
    'pme',
    'pmt',
    'pnh',
    'pon',
    'pop',
    'ppn',
    'pri',
    'pss',
    'psw',
    'ptp',
    'ptv',
    'puw',
    'pwg',
    'rai',
    'rak',
    'rap',
    'rar',
    'ray',
    'roe',
    'rri',
    'rro',
    'rug',
    'sax',
    'sbb',
    'sbc',
    'sbe',
    'sbh',
    'sgz',
    'sij',
    'sjr',
    'sku',
    'slz',
    'smo',
    'sns',
    'sob',
    'sol',
    'sov',
    'sps',
    'ssg',
    'stn',
    'stw',
    'swp',
    'szw',
    'tah',
    'tbc',
    'tbe',
    'tbf',
    'tbj',
    'tgc',
    'tgi',
    'tgp',
    'tgs',
    'tio',
    'tkl',
    'tkp',
    'tkw',
    'tlm',
    'tlr',
    'tlx',
    'tmb',
    'tmi',
    'tmy',
    'tnk',
    'tnl',
    'tnn',
    'tnp',
    'tnx',
    'ton',
    'tox',
    'tpv',
    'tpz',
    'tql',
    'tqp',
    'tsr',
    'ttu',
    'ttv',
    'tuc',
    'tva',
    'tvk',
    'tvl',
    'twp',
    'ubr',
    'uge',
    'uli',
    'upv',
    'urr',
    'urv',
    'utp',
    'uve',
    'uvl',
    'vao',
    'vmg',
    'vnk',
    'vnm',
    'vra',
    'vrs',
    'vrt',
    'wiv',
    'wls',
    'woe',
    'wuv',
    'wwo',
    'wyy',
    'xsi',
    'yap',
    'yly',
    'zgr'
  ],
  'zlw' => [
    'ces',
    'csb',
    'czk',
    'pol',
    'pox',
    'slk',
    'szl',
    'wen'
  ],
  'sqj' => [
    'aae',
    'aat',
    'aln',
    'als'
  ],
  'ijo' => [
    'iby',
    'ijc',
    'ije',
    'ijn',
    'ijs',
    'nkx',
    'okd',
    'okr',
    'orr'
  ],
  'toto1251' => [
    'tcw',
    'tee',
    'tku',
    'tlc',
    'tlp',
    'toc',
    'too',
    'top',
    'tos',
    'tpp',
    'tpt',
    'tqt'
  ],
  'plf' => [
    'alo',
    'amv',
    'gal',
    'hbu',
    'kje',
    'lti',
    'mhs',
    'szn',
    'tet',
    'tlv',
    'txn',
    'wha'
  ],
  'cba' => [
    'bzd',
    'cbg',
    'chb',
    'kog',
    'mbp',
    'mot',
    'tuf'
  ],
  'mkh' => [
    'bbh',
    'bgk',
    'blr',
    'caq',
    'cbn',
    'crv',
    'cwg',
    'huo',
    'jah',
    'jhi',
    'kha',
    'khm',
    'kjg',
    'lbn',
    'mhe',
    'mlf',
    'mml',
    'mnw',
    'mqt',
    'mra',
    'mtq',
    'ncb',
    'oyb',
    'ply',
    'prk',
    'pry',
    'rka',
    'scb',
    'sea',
    'sii',
    'tef',
    'tnz',
    'tpu',
    'tyh',
    'uuu',
    'vie',
    'vwa',
    'wbm',
    'xao',
    'xnh',
    'zng'
  ],
  'nic' => [
    'alv',
    'dmn',
    'eka',
    'kdo',
    'lam',
    'nqo',
    'nyo',
    'tog',
    'znd'
  ],
  'syd' => [
    'mtm',
    'nio',
    'sel',
    'xas',
    'yrk'
  ],
  'cai' => [
    'azc',
    'cba',
    'cuy',
    'hok',
    'hue',
    'huv',
    'hve',
    'hvv',
    'len',
    'misu1242',
    'mixe1284',
    'myn',
    'omq',
    'pua',
    'tequ1244',
    'toto1251',
    'tsz',
    'xin'
  ],
  'bai' => [
    'bbj',
    'bko',
    'byv',
    'fmp',
    'jgo',
    'nla',
    'nnh',
    'nnz',
    'nwe',
    'xmg',
    'ybb'
  ],
  'wak' => [
    'dtd',
    'has',
    'hei',
    'kwk',
    'myh',
    'nuk'
  ],
  'sit' => [
    'dzo',
    'ero',
    'grt',
    'hmr',
    'hni',
    'iii',
    'jkr',
    'kac',
    'kar',
    'lbj',
    'lus',
    'mni',
    'mya',
    'new',
    'njh',
    'njm',
    'nmy',
    'nwc',
    'nxq',
    'qvy',
    'sxg',
    'tbq',
    'tsj',
    'txg',
    'xsr',
    'zhx'
  ],
  'tequ1244' => [
    'chd',
    'clo'
  ],
  'bnt' => [
    'abb',
    'asa',
    'auh',
    'bas',
    'beb',
    'bem',
    'beq',
    'bez',
    'bip',
    'bja',
    'bkh',
    'bkw',
    'bng',
    'bni',
    'bqz',
    'brf',
    'btb',
    'bum',
    'bvb',
    'bwt',
    'bxg',
    'cgg',
    'cjk',
    'cwe',
    'dav',
    'dez',
    'dma',
    'dua',
    'ebu',
    'eko',
    'eto',
    'ewo',
    'fan',
    'fip',
    'guz',
    'haq',
    'heh',
    'her',
    'hke',
    'hoo',
    'jmc',
    'kam',
    'kck',
    'kcv',
    'kde',
    'kik',
    'kin',
    'kkj',
    'kmb',
    'kon',
    'koo',
    'koq',
    'kqn',
    'ksb',
    'ksf',
    'kua',
    'kws',
    'kzo',
    'lag',
    'lch',
    'lik',
    'lin',
    'lol',
    'loz',
    'lua',
    'lub',
    'lue',
    'lug',
    'lun',
    'luy',
    'lyn',
    'mbo',
    'mdw',
    'mer',
    'mgh',
    'mhb',
    'mhw',
    'mye',
    'nba',
    'nbl',
    'ndc',
    'nde',
    'ndo',
    'ngc',
    'ngl',
    'njx',
    'nmg',
    'nnb',
    'nse',
    'nso',
    'nya',
    'nyf',
    'nym',
    'nyn',
    'pic',
    'rng',
    'rof',
    'run',
    'rwk',
    'rwm',
    'sbp',
    'seh',
    'shr',
    'sna',
    'snq',
    'sop',
    'sot',
    'ssw',
    'suk',
    'swa',
    'swb',
    'tll',
    'toi',
    'tsn',
    'tso',
    'tum',
    'umb',
    'ven',
    'vif',
    'vmk',
    'vun',
    'wdd',
    'wlc',
    'wni',
    'xho',
    'xog',
    'yao',
    'zdj',
    'zmw',
    'zul'
  ],
  'inc' => [
    'asm',
    'awa',
    'ben',
    'bgc',
    'bhb',
    'bho',
    'bjj',
    'bkk',
    'bns',
    'bpy',
    'bra',
    'ccp',
    'ctg',
    'div',
    'dml',
    'doi',
    'emx',
    'guj',
    'gwc',
    'gwt',
    'hif',
    'hin',
    'hne',
    'kas',
    'khw',
    'kls',
    'kok',
    'lah',
    'mag',
    'mai',
    'mar',
    'mvy',
    'mwr',
    'nep',
    'ori',
    'pan',
    'phl',
    'pra',
    'raj',
    'rml',
    'rmq',
    'rmt',
    'rom',
    'scl',
    'sdg',
    'sin',
    'skr',
    'snd',
    'syl',
    'urd'
  ],
  'aus' => [
    'bck',
    'dbl',
    'ddj',
    'gbu',
    'gni',
    'kdd',
    'kjn',
    'kld',
    'mep',
    'nha',
    'nuy',
    'piu',
    'pkn',
    'vma',
    'vmb',
    'wbp',
    'wmt',
    'xbp',
    'xrg',
    'yii',
    'yij'
  ],
  'qwe' => [
    'cqu',
    'inb',
    'inj',
    'qub',
    'qud',
    'quf',
    'qug',
    'quh',
    'quk',
    'qul',
    'qup',
    'qur',
    'qus',
    'quw',
    'qux',
    'quy',
    'quz',
    'qva',
    'qvc',
    'qve',
    'qvh',
    'qvi',
    'qvj',
    'qvl',
    'qvm',
    'qvn',
    'qvo',
    'qvp',
    'qvs',
    'qvw',
    'qvz',
    'qwa',
    'qwc',
    'qwh',
    'qws',
    'qxa',
    'qxc',
    'qxh',
    'qxl',
    'qxn',
    'qxo',
    'qxp',
    'qxr',
    'qxt',
    'qxu',
    'qxw'
  ],
  'znd' => [
    'zne'
  ],
  'ypk' => [
    'ems',
    'ess',
    'esu',
    'ynk'
  ],
  'cmc' => [
    'ace',
    'cje',
    'cjm',
    'hro',
    'huq',
    'jra',
    'rad',
    'rog'
  ],
  'egx' => [
    'egy'
  ],
  'sal' => [
    'cjh',
    'clm',
    'col',
    'coo',
    'cow',
    'crd',
    'fla',
    'hur',
    'lil',
    'nok',
    'oka',
    'qun',
    'shs',
    'spo',
    'squ',
    'str',
    'thp'
  ],
  'zhx' => [
    'cdo',
    'cjy',
    'cpx',
    'czh',
    'czo',
    'gan',
    'hak',
    'hsn',
    'ltc',
    'mnp',
    'nan',
    'och',
    'wuu',
    'wxa',
    'yue',
    'zho'
  ],
  'pqw' => [
    'abl',
    'abs',
    'abx',
    'ban',
    'bdg',
    'bdl',
    'bdr',
    'beg',
    'bew',
    'bjn',
    'bkz',
    'bsu',
    'btk',
    'buc',
    'bug',
    'cha',
    'cia',
    'cmc',
    'day',
    'dbj',
    'drg',
    'dtr',
    'dun',
    'dup',
    'duq',
    'duw',
    'eno',
    'gay',
    'goq',
    'iba',
    'ind',
    'jav',
    'kaw',
    'kge',
    'kjc',
    'kjk',
    'kqr',
    'ktq',
    'kvr',
    'kxd',
    'kyi',
    'kys',
    'lbw',
    'lbx',
    'lce',
    'lcf',
    'ley',
    'liw',
    'ljp',
    'llk',
    'mad',
    'mak',
    'mdr',
    'mfa',
    'mfb',
    'mhy',
    'min',
    'mkm',
    'mlg',
    'mqn',
    'msa',
    'mtd',
    'mui',
    'mwv',
    'mxr',
    'myl',
    'mzq',
    'nia',
    'nij',
    'nrm',
    'otd',
    'pau',
    'pdo',
    'pel',
    'phi',
    'pku',
    'pse',
    'raz',
    'ree',
    'rej',
    'sas',
    'sda',
    'sjm',
    'skh',
    'slm',
    'sml',
    'smr',
    'smw',
    'snv',
    'ssb',
    'sse',
    'sun',
    'sya',
    'tdi',
    'tdu',
    'tdx',
    'tjg',
    'tkg',
    'tlk',
    'twy',
    'txy',
    'ulu',
    'vkl',
    'vko',
    'wow',
    'wru',
    'xkq',
    'xmv',
    'xmw',
    'xmz',
    'yka',
    'zbc',
    'zbe',
    'zbw'
  ],
  'nah' => [
    'nci'
  ],
  'wen' => [
    'dsb',
    'hsb'
  ],
  'dmn' => [
    'bam',
    'bib',
    'bqc',
    'dnj',
    'dyu',
    'goa',
    'kao',
    'knk',
    'kno',
    'knu',
    'kpe',
    'lom',
    'man',
    'men',
    'mlq',
    'moa',
    'mwk',
    'rkm',
    'snk',
    'sus',
    'vai',
    'xkg',
    'yal'
  ],
  'kar' => [
    'kvq'
  ],
  'nub' => [
    'fia',
    'onw'
  ],
  'myn' => [
    'acr',
    'agu',
    'caa',
    'cac',
    'cak',
    'ctu',
    'hus',
    'itz',
    'ixl',
    'jac',
    'kek',
    'kjb',
    'knj',
    'mam',
    'mhc',
    'mop',
    'poc',
    'poh',
    'quc',
    'qum',
    'quv',
    'toj',
    'ttc',
    'tzh',
    'tzj',
    'tzo',
    'usp',
    'yua'
  ],
  'cpp' => [
    'aoa',
    'cri',
    'fab',
    'kea',
    'mzs',
    'pap',
    'pov',
    'pre',
    'srm',
    'xmm'
  ],
  'trk' => [
    'aib',
    'alt',
    'azb',
    'aze',
    'bak',
    'chg',
    'chv',
    'cjs',
    'clw',
    'crh',
    'dlg',
    'gag',
    'ili',
    'jct',
    'kaa',
    'kaz',
    'kdr',
    'kim',
    'kir',
    'kjh',
    'klj',
    'kmz',
    'krc',
    'kum',
    'ota',
    'otk',
    'qwm',
    'qxq',
    'sah',
    'slr',
    'tat',
    'tuk',
    'tur',
    'tyv',
    'uig',
    'uzb',
    'uzs',
    'xpc',
    'ybe'
  ],
  'alv' => [
    'aba',
    'abi',
    'abr',
    'abu',
    'ada',
    'adj',
    'agq',
    'ajg',
    'aka',
    'anw',
    'ati',
    'avi',
    'ayb',
    'azo',
    'bad',
    'bai',
    'bax',
    'bba',
    'bce',
    'bci',
    'bda',
    'beh',
    'bfd',
    'bfl',
    'bgj',
    'bim',
    'bin',
    'bju',
    'bkc',
    'bkm',
    'blo',
    'bmq',
    'bnt',
    'bqj',
    'bsc',
    'cae',
    'cou',
    'cwt',
    'dag',
    'dai',
    'dop',
    'dur',
    'dyo',
    'ebr',
    'efi',
    'ewe',
    'fap',
    'fod',
    'fon',
    'ful',
    'gaa',
    'gba',
    'gej',
    'gjn',
    'gkn',
    'goy',
    'gur',
    'gux',
    'ibo',
    'ijo',
    'jab',
    'kbp',
    'kcj',
    'kdh',
    'keu',
    'kia',
    'kma',
    'knf',
    'kqs',
    'kro',
    'krx',
    'kss',
    'kzc',
    'kzr',
    'ldm',
    'lee',
    'lmp',
    'lob',
    'mdd',
    'mfq',
    'mfv',
    'mgo',
    'mlo',
    'mnh',
    'mor',
    'mos',
    'mql',
    'mua',
    'myk',
    'mzm',
    'mzv',
    'mzw',
    'naj',
    'ndv',
    'nfr',
    'nga',
    'ngb',
    'nie',
    'nku',
    'ntm',
    'nza',
    'nzi',
    'ogc',
    'oku',
    'otr',
    'ozm',
    'pbo',
    'pbp',
    'pil',
    'pny',
    'pug',
    'sav',
    'sev',
    'shz',
    'snf',
    'soy',
    'spp',
    'srr',
    'tbz',
    'tem',
    'tfi',
    'tik',
    'tiv',
    'tkq',
    'tnr',
    'tui',
    'tuz',
    'urh',
    'wci',
    'wol',
    'wwa',
    'xsm',
    'xwe',
    'yav',
    'yky',
    'yor',
    'znd'
  ],
  'ine' => [
    'aln',
    'anp',
    'bat',
    'cel',
    'cms',
    'gem',
    'grk',
    'hit',
    'hlu',
    'hye',
    'hyx',
    'iir',
    'imy',
    'itc',
    'plq',
    'scx',
    'sdt',
    'sla',
    'sqi',
    'sqj',
    'txb',
    'txh',
    'xcl',
    'xcr',
    'xdc',
    'xlc',
    'xld',
    'xlg',
    'xls',
    'xmk',
    'xpg',
    'xps',
    'xsd',
    'xto',
    'xve'
  ],
  'gme' => [
    'got',
    'xvn'
  ],
  'kro' => [
    'ald',
    'bsq',
    'dic',
    'grb',
    'gud',
    'gxx',
    'ney',
    'nwb',
    'wec'
  ],
  'roa' => [
    'arg',
    'ast',
    'cat',
    'cos',
    'cpf',
    'cpp',
    'dlm',
    'egl',
    'ext',
    'fax',
    'fra',
    'frc',
    'frm',
    'fro',
    'frp',
    'fur',
    'glg',
    'ist',
    'ita',
    'lad',
    'lij',
    'lld',
    'lmo',
    'mwl',
    'mxi',
    'nap',
    'nrf',
    'oci',
    'osp',
    'pcd',
    'pms',
    'por',
    'rgn',
    'roh',
    'ron',
    'ruo',
    'rup',
    'ruq',
    'scn',
    'sdc',
    'sdn',
    'spa',
    'srd',
    'vec',
    'wln'
  ],
  'cus' => [
    'aar',
    'arv',
    'bej',
    'bji',
    'byn',
    'dal',
    'irk',
    'orc',
    'orm',
    'sid',
    'som',
    'ssn',
    'ssy'
  ],
  'kdo' => [
    'acz',
    'dec',
    'eli',
    'fuj',
    'hbn',
    'iof',
    'jle',
    'kcp',
    'kcr',
    'kec',
    'kgo',
    'kib',
    'laf',
    'lmd',
    'mor',
    'otr',
    'ras',
    'shw',
    'tag',
    'taz',
    'tbr',
    'tey',
    'tic',
    'tlo',
    'tms',
    'tqr',
    'wrn',
    'xtc'
  ],
  'pra' => [
    'pli',
    'san'
  ],
  'ber' => [
    'cnu',
    'grr',
    'jbe',
    'jbn',
    'kab',
    'mzb',
    'nxm',
    'oua',
    'rif',
    'sds',
    'shi',
    'shy',
    'siz',
    'taq',
    'thv',
    'tmh',
    'tzm',
    'zen',
    'zgh'
  ],
  'cdc' => [
    'anc',
    'ank',
    'bid',
    'daa',
    'hau',
    'hed',
    'lme',
    'maf',
    'mcn',
    'mmy',
    'mpi',
    'mse',
    'mug',
    'nnc',
    'nnn',
    'pip',
    'sor',
    'tmc',
    'zim',
    'zuy'
  ],
  'sgn' => [
    'csn',
    'fcs',
    'fsl',
    'ils',
    'isg',
    'rsl'
  ],
  'mul' => [
    'aav',
    'afa',
    'aqa',
    'aql',
    'art',
    'auf',
    'aus',
    'awd',
    'azc',
    'cau',
    'cba',
    'cdd',
    'dra',
    'esx',
    'euq',
    'hmx',
    'hok',
    'ine',
    'iro',
    'jpx',
    'khi',
    'map',
    'myn',
    'nic',
    'omq',
    'paa',
    'sal',
    'sgn',
    'sio',
    'sit',
    'ssa',
    'tai',
    'tup',
    'tut',
    'urj',
    'wak',
    'xnd'
  ],
  'jpx' => [
    'jpn'
  ],
  'cau' => [
    'ccn',
    'ccs'
  ],
  'sai' => [
    'aqa',
    'awd',
    'cba',
    'qwe',
    'tup'
  ],
  'ath' => [
    'aht',
    'apa',
    'bcr',
    'bea',
    'caf',
    'chp',
    'clc',
    'crx',
    'den',
    'dgr',
    'gwi',
    'haa',
    'hup',
    'ing',
    'kkz',
    'koy',
    'kuu',
    'srs',
    'tau',
    'tcb',
    'tgx',
    'tht',
    'tol'
  ],
  'alg' => [
    'alq',
    'arp',
    'atj',
    'ats',
    'bla',
    'chy',
    'ciw',
    'cre',
    'del',
    'kic',
    'mez',
    'mia',
    'mic',
    'mjy',
    'moe',
    'nnt',
    'oji',
    'ojs',
    'ojw',
    'otw',
    'pim',
    'pot',
    'qyp',
    'sac',
    'sjw',
    'unm',
    'wam',
    'xlb',
    'xlo',
    'xnt',
    'xpq'
  ],
  'oto' => [
    'otm'
  ],
  'ira' => [
    'ave',
    'bal',
    'bsg',
    'ckb',
    'fas',
    'glk',
    'hac',
    'haz',
    'isk',
    'jdt',
    'jpr',
    'kho',
    'kur',
    'lrc',
    'lsa',
    'mzn',
    'oru',
    'oss',
    'pal',
    'peo',
    'prc',
    'pus',
    'sgh',
    'sgl',
    'sgy',
    'siy',
    'smy',
    'sog',
    'sqo',
    'srh',
    'tgk',
    'tly',
    'ttt',
    'wbl',
    'xbc',
    'xco',
    'xpr',
    'xsc',
    'yai',
    'zum',
    'zza'
  ],
  'ccs' => [
    'kat',
    'lzz',
    'sva',
    'xmf'
  ],
  'euq' => [
    'eus'
  ],
  'mixe1284' => [
    'mco',
    'mir',
    'mto',
    'mxp',
    'mxq',
    'mzl',
    'neq',
    'plo',
    'poi',
    'poq',
    'pos',
    'pxm',
    'zoc',
    'zoh',
    'zoq',
    'zor',
    'zos'
  ],
  'day' => [
    'bth',
    'lra',
    'sdo',
    'sne'
  ],
  'btk' => [
    'akb',
    'bbc',
    'btd',
    'btm',
    'bts',
    'btx',
    'btz'
  ],
  'bih' => [
    'anp',
    'bho',
    'hif',
    'hns',
    'kra',
    'kyw',
    'mag',
    'mah',
    'mai',
    'mjz',
    'sck',
    'smm',
    'soi',
    'tdb',
    'the',
    'thl',
    'thq',
    'thr',
    'tkb',
    'tkt'
  ],
  'afa' => [
    'ber',
    'bxe',
    'cdc',
    'cop',
    'cus',
    'egx',
    'egy',
    'omv',
    'sem',
    'zwa'
  ],
  'hmx' => [
    'bje',
    'bpn',
    'buh',
    'bwn',
    'cqd',
    'hmd',
    'hml',
    'hmn',
    'hnj',
    'ium',
    'mji',
    'mmr',
    'mww',
    'pha',
    'pnu',
    'shx'
  ],
  'mno' => [
    'atd',
    'bgs',
    'bkd',
    'cgc',
    'mba',
    'mbb',
    'mbd',
    'mbi',
    'mbs',
    'mbt',
    'mkx',
    'mqk',
    'msm',
    'mta',
    'obo'
  ],
  'tut' => [
    'nog',
    'trk',
    'tuw',
    'xgn'
  ],
  'gem' => [
    'gme',
    'gmq',
    'gmw'
  ],
  'ssa' => [
    'csu',
    'dzg',
    'fvr',
    'gly',
    'guk',
    'ikx',
    'kau',
    'kbl',
    'kie',
    'kmq',
    'lgn',
    'mde',
    'mls',
    'rou',
    'sdv',
    'son',
    'teu',
    'tuq',
    'udu',
    'wti',
    'xmr',
    'xom'
  ],
  'sio' => [
    'asb',
    'bll',
    'cro',
    'dak',
    'hid',
    'iow',
    'ksk',
    'lkt',
    'mhq',
    'ofo',
    'oma',
    'osa',
    'qua',
    'sto',
    'tta',
    'win',
    'xwc'
  ],
  'grk' => [
    'cpg',
    'ell',
    'gmy',
    'grc',
    'pnt',
    'tsd',
    'yej'
  ],
  'csu' => [
    'avu',
    'bdh',
    'bex',
    'bot',
    'kcm',
    'led',
    'mdi',
    'mdj',
    'mhi',
    'mwm',
    'myb',
    'niy',
    'sba'
  ],
  'tup' => [
    'eme',
    'grn',
    'gui',
    'guq',
    'gyr',
    'kay',
    'kgk',
    'kpn',
    'ktn',
    'kyr',
    'mpu',
    'myu',
    'nhd',
    'psm',
    'skf',
    'srq',
    'tpj',
    'tpr',
    'tpw',
    'twt',
    'wyr',
    'yrl'
  ],
  'cpf' => [
    'acf',
    'cks',
    'crs',
    'gcf',
    'gcr',
    'hat',
    'kmv',
    'lou',
    'mfe',
    'rcf'
  ],
  'khi' => [
    'hts',
    'ktz',
    'kwz',
    'naq',
    'nmn',
    'sad'
  ],
  'poz' => [
    'aol',
    'bhp',
    'end',
    'hvn',
    'ivv',
    'kei',
    'kvh',
    'mqy',
    'nxe',
    'ple',
    'plf',
    'pqe',
    'pqw',
    'ski',
    'tao',
    'xbr',
    'xxk'
  ],
  'omq' => [
    'cco',
    'coz',
    'czn',
    'ixc',
    'maj',
    'maq',
    'miz',
    'mxb',
    'oto',
    'pbs',
    'pmq',
    'pmz',
    'tpc',
    'tpl',
    'tpx',
    'trs',
    'zap',
    'zaw',
    'ztq',
    'zty'
  ],
  'itc' => [
    'lat',
    'osc',
    'roa',
    'spx',
    'xfa',
    'xum'
  ],
  'paa' => [
    'aau',
    'anz',
    'ddg',
    'gak',
    'kax',
    'kmo',
    'lvk',
    'mok',
    'nas',
    'ngf',
    'pgu',
    'saj',
    'tcm',
    'tft',
    'tif',
    'tlb',
    'tqu',
    'waj',
    'wli',
    'yee',
    'zuh'
  ],
  'xnd' => [
    'ath',
    'eya',
    'hoi',
    'tfn',
    'tli'
  ],
  'swa' => [
    'swc'
  ],
  'tbq' => [
    'adx',
    'anm',
    'bod',
    'bqh',
    'brx',
    'duu',
    'ers',
    'gqi',
    'gro',
    'jya',
    'kar',
    'lhu',
    'lpo',
    'mxj',
    'njo',
    'nun',
    'trp',
    'twm'
  ],
  'omv' => [
    'aiw',
    'bcq',
    'bwo',
    'dim',
    'doz',
    'jnj',
    'mdx',
    'noz',
    'she',
    'wal',
    'zay'
  ],
  'bat' => [
    'lav',
    'lit',
    'ltg',
    'ndf',
    'olt',
    'prg',
    'sgs',
    'svx',
    'sxl',
    'xcu',
    'xgl',
    'xsv',
    'xzm'
  ],
  'fiu' => [
    'chm',
    'est',
    'fin',
    'fit',
    'fkv',
    'hun',
    'izh',
    'kca',
    'koi',
    'kom',
    'krl',
    'liv',
    'mdf',
    'mns',
    'mrj',
    'myv',
    'olo',
    'smi',
    'udm',
    'vep',
    'vot',
    'vro'
  ],
  'iro' => [
    'cay',
    'chr',
    'lre',
    'moh',
    'ntw',
    'one',
    'ono',
    'see',
    'sqn',
    'tus',
    'wya'
  ],
  'son' => [
    'ddn',
    'dje',
    'kcy',
    'khq',
    'ses',
    'twq'
  ],
  'ccn' => [
    'abk',
    'abq',
    'ady',
    'agx',
    'akv',
    'ani',
    'aqc',
    'ava',
    'bbl',
    'bdk',
    'bph',
    'che',
    'cji',
    'dar',
    'ddo',
    'gdo',
    'gin',
    'huz',
    'inh',
    'kap',
    'kbd',
    'khv',
    'kjj',
    'kpt',
    'kry',
    'kva',
    'lbe',
    'lez',
    'rut',
    'tab',
    'tin',
    'tkr',
    'uby',
    'udi'
  ],
  'ngb' => [
    'sag'
  ]
};
$LanguageParent = {
  'zgh' => 'ber',
  'hak' => 'zhx',
  'gld' => 'tuw',
  'shu' => 'sem',
  'zaw' => 'omq',
  'xls' => 'ine',
  'udi' => 'ccn',
  'tol' => 'ath',
  'snk' => 'dmn',
  'chb' => 'cba',
  'nke' => 'pqe',
  'lbw' => 'pqw',
  'ine' => 'mul',
  'cid' => 'hok',
  'nep' => 'inc',
  'xgl' => 'bat',
  'efi' => 'alv',
  'frp' => 'roa',
  'fap' => 'alv',
  'khv' => 'ccn',
  'mya' => 'sit',
  'tnx' => 'pqe',
  'tah' => 'pqe',
  'jya' => 'tbq',
  'rsl' => 'sgn',
  'wxa' => 'zhx',
  'ido' => 'art',
  'hit' => 'ine',
  'drr' => 'pqe',
  'zgr' => 'pqe',
  'chk' => 'pqe',
  'tsr' => 'pqe',
  'dtr' => 'pqw',
  'tgc' => 'pqe',
  'mez' => 'alg',
  'cwt' => 'alv',
  'bjk' => 'pqe',
  'hin' => 'inc',
  'zng' => 'mkh',
  'zbw' => 'pqw',
  'auh' => 'bnt',
  'kff' => 'dra',
  'mlg' => 'pqw',
  'llp' => 'pqe',
  'roe' => 'pqe',
  'osc' => 'itc',
  'grk' => 'ine',
  'cqd' => 'hmx',
  'dbl' => 'aus',
  'trp' => 'tbq',
  'mixe1284' => 'cai',
  'kii' => 'cdd',
  'gli' => 'pqe',
  'onw' => 'nub',
  'muv' => 'dra',
  'ask' => 'iir',
  'nun' => 'tbq',
  'yii' => 'aus',
  'hbs' => 'zls',
  'bce' => 'alv',
  'goh' => 'gmw',
  'aul' => 'pqe',
  'mov' => 'hok',
  'ncf' => 'pqe',
  'mte' => 'pqe',
  'vun' => 'bnt',
  'cia' => 'pqw',
  'bdr' => 'pqw',
  'smn' => 'smi',
  'frm' => 'roa',
  'var' => 'azc',
  'ilk' => 'phi',
  'gdo' => 'ccn',
  'thp' => 'sal',
  'ikx' => 'ssa',
  'mta' => 'mno',
  'hed' => 'cdc',
  'chu' => 'zls',
  'bul' => 'zls',
  'mrn' => 'pqe',
  'mcn' => 'cdc',
  'lgn' => 'ssa',
  'puy' => 'hok',
  'smi' => 'fiu',
  'njx' => 'bnt',
  'mnr' => 'azc',
  'odt' => 'gmw',
  'myv' => 'fiu',
  'lmp' => 'alv',
  'akv' => 'ccn',
  'cam' => 'pqe',
  'hur' => 'sal',
  'bsg' => 'ira',
  'peq' => 'hok',
  'has' => 'wak',
  'uga' => 'sem',
  'tpu' => 'mkh',
  'lat' => 'itc',
  'sdc' => 'roa',
  'nob' => 'gmq',
  'rro' => 'pqe',
  'wni' => 'bnt',
  'kcv' => 'bnt',
  'chd' => 'tequ1244',
  'afb' => 'sem',
  'lna' => 'bad',
  'knj' => 'myn',
  'spo' => 'sal',
  'blf' => 'phi',
  'sop' => 'bnt',
  'gjn' => 'alv',
  'ssb' => 'pqw',
  'fmp' => 'bai',
  'brr' => 'pqe',
  'ivv' => 'poz',
  'dop' => 'alv',
  'nsn' => 'pqe',
  'krf' => 'pqe',
  'lot' => 'sdv',
  'ncc' => 'pqe',
  'wbk' => 'iir',
  'clc' => 'ath',
  'apc' => 'sem',
  'bim' => 'alv',
  'ast' => 'roa',
  'bts' => 'btk',
  'kmj' => 'dra',
  'fox' => 'map',
  'xgn' => 'tut',
  'zza' => 'ira',
  'lib' => 'pqe',
  'nua' => 'pqe',
  'tmy' => 'pqe',
  'tio' => 'pqe',
  'pfa' => 'pqe',
  'aba' => 'alv',
  'sdn' => 'roa',
  'oma' => 'sio',
  'tbl' => 'phi',
  'inh' => 'ccn',
  'mnw' => 'mkh',
  'aar' => 'cus',
  'jpx' => 'mul',
  'goo' => 'pqe',
  'wal' => 'omv',
  'dag' => 'alv',
  'ign' => 'awd',
  'mxp' => 'mixe1284',
  'nmn' => 'khi',
  'sto' => 'sio',
  'scb' => 'mkh',
  'jle' => 'kdo',
  'knu' => 'dmn',
  'quc' => 'myn',
  'dun' => 'pqw',
  'bjz' => 'ngf',
  'paw' => 'cdd',
  'sog' => 'ira',
  'rug' => 'pqe',
  'kei' => 'poz',
  'tms' => 'kdo',
  'pam' => 'phi',
  'sbp' => 'bnt',
  'bqh' => 'tbq',
  'avk' => 'art',
  'fiu' => 'urj',
  'gin' => 'ccn',
  'kkk' => 'pqe',
  'got' => 'gme',
  'grz' => 'pqe',
  'ser' => 'azc',
  'ccn' => 'cau',
  'isg' => 'sgn',
  'krj' => 'phi',
  'bmq' => 'alv',
  'tet' => 'plf',
  'kno' => 'dmn',
  'rwm' => 'bnt',
  'kxu' => 'dra',
  'akk' => 'sem',
  'tly' => 'ira',
  'hts' => 'khi',
  'ron' => 'roa',
  'bbj' => 'bai',
  'dal' => 'cus',
  'kax' => 'paa',
  'day' => 'mul',
  'cje' => 'cmc',
  'hch' => 'azc',
  'otk' => 'trk',
  'dhv' => 'pqe',
  'qvn' => 'qwe',
  'fao' => 'gmq',
  'alq' => 'alg',
  'maq' => 'omq',
  'sce' => 'xgn',
  'otd' => 'pqw',
  'nss' => 'pqe',
  'miq' => 'misu1242',
  'tuk' => 'trk',
  'srq' => 'tup',
  'ijc' => 'ijo',
  'tau' => 'ath',
  'fax' => 'roa',
  'lce' => 'pqw',
  'nzi' => 'alv',
  'sag' => 'ngb',
  'cel' => 'ine',
  'kal' => 'esx',
  'poi' => 'mixe1284',
  'kat' => 'ccs',
  'lsa' => 'ira',
  'bwt' => 'bnt',
  'tmi' => 'pqe',
  'sdo' => 'day',
  'pib' => 'awd',
  'lng' => 'gmw',
  'jaz' => 'pqe',
  'ney' => 'kro',
  'mpr' => 'pqe',
  'moa' => 'dmn',
  'adx' => 'tbq',
  'buc' => 'pqw',
  'bhb' => 'inc',
  'gox' => 'bad',
  'mwm' => 'csu',
  'aib' => 'trk',
  'ctu' => 'myn',
  'fab' => 'cpp',
  'ukr' => 'zle',
  'veo' => 'hok',
  'ebr' => 'alv',
  'kgo' => 'kdo',
  'ctg' => 'inc',
  'lpx' => 'sdv',
  'hni' => 'sit',
  'rmv' => 'art',
  'pse' => 'pqw',
  'srm' => 'cpp',
  'avi' => 'alv',
  'eme' => 'tup',
  'mkv' => 'pqe',
  'asm' => 'inc',
  'leu' => 'pqe',
  'fra' => 'roa',
  'ces' => 'zlw',
  'lmo' => 'roa',
  'xxk' => 'poz',
  'hml' => 'hmx',
  'gan' => 'zhx',
  'pnt' => 'grk',
  'ang' => 'gmw',
  'nbl' => 'bnt',
  'abr' => 'alv',
  'wha' => 'plf',
  'gle' => 'cel',
  'sxl' => 'bat',
  'guo' => 'awd',
  'sjm' => 'pqw',
  'wlm' => 'cel',
  'irh' => 'pqe',
  'xwc' => 'sio',
  'scl' => 'inc',
  'doi' => 'inc',
  'cym' => 'cel',
  'tgk' => 'ira',
  'tik' => 'alv',
  'apa' => 'ath',
  'qug' => 'qwe',
  'kvr' => 'pqw',
  'pau' => 'pqw',
  'brg' => 'awd',
  'rom' => 'inc',
  'krx' => 'alv',
  'tay' => 'fox',
  'tey' => 'kdo',
  'qvm' => 'qwe',
  'bja' => 'bnt',
  'lrz' => 'pqe',
  'zne' => 'znd',
  'bgs' => 'mno',
  'tub' => 'azc',
  'wyy' => 'pqe',
  'npn' => 'pqe',
  'mls' => 'ssa',
  'tmh' => 'ber',
  'ijo' => 'alv',
  'aae' => 'sqj',
  'pme' => 'pqe',
  'lyn' => 'bnt',
  'pal' => 'ira',
  'nov' => 'art',
  'ber' => 'afa',
  'quy' => 'qwe',
  'kao' => 'dmn',
  'kqn' => 'bnt',
  'sai' => 'mul',
  'wbl' => 'ira',
  'mxq' => 'mixe1284',
  'bci' => 'alv',
  'kro' => 'alv',
  'nog' => 'tut',
  'orv' => 'zle',
  'gba' => 'alv',
  'seh' => 'bnt',
  'ttv' => 'pqe',
  'ltg' => 'bat',
  'ven' => 'bnt',
  'bqz' => 'bnt',
  'bxg' => 'bnt',
  'xvi' => 'iir',
  'gct' => 'gmw',
  'lil' => 'sal',
  'yaj' => 'bad',
  'fud' => 'pqe',
  'awa' => 'inc',
  'oaa' => 'tuw',
  'gkn' => 'alv',
  'osx' => 'gmw',
  'rak' => 'pqe',
  'emx' => 'inc',
  'tut' => 'mul',
  'cat' => 'roa',
  'bfd' => 'alv',
  'spp' => 'alv',
  'ili' => 'trk',
  'moh' => 'iro',
  'pif' => 'pqe',
  'hbu' => 'plf',
  'que' => 'qwe',
  'lga' => 'pqe',
  'sns' => 'pqe',
  'pgu' => 'paa',
  'xom' => 'ssa',
  'vol' => 'art',
  'ari' => 'cdd',
  'qur' => 'qwe',
  'kua' => 'bnt',
  'erk' => 'pqe',
  'mqk' => 'mno',
  'lmv' => 'pqe',
  'mjv' => 'dra',
  'pbo' => 'alv',
  'hmr' => 'sit',
  'bam' => 'dmn',
  'mai' => 'bih',
  'egl' => 'roa',
  'itz' => 'myn',
  'ood' => 'azc',
  'aql' => 'nai',
  'sgl' => 'ira',
  'sah' => 'trk',
  'afh' => 'art',
  'niq' => 'sdv',
  'gaa' => 'alv',
  'bkm' => 'alv',
  'pus' => 'ira',
  'rou' => 'ssa',
  'mft' => 'pqe',
  'igs' => 'art',
  'mdd' => 'alv',
  'too' => 'toto1251',
  'ccp' => 'inc',
  'soy' => 'alv',
  'qxc' => 'qwe',
  'pli' => 'pra',
  'end' => 'poz',
  'mvo' => 'pqe',
  'rkm' => 'dmn',
  'dma' => 'bnt',
  'sdg' => 'inc',
  'yaq' => 'azc',
  'pao' => 'azc',
  'pha' => 'hmx',
  'kie' => 'ssa',
  'klv' => 'pqe',
  'toq' => 'sdv',
  'wec' => 'kro',
  'mmg' => 'pqe',
  'cai' => 'mul',
  'tyv' => 'trk',
  'slr' => 'trk',
  'bvb' => 'bnt',
  'txg' => 'sit',
  'bzq' => 'pqe',
  'shi' => 'ber',
  'lun' => 'bnt',
  'anp' => 'bih',
  'shx' => 'hmx',
  'pnu' => 'hmx',
  'shy' => 'ber',
  'qxu' => 'qwe',
  'bph' => 'ccn',
  'bcq' => 'omv',
  'tkq' => 'alv',
  'bkz' => 'pqw',
  'cow' => 'sal',
  'bpa' => 'pqe',
  'yee' => 'paa',
  'sev' => 'alv',
  'nga' => 'alv',
  'nub' => 'sdv',
  'bwn' => 'hmx',
  'che' => 'ccn',
  'kcr' => 'kdo',
  'ewe' => 'alv',
  'mwi' => 'pqe',
  'mak' => 'pqw',
  'mhs' => 'plf',
  'pma' => 'pqe',
  'vmg' => 'pqe',
  'tdx' => 'pqw',
  'ary' => 'sem',
  'soi' => 'bih',
  'nrf' => 'roa',
  'tbq' => 'sit',
  'guh' => 'awd',
  'niy' => 'csu',
  'mua' => 'alv',
  'txh' => 'ine',
  'mey' => 'sem',
  'lrv' => 'pqe',
  'ita' => 'roa',
  'scx' => 'ine',
  'mco' => 'mixe1284',
  'uby' => 'ccn',
  'jgo' => 'bai',
  'amw' => 'sem',
  'len' => 'cai',
  'yal' => 'dmn',
  'bho' => 'bih',
  'pel' => 'pqw',
  'blr' => 'mkh',
  'pag' => 'phi',
  'koy' => 'ath',
  'ist' => 'roa',
  'srd' => 'roa',
  'onu' => 'pqe',
  'nap' => 'roa',
  'ltc' => 'zhx',
  'kcp' => 'kdo',
  'apj' => 'apa',
  'kra' => 'bih',
  'mra' => 'mkh',
  'mjg' => 'xgn',
  'wae' => 'gmw',
  'skr' => 'inc',
  'tgx' => 'ath',
  'nnc' => 'cdc',
  'mdw' => 'bnt',
  'mee' => 'pqe',
  'cup' => 'azc',
  'yid' => 'gmw',
  'btx' => 'btk',
  'toto1251' => 'cai',
  'tlv' => 'plf',
  'kkz' => 'ath',
  'vep' => 'fiu',
  'sov' => 'pqe',
  'cus' => 'afa',
  'smr' => 'pqw',
  'zoq' => 'mixe1284',
  'iku' => 'esx',
  'tif' => 'paa',
  'hsn' => 'zhx',
  'bal' => 'ira',
  'myn' => 'cai',
  'wuu' => 'zhx',
  'zho' => 'zhx',
  'acr' => 'myn',
  'mnc' => 'tuw',
  'plq' => 'ine',
  'ybb' => 'bai',
  'nia' => 'pqw',
  'arz' => 'sem',
  'pqw' => 'poz',
  'xbp' => 'aus',
  'tkp' => 'pqe',
  'roh' => 'roa',
  'chm' => 'fiu',
  'mye' => 'bnt',
  'qul' => 'qwe',
  'zuh' => 'paa',
  'cro' => 'sio',
  'xmv' => 'pqw',
  'duu' => 'tbq',
  'hvv' => 'cai',
  'pku' => 'pqw',
  'swa' => 'swa',
  'bbl' => 'ccn',
  'yap' => 'pqe',
  'sas' => 'pqw',
  'nba' => 'bnt',
  'tnr' => 'alv',
  'nai' => 'mul',
  'tdn' => 'phi',
  'cpg' => 'grk',
  'syc' => 'sem',
  'udu' => 'ssa',
  'liv' => 'fiu',
  'gmw' => 'gem',
  'sba' => 'csu',
  'tac' => 'azc',
  'sdv' => 'ssa',
  'azc' => 'cai',
  'kdh' => 'alv',
  'dws' => 'art',
  'art' => 'mul',
  'yav' => 'alv',
  'ntp' => 'azc',
  'qvy' => 'sit',
  'kld' => 'aus',
  'huq' => 'cmc',
  'ple' => 'poz',
  'xga' => 'cel',
  'sat' => 'mun',
  'ibl' => 'phi',
  'kck' => 'bnt',
  'gmq' => 'gem',
  'bot' => 'csu',
  'eng' => 'gmw',
  'dtd' => 'wak',
  'mor' => 'kdo',
  'fry' => 'gmw',
  'xpg' => 'ine',
  'fro' => 'roa',
  'hun' => 'fiu',
  'mek' => 'pqe',
  'bcm' => 'pqe',
  'nnh' => 'bai',
  'tus' => 'iro',
  'orr' => 'ijo',
  'guj' => 'inc',
  'mwo' => 'pqe',
  'zbl' => 'art',
  'kak' => 'phi',
  'ath' => 'xnd',
  'mal' => 'dra',
  'heh' => 'bnt',
  'goy' => 'alv',
  'btm' => 'btk',
  'abi' => 'alv',
  'inp' => 'awd',
  'kqw' => 'pqe',
  'qvo' => 'qwe',
  'heb' => 'sem',
  'dai' => 'alv',
  'sid' => 'cus',
  'kln' => 'sdv',
  'suk' => 'bnt',
  'lid' => 'pqe',
  'aze' => 'trk',
  'psm' => 'tup',
  'gem' => 'ine',
  'trn' => 'awd',
  'srr' => 'alv',
  'tup' => 'sai',
  'thq' => 'bih',
  'dyo' => 'alv',
  'mrv' => 'pqe',
  'tox' => 'pqe',
  'hoo' => 'bnt',
  'nhd' => 'tup',
  'bid' => 'cdc',
  'unr' => 'mun',
  'khw' => 'inc',
  'tsz' => 'cai',
  'tlm' => 'pqe',
  'sea' => 'mkh',
  'xeb' => 'sem',
  'aru' => 'auf',
  'urj' => 'mul',
  'pfl' => 'gmw',
  'gwi' => 'ath',
  'phi' => 'pqw',
  'kec' => 'kdo',
  'sma' => 'smi',
  'kma' => 'alv',
  'duq' => 'pqw',
  'urd' => 'inc',
  'coc' => 'hok',
  'aht' => 'ath',
  'lik' => 'bnt',
  'qvc' => 'qwe',
  'cjm' => 'cmc',
  'ile' => 'art',
  'yly' => 'pqe',
  'sht' => 'hok',
  'hoa' => 'pqe',
  'kyr' => 'tup',
  'kvh' => 'poz',
  'gei' => 'pqe',
  'ldm' => 'alv',
  'ben' => 'inc',
  'rcf' => 'cpf',
  'hah' => 'pqe',
  'bnq' => 'phi',
  'prn' => 'iir',
  'aia' => 'pqe',
  'gui' => 'tup',
  'ksh' => 'gmw',
  'rar' => 'pqe',
  'lre' => 'iro',
  'adj' => 'alv',
  'mns' => 'fiu',
  'omq' => 'cai',
  'tgs' => 'pqe',
  'mog' => 'phi',
  'omv' => 'afa',
  'clm' => 'sal',
  'nem' => 'pqe',
  'wym' => 'gmw',
  'btb' => 'bnt',
  'xgf' => 'azc',
  'tsj' => 'sit',
  'wiv' => 'pqe',
  'cjk' => 'bnt',
  'alt' => 'trk',
  'bra' => 'inc',
  'otm' => 'oto',
  'qwa' => 'qwe',
  'ilo' => 'phi',
  'bqc' => 'dmn',
  'ayb' => 'alv',
  'str' => 'sal',
  'fit' => 'fiu',
  'kon' => 'bnt',
  'bkh' => 'bnt',
  'tpj' => 'tup',
  'sda' => 'pqw',
  'qwm' => 'trk',
  'klb' => 'hok',
  'deu' => 'gmw',
  'shr' => 'bnt',
  'omb' => 'pqe',
  'smw' => 'pqw',
  'gak' => 'paa',
  'iai' => 'pqe',
  'stw' => 'pqe',
  'bpd' => 'bad',
  'aol' => 'poz',
  'sot' => 'bnt',
  'bjo' => 'bad',
  'rad' => 'cmc',
  'new' => 'sit',
  'kjk' => 'pqw',
  'mbt' => 'mno',
  'pra' => 'inc',
  'psw' => 'pqe',
  'snl' => 'phi',
  'osa' => 'sio',
  'ats' => 'alg',
  'fon' => 'alv',
  'her' => 'bnt',
  'qux' => 'qwe',
  'mtn' => 'misu1242',
  'sga' => 'cel',
  'inz' => 'hok',
  'orh' => 'tuw',
  'ahb' => 'pqe',
  'poh' => 'myn',
  'xkg' => 'dmn',
  'tql' => 'pqe',
  'xin' => 'cai',
  'ota' => 'trk',
  'sgc' => 'sdv',
  'abs' => 'pqw',
  'hif' => 'bih',
  'oku' => 'alv',
  'cmc' => 'pqw',
  'mga' => 'cel',
  'syr' => 'sem',
  'tpw' => 'tup',
  'tll' => 'bnt',
  'ktn' => 'tup',
  'ane' => 'pqe',
  'amv' => 'plf',
  'bae' => 'awd',
  'kyw' => 'bih',
  'oac' => 'tuw',
  'lui' => 'azc',
  'qva' => 'qwe',
  'zbe' => 'pqw',
  'myl' => 'pqw',
  'inj' => 'qwe',
  'ulw' => 'misu1242',
  'peh' => 'xgn',
  'cac' => 'myn',
  'tzm' => 'ber',
  'swx' => 'auf',
  'nyf' => 'bnt',
  'app' => 'pqe',
  'bsq' => 'kro',
  'pmq' => 'omq',
  'mqy' => 'poz',
  'ton' => 'pqe',
  'iba' => 'pqw',
  'fia' => 'nub',
  'brx' => 'tbq',
  'tog' => 'nic',
  'mxe' => 'pqe',
  'kau' => 'ssa',
  'xcu' => 'bat',
  'erg' => 'pqe',
  'kic' => 'alg',
  'kys' => 'pqw',
  'mhb' => 'bnt',
  'tnt' => 'phi',
  'fcs' => 'sgn',
  'swp' => 'pqe',
  'gez' => 'sem',
  'abx' => 'pqw',
  'bxf' => 'pqe',
  'dim' => 'omv',
  'rka' => 'mkh',
  'nya' => 'bnt',
  'xce' => 'cel',
  'anm' => 'tbq',
  'mse' => 'cdc',
  'zul' => 'bnt',
  'kjc' => 'pqw',
  'guc' => 'awd',
  'bko' => 'bai',
  'isl' => 'gmq',
  'sel' => 'syd',
  'nxe' => 'poz',
  'zap' => 'omq',
  'krc' => 'trk',
  'gal' => 'plf',
  'bju' => 'alv',
  'kjj' => 'ccn',
  'gri' => 'pqe',
  'kjg' => 'mkh',
  'naq' => 'khi',
  'bak' => 'trk',
  'pkn' => 'aus',
  'hyw' => 'hyx',
  'gdd' => 'pqe',
  'bnk' => 'pqe',
  'mfe' => 'cpf',
  'mhj' => 'xgn',
  'mqm' => 'pqe',
  'est' => 'fiu',
  'crs' => 'cpf',
  'tum' => 'bnt',
  'myu' => 'tup',
  'hac' => 'ira',
  'baa' => 'pqe',
  'gdq' => 'sem',
  'ssn' => 'cus',
  'lcm' => 'pqe',
  'tbe' => 'pqe',
  'ojs' => 'alg',
  'mna' => 'pqe',
  'mmt' => 'pqe',
  'tuq' => 'ssa',
  'ace' => 'cmc',
  'kdr' => 'trk',
  'btr' => 'pqe',
  'kqr' => 'pqw',
  'sne' => 'day',
  'yue' => 'zhx',
  'acz' => 'kdo',
  'doz' => 'omv',
  'tee' => 'toto1251',
  'gay' => 'pqw',
  'tlx' => 'pqe',
  'keu' => 'alv',
  'hil' => 'phi',
  'nen' => 'pqe',
  'zim' => 'cdc',
  'mme' => 'pqe',
  'ktq' => 'pqw',
  'hrw' => 'pqe',
  'nav' => 'apa',
  'faf' => 'pqe',
  'woe' => 'pqe',
  'uzs' => 'trk',
  'aau' => 'paa',
  'ori' => 'inc',
  'bkk' => 'inc',
  'haa' => 'ath',
  'ale' => 'esx',
  'mah' => 'bih',
  'slz' => 'pqe',
  'yij' => 'aus',
  'msa' => 'pqw',
  'srp' => 'zls',
  'usp' => 'myn',
  'pia' => 'azc',
  'lgl' => 'pqe',
  'kfa' => 'dra',
  'huz' => 'ccn',
  'beg' => 'pqw',
  'tos' => 'toto1251',
  'vrs' => 'pqe',
  'hoc' => 'mun',
  'sbc' => 'pqe',
  'urv' => 'pqe',
  'mmy' => 'cdc',
  'nyn' => 'bnt',
  'som' => 'cus',
  'bez' => 'bnt',
  'dur' => 'alv',
  'alg' => 'aql',
  'bsh' => 'iir',
  'hns' => 'bih',
  'vma' => 'aus',
  'tli' => 'xnd',
  'mjt' => 'dra',
  'bdg' => 'pqw',
  'ltz' => 'gmw',
  'dmn' => 'nic',
  'aut' => 'pqe',
  'xho' => 'bnt',
  'bzh' => 'pqe',
  'tvk' => 'pqe',
  'pol' => 'zlw',
  'bjn' => 'pqw',
  'shz' => 'alv',
  'cay' => 'iro',
  'mxr' => 'pqw',
  'mqa' => 'pqe',
  'fla' => 'sal',
  'pmz' => 'omq',
  'knf' => 'alv',
  'lus' => 'sit',
  'mla' => 'pqe',
  'atd' => 'mno',
  'tha' => 'tai',
  'ttc' => 'myn',
  'ccs' => 'cau',
  'run' => 'bnt',
  'kaw' => 'pqw',
  'euq' => 'mul',
  'mam' => 'myn',
  'lgr' => 'pqe',
  'lfn' => 'art',
  'snd' => 'inc',
  'gil' => 'pqe',
  'qvl' => 'qwe',
  'mlu' => 'pqe',
  'ddd' => 'sdv',
  'tcm' => 'paa',
  'olr' => 'pqe',
  'zay' => 'omv',
  'unm' => 'alg',
  'shw' => 'kdo',
  'sij' => 'pqe',
  'aqa' => 'sai',
  'sqn' => 'iro',
  'mon' => 'xgn',
  'jdt' => 'ira',
  'bbh' => 'mkh',
  'cdo' => 'zhx',
  'mrq' => 'pqe',
  'bel' => 'zle',
  'bvd' => 'pqe',
  'afr' => 'gmw',
  'lit' => 'bat',
  'mer' => 'bnt',
  'smp' => 'sem',
  'mad' => 'pqw',
  'anc' => 'cdc',
  'mwr' => 'inc',
  'gcf' => 'cpf',
  'nha' => 'aus',
  'stp' => 'azc',
  'mhq' => 'sio',
  'crc' => 'pqe',
  'qve' => 'qwe',
  'trv' => 'fox',
  'tth' => 'aav',
  'sme' => 'smi',
  'mrm' => 'pqe',
  'isk' => 'ira',
  'kom' => 'fiu',
  'nkx' => 'ijo',
  'lbx' => 'pqw',
  'phl' => 'inc',
  'ogc' => 'alv',
  'bzg' => 'fox',
  'bas' => 'bnt',
  'nwi' => 'pqe',
  'lua' => 'bnt',
  'luo' => 'sdv',
  'pov' => 'cpp',
  'quz' => 'qwe',
  'cre' => 'alg',
  'lcf' => 'pqw',
  'yua' => 'myn',
  'umb' => 'bnt',
  'wlc' => 'bnt',
  'acv' => 'hok',
  'uge' => 'pqe',
  'xve' => 'ine',
  'pos' => 'mixe1284',
  'mml' => 'mkh',
  'bnn' => 'fox',
  'tag' => 'kdo',
  'poz' => 'map',
  'xfa' => 'itc',
  'kmb' => 'bnt',
  'aua' => 'pqe',
  'tne' => 'phi',
  'hnj' => 'hmx',
  'tlo' => 'kdo',
  'eyo' => 'sdv',
  'qxo' => 'qwe',
  'sia' => 'smi',
  'mmw' => 'pqe',
  'tkr' => 'ccn',
  'lld' => 'roa',
  'mhn' => 'gmw',
  'mrc' => 'hok',
  'tva' => 'pqe',
  'uig' => 'trk',
  'mky' => 'pqe',
  'kru' => 'dra',
  'koq' => 'bnt',
  'duw' => 'pqw',
  'aus' => 'mul',
  'rej' => 'pqw',
  'sus' => 'dmn',
  'nal' => 'pqe',
  'lmg' => 'pqe',
  'tequ1244' => 'cai',
  'bla' => 'alg',
  'ncb' => 'mkh',
  'qwh' => 'qwe',
  'ldn' => 'art',
  'pio' => 'awd',
  'oyb' => 'mkh',
  'she' => 'omv',
  'tir' => 'sem',
  'tom' => 'phi',
  'txb' => 'ine',
  'mun' => 'aav',
  'ddj' => 'aus',
  'hop' => 'azc',
  'llu' => 'pqe',
  'tzl' => 'art',
  'cdc' => 'afa',
  'bdk' => 'ccn',
  'prc' => 'ira',
  'frt' => 'pqe',
  'jbe' => 'ber',
  'eka' => 'nic',
  'bem' => 'bnt',
  'sun' => 'pqw',
  'khl' => 'pqe',
  'nlg' => 'pqe',
  'gur' => 'alv',
  'lml' => 'pqe',
  'aii' => 'sem',
  'tft' => 'paa',
  'kaz' => 'trk',
  'wls' => 'pqe',
  'smm' => 'bih',
  'kij' => 'pqe',
  'bdh' => 'csu',
  'crx' => 'ath',
  'yor' => 'alv',
  'ccr' => 'misu1242',
  'ipk' => 'esx',
  'ems' => 'ypk',
  'ext' => 'roa',
  'sbb' => 'pqe',
  'czn' => 'omq',
  'sgz' => 'pqe',
  'bsc' => 'alv',
  'lht' => 'pqe',
  'kzc' => 'alv',
  'mep' => 'aus',
  'agq' => 'alv',
  'szn' => 'plf',
  'sva' => 'ccs',
  'lch' => 'bnt',
  'tyh' => 'mkh',
  'tbz' => 'alv',
  'apb' => 'pqe',
  'sin' => 'inc',
  'beh' => 'alv',
  'guk' => 'ssa',
  'tkt' => 'bih',
  'bpy' => 'inc',
  'har' => 'sem',
  'pcj' => 'mun',
  'ndv' => 'alv',
  'uhn' => 'ngf',
  'snv' => 'pqw',
  'tae' => 'awd',
  'bxe' => 'afa',
  'mmr' => 'hmx',
  'mni' => 'sit',
  'jrb' => 'sem',
  'ypk' => 'esx',
  'agw' => 'pqe',
  'kuu' => 'ath',
  'ful' => 'alv',
  'bvc' => 'pqe',
  'grc' => 'grk',
  'asb' => 'sio',
  'izh' => 'fiu',
  'lbe' => 'ccn',
  'alo' => 'plf',
  'bin' => 'alv',
  'rap' => 'pqe',
  'daa' => 'cdc',
  'kzu' => 'pqe',
  'mlt' => 'sem',
  'myb' => 'csu',
  'dua' => 'bnt',
  'mzn' => 'ira',
  'bng' => 'bnt',
  'mrj' => 'fiu',
  'ree' => 'pqw',
  'ulu' => 'pqw',
  'snq' => 'bnt',
  'dsb' => 'wen',
  'ppn' => 'pqe',
  'xsr' => 'sit',
  'nyl' => 'aav',
  'jaj' => 'pqe',
  'qub' => 'qwe',
  'ghn' => 'pqe',
  'ksd' => 'pqe',
  'evn' => 'tuw',
  'chv' => 'trk',
  'hve' => 'cai',
  'tef' => 'mkh',
  'xlc' => 'ine',
  'mvf' => 'xgn',
  'haz' => 'ira',
  'nmy' => 'sit',
  'pil' => 'alv',
  'mui' => 'pqw',
  'bod' => 'tbq',
  'nnz' => 'bai',
  'iof' => 'kdo',
  'udm' => 'fiu',
  'ara' => 'sem',
  'agu' => 'myn',
  'iru' => 'dra',
  'yky' => 'alv',
  'mnv' => 'pqe',
  'mfa' => 'pqw',
  'buh' => 'hmx',
  'fip' => 'bnt',
  'xld' => 'ine',
  'mas' => 'sdv',
  'gly' => 'ssa',
  'nuu' => 'bad',
  'bib' => 'dmn',
  'ler' => 'pqe',
  'snf' => 'alv',
  'ttu' => 'pqe',
  'zoc' => 'mixe1284',
  'ava' => 'ccn',
  'tuz' => 'alv',
  'men' => 'dmn',
  'bnt' => 'alv',
  'hmn' => 'hmx',
  'yej' => 'grk',
  'por' => 'roa',
  'zos' => 'mixe1284',
  'bwd' => 'pqe',
  'lpa' => 'pqe',
  'uve' => 'pqe',
  'ame' => 'awd',
  'gme' => 'gem',
  'tzh' => 'myn',
  'uzb' => 'trk',
  'inb' => 'qwe',
  'sxr' => 'fox',
  'qxr' => 'qwe',
  'sii' => 'mkh',
  'teu' => 'ssa',
  'bex' => 'csu',
  'hue' => 'cai',
  'shh' => 'azc',
  'shk' => 'sdv',
  'gyr' => 'tup',
  'kdd' => 'aus',
  'nah' => 'azc',
  'oji' => 'alg',
  'kcy' => 'son',
  'vec' => 'roa',
  'zea' => 'gmw',
  'hiw' => 'pqe',
  'ngb' => 'alv',
  'squ' => 'sal',
  'pyu' => 'fox',
  'qua' => 'sio',
  'pre' => 'cpp',
  'yrk' => 'syd',
  'beb' => 'bnt',
  'bbp' => 'bad',
  'tsu' => 'fox',
  'kxs' => 'xgn',
  'kje' => 'plf',
  'hbn' => 'kdo',
  'fod' => 'alv',
  'nla' => 'bai',
  'nyo' => 'nic',
  'zor' => 'mixe1284',
  'qvz' => 'qwe',
  'msb' => 'phi',
  'tcb' => 'ath',
  'cop' => 'afa',
  'ssf' => 'fox',
  'ing' => 'ath',
  'haw' => 'pqe',
  'piu' => 'aus',
  'ify' => 'phi',
  'hlu' => 'ine',
  'ndf' => 'bat',
  'ibo' => 'alv',
  'kpc' => 'awd',
  'hyx' => 'ine',
  'rmg' => 'gmq',
  'gfk' => 'pqe',
  'taz' => 'kdo',
  'bqj' => 'alv',
  'luy' => 'bnt',
  'laf' => 'kdo',
  'bhc' => 'pqe',
  'cim' => 'gmw',
  'btd' => 'btk',
  'nrm' => 'pqw',
  'saj' => 'paa',
  'nxq' => 'sit',
  'muz' => 'sdv',
  'mos' => 'alv',
  'mlf' => 'mkh',
  'top' => 'toto1251',
  'asz' => 'pqe',
  'tnk' => 'pqe',
  'anu' => 'sdv',
  'pqe' => 'poz',
  'apr' => 'pqe',
  'byn' => 'cus',
  'koo' => 'bnt',
  'srs' => 'ath',
  'lzz' => 'ccs',
  'yec' => 'gmw',
  'grn' => 'tup',
  'keo' => 'sdv',
  'caf' => 'ath',
  'bje' => 'hmx',
  'bcu' => 'pqe',
  'xco' => 'ira',
  'kwz' => 'khi',
  'ddn' => 'son',
  'arq' => 'sem',
  'epo' => 'art',
  'ptp' => 'pqe',
  'nrc' => 'cel',
  'blp' => 'pqe',
  'sjo' => 'tuw',
  'mlv' => 'pqe',
  'tbf' => 'pqe',
  'ktm' => 'pqe',
  'loj' => 'pqe',
  'col' => 'sal',
  'wli' => 'paa',
  'bda' => 'alv',
  'zhx' => 'sit',
  'zty' => 'omq',
  'sac' => 'alg',
  'nds' => 'gmw',
  'cji' => 'ccn',
  'sxn' => 'phi',
  'czk' => 'zlw',
  'tbr' => 'kdo',
  'sna' => 'bnt',
  'bik' => 'phi',
  'mdx' => 'omv',
  'khi' => 'mul',
  'pan' => 'inc',
  'brf' => 'bnt',
  'kha' => 'mkh',
  'kyk' => 'phi',
  'tpr' => 'tup',
  'ply' => 'mkh',
  'guz' => 'bnt',
  'ina' => 'art',
  'sgs' => 'bat',
  'dgr' => 'ath',
  'qxn' => 'qwe',
  'sla' => 'ine',
  'pgk' => 'pqe',
  'hoi' => 'xnd',
  'zwa' => 'afa',
  'dan' => 'gmq',
  'mia' => 'alg',
  'mxb' => 'omq',
  'amh' => 'sem',
  'poc' => 'myn',
  'rml' => 'inc',
  'kho' => 'ira',
  'rgn' => 'roa',
  'cbn' => 'mkh',
  'goa' => 'dmn',
  'ycn' => 'awd',
  'gqi' => 'tbq',
  'axm' => 'hyx',
  'ewo' => 'bnt',
  'swb' => 'bnt',
  'bno' => 'phi',
  'ksg' => 'pqe',
  'meu' => 'pqe',
  'sqo' => 'ira',
  'tcx' => 'dra',
  'twy' => 'pqw',
  'alc' => 'aqa',
  'gor' => 'phi',
  'xsm' => 'alv',
  'qxa' => 'qwe',
  'pxm' => 'mixe1284',
  'wak' => 'nai',
  'ajt' => 'sem',
  'xbm' => 'cel',
  'jav' => 'pqw',
  'clo' => 'tequ1244',
  'kws' => 'bnt',
  'bre' => 'cel',
  'mxi' => 'roa',
  'alm' => 'pqe',
  'zls' => 'sla',
  'gmb' => 'pqe',
  'qya' => 'art',
  'oto' => 'omq',
  'kea' => 'cpp',
  'xpr' => 'ira',
  'nnb' => 'bnt',
  'xsd' => 'ine',
  'txy' => 'pqw',
  'sje' => 'smi',
  'obo' => 'mno',
  'bgt' => 'pqe',
  'fij' => 'pqe',
  'mhw' => 'bnt',
  'ysr' => 'esx',
  'tkw' => 'pqe',
  'ebu' => 'bnt',
  'qxp' => 'qwe',
  'kge' => 'pqw',
  'bua' => 'xgn',
  'kim' => 'trk',
  'qud' => 'qwe',
  'iro' => 'nai',
  'lam' => 'nic',
  'tqp' => 'pqe',
  'tnl' => 'pqe',
  'kva' => 'ccn',
  'mhe' => 'mkh',
  'crz' => 'hok',
  'drg' => 'pqw',
  'koi' => 'fiu',
  'bqk' => 'bad',
  'bgk' => 'mkh',
  'kpt' => 'ccn',
  'vif' => 'bnt',
  'led' => 'csu',
  'mpu' => 'tup',
  'ckv' => 'fox',
  'yka' => 'pqw',
  'los' => 'pqe',
  'lbv' => 'pqe',
  'kxl' => 'dra',
  'pbp' => 'alv',
  'misu1242' => 'cai',
  'anz' => 'paa',
  'tfi' => 'alv',
  'mnp' => 'zhx',
  'kjb' => 'myn',
  'tmb' => 'pqe',
  'aav' => 'mul',
  'mln' => 'pqe',
  'fsl' => 'sgn',
  'yai' => 'ira',
  'bkc' => 'alv',
  'chg' => 'trk',
  'mrl' => 'pqe',
  'ixc' => 'omq',
  'kab' => 'ber',
  'lky' => 'sdv',
  'toi' => 'bnt',
  'cak' => 'myn',
  'dlm' => 'roa',
  'mok' => 'paa',
  'nqo' => 'nic',
  'ude' => 'tuw',
  'sjn' => 'art',
  'urh' => 'alv',
  'tin' => 'ccn',
  'tdi' => 'pqw',
  'cou' => 'alv',
  'sqj' => 'ine',
  'cuy' => 'cai',
  'rth' => 'phi',
  'llf' => 'pqe',
  'nms' => 'pqe',
  'ley' => 'pqw',
  'kzk' => 'pqe',
  'glv' => 'cel',
  'tar' => 'azc',
  'mkj' => 'pqe',
  'cco' => 'omq',
  'kum' => 'trk',
  'kbm' => 'pqe',
  'btz' => 'btk',
  'rmq' => 'inc',
  'wti' => 'ssa',
  'huv' => 'cai',
  'gxx' => 'kro',
  'apk' => 'apa',
  'ndo' => 'bnt',
  'kwk' => 'wak',
  'qvw' => 'qwe',
  'sqi' => 'sqj',
  'kbl' => 'ssa',
  'mhi' => 'csu',
  'ddg' => 'paa',
  'rwk' => 'bnt',
  'byv' => 'bai',
  'eli' => 'kdo',
  'nuw' => 'pqe',
  'mhy' => 'pqw',
  'xas' => 'syd',
  'mgh' => 'bnt',
  'paa' => 'mul',
  'rif' => 'ber',
  'qvp' => 'qwe',
  'agx' => 'ccn',
  'xzm' => 'bat',
  'ksb' => 'bnt',
  'coz' => 'omq',
  'dak' => 'sio',
  'szw' => 'pqe',
  'stq' => 'gmw',
  'awd' => 'sai',
  'tpz' => 'pqe',
  'wol' => 'alv',
  'del' => 'alg',
  'mdj' => 'csu',
  'lah' => 'inc',
  'ngl' => 'bnt',
  'pwn' => 'fox',
  'cae' => 'alv',
  'ban' => 'pqw',
  'dyu' => 'dmn',
  'xpq' => 'alg',
  'xum' => 'itc',
  'akl' => 'phi',
  'gon' => 'dra',
  'wow' => 'pqw',
  'atw' => 'hok',
  'bfa' => 'sdv',
  'aca' => 'awd',
  'rmt' => 'inc',
  'zlw' => 'sla',
  'ndc' => 'bnt',
  'frk' => 'gmw',
  'mwh' => 'pqe',
  'oci' => 'roa',
  'kdo' => 'nic',
  'wci' => 'alv',
  'kin' => 'bnt',
  'tao' => 'poz',
  'the' => 'bih',
  'ess' => 'ypk',
  'twm' => 'tbq',
  'sms' => 'smi',
  'sbh' => 'pqe',
  'lek' => 'pqe',
  'cwg' => 'mkh',
  'skf' => 'tup',
  'azb' => 'trk',
  'vmk' => 'bnt',
  'akb' => 'btk',
  'wya' => 'iro',
  'pug' => 'alv',
  'gzn' => 'pqe',
  'bej' => 'cus',
  'als' => 'sqj',
  'bch' => 'pqe',
  'abb' => 'bnt',
  'xtc' => 'kdo',
  'ach' => 'sdv',
  'xpi' => 'cel',
  'nde' => 'bnt',
  'lgk' => 'pqe',
  'trs' => 'omq',
  'tcy' => 'dra',
  'quw' => 'qwe',
  'zuy' => 'cdc',
  'xmg' => 'bai',
  'skh' => 'pqw',
  'mlq' => 'dmn',
  'bns' => 'inc',
  'hmx' => 'mul',
  'arg' => 'roa',
  'wam' => 'alg',
  'lbn' => 'mkh',
  'kas' => 'inc',
  'jct' => 'trk',
  'nza' => 'alv',
  'hrv' => 'zls',
  'com' => 'azc',
  'neu' => 'art',
  'yur' => 'aql',
  'kia' => 'alv',
  'bxa' => 'pqe',
  'mtd' => 'pqw',
  'arc' => 'sem',
  'tem' => 'alv',
  'hro' => 'cmc',
  'jac' => 'myn',
  'irk' => 'cus',
  'mde' => 'ssa',
  'lav' => 'bat',
  'tdu' => 'pqw',
  'sol' => 'pqe',
  'crp' => 'mul',
  'kap' => 'ccn',
  'ije' => 'ijo',
  'mzq' => 'pqw',
  'moe' => 'alg',
  'tdb' => 'bih',
  'tuw' => 'tut',
  'twq' => 'son',
  'tmc' => 'cdc',
  'grt' => 'sit',
  'kpg' => 'pqe',
  'goq' => 'pqw',
  'vra' => 'pqe',
  'njm' => 'sit',
  'far' => 'pqe',
  'was' => 'hok',
  'dje' => 'son',
  'tzo' => 'myn',
  'fuj' => 'kdo',
  'dzg' => 'ssa',
  'vwa' => 'mkh',
  'gej' => 'alv',
  'zmz' => 'bad',
  'yum' => 'hok',
  'lnd' => 'map',
  'ijs' => 'ijo',
  'yuy' => 'xgn',
  'koa' => 'pqe',
  'kss' => 'alv',
  'uun' => 'fox',
  'upv' => 'pqe',
  'ojw' => 'alg',
  'eno' => 'pqw',
  'bni' => 'bnt',
  'tpp' => 'toto1251',
  'dgg' => 'pqe',
  'tuv' => 'sdv',
  'ium' => 'hmx',
  'tqt' => 'toto1251',
  'oru' => 'ira',
  'miz' => 'omq',
  'osp' => 'roa',
  'nnd' => 'pqe',
  'nie' => 'alv',
  'oss' => 'ira',
  'mzs' => 'cpp',
  'zle' => 'sla',
  'nmb' => 'pqe',
  'czo' => 'zhx',
  'bum' => 'bnt',
  'hok' => 'cai',
  'oka' => 'sal',
  'kok' => 'inc',
  'kdk' => 'pqe',
  'qvh' => 'qwe',
  'aud' => 'pqe',
  'uuu' => 'mkh',
  'nwc' => 'sit',
  'chr' => 'iro',
  'orm' => 'cus',
  'pot' => 'alg',
  'sgy' => 'ira',
  'xsi' => 'pqe',
  'chp' => 'ath',
  'gux' => 'alv',
  'lom' => 'dmn',
  'chl' => 'azc',
  'smy' => 'ira',
  'bpn' => 'hmx',
  'hat' => 'cpf',
  'tbc' => 'pqe',
  'bdl' => 'pqw',
  'xnh' => 'mkh',
  'irr' => 'aav',
  'clw' => 'trk',
  'mjz' => 'bih',
  'cdd' => 'nai',
  'nuy' => 'aus',
  'yao' => 'bnt',
  'nmk' => 'pqe',
  'enm' => 'gmw',
  'enb' => 'sdv',
  'kji' => 'pqe',
  'apl' => 'apa',
  'urr' => 'pqe',
  'trk' => 'tut',
  'war' => 'phi',
  'bgj' => 'alv',
  'fin' => 'fiu',
  'aqc' => 'ccn',
  'mir' => 'mixe1284',
  'vro' => 'fiu',
  'ckb' => 'ira',
  'jnj' => 'omv',
  'dav' => 'bnt',
  'abu' => 'alv',
  'tuy' => 'sdv',
  'sgh' => 'ira',
  'wic' => 'cdd',
  'frr' => 'gmw',
  'nee' => 'pqe',
  'mxj' => 'tbq',
  'qxh' => 'qwe',
  'lin' => 'bnt',
  'kfc' => 'dra',
  'rri' => 'pqe',
  'ald' => 'kro',
  'kaa' => 'trk',
  'xkq' => 'pqw',
  'jpn' => 'jpx',
  'gwt' => 'inc',
  'sjr' => 'pqe',
  'cal' => 'pqe',
  'prk' => 'mkh',
  'kbd' => 'ccn',
  'mvy' => 'inc',
  'esx' => 'mul',
  'ggt' => 'pqe',
  'sku' => 'pqe',
  'hei' => 'wak',
  'spx' => 'itc',
  'mdh' => 'phi',
  'mwk' => 'dmn',
  'tbj' => 'pqe',
  'eko' => 'bnt',
  'caq' => 'mkh',
  'rup' => 'roa',
  'tku' => 'toto1251',
  'siy' => 'ira',
  'xpc' => 'trk',
  'lob' => 'alv',
  'peb' => 'hok',
  'myk' => 'alv',
  'gsw' => 'gmw',
  'mtt' => 'pqe',
  'iii' => 'sit',
  'one' => 'iro',
  'kxd' => 'pqw',
  'din' => 'sdv',
  'yan' => 'misu1242',
  'cau' => 'mul',
  'bkd' => 'mno',
  'mfb' => 'pqw',
  'sgd' => 'phi',
  'wwa' => 'alv',
  'vnm' => 'pqe',
  'gag' => 'trk',
  'pom' => 'hok',
  'toj' => 'myn',
  'mji' => 'hmx',
  'nsg' => 'sdv',
  'mzm' => 'alv',
  'kbp' => 'alv',
  'lmd' => 'kdo',
  'div' => 'inc',
  'kyj' => 'phi',
  'kvc' => 'pqe',
  'tkl' => 'pqe',
  'xpu' => 'sem',
  'txs' => 'phi',
  'pua' => 'cai',
  'sse' => 'pqw',
  'ktz' => 'khi',
  'rng' => 'bnt',
  'pmt' => 'pqe',
  'bug' => 'pqw',
  'lww' => 'pqe',
  'xmm' => 'cpp',
  'ssy' => 'cus',
  'svx' => 'bat',
  'sya' => 'pqw',
  'tla' => 'azc',
  'lkn' => 'pqe',
  'mbp' => 'cba',
  'slv' => 'zls',
  'raz' => 'pqw',
  'xbr' => 'poz',
  'ora' => 'pqe',
  'bfl' => 'bad',
  'sio' => 'nai',
  'cnu' => 'ber',
  'atj' => 'alg',
  'lub' => 'bnt',
  'slm' => 'pqw',
  'qxw' => 'qwe',
  'arv' => 'cus',
  'qum' => 'myn',
  'ell' => 'grk',
  'kmo' => 'paa',
  'pry' => 'mkh',
  'aiw' => 'omv',
  'eya' => 'xnd',
  'mfy' => 'azc',
  'nci' => 'nah',
  'qup' => 'qwe',
  'acf' => 'cpf',
  'pms' => 'roa',
  'tpv' => 'pqe',
  'wiy' => 'aql',
  'llk' => 'pqw',
  'kuw' => 'bad',
  'dec' => 'kdo',
  'tso' => 'bnt',
  'twt' => 'tup',
  'qus' => 'qwe',
  'obi' => 'hok',
  'lhu' => 'tbq',
  'tta' => 'sio',
  'ngr' => 'pqe',
  'syl' => 'inc',
  'ozm' => 'alv',
  'tjg' => 'pqw',
  'inc' => 'iir',
  'zmw' => 'bnt',
  'akr' => 'pqe',
  'kyh' => 'hok',
  'fkv' => 'fiu',
  'apu' => 'awd',
  'sds' => 'ber',
  'chy' => 'alg',
  'wmt' => 'aus',
  'tam' => 'dra',
  'lme' => 'cdc',
  'lag' => 'bnt',
  'tab' => 'ccn',
  'mar' => 'inc',
  'wln' => 'roa',
  'quf' => 'qwe',
  'mgo' => 'alv',
  'twp' => 'pqe',
  'wen' => 'zlw',
  'cha' => 'pqw',
  'eus' => 'euq',
  'xmz' => 'pqw',
  'cri' => 'cpp',
  'zen' => 'ber',
  'tpc' => 'omq',
  'lrc' => 'ira',
  'lij' => 'roa',
  'mox' => 'pqe',
  'xdc' => 'ine',
  'mlo' => 'alv',
  'dny' => 'auf',
  'pej' => 'hok',
  'mww' => 'hmx',
  'ciw' => 'alg',
  'naj' => 'alv',
  'hus' => 'myn',
  'tkg' => 'pqw',
  'den' => 'ath',
  'sax' => 'pqe',
  'pcd' => 'roa',
  'vrt' => 'pqe',
  'khm' => 'mkh',
  'nnt' => 'alg',
  'nkr' => 'pqe',
  'tgp' => 'pqe',
  'xmk' => 'ine',
  'rai' => 'pqe',
  'xps' => 'ine',
  'sav' => 'alv',
  'tic' => 'kdo',
  'kvq' => 'kar',
  'bad' => 'alv',
  'cgg' => 'bnt',
  'pnh' => 'pqe',
  'tor' => 'bad',
  'tmr' => 'sem',
  'ljp' => 'pqw',
  'nus' => 'sdv',
  'kdj' => 'sdv',
  'wbm' => 'mkh',
  'grr' => 'ber',
  'qwe' => 'sai',
  'kry' => 'ccn',
  'tqu' => 'paa',
  'asa' => 'bnt',
  'bai' => 'alv',
  'maj' => 'omq',
  'ers' => 'tbq',
  'alu' => 'pqe',
  'tur' => 'trk',
  'ybe' => 'trk',
  'taq' => 'ber',
  'xvn' => 'gme',
  'jpr' => 'ira',
  'vai' => 'dmn',
  'och' => 'zhx',
  'non' => 'gmq',
  'nij' => 'pqw',
  'sps' => 'pqe',
  'opt' => 'azc',
  'bew' => 'pqw',
  'zoh' => 'mixe1284',
  'jmc' => 'bnt',
  'hau' => 'cdc',
  'poo' => 'hok',
  'kpz' => 'sdv',
  'pim' => 'alg',
  'hsb' => 'wen',
  'zdj' => 'bnt',
  'neg' => 'tuw',
  'shs' => 'sal',
  'mql' => 'alv',
  'mhc' => 'myn',
  'swg' => 'gmw',
  'cps' => 'phi',
  'egy' => 'egx',
  'bkw' => 'bnt',
  'nfr' => 'alv',
  'csu' => 'ssa',
  'brh' => 'dra',
  'qun' => 'sal',
  'knk' => 'dmn',
  'dta' => 'xgn',
  'mkx' => 'mno',
  'ira' => 'iir',
  'ady' => 'ccn',
  'vnk' => 'pqe',
  'see' => 'iro',
  'sem' => 'afa',
  'utp' => 'pqe',
  'fvr' => 'ssa',
  'mqu' => 'sdv',
  'pny' => 'alv',
  'dra' => 'mul',
  'otr' => 'kdo',
  'ddo' => 'ccn',
  'liy' => 'bad',
  'hvn' => 'poz',
  'fos' => 'fox',
  'ssg' => 'pqe',
  'xao' => 'mkh',
  'map' => 'mul',
  'phn' => 'sem',
  'arp' => 'alg',
  'pox' => 'zlw',
  'gla' => 'cel',
  'aie' => 'pqe',
  'gmh' => 'gmw',
  'mpy' => 'pqe',
  'cba' => 'cai',
  'crh' => 'trk',
  'kpn' => 'tup',
  'huo' => 'mkh',
  'dum' => 'gmw',
  'piz' => 'pqe',
  'tnz' => 'mkh',
  'bzd' => 'cba',
  'tlh' => 'art',
  'njh' => 'sit',
  'man' => 'dmn',
  'plf' => 'poz',
  'qxl' => 'qwe',
  'not' => 'awd',
  'ntm' => 'alv',
  'mzw' => 'alv',
  'hao' => 'pqe',
  'dml' => 'inc',
  'xog' => 'bnt',
  'pap' => 'cpp',
  'mwv' => 'pqw',
  'nld' => 'gmw',
  'xcb' => 'cel',
  'xwo' => 'xgn',
  'mzb' => 'ber',
  'lad' => 'roa',
  'ray' => 'pqe',
  'fut' => 'pqe',
  'lug' => 'bnt',
  'bnr' => 'pqe',
  'fwa' => 'pqe',
  'nwb' => 'kro',
  'tpt' => 'toto1251',
  'kcj' => 'alv',
  'ksf' => 'bnt',
  'bax' => 'alv',
  'mpi' => 'cdc',
  'ccc' => 'awd',
  'anw' => 'alv',
  'mno' => 'phi',
  'blq' => 'pqe',
  'abq' => 'ccn',
  'alz' => 'sdv',
  'gob' => 'awd',
  'lao' => 'tai',
  'auq' => 'pqe',
  'btk' => 'pqw',
  'wwo' => 'pqe',
  'tui' => 'alv',
  'lra' => 'day',
  'xsc' => 'ira',
  'bba' => 'alv',
  'sln' => 'hok',
  'hne' => 'inc',
  'xbc' => 'ira',
  'bhw' => 'pqe',
  'tsn' => 'bnt',
  'vko' => 'pqw',
  'lti' => 'plf',
  'pex' => 'pqe',
  'cpe' => 'crp',
  'lpo' => 'tbq',
  'ynn' => 'hok',
  'rue' => 'zle',
  'abk' => 'ccn',
  'quk' => 'qwe',
  'xmr' => 'ssa',
  'tzj' => 'myn',
  'ubr' => 'pqe',
  'thv' => 'ber',
  'ulc' => 'tuw',
  'mkh' => 'aav',
  'mba' => 'mno',
  'cjs' => 'trk',
  'ttt' => 'ira',
  'aoa' => 'cpp',
  'myh' => 'wak',
  'mwl' => 'roa',
  'smo' => 'pqe',
  'tiv' => 'alv',
  'nor' => 'gmq',
  'tcw' => 'toto1251',
  'kkj' => 'bnt',
  'tec' => 'sdv',
  'xwe' => 'alv',
  'tpl' => 'omq',
  'gni' => 'aus',
  'kzr' => 'alv',
  'nxm' => 'ber',
  'acw' => 'sem',
  'cos' => 'roa',
  'sjw' => 'alg',
  'min' => 'pqw',
  'mkm' => 'pqw',
  'grb' => 'kro',
  'kpe' => 'dmn',
  'alv' => 'nic',
  'tnn' => 'pqe',
  'kac' => 'sit',
  'swc' => 'swa',
  'aeb' => 'sem',
  'nfl' => 'pqe',
  'jbo' => 'art',
  'stn' => 'pqe',
  'kdt' => 'aav',
  'xlo' => 'alg',
  'mtm' => 'syd',
  'cpp' => 'crp',
  'sal' => 'nai',
  'niu' => 'pqe',
  'mqn' => 'pqw',
  'pic' => 'bnt',
  'mmx' => 'pqe',
  'pri' => 'pqe',
  'nnn' => 'cdc',
  'nok' => 'sal',
  'mbb' => 'mno',
  'dor' => 'pqe',
  'maf' => 'cdc',
  'itc' => 'ine',
  'txn' => 'plf',
  'yuf' => 'hok',
  'hmd' => 'hmx',
  'hid' => 'sio',
  'cpf' => 'crp',
  'ras' => 'kdo',
  'vot' => 'fiu',
  'hke' => 'bnt',
  'ynk' => 'ypk',
  'gga' => 'pqe',
  'ntw' => 'iro',
  'toc' => 'toto1251',
  'fan' => 'bnt',
  'hup' => 'ath',
  'tkb' => 'bih',
  'okr' => 'ijo',
  'jbn' => 'ber',
  'lbj' => 'sit',
  'blo' => 'alv',
  'klj' => 'trk',
  'cor' => 'cel',
  'bwo' => 'omv',
  'anx' => 'pqe',
  'aat' => 'sqj',
  'gcr' => 'cpf',
  'lkt' => 'sio',
  'xcl' => 'hyx',
  'ngf' => 'paa',
  'sad' => 'khi',
  'qxt' => 'qwe',
  'fil' => 'phi',
  'mdr' => 'pqw',
  'ssw' => 'bnt',
  'nku' => 'alv',
  'tig' => 'sem',
  'tat' => 'trk',
  'uvl' => 'pqe',
  'kmq' => 'ssa',
  'ptv' => 'pqe',
  'mnh' => 'bad',
  'olo' => 'fiu',
  'sit' => 'mul',
  'mkd' => 'zls',
  'cbg' => 'cba',
  'gud' => 'kro',
  'ave' => 'ira',
  'owl' => 'cel',
  'olt' => 'bat',
  'pef' => 'hok',
  'peo' => 'ira',
  'mrb' => 'pqe',
  'tel' => 'dra',
  'mbi' => 'mno',
  'pbs' => 'omq',
  'pdc' => 'gmw',
  'dlg' => 'trk',
  'ijn' => 'ijo',
  'teo' => 'sdv',
  'kca' => 'fiu',
  'dar' => 'ccn',
  'bck' => 'aus',
  'ero' => 'sit',
  'eto' => 'bnt',
  'mqt' => 'mkh',
  'dez' => 'bnt',
  'coo' => 'sal',
  'tht' => 'ath',
  'ekg' => 'ngf',
  'tnp' => 'pqe',
  'vao' => 'pqe',
  'son' => 'ssa',
  'llx' => 'pqe',
  'vmb' => 'aus',
  'gro' => 'tbq',
  'biq' => 'pqe',
  'zum' => 'ira',
  'tlr' => 'pqe',
  'rog' => 'cmc',
  'lue' => 'bnt',
  'thr' => 'bih',
  'nas' => 'paa',
  'jae' => 'pqe',
  'haq' => 'bnt',
  'imy' => 'ine',
  'saq' => 'sdv',
  'mdf' => 'fiu',
  'ind' => 'pqw',
  'wdd' => 'bnt',
  'raj' => 'inc',
  'cpx' => 'zhx',
  'lgb' => 'pqe',
  'gwc' => 'inc',
  'boi' => 'hok',
  'khq' => 'son',
  'hye' => 'hyx',
  'esu' => 'ypk',
  'srh' => 'ira',
  'pbg' => 'awd',
  'bhp' => 'poz',
  'lle' => 'pqe',
  'kir' => 'trk',
  'wbp' => 'aus',
  'iby' => 'ijo',
  'tfn' => 'xnd',
  'quv' => 'myn',
  'caa' => 'myn',
  'san' => 'pra',
  'dzo' => 'sit',
  'iow' => 'sio',
  'oua' => 'ber',
  'lmu' => 'pqe',
  'rus' => 'zle',
  'mag' => 'bih',
  'qvi' => 'qwe',
  'puw' => 'pqe',
  'bll' => 'sio',
  'kxr' => 'pqe',
  'glg' => 'roa',
  'spa' => 'roa',
  'mdi' => 'csu',
  'lol' => 'bnt',
  'tai' => 'mul',
  'gmy' => 'grk',
  'wyr' => 'tup',
  'bth' => 'day',
  'sdt' => 'ine',
  'mbo' => 'bnt',
  'mtq' => 'mkh',
  'sjt' => 'smi',
  'xlg' => 'ine',
  'kcm' => 'csu',
  'bjj' => 'inc',
  'cjh' => 'sal',
  'buk' => 'pqe',
  'sbe' => 'pqe',
  'nym' => 'bnt',
  'xrg' => 'aus',
  'kar' => 'tbq',
  'ddi' => 'pqe',
  'win' => 'sio',
  'tuc' => 'pqe',
  'xmw' => 'pqw',
  'esq' => 'hok',
  'jhi' => 'mkh',
  'nse' => 'bnt',
  'bos' => 'zls',
  'dup' => 'pqw',
  'obt' => 'cel',
  'lcl' => 'map',
  'wuv' => 'pqe',
  'nuk' => 'wak',
  'poq' => 'mixe1284',
  'tlp' => 'toto1251',
  'ssa' => 'mul',
  'neq' => 'mixe1284',
  'ksk' => 'sio',
  'mjy' => 'alg',
  'ovd' => 'gmq',
  'noz' => 'omv',
  'kju' => 'hok',
  'nan' => 'zhx',
  'mug' => 'cdc',
  'mzl' => 'mixe1284',
  'bsu' => 'pqw',
  'ppl' => 'azc',
  'mrw' => 'phi',
  'bih' => 'iir',
  'kls' => 'inc',
  'iir' => 'ine',
  'xsy' => 'fox',
  'pss' => 'pqe',
  'kde' => 'bnt',
  'cjy' => 'zhx',
  'gbu' => 'aus',
  'nmt' => 'pqe',
  'ajg' => 'alv',
  'nmg' => 'bnt',
  'xaw' => 'azc',
  'kzo' => 'bnt',
  'bcr' => 'ath',
  'nio' => 'syd',
  'aln' => 'sqj',
  'szl' => 'zlw',
  'nno' => 'gmq',
  'mbd' => 'mno',
  'ppi' => 'hok',
  'nic' => 'mul',
  'bzt' => 'art',
  'swe' => 'gmq',
  'jah' => 'mkh',
  'xal' => 'xgn',
  'nau' => 'pqe',
  'frc' => 'roa',
  'ruo' => 'roa',
  'lez' => 'ccn',
  'plu' => 'awd',
  'wru' => 'pqw',
  'pkg' => 'pqe',
  'dbj' => 'pqw',
  'dob' => 'pqe',
  'pop' => 'pqe',
  'fas' => 'ira',
  'crv' => 'mkh',
  'lou' => 'cpf',
  'kyi' => 'pqw',
  'met' => 'pqe',
  'eve' => 'tuw',
  'aka' => 'alv',
  'kmv' => 'cpf',
  'egx' => 'afa',
  'par' => 'azc',
  'lgu' => 'pqe',
  'abl' => 'pqw',
  'guq' => 'tup',
  'bat' => 'ine',
  'sss' => 'aav',
  'liw' => 'pqw',
  'xnt' => 'alg',
  'mfv' => 'alv',
  'kqs' => 'alv',
  'qxq' => 'trk',
  'kek' => 'myn',
  'lim' => 'gmw',
  'cad' => 'cdd',
  'ncn' => 'pqe',
  'qws' => 'qwe',
  'ayl' => 'sem',
  'xto' => 'ine',
  'cgc' => 'mno',
  'rut' => 'ccn',
  'kog' => 'cba',
  'sck' => 'bih',
  'ils' => 'sgn',
  'krl' => 'fiu',
  'uli' => 'pqe',
  'nue' => 'bad',
  'cks' => 'cpf',
  'tvl' => 'pqe',
  'mzv' => 'alv',
  'waj' => 'paa',
  'sqr' => 'sem',
  'prg' => 'bat',
  'kur' => 'ira',
  'kam' => 'bnt',
  'aji' => 'pqe',
  'quh' => 'qwe',
  'sjd' => 'smi',
  'mot' => 'cba',
  'dnj' => 'dmn',
  'kgk' => 'tup',
  'sxg' => 'sit',
  'tqr' => 'kdo',
  'zbc' => 'pqw',
  'jab' => 'alv',
  'pwg' => 'pqe',
  'apw' => 'apa',
  'xmf' => 'ccs',
  'aao' => 'sem',
  'pip' => 'cdc',
  'sml' => 'pqw',
  'otw' => 'alg',
  'tlb' => 'paa',
  'kjh' => 'trk',
  'vkl' => 'pqw',
  'mfq' => 'alv',
  'gml' => 'gmw',
  'kik' => 'bnt',
  'roa' => 'itc',
  'ztq' => 'omq',
  'qvj' => 'qwe',
  'pon' => 'pqe',
  'tuf' => 'cba',
  'siz' => 'ber',
  'pek' => 'pqe',
  'loz' => 'bnt',
  'kwd' => 'pqe',
  'sei' => 'hok',
  'kos' => 'pqe',
  'fur' => 'roa',
  'smj' => 'smi',
  'orc' => 'cus',
  'avu' => 'csu',
  'bip' => 'bnt',
  'ruq' => 'roa',
  'tsd' => 'grk',
  'tlk' => 'pqw',
  'cui' => 'awd',
  'azo' => 'alv',
  'csb' => 'zlw',
  'qvs' => 'qwe',
  'etn' => 'pqe',
  'tlc' => 'toto1251',
  'mri' => 'pqe',
  'ono' => 'iro',
  'xcr' => 'ine',
  'lvk' => 'paa',
  'ada' => 'alv',
  'mto' => 'mixe1284',
  'xaa' => 'sem',
  'yrl' => 'tup',
  'dru' => 'fox',
  'tpx' => 'omq',
  'ofo' => 'sio',
  'cul' => 'auf',
  'thl' => 'bih',
  'msm' => 'mno',
  'qwc' => 'qwe',
  'ixl' => 'myn',
  'xlb' => 'alg',
  'mic' => 'alg',
  'dic' => 'kro',
  'mop' => 'myn',
  'ceb' => 'phi',
  'bea' => 'ath',
  'juc' => 'tuw',
  'slk' => 'zlw',
  'acy' => 'sem',
  'kan' => 'dra',
  'ses' => 'son',
  'auf' => 'awd',
  'glk' => 'ira',
  'msq' => 'pqe',
  'rof' => 'bnt',
  'sor' => 'cdc',
  'kay' => 'tup',
  'mgl' => 'pqe',
  'sgn' => 'mul',
  'aty' => 'pqe',
  'ofs' => 'gmw',
  'mwc' => 'pqe',
  'mbn' => 'awd',
  'kib' => 'kdo',
  'sam' => 'sem',
  'sco' => 'gmw',
  'wrn' => 'kdo',
  'ibg' => 'phi',
  'bgc' => 'inc',
  'lee' => 'alv',
  'kwf' => 'pqe',
  'xsv' => 'bat',
  'qyp' => 'alg',
  'ani' => 'ccn',
  'nrn' => 'gmq',
  'ank' => 'cdc',
  'ski' => 'poz',
  'xnd' => 'nai',
  'kjn' => 'aus',
  'lnl' => 'bad',
  'xnb' => 'fox',
  'cqu' => 'qwe',
  'mbs' => 'mno',
  'gos' => 'gmw',
  'pad' => 'auf',
  'bji' => 'cus',
  'afa' => 'mul',
  'tgi' => 'pqe',
  'okd' => 'ijo',
  'kxv' => 'dra',
  'nwe' => 'bai',
  'pdo' => 'pqw',
  'csn' => 'sgn',
  'kmz' => 'trk',
  'cwe' => 'bnt',
  'czh' => 'zhx',
  'loc' => 'phi',
  'piv' => 'pqe',
  'nsw' => 'pqe',
  'wep' => 'gmw',
  'znd' => 'alv',
  'tnw' => 'phi',
  'crd' => 'sal',
  'beq' => 'bnt',
  'cms' => 'ine',
  'syd' => 'urj',
  'lbb' => 'pqe',
  'nso' => 'bnt',
  'vie' => 'mkh',
  'hla' => 'pqe',
  'plo' => 'mixe1284',
  'njo' => 'tbq',
  'jra' => 'cmc',
  'bbc' => 'btk',
  'ngc' => 'bnt',
  'scn' => 'roa',
  'sob' => 'pqe',
  'jkr' => 'sit',
  'ati' => 'alv'
};
#-*-perl-*-

=head1 SUBROUTINES

=head2 @langcodes = language_group( $groupcode )

Returns a list of language codes within the given language group.

=cut


sub language_group{
    my %children = ();
    if (exists $$LanguageGroup{$_[0]}){
	foreach my $l (@{$$LanguageGroup{$_[0]}}){
	    if (exists $$LanguageGroup{$l}){
		foreach (&language_group($l)){
		    $children{$_}++;
		}
	    }
	    else{
		$children{$l}++;
	    }
	}
    }
    else{
	return ($_[0]);
    }
    return sort keys %children;
}


=head2 @langcodes = language_group_children( $groupcode )

Returns a list of language codes that are immediate children of the given language group.

=cut

sub language_group_children{
    if (exists $$LanguageGroup{$_[0]}){
	return @{$$LanguageGroup{$_[0]}};
    }
    print STDERR "unknown language group $_[0]\n";
    return ();
}


=head2 @parentcode = language_group( $langcode )

Returns the parent language code for the given language.

=cut


sub language_parent{
    if (exists $$LanguageParent{$_[0]}){
	return $$LanguageParent{$_[0]};
    }
    print STDERR "no parent found for '$_[0]'\n";
    return undef;
}


## don't need the functions below, just use ISO::639::3
##

# =head2 $name = language_group_name( $groupcode )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_language_name($_[0]);
# }


# =head2 $code = language_group_code( $groupname )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_iso639_3($_[0]);
# }



1;

