=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ks - Package for language Kashmiri

=cut

package Locale::CLDR::Locales::Ks;
# This file auto generated from Data\common\main\ks.xml
#	on Wed 15 Jan 11:22:39 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'اَفار',
 				'ab' => 'اَبخازِیان',
 				'ace' => 'اَچَےنیٖز',
 				'ach' => 'اَکولی',
 				'ada' => 'اَدَنگمیے',
 				'ady' => 'اَدَیٖگیے',
 				'ae' => 'اَویستَن',
 				'af' => 'اَفریٖکانز',
 				'afh' => 'اَفرِہِلی',
 				'agq' => 'اگہم',
 				'ain' => 'اینوٗ',
 				'ak' => 'اَکان',
 				'akk' => 'اَکادِیَن',
 				'ale' => 'اَلویتی',
 				'alt' => 'جنوٗبی اَلتایی',
 				'am' => 'اَمہاری',
 				'an' => 'اَراگونی',
 				'ang' => 'پرون اَنگریٖزی',
 				'anp' => 'اَنگِکا',
 				'ar' => 'عربی',
 				'ar_001' => 'ماڈرن معیٲری عربی',
 				'arc' => 'اَرَمیک',
 				'arn' => 'ایرو کونِیَن',
 				'arp' => 'اَراپاہو',
 				'arw' => 'اَراوَک',
 				'as' => 'اسٲمؠ',
 				'ast' => 'ایسٹوٗریَن',
 				'av' => 'اَوارِک',
 				'awa' => 'اَوَدی',
 				'ay' => 'ایمارا',
 				'az' => 'اَزَربیجانی',
 				'ba' => 'بَشکیٖر',
 				'bal' => 'بَلوٗچی',
 				'ban' => 'بالِنیٖز',
 				'bas' => 'باسا',
 				'be' => 'بیلَروٗشیَن',
 				'bej' => 'بیجا',
 				'bem' => 'بیمبا',
 				'bg' => 'بینا',
 				'bho' => 'بوجپوٗری',
 				'bi' => 'بِسلاما',
 				'bik' => 'بِکول',
 				'bin' => 'بِنی',
 				'bla' => 'سِکسِکا',
 				'bm' => 'بَمبارا',
 				'bn' => 'بَنگٲلؠ',
 				'bo' => 'تِبتی',
 				'br' => 'بریٹَن',
 				'bra' => 'برج',
 				'bs' => 'بوسنِیَن',
 				'bua' => 'بُرِیَت',
 				'bug' => 'بَگنیٖز',
 				'byn' => 'بٕلِن',
 				'ca' => 'کَتلان',
 				'cad' => 'کاڈو',
 				'car' => 'کارِب',
 				'cch' => 'اتسَم',
 				'ce' => 'چیچَن',
 				'ceb' => 'سیباونو',
 				'ch' => 'کَمورو',
 				'chb' => 'چیٖبچا',
 				'chg' => 'چھَگتاے',
 				'chk' => 'چُکیٖز',
 				'chm' => 'ماری',
 				'chn' => 'چِنوٗک جارگَن',
 				'cho' => 'چوکتَو',
 				'chp' => 'شیپویان',
 				'chr' => 'چیروکی',
 				'chy' => 'شییون',
 				'co' => 'کارسِکَن',
 				'cop' => 'کاپٹِک',
 				'cr' => 'کری',
 				'crh' => 'کرٕمیٖن تُرکی',
 				'cs' => 'چیک',
 				'csb' => 'کَشوٗبِیَن',
 				'cu' => 'چٔرچ سلاوِک',
 				'cv' => 'چُواش',
 				'cy' => 'ویلش',
 				'da' => 'ڈینِش',
 				'dak' => 'ڈکوٹا',
 				'dar' => 'دَرگوا',
 				'de' => 'جٔرمَن',
 				'de_AT' => 'آسٹرِیَن جٔرمَن',
 				'de_CH' => 'سٕوِس ہائی جٔرمَن',
 				'del' => 'ڈیلوییَر',
 				'den' => 'سلیو',
 				'dgr' => 'ڈاگرِب',
 				'din' => 'ڈِنکا',
 				'doi' => 'ڈوگری',
 				'dsb' => 'بۆنِم ساربِیَن',
 				'dua' => 'دُوالا',
 				'dum' => 'وَستی پُرتُگالی',
 				'dv' => 'دِویہی',
 				'dyu' => 'ڈِیوٗلا',
 				'dz' => 'زونگکھا',
 				'ee' => 'ایٖو',
 				'efi' => 'ایفِک',
 				'egy' => 'قدیٖمی مِصری',
 				'eka' => 'ایکاجُک',
 				'el' => 'یوٗنٲنی',
 				'elx' => 'ایلامایِٹ',
 				'en' => 'اَنگیٖزؠ',
 				'en_AU' => 'آسٹریلیَن اَنگریٖزؠ',
 				'en_CA' => 'کینَڈِیٲیی اَنگریٖزؠ',
 				'en_GB' => 'بَرطانوی اَنگریٖزؠ',
 				'en_GB@alt=short' => 'UK اَنٛگریٖزؠ',
 				'en_US' => 'امریٖکی اَنٛگریٖزؠ',
 				'en_US@alt=short' => 'US اَنٛگریٖزؠ',
 				'enm' => 'وَسطی اَنگریٖزؠ',
 				'eo' => 'ایسپَرینٹو',
 				'es' => 'ہسپانوی',
 				'es_419' => 'لاطیٖنی امریٖکی ہسپانوی',
 				'es_ES' => 'یوٗرپی ہسپانوی',
 				'es_MX' => 'میکسیکن ہسپانوی',
 				'et' => 'ایسٹونیَن',
 				'eu' => 'باسک',
 				'ewo' => 'ایوونڈو',
 				'fa' => 'فارسی',
 				'fan' => 'فینگ',
 				'fat' => 'فانٹی',
 				'ff' => 'فُلاہ',
 				'fi' => 'فِنِش',
 				'fil' => 'فِلِپیٖنو',
 				'fj' => 'فِجیَن',
 				'fo' => 'فَروس',
 				'fon' => 'فون',
 				'fr' => 'فرانسیسی',
 				'fr_CA' => 'کَنیڈیَن فرانسیسی',
 				'fr_CH' => 'سٕوٕس فرانسیسی',
 				'frm' => 'وسطی فرینچ',
 				'fro' => 'پرون فرینچ',
 				'frr' => 'شُمٲلی فرِشیَن',
 				'frs' => 'مشرِقی فرِشیَن',
 				'fur' => 'فروٗلِیَن',
 				'fy' => 'مغربی فرِشیَن',
 				'ga' => 'اَیرِش',
 				'gaa' => 'گا',
 				'gay' => 'گیےیو',
 				'gba' => 'گبایا',
 				'gd' => 'سکوٹِش گیےلِک',
 				'gez' => 'گیٖز',
 				'gil' => 'گِلبٔرٹیٖز',
 				'gl' => 'گیلِشِیَن',
 				'gmh' => 'وَسطی ہاے جٔرمَن',
 				'gn' => 'گُوارَنی',
 				'goh' => 'پرون ہاے جٔرمَن',
 				'gon' => 'گوندی',
 				'gor' => 'گورینٹیلو',
 				'got' => 'گوتھِک',
 				'grb' => 'گرِبو',
 				'grc' => 'قدیٖم یوٗنٲنی',
 				'gsw' => 'سٕوِس جٔرمَن',
 				'gu' => 'گُجرٲتی',
 				'gv' => 'مینکس',
 				'gwi' => 'گُوِچ اِن',
 				'ha' => 'ہاوسا',
 				'hai' => 'ہَیدا',
 				'haw' => 'ہوایِیَن',
 				'he' => 'عبرٲنؠ',
 				'hi' => 'ہِندی',
 				'hil' => 'ہِلیٖگینَن',
 				'hit' => 'ہِتایِت',
 				'hmn' => 'ہمونگ',
 				'ho' => 'ہِری موتوٗ',
 				'hr' => 'کروشِیَن',
 				'hsb' => 'ہیرِم ساربِیَن',
 				'ht' => 'ہیتِیاں',
 				'hu' => 'ہَنگیریَن',
 				'hup' => 'ہُپا',
 				'hy' => 'اَرمینیَن',
 				'hz' => 'ہیریٖرو',
 				'ia' => 'اِنٹَرلِنگوا',
 				'iba' => 'اِبان',
 				'id' => 'اِنڈونیشیا',
 				'ie' => 'اِنٹَر لِننگویے',
 				'ig' => 'اِگبو',
 				'ii' => 'سِچوان یٖی',
 				'ik' => 'اِنُپِیاک',
 				'ilo' => 'اِلوکو',
 				'inh' => 'اِنگُش',
 				'io' => 'اِڈو',
 				'is' => 'آیِسلینڈِک',
 				'it' => 'اِطالوی',
 				'iu' => 'اِنُکتِتوٗ',
 				'ja' => 'جاپٲنؠ',
 				'jbo' => 'لوجبان',
 				'jpr' => 'جوڈیو فارسی',
 				'jrb' => 'جوڈیو عربی',
 				'jv' => 'جَوَنیٖز',
 				'ka' => 'جارجِیَن',
 				'kaa' => 'کارا کَلپَک',
 				'kab' => 'کَبایِل',
 				'kac' => 'کاچِن',
 				'kaj' => 'جُوٗ',
 				'kam' => 'کامبا',
 				'kaw' => 'کَوی',
 				'kbd' => 'کَبارڈِیَن',
 				'kcg' => 'تَیَپ',
 				'kfo' => 'کورو',
 				'kg' => 'کونگو',
 				'kha' => 'کھاسی',
 				'kho' => 'کھوتَنیٖز',
 				'ki' => 'کِکُیوٗ',
 				'kj' => 'کُوانیاما',
 				'kk' => 'کازَخ',
 				'kl' => 'کَلالِسُت',
 				'km' => 'خَمیر',
 				'kmb' => 'کِمبُندوٗ',
 				'kn' => 'کَنَڑ',
 				'ko' => 'کوریَن',
 				'kok' => 'کونکَنی',
 				'kos' => 'کوسرییَن',
 				'kpe' => 'کَپیلی',
 				'kr' => 'کَنوٗری',
 				'krc' => 'کراچیے بَلکار',
 				'krl' => 'کَریلِیَن',
 				'kru' => 'کُرُکھ',
 				'ks' => 'کٲشُر',
 				'ku' => 'کُردِش',
 				'kum' => 'کُمِک',
 				'kut' => 'کُتینَے',
 				'kv' => 'کومی',
 				'kw' => 'کورنِش',
 				'ky' => 'کِرگِز',
 				'la' => 'لاتیٖنی',
 				'lad' => 'لیڈِنو',
 				'lah' => 'لَہَندا',
 				'lam' => 'لَمبا',
 				'lb' => 'لُکھزیمبورگِش',
 				'lez' => 'لیزگِیَن',
 				'lg' => 'گاندا',
 				'li' => 'لِمبٔرگِش',
 				'ln' => 'لِنگالا',
 				'lo' => 'لاو',
 				'lol' => 'مونگو',
 				'loz' => 'لوزی',
 				'lt' => 'لِتھوانِیَن',
 				'lu' => 'لوُبا کَتَنگا',
 				'lua' => 'لوٗبا لوٗلُوا',
 				'lui' => 'لویِسینو',
 				'lun' => 'لُندا',
 				'luo' => 'لُوو',
 				'lus' => 'لُسہاے',
 				'lv' => 'لَتوِیَن',
 				'mad' => 'مَدُریٖز',
 				'mag' => 'مَگاے',
 				'mai' => 'میتَھلی',
 				'mak' => 'مَکَسار',
 				'man' => 'مَندِنگو',
 				'mas' => 'مَساے',
 				'mdf' => 'موکشا',
 				'mdr' => 'مَندَر',
 				'men' => 'میندیے',
 				'mg' => 'مَلاگَسی',
 				'mga' => 'وَستی ایرِش',
 				'mh' => 'مارشَلیٖز',
 				'mi' => 'ماوری',
 				'mic' => 'مِکمیک',
 				'min' => 'مِنَنگکَباو',
 				'mk' => 'میکَڈونیَن',
 				'ml' => 'مٔلیالَم',
 				'mn' => 'مَنگولی',
 				'mnc' => 'مانچوٗ',
 				'mni' => 'مَنیپوٗری',
 				'moh' => 'موہاک',
 				'mos' => 'موسی',
 				'mr' => 'مَرٲٹھؠ',
 				'ms' => 'مَلَے',
 				'mt' => 'مَلتیٖس',
 				'mul' => 'واریاہ زبان',
 				'mus' => 'کریٖک',
 				'mwl' => 'مِراندیٖز',
 				'mwr' => 'مارواڑی',
 				'my' => 'بٔمیٖز',
 				'myv' => 'ایرزِیا',
 				'na' => 'ناورُ',
 				'nap' => 'نیٖپالیٹَن',
 				'nb' => 'ناروییَن بوکمال',
 				'nd' => 'شُمال ڈَبیل',
 				'nds' => 'بۆنِم جٔرمَن',
 				'ne' => 'نیپٲلؠ',
 				'new' => 'نیواری',
 				'ng' => 'ڈونگا',
 				'nia' => 'نِیاس',
 				'niu' => 'نِیویَن',
 				'nl' => 'ڈَچ',
 				'nl_BE' => 'فلیمِش',
 				'nn' => 'ناروییَن نَے نورسک',
 				'no' => 'ناروییَن',
 				'nog' => 'نوگاے',
 				'non' => 'پرون نارسی',
 				'nqo' => 'این کو',
 				'nr' => 'جنوب ڈیبیل',
 				'nso' => 'شمالی ستھو',
 				'nv' => 'نَواجو',
 				'nwc' => 'کلاسِکَل نیواری',
 				'ny' => 'نِیَنجا',
 				'nym' => 'نِیَمویزی',
 				'nyn' => 'نِیَنکول',
 				'nyo' => 'نِیورو',
 				'nzi' => 'نَظیٖما',
 				'oc' => 'اوکسیٖٹَن',
 				'oj' => 'اوجِبوا',
 				'om' => 'اۆرومو',
 				'or' => 'اۆرِیا',
 				'os' => 'اۆسیٹِک',
 				'osa' => 'اۆسیج',
 				'ota' => 'اوٹومَن تُرکِش',
 				'pa' => 'پَنجٲبؠ',
 				'pag' => 'پَنگاسِنَن',
 				'pal' => 'پَہلَوی',
 				'pam' => 'پَمپَنگا',
 				'pap' => 'پَپِیامینٹو',
 				'pau' => 'پَلااُواں',
 				'peo' => 'پرون فارسی',
 				'phn' => 'فونیٖشیَن',
 				'pi' => 'پالی',
 				'pl' => 'پالِش',
 				'pon' => 'پانپییَن',
 				'pro' => 'پرون پرووینچَل',
 				'ps' => 'پَشتوٗ',
 				'pt' => 'پُرتَگیٖز',
 				'pt_BR' => 'برازیٖلی پُرتَگیٖز',
 				'pt_PT' => 'یوٗرپی پُرتَگیٖز',
 				'qu' => 'کُویشُوا',
 				'raj' => 'راجِستھٲنؠ',
 				'rap' => 'رَپانوی',
 				'rar' => 'رَروٹونگَن',
 				'rm' => 'رومانش',
 				'rn' => 'رُندی',
 				'ro' => 'رومٲنی',
 				'ro_MD' => 'مولداوِیَن',
 				'rom' => 'رومَنی',
 				'ru' => 'روٗسی',
 				'rup' => 'اَرومانی',
 				'rw' => 'کِنیاوِندا',
 				'sa' => 'سَنسکرٕت',
 				'sad' => 'سَندَویے',
 				'sah' => 'یاکُت',
 				'sam' => 'سَمارِتَن اَرامیک',
 				'sas' => 'سَسَک',
 				'sat' => 'سَنتالی',
 				'sc' => 'سراڈیٖنی',
 				'scn' => 'سِچِلِیَن',
 				'sco' => 'سکاٹس',
 				'sd' => 'سِندی',
 				'se' => 'شُمٲلی سَمی',
 				'sel' => 'سیلکُپ',
 				'sg' => 'سَنگو',
 				'sga' => 'پرون ایرِش',
 				'sh' => 'سیربو کروشِیَن',
 				'shn' => 'شان',
 				'si' => 'سِنہالا',
 				'sid' => 'سِدامو',
 				'sk' => 'سلووَک',
 				'sl' => 'سلووینیَن',
 				'sm' => 'سَمواَن',
 				'sma' => 'جنوٗبی سَمی',
 				'smj' => 'لولیے سَمی',
 				'smn' => 'اِناری سَمی',
 				'sms' => 'سکولٹ سَمی',
 				'sn' => 'شونا',
 				'snk' => 'سونِنکیے',
 				'so' => 'سومٲلی',
 				'sog' => 'سوگڈِیَن',
 				'sq' => 'البانِیَن',
 				'sr' => 'سٔربِیَن',
 				'srn' => 'سرانَن ٹونگو',
 				'srr' => 'سیریر',
 				'ss' => 'سواتی',
 				'st' => 'جنوبی ستھو',
 				'su' => 'سَنڈَنیٖز',
 				'suk' => 'سُکُما',
 				'sus' => 'سُسوٗ',
 				'sux' => 'سُمیریَن',
 				'sv' => 'سویٖڈِش',
 				'sw' => 'سواہِلی',
 				'syr' => 'سیٖریٲیی',
 				'ta' => 'تَمِل',
 				'te' => 'تیلگوٗ',
 				'tem' => 'ٹِمنیے',
 				'ter' => 'ٹیرینو',
 				'tet' => 'ٹیٹَم',
 				'tg' => 'تاجِک',
 				'th' => 'تھاے',
 				'ti' => 'ٹِگرِنیا',
 				'tig' => 'ٹاےگریے',
 				'tiv' => 'تیٖو',
 				'tk' => 'تُرکمین',
 				'tkl' => 'ٹوکیٖلاو',
 				'tl' => 'تَماشیک',
 				'tlh' => 'کِلِنگون',
 				'tli' => 'ٹِلِنگِت',
 				'tmh' => 'تاماشیک',
 				'tn' => 'سوانا',
 				'to' => 'ٹونگا',
 				'tog' => 'نیاسا ٹونگا',
 				'tpi' => 'ٹاک پِسِن',
 				'tr' => 'تُرکِش',
 				'ts' => 'ژونگا',
 				'tsi' => 'ژھِمشِیان',
 				'tt' => 'تَتار',
 				'tum' => 'تُمبُکا',
 				'tvl' => 'تُوالوٗ',
 				'tw' => 'توی',
 				'ty' => 'تاہیشِیَن',
 				'tyv' => 'تُویٖنیَن',
 				'udm' => 'اُدمُرت',
 				'uga' => 'اُگارتِک',
 				'uk' => 'یوٗکرینیٲیی',
 				'umb' => 'یُمبُندوٗ',
 				'und' => 'اَنزٲنؠ یا نَہ لَگہٕہار زبان',
 				'ur' => 'اُردوٗ',
 				'uz' => 'اُزبیک',
 				'vai' => 'واے',
 				've' => 'ویندا',
 				'vi' => 'وِیَتنَمیٖز',
 				'vo' => 'وولَپُک',
 				'vot' => 'ووتِک',
 				'wa' => 'وَلوٗن',
 				'wal' => 'والامو',
 				'war' => 'وَریے',
 				'was' => 'واشو',
 				'wo' => 'وولوف',
 				'xal' => 'کالمِک',
 				'xh' => 'کھوسا',
 				'yao' => 'یاو',
 				'yap' => 'یَپیٖز',
 				'yi' => 'یِدِش',
 				'yo' => 'یورُبا',
 				'za' => 'زُہانگ',
 				'zap' => 'زَپوتیک',
 				'zen' => 'زیناگا',
 				'zh' => 'چیٖنی ﴿ترجمع اِشارٕ: خاص طور، مینڈارن چیٖنی۔﴾',
 				'zh@alt=menu' => 'چیٖنی، مینڈارن',
 				'zh_Hans' => 'سَہل چیٖنی',
 				'zh_Hans@alt=long' => 'سَہل مینڈارن چیٖنی',
 				'zh_Hant' => 'رِوٲجی چیٖنی',
 				'zh_Hant@alt=long' => 'رِوٲجی مینڈارن چیٖنی',
 				'zu' => 'زُلوٗ',
 				'zun' => 'زوٗنی',
 				'zxx' => 'کانہہ تہِ لِسانیاتی مواد نہٕ',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'عربی',
 			'Aran' => 'نستعلیق',
 			'Armn' => 'اَرمانیَن',
 			'Avst' => 'اَویستَن',
 			'Bali' => 'بالَنیٖز',
 			'Batk' => 'باتَک',
 			'Beng' => 'بینگٲلؠ',
 			'Blis' => 'بِلِس سِمبلز',
 			'Bopo' => 'بوپوموفو',
 			'Brah' => 'براہمی',
 			'Brai' => 'بریل',
 			'Bugi' => 'بُگِنیٖز',
 			'Buhd' => 'بُہِد',
 			'Cans' => 'یُنِفایِڑ کنیڑِیَن ایب آرجِنَل سِلیبِک',
 			'Cari' => 'کاریَن',
 			'Cham' => 'چَم',
 			'Cher' => 'چیروکی',
 			'Cirt' => 'کِرتھ',
 			'Copt' => 'کاپٹِک',
 			'Cprt' => 'کِپرایِٹ',
 			'Cyrl' => 'سَیرِلِک',
 			'Cyrs' => 'پرون چٔرچسلیوونِک سَیرِلِک',
 			'Deva' => 'دیوناگری',
 			'Dsrt' => 'ڈیسٔریٹ',
 			'Egyd' => 'اِجپشِیَن ڈِماٹِک',
 			'Egyh' => 'اِجِپشَن ہَیریٹِک',
 			'Egyp' => 'اِجِپشَن ہَیروگلِپھس',
 			'Ethi' => 'اِتھیوپِک',
 			'Geok' => 'جارجِیَن کھتسوری',
 			'Geor' => 'جارجِیَن',
 			'Glag' => 'گلیگولِٹِک',
 			'Goth' => 'گوتھِک',
 			'Grek' => 'گرَنتھا',
 			'Gujr' => 'گریٖک',
 			'Guru' => 'گُجرٲتؠ',
 			'Hang' => 'ہانگُل',
 			'Hani' => 'ہان',
 			'Hano' => 'ہانُنوٗ',
 			'Hans' => 'سَہل ﴿ترجمع اِشارٕ: یِم ورژن رَسم الخط ہُک ناؤ چھُ چیٖنی باپتھ زَبانٕ ناؤ کِس مجموعَس سٕتؠ اِستعمال یِوان کرنٕہ۔﴾',
 			'Hans@alt=stand-alone' => 'سَہل ہان ﴿ترجمع اِشارٕ: یِم ورژن رَسم الخط ہُک ناؤ چھُ چیٖنی باپتھ زَبانٕ ناؤ کِس مجموعَس بغٲرٕ الگ اِستعمال یِوان کرنٕہ۔﴾',
 			'Hant' => 'رِوٲجی ﴿ترجمع اِشارٕ: یِم ورژن رَسم الخط ہُک ناؤ چھُ چیٖنی باپتھ زَبانٕ ناؤ کِس مجموعَس سٕتؠ اِستعمال یِوان کرنٕہ۔﴾',
 			'Hant@alt=stand-alone' => 'رِوٲجی ہان ﴿ترجمع اِشارٕ: یِم ورژن رَسم الخط ہُک ناؤ چھُ چیٖنی باپتھ زَبانٕ ناؤ کِس مجموعَس بغٲرٕ الگ اِستعمال یِوان کرنٕہ۔﴾',
 			'Hebr' => 'ہِبرِو',
 			'Hira' => 'ہیٖراگانا',
 			'Hmng' => 'پَہاو مانگ',
 			'Hrkt' => 'کَٹاکانا یا ہِراگانا',
 			'Hung' => 'پرون ہَنگیریَن',
 			'Inds' => 'اِنڈَس',
 			'Ital' => 'اولڈ اِٹیلِک',
 			'Java' => 'جاوَنیٖز',
 			'Jpan' => 'جاپٲنی',
 			'Kali' => 'کایا لی',
 			'Kana' => 'کَتاکانا',
 			'Khar' => 'خَروشتھی',
 			'Khmr' => 'کھٕمیر',
 			'Knda' => 'کَنَڑا',
 			'Kore' => 'کوریَن',
 			'Lana' => 'لانا',
 			'Laoo' => 'لاو',
 			'Latf' => 'فرکتُر لیٹِن',
 			'Latg' => 'گیلِک لیٹَن',
 			'Latn' => 'لاطیٖنی',
 			'Lepc' => 'لیپکا',
 			'Limb' => 'لِمبوٗ',
 			'Lina' => 'لیٖنیَر اے',
 			'Linb' => 'لیٖنیَر بی',
 			'Lyci' => 'لیسِیَن',
 			'Lydi' => 'لیدِیَن',
 			'Mand' => 'مَندییَن',
 			'Mani' => 'مانیشییَن',
 			'Maya' => 'مایَن ہیٖروگلِپھ',
 			'Mero' => 'مِرایٹِک',
 			'Mlym' => 'مَلیالَم',
 			'Mong' => 'مَنگولیَن',
 			'Moon' => 'موٗن',
 			'Mtei' => 'میتی مایَک',
 			'Mymr' => 'مَیَنمار',
 			'Nkoo' => 'این کو',
 			'Ogam' => 'اوگہام',
 			'Olck' => 'اول چِکی',
 			'Orkh' => 'اورکھون',
 			'Orya' => 'اورِیا',
 			'Osma' => 'اوسمانیا',
 			'Perm' => 'اولڈ پٔرمِک',
 			'Phag' => 'پھاگس پا',
 			'Phlv' => 'بوٗک پَہَلوی',
 			'Phnx' => 'پھونِشِیَن',
 			'Plrd' => 'پولاڑ پھونِٹِک',
 			'Rjng' => 'ریجَنگ',
 			'Roro' => 'رونگو رونگو',
 			'Runr' => 'رَنِک',
 			'Samr' => 'سَمارِٹَن',
 			'Sara' => 'سَراتی',
 			'Saur' => 'سوراشٹرا',
 			'Sgnw' => 'اِشارٲتی لِکھٲے',
 			'Shaw' => 'شاویَن',
 			'Sinh' => 'سِنہالا',
 			'Sund' => 'سَنڈَنیٖز',
 			'Sylo' => 'سیلوتی ناگری',
 			'Syrc' => 'سیٖرِیَک',
 			'Syre' => 'ایسٹرینجِلو سیٖرِیَک',
 			'Syrj' => 'مغرِبی سیٖریَک',
 			'Syrn' => 'مشرَقی سیٖریَک',
 			'Tagb' => 'تَگبَنوا',
 			'Tale' => 'تَیلیے',
 			'Talu' => 'نۆو تیلو',
 			'Taml' => 'تَمِل',
 			'Telu' => 'تیلگوٗ',
 			'Teng' => 'تینگوار',
 			'Tfng' => 'تِفِناگ',
 			'Tglg' => 'تَگَلوگ',
 			'Thaa' => 'تھانا',
 			'Thai' => 'تھاے',
 			'Tibt' => 'تِبتی',
 			'Ugar' => 'اُگارِٹِک',
 			'Vaii' => 'واے',
 			'Visp' => 'وِزِبٕل سپیٖچ',
 			'Xpeo' => 'پرون فارسی',
 			'Xsux' => 'سُمیرو اکادیَن کوٗنِفام',
 			'Yiii' => 'یٖی',
 			'Zxxx' => 'لیکھنَے',
 			'Zyyy' => 'عام',
 			'Zzzz' => 'نامولوٗم رَسم الخط',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'دُنیا',
 			'002' => 'اَفریٖکا',
 			'003' => 'شُمٲلی اَمریٖکا',
 			'005' => 'جَنوٗنی اَمرٖیٖکا',
 			'009' => 'اوشَنیا',
 			'011' => 'مَغریٖبی اَفریٖکا',
 			'013' => 'مرکٔزی اَمریٖکا',
 			'014' => 'مَشرِقی اَفریٖکا',
 			'015' => 'شُمٲلی اَفریٖکا',
 			'017' => 'وسطی اَفریٖکا',
 			'018' => 'جنوٗبی اَفریٖکا',
 			'019' => 'اَمریٖکَس',
 			'021' => 'شُمٲلی اَمریٖکا خٕطہٕ',
 			'029' => 'کَرِببیٖن',
 			'030' => 'مَشرِقی ایشیا',
 			'034' => 'جنوٗبی ایشیا',
 			'035' => 'جنوٗبہِ مَشرِقی ایشیا',
 			'039' => 'جنوٗبی یوٗرَپ',
 			'053' => 'آسٹریلیشیا',
 			'054' => 'مؠلَنیٖشِیا',
 			'057' => 'مَیکرونَیشِیَن خٕطہٕ',
 			'061' => 'پالنیشِیا',
 			'142' => 'ایشیا',
 			'143' => 'مرکٔزی ایشیا',
 			'145' => 'مَغرِبی ایشیا',
 			'150' => 'یوٗرَپ',
 			'151' => 'مشرِقی یوٗرَپ',
 			'154' => 'شُمٲلی یوٗرَپ',
 			'155' => 'مغرِبی یوٗرَپ',
 			'202' => 'ذیلی سہارن افریقہ',
 			'419' => 'لاطیٖنی اَمریٖکا',
 			'AC' => 'ایسنشن جزیرٕ',
 			'AD' => 'اینڈورا',
 			'AE' => 'مُتحدہ عرَب امارات',
 			'AF' => 'اَفغانَستان',
 			'AG' => 'اؠنٹِگُوا تہٕ باربوڑا',
 			'AI' => 'انگوئیلا',
 			'AL' => 'البانیا',
 			'AM' => 'اَرمانِیا',
 			'AO' => 'انگولا',
 			'AQ' => 'اینٹارٹِکا',
 			'AR' => 'أرجَنٹینا',
 			'AS' => 'اَمریٖکَن سَموا',
 			'AT' => 'آسٹریا',
 			'AU' => 'آسٹریلِیا',
 			'AW' => 'اَروٗبا',
 			'AX' => 'ایلینڑ جٔزیٖرٕ',
 			'AZ' => 'آذربائیجان',
 			'BA' => 'بوسنِیا تہٕ ہَرزِگووِنا',
 			'BB' => 'باربیڈوس',
 			'BD' => 'بَنگلادیش',
 			'BE' => 'بیلجِیَم',
 			'BF' => 'بُرکِنا فیسو',
 			'BG' => 'بَلجیرِیا',
 			'BH' => 'بحریٖن',
 			'BI' => 'بورَنڈِ',
 			'BJ' => 'بِنِن',
 			'BL' => 'سینٹ بارتَھیلمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونے',
 			'BO' => 'بولِوِیا',
 			'BQ' => 'کیریبین نیدرلینڈس',
 			'BR' => 'برازِل',
 			'BS' => 'بَہامَس',
 			'BT' => 'بوٗٹان',
 			'BV' => 'بووَٹ جٔزیٖرٕ',
 			'BW' => 'بوتَسوانا',
 			'BY' => 'بیلاروٗس',
 			'BZ' => 'بیلز',
 			'CA' => 'کینیڈا',
 			'CC' => 'کوکَس (کیٖلِنگ) جٔزیٖرٕ',
 			'CD' => 'کونگو کِنشاسا',
 			'CD@alt=variant' => 'کونگو (ڈی آر سی)',
 			'CF' => 'مرکٔزی اَفریٖکی جموٗریَت',
 			'CG' => 'کونگو بٔرزاوِلی',
 			'CG@alt=variant' => 'کونگو (جمہوریہ)',
 			'CH' => 'سُوِزَرلینڑ',
 			'CI' => 'کوٹ ڈلوائر',
 			'CK' => 'کُک جٔزیٖرٕ',
 			'CL' => 'چِلی',
 			'CM' => 'کیمِروٗن',
 			'CN' => 'چیٖن',
 			'CO' => 'کولَمبِیا',
 			'CP' => 'کلیپرٹن جزیرٕ',
 			'CR' => 'کوسٹا ریکا',
 			'CU' => 'کیوٗبا',
 			'CV' => 'کیپ ؤرڑی',
 			'CW' => 'کیوراکو',
 			'CX' => 'کرِسمَس جٔزیٖرٕ',
 			'CY' => 'سائپرس',
 			'CZ' => 'چیکیا',
 			'DE' => 'جرمٔنی',
 			'DG' => 'ڈیگو گریشیا',
 			'DJ' => 'جِبوٗتی',
 			'DK' => 'ڈینمارٕک',
 			'DM' => 'ڈومِنِکا',
 			'DO' => 'ڈومِنِکَن جموٗرِیَت',
 			'DZ' => 'اؠلجیرِیا',
 			'EA' => 'سیوٹا تٕہ مٔلیلا',
 			'EC' => 'اِکواڑور',
 			'EE' => 'ایسٹونِیا',
 			'EG' => 'مصر',
 			'EH' => 'مشرِقی سَہارا',
 			'ER' => 'اِرٕٹِیا',
 			'ES' => 'سٕپین',
 			'ET' => 'اِتھوپِیا',
 			'EU' => 'یوٗرپی یونین',
 			'EZ' => 'یوٗرو زون',
 			'FI' => 'فِن لینڈ',
 			'FJ' => 'فِجی',
 			'FK' => 'فٕلاکلینڑ جٔزیٖرٕ',
 			'FM' => 'مائیکرونیشیا',
 			'FO' => 'فارو جزیرہ',
 			'FR' => 'فرانس',
 			'GA' => 'گیبان',
 			'GB' => 'متحدہ مملِکت',
 			'GD' => 'گرینیڈا',
 			'GE' => 'جارجِیا',
 			'GF' => 'فرانسِسی گِانا',
 			'GG' => 'گورنسے',
 			'GH' => 'گانا',
 			'GI' => 'جِبرالٹَر',
 			'GL' => 'گرین لینڈ',
 			'GM' => 'گَمبِیا',
 			'GN' => 'گِنی',
 			'GP' => 'گواڈلوپ',
 			'GQ' => 'اِکوِٹورِیَل گِنی',
 			'GR' => 'گریٖس',
 			'GS' => 'جنوٗبی جارجِیا تہٕ جنوٗبی سینڑوٕچ جٔزیٖرٕ',
 			'GT' => 'گواٹمالا',
 			'GU' => 'گُوام',
 			'GW' => 'گیٖنی بِساو',
 			'GY' => 'گُیانا',
 			'HK' => 'ہانگ کانگ ایس اے آر چیٖن',
 			'HK@alt=short' => 'ہانگ کانگ',
 			'HM' => 'ہَرٕڑ تہٕ مؠکڈونالڑٕ جٔزیٖرٕ',
 			'HN' => 'ہونڈورس',
 			'HR' => 'کروشِیا',
 			'HT' => 'ہیتی',
 			'HU' => 'ہَنگری',
 			'IC' => 'کینری جزیرٕ',
 			'ID' => 'انڈونیشیا',
 			'IE' => 'اَیَرلینڑ',
 			'IL' => 'اسرا ییل',
 			'IM' => 'آیِل آف مین',
 			'IN' => 'ہِندوستان',
 			'IO' => 'برطانوی بحرِ ہِندؠ علاقہٕ',
 			'IQ' => 'ایٖراق',
 			'IR' => 'ایٖران',
 			'IS' => 'اَیِسلینڑ',
 			'IT' => 'اِٹلی',
 			'JE' => 'جٔرسی',
 			'JM' => 'جَمایکا',
 			'JO' => 'جورڈن',
 			'JP' => 'جاپان',
 			'KE' => 'کِنیا',
 			'KG' => 'کرغزستان',
 			'KH' => 'کَمبوڑِیا',
 			'KI' => 'کِرٕباتی',
 			'KM' => 'کَمورَس',
 			'KN' => 'سینٹ کِٹَس تہٕ نیوِس',
 			'KP' => 'شُمٲلی کورِیا',
 			'KR' => 'جنوٗبی کورِیا',
 			'KW' => 'کُویت',
 			'KY' => 'کیمَن جٔزیٖرٕ',
 			'KZ' => 'قازقستان',
 			'LA' => 'لاس',
 			'LB' => 'لؠبنان',
 			'LC' => 'سینٹ لوٗسِیا',
 			'LI' => 'لِکٹیسٹیٖن',
 			'LK' => 'سری لنکا',
 			'LR' => 'لایبیرِیا',
 			'LS' => 'لیسوتھو',
 			'LT' => 'لِتھُوانِیا',
 			'LU' => 'لَکسَمبٔرٕگ',
 			'LV' => 'لیٹوِیا',
 			'LY' => 'لِبیا',
 			'MA' => 'موروکو',
 			'MC' => 'مونیکو',
 			'MD' => 'مولڈووا',
 			'ME' => 'موٹونیگِریو',
 			'MF' => 'سینٹ مارٹِن',
 			'MG' => 'میڈاگاسکار',
 			'MH' => 'مارشَل جٔزیٖرٕ',
 			'MK' => 'شُمالی میسڈونیا',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برما)',
 			'MN' => 'مَنگولِیا',
 			'MO' => 'مَکاوو ایس اے آر چیٖن',
 			'MO@alt=short' => 'ماکاوو',
 			'MP' => 'شُمٲلی مارِیانا جٔزیٖرٕ',
 			'MQ' => 'مارٹِنِک',
 			'MR' => 'مارٕٹانِیا',
 			'MS' => 'مانٹسیراٹ',
 			'MT' => 'مالٹا',
 			'MU' => 'مورِشَس',
 			'MV' => 'مالدیٖو',
 			'MW' => 'ملاوی',
 			'MX' => 'مؠکسِکو',
 			'MY' => 'مَلیشِیا',
 			'MZ' => 'موزَمبِک',
 			'NA' => 'نامِبِیا',
 			'NC' => 'نِو کیلِڑونِیا',
 			'NE' => 'نایجَر',
 			'NF' => 'نارفاک جٔزیٖرٕ',
 			'NG' => 'نایجیرِیا',
 			'NI' => 'ناکاراگُوا',
 			'NL' => 'نیٖدَرلینڑ',
 			'NO' => 'ناروے',
 			'NP' => 'نیپال',
 			'NR' => 'نارووٗ',
 			'NU' => 'نیوٗ',
 			'NZ' => 'نیوزی لینڈ',
 			'OM' => 'اومان',
 			'PA' => 'پَناما',
 			'PE' => 'پیٖروٗ',
 			'PF' => 'فرانسی پولِنیشِیا',
 			'PG' => 'پاپُوا نیوٗ گیٖنی',
 			'PH' => 'فلپائن',
 			'PK' => 'پاکِستان',
 			'PL' => 'پولینڈ',
 			'PM' => 'سینٹ پیٖری تہٕ موکیلِیَن',
 			'PN' => 'پِٹکیرٕنؠ جٔزیٖرٕ',
 			'PR' => 'پٔرٹو رِکو',
 			'PS' => 'فلسطینی علاقٕہ',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پُرتِگال',
 			'PW' => 'پَلاو',
 			'PY' => 'پَراگُے',
 			'QA' => 'قَطِر',
 			'QO' => 'آوُٹلاینِگ اوشینِیا',
 			'RE' => 'رِیوٗنِیَن',
 			'RO' => 'رومانِیا',
 			'RS' => 'سَربِیا',
 			'RU' => 'روٗس',
 			'RW' => 'روٗوانڈا',
 			'SA' => 'سعودی عرب',
 			'SB' => 'سولامان جٔزیٖرٕ',
 			'SC' => 'سیشَلِس',
 			'SD' => 'سوٗڈان',
 			'SE' => 'سویڈن',
 			'SG' => 'سِنگاپوٗر',
 			'SH' => 'سینٹ ہؠلِنا',
 			'SI' => 'سَلووینِیا',
 			'SJ' => 'سَوالبریڑ تہٕ جان ماییڑ',
 			'SK' => 'سَلوواکِیا',
 			'SL' => 'سیرا لیون',
 			'SM' => 'سین میرِنو',
 			'SN' => 'سینیگَل',
 			'SO' => 'سومالِیا',
 			'SR' => 'سُرِنام',
 			'SS' => 'جنوبی سوڈان',
 			'ST' => 'ساو توم تہٕ پرنسِپی',
 			'SV' => 'ایل سلویڈر',
 			'SX' => 'سِنٹ مارٹِن',
 			'SY' => 'شام',
 			'SZ' => 'ایسواتنی',
 			'SZ@alt=variant' => 'سویزیلینڈ',
 			'TA' => 'ٹریسٹن ڈا کنہا',
 			'TC' => 'تُرکس تٕہ کیکو جزیرٕ',
 			'TD' => 'چاڑ',
 			'TF' => 'فرانسِسی جَنوٗبی عَلاقہٕ',
 			'TG' => 'ٹوگو',
 			'TH' => 'تھائی لینڈ',
 			'TJ' => 'تاجکِستان',
 			'TK' => 'ٹوکلو',
 			'TL' => 'تیمور-لیسٹ',
 			'TM' => 'تُرکمنستان',
 			'TN' => 'ٹونیشِیا',
 			'TO' => 'ٹونگا',
 			'TR' => 'تُرکی',
 			'TT' => 'ٹرنِنداد تہٕ ٹوبیگو',
 			'TV' => 'توٗوالوٗ',
 			'TW' => 'تایوان',
 			'TZ' => 'تَنجانِیا',
 			'UA' => 'یوٗرِکین',
 			'UG' => 'یوٗگانڑا',
 			'UM' => 'یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنگ جٔزیٖرٕ',
 			'UN' => 'متحدہ مُمٲلک',
 			'US' => 'یوٗنایٹِڑ سِٹیٹِس',
 			'UY' => 'یوٗروگے',
 			'UZ' => 'اُزبِکِستان',
 			'VA' => 'ویٹِکَن سِٹی',
 			'VC' => 'سینٹ وینسؠٹ تہٕ گریناڑاینٕز',
 			'VE' => 'وینازوٗلا',
 			'VG' => 'بَرطانوی ؤرجِن جٔزیٖرٕ',
 			'VI' => 'یوٗ ایس ؤرجِن جٔزیٖرٕ',
 			'VN' => 'ویتنام',
 			'VU' => 'وانوٗتوٗ',
 			'WF' => 'والِس تہٕ فیوٗچوٗنا',
 			'WS' => 'سامو',
 			'XA' => 'سوڈو-ایسنٹس',
 			'XB' => 'سوڈو-بیڈی',
 			'XK' => 'کوسوو',
 			'YE' => 'یَمَن',
 			'YT' => 'مَییٹ',
 			'ZA' => 'جنوبی افریقہ',
 			'ZM' => 'زیمبیا',
 			'ZW' => 'زِمبابے',
 			'ZZ' => 'نامولوٗم علاقٕہ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'رؠوٲتی جٔرمَن عِلمہِ ہِجا',
 			'1994' => 'مَیعٲری روٗسی عِلمہِ ہِجا',
 			'1996' => 'جٔرمَن عِلمہِ ہِجا ۱۹۹۶سُک',
 			'1606NICT' => 'بعد وَقت وَسطی فرانس پؠٹھ ۱۶٠۶ تام',
 			'AREVELA' => 'مَشرِقی اَمریٖکا',
 			'BAKU1926' => 'جٔمع کٔرِتھ تُرکی لاطیٖنی اَچھر',
 			'BISKE' => 'سین جارجِیو/بِلا بوٗلؠ',
 			'FONIPA' => 'آوازیات',
 			'FONUPA' => 'یوٗ پی اے آوازِیات',
 			'LIPAW' => 'روٗسی زَبانہِ ہِنز لِپوواز بوٗلؠ',
 			'MONOTON' => 'اَکٔے لہجہٕ واجؠن زَبان',
 			'NEDIS' => 'نؠٹِسون بوٗلؠ',
 			'NJIVA' => 'نیجِوا بوٗلؠ',
 			'OSOJS' => 'اُشیکو/اوسوجین بوٗلؠ',
 			'POLYTON' => 'واریاہ لہجہٕ واجؠن زَبان',
 			'POSIX' => 'کَمپیوٗٹَر',
 			'REVISED' => 'دُبارٕ دۄہراونہٕ آمُت عِلمہِ ہِجا',
 			'ROZAJ' => 'روٗسی',
 			'SAAHO' => 'سوہو',
 			'SCOTLAND' => 'سُکاٹِش مَیعٲری اَنگریٖزؠ',
 			'SCOUSE' => 'سِکوس',
 			'SOLBA' => 'ثٹولوِزا/سولبِکا بوٗلؠ',
 			'TARASK' => 'تاراسکیٖوِکا علمہ ہِجاِ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'کیلنڑر',
 			'currency' => 'ضَرب',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بُدَن ہُند کیلنڑَر},
 				'chinese' => q{چیٖنی کیلَنڑَر},
 				'gregorian' => q{گرگوریَن کیلنڑَر},
 				'hebrew' => q{ہِبرِو کیلنڑَر},
 				'indian' => q{انڈین نیشنل کیلنڈر},
 				'islamic' => q{اِسلٲمی کیلنڑَر},
 				'islamic-civil' => q{اِسلٲمی اِجتمٲیی کیلنڑَر},
 				'iso8601' => q{ISO-8601 کیلنڈر},
 				'japanese' => q{جاپٲنؠ کیلنڑَر},
 				'roc' => q{جموٗریٲتی چیٖنی کیلَنڑَر},
 			},
 			'collation' => {
 				'big5han' => q{رؠوٲتی چیٖنی تِرتیٖب},
 				'phonebook' => q{فون بُک تَرتیٖب},
 				'pinyin' => q{آسان بَناونہٕ آمُت چیٖنی پیٖنیَن تَرتیٖب},
 				'standard' => q{معیٲری ترتیٖب آڈر},
 				'stroke' => q{رؠوٲتی چیٖنی سٹروک تَرتیٖب},
 				'traditional' => q{رؠوٲتی تَرتیٖب},
 			},
 			'numbers' => {
 				'arab' => q{اَربی-اِنڈِک ہندسٕہ},
 				'arabext' => q{توسیٖع شُدہ اَربی-اِنڈِک ہندسٕہ},
 				'deva' => q{دیوناگری ہندسٕہ},
 				'latn' => q{مغربی ہندسٕہ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{میٖٹرِک},
 			'UK' => q{یو کے},
 			'US' => q{یو ایس},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'زَبان: {0}',
 			'script' => 'رَسم الخط: {0}',
 			'region' => 'علاقہٕ: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‎‏ َ ُ ِ ٔ ٕ ٟ ٖ ٗ ئ]},
			main => qr{[ء آ أ ٲ ؤ ا ب پ ت ث ٹ ج چ ح خ د ذ ڈ ر ز ڑ ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن ں ھ ہ و ۄ ۆ ی ؠ ے]},
			numbers => qr{[‎ \- ‑ , ٫ ٬ . % ‰ + 0۰ 1۱ 2۲ 3۳ 4۴ 5۵ 6۶ 7۷ 8۸ 9۹]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return {};
},
);


has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0} دۄہ),
						'other' => q({0} دۄہ),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0} دۄہ),
						'other' => q({0} دۄہ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} گَنٹہٕ),
						'other' => q({0} گٲنٹہٕ),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} گَنٹہٕ),
						'other' => q({0} گٲنٹہٕ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0} مِنَٹ),
						'other' => q({0} مِنَٹ),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0} مِنَٹ),
						'other' => q({0} مِنَٹ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0} ریتھ),
						'other' => q({0} ریتھ),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0} ریتھ),
						'other' => q({0} ریتھ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0} سیکَنڈ),
						'other' => q({0} سیکَنڈ),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0} سیکَنڈ),
						'other' => q({0} سیکَنڈ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} ہَفتہٕ),
						'other' => q({0} ہَفتہٕ),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} ہَفتہٕ),
						'other' => q({0} ہَفتہٕ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0} ؤری),
						'other' => q({0} ؤری),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0} ؤری),
						'other' => q({0} ؤری),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سؠنٹی میٖٹَر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سؠنٹی میٖٹَر),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کِلومیٖٹر),
						'per' => q({0} فی کِلومیٖٹر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کِلومیٖٹر),
						'per' => q({0} فی کِلومیٖٹر),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(میٖٹَر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(میٖٹَر),
					},
				},
				'short' => {
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(دۄہ),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(دۄہ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(گٲنٹہٕ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(گٲنٹہٕ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(مِنَٹ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(مِنَٹ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ریتھ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ریتھ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سیکَنڈ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سیکَنڈ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ہَفتہٕ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ہَفتہٕ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ؤری),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ؤری),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کلومیٹر),
						'per' => q({0}/کِلومیٖٹر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کلومیٹر),
						'per' => q({0}/کِلومیٖٹر),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:آ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نَہ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}، {1}),
				middle => q({0}، {1}),
				end => q({0}، تٕہ {1}),
				2 => q({0} تٕہ {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'timeSeparator' => q(:),
		},
		'latn' => {
			'group' => q(،),
		},
	} }
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(اؠڑورَن پیسِٹا),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(مُتحدہ عرب اِمارات دِرہم),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(افغان افغٲنی),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(اؠلبینِیَن لِک),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(اَرمانؠن ڈرؠم),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(نایدَرلینڑ اؠنٹٕلیٖیَن گِلڑَر),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(اؠنگولَن کوانزا),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(اؠنگولَن کوانزا رؠجِسٹاڑو),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(أرجَنٹیٖن اَسٹرل),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(أرجَنٹیٖن پِسو),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(آسٹریَن شِلِنگ),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(آسٹریلِیَن ڈالَر),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(اَروبَن فِلورِن),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(آزَرباجانی مَنَٹ),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(بوزنِیاہَرزِگووِنا دیٖنار),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوزنِیاہَرزِگووِنا کَنوٲٹیبٕل مارٕک),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(بابیڑِیَن ڈالَر),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(بَنگلادیٖشی ٹَکا),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(بَلجِیَن فرینک),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(بیلگیرِیَن ہاڑ لِو),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(بحریٖنی دیٖنار),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(بُرُنڑِین فرینک),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(بٔرمیوٗڑَن ڈالَر),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(برونی ڈالَر),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولِوِیَن بولوینو),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(بولویَن پِسو),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(بولوِیَن مَوڈال),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(برازیٖلین کروزِرو نووو),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(برازیٖلین کروزیڑو),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(برازیٖلین کروزِرو),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(برازیٖلی رِیَل),
				'one' => q(برازیٖلی رِیَل),
				'other' => q(برازیٖلی رِیَلز),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(برازیٖلین کروزیڑو نووو),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(برازیٖلین کروزیرو),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(بہامِیَن ڈالر),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(بوٗٹینیٖز نگُلٹرم),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(بٔرمیٖز کیٹ),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوٹٕسوانَن پُلا),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(بِلیروشِیَن نِو رِبٕل),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(بِلیروشِیَن رِبٕل),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(بِلیروشِیَن رِبٕل \(۲۰۰۰–۲۰۱۶\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بِلِزی ڈالر),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(کینَڑِیَن ڈالر),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(کونگولیٖز فریک),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(وِر یوٗرو),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(سُوِز فریک),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(وِر فریک),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(چِلِن یوٗنِڑیدیٖز ڑِ فومیٹو),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چِلِن پِسو),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(چیٖنی یُوان),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(کولَمبِین پِسو),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(ِٖیوٗنِڑیڑ ڑِ ویلور رِیل),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(کوسٹا رِکَن کولَن),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(پرون سٔربِین ڈالر),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(چِکوسولوواک ہاڑ کوروٗنا),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(کیوٗبَن پِسو),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(کیپروٹ پَوُڑ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(چیک کوریٖنا),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(مٔشرِقی جٔرمَن مارٕک),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(جٔرمَن مارٕک),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ڈٔنِش کرون),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ڈومِنِکَن پِسو),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(اؠلجیرِیَن ڈیٖنار),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(اؠسٹونِیَن کرون),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(اِجِپٹِیَن پَوُنڑ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(رِٹریٖن نَفکا),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(سِپینِش پیسِٹا),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(اِتھوپِیَن بِر),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(یوٗرو),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(فِنِش مارکا),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فِجین ڈالر),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(فیکلینڑِس آیلینڑ پونڑ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانسِسی فریک),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(برطٲنوی پوٗنڈ),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(جارجِیَن کیوٗپَن لَرِٹ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(جارجِیَن لاری),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(گَنییَن سؠڑی\(۱۹۷۹–۲٠٠۷\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(گَنییَن سؠڑی),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(گِبریلٹَر پَاونڑ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(گیمبِیاہُک دلاسی),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(گِنِیَن فرینک),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(گِنِیَن سِلی),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(اِکویٹورِیَل گِنِیَن اؠکویٖل),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(گریٖسُک ڑرؠکما),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(گواٹَمالَن قیوٗٹزَل),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(پورتگیٖزُک گِنی اؠسکیوٗڑو),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(گِنی بِساوُک پؠسو),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(گَیَنیٖزُک ڑالَر),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(حانگ کانگُک ڑالَر),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(حونڑورنُک لؠمپیٖرا),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(کروایشنُک دیٖنار),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(کروایشنُک کوٗنا),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(حیشَنُک گوڑ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(حَنگیرِیَن فورِنٹ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(اِنڑونیشیاہُک رُپِیاہ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(اَیرلینڑُک پاونڑ),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(اِزرٲیِلی پاونڑ),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(اِزرٲیِلی نٔوؠ شؠقٕل),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(ہِندُستٲنؠ رۄپَے),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ایٖراقُک دیٖنار),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ایٖرانُک رِیال),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(اَیسلینڑُک کرونا),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(اِٹلیٖ یُک لیٖرا),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(جَمَیکاہُک ڑالَر),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(جَرڑینیاہُک دیٖنار),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(جاپانُک یَن),
				'one' => q(جاپٲن یَن),
				'other' => q(جاپٲن یَن),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(کؠنیَن شِلِنگ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(کِرگِستانُک سوم),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(کَمبوڑِیاہُک رِیال),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(کومورِیَن فرینک),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(جنوٗبی کورِیَن وَن),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(ساوتھ کورِیَن وَن),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(قُویتُک دیٖنار),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(کیمین ججیٖرُک ڑالَر),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(کزاکِستان ٹینج),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لَوٹِیَن کِپ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لیبنیٖزُک پاونڑ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(سری لَنکاہٕچ رۄپَے),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(لَیبیرِیَن ڑالَر),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لِسوتھو لوٹی),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(لِتھوینِیَن لِٹاس),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(لِتھوینِیَن ٹؠلوناس),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(لَکزٕمبورگِیَن کَنؤرٹِبٕل فرینک),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(لَکزٕمبورگِیَن فرینک),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(لَکزٕمبوگ فَینانشَل فرینک),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(لَتوِیَن لیٹس),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(لَتوِیَن رَبٕل),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(لِبیَن دیٖنار),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(موروکَن دِرہَم),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(موروکَن فرینک),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مولڑووین لیوٗ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(مؠلؠگیسی اؠریَری),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(مؠلؠگیسی فرینک),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(مؠکَڑونِیَن دیٖنار),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(میلِیَن فرینک),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(مِیانما کیاٹ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(مۄنگولِیَن ٹُگرِک),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(مؠکانیٖز پَٹاکا),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(مورِٹینِیَن عوگیوٗیا \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(مورِٹینِیَن عوگیوٗیا),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(مالٹیٖزُک لیٖرا),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(مالٹیٖزُک پاونڑ),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(مورؠشِیاہٕچ رۄپَے),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالدِیٖوِیَن رُفِیا),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(مؠلیوِیَن کواچا),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(مؠکسِکَن پؠسو),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(مؠکسِکَن سِلوَر پؠسو \(۱۸۶۱–۱۹۹۲\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(مَلیشِیَن رِنگِٹ),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(موزیمبِکَن سکیوٗڑو),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(پرون موزیمبِکَن مؠٹِکَل),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزیمبِکَن مؠٹِکَل),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(نامِبِیَن ڑالَر),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نَیجیرِیَن ڑالَر),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(نِکؠراگُوؠن کورڑوبا),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(نِکؠراگُوؠن کورڑوبا اورو),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(ڈَچ گِلڑَر),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(نوروییِنُک کرون),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نیپالٕچ رۄپَے),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(نِوزیٖلینڑُک ڑالَر),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(اومِنی رِیال),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پانامانِیَن بالبوز),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(پٔریوٗوِیَن اِنٹی),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پٔریوٗوِیَن سولٕز),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(پٔریوٗوِیَن سول \(۱۸۶۳–۱۹۶۵\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(نیوٗ پیپُعا گِنِیَن کیٖنا),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(پھِلِپایِٔن پؠسو),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(پاکِستٲنؠ رۄپَے),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولِش زلوٹی),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(پولِش زلوٹی\(۱۹۵٠–۱۹۹۵\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(پورتُگیٖز اؠسکیوٗڑو),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پؠرؠگیوٗوَیَن گُعارانی),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(قطاری رِیال),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(رھوڑیشِیَن ڑالَر),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(اولڑ رومانِیَن لؠیوٗ),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(رومانِیَن لؠیوٗ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سٔربِیَن دیٖنار),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(روٗسی رَبٕل),
				'one' => q(روٗسی رَبٕل),
				'other' => q(روٗسی رَبٕلز),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(رٔشیَن رَبٕل\(۱۹۹۱–۱۹۹۸\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(روانڑَن فرانک),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(سودیٖیُک رِیال),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولَمَن جٔزیٖرُک ڈالَر),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(پرون سوٗڈانُک دیٖنار),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سوٗڈانُک پونڈ),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(پرون سوٗڈانُک پونڈ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(سویٖڈِش کَرونا),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(سِنگاپورُک ڈالَر),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(سینٹ ہیلِنا پونڈ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(سلووینُک ٹولَر),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(سلووَک کَرونا),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(سومالی شِلِنگ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سُریٖنامُک ڈالَر),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(سُریٖنام گِلدَر),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(سوویت روبٕل),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(سَلویدَرُک کولَن),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(سیٖریاہُک پونڈ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سوازی لِلَنگینی),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(تھایھک بات),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(تاجکِستانُک رَبٕل),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجِکتانُک سَمونی),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(تُکَمَنِستانُک مَنَت),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ٹُنیشیاہُک دیٖنار),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ٹونگَن پانگا),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(ٹیموریسو ایکیٖڈو),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(پرون تُرکِش لیرا),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(تُرکیہُک لیرا),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ٹرِنہِ ڈیڈ تہٕ ٹوبیگو ڈالَر),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(نۆو تیوانُک ڈالَر),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تَنزانیاہُک شِلِنگ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(یوٗکرینیاہُک ہرِوِنیا),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(یوٗکرینیاہُک کاربووَنیٹس),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(اُگاداہُک شِلِنگ\(۱۹۶۶–۱۹۸۷\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(اُگاداہُک شِلِنگ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(US ڈالر),
				'one' => q(US ڈالر),
				'other' => q(US ڈالرس),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(یوٗ ایس ڈالَر\(پَگاہ\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(یوٗ ایس ڈالَر\(تَمی دًۄہ\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(اُرگایَن پیسو یوٗنِڈیڈَس اِنڈیکسَس),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(اُرگایَن پیسو\(۱۹۷۵–۱۹۹۳\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(اُروٗگایَن پیسو),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(اُبیکِستان سوم),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(وینٕزوٗلیُک بولِوَر \(۱۸۷۱–۲۰۰۸\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(وینٕزوٗلیُک بولِوَر \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(وینٕزوٗلیُک بولِوَر),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(وِیَنَمُک ڈانگ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(وَنوٗاَتوٗ وَتوٗ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(سَمون تَلا),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(سی ایف اے فرینک بی ایٖ اے سی),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(رۄپھ),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(سۄن),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(یوٗرپی کَمپوسِٹ یوٗنِٹ),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(یوٗرپی مونِٹَری یوٗنِٹ),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(یوٗرپی یوٗنِٹ آف ایکاوُنٹ \(ایکس بی سی\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(یوٗرپی یوٗنِٹ آف ایکاوُنٹ \(ایکس بی ڈی\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(مَشرِقی کیرِبِیَن ڈالَر),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(خاص ڈرایِنگ رایٹس),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(یوٗرپی کَرَنسی یوٗنِٹ),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(فرینچ گولڈ فرینک),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(فرینچ یوٗ اے سی فرینک),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(سی ایف اے فرینک بی سی ایٖ اے او),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(پُلیڈیَم),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(سی ایف پی فرینک),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(پلیٹِنَم),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(آر آے این ایٖ ٹی فَنڈ),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(ٹیسٹِنگ کَرَنسی کوڈ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(نامولوٗم کرنسی),
				'one' => q(﴿کرنسی ہُنٛد نامولوٗم سِکٕہ﴾),
				'other' => q(﴿نانولوٗم کرنسی﴾),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(یَمنُک دیٖنار),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(یَمنُک رِیال),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(یوگوسلاوِیَن ہاڑ دیٖنار),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(یوگوسلاوِیَن نووِے دیٖنار),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(یوگوسلاوِیَن کَنؤٹِبٕل دیٖنار),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(ساوُتھ افریٖکاہُک رینڈ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(زِمبابیُک کواچا \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زِمبابیُک کواچا),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(زایرِیَن نِو زایِر),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(زَیرُک ڈالَر),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(زِمبابِیُک ڈالَر),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'جنؤری',
							'فرؤری',
							'مارٕچ',
							'اپریل',
							'مئی',
							'جوٗن',
							'جُلَے',
							'اگست',
							'ستمبر',
							'اکتوٗبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنؤری',
							'فرؤری',
							'مارٕچ',
							'اپریل',
							'مئی',
							'جوٗن',
							'جُلَے',
							'اگست',
							'ستمبر',
							'اکتوٗبر',
							'نومبر',
							'دَسَمبَر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'جنؤری',
							'فرؤری',
							'مارٕچ',
							'اپریل',
							'مئی',
							'جوٗن',
							'جوٗلایی',
							'اگست',
							'ستمبر',
							'اکتوٗبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ج',
							'ف',
							'م',
							'ا',
							'م',
							'ج',
							'ج',
							'ا',
							'س',
							'س',
							'ا',
							'ن'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنؤری',
							'فرؤری',
							'مارٕچ',
							'اپریل',
							'مئی',
							'جوٗن',
							'جوٗلایی',
							'اگست',
							'ستمبر',
							'اکتوٗبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیٖع الاول',
							'ربیٖع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذِی القعدہ',
							'ذِی الحج'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ژٔندٕروار',
						tue => 'بۆموار',
						wed => 'بودوار',
						thu => 'برؠسوار',
						fri => 'جُمہ',
						sat => 'بٹوار',
						sun => 'آتھوار'
					},
					wide => {
						mon => 'ژٔندرٕروار',
						tue => 'بۆموار',
						wed => 'بودوار',
						thu => 'برؠسوار',
						fri => 'جُمہ',
						sat => 'بٹوار',
						sun => 'اَتھوار'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'ژ',
						tue => 'ب',
						wed => 'ب',
						thu => 'ب',
						fri => 'ج',
						sat => 'ب',
						sun => 'ا'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'کیو 1',
						1 => 'کیو 2',
						2 => 'کیو 3',
						3 => 'کیو 4'
					},
					wide => {0 => 'گۄڑنیُک ژۄباگ',
						1 => 'دۆیِم ژۄباگ',
						2 => 'تریِم ژۄباگ',
						3 => 'ژوٗرِم ژۄباگ'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'am' => q{a},
					'pm' => q{p},
				},
				'wide' => {
					'am' => q{اے ایم},
					'pm' => q{پی ایم},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'بی سی',
				'1' => 'اے ڈی'
			},
			wide => {
				'0' => 'قبٕل مسیٖح',
				'1' => 'اینو ڈومنی'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ساکا'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, MMMM d, y},
			'long' => q{MMMM d, y},
			'medium' => q{MMM d, y},
			'short' => q{M/d/yy},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Gy => q{Gy},
			GyMMM => q{MMM Gy},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{MMM d, y G},
			GyMd => q{M/d/y GGGGG},
			MEd => q{E, M/d},
			MMMEd => q{E, MMM d},
			MMMMEd => q{E, MMMM d},
			Md => q{M/d},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, M/d/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, MMM d, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{MMM d, y G},
			yyyyMd => q{M/d/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{MMM d, y G},
			GyMd => q{M/d/y GGGGG},
			MEd => q{E, M/d},
			MMMEd => q{E, MMM d},
			MMMMEd => q{E, MMMM d},
			MMMMW => q{ہفتہ W از MMMM},
			Md => q{M/d},
			yM => q{M/y},
			yMEd => q{E, M/d/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, MMM d, y},
			yMMMM => q{MMMM y},
			yMd => q{M/d/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{ہفتہ w از Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, M/d – E, M/d},
				d => q{E, M/d – E, M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, MMM d – E, MMM d},
				d => q{E, MMM d – E, MMM d},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			yMd => {
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
		},
		'gregorian' => {
			GyM => {
				G => q{M/y G – M/y G},
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			GyMEd => {
				G => q{E, M/d/y G – E, M/d/y G},
				M => q{E, M/d/y – E, M/d/y G},
				d => q{E, M/d/y – E, M/d/y G},
				y => q{E, M/d/y – E, M/d/y G},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y G – M/d/y G},
				M => q{M/d/y – M/d/y G},
				d => q{M/d/y – M/d/y G},
				y => q{M/d/y – M/d/y G},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, M/d – E, M/d},
				d => q{E, M/d – E, M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, MMM d – E, MMM d},
				d => q{E, MMM d – E, MMM d},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, M/d/y – E, M/d/y},
				d => q{E, M/d/y – E, M/d/y},
				y => q{E, M/d/y – E, M/d/y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, MMM d – E, MMM d, y},
				d => q{E, MMM d – E, MMM d, y},
				y => q{E, MMM d, y – E, MMM d, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{MMM d – MMM d, y},
				d => q{MMM d – d, y},
				y => q{MMM d, y – MMM d, y},
			},
			yMd => {
				M => q{M/d/y – M/d/y},
				d => q{M/d/y – M/d/y},
				y => q{M/d/y – M/d/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtZeroFormat => q(جی ایم ٹی),
		regionFormat => q({0} وَکھ),
		regionFormat => q({0} ڈے لائٹ وَکھ),
		regionFormat => q({0} معیٲری وَکھ),
		'Acre' => {
			long => {
				'daylight' => q#اؠکرے سَمَر ٹایِم#,
				'generic' => q#اؠکرے ٹایِم#,
				'standard' => q#اؠکرے سٹینڑاڑ ٹایِم#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#افغانِستان ٹایِم#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#عابِدجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اؠکرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#عدیس ابابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#اَلجیٖرِیا#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اَسمیرا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#بماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بؠنگوٗیی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بَنجوٗل#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بِساؤں#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلانتَیر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاوِل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بُجُمبُرا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#کَیرو#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کؠسابلؠنکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#کیوٗٹا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کوناکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#دَکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دارالسلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ڈِجیبوٹی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ڈوولا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ال عیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری ٹاوُن#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گؠبورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ہَراریے#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوہانسبرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کَمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#کھارتوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کِگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کِنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لیگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لِبَروِل#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لیوانڈا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبم باشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لوساکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#مالابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#مَپوٗٹو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#مَسیروٗ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مابین#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادِشوٗ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونرووِیا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نیروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#جَمیٖنا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نَیمیے#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نوواکچھوت#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اوآگدوگو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورٹو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ساو ٹوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ترپولی#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ٹوٗنِس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#وِنڈہوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#مرکزی افریٖقا ٹایِم#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#مشرقی افریٖقا ٹایِم#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#جنوٗبی افریقا ٹایِم#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#مغربی افریٖقا سَمَر ٹایِم#,
				'generic' => q#مغربی افریٖقا ٹایِم#,
				'standard' => q#مغربی افریٖقا سٹینڈرڈ ٹایِم#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#اؠلاسکا ڈےلایِٔٹ ٹایِم#,
				'generic' => q#اؠلاسکا ٹایِم#,
				'standard' => q#اؠلاسکا سٹینڑاڑ ٹایِم#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#اؠلمؠٹی سَمَر ٹایِم#,
				'generic' => q#اؠلمؠٹی ٹایِم#,
				'standard' => q#اؠلمؠٹی سٹینڑاڑ ٹایِم#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#اؠمَزَن سَمَر ٹایِم#,
				'generic' => q#اؠمَزَن ٹایِم#,
				'standard' => q#اؠمَزَن سٹینڑاڑ ٹایِم#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ادک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اَنکوراج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#اؠنگِولا#,
		},
		'America/Antigua' => {
			exemplarCity => q#اؠنٹِگُوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اؠریگُوینا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا رِیوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#رِیو گالیگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالٹا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سین جُواں#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سین لوٗیِس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٹوکوٗمَن#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اُشُوٗاییا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اَروٗبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اَسُنچِیَن#,
		},
		'America/Bahia' => {
			exemplarCity => q#بَہِیا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#باہیا بندارس#,
		},
		'America/Barbados' => {
			exemplarCity => q#بارباڈوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بؠلؠم#,
		},
		'America/Belize' => {
			exemplarCity => q#بؠلیٖز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانک سؠبلَن#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوآ وِسٹا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بوگوٹا#,
		},
		'America/Boise' => {
			exemplarCity => q#بویِس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بیوٗنَس آیرَس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کیمبرِج خلیٖج#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کؠمپو گرینڑ#,
		},
		'America/Cancun' => {
			exemplarCity => q#کینکَن#,
		},
		'America/Caracas' => {
			exemplarCity => q#کیرَکَس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کیٹامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کَیین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمَن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شِکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چِہُوا ہُوا#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اٹی کوکنٍ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کورڑوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کوسٹا ریٖکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کریسٹن#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کوٗیابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کیوٗراکااو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڈنمارک شاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڈاوسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڈواسَن کریٖک#,
		},
		'America/Denver' => {
			exemplarCity => q#ڈینوَر#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڈیٹرایِٹ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڈومِنِکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#اؠڈمَنٹَن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایٖروٗنیپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ایل سَلویدَر#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورٹ نیلسن#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٹیلیزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس خلیٖج#,
		},
		'America/Godthab' => {
			exemplarCity => q#نوٗک#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوٗس خلیٖج#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گرینڈ تٔرک#,
		},
		'America/Grenada' => {
			exemplarCity => q#گریناڈا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گوڑلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواٹیمالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوایاکِوَل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گُیانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#حیلِفؠکس#,
		},
		'America/Havana' => {
			exemplarCity => q#حوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ۂرموسِلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#نوکس#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#میرنگو، انڈیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پِٹس بٔرگ، انڈیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٹیل سِٹی، انڈیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویویے، انڈیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#وِنسینیس، انڈیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#وِنیمیک، انڈیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#اِنڈیَن پولِس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#اِنوٗوِک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#اِقالیوٗیِت#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جَمَیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جُجویے#,
		},
		'America/Juneau' => {
			exemplarCity => q#جوٗنی#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٹِسیلو، کینٹوکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالینڈِک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لِما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اینجٕلز#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوٗیِس وِل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوور پرنس کوارٹر#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسِیوو#,
		},
		'America/Managua' => {
			exemplarCity => q#مَناگوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#مَنوس#,
		},
		'America/Marigot' => {
			exemplarCity => q#میریگوٹ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٹِنِک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#میٹاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#مَزَٹلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مؠنڑوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومِنی#,
		},
		'America/Merida' => {
			exemplarCity => q#میرِڈا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#میٹلا کاٹلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#میکسِکو سِٹی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#مِکیٖلَن#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونکٹٕن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#موٹیری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٹیوِڈیو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونژیرات#,
		},
		'America/Nassau' => {
			exemplarCity => q#نساؤں#,
		},
		'America/New_York' => {
			exemplarCity => q#نِو یارک#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونہا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولاہ، شُمالی ڈیکوٹا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#مَرکزی جنوٗبی ڈکوٹا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نوو سیلٕم، شُمالی ڈیکوٹا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوجی ناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پَناما#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پَرامارِبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#پھِنِکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پوٹ آؤں پرِنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پوٹ آف سپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پوٹو وؠلہو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پیٖٹو رِکو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پونٹا اریناس#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رینکِن اِنلؠٹ#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسیف#,
		},
		'America/Regina' => {
			exemplarCity => q#رؠجیٖنا#,
		},
		'America/Resolute' => {
			exemplarCity => q#رِسولیوٗٹ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#رِیو برانکو#,
		},
		'America/Santarem' => {
			exemplarCity => q#سانتاریم#,
		},
		'America/Santiago' => {
			exemplarCity => q#سینٹیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سؠنٹو ڑومِنگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ساؤ پالو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#سکورٕسباےسَنڑ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سِٹکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سینٹ بارتھیلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سؠنٹ جونس#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سینٹ کِٹس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سؠنٹ لوٗسِیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سینٹ تھامَس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سینٹ وِنسینٹ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سٕوِفٹ کَرَنٹ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ٹیگوسی گالپا#,
		},
		'America/Thule' => {
			exemplarCity => q#تھیوٗلے#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تِجُوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٹورونٹو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٹارٹولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وؠنکووَر#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وایِٹ ہارٕس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وِنِپؠگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یکوٗتات#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#مرکزی ڈےلایِٔٹ ٹایِم#,
				'generic' => q#مرکزی ٹایِم#,
				'standard' => q#مرکزی سٹینڑاڑ ٹایِم#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#مشرقی ڈےلایِٔٹ ٹایِم#,
				'generic' => q#مشرقی ٹایِم#,
				'standard' => q#مشرقی سٹینڑاڑ ٹایِم#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ماونٹین ڈےلایِٔٹ ٹایِم#,
				'generic' => q#ماونٹین ٹایِم#,
				'standard' => q#ماونٹین سٹینڑاڑ ٹایِم#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#پیسِفِک ڈےلایِٔٹ ٹایِم#,
				'generic' => q#پیسِفِک ٹایِم#,
				'standard' => q#پیسِفِک سٹینڑاڑ ٹایِم#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#اؠنڑیٖر سَمَر ٹایِم#,
				'generic' => q#اؠنَڑیٖر ٹایِم#,
				'standard' => q#اؠنَڑیٖر سٹینڑاڑ ٹایِم#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڈیوِس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڈُمونٹ ڈ اَروِل#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماسَن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#مؠک مٲڑو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پامَر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روتھیرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سیووا#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوک#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q#اؠکٹاؤ سَمَر ٹایِم#,
				'generic' => q#اؠکٹاؤ ٹایِم#,
				'standard' => q#اؠکٹاؤ سٹینڑاڑ ٹایِم#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#اؠکٹوب سَمَر ٹایِم#,
				'generic' => q#اؠکٹوب ٹایِم#,
				'standard' => q#اؠکٹوب سٹینڑاڑ ٹایِم#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#ارؠبِیَن ڈےلایِٔٹ ٹایِم#,
				'generic' => q#ارؠبِیَن ٹایِم#,
				'standard' => q#ارؠبِیَن سٹینڈرڈ ٹایِم#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لونگ ییئر بئین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارجؠنٹیٖنا سَمَر ٹایِم#,
				'generic' => q#ارجؠنٹیٖنا ٹایِم#,
				'standard' => q#ارجؠنٹیٖنا سٹینڑاڑ ٹایِم#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#مغربی ارجؠنٹیٖنا سَمَر ٹایِم#,
				'generic' => q#مغربی ارجؠنٹیٖنا ٹایِم#,
				'standard' => q#مغربی ارجؠنٹیٖنا سٹینڑاڑ ٹایِم#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ارمیٖنِیا سَمَر ٹایِم#,
				'generic' => q#ارمیٖنِیا ٹایِم#,
				'standard' => q#ارمیٖنِیا سٹینڈرڈ ٹایِم#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ایڈٕن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#اَلماٹی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#اَمان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#اَنَدیر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اکٹو#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اَقٹوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اَشگَبَت#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#اٹیرو#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بؠہریٖن#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باقوٗ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بینگ کاک#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#برنول#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیرٹ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بِشکیک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#بروٗنَے#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کَلٕکَتا#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چیٹا#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کولَمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دَمَسکَس#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڈھاکا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دِلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دُبئی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دُشانبیے#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاما گوسٹا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزہ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ہیبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ہانگ کانگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#حووڑ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#اِرکُسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جکارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جَیاپوٗرا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#یروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#قابُل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کَمچھٹکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کَراچی#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاٹھمَنڈوٗ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#کھانڈیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کرنسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کولالَمپوٗر#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کُچِنگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کُویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مکو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#مَگادَن#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#مَکَسَر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#مَنیٖلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نِکوسِیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکُزنیٹسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوووسِبِرسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورَل#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#نوم پؠنہہ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونتِعانک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگیانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#کوسٹانے#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#قؠزؠلوڑا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنگوٗن#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#سیگَن#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#سَکھالِن#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سَمَرکَند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سیول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شانگے#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سِنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سریڈنیکولیمسک#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تَیپیے#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشکینٹ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#بِلِسی#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تؠہران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تھِمپوٗ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٹوکیو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ٹومسک#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولن باٹر#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#اُرومقی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوسٹ-نیرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وِیَنتِیین#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#لادِووستوک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یکوسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یَکاتِرِنبٔرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#یےریوَن#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#اؠٹلانٹِک ڈےلایِٔٹ ٹایِم#,
				'generic' => q#اؠٹلانٹِک ٹایِم#,
				'standard' => q#اؠٹلانٹِک سٹینڑاڑ ٹایِم#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#اَزورَس#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برموٗڑا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#کؠنَری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ ؤرڑے#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فؠرو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مَڈیٖرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#رؠکیاوِک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جنوبی جارجیا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سینٹ ہیلِنا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#سٹینلی#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#اؠڑِلیڑ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکٕن ہِل#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڈاروِن#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#یوٗکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#حۄبٲٹ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لِنڑیمان#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لعاڑ ہووے#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#مؠلبعارن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پٔرتھ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سِڑنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#آسٹریلِیَن مرکزی ڈےلایِٔٹ ٹایِم#,
				'generic' => q#مرکزی آسٹریلِیَن ٹایِم#,
				'standard' => q#آسٹریلِیَن مرکزی سٹینڑاڑ ٹایِم#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#آسٹریلِیَن مرکزی مغربی ڈےلایِٔٹ ٹایِم#,
				'generic' => q#آسٹریلِیَن مرکزی مغربی ٹایِم#,
				'standard' => q#آسٹریلِیَن مرکزی مغربی سٹینڑاڑ ٹایِم#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#آسٹریلِیَن مشرقی ڈےلایِٔٹ ٹایِم#,
				'generic' => q#مشرِقی آسٹریلِیا ٹایِم#,
				'standard' => q#آسٹریلِیَن مشرقی سٹینڑاڑ ٹایِم#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#آسٹریلِیَن مغرِبیٖ ڈےلایٔٹ ٹایِم#,
				'generic' => q#مغرِبی آسٹریلِیا ٹایِم#,
				'standard' => q#آسٹریلِیَن مغرِبی سٹینڑاڑ ٹایِم#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ازربائیجان سَمَر ٹائم#,
				'generic' => q#ازربائیجان ٹائم#,
				'standard' => q#ازربائیجان سٹینڈرڈ ٹائم#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#اؠزورٕس سَمَر ٹائم#,
				'generic' => q#اؠزورٕس ٹایِم#,
				'standard' => q#اؠزورٕس سٹینڑاڑ ٹایِم#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بَنگلادیش سَمَر ٹایِم#,
				'generic' => q#بَنگلادیش ٹایِم#,
				'standard' => q#بَنگلادیش سٹینڑاڑ ٹایِم#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#بوٗٹان ٹایِم#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولِوِیا ٹایِم#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#برؠسِلِیا سَمَر ٹایِم#,
				'generic' => q#برؠسِلِیا ٹایِم#,
				'standard' => q#برؠسِلِیا سٹینڑاڑ ٹایِم#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#بروٗنَے دَروٗسَلَم ٹایِم#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#کیپ سَمَر ٹایِم#,
				'generic' => q#کیپ ؤرڑو ٹایِم#,
				'standard' => q#کیپ ؤرڑو سٹینڈرڈ ٹایِم#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#کؠمورو سٹینڑاڑ ٹایِم#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چؠتھَم سَمَر ٹایِم#,
				'generic' => q#کؠتھَم ٹایِم#,
				'standard' => q#کؠتھَم سٹینڑاڑ ٹایِم#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چِلی سَمَر ٹایِم#,
				'generic' => q#چِلی ٹایِم#,
				'standard' => q#چِلی سٹینڑاڑ ٹایِم#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#چَینا ڈےلایِٔٹ ٹایِم#,
				'generic' => q#چَینا ٹایِم#,
				'standard' => q#چَینا سٹینڈرڈ ٹایِم#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#کرسمَس ٹایِم#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#کوکوز اَیلینڑز ٹایِم#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#کولومبِیا سَمَر ٹایِم#,
				'generic' => q#کولومبِیا ٹایِم#,
				'standard' => q#کولومبِیا سٹینڑاڑ ٹایِم#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#کُک اَیلینڑز حاف سَمَر ٹایِم#,
				'generic' => q#کُک اَیلینڑز ٹایِم#,
				'standard' => q#کُک اَیلینڑز سٹینڑاڑ ٹایِم#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#کیوٗبا ڈےلایِٔٹ ٹایِم#,
				'generic' => q#کیوٗبا ٹایِم#,
				'standard' => q#کیوٗبا سٹینڑاڑ ٹایِم#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ڑیوِس ٹایِم#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ڑمانٹ ڈی اُرویٖل ٹایِم#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ایٖسٹ ٹیٖمَر ٹایِم#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ایٖسٹَر جزیرٕ سَمَر ٹایِم#,
				'generic' => q#ایٖسٹَر جزیرٕ ٹایِم#,
				'standard' => q#ایٖسٹَر جزیرٕ سٹینڈرڈ ٹایِم#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#اِکویڑَر ٹایِم#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#کوآرڈنیٹڈ یونیورسل وَکھ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#غٲر زان#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ایمسٹَرڈیم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#اَنڈورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#ایسٹرا کھان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#اؠتھٕنس#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بیلگریڈ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#بٔرلِن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#بریٹیسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برسٕلس#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بَچاریسٹ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بُڈاپیسٹ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بوسِنگین#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چِسیٖنو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کوپن ہیگن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڈَبلِن#,
			long => {
				'daylight' => q#اَیرِش سَمَر ٹایِم#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#گِبرالٹَر#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گویرنسے#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#حؠلسِنکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#آئل آف مین#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#اِستانبُل#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کَلِناِنگرَد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیٖو#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#کیرو#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لِسبَن#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لِیوٗب لِیانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لَندَن#,
			long => {
				'daylight' => q#برطٲنوی سَمَر ٹایِم#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لَکزٕمبٔرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#میڈریڈ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٹا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#میری ہیم#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مِنسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پیرِس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوڈگوریکا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#رِگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سَمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سین مرینو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سارا جیوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ساراٹو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سِمفیروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#سِکوپیے#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#سوفِیا#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#سٹاک ہولم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ٹؠلِن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ٹِرین#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#اولیانووسک#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#وادُز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ویٹیکن#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#وِیَننا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#وِلِنِیَس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگرَد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زگریب#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زیوٗرِک#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#مرکزی یوٗرپی سَمَر ٹایِم#,
				'generic' => q#مرکزی یوٗرپی ٹایِم#,
				'standard' => q#مرکزی یوٗرپی سٹینڑاڑ ٹایِم#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#مشرقی یوٗرپی سَمَر ٹایِم#,
				'generic' => q#مشرقی یوٗرپی ٹایِم#,
				'standard' => q#مشرقی یوٗرپی سٹینڑاڑ ٹایِم#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#مزید مشرقی یورپی ٹائم#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#مغرِبی یوٗرِپی سَمَر ٹایِم#,
				'generic' => q#مغرِبی یوٗرپی ٹایِم#,
				'standard' => q#مغرِبی یوٗرپی سٹینڈرڈ ٹایِم#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فالک لینڈ جزیرٕ سَمَر ٹائم#,
				'generic' => q#فالک لینڈ جزیرٕ ٹائم#,
				'standard' => q#فالک لینڈ جزیرٕ سٹینڈرڈ ٹائم#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فیٖجی سَمَر ٹایِم#,
				'generic' => q#فیٖجی ٹایِم#,
				'standard' => q#فیٖجی سٹینڑاڑ ٹایِم#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فرؠنچ گیوٗؠنا ٹایِم#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فرینچ جنوبی تٕہ انٹارکٹِک ٹائم#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گریٖن وِچ میٖن ٹایِم#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گؠلؠپیگوز ٹایِم#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گؠمبِیَر ٹایِم#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#جورجِیاہُک سَمَر ٹایِم#,
				'generic' => q#جورجِیاہُک ٹایِم#,
				'standard' => q#جورجِیاہُک سٹینڈرڈ ٹایِم#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#گِلبٲٹ ججیٖرُک ٹایِم#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#مشرِقی گریٖن لینڈُک سَمَر ٹایِم#,
				'generic' => q#مشرِقی گریٖن لینڈُک ٹایِم#,
				'standard' => q#مشرِقی گریٖن لینڈُک سٹینڑاڑ ٹایِم#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#مغرِبی گریٖن لینڈُک سَمَر ٹایِم#,
				'generic' => q#مغرِبی گریٖن لینڈُک ٹایِم#,
				'standard' => q#مغرِبی گریٖن لینڈُک سٹینڑاڑ ٹایِم#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#گُوؠم ٹایِم#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#گَلف سٹینڈرڈ ٹایِم#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گُیَنا ٹایِم#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#حَواے اؠلیوٗٹِیَن سَمَر ٹایِم#,
				'generic' => q#حَواے اؠلیوٗٹِیَن ٹایِم#,
				'standard' => q#حَواے اؠلیوٗٹِیَن سٹینڑاڑ ٹایِم#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ہانگ کانگ سَمر ٹائم#,
				'generic' => q#ہانگ کانگ ٹائم#,
				'standard' => q#ہانگ کانگ سٹینڈرڈ ٹائم#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#حووڑ سَمَر ٹایِم#,
				'generic' => q#حووڑ ٹایِم#,
				'standard' => q#حووڑ سٹینڈرڈ ٹایِم#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ہِندوستان#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#اؠنٹنانرِوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کرِسمَس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کیرگولِن#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماہیے#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیٖوز#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#مورِشیس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#میوٹ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#رِیوٗنیَن#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ہِندوستٲنؠ اوشَن ٹائم#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#اِنڑوچَینا ٹایِم#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#مرکزی اِنڑونیشِیا ٹایِم#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#مشرِقی اِنڑونیشِیا ٹایِم#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#مغرِبی اِنڑونیشِیا ٹایِم#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#اِیٖرٲنی سَمَر ٹایِم#,
				'generic' => q#اِیٖرٲنؠ ٹایِم#,
				'standard' => q#اِیٖرٲنؠ سٹینڑاڑ ٹایِم#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#اِرکُٹسک سَمَر ٹایِم#,
				'generic' => q#اِرکُٹسک ٹایِم#,
				'standard' => q#اِرکُٹسک سٹینڈرڈ ٹایِم#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#اِسرٲیِلی ڑےلایِٔٹ ٹایِم#,
				'generic' => q#اِسرٲیِلی ٹایِم#,
				'standard' => q#اِسرٲیِلی سٹینڈرڈ ٹایِم#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپٲنؠ ڑےلایِٔٹ ٹایِم#,
				'generic' => q#جاپٲنؠ ٹایِم#,
				'standard' => q#جاپٲنؠ سٹینڈرڈ ٹایِم#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#کَمچَٹکا سَمَر ٹایِم#,
				'generic' => q#کَمچَٹکا ٹایِم#,
				'standard' => q#کَمچَٹکا سٹینڑاڑ ٹایِم#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#مشرقی قازقستان ٹائم#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#مغربی قازقستان ٹائم#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#کورِیا ڑےلایِٔٹ ٹایِم#,
				'generic' => q#کورِیا ٹایِم#,
				'standard' => q#کورِیا سٹینڈرڈ ٹایِم#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#کورسَے ٹایِم#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#کرؠسنوےیارسک سَمَر ٹایِم#,
				'generic' => q#کرؠسنوےیارسک ٹایِم#,
				'standard' => q#کرؠسنوےیارسک سٹینڈرڈ ٹایِم#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#کرغزستان ٹائم#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#لَنکا ٹایِم#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لایِٔن ججیٖرُک ٹایِم#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لعاڑ ڑےلایٔٹ ٹایِم#,
				'generic' => q#لعاڑ حووے ٹایِم#,
				'standard' => q#لعاڑ حووے سٹینڑاڑ ٹایِم#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#مَکَعوٗ سَمَر ٹایِم#,
				'generic' => q#مَکَعوٗ ٹایِم#,
				'standard' => q#مَکَعوٗ سٹینڑاڑ ٹایِم#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#مَگَدَن سَمَر ٹایِم#,
				'generic' => q#مَگَدَن ٹایِم#,
				'standard' => q#مَگَدَن سٹینڈرڈ ٹایِم#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#مَلیشِیا ٹایِم#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالدیٖوٕز ٹایِم#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#مارقیوٗسَس ٹایِم#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشَل ججیٖرُک ٹایِم#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#مورِشَس سَمَر ٹایِم#,
				'generic' => q#مورِشَس ٹایِم#,
				'standard' => q#مورِشَس سٹینڈرڈ ٹایِم#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ماسَن ٹایِم#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#میکسیکن پیسیفک ڈے لائٹ ٹائم#,
				'generic' => q#میکسیکن پیسیفک ٹائم#,
				'standard' => q#میکسیکن پیسیفک سٹینڈرڈ ٹائم#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#اولن باٹر سَمَر ٹایِم#,
				'generic' => q#اولن باٹر ٹائم#,
				'standard' => q#اولن باٹر سٹینڈرڈ ٹائم#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسکو سَمَر ٹایِم#,
				'generic' => q#ماسکَو ٹایِم#,
				'standard' => q#ماسکو سٹینڈرڈ ٹایِم#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#مِیانمَر ٹایِم#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#نَعوٗروٗ ٹایِم#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نؠپٲلؠ ٹایِم#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#نِو کیلؠڑونِیس سَمَر ٹایِم#,
				'generic' => q#نِو کیلؠڑونِیا ٹایِم#,
				'standard' => q#نِو کیلؠڑونِیا سٹینڑاڑ ٹایِم#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#نِوزِلینڑ ڑےلایٔٹ ٹایِم#,
				'generic' => q#نِوزِلینڑ ٹایِم#,
				'standard' => q#نِوزِلینڑ سٹینڑاڑ ٹایِم#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نیو فاؤنڈ لینڈ ڈے لائٹ ٹائم#,
				'generic' => q#نیو فاؤنڈ لینڈ ٹائم#,
				'standard' => q#نیو فاؤنڈ لینڈ سٹینڈرڈ ٹائم#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نِیوٗ ٹایِم#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#نورفعاک سَمَر ٹایِم#,
				'generic' => q#نورفعاک ٹایِم#,
				'standard' => q#نورفعاک سٹینڑاڑ ٹایِم#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فرنینڈو ڈی نورونہا سَمَر ٹائم#,
				'generic' => q#فرنینڈو ڈی نورونہا ٹائم#,
				'standard' => q#فرنینڈو ڈی نورونہا سٹینڈرڈ ٹائم#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#شُمٲلی مَرِیانا ٹایِم#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نۄوۄسِبٔرسک سَمَر ٹایِم#,
				'generic' => q#نۄوۄسِبٔرسک ٹایِم#,
				'standard' => q#نۄوۄسِبٔرسک سٹینڈرڈ ٹایِم#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#اۄمسک سَمَر ٹایِم#,
				'generic' => q#اۄمسک ٹایِم#,
				'standard' => q#اۄمسک سٹینڈرڈ ٹایِم#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#آپِیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آکلینڈ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چَتھَم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایٖسٹَر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ایفاتیے#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اؠنڑربیری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فَکَوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فِجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فُنافوٗتی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گؠلَپگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گیمبِیَر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گُوادَلچَنَل#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ہونولو لو#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کِرِتِماتی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسراے#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کُوجلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مَجوٗرو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکیسَس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#مِڈویے#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ناوروٗ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نِو#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفوک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نومیی#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پیگو پیگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پَلاو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پِٹکیرَن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پوناپے#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پوٹ مورسبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٹونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سَیپان#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تَہِتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ٹَراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#تونگاتَپوٗ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ٹرک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ویلِس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاکِستان سَمَر ٹایِم#,
				'generic' => q#پاکِستان ٹایِم#,
				'standard' => q#پاکِستان سٹینڑاڑ ٹایِم#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پَلاو ٹایِم#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپُعا نیوٗ گؠنی ٹایِم#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پیرؠگوے سَمَر ٹایِم#,
				'generic' => q#پیرؠگوے ٹایِم#,
				'standard' => q#پیرؠگوے سٹینڈرڈ ٹایِم#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پٔروٗ سَمَر ٹایِم#,
				'generic' => q#پٔروٗ ٹایِم#,
				'standard' => q#پٔروٗ سٹینڈرڈ ٹایِم#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#پھِلِپایِن سَمَر ٹایِم#,
				'generic' => q#پھِلِپایِن ٹایِم#,
				'standard' => q#پھِلِپایِن سٹینڑاڑ ٹایِم#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#پھونِکس ججیٖرُک ٹایِم#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سینٹ پَیری مِقیوٗلَن ڑےلایِٔٹ ٹایِم#,
				'generic' => q#سینٹ پَیری مِقیوٗلَن ٹایِم#,
				'standard' => q#سینٹ پَیری مِقیوٗلَن سٹینڑاڑ ٹایِم#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پِٹکیرٕن ٹایِم#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پونیپ ٹایِم#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#یونگ یانگ ٹائم#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#قِزلوڑا سَمَر ٹایِم#,
				'generic' => q#قِزلوڑا ٹایِم#,
				'standard' => q#قِزلوڑا سٹینڑاڑ ٹایِم#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#رِیوٗنِیَن ٹایِم#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روتھؠرا ٹایِم#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#سَکھؠلِن سَمَر ٹایِم#,
				'generic' => q#سَکھؠلِن ٹایِم#,
				'standard' => q#سَکھؠلِن سٹینڈرڈ ٹایِم#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#سمؠرا سَمَر ٹایِم#,
				'generic' => q#سمؠرا ٹایِم#,
				'standard' => q#سمؠرا سٹینڑاڑ ٹایِم#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#سؠموآ سَمَر ٹایِم#,
				'generic' => q#سؠموآ ٹایِم#,
				'standard' => q#سؠموآ سٹینڑاڑ ٹایِم#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#سیشؠلٕز ٹایِم#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سِنگاپوٗر ٹایِم#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولومَن ججیٖرَن ہُند ٹایِم#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#شُمٲلی جورجِیا ٹایِم#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سُرِنام ٹایِم#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سیووا ٹایِم#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ٹاہِٹی ٹایِم#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ٹے پے ڈے لائٹ ٹائم#,
				'generic' => q#ٹے پے ٹائم#,
				'standard' => q#ٹے پے سٹینڈرڈ ٹائم#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجکستان ٹائم#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ٹوکؠلو ٹایِم#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ٹعانگا سَمَر ٹایِم#,
				'generic' => q#ٹعانگا ٹایِم#,
				'standard' => q#ٹعانگا سٹینڑاڑ ٹایِم#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ٹٔرک ٹایِم#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#تُرکمؠنِستان سَمَر ٹایِم#,
				'generic' => q#ترکمانستان ٹائم#,
				'standard' => q#ترکمانستان سٹینڈرڈ ٹائم#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ٹوٗوَلوٗ ٹایِم#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#یوٗرؠگوَے سَمَر ٹایِم#,
				'generic' => q#یوٗرؠگوَے ٹایِم#,
				'standard' => q#یوٗرؠگوَے سٹینڈرڈ ٹایِم#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#اُزبیکِستانُک سَمَر ٹایِم#,
				'generic' => q#اُزبیکِستان ٹایِم#,
				'standard' => q#اُزبیکِستان سٹینڈرڈ ٹایِم#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وَنوٗاَٹوٗ سَمَر ٹایِم#,
				'generic' => q#وَنوٗاَٹوٗ ٹایِم#,
				'standard' => q#وَنوٗاَٹوٗ سٹینڑاڑ ٹایِم#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وؠنؠزیوٗلا ٹایِم#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ولاڑِووسٹوک سَمَر ٹایِم#,
				'generic' => q#ولاڑِووسٹوک ٹایِم#,
				'standard' => q#ولاڑِووسٹوک سٹینڈرڈ ٹایِم#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وولگوگریڑ سَمَر ٹایِم#,
				'generic' => q#وولگوگریڑ ٹایِم#,
				'standard' => q#وولگوگریڑ سٹینڈرڈ ٹایِم#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ووسٹوک ٹایِم#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ویک ججیٖرُک ٹایِم#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#والِس تہٕ فیوٗٹیوٗنا ٹایِم#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#یَکُٹُسک سَمَر ٹایِم#,
				'generic' => q#یَکُٹسک ٹایِم#,
				'standard' => q#یَکُٹسک سٹینڈرڈ ٹایِم#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#یؠکَٹرِنبٔرگ سَمَر ٹایِم#,
				'generic' => q#یؠکَٹٔرِنبٔرگ ٹایِم#,
				'standard' => q#یؠکَٹٔرِنبٔرگ سٹینڈرڈ ٹایِم#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#یوکون ٹائم#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
