# Generated by default/object.tt
package Paws::GameLift::PriorityConfiguration;
  use Moose;
  has LocationOrder => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has PriorityOrder => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::PriorityConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::PriorityConfiguration object:

  $service_obj->Method(Att1 => { LocationOrder => $value, ..., PriorityOrder => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::PriorityConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->LocationOrder

=head1 DESCRIPTION

Custom prioritization settings for use by a game session queue when
placing new game sessions with available game servers. When defined,
this configuration replaces the default FleetIQ prioritization process,
which is as follows:

=over

=item *

If player latency data is included in a game session request,
destinations and locations are prioritized first based on lowest
average latency (1), then on lowest hosting cost (2), then on
destination list order (3), and finally on location (alphabetical) (4).
This approach ensures that the queue's top priority is to place game
sessions where average player latency is lowest, and--if latency is the
same--where the hosting cost is less, etc.

=item *

If player latency data is not included, destinations and locations are
prioritized first on destination list order (1), and then on location
(alphabetical) (2). This approach ensures that the queue's top priority
is to place game sessions on the first destination fleet listed. If
that fleet has multiple locations, the game session is placed on the
first location (when listed alphabetically).

=back

Changing the priority order will affect how game sessions are placed.

Priority configurations are part of a GameSessionQueue.

=head1 ATTRIBUTES


=head2 LocationOrder => ArrayRef[Str|Undef]

The prioritization order to use for fleet locations, when the
C<PriorityOrder> property includes C<LOCATION>. Locations are
identified by AWS Region codes such as C<us-west-2>. Each location can
only be listed once.


=head2 PriorityOrder => ArrayRef[Str|Undef]

The recommended sequence to use when prioritizing where to place new
game sessions. Each type can only be listed once.

=over

=item *

C<LATENCY> -- FleetIQ prioritizes locations where the average player
latency (provided in each game session request) is lowest.

=item *

C<COST> -- FleetIQ prioritizes destinations with the lowest current
hosting costs. Cost is evaluated based on the location, instance type,
and fleet type (Spot or On-Demand) for each destination in the queue.

=item *

C<DESTINATION> -- FleetIQ prioritizes based on the order that
destinations are listed in the queue configuration.

=item *

C<LOCATION> -- FleetIQ prioritizes based on the provided order of
locations, as defined in C<LocationOrder>.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

