# Generated by default/object.tt
package Paws::GuardDuty::UsageCriteria;
  use Moose;
  has AccountIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'accountIds', traits => ['NameInRequest']);
  has DataSources => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'dataSources', traits => ['NameInRequest'], required => 1);
  has Resources => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'resources', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::UsageCriteria

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::UsageCriteria object:

  $service_obj->Method(Att1 => { AccountIds => $value, ..., Resources => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::UsageCriteria object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountIds

=head1 DESCRIPTION

Contains information about the criteria used to query usage statistics.

=head1 ATTRIBUTES


=head2 AccountIds => ArrayRef[Str|Undef]

The account IDs to aggregate usage statistics from.


=head2 B<REQUIRED> DataSources => ArrayRef[Str|Undef]

The data sources to aggregate usage statistics from.


=head2 Resources => ArrayRef[Str|Undef]

The resources to aggregate usage statistics from. Only accepts exact
resource names.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

