# Generated by default/object.tt
package Paws::SageMaker::OidcMemberDefinition;
  use Moose;
  has Groups => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::OidcMemberDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::OidcMemberDefinition object:

  $service_obj->Method(Att1 => { Groups => $value, ..., Groups => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::OidcMemberDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->Groups

=head1 DESCRIPTION

A list of user groups that exist in your OIDC Identity Provider (IdP).
One to ten groups can be used to create a single private work team.
When you add a user group to the list of C<Groups>, you can add that
user group to one or more private work teams. If you add a user group
to a private work team, all workers in that user group are added to the
work team.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Groups => ArrayRef[Str|Undef]

A list of comma seperated strings that identifies user groups in your
OIDC IdP. Each user group is made up of a group of private workers.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

