# Generated by default/object.tt
package Paws::Appflow::ExecutionRecord;
  use Moose;
  has DataPullEndTime => (is => 'ro', isa => 'Str', request_name => 'dataPullEndTime', traits => ['NameInRequest']);
  has DataPullStartTime => (is => 'ro', isa => 'Str', request_name => 'dataPullStartTime', traits => ['NameInRequest']);
  has ExecutionId => (is => 'ro', isa => 'Str', request_name => 'executionId', traits => ['NameInRequest']);
  has ExecutionResult => (is => 'ro', isa => 'Paws::Appflow::ExecutionResult', request_name => 'executionResult', traits => ['NameInRequest']);
  has ExecutionStatus => (is => 'ro', isa => 'Str', request_name => 'executionStatus', traits => ['NameInRequest']);
  has LastUpdatedAt => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedAt', traits => ['NameInRequest']);
  has StartedAt => (is => 'ro', isa => 'Str', request_name => 'startedAt', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::ExecutionRecord

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::ExecutionRecord object:

  $service_obj->Method(Att1 => { DataPullEndTime => $value, ..., StartedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::ExecutionRecord object:

  $result = $service_obj->Method(...);
  $result->Att1->DataPullEndTime

=head1 DESCRIPTION

Specifies information about the past flow run instances for a given
flow.

=head1 ATTRIBUTES


=head2 DataPullEndTime => Str

The timestamp that indicates the last new or updated record to be
transferred in the flow run.


=head2 DataPullStartTime => Str

The timestamp that determines the first new or updated record to be
transferred in the flow run.


=head2 ExecutionId => Str

Specifies the identifier of the given flow run.


=head2 ExecutionResult => L<Paws::Appflow::ExecutionResult>

Describes the result of the given flow run.


=head2 ExecutionStatus => Str

Specifies the flow run status and whether it is in progress, has
completed successfully, or has failed.


=head2 LastUpdatedAt => Str

Specifies the time of the most recent update.


=head2 StartedAt => Str

Specifies the start time of the flow run.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

