#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 260_Slurm-SAQos-echo.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Qos;

my $testDir = dirname(abs_path($0));
our $num_tests_run = 0;

require "$testDir/helpers/echo-help.pl";

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/echo_cmdline");
my $saqos = 'Slurm::Sacctmgr::Qos';

my $results;
my $args;
my $err;
my $argstr;
my (@temp, @temp2);
my ($temp, $temp2);

#Test various commands with echo sacctmgr


my @listtmp1 = ( 'list', 'qos', 'format=description,gracetime,grpcpumins,grpcpus,grpjobs,grpnodes,grpsubmitjobs,grpwall,maxcpumins,maxcpus,maxcpusperuser,maxjobs,maxnodes,maxnodesperuser,maxsubmitjobs,maxwall,name,preempt,preemptmode,priority,usagefactor' );
my @listtmp2 = ( '--parsable2', '--noheader', '--readonly' );
@temp = ( name=>'high-priority', );
$results = $saqos->sacctmgr_list($sa,@temp);
$results = $saqos->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single qos');


@temp = ( preempt=>'scavenger', priority=>10  );
$results = $saqos->sacctmgr_list($sa,@temp);
$results = $saqos->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list qos multi-fields');


@temp = ( name=>'high-priority', description=>'high-priority qos',
	gracetime=>'10', 
	grpcpumins=>60000, grpcpus=>1000, grpjobs=>200, grpnodes=>100, 
	grpsubmitjobs=>150, grpwall=>40000,
	maxcpimins=>120000, maxcpus=>2000, maxjobs=>400, maxnodes=>300,
	maxsubmitjobs=>275, maxwall=>80000,
	preempt=>'scavenger,normal', preemptmode=>'cluster', 
	priority=>10, usagefactor=>2);
$results = $saqos->sacctmgr_add($sa,@temp);
$results = $saqos->_ebadddel_last_raw_output;
$args = [ '-i', 'add', 'qos', hash_to_arglist_lexical(@temp) ];
check_results($args, $results, 'sacctmgr_add qos');

note('Ignore output to stderr about return value from sacctmgr_modify');
@temp = ( name=>'high-priority',  );
@temp2 = ( priority => 75 );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $saqos->sacctmgr_modify($sa,$temp, $temp2);
$results = $saqos->_ebmod_last_raw_output;
$args = [ '-i', 'modify', 'qos', 'where',  hash_to_arglist(@temp), 'set', hash_to_arglist(@temp2) ];
check_results($args, $results, 'sacctmgr_modify qos');

@temp = ( name=>'high-priority', );
$results = $saqos->sacctmgr_delete($sa,@temp);
$results = $saqos->_ebadddel_last_raw_output;
$args = [ '-i', 'delete', 'qos', 'where', hash_to_arglist(@temp) ];
check_results($args, $results, 'sacctmgr_delete qos');


#Now verify that nothing is run when we are in debug mode
note('The remaining tests generate [DRYRUN] lines, which you can ignore');
note('We just want to make sure they dont actually _do_ anything');
$sa->dryrun(1);

@temp = ( name=>'high-priority', description=>'high-priority qos',);
$results = $saqos->sacctmgr_add($sa,@temp);
$results =$saqos->_ebadddel_last_raw_output; 
is_deeply( $results, [], "sacctmgr_add qos (dryrun mode)");
$num_tests_run++;

@temp = ( name=>'high-priority',  );
@temp2 = ( priority => 75 );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $saqos->sacctmgr_modify($sa,$temp, $temp2);
$results = $saqos->_ebmod_last_raw_output;
is_deeply( $results, [], "sacctmgr_modify qos (dryrun mode)");
$num_tests_run++;

@temp = ( name=>'high-priority', );
$results = $saqos->sacctmgr_delete($sa,@temp);
$results = $saqos->_ebadddel_last_raw_output;
is_deeply( $results, [], "sacctmgr_delete qos (dryrun mode)");
$num_tests_run++;

#This one actually _should_ run, as is just a list
@temp = ( name=>'high-priority', );
$results = $saqos->sacctmgr_list($sa,@temp);
$results = $saqos->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single qos (dryrun mode)');

done_testing($num_tests_run);

