# Generated by default/object.tt
package Paws::CloudWatchEvents::Replay;
  use Moose;
  has EventEndTime => (is => 'ro', isa => 'Str');
  has EventLastReplayedTime => (is => 'ro', isa => 'Str');
  has EventSourceArn => (is => 'ro', isa => 'Str');
  has EventStartTime => (is => 'ro', isa => 'Str');
  has ReplayEndTime => (is => 'ro', isa => 'Str');
  has ReplayName => (is => 'ro', isa => 'Str');
  has ReplayStartTime => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');
  has StateReason => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::Replay

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::Replay object:

  $service_obj->Method(Att1 => { EventEndTime => $value, ..., StateReason => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::Replay object:

  $result = $service_obj->Method(...);
  $result->Att1->EventEndTime

=head1 DESCRIPTION

A C<Replay> object that contains details about a replay.

=head1 ATTRIBUTES


=head2 EventEndTime => Str

A time stamp for the time to start replaying events. Any event with a
creation time prior to the C<EventEndTime> specified is replayed.


=head2 EventLastReplayedTime => Str

A time stamp for the time that the last event was replayed.


=head2 EventSourceArn => Str

The ARN of the archive to replay event from.


=head2 EventStartTime => Str

A time stamp for the time to start replaying events. This is determined
by the time in the event as described in Time
(https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time).


=head2 ReplayEndTime => Str

A time stamp for the time that the replay completed.


=head2 ReplayName => Str

The name of the replay.


=head2 ReplayStartTime => Str

A time stamp for the time that the replay started.


=head2 State => Str

The current state of the replay.


=head2 StateReason => Str

A description of why the replay is in the current state.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

