#ifdef __cplusplus
extern "C" {
#endif

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <config.h>
#include <uuid/uuid.h>
#include <uuid/uuidP.h>

#ifdef __cplusplus
}
#endif


/* 2 hex digits per byte + 4 separators + 1 trailing null */
#define UUID_BUF_SZ 37


MODULE = UUID		PACKAGE = UUID


void
generate(str)
    SV * str
    PROTOTYPE: $
    INIT:
    struct uuid uu;
    CODE:
    uuid_generate((unsigned char*)&uu);
    sv_setpvn(str, (unsigned char*)&uu, sizeof(struct uuid));

void
generate_random(str)
    SV * str
    PROTOTYPE: $
    INIT:
    struct uuid uu;
    CODE:
    uuid_generate_random((unsigned char*)&uu);
    sv_setpvn(str, (char*)&uu, sizeof(struct uuid));

void
generate_time(str)
    SV * str
    PROTOTYPE: $
    INIT:
    struct uuid uu;
    CODE:
    uuid_generate_time((unsigned char*)&uu);
    sv_setpvn(str, (char*)&uu, sizeof(struct uuid));

void
unparse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    char str[UUID_BUF_SZ];
    CODE:
    uuid_unparse(sv_grow(in, sizeof(struct uuid)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ-1);

void
unparse_lower(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    char str[UUID_BUF_SZ];
    CODE:
    uuid_unparse_lower(sv_grow(in, sizeof(struct uuid)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ-1);

void
unparse_upper(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    char str[UUID_BUF_SZ];
    CODE:
    uuid_unparse_upper(sv_grow(in, sizeof(struct uuid)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ-1);

int
parse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
    struct uuid uu;
    CODE:
    RETVAL = uuid_parse(sv_grow(in, UUID_BUF_SZ+1), (unsigned char*)&uu);
    if( !RETVAL )
        sv_setpvn(out, (char*)&uu, sizeof(struct uuid));
    OUTPUT:
    RETVAL

void
clear(in)
    SV * in
    PROTOTYPE: $
    INIT:
    struct uuid uu;
    CODE:
    uuid_clear((unsigned char*)&uu);
    sv_setpvn(in, (char*)&uu, sizeof(struct uuid));

int
is_null(in)
    SV * in
    PROTOTYPE: $
    CODE:
    if( SvCUR(in) != sizeof(struct uuid) )
        RETVAL = 0;
    else
        RETVAL = uuid_is_null(sv_grow(in, sizeof(struct uuid)+1));
    OUTPUT:
    RETVAL

void
copy(dst, src)
    SV * dst
    SV * src
    INIT:
    struct uuid uu;
    CODE:
    if( SvCUR(src) != sizeof(struct uuid) )
        uuid_clear((unsigned char*)&uu);
    else
        uuid_copy((unsigned char*)&uu, sv_grow(src, sizeof(struct uuid)+1));
    sv_setpvn(dst, (char*)&uu, sizeof(struct uuid));

int
compare(uu1, uu2)
    SV * uu1
    SV * uu2
    INIT:
    unsigned char *p1;
    unsigned char *p2;
    CODE:
    p1 = (unsigned char*)sv_grow(uu1, sizeof(struct uuid)+1);
    p2 = (unsigned char*)sv_grow(uu2, sizeof(struct uuid)+1);
    RETVAL = uuid_compare(p1, p2);
    OUTPUT:
    RETVAL

int
type(in)
    SV * in
    PROTOTYPE: $
    CODE:
    RETVAL = uuid_type((unsigned char*)sv_grow(in, sizeof(struct uuid)+1));
    OUTPUT:
    RETVAL

time_t
time(in)
    SV * in
    PROTOTYPE: $
    INIT:
    struct timeval tv;
    CODE:
    RETVAL = uuid_time((unsigned char*)sv_grow(in, sizeof(struct uuid)+1), &tv);
    OUTPUT:
    RETVAL

int
variant(in)
    SV * in
    PROTOTYPE: $
    CODE:
    RETVAL = uuid_variant((unsigned char*)sv_grow(in, sizeof(struct uuid)+1));
    OUTPUT:
    RETVAL

SV*
uuid()
    PROTOTYPE:
    INIT:
    struct uuid uu;
    unsigned char str[UUID_BUF_SZ];
    CODE:
    uuid_generate((unsigned char*)&uu);
    uuid_unparse((unsigned char*)&uu, str);
    RETVAL = newSVpvn(str, UUID_BUF_SZ-1);
    OUTPUT:
    RETVAL

int
debug_sizeof_char()
    PROTOTYPE:
    CODE:
    RETVAL = sizeof(char);
    OUTPUT:
    RETVAL

int
debug_sizeof_signed_char()
    PROTOTYPE:
    CODE:
    RETVAL = sizeof(signed char);
    OUTPUT:
    RETVAL

int
debug_sizeof_unsigned_char()
    PROTOTYPE:
    CODE:
    RETVAL = sizeof(unsigned char);
    OUTPUT:
    RETVAL

int
debug_sizeof_struct_uuid()
    PROTOTYPE:
    CODE:
    RETVAL = sizeof(struct uuid);
    OUTPUT:
    RETVAL

int
debug_sizeof_uuid_t()
    PROTOTYPE:
    CODE:
    RETVAL = sizeof(uuid_t);
    OUTPUT:
    RETVAL
