#!/usr/bin/perl

package eBay::API::XML::Call::ValidateTestUserRegistration;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ValidateTestUserRegistration.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::ValidateTestUserRegistration

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::ValidateTestUserRegistration inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::ValidateTestUserRegistration::ValidateTestUserRegistrationRequestType;
use eBay::API::XML::Call::ValidateTestUserRegistration::ValidateTestUserRegistrationResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'ValidateTestUserRegistration';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::ValidateTestUserRegistration::ValidateTestUserRegistrationRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::ValidateTestUserRegistration::ValidateTestUserRegistrationResponseType';
}

#
# input properties
#

=head2 setFeedbackScore()

Value for the feedback score of a user. If no value is passed in the request,
or if the value is zero, the feedback score is unchanged. This element is not intended
for regularly testing feedback because the feedback value can change after the request.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setFeedbackScore {
   my $self   = shift;
   my $sFeedbackScore = shift;
   $self->getRequestDataType()->setFeedbackScore($sFeedbackScore);
}

=head2 setRegistrationDate()

Value for the date and time that a user's registration begins.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut
       
sub setRegistrationDate {
   my $self   = shift;
   my $sRegistrationDate = shift;
   $self->getRequestDataType()->setRegistrationDate($sRegistrationDate);
}

=head2 setSubscribeSA()

Indicates if a user subscribes to Seller's Assistant. You cannot
request to subscribe a user to both Seller's Assistant and
Seller's Assistant Pro. You cannot request to unsubscribe a user.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setSubscribeSA {
   my $self   = shift;
   my $sSubscribeSA = shift;
   $self->getRequestDataType()->setSubscribeSA($sSubscribeSA);
}

=head2 setSubscribeSAPro()

Indicates if a user subscribes to Seller's Assistant Pro. You cannot
request to subscribe a user to both Seller's Assistant and
Seller's Assistant Pro. You cannot request to unsubscribe a user.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setSubscribeSAPro {
   my $self   = shift;
   my $sSubscribeSAPro = shift;
   $self->getRequestDataType()->setSubscribeSAPro($sSubscribeSAPro);
}

=head2 setSubscribeSM()

Indicates if a user subscribes to Selling Manager. You cannot
request to subscribe a user to both Selling Manager and
Selling Manager Pro. You cannot request to unsubscribe a user.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setSubscribeSM {
   my $self   = shift;
   my $sSubscribeSM = shift;
   $self->getRequestDataType()->setSubscribeSM($sSubscribeSM);
}

=head2 setSubscribeSMPro()

Indicates if a user subscribes to Selling Manager Pro. You cannot
request to subscribe a user to both Selling Manager and
Selling Manager Pro. You cannot request to unsubscribe a user.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setSubscribeSMPro {
   my $self   = shift;
   my $sSubscribeSMPro = shift;
   $self->getRequestDataType()->setSubscribeSMPro($sSubscribeSMPro);
}



#
# output properties
#





1;   
