# Generated by default/object.tt
package Paws::SecurityHub::PortProbeAction;
  use Moose;
  has Blocked => (is => 'ro', isa => 'Bool');
  has PortProbeDetails => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::PortProbeDetail]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::PortProbeAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::PortProbeAction object:

  $service_obj->Method(Att1 => { Blocked => $value, ..., PortProbeDetails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::PortProbeAction object:

  $result = $service_obj->Method(...);
  $result->Att1->Blocked

=head1 DESCRIPTION

Provided if C<ActionType> is C<PORT_PROBE>. It provides details about
the attempted port probe that was detected.

=head1 ATTRIBUTES


=head2 Blocked => Bool

Indicates whether the port probe was blocked.


=head2 PortProbeDetails => ArrayRef[L<Paws::SecurityHub::PortProbeDetail>]

Information about the ports affected by the port probe.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

