# Generated by default/object.tt
package Paws::Connect::QueueQuickConnectConfig;
  use Moose;
  has ContactFlowId => (is => 'ro', isa => 'Str', required => 1);
  has QueueId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::QueueQuickConnectConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::QueueQuickConnectConfig object:

  $service_obj->Method(Att1 => { ContactFlowId => $value, ..., QueueId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::QueueQuickConnectConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactFlowId

=head1 DESCRIPTION

Contains information about a queue for a quick connect. The contact
flow must be of type Transfer to Queue.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContactFlowId => Str

The identifier of the contact flow.


=head2 B<REQUIRED> QueueId => Str

The identifier for the queue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

