﻿//
// Patterns.cs
//
// Authors:
//	Marek Safar  <marek.safar@gmail.com>
//
// Copyright (C) 2012 Xamarin Inc (http://www.xamarin.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Collections.Generic;

namespace Mono.Tools.LocaleBuilder
{
	static class Patterns
	{
		static readonly Dictionary<int, string[]> DateTime = new Dictionary<int, string[]> {
			{ 0x0001, new [] { "/", "dd/MMMM/yyyy", "hh:mm:ss tt", "dd/MM/yy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0002, new [] { ".", "dd MMMM yyyy 'г.'", "HH:mm:ss 'ч.'", "d.M.yyyy 'г.'", "HH:mm 'ч.'", "dd MMMM", "MMMM yyyy 'г.'" } },
			{ 0x0003, new [] { "/", "dddd, d' / 'MMMM' / 'yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM' / 'yyyy" } },
			{ 0x0004, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "yyyy/M/d", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x0005, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0006, new [] { "-", "d. MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0007, new [] { ".", "dddd, d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0008, new [] { "/", "dddd, d MMMM yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0009, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x000a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x000b, new [] { ".", "d. MMMM'ta 'yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM'ta'", "MMMM yyyy" } },
			{ 0x000c, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x000d, new [] { "/", "dddd dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x000e, new [] { ".", "yyyy. MMMM d.", "H:mm:ss", "yyyy.MM.dd.", "H:mm", "MMMM d.", "yyyy. MMMM" } },
			{ 0x000f, new [] { ".", "d. MMMM yyyy", "HH:mm:ss", "d.M.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0010, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0011, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "yyyy/MM/dd", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x0012, new [] { "-", "yyyy'년' M'월' d'일' dddd", "tt h:mm:ss", "yyyy-MM-dd", "tt h:mm", "M'월' d'일'", "yyyy'년' M'월'" } },
			{ 0x0013, new [] { "-", "dddd d MMMM yyyy", "H:mm:ss", "d-M-yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0014, new [] { ".", "d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0015, new [] { "-", "d MMMM yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0016, new [] { "/", "dddd, d' de 'MMMM' de 'yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd' de 'MMMM", "MMMM' de 'yyyy" } },
			{ 0x0017, new [] { "/", "dddd, d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0018, new [] { ".", "d MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0019, new [] { ".", "d MMMM yyyy 'г.'", "H:mm:ss", "dd.MM.yyyy", "H:mm", "MMMM dd", "MMMM yyyy" } },
			{ 0x001a, new [] { ".", "d. MMMM yyyy.", "H:mm:ss", "d.M.yyyy.", "H:mm", "d. MMMM", "MMMM, yyyy" } },
			{ 0x001b, new [] { ". ", "d. MMMM yyyy", "H:mm:ss", "d. M. yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x001c, new [] { "-", "yyyy-MM-dd", "h:mm:ss.tt", "yyyy-MM-dd", "h:mm.tt", "MMMM dd", "yyyy-MM" } },
			{ 0x001d, new [] { "-", "'den 'd MMMM yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "'den 'd MMMM", "MMMM yyyy" } },
			{ 0x001e, new [] { "/", "d MMMM yyyy", "H:mm:ss", "d/M/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x001f, new [] { ".", "dd MMMM yyyy dddd", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0020, new [] { "/", "dd MMMM, yyyy", "h:mm:ss tt", "dd/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0021, new [] { "/", "dd MMMM yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0022, new [] { ".", "d MMMM yyyy' р.'", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy' р.'" } },
			{ 0x0023, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0024, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0025, new [] { ".", "d. MMMM yyyy'. a.'", "H:mm:ss", "d.MM.yyyy", "H:mm", "d. MMMM", "MMMM yyyy'. a.'" } },
			{ 0x0026, new [] { ".", "dddd, yyyy'. gada 'd. MMMM", "H:mm:ss", "yyyy.MM.dd.", "H:mm", "d. MMMM", "yyyy. MMMM" } },
			{ 0x0027, new [] { ".", "yyyy 'm.' MMMM d 'd.'", "HH:mm:ss", "yyyy.MM.dd", "HH:mm", "MMMM d 'd.'", "yyyy 'm.' MMMM" } },
			{ 0x0028, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yy", "H:mm", "MMMM dd", "MMMM yyyy" } },
			{ 0x0029, new [] { "/", "dddd, MMMM dd, yyyy", "hh:mm:ss tt", "MM/dd/yyyy", "hh:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x002a, new [] { "/", "dd MMMM yyyy", "h:mm:ss tt", "dd/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x002b, new [] { ".", "d MMMM, yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM, yyyy" } },
			{ 0x002c, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x002d, new [] { "/", "dddd, yyyy.'eko' MMMM'k 'd", "H:mm:ss", "yyyy/MM/dd", "HH:mm", "MMMM dd", "yyyy.'eko' MMMM" } },
			{ 0x002e, new [] { ". ", "dddd, 'dnja' d. MMMM yyyy", "H:mm:ss", "d. M. yyyy", "H.mm 'hodź.'", "d. MMMM", "MMMM yyyy" } },
			{ 0x002f, new [] { ".", "dddd, dd MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0032, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0034, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0035, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0036, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0037, new [] { ".", "yyyy 'წლის' dd MM, dddd", "H:mm:ss", "dd.MM.yyyy", "H:mm", "dd MM", "MMMM yyyy" } },
			{ 0x0038, new [] { "-", "d. MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0039, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x003a, new [] { "/", "dddd, d' ta\' 'MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d' ta\' 'MMMM", "MMMM yyyy" } },
			{ 0x003b, new [] { ".", "MMMM d'. b. 'yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x003c, new [] { "/", "d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x003e, new [] { "/", "dd MMMM yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x003f, new [] { ".", "d MMMM yyyy 'ж.'", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0040, new [] { ".", "d'-'MMMM yyyy'-ж.'", "H:mm:ss", "dd.MM.yy", "H:mm", "d MMMM", "MMMM yyyy'-ж.'" } },
			{ 0x0041, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0042, new [] { ".", "yyyy 'ý.' MMMM d", "H:mm:ss", "dd.MM.yy", "H:mm", "MMMM dd", "yyyy 'ý.' MMMM" } },
			{ 0x0043, new [] { "/", "yyyy 'yil' d-MMMM", "HH:mm:ss", "dd/MM yyyy", "HH:mm", "d-MMMM", "MMMM yyyy" } },
			{ 0x0044, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0045, new [] { "-", "dd MMMM yyyy", "HH.mm.ss", "dd-MM-yy", "HH.mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0046, new [] { "-", "dd MMMM yyyy dddd", "tt hh:mm:ss", "dd-MM-yy", "tt hh:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0047, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0048, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0049, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x004a, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x004b, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x004c, new [] { "-", "dd MMMM yyyy", "HH.mm.ss", "dd-MM-yy", "HH.mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x004d, new [] { "-", "yyyy,MMMM dd, dddd", "tt h:mm:ss", "dd-MM-yyyy", "tt h:mm", "dd MMMM", "MMMM,yy" } },
			{ 0x004e, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x004f, new [] { "-", "dd MMMM yyyy dddd", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0050, new [] { ".", "yyyy 'оны' MMMM d", "H:mm:ss", "yy.MM.dd", "H:mm", "d MMMM", "yyyy 'он' MMMM" } },
			{ 0x0051, new [] { "/", "yyyy'ལོའི་ཟླ' M'ཚེས' d", "HH:mm:ss", "yyyy/M/d", "HH:mm", "'ཟླ་' M'ཚེས'd", "yyyy.M" } },
			{ 0x0052, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0053, new [] { "-", "d MMMM yyyy", "HH:mm:ss", "yyyy-MM-dd", "H:mm tt", "'ថ្ងៃទី' dd 'ខែ' MM", "'ខែ' MM 'ឆ្នាំ' yyyy" } },
			{ 0x0054, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "H:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0056, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x0057, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x005a, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x005b, new [] { "-", "yyyy MMMM' මස 'dd' වැනිදා 'dddd", "h:mm:ss tt", "yyyy-MM-dd", "h:mm tt", "MMMM dd", "yyyy MMMM" } },
			{ 0x005d, new [] { "/", "ddd, MMMM dd,yyyy", "h:mm:ss tt", "d/MM/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x005e, new [] { "/", "dddd '፣' MMMM d 'ቀን' yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM d ቀን", "MMMM yyyy" } },
			{ 0x005f, new [] { "-", "dd MMMM, yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0061, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM,yyyy" } },
			{ 0x0062, new [] { "-", "dddd d MMMM yyyy", "H:mm:ss", "d-M-yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0063, new [] { "/", "dd/MM/yyyy", "h:mm:ss tt", "dd/MM/yy", "h:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0064, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0065, new [] { "/", "dd/MM/yyyy", "HH:mm:ss", "dd/MM/yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0068, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x006a, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x006b, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "MMMM dd", "MMMM' de 'yyyy" } },
			{ 0x006c, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x006d, new [] { ".", "d MMMM yyyy 'й'", "H:mm:ss", "dd.MM.yy", "H:mm", "MMMM dd", "MMMM yyyy" } },
			{ 0x006e, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x006f, new [] { "-", "d. MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0070, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0078, new [] { "/", "yyyy'ꈎ' M'ꆪ' d'ꑍ'", "H:mm:ss", "yyyy/M/d", "tt h:mm", "M'ꆪ' d'ꑍ'", "yyyy'ꈎ' M'ꆪ'" } },
			{ 0x007a, new [] { "-", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x007c, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x007e, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x007f, new [] { "/", "dddd, dd MMMM yyyy", "HH:mm:ss", "MM/dd/yyyy", "HH:mm", "MMMM dd", "yyyy MMMM" } },
			{ 0x0080, new [] { "-", "yyyy-'يىلى' MMMM d-'كۈنى،'", "H:mm:ss", "yyyy-M-d", "H:mm", "MMMM d'-كۈنى'", "yyyy-'يىلى' MMMM" } },
			{ 0x0081, new [] { "/", "dddd, dd MMMM, yyyy", "h:mm:ss tt", "dd/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM, yy" } },
			{ 0x0082, new [] { "/", "dddd,' lo 'd MMMM' de 'yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0083, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0084, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0085, new [] { ".", "MMMM d yyyy 'с.'", "H:mm:ss", "MM.dd.yyyy", "H:mm", "MMMM dd", "MMMM yyyy 'с.'" } },
			{ 0x0086, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x0087, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0088, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x008c, new [] { "/", "dd/MM/yyyy", "h:mm:ss tt", "dd/MM/yy", "h:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0091, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0401, new [] { "/", "dd/MMMM/yyyy", "hh:mm:ss tt", "dd/MM/yy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0402, new [] { ".", "dd MMMM yyyy 'г.'", "HH:mm:ss 'ч.'", "d.M.yyyy 'г.'", "HH:mm 'ч.'", "dd MMMM", "MMMM yyyy 'г.'" } },
			{ 0x0403, new [] { "/", "dddd, d' / 'MMMM' / 'yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM' / 'yyyy" } },
			{ 0x0404, new [] { "/", "yyyy'年'M'月'd'日'", "tt hh:mm:ss", "yyyy/M/d", "tt hh:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x0405, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0406, new [] { "-", "d. MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0407, new [] { ".", "dddd, d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0408, new [] { "/", "dddd, d MMMM yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0409, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x040b, new [] { ".", "d. MMMM'ta 'yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM'ta'", "MMMM yyyy" } },
			{ 0x040c, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x040d, new [] { "/", "dddd dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x040e, new [] { ".", "yyyy. MMMM d.", "H:mm:ss", "yyyy.MM.dd.", "H:mm", "MMMM d.", "yyyy. MMMM" } },
			{ 0x040f, new [] { ".", "d. MMMM yyyy", "HH:mm:ss", "d.M.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0410, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0411, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "yyyy/MM/dd", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x0412, new [] { "-", "yyyy'년' M'월' d'일' dddd", "tt h:mm:ss", "yyyy-MM-dd", "tt h:mm", "M'월' d'일'", "yyyy'년' M'월'" } },
			{ 0x0413, new [] { "-", "dddd d MMMM yyyy", "H:mm:ss", "d-M-yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0414, new [] { ".", "d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0415, new [] { "-", "d MMMM yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0416, new [] { "/", "dddd, d' de 'MMMM' de 'yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd' de 'MMMM", "MMMM' de 'yyyy" } },
			{ 0x0417, new [] { "/", "dddd, d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0418, new [] { ".", "d MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0419, new [] { ".", "d MMMM yyyy 'г.'", "H:mm:ss", "dd.MM.yyyy", "H:mm", "MMMM dd", "MMMM yyyy" } },
			{ 0x041a, new [] { ".", "d. MMMM yyyy.", "H:mm:ss", "d.M.yyyy.", "H:mm", "d. MMMM", "MMMM, yyyy" } },
			{ 0x041b, new [] { ". ", "d. MMMM yyyy", "H:mm:ss", "d. M. yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x041c, new [] { "-", "yyyy-MM-dd", "h:mm:ss.tt", "yyyy-MM-dd", "h:mm.tt", "MMMM dd", "yyyy-MM" } },
			{ 0x041d, new [] { "-", "'den 'd MMMM yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "'den 'd MMMM", "MMMM yyyy" } },
			{ 0x041e, new [] { "/", "d MMMM yyyy", "H:mm:ss", "d/M/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x041f, new [] { ".", "dd MMMM yyyy dddd", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0420, new [] { "/", "dd MMMM, yyyy", "h:mm:ss tt", "dd/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0421, new [] { "/", "dd MMMM yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0422, new [] { ".", "d MMMM yyyy' р.'", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy' р.'" } },
			{ 0x0423, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0424, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0425, new [] { ".", "d. MMMM yyyy'. a.'", "H:mm:ss", "d.MM.yyyy", "H:mm", "d. MMMM", "MMMM yyyy'. a.'" } },
			{ 0x0426, new [] { ".", "dddd, yyyy'. gada 'd. MMMM", "H:mm:ss", "yyyy.MM.dd.", "H:mm", "d. MMMM", "yyyy. MMMM" } },
			{ 0x0427, new [] { ".", "yyyy 'm.' MMMM d 'd.'", "HH:mm:ss", "yyyy.MM.dd", "HH:mm", "MMMM d 'd.'", "yyyy 'm.' MMMM" } },
			{ 0x0428, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yy", "H:mm", "MMMM dd", "MMMM yyyy" } },
			{ 0x0429, new [] { "/", "dddd, MMMM dd, yyyy", "hh:mm:ss tt", "MM/dd/yyyy", "hh:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x042a, new [] { "/", "dd MMMM yyyy", "h:mm:ss tt", "dd/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x042b, new [] { ".", "d MMMM, yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM, yyyy" } },
			{ 0x042c, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x042d, new [] { "/", "dddd, yyyy.'eko' MMMM'k 'd", "H:mm:ss", "yyyy/MM/dd", "HH:mm", "MMMM dd", "yyyy.'eko' MMMM" } },
			{ 0x042e, new [] { ". ", "dddd, 'dnja' d. MMMM yyyy", "H:mm:ss", "d. M. yyyy", "H.mm 'hodź.'", "d. MMMM", "MMMM yyyy" } },
			{ 0x042f, new [] { ".", "dddd, dd MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0432, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0434, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0435, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0436, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0437, new [] { ".", "yyyy 'წლის' dd MM, dddd", "H:mm:ss", "dd.MM.yyyy", "H:mm", "dd MM", "MMMM yyyy" } },
			{ 0x0438, new [] { "-", "d. MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0439, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x043a, new [] { "/", "dddd, d' ta\' 'MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d' ta\' 'MMMM", "MMMM yyyy" } },
			{ 0x043b, new [] { ".", "MMMM d'. b. 'yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x043e, new [] { "/", "dd MMMM yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x043f, new [] { ".", "d MMMM yyyy 'ж.'", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0440, new [] { ".", "d'-'MMMM yyyy'-ж.'", "H:mm:ss", "dd.MM.yy", "H:mm", "d MMMM", "MMMM yyyy'-ж.'" } },
			{ 0x0441, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0442, new [] { ".", "yyyy 'ý.' MMMM d", "H:mm:ss", "dd.MM.yy", "H:mm", "MMMM dd", "yyyy 'ý.' MMMM" } },
			{ 0x0443, new [] { "/", "yyyy 'yil' d-MMMM", "HH:mm:ss", "dd/MM yyyy", "HH:mm", "d-MMMM", "MMMM yyyy" } },
			{ 0x0444, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0445, new [] { "-", "dd MMMM yyyy", "HH.mm.ss", "dd-MM-yy", "HH.mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0446, new [] { "-", "dd MMMM yyyy dddd", "tt hh:mm:ss", "dd-MM-yy", "tt hh:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0447, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0448, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0449, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x044a, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x044b, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x044c, new [] { "-", "dd MMMM yyyy", "HH.mm.ss", "dd-MM-yy", "HH.mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x044d, new [] { "-", "yyyy,MMMM dd, dddd", "tt h:mm:ss", "dd-MM-yyyy", "tt h:mm", "dd MMMM", "MMMM,yy" } },
			{ 0x044e, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x044f, new [] { "-", "dd MMMM yyyy dddd", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0450, new [] { ".", "yyyy 'оны' MMMM d", "H:mm:ss", "yy.MM.dd", "H:mm", "d MMMM", "yyyy 'он' MMMM" } },
			{ 0x0451, new [] { "/", "yyyy'ལོའི་ཟླ' M'ཚེས' d", "HH:mm:ss", "yyyy/M/d", "HH:mm", "'ཟླ་' M'ཚེས'd", "yyyy.M" } },
			{ 0x0452, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0453, new [] { "-", "d MMMM yyyy", "HH:mm:ss", "yyyy-MM-dd", "H:mm tt", "'ថ្ងៃទី' dd 'ខែ' MM", "'ខែ' MM 'ឆ្នាំ' yyyy" } },
			{ 0x0454, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "H:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0456, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x0457, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x045a, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x045b, new [] { "-", "yyyy MMMM' මස 'dd' වැනිදා 'dddd", "h:mm:ss tt", "yyyy-MM-dd", "h:mm tt", "MMMM dd", "yyyy MMMM" } },
			{ 0x045d, new [] { "/", "dddd,MMMM dd,yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM,yyyy" } },
			{ 0x045e, new [] { "/", "dddd '፣' MMMM d 'ቀን' yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM d ቀን", "MMMM yyyy" } },
			{ 0x0461, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM,yyyy" } },
			{ 0x0462, new [] { "-", "dddd d MMMM yyyy", "H:mm:ss", "d-M-yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0463, new [] { "/", "dd/MM/yyyy", "h:mm:ss tt", "dd/MM/yy", "h:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0464, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0465, new [] { "/", "dd/MM/yyyy", "HH:mm:ss", "dd/MM/yy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0468, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x046a, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x046b, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "MMMM dd", "MMMM' de 'yyyy" } },
			{ 0x046c, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x046d, new [] { ".", "d MMMM yyyy 'й'", "H:mm:ss", "dd.MM.yy", "H:mm", "MMMM dd", "MMMM yyyy" } },
			{ 0x046e, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x046f, new [] { "-", "d. MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0470, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0478, new [] { "/", "yyyy'ꈎ' M'ꆪ' d'ꑍ'", "H:mm:ss", "yyyy/M/d", "tt h:mm", "M'ꆪ' d'ꑍ'", "yyyy'ꈎ' M'ꆪ'" } },
			{ 0x047a, new [] { "-", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x047c, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x047e, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0480, new [] { "-", "yyyy-'يىلى' MMMM d-'كۈنى،'", "H:mm:ss", "yyyy-M-d", "H:mm", "MMMM d'-كۈنى'", "yyyy-'يىلى' MMMM" } },
			{ 0x0481, new [] { "/", "dddd, dd MMMM, yyyy", "h:mm:ss tt", "dd/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM, yy" } },
			{ 0x0482, new [] { "/", "dddd,' lo 'd MMMM' de 'yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0483, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0484, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0485, new [] { ".", "MMMM d yyyy 'с.'", "H:mm:ss", "MM.dd.yyyy", "H:mm", "MMMM dd", "MMMM yyyy 'с.'" } },
			{ 0x0486, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x0487, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x0488, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x048c, new [] { "/", "dd/MM/yyyy", "h:mm:ss tt", "dd/MM/yy", "h:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0491, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0801, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0804, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "yyyy/M/d", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x0807, new [] { ".", "dddd, d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0809, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x080a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x080c, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "d/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x0810, new [] { ".", "dddd, d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0813, new [] { "/", "dddd d MMMM yyyy", "H:mm:ss", "d/MM/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0814, new [] { ".", "d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0816, new [] { "-", "dddd, d' de 'MMMM' de 'yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "d/M", "MMMM' de 'yyyy" } },
			{ 0x081a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x081d, new [] { ".", "'den 'd MMMM yyyy", "HH:mm:ss", "d.M.yyyy", "HH:mm", "'den 'd MMMM", "MMMM yyyy" } },
			{ 0x082c, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x082e, new [] { ". ", "dddd, 'dnja' d. MMMM yyyy", "H:mm:ss", "d. M. yyyy", "H.mm 'goź.'", "d. MMMM", "MMMM yyyy" } },
			{ 0x083b, new [] { "-", "MMMM d'. b. 'yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x083c, new [] { "/", "d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x083e, new [] { "/", "dd MMMM yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0843, new [] { ".", "yyyy 'йил' d-MMMM", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d-MMMM", "MMMM yyyy" } },
			{ 0x0845, new [] { "-", "dd MMMM yyyy", "HH.mm.ss", "dd-MM-yy", "HH.mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0850, new [] { "/", "yyyy'ᠣᠨ ᠤ᠋' M'ᠰᠠᠷ᠎ᠠ  ᠢᠢᠨ 'd' ᠤ᠋ ᠡᠳᠦᠷ'", "H:mm:ss", "yyyy/M/d", "H:mm", "M'ᠰᠠᠷ᠎ᠠ' d'ᠡᠳᠦᠷ'", "yyyy'ᠣᠨ' M'ᠰᠠᠷ᠎ᠠ'" } },
			{ 0x085d, new [] { "/", "ddd, MMMM dd,yyyy", "h:mm:ss tt", "d/MM/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x085f, new [] { "-", "dd MMMM, yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x086b, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "MMMM dd", "MMMM' de 'yyyy" } },
			{ 0x0c01, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x0c04, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "d/M/yyyy", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x0c07, new [] { ".", "dddd, dd. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x0c09, new [] { "/", "dddd, d MMMM yyyy", "h:mm:ss tt", "d/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x0c0a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x0c0c, new [] { "-", "d MMMM yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "d MMMM", "MMMM, yyyy" } },
			{ 0x0c1a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x0c3b, new [] { ".", "MMMM d'. b. 'yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x0c6b, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "MMMM dd", "MMMM' de 'yyyy" } },
			{ 0x1001, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x1004, new [] { "/", "yyyy'年'M'月'd'日'", "tt h:mm:ss", "d/M/yyyy", "tt h:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x1007, new [] { ".", "dddd, d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x1009, new [] { "/", "MMMM-dd-yy", "h:mm:ss tt", "dd/MM/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x100a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x100c, new [] { ".", "dddd d MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x101a, new [] { ".", "d. MMMM yyyy.", "H:mm:ss", "d.M.yyyy.", "H:mm", "d. MMMM", "MMMM, yyyy" } },
			{ 0x103b, new [] { ".", "MMMM d'. b. 'yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x1401, new [] { "-", "dd MMMM, yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x1404, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "d/M/yyyy", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x1407, new [] { ".", "dddd, d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x1409, new [] { "/", "dddd, d MMMM yyyy", "h:mm:ss tt", "d/MM/yyyy", "h:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x140a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x140c, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x141a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x143b, new [] { "-", "MMMM d'. b. 'yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x1801, new [] { "-", "dd MMMM, yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x1809, new [] { "/", "dd MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "dd MMMM", "MMMM yyyy" } },
			{ 0x180a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "MM/dd/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x180c, new [] { "/", "dddd d MMMM yyyy", "HH:mm:ss", "dd/MM/yyyy", "HH:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x181a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x183b, new [] { ".", "MMMM d'. b. 'yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x1c01, new [] { "-", "dd MMMM, yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x1c09, new [] { "/", "dd MMMM yyyy", "hh:mm:ss tt", "yyyy/MM/dd", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x1c0a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x1c1a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM, yyyy" } },
			{ 0x1c3b, new [] { "-", "MMMM d'. b. 'yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x2001, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x2009, new [] { "/", "dddd, MMMM dd, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x200a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x201a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM, yyyy" } },
			{ 0x203b, new [] { ".", "MMMM d'. p. 'yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "MMMM d'. p. '", "MMMM yyyy" } },
			{ 0x2401, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x2409, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "MM/dd/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x240a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x241a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x243b, new [] { ".", "MMMM d'. p. 'yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "MMMM d'. p. '", "MMMM yyyy" } },
			{ 0x2801, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x2809, new [] { "/", "dddd, dd MMMM yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x280a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x281a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x2c01, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x2c09, new [] { "/", "dddd, dd MMMM yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM yyyy" } },
			{ 0x2c0a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x2c1a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x3001, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x3009, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x300a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd/MM/yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x301a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x3401, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x3409, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x340a, new [] { "-", "dddd, dd' de 'MMMM' de 'yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x3801, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x380a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x3c01, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x3c0a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x4001, new [] { "/", "dd MMMM, yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM, yyyy" } },
			{ 0x4009, new [] { "-", "dd MMMM yyyy", "HH:mm:ss", "dd-MM-yyyy", "HH:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x400a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x4409, new [] { "/", "dddd, d MMMM, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "d MMMM", "MMMM, yyyy" } },
			{ 0x440a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x4809, new [] { "/", "dddd, d MMMM, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "d MMMM", "MMMM, yyyy" } },
			{ 0x480a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x4c0a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x500a, new [] { "/", "dddd, dd' de 'MMMM' de 'yyyy", "hh:mm:ss tt", "dd/MM/yyyy", "hh:mm tt", "dd MMMM", "MMMM' de 'yyyy" } },
			{ 0x540a, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "M/d/yyyy", "h:mm tt", "dd' de 'MMMM", "MMMM' de 'yyyy" } },
			{ 0x641a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM, yyyy" } },
			{ 0x681a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x6c1a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x701a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x703b, new [] { ".", "MMMM d'. p. 'yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "MMMM d'. p. '", "MMMM yyyy" } },
			{ 0x742c, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x743b, new [] { ".", "MMMM d'. p. 'yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "MMMM d'. p. '", "MMMM yyyy" } },
			{ 0x7804, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "yyyy/M/d", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x7814, new [] { ".", "d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x781a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x782c, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yyyy", "H:mm", "d MMMM", "MMMM yyyy" } },
			{ 0x783b, new [] { "-", "MMMM d'. b. 'yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x7843, new [] { ".", "yyyy 'йил' d-MMMM", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d-MMMM", "MMMM yyyy" } },
			{ 0x7850, new [] { ".", "yyyy 'оны' MMMM d", "H:mm:ss", "yy.MM.dd", "H:mm", "d MMMM", "yyyy 'он' MMMM" } },
			{ 0x785d, new [] { "/", "dddd,MMMM dd,yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM,yyyy" } },
			{ 0x7c04, new [] { "/", "yyyy'年'M'月'd'日'", "H:mm:ss", "d/M/yyyy", "H:mm", "M'月'd'日'", "yyyy'年'M'月'" } },
			{ 0x7c14, new [] { ".", "d. MMMM yyyy", "HH:mm:ss", "dd.MM.yyyy", "HH:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x7c1a, new [] { ".", "d. MMMM yyyy", "H:mm:ss", "d.M.yyyy", "H:mm", "d. MMMM", "MMMM yyyy" } },
			{ 0x7c28, new [] { ".", "d MMMM yyyy", "H:mm:ss", "dd.MM.yy", "H:mm", "MMMM dd", "MMMM yyyy" } },
			{ 0x7c2e, new [] { ". ", "dddd, 'dnja' d. MMMM yyyy", "H:mm:ss", "d. M. yyyy", "H.mm 'goź.'", "d. MMMM", "MMMM yyyy" } },
			{ 0x7c3b, new [] { "-", "MMMM d'. b. 'yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm", "MMMM d'. b. '", "MMMM yyyy" } },
			{ 0x7c43, new [] { "/", "yyyy 'yil' d-MMMM", "HH:mm:ss", "dd/MM yyyy", "HH:mm", "d-MMMM", "MMMM yyyy" } },
			{ 0x7c50, new [] { "/", "yyyy'ᠣᠨ ᠤ᠋' M'ᠰᠠᠷ᠎ᠠ  ᠢᠢᠨ 'd' ᠤ᠋ ᠡᠳᠦᠷ'", "H:mm:ss", "yyyy/M/d", "H:mm", "M'ᠰᠠᠷ᠎ᠠ' d'ᠡᠳᠦᠷ'", "yyyy'ᠣᠨ' M'ᠰᠠᠷ᠎ᠠ'" } },
			{ 0x7c5d, new [] { "/", "ddd, MMMM dd,yyyy", "h:mm:ss tt", "d/MM/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } },
			{ 0x7c5f, new [] { "-", "dd MMMM, yyyy", "H:mm:ss", "dd-MM-yyyy", "H:mm", "dd MMMM", "MMMM, yyyy" } },
			{ 0x7c68, new [] { "/", "dddd, MMMM dd, yyyy", "h:mm:ss tt", "d/M/yyyy", "h:mm tt", "MMMM dd", "MMMM, yyyy" } }
		};

		static readonly Dictionary<int, string[][]> DateTime2 = new Dictionary<int, string[][]> {
			{ 0x0001, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0002, new[] { new[] { "d.M.yyyy 'г.'", "dd.M.yyyy 'г.'", "d.MM.yyyy 'г.'", "dd.MM.yyyy 'г.'" }, new[] { "dd MMMM yyyy 'г.'", "d MMMM yyyy 'г.'", "dddd, dd MMMM yyyy 'г.'", "dddd, d MMMM yyyy 'г.'" }, new[] { "HH:mm 'ч.'", "H:mm 'ч.'" }, new[] { "HH:mm:ss 'ч.'", "H:mm:ss 'ч.'" } } },
			{ 0x0003, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd", "d/MM/yy", "d/M/yy", "dd-MM-yy", "dd.MM.yy" }, new[] { "dddd, d' / 'MMMM' / 'yyyy", "d'/'MMMM'/'yyyy", "d' 'MMMM' 'yyyy" }, new[] { "HH:mm", "H:mm", "HH'H'mm'\''" }, new[] { "HH:mm:ss", "H:mm:ss", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x0004, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'M'月'd'日',dddd", "dddd,yyyy'年'M'月'd'日'" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x0005, new[] { new[] { "d.M.yyyy", "d-M-yy", "yyyy-MM-dd", "yyyy-M-d", "yy-M-d" }, new[] { "d. MMMM yyyy" }, new[] { "H:mm", "HH:mm", "h.mm tt", "H.mm" }, new[] { "H:mm:ss", "HH:mm:ss", "h.mm.ss tt", "H.mm.ss" } } },
			{ 0x0006, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0007, new[] { new[] { "dd.MM.yyyy", "dd.MMM.yyyy", "dd.MM.yy", "d.MM.yy", "d.M.yy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. MMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "H.mm' Uhr'" }, new[] { "HH:mm:ss", "H:mm:ss' Uhr'", "HH:mm:ss' Uhr'", "HHmmss" } } },
			{ 0x0008, new[] { new[] { "d/M/yyyy", "dd/MM/yyyy", "d/M/yy", "dd/MM/yy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0009, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x000a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "dd-MM-yy", "dd.MM.yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm", "HH'H'mm'\''" }, new[] { "H:mm:ss", "HH:mm:ss", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x000b, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "d. MMMM'ta 'yyyy", "dd. MMMM'ta 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x000c, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x000d, new[] { new[] { "dd/MM/yyyy", "dd MMMM yyyy", "dd/MM/yy", "dd/MMMM/yyyy", "dd-MM-yy", "dd-MM-yyyy", "dd-MMMM-yyyy", "yyyy-MM-dd", "dd 'ב'MMMM yyyy", "dd MMM yy" }, new[] { "dddd dd MMMM yyyy", "dd MMMM yyyy", "dddd dd 'ב'MMMM yyyy", "ddd dd 'ב'MMMM yyyy", "dd 'ב'MMMM yyyy" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" } } },
			{ 0x000e, new[] { new[] { "yyyy.MM.dd.", "yyyy. MM. dd.", "yyyy-MM-dd", "yy-MM-dd" }, new[] { "yyyy. MMMM d." }, new[] { "H:mm", "HH:mm", "h:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "h:mm:ss tt" } } },
			{ 0x000f, new[] { new[] { "d.M.yyyy", "dd.MM.yy", "d. M. yyyy.", "d. M. '\''yy.", "yyyy-MM-dd", "yy MM dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0010, new[] { new[] { "dd/MM/yyyy", "dd/MMM/yyyy", "dd/MM/yy", "dd.M.yy", "d/M/yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "HH.mm" }, new[] { "HH:mm:ss", "H.mm.ss", "HH.mm.ss" } } },
			{ 0x0011, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yy/M/d", "yyyy/M/d", "yy/MM/dd' ('ddd')'", "yy/M/d' ('ddd')'", "yyyy/MM/dd' ('ddd')'", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy'年'M'月'd'日' dddd", "yyyy'年'MM'月'dd'日' dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x0012, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd", "yy-M-d", "yyyy-M-d" }, new[] { "yyyy'년' M'월' d'일' dddd", "yyyy'년' M'월' d'일'", "yy'년' M'월' d'일' dddd", "yy'년' M'월' d'일'", "yyyy'년' MM'월' dd'일' dddd", "yyyy'년' MM'월' dd'일'" }, new[] { "tt h:mm", "tt hh:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0013, new[] { new[] { "d-M-yyyy", "d-M-yy", "dd-MM-yy", "dd/MM/yy", "dd.MM.yy", "dd.MMM.yyyy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy", "d MMM yy" }, new[] { "H:mm", "HH:mm", "H.mm", "HH.mm' uur'", "HH:mm' uur'" }, new[] { "H:mm:ss", "HH:mm:ss", "HH.mm.ss' uur'", "HH:mm:ss' uur'" } } },
			{ 0x0014, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'HH.mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'HH.mm.ss", "HH.mm.ss" } } },
			{ 0x0015, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0016, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yyyy", "d/M/yy", "dd-MM-yy", "dd-MM-yyyy", "d-M-yy", "d-M-yyyy", "dd.MM.yy", "dd.MM.yyyy", "dd.MMM.yyyy", "d.M.yy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0017, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "dd/M/yy", "d/M/yy", "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy", "d MMM yy" }, new[] { "HH:mm", "H:mm", "HH:mm' Ura'", "H:mm' Ura'", "H' Ura'", "HH.mm' h'", "H.mm' h'", "H' h'", "H.mm' Uhr'", "H' Uhr'", "HHmm", "HH" }, new[] { "HH:mm:ss", "H:mm:ss", "HH:mm:ss' Ura'", "H:mm:ss' Ura'", "HH:mm:ss' Uhr'", "H:mm:ss' Uhr'", "HH:mm:ss' h'", "H:mm:ss' h'", "HHmmss" } } },
			{ 0x0018, new[] { new[] { "dd.MM.yyyy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0019, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'г.'", "dd MMMM yyyy 'г.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x001a, new[] { new[] { "d.M.yyyy.", "d.M.yy.", "d. M. yyyy.", "dd.MM.yyyy.", "d. M. yy.", "dd.MM.yy.", "dd. MM. yy.", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x001b, new[] { new[] { "d. M. yyyy", "d.M.yyyy", "d. M. yy", "d.M.yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "H:mm", "HH:mm", "H.mm" }, new[] { "H:mm:ss", "HH:mm:ss", "H.mm.ss" } } },
			{ 0x001c, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "yyyy-MM-dd" }, new[] { "h:mm.tt", "HH:mm" }, new[] { "h:mm:ss.tt", "HH:mm:ss" } } },
			{ 0x001d, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "'den 'd MMMM yyyy", "dddd' den 'd MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'H:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'H:mm:ss" } } },
			{ 0x001e, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "d MMM yyyy", "dd MMM yyyy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy", "'วัน'dddd'ที่' d MMMM gg yyyy" }, new[] { "H:mm", "HH:mm", "h:mm tt", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "h:mm:ss tt", "hh:mm:ss tt" } } },
			{ 0x001f, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0020, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0021, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0022, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy' р.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0023, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0024, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0025, new[] { new[] { "d.MM.yyyy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy'. a.'", "dd. MMMM yyyy'. a.'", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0026, new[] { new[] { "yyyy.MM.dd.", "yy.MM.dd.", "yyyy-MM-dd" }, new[] { "dddd, yyyy'. gada 'd. MMMM" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0027, new[] { new[] { "yyyy.MM.dd", "yyyy-MM-dd" }, new[] { "yyyy 'm.' MMMM d 'd.'" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0028, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss" } } },
			{ 0x0029, new[] { new[] { "MM/dd/yyyy", "MM/dd/yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x002a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x002b, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d/MM/yyyy", "dd/MM/yyyy", "d/MMM/yyyy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "d MMMM, yyyy", "dddd, d MMMM yyyy", "dddd, dd MMMM yyyy", "dd MMMM yyyy", "d-MMM-yyyy", "dd-MMM-yyyy", "ddd, d-MMMM-yyyy", "ddd, dd-MMMM-yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x002c, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x002d, new[] { new[] { "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "dddd, yyyy.'eko' MMMM'k 'd" }, new[] { "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x002e, new[] { new[] { "d. M. yyyy", "d. M. yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, 'dnja' d. MMMM yyyy", "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. M. yyyy" }, new[] { "H.mm 'hodź.'", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x002f, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0032, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0034, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0035, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0036, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd", "yyyy/MMM/dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0037, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "yyyy 'წლის' dd MM, dddd" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0038, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy" }, new[] { "HH:mm", "HH.mm" }, new[] { "HH:mm:ss", "HH.mm.ss" } } },
			{ 0x0039, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x003a, new[] { new[] { "dd/MM/yyyy", "yyyy-MM-dd", "ddMMyyyy", "d-M-yyyy", "d/M/yyyy" }, new[] { "dddd, d' ta\' 'MMMM yyyy", "d' ta\' 'MMMM yyyy", "dd MMM yyyy" }, new[] { "HH:mm", "h:mm tt", "H:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "h:mm:ss tt", "H:mm:ss", "hh:mm:ss tt" } } },
			{ 0x003b, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "HH.mm.ss" } } },
			{ 0x003c, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy", "dd MMM yyyy", "d MMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x003e, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x003f, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'ж.'", "dd MMMM yyyy 'ж.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0040, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d'-'MMMM yyyy'-ж.'" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x0041, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0042, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "yyyy 'ý.' MMMM d", "yyyy 'ý.' MMMM dd" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0043, new[] { new[] { "dd/MM yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "yyyy 'yil' d-MMMM", "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0044, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0045, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" } } },
			{ 0x0046, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "tt hh:mm", "tt h:mm", "H:mm", "HH:mm" }, new[] { "tt hh:mm:ss", "tt h:mm:ss", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0047, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x0048, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x0049, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x004a, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x004b, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x004c, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" } } },
			{ 0x004d, new[] { new[] { "dd-MM-yyyy" }, new[] { "yyyy,MMMM dd, dddd" }, new[] { "tt h:mm", "tt hh:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x004e, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x004f, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x0050, new[] { new[] { "yy.MM.dd", "yyyy-MM-dd" }, new[] { "yyyy 'оны' MMMM d" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x0051, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d" }, new[] { "yyyy'ལོའི་ཟླ' M'ཚེས' d", "yyyy'ལོའི་ཟླ' M'ཚེས' d dddd" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0052, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt", "h:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt", "h:mm:ss tt" } } },
			{ 0x0053, new[] { new[] { "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy" }, new[] { "H:mm tt" }, new[] { "HH:mm:ss" } } },
			{ 0x0054, new[] { new[] { "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "H:mm tt" }, new[] { "HH:mm:ss" } } },
			{ 0x0056, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "dd-MM-yy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt", "HH'H'mm'\''" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x0057, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x005a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x005b, new[] { new[] { "yyyy-MM-dd", "yyyy/MM/dd", "yy/MM/dd", "dd/MM/yyyy", "dd/MM/yy" }, new[] { "yyyy MMMM' මස 'dd' වැනිදා 'dddd" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x005d, new[] { new[] { "d/MM/yyyy", "d/M/yy", "yy-MM-dd", "dd/MM/yyyy", "yy-MM-dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "ddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x005e, new[] { new[] { "d/M/yyyy", "yyyy-MM-dd" }, new[] { "dddd '፣' MMMM d 'ቀን' yyyy" }, new[] { "h:mm tt" }, new[] { "h:mm:ss tt" } } },
			{ 0x005f, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0061, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0062, new[] { new[] { "d-M-yyyy", "d-M-yy", "dd-MM-yy", "dd/MM/yy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy", "d MMM yy" }, new[] { "H:mm", "HH:mm", "H:mm", "H.mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0063, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MM/yyyy", "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy", "dd/MM/yyyy 'هـ'" }, new[] { "h:mm tt", "H:mm" }, new[] { "h:mm:ss tt", "H:mm:ss" } } },
			{ 0x0064, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0065, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MM/yyyy", "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy", "dd/MM/yyyy 'هـ'" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" } } },
			{ 0x0068, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x006a, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x006b, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x006c, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x006d, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'й'" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x006e, new[] { new[] { "dd/MM/yyyy", " dd/MM/yy", "dd.MM.yy", "dd/MM/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "H.mm' Auer'" }, new[] { "HH:mm:ss", "H:mm:ss' Auer'", "HH:mm:ss' Auer'", "HHmmss" } } },
			{ 0x006f, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0070, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0078, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd" }, new[] { "yyyy'ꈎ' M'ꆪ' d'ꑍ'", "dddd, yyyy'ꈎ' M'ꆪ' d'ꑍ'", "yyyy'ꈎ' M'ꆪ' d'ꑍ', dddd" }, new[] { "tt h:mm", "H:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x007a, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "dd/MM/yy", "d/M/yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x007c, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x007e, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0080, new[] { new[] { "yyyy-M-d", "yyyy.M.d", "yyyy-MM-dd", "yyyy.MM.dd" }, new[] { "yyyy-'يىلى' MMMM d-'كۈنى،'", "yyyy-'يىلى' MMMM d-'كۈنى،' dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x0081, new[] { new[] { "dd/MM/yyyy", "d/MM/yy", "dd/MM/yy", "d.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM, yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0082, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd,' lo 'd MMMM' de 'yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0083, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0084, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0085, new[] { new[] { "MM.dd.yyyy", "MM.dd.yy", "d.M.yy", "MM/dd/yy", "MM-dd-yyyy" }, new[] { "MMMM d yyyy 'с.'", "MMMM dd yyyy 'с.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0086, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yyyy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0087, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0088, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x008c, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MM/yyyy", "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy", "dd/MM/yyyy 'هـ'" }, new[] { "h:mm tt", "H:mm" }, new[] { "h:mm:ss tt", "H:mm:ss" } } },
			{ 0x0091, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt", "h:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt", "h:mm:ss tt" } } },
			{ 0x0401, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0402, new[] { new[] { "d.M.yyyy 'г.'", "dd.M.yyyy 'г.'", "d.MM.yyyy 'г.'", "dd.MM.yyyy 'г.'" }, new[] { "dd MMMM yyyy 'г.'", "d MMMM yyyy 'г.'", "dddd, dd MMMM yyyy 'г.'", "dddd, d MMMM yyyy 'г.'" }, new[] { "HH:mm 'ч.'", "H:mm 'ч.'" }, new[] { "HH:mm:ss 'ч.'", "H:mm:ss 'ч.'" } } },
			{ 0x0403, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd", "d/MM/yy", "d/M/yy", "dd-MM-yy", "dd.MM.yy" }, new[] { "dddd, d' / 'MMMM' / 'yyyy", "d'/'MMMM'/'yyyy", "d' 'MMMM' 'yyyy" }, new[] { "HH:mm", "H:mm", "HH'H'mm'\''" }, new[] { "HH:mm:ss", "H:mm:ss", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x0404, new[] { new[] { "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'" }, new[] { "tt hh:mm", "tt h:mm", "HH:mm", "H:mm" }, new[] { "tt hh:mm:ss", "tt h:mm:ss", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0405, new[] { new[] { "d.M.yyyy", "d-M-yy", "yyyy-MM-dd", "yyyy-M-d", "yy-M-d" }, new[] { "d. MMMM yyyy" }, new[] { "H:mm", "HH:mm", "h.mm tt", "H.mm" }, new[] { "H:mm:ss", "HH:mm:ss", "h.mm.ss tt", "H.mm.ss" } } },
			{ 0x0406, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0407, new[] { new[] { "dd.MM.yyyy", "dd.MMM.yyyy", "dd.MM.yy", "d.MM.yy", "d.M.yy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. MMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "H.mm' Uhr'" }, new[] { "HH:mm:ss", "H:mm:ss' Uhr'", "HH:mm:ss' Uhr'", "HHmmss" } } },
			{ 0x0408, new[] { new[] { "d/M/yyyy", "dd/MM/yyyy", "d/M/yy", "dd/MM/yy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0409, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x040b, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "d. MMMM'ta 'yyyy", "dd. MMMM'ta 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x040c, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x040d, new[] { new[] { "dd/MM/yyyy", "dd MMMM yyyy", "dd/MM/yy", "dd/MMMM/yyyy", "dd-MM-yy", "dd-MM-yyyy", "dd-MMMM-yyyy", "yyyy-MM-dd", "dd 'ב'MMMM yyyy", "dd MMM yy" }, new[] { "dddd dd MMMM yyyy", "dd MMMM yyyy", "dddd dd 'ב'MMMM yyyy", "ddd dd 'ב'MMMM yyyy", "dd 'ב'MMMM yyyy" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" } } },
			{ 0x040e, new[] { new[] { "yyyy.MM.dd.", "yyyy. MM. dd.", "yyyy-MM-dd", "yy-MM-dd" }, new[] { "yyyy. MMMM d." }, new[] { "H:mm", "HH:mm", "h:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "h:mm:ss tt" } } },
			{ 0x040f, new[] { new[] { "d.M.yyyy", "dd.MM.yy", "d. M. yyyy.", "d. M. '\''yy.", "yyyy-MM-dd", "yy MM dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0410, new[] { new[] { "dd/MM/yyyy", "dd/MMM/yyyy", "dd/MM/yy", "dd.M.yy", "d/M/yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "HH.mm" }, new[] { "HH:mm:ss", "H.mm.ss", "HH.mm.ss" } } },
			{ 0x0411, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yy/M/d", "yyyy/M/d", "yy/MM/dd' ('ddd')'", "yy/M/d' ('ddd')'", "yyyy/MM/dd' ('ddd')'", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'", "yyyy'年'M'月'd'日' dddd", "yyyy'年'MM'月'dd'日' dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x0412, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd", "yy-M-d", "yyyy-M-d" }, new[] { "yyyy'년' M'월' d'일' dddd", "yyyy'년' M'월' d'일'", "yy'년' M'월' d'일' dddd", "yy'년' M'월' d'일'", "yyyy'년' MM'월' dd'일' dddd", "yyyy'년' MM'월' dd'일'" }, new[] { "tt h:mm", "tt hh:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0413, new[] { new[] { "d-M-yyyy", "d-M-yy", "dd-MM-yy", "dd/MM/yy", "dd.MM.yy", "dd.MMM.yyyy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy", "d MMM yy" }, new[] { "H:mm", "HH:mm", "H.mm", "HH.mm' uur'", "HH:mm' uur'" }, new[] { "H:mm:ss", "HH:mm:ss", "HH.mm.ss' uur'", "HH:mm:ss' uur'" } } },
			{ 0x0414, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'HH.mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'HH.mm.ss", "HH.mm.ss" } } },
			{ 0x0415, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0416, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yyyy", "d/M/yy", "dd-MM-yy", "dd-MM-yyyy", "d-M-yy", "d-M-yyyy", "dd.MM.yy", "dd.MM.yyyy", "dd.MMM.yyyy", "d.M.yy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0417, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "dd/M/yy", "d/M/yy", "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy", "d MMM yy" }, new[] { "HH:mm", "H:mm", "HH:mm' Ura'", "H:mm' Ura'", "H' Ura'", "HH.mm' h'", "H.mm' h'", "H' h'", "H.mm' Uhr'", "H' Uhr'", "HHmm", "HH" }, new[] { "HH:mm:ss", "H:mm:ss", "HH:mm:ss' Ura'", "H:mm:ss' Ura'", "HH:mm:ss' Uhr'", "H:mm:ss' Uhr'", "HH:mm:ss' h'", "H:mm:ss' h'", "HHmmss" } } },
			{ 0x0418, new[] { new[] { "dd.MM.yyyy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0419, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'г.'", "dd MMMM yyyy 'г.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x041a, new[] { new[] { "d.M.yyyy.", "d.M.yy.", "d. M. yyyy.", "dd.MM.yyyy.", "d. M. yy.", "dd.MM.yy.", "dd. MM. yy.", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x041b, new[] { new[] { "d. M. yyyy", "d.M.yyyy", "d. M. yy", "d.M.yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "H:mm", "HH:mm", "H.mm" }, new[] { "H:mm:ss", "HH:mm:ss", "H.mm.ss" } } },
			{ 0x041c, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "yyyy-MM-dd" }, new[] { "h:mm.tt", "HH:mm" }, new[] { "h:mm:ss.tt", "HH:mm:ss" } } },
			{ 0x041d, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "'den 'd MMMM yyyy", "dddd' den 'd MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'H:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'H:mm:ss" } } },
			{ 0x041e, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "d MMM yyyy", "dd MMM yyyy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy", "'วัน'dddd'ที่' d MMMM gg yyyy" }, new[] { "H:mm", "HH:mm", "h:mm tt", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "h:mm:ss tt", "hh:mm:ss tt" } } },
			{ 0x041f, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0420, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0421, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0422, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy' р.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0423, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0424, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0425, new[] { new[] { "d.MM.yyyy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy'. a.'", "dd. MMMM yyyy'. a.'", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0426, new[] { new[] { "yyyy.MM.dd.", "yy.MM.dd.", "yyyy-MM-dd" }, new[] { "dddd, yyyy'. gada 'd. MMMM" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0427, new[] { new[] { "yyyy.MM.dd", "yyyy-MM-dd" }, new[] { "yyyy 'm.' MMMM d 'd.'" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0428, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss" } } },
			{ 0x0429, new[] { new[] { "MM/dd/yyyy", "MM/dd/yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x042a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x042b, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d/MM/yyyy", "dd/MM/yyyy", "d/MMM/yyyy", "dd/MMM/yyyy", "yyyy-MM-dd" }, new[] { "d MMMM, yyyy", "dddd, d MMMM yyyy", "dddd, dd MMMM yyyy", "dd MMMM yyyy", "d-MMM-yyyy", "dd-MMM-yyyy", "ddd, d-MMMM-yyyy", "ddd, dd-MMMM-yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x042c, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x042d, new[] { new[] { "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "dddd, yyyy.'eko' MMMM'k 'd" }, new[] { "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x042e, new[] { new[] { "d. M. yyyy", "d. M. yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, 'dnja' d. MMMM yyyy", "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. M. yyyy" }, new[] { "H.mm 'hodź.'", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x042f, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM yyyy" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0432, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0434, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0435, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0436, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd", "yyyy/MMM/dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0437, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "yyyy 'წლის' dd MM, dddd" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0438, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy" }, new[] { "HH:mm", "HH.mm" }, new[] { "HH:mm:ss", "HH.mm.ss" } } },
			{ 0x0439, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x043a, new[] { new[] { "dd/MM/yyyy", "yyyy-MM-dd", "ddMMyyyy", "d-M-yyyy", "d/M/yyyy" }, new[] { "dddd, d' ta\' 'MMMM yyyy", "d' ta\' 'MMMM yyyy", "dd MMM yyyy" }, new[] { "HH:mm", "h:mm tt", "H:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "h:mm:ss tt", "H:mm:ss", "hh:mm:ss tt" } } },
			{ 0x043b, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "HH.mm.ss" } } },
			{ 0x043e, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x043f, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'ж.'", "dd MMMM yyyy 'ж.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0440, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d'-'MMMM yyyy'-ж.'" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x0441, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0442, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "yyyy 'ý.' MMMM d", "yyyy 'ý.' MMMM dd" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0443, new[] { new[] { "dd/MM yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "yyyy 'yil' d-MMMM", "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0444, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0445, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" } } },
			{ 0x0446, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "tt hh:mm", "tt h:mm", "H:mm", "HH:mm" }, new[] { "tt hh:mm:ss", "tt h:mm:ss", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0447, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x0448, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x0449, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x044a, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x044b, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x044c, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" } } },
			{ 0x044d, new[] { new[] { "dd-MM-yyyy" }, new[] { "yyyy,MMMM dd, dddd" }, new[] { "tt h:mm", "tt hh:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x044e, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x044f, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy dddd", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x0450, new[] { new[] { "yy.MM.dd", "yyyy-MM-dd" }, new[] { "yyyy 'оны' MMMM d" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x0451, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d" }, new[] { "yyyy'ལོའི་ཟླ' M'ཚེས' d", "yyyy'ལོའི་ཟླ' M'ཚེས' d dddd" }, new[] { "HH:mm" }, new[] { "HH:mm:ss" } } },
			{ 0x0452, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt", "h:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt", "h:mm:ss tt" } } },
			{ 0x0453, new[] { new[] { "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "ddd d MMMM yyyy" }, new[] { "H:mm tt" }, new[] { "HH:mm:ss" } } },
			{ 0x0454, new[] { new[] { "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "H:mm tt" }, new[] { "HH:mm:ss" } } },
			{ 0x0456, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "dd-MM-yy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt", "HH'H'mm'\''" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x0457, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm", "tt h:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x045a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x045b, new[] { new[] { "yyyy-MM-dd", "yyyy/MM/dd", "yy/MM/dd", "dd/MM/yyyy", "dd/MM/yy" }, new[] { "yyyy MMMM' මස 'dd' වැනිදා 'dddd" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x045d, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd,MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x045e, new[] { new[] { "d/M/yyyy", "yyyy-MM-dd" }, new[] { "dddd '፣' MMMM d 'ቀን' yyyy" }, new[] { "h:mm tt" }, new[] { "h:mm:ss tt" } } },
			{ 0x0461, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0462, new[] { new[] { "d-M-yyyy", "d-M-yy", "dd-MM-yy", "dd/MM/yy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d-MMM-yy", "d MMMM yyyy", "d MMM yy" }, new[] { "H:mm", "HH:mm", "H:mm", "H.mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0463, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MM/yyyy", "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy", "dd/MM/yyyy 'هـ'" }, new[] { "h:mm tt", "H:mm" }, new[] { "h:mm:ss tt", "H:mm:ss" } } },
			{ 0x0464, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0465, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MM/yyyy", "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy", "dd/MM/yyyy 'هـ'" }, new[] { "HH:mm", "hh:mm tt" }, new[] { "HH:mm:ss", "hh:mm:ss tt" } } },
			{ 0x0468, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x046a, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x046b, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x046c, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss" } } },
			{ 0x046d, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy 'й'" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x046e, new[] { new[] { "dd/MM/yyyy", " dd/MM/yy", "dd.MM.yy", "dd/MM/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "H.mm' Auer'" }, new[] { "HH:mm:ss", "H:mm:ss' Auer'", "HH:mm:ss' Auer'", "HHmmss" } } },
			{ 0x046f, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd", "yyyy MM dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0470, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0478, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd" }, new[] { "yyyy'ꈎ' M'ꆪ' d'ꑍ'", "dddd, yyyy'ꈎ' M'ꆪ' d'ꑍ'", "yyyy'ꈎ' M'ꆪ' d'ꑍ', dddd" }, new[] { "tt h:mm", "H:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x047a, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "dd/MM/yy", "d/M/yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x047c, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x047e, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0480, new[] { new[] { "yyyy-M-d", "yyyy.M.d", "yyyy-MM-dd", "yyyy.MM.dd" }, new[] { "yyyy-'يىلى' MMMM d-'كۈنى،'", "yyyy-'يىلى' MMMM d-'كۈنى،' dddd" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x0481, new[] { new[] { "dd/MM/yyyy", "d/MM/yy", "dd/MM/yy", "d.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM, yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0482, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd,' lo 'd MMMM' de 'yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0483, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0484, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0485, new[] { new[] { "MM.dd.yyyy", "MM.dd.yy", "d.M.yy", "MM/dd/yy", "MM-dd-yyyy" }, new[] { "MMMM d yyyy 'с.'", "MMMM dd yyyy 'с.'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0486, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yyyy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0487, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0488, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x048c, new[] { new[] { "dd/MM/yy", "dd/MM/yyyy" }, new[] { "dd/MM/yyyy", "dd/MMMM/yyyy", "dddd, dd MMMM, yyyy", "dd/MM/yyyy 'هـ'" }, new[] { "h:mm tt", "H:mm" }, new[] { "h:mm:ss tt", "H:mm:ss" } } },
			{ 0x0491, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt", "h:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt", "h:mm:ss tt" } } },
			{ 0x0801, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0804, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'M'月'd'日',dddd", "dddd,yyyy'年'M'月'd'日'" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x0807, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.MM.yy", "dd. M. yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. MMM yy" }, new[] { "HH:mm", "H:mm", "H.mm' h'", "HH.mm' h'", "H.mm' Uhr'", "HHmm", "HH", "H' h'", "H' Uhr'" }, new[] { "HH:mm:ss", "H:mm:ss", "HH:mm:ss' h'", "H:mm:ss' h'", "HH:mm:ss' Uhr'", "H:mm:ss' Uhr'", "HHmmss" } } },
			{ 0x0809, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "hh:mm tt", "h:mm tt" }, new[] { "HH:mm:ss", "H:mm:ss", "hh:mm:ss tt", "h:mm:ss tt" } } },
			{ 0x080a, new[] { new[] { "dd/MM/yyyy", "dd/MMM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x080c, new[] { new[] { "d/MM/yyyy", "d/MM/yy", "dd.MM.yy", "yy/MM/dd", "dd-MM-yy", "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy", "dd-MMM-yy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0810, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "dd. MM. yy", "d/M/yy", "dd.M.yy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d-MMM-yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm' h'" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0813, new[] { new[] { "d/MM/yyyy", "d/MM/yy", "dd-MM-yy", "dd.MM.yy", "dd.MMM.yyyy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "dd-MMM-yy", "d MMMM yyyy", "dd MMM yy" }, new[] { "H:mm", "HH:mm", "H.mm' u.'" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0814, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'HH.mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'HH.mm.ss", "HH.mm.ss" } } },
			{ 0x0816, new[] { new[] { "dd-MM-yyyy", "dd-MMM-yyyy", "yy.MM.dd", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dddd, d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy", "d/MMM/yy", "d.MMM.yy" }, new[] { "HH:mm", "HH'H'mm'm'" }, new[] { "HH:mm:ss" } } },
			{ 0x081a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x081d, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "'den 'd MMMM yyyy", "dddd' den 'd MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'H:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'H:mm:ss" } } },
			{ 0x082c, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x082e, new[] { new[] { "d. M. yyyy", "d. M. yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, 'dnja' d. MMMM yyyy", "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. M. yyyy" }, new[] { "H.mm 'goź.'", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x083b, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x083c, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy", "dd MMM yyyy", "d MMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x083e, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0843, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "dd/MM yyyy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "yyyy 'йил' d-MMMM", "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0845, new[] { new[] { "dd-MM-yy", "d-M-yy", "d.M.yy", "dd-MM-yyyy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH.mm", "H.mm", "tt hh.mm", "tt h.mm" }, new[] { "HH.mm.ss", "H.mm.ss", "tt hh.mm.ss", "tt h.mm.ss" } } },
			{ 0x0850, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'ᠣᠨ ᠤ᠋' M'ᠰᠠᠷ᠎ᠠ  ᠢᠢᠨ 'd' ᠤ᠋ ᠡᠳᠦᠷ'", "yyyy'ᠣᠨ ᠤ᠋' M'ᠰᠠᠷ᠎ᠠ  ᠢᠢᠨ 'd' ᠤ᠋ ᠡᠳᠦᠷ᠂' dddd" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x085d, new[] { new[] { "d/MM/yyyy", "d/M/yy", "yy-MM-dd", "dd/MM/yyyy", "yy-MM-dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "ddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x085f, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x086b, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0c01, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x0c04, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0c07, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "dd.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, dd. MMMM yyyy", "d.MMMM yyyy", "d.MMMyyyy", "d MMM yyyy" }, new[] { "HH:mm", "H:mm", "HH:mm' Uhr'", "H:mm' Uhr'", "HHmm", "HH", "H' Uhr'" }, new[] { "HH:mm:ss", "H:mm:ss", "HH:mm:ss' Uhr'", "H:mm:ss' Uhr'", "HHmmss" } } },
			{ 0x0c09, new[] { new[] { "d/MM/yyyy", "d/MM/yy", "d/M/yy", "d/M/yyyy", "dd/MM/yy", "dd/MM/yyyy", "dd-MMM-yy", "dd-MMMM-yyyy", "yyyy-MM-dd", "yy/MM/dd", "yyyy/MM/dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0c0a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yy", "d/M/yy", "dd-MM-yy", "dd.MM.yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm", "HH'H'mm'\''" }, new[] { "H:mm:ss", "HH:mm:ss", "HH'H'mm'\''ss'\'\''" } } },
			{ 0x0c0c, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd", "dd-MM-yy", "yy MM dd", "dd/MM/yy", "dd/MMM/yyyy" }, new[] { "d MMMM yyyy", "d MMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x0c1a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0c3b, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x0c6b, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x1001, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x1004, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'" }, new[] { "tt h:mm", "tt hh:mm", "H:mm", "HH:mm" }, new[] { "tt h:mm:ss", "tt hh:mm:ss", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x1007, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.MM.yy", "d.M.yy", "d.M.yyyy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. MMM yyyy" }, new[] { "HH:mm", "H:mm", "H.mm", "H.mm' Uhr'" }, new[] { "HH:mm:ss", "H:mm:ss' Uhr'", "HH:mm:ss' Uhr'", "HHmmss" } } },
			{ 0x1009, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "yyyy-MM-dd", "yy-MM-dd", "M/dd/yy", "dd-MMM-yy", "dd-MMM-yyyy" }, new[] { "MMMM-dd-yy", "MMMM d, yyyy", "d-MMM-yy", "dddd, MMMM dd, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x100a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yyyy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x100c, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "dd. M. yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMMM yyyy", "d MMM yy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x101a, new[] { new[] { "d.M.yyyy.", "d.M.yy.", "d. M. yyyy.", "dd.MM.yyyy.", "d. M. yy.", "dd.MM.yy.", "dd. MM. yy.", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy.", "dd. MMMM yyyy.", "dddd, d. MMMM yyyy." }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x103b, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "HH.mm.ss" } } },
			{ 0x1401, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt" } } },
			{ 0x1404, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "dddd yyyy'年'M'月'd'日'", "dddd yyyy MM dd", "yyyy MM dd" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x1407, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.MM.yy", "dd. M. yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. MMM yy" }, new[] { "HH:mm", "H:mm", "H.mm' h'", "HH.mm' h'", "H.mm' Uhr'", "HHmm", "HH", "H' h'", "H' Uhr'" }, new[] { "HH:mm:ss", "H:mm:ss", "HH:mm:ss' h'", "H:mm:ss' h'", "HH:mm:ss' Uhr'", "H:mm:ss' Uhr'", "HHmmss" } } },
			{ 0x1409, new[] { new[] { "d/MM/yyyy", "d/MM/yy", "dd/MM/yy", "d.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM yyyy", "d MMMM yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x140a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x140c, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x141a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x143b, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x1801, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt" } } },
			{ 0x1809, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x180a, new[] { new[] { "MM/dd/yyyy", "MM/dd/yy", "d/M/yy", "dd/MM/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x180c, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "dd.MM.yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd d MMMM yyyy", "d MMM yy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "HH.mm", "HH' h 'mm", "HH'h'mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x181a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x183b, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x1c01, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm tt" }, new[] { "H:mm:ss", "HH:mm:ss", "hh:mm:ss tt" } } },
			{ 0x1c09, new[] { new[] { "yyyy/MM/dd", "yy/MM/dd", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x1c0a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "MM/dd/yyyy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x1c1a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x1c3b, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x2001, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x2009, new[] { new[] { "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x200a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x201a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x203b, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x2401, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x2409, new[] { new[] { "MM/dd/yyyy", "MM/dd/yy", "yyyy-MM-dd" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x240a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/MM/yyyy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x241a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x243b, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x2801, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x2809, new[] { new[] { "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x280a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x281a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x2c01, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x2c09, new[] { new[] { "dd/MM/yyyy", "yyyy-MM-dd" }, new[] { "dddd, dd MMMM yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x2c0a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x2c1a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x3001, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x3009, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yyyy-MM-dd", "yy/MM/dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x300a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x301a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x3401, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x3409, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yyyy-MM-dd", "yy/MM/dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x340a, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "dd/MM/yy", "d/M/yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x3801, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x380a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x3c01, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x3c0a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x4001, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "hh:mm tt", "HH:mm", "H:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x4009, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "d-M-yy", "d.M.yy", "yyyy-MM-dd" }, new[] { "dd MMMM yyyy", "d MMMM yyyy" }, new[] { "HH:mm", "H:mm", "tt hh:mm" }, new[] { "HH:mm:ss", "H:mm:ss", "tt hh:mm:ss", "tt h:mm:ss" } } },
			{ 0x400a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "d/M/yy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy", "dddd d' de 'MMMM' de 'yyyy", "d' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "h:mm tt", "H:mm", "HH:mm" }, new[] { "hh:mm:ss tt", "h:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x4409, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x440a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "MM-dd-yyyy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x4809, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yyyy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "dddd, d MMMM, yyyy", "d MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x480a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "MM-dd-yyyy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x4c0a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "MM-dd-yyyy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x500a, new[] { new[] { "dd/MM/yyyy", "dd/MM/yy", "MM-dd-yyyy", "yyyy-MM-dd" }, new[] { "dddd, dd' de 'MMMM' de 'yyyy" }, new[] { "hh:mm tt", "HH:mm" }, new[] { "hh:mm:ss tt", "HH:mm:ss" } } },
			{ 0x540a, new[] { new[] { "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x641a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x681a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x6c1a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x701a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x703b, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x742c, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x743b, new[] { new[] { "d.M.yyyy", "dd.MM.yyyy", "d.M.yy", "yyyy-MM-dd" }, new[] { "MMMM d'. p. 'yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x7804, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'M'月'd'日',dddd", "dddd,yyyy'年'M'月'd'日'" }, new[] { "H:mm", "HH:mm", "tt h:mm", "tt hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss", "tt h:mm:ss", "tt hh:mm:ss" } } },
			{ 0x7814, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'HH.mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'HH.mm.ss", "HH.mm.ss" } } },
			{ 0x781a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x782c, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x783b, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x7843, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "dd/MM yyyy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "yyyy 'йил' d-MMMM", "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x7850, new[] { new[] { "yy.MM.dd", "yyyy-MM-dd" }, new[] { "yyyy 'оны' MMMM d" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x785d, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd,MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
			{ 0x7c04, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "yy/M/d", "yy/MM/dd", "yyyy/M/d", "yyyy/MM/dd", "yyyy-MM-dd" }, new[] { "yyyy'年'M'月'd'日'", "yyyy'年'MM'月'dd'日'" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x7c14, new[] { new[] { "dd.MM.yyyy", "dd.MM.yy", "d.M.yy", "yyyy-MM-dd", "dd.MMM.yyyy" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy" }, new[] { "HH:mm", "H:mm", "'kl 'HH.mm", "HH.mm" }, new[] { "HH:mm:ss", "H:mm:ss", "'kl 'HH.mm.ss", "HH.mm.ss" } } },
			{ 0x7c1a, new[] { new[] { "d.M.yyyy", "d.M.yy", "d. M. yyyy", "dd.MM.yyyy", "d. M. yy", "dd.MM.yy", "dd. MM. yy", "yyyy-MM-dd" }, new[] { "d. MMMM yyyy", "dd. MMMM yyyy", "dddd, d. MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x7c28, new[] { new[] { "dd.MM.yy", "yyyy-MM-dd" }, new[] { "d MMMM yyyy" }, new[] { "H:mm", "HH:mm" }, new[] { "H:mm:ss" } } },
			{ 0x7c2e, new[] { new[] { "d. M. yyyy", "d. M. yy", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd" }, new[] { "dddd, 'dnja' d. MMMM yyyy", "dddd, d. MMMM yyyy", "d. MMMM yyyy", "d. M. yyyy" }, new[] { "H.mm 'goź.'", "HH:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x7c3b, new[] { new[] { "yyyy-MM-dd", "yy-MM-dd" }, new[] { "MMMM d'. b. 'yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x7c43, new[] { new[] { "dd/MM yyyy", "dd.MM.yy", "d.M.yy", "dd/MM/yy", "yyyy-MM-dd" }, new[] { "yyyy 'yil' d-MMMM", "d MMMM yyyy", "dd MMMM yyyy" }, new[] { "HH:mm", "H:mm" }, new[] { "HH:mm:ss", "H:mm:ss" } } },
			{ 0x7c50, new[] { new[] { "yyyy/M/d", "yyyy-M-d", "yyyy.M.d", "yyyy.MM.dd", "yyyy-MM-dd", "yyyy/MM/dd", "yy-M-d", "yy/M/d", "yy.M.d", "yy/MM/dd" }, new[] { "yyyy'ᠣᠨ ᠤ᠋' M'ᠰᠠᠷ᠎ᠠ  ᠢᠢᠨ 'd' ᠤ᠋ ᠡᠳᠦᠷ'", "yyyy'ᠣᠨ ᠤ᠋' M'ᠰᠠᠷ᠎ᠠ  ᠢᠢᠨ 'd' ᠤ᠋ ᠡᠳᠦᠷ᠂' dddd" }, new[] { "H:mm" }, new[] { "H:mm:ss" } } },
			{ 0x7c5d, new[] { new[] { "d/MM/yyyy", "d/M/yy", "yy-MM-dd", "dd/MM/yyyy", "yy-MM-dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "ddd, MMMM dd,yyyy", "MMMM dd,yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "HH:mm", "H:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "HH:mm:ss", "H:mm:ss" } } },
			{ 0x7c5f, new[] { new[] { "dd-MM-yyyy", "dd-MM-yy", "yyyy-MM-dd" }, new[] { "dd MMMM, yyyy", "dddd, dd MMMM, yyyy" }, new[] { "H:mm", "HH:mm", "hh:mm" }, new[] { "H:mm:ss", "HH:mm:ss" } } },
			{ 0x7c68, new[] { new[] { "d/M/yyyy", "d/M/yy", "dd/MM/yy", "dd/MM/yyyy", "yy/MM/dd", "yyyy-MM-dd", "dd-MMM-yy" }, new[] { "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dddd, dd MMMM, yyyy", "dd MMMM, yyyy" }, new[] { "h:mm tt", "hh:mm tt", "H:mm", "HH:mm" }, new[] { "h:mm:ss tt", "hh:mm:ss tt", "H:mm:ss", "HH:mm:ss" } } },
		};

		static readonly Dictionary<int, string[][]> GroupSizes = new Dictionary<int, string[][]> {
			{ 0x0028, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0039, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0045, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0046, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0047, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0048, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0049, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004a, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004b, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004c, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004d, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004e, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x004f, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0051, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0053, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0054, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0057, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x005b, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x005d, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x005e, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0061, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x006d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x006f, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0078, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x007c, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0428, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0439, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0445, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0446, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0447, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0448, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0449, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044a, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044b, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044c, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044d, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044e, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x044f, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0451, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0453, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0454, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0457, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x045b, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x045d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x045e, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0461, new [] { new [] { "3" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x046d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x046f, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0478, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x047c, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x0845, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x0850, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x085d, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x4009, new [] { new [] { "3", "2" }, new [] { "3", "2" }, new [] { "3", "2" } } },
			{ 0x540a, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x785d, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x7c28, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x7c50, new [] { new [] { "3", "0" }, new [] { "3", "0" }, new [] { "3", "0" } } },
			{ 0x7c5d, new [] { new [] { "3" }, new [] { "3", "0" }, new [] { "3", "0" } } },
		};

		static readonly Dictionary<int, string[]> Text = new Dictionary<int, string[]> {
			{ 0x0001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0002, new [] { "1251", "21025", "0", ";", "10007", "866" } },
			{ 0x0003, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0004, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x0005, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x0006, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0007, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0008, new [] { "1253", "20273", "0", ";", "10006", "737" } },
			{ 0x0009, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x000a, new [] { "1252", "20284", "0", ";", "10000", "850" } },
			{ 0x000b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x000c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x000d, new [] { "1255", "500", "1", ",", "10005", "862" } },
			{ 0x000e, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x000f, new [] { "1252", "20871", "0", ";", "10079", "850" } },
			{ 0x0010, new [] { "1252", "20280", "0", ";", "10000", "850" } },
			{ 0x0011, new [] { "932", "20290", "0", ",", "10001", "932" } },
			{ 0x0012, new [] { "949", "20833", "0", ",", "10003", "949" } },
			{ 0x0013, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0014, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0015, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0016, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0017, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0018, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0019, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x001a, new [] { "1250", "500", "0", ";", "10082", "852" } },
			{ 0x001b, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x001c, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x001d, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x001e, new [] { "874", "20838", "0", ",", "10021", "874" } },
			{ 0x001f, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x0020, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0021, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0022, new [] { "1251", "500", "0", ";", "10017", "866" } },
			{ 0x0023, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0024, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0025, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0026, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0027, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0028, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0029, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x002a, new [] { "1258", "500", "0", ",", "10000", "1258" } },
			{ 0x002b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x002c, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x002d, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x002e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x002f, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0032, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0034, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0035, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0036, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0037, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0038, new [] { "1252", "20277", "0", ";", "10079", "850" } },
			{ 0x0039, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x003a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x003b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x003c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x003e, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x003f, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0040, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0041, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0042, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0043, new [] { "1254", "500", "0", ";", "10029", "857" } },
			{ 0x0044, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0045, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0046, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0047, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0048, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0049, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004c, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004e, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x004f, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0050, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0051, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0052, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0053, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0054, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0056, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0057, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x005a, new [] { "0", "500", "1", ",", "2", "1" } },
			{ 0x005b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x005d, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x005e, new [] { "0", "500", "0", "á£", "2", "1" } },
			{ 0x005f, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0061, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0062, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0063, new [] { "0", "500", "1", ";", "2", "1" } },
			{ 0x0064, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0065, new [] { "0", "500", "1", "ØŒ", "2", "1" } },
			{ 0x0068, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x006a, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x006b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x006c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x006d, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x006e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x006f, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0070, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x0078, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x007a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x007c, new [] { "1252", "37", "0", ",", "10000", "850" } },
			{ 0x007e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x007f, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x0080, new [] { "1256", "20420", "1", ",", "10004", "720" } },
			{ 0x0081, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0082, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0083, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0084, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0085, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0086, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x0087, new [] { "1252", "37", "0", ";", "10000", "437" } },
			{ 0x0088, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x008c, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0091, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0402, new [] { "1251", "21025", "0", ";", "10007", "866" } },
			{ 0x0403, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0404, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x0405, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x0406, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0407, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0408, new [] { "1253", "20273", "0", ";", "10006", "737" } },
			{ 0x0409, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x040b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x040c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x040d, new [] { "1255", "500", "1", ",", "10005", "862" } },
			{ 0x040e, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x040f, new [] { "1252", "20871", "0", ";", "10079", "850" } },
			{ 0x0410, new [] { "1252", "20280", "0", ";", "10000", "850" } },
			{ 0x0411, new [] { "932", "20290", "0", ",", "10001", "932" } },
			{ 0x0412, new [] { "949", "20833", "0", ",", "10003", "949" } },
			{ 0x0413, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0414, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0415, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0416, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0417, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0418, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0419, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x041a, new [] { "1250", "500", "0", ";", "10082", "852" } },
			{ 0x041b, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x041c, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x041d, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x041e, new [] { "874", "20838", "0", ",", "10021", "874" } },
			{ 0x041f, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x0420, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0421, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0422, new [] { "1251", "500", "0", ";", "10017", "866" } },
			{ 0x0423, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0424, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0425, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0426, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0427, new [] { "1257", "500", "0", ";", "10029", "775" } },
			{ 0x0428, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0429, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x042a, new [] { "1258", "500", "0", ",", "10000", "1258" } },
			{ 0x042b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x042c, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x042d, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x042e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x042f, new [] { "1251", "500", "0", ";", "10007", "866" } },
			{ 0x0432, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0434, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0435, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0436, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0437, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0438, new [] { "1252", "20277", "0", ";", "10079", "850" } },
			{ 0x0439, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x043a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x043b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x043e, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x043f, new [] { "0", "500", "0", ";", "2", "1" } },
			{ 0x0440, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0441, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0442, new [] { "1250", "20880", "0", ";", "10029", "852" } },
			{ 0x0443, new [] { "1254", "500", "0", ";", "10029", "857" } },
			{ 0x0444, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0445, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0446, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0447, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0448, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0449, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044a, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044c, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044e, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x044f, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0450, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0451, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0452, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0453, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0454, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0456, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0457, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x045a, new [] { "0", "500", "1", ",", "2", "1" } },
			{ 0x045b, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x045d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x045e, new [] { "0", "500", "0", "á£", "2", "1" } },
			{ 0x0461, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0462, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0463, new [] { "0", "500", "1", ";", "2", "1" } },
			{ 0x0464, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x0465, new [] { "0", "500", "1", "ØŒ", "2", "1" } },
			{ 0x0468, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x046a, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x046b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x046c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x046d, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x046e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x046f, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0470, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x0478, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x047a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x047c, new [] { "1252", "37", "0", ",", "10000", "850" } },
			{ 0x047e, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0480, new [] { "1256", "20420", "1", ",", "10004", "720" } },
			{ 0x0481, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0482, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0483, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0484, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0485, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0486, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x0487, new [] { "1252", "37", "0", ";", "10000", "437" } },
			{ 0x0488, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x048c, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0491, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x0801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0804, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x0807, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0809, new [] { "1252", "20285", "0", ",", "10000", "850" } },
			{ 0x080a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x080c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0810, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0813, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0814, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x0816, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x081a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x081d, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x082c, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x082e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x083b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x083c, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x083e, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x0843, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x0845, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x0850, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x085d, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x085f, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x086b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x0c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x0c04, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x0c07, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x0c09, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x0c0a, new [] { "1252", "20284", "0", ";", "10000", "850" } },
			{ 0x0c0c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x0c1a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x0c3b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x0c6b, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x1001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1004, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x1007, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x1009, new [] { "1252", "37", "0", ",", "10000", "850" } },
			{ 0x100a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x100c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x101a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x103b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x1401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1404, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x1407, new [] { "1252", "20273", "0", ";", "10000", "850" } },
			{ 0x1409, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x140a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x140c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x141a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x143b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x1801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1809, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x180a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x180c, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x181a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x183b, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x1c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x1c09, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x1c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x1c1a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x1c3b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x2001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2009, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x200a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x201a, new [] { "1251", "870", "0", ";", "10082", "855" } },
			{ 0x203b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x2401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2409, new [] { "1252", "500", "0", ",", "10000", "850" } },
			{ 0x240a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x241a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x243b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x2801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2809, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x280a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x281a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x2c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x2c09, new [] { "1252", "500", "0", ";", "10000", "850" } },
			{ 0x2c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x2c1a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x3001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x3009, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x300a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x301a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x3401, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x3409, new [] { "1252", "500", "0", ",", "10000", "437" } },
			{ 0x340a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x3801, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x380a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x3c01, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x3c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4001, new [] { "1256", "20420", "1", ";", "10004", "720" } },
			{ 0x4009, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x400a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4409, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x440a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4809, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x480a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x4c0a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x500a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x540a, new [] { "1252", "20284", "0", ",", "10000", "850" } },
			{ 0x641a, new [] { "1251", "870", "0", ";", "10082", "855" } },
			{ 0x681a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x6c1a, new [] { "1251", "21025", "0", ";", "10007", "855" } },
			{ 0x701a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x703b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x742c, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x743b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x7804, new [] { "936", "500", "0", ",", "10008", "936" } },
			{ 0x7814, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x781a, new [] { "1250", "870", "0", ";", "10082", "852" } },
			{ 0x782c, new [] { "1254", "20905", "0", ";", "10081", "857" } },
			{ 0x783b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x7843, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x7850, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x785d, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x7c04, new [] { "950", "500", "0", ",", "10002", "950" } },
			{ 0x7c14, new [] { "1252", "20277", "0", ";", "10000", "850" } },
			{ 0x7c1a, new [] { "1250", "500", "0", ";", "10029", "852" } },
			{ 0x7c28, new [] { "1251", "20880", "0", ";", "10007", "866" } },
			{ 0x7c2e, new [] { "1252", "870", "0", ";", "10000", "850" } },
			{ 0x7c3b, new [] { "1252", "20278", "0", ";", "10000", "850" } },
			{ 0x7c43, new [] { "1254", "500", "0", ";", "10029", "857" } },
			{ 0x7c50, new [] { "0", "500", "0", ",", "2", "1" } },
			{ 0x7c5d, new [] { "1252", "37", "0", ",", "10000", "437" } },
			{ 0x7c5f, new [] { "1252", "20297", "0", ";", "10000", "850" } },
			{ 0x7c68, new [] { "1252", "37", "0", ",", "10000", "437" } },
		};

		static readonly Dictionary<int, string[]> Numbers = new Dictionary<int, string[]> {
			{ 0x0001, new [] { "3", "2", "3", "0", "0" } },
			{ 0x0002, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0003, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0004, new [] { "2", "0", "1", "1", "1" } },
			{ 0x0005, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0006, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0007, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0008, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0009, new [] { "0", "0", "1", "0", "0" } },
			{ 0x000a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x000b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x000c, new [] { "8", "3", "1", "0", "0" } },
			{ 0x000d, new [] { "2", "2", "1", "1", "1" } },
			{ 0x000e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x000f, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0010, new [] { "9", "2", "1", "1", "1" } },
			{ 0x0011, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0012, new [] { "1", "0", "1", "0", "0" } },
			{ 0x0013, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0014, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0015, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0016, new [] { "9", "2", "1", "1", "1" } },
			{ 0x0017, new [] { "2", "2", "1", "1", "1" } },
			{ 0x0018, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0019, new [] { "5", "1", "1", "1", "1" } },
			{ 0x001a, new [] { "8", "3", "2", "1", "1" } },
			{ 0x001b, new [] { "8", "3", "1", "1", "1" } },
			{ 0x001c, new [] { "5", "1", "1", "0", "0" } },
			{ 0x001d, new [] { "8", "3", "1", "0", "0" } },
			{ 0x001e, new [] { "1", "0", "1", "0", "0" } },
			{ 0x001f, new [] { "8", "3", "1", "2", "2" } },
			{ 0x0020, new [] { "3", "0", "1", "0", "0" } },
			{ 0x0021, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0022, new [] { "5", "1", "1", "1", "1" } },
			{ 0x0023, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0024, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0025, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0026, new [] { "9", "2", "1", "1", "1" } },
			{ 0x0027, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0028, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0029, new [] { "3", "2", "3", "0", "0" } },
			{ 0x002a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x002b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x002c, new [] { "8", "3", "1", "1", "1" } },
			{ 0x002d, new [] { "8", "3", "1", "0", "0" } },
			{ 0x002e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x002f, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0032, new [] { "2", "2", "1", "2", "2" } },
			{ 0x0034, new [] { "2", "2", "1", "2", "2" } },
			{ 0x0035, new [] { "2", "2", "1", "2", "2" } },
			{ 0x0036, new [] { "2", "2", "1", "1", "1" } },
			{ 0x0037, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0038, new [] { "12", "2", "1", "1", "1" } },
			{ 0x0039, new [] { "12", "2", "1", "0", "0" } },
			{ 0x003a, new [] { "1", "0", "1", "2", "2" } },
			{ 0x003b, new [] { "12", "2", "1", "2", "2" } },
			{ 0x003c, new [] { "1", "0", "1", "0", "0" } },
			{ 0x003e, new [] { "0", "0", "1", "0", "0" } },
			{ 0x003f, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0040, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0041, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0042, new [] { "5", "1", "1", "1", "1" } },
			{ 0x0043, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0044, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0045, new [] { "12", "2", "1", "2", "2" } },
			{ 0x0046, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0047, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0048, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0049, new [] { "12", "2", "1", "0", "0" } },
			{ 0x004a, new [] { "12", "2", "1", "0", "0" } },
			{ 0x004b, new [] { "12", "2", "1", "0", "0" } },
			{ 0x004c, new [] { "12", "2", "1", "2", "2" } },
			{ 0x004d, new [] { "12", "1", "1", "1", "1" } },
			{ 0x004e, new [] { "12", "2", "1", "0", "0" } },
			{ 0x004f, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0050, new [] { "5", "1", "1", "0", "0" } },
			{ 0x0051, new [] { "2", "0", "1", "1", "1" } },
			{ 0x0052, new [] { "1", "0", "1", "2", "2" } },
			{ 0x0053, new [] { "5", "1", "2", "1", "1" } },
			{ 0x0054, new [] { "4", "1", "0", "0", "0" } },
			{ 0x0056, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0057, new [] { "12", "2", "1", "0", "0" } },
			{ 0x005a, new [] { "3", "2", "1", "0", "0" } },
			{ 0x005b, new [] { "14", "2", "1", "0", "0" } },
			{ 0x005d, new [] { "0", "0", "1", "0", "0" } },
			{ 0x005e, new [] { "1", "0", "1", "1", "1" } },
			{ 0x005f, new [] { "8", "3", "3", "0", "0" } },
			{ 0x0061, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0062, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0063, new [] { "3", "0", "3", "4", "2" } },
			{ 0x0064, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0065, new [] { "10", "3", "1", "0", "0" } },
			{ 0x0068, new [] { "2", "2", "1", "0", "0" } },
			{ 0x006a, new [] { "2", "2", "1", "0", "0" } },
			{ 0x006b, new [] { "14", "2", "1", "2", "2" } },
			{ 0x006c, new [] { "2", "2", "1", "2", "2" } },
			{ 0x006d, new [] { "8", "3", "1", "1", "1" } },
			{ 0x006e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x006f, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0070, new [] { "2", "2", "1", "0", "0" } },
			{ 0x0078, new [] { "2", "0", "1", "1", "1" } },
			{ 0x007a, new [] { "9", "2", "1", "0", "0" } },
			{ 0x007c, new [] { "0", "0", "1", "0", "0" } },
			{ 0x007e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x007f, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0080, new [] { "2", "0", "1", "1", "1" } },
			{ 0x0081, new [] { "1", "0", "1", "2", "2" } },
			{ 0x0082, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0083, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0084, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0085, new [] { "5", "1", "1", "1", "1" } },
			{ 0x0086, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0087, new [] { "2", "2", "1", "0", "0" } },
			{ 0x0088, new [] { "8", "3", "1", "0", "0" } },
			{ 0x008c, new [] { "3", "0", "3", "4", "2" } },
			{ 0x0091, new [] { "1", "0", "1", "0", "0" } },
			{ 0x0401, new [] { "3", "2", "3", "0", "0" } },
			{ 0x0402, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0403, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0404, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0405, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0406, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0407, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0408, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0409, new [] { "0", "0", "1", "0", "0" } },
			{ 0x040b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x040c, new [] { "8", "3", "1", "0", "0" } },
			{ 0x040d, new [] { "2", "2", "1", "1", "1" } },
			{ 0x040e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x040f, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0410, new [] { "9", "2", "1", "1", "1" } },
			{ 0x0411, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0412, new [] { "1", "0", "1", "0", "0" } },
			{ 0x0413, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0414, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0415, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0416, new [] { "9", "2", "1", "1", "1" } },
			{ 0x0417, new [] { "2", "2", "1", "1", "1" } },
			{ 0x0418, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0419, new [] { "5", "1", "1", "1", "1" } },
			{ 0x041a, new [] { "8", "3", "2", "1", "1" } },
			{ 0x041b, new [] { "8", "3", "1", "1", "1" } },
			{ 0x041c, new [] { "5", "1", "1", "0", "0" } },
			{ 0x041d, new [] { "8", "3", "1", "0", "0" } },
			{ 0x041e, new [] { "1", "0", "1", "0", "0" } },
			{ 0x041f, new [] { "8", "3", "1", "2", "2" } },
			{ 0x0420, new [] { "3", "0", "1", "0", "0" } },
			{ 0x0421, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0422, new [] { "5", "1", "1", "1", "1" } },
			{ 0x0423, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0424, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0425, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0426, new [] { "9", "2", "1", "1", "1" } },
			{ 0x0427, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0428, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0429, new [] { "3", "2", "3", "0", "0" } },
			{ 0x042a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x042b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x042c, new [] { "8", "3", "1", "1", "1" } },
			{ 0x042d, new [] { "8", "3", "1", "0", "0" } },
			{ 0x042e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x042f, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0432, new [] { "2", "2", "1", "2", "2" } },
			{ 0x0434, new [] { "2", "2", "1", "2", "2" } },
			{ 0x0435, new [] { "2", "2", "1", "2", "2" } },
			{ 0x0436, new [] { "2", "2", "1", "1", "1" } },
			{ 0x0437, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0438, new [] { "12", "2", "1", "1", "1" } },
			{ 0x0439, new [] { "12", "2", "1", "0", "0" } },
			{ 0x043a, new [] { "1", "0", "1", "2", "2" } },
			{ 0x043b, new [] { "12", "2", "1", "2", "2" } },
			{ 0x043e, new [] { "0", "0", "1", "0", "0" } },
			{ 0x043f, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0440, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0441, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0442, new [] { "5", "1", "1", "1", "1" } },
			{ 0x0443, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0444, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0445, new [] { "12", "2", "1", "2", "2" } },
			{ 0x0446, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0447, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0448, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0449, new [] { "12", "2", "1", "0", "0" } },
			{ 0x044a, new [] { "12", "2", "1", "0", "0" } },
			{ 0x044b, new [] { "12", "2", "1", "0", "0" } },
			{ 0x044c, new [] { "12", "2", "1", "2", "2" } },
			{ 0x044d, new [] { "12", "1", "1", "1", "1" } },
			{ 0x044e, new [] { "12", "2", "1", "0", "0" } },
			{ 0x044f, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0450, new [] { "5", "1", "1", "0", "0" } },
			{ 0x0451, new [] { "2", "0", "1", "1", "1" } },
			{ 0x0452, new [] { "1", "0", "1", "2", "2" } },
			{ 0x0453, new [] { "5", "1", "2", "1", "1" } },
			{ 0x0454, new [] { "4", "1", "0", "0", "0" } },
			{ 0x0456, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0457, new [] { "12", "2", "1", "0", "0" } },
			{ 0x045a, new [] { "3", "2", "1", "0", "0" } },
			{ 0x045b, new [] { "14", "2", "1", "0", "0" } },
			{ 0x045d, new [] { "0", "0", "1", "1", "1" } },
			{ 0x045e, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0461, new [] { "1", "0", "1", "1", "1" } },
			{ 0x0462, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0463, new [] { "3", "0", "3", "4", "2" } },
			{ 0x0464, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0465, new [] { "10", "3", "1", "0", "0" } },
			{ 0x0468, new [] { "2", "2", "1", "0", "0" } },
			{ 0x046a, new [] { "2", "2", "1", "0", "0" } },
			{ 0x046b, new [] { "14", "2", "1", "2", "2" } },
			{ 0x046c, new [] { "2", "2", "1", "2", "2" } },
			{ 0x046d, new [] { "8", "3", "1", "1", "1" } },
			{ 0x046e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x046f, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0470, new [] { "2", "2", "1", "0", "0" } },
			{ 0x0478, new [] { "2", "0", "1", "1", "1" } },
			{ 0x047a, new [] { "9", "2", "1", "0", "0" } },
			{ 0x047c, new [] { "0", "0", "1", "0", "0" } },
			{ 0x047e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0480, new [] { "2", "0", "1", "1", "1" } },
			{ 0x0481, new [] { "1", "0", "1", "2", "2" } },
			{ 0x0482, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0483, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0484, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0485, new [] { "5", "1", "1", "1", "1" } },
			{ 0x0486, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0487, new [] { "2", "2", "1", "0", "0" } },
			{ 0x0488, new [] { "8", "3", "1", "0", "0" } },
			{ 0x048c, new [] { "3", "0", "3", "4", "2" } },
			{ 0x0491, new [] { "1", "0", "1", "0", "0" } },
			{ 0x0801, new [] { "3", "2", "3", "0", "0" } },
			{ 0x0804, new [] { "2", "0", "1", "1", "1" } },
			{ 0x0807, new [] { "2", "2", "1", "1", "1" } },
			{ 0x0809, new [] { "1", "0", "1", "0", "0" } },
			{ 0x080a, new [] { "1", "0", "1", "0", "0" } },
			{ 0x080c, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0810, new [] { "2", "2", "1", "1", "1" } },
			{ 0x0813, new [] { "12", "2", "1", "1", "1" } },
			{ 0x0814, new [] { "12", "2", "1", "0", "0" } },
			{ 0x0816, new [] { "8", "3", "1", "1", "1" } },
			{ 0x081a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x081d, new [] { "8", "3", "1", "0", "0" } },
			{ 0x082c, new [] { "8", "3", "1", "1", "1" } },
			{ 0x082e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x083b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x083c, new [] { "1", "0", "1", "0", "0" } },
			{ 0x083e, new [] { "0", "0", "1", "0", "0" } },
			{ 0x0843, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0845, new [] { "12", "2", "1", "2", "2" } },
			{ 0x0850, new [] { "2", "0", "1", "1", "1" } },
			{ 0x085d, new [] { "0", "0", "1", "0", "0" } },
			{ 0x085f, new [] { "8", "3", "3", "0", "0" } },
			{ 0x086b, new [] { "14", "2", "1", "2", "2" } },
			{ 0x0c01, new [] { "3", "2", "3", "0", "0" } },
			{ 0x0c04, new [] { "0", "0", "1", "1", "1" } },
			{ 0x0c07, new [] { "9", "2", "1", "1", "1" } },
			{ 0x0c09, new [] { "1", "0", "1", "0", "0" } },
			{ 0x0c0a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0c0c, new [] { "15", "3", "1", "0", "0" } },
			{ 0x0c1a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x0c3b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x0c6b, new [] { "12", "2", "1", "2", "2" } },
			{ 0x1001, new [] { "3", "0", "3", "0", "0" } },
			{ 0x1004, new [] { "0", "0", "1", "1", "1" } },
			{ 0x1007, new [] { "8", "3", "1", "1", "1" } },
			{ 0x1009, new [] { "1", "0", "1", "0", "0" } },
			{ 0x100a, new [] { "0", "0", "1", "0", "0" } },
			{ 0x100c, new [] { "2", "2", "1", "0", "0" } },
			{ 0x101a, new [] { "8", "3", "2", "0", "0" } },
			{ 0x103b, new [] { "12", "2", "1", "2", "2" } },
			{ 0x1401, new [] { "3", "2", "3", "0", "0" } },
			{ 0x1404, new [] { "0", "0", "1", "1", "1" } },
			{ 0x1407, new [] { "2", "2", "1", "1", "1" } },
			{ 0x1409, new [] { "1", "0", "1", "0", "0" } },
			{ 0x140a, new [] { "0", "0", "1", "0", "0" } },
			{ 0x140c, new [] { "8", "3", "1", "0", "0" } },
			{ 0x141a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x143b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x1801, new [] { "3", "2", "3", "0", "0" } },
			{ 0x1809, new [] { "1", "0", "1", "0", "0" } },
			{ 0x180a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x180c, new [] { "8", "3", "1", "0", "0" } },
			{ 0x181a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x183b, new [] { "12", "2", "1", "2", "2" } },
			{ 0x1c01, new [] { "3", "2", "3", "0", "0" } },
			{ 0x1c09, new [] { "2", "2", "1", "1", "1" } },
			{ 0x1c0a, new [] { "0", "0", "1", "0", "0" } },
			{ 0x1c1a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x1c3b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x2001, new [] { "3", "2", "3", "0", "0" } },
			{ 0x2009, new [] { "1", "0", "1", "0", "0" } },
			{ 0x200a, new [] { "12", "2", "1", "0", "0" } },
			{ 0x201a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x203b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x2401, new [] { "3", "2", "3", "0", "0" } },
			{ 0x2409, new [] { "1", "0", "1", "0", "0" } },
			{ 0x240a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x241a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x243b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x2801, new [] { "3", "2", "3", "0", "0" } },
			{ 0x2809, new [] { "0", "0", "1", "0", "0" } },
			{ 0x280a, new [] { "12", "2", "1", "0", "0" } },
			{ 0x281a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x2c01, new [] { "3", "2", "3", "0", "0" } },
			{ 0x2c09, new [] { "0", "0", "1", "0", "0" } },
			{ 0x2c0a, new [] { "2", "2", "1", "0", "0" } },
			{ 0x2c1a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x3001, new [] { "3", "2", "3", "0", "0" } },
			{ 0x3009, new [] { "0", "0", "1", "0", "0" } },
			{ 0x300a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x301a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x3401, new [] { "3", "2", "3", "0", "0" } },
			{ 0x3409, new [] { "0", "0", "1", "0", "0" } },
			{ 0x340a, new [] { "9", "2", "1", "0", "0" } },
			{ 0x3801, new [] { "3", "2", "3", "0", "0" } },
			{ 0x380a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x3c01, new [] { "3", "2", "3", "0", "0" } },
			{ 0x3c0a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x4001, new [] { "3", "2", "3", "0", "0" } },
			{ 0x4009, new [] { "12", "2", "1", "0", "0" } },
			{ 0x400a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x4409, new [] { "0", "0", "1", "1", "1" } },
			{ 0x440a, new [] { "0", "0", "1", "0", "0" } },
			{ 0x4809, new [] { "0", "0", "1", "1", "1" } },
			{ 0x480a, new [] { "12", "2", "1", "0", "0" } },
			{ 0x4c0a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x500a, new [] { "14", "2", "1", "0", "0" } },
			{ 0x540a, new [] { "0", "0", "1", "0", "0" } },
			{ 0x641a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x681a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x6c1a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x701a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x703b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x742c, new [] { "8", "3", "1", "1", "1" } },
			{ 0x743b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x7804, new [] { "2", "0", "1", "1", "1" } },
			{ 0x7814, new [] { "12", "2", "1", "0", "0" } },
			{ 0x781a, new [] { "8", "3", "1", "0", "0" } },
			{ 0x782c, new [] { "8", "3", "1", "1", "1" } },
			{ 0x783b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x7843, new [] { "8", "3", "1", "1", "1" } },
			{ 0x7850, new [] { "5", "1", "1", "0", "0" } },
			{ 0x785d, new [] { "0", "0", "1", "1", "1" } },
			{ 0x7c04, new [] { "0", "0", "1", "1", "1" } },
			{ 0x7c14, new [] { "12", "2", "1", "0", "0" } },
			{ 0x7c1a, new [] { "8", "3", "1", "1", "1" } },
			{ 0x7c28, new [] { "8", "3", "1", "1", "1" } },
			{ 0x7c2e, new [] { "8", "3", "1", "0", "0" } },
			{ 0x7c3b, new [] { "8", "3", "1", "0", "0" } },
			{ 0x7c43, new [] { "8", "3", "1", "1", "1" } },
			{ 0x7c50, new [] { "2", "0", "1", "1", "1" } },
			{ 0x7c5d, new [] { "0", "0", "1", "0", "0" } },
			{ 0x7c5f, new [] { "8", "3", "3", "0", "0" } },
			{ 0x7c68, new [] { "2", "2", "1", "0", "0" } },
		};

		static readonly Dictionary<int, string> Geo = new Dictionary<int, string> {
			{ 0x0401, "205" },
			{ 0x0402, "35" },
			{ 0x0403, "217" },
			{ 0x0404, "237" },
			{ 0x0405, "75" },
			{ 0x0406, "61" },
			{ 0x0407, "94" },
			{ 0x0408, "98" },
			{ 0x0409, "244" },
			{ 0x040b, "77" },
			{ 0x040c, "84" },
			{ 0x040d, "117" },
			{ 0x040e, "109" },
			{ 0x040f, "110" },
			{ 0x0410, "118" },
			{ 0x0411, "122" },
			{ 0x0412, "134" },
			{ 0x0413, "176" },
			{ 0x0414, "177" },
			{ 0x0415, "191" },
			{ 0x0416, "32" },
			{ 0x0417, "223" },
			{ 0x0418, "200" },
			{ 0x0419, "203" },
			{ 0x041a, "108" },
			{ 0x041b, "143" },
			{ 0x041c, "6" },
			{ 0x041d, "221" },
			{ 0x041e, "227" },
			{ 0x041f, "235" },
			{ 0x0420, "190" },
			{ 0x0421, "111" },
			{ 0x0422, "241" },
			{ 0x0423, "29" },
			{ 0x0424, "212" },
			{ 0x0425, "70" },
			{ 0x0426, "140" },
			{ 0x0427, "141" },
			{ 0x0428, "228" },
			{ 0x0429, "116" },
			{ 0x042a, "251" },
			{ 0x042b, "7" },
			{ 0x042c, "5" },
			{ 0x042d, "217" },
			{ 0x042e, "94" },
			{ 0x042f, "19618" },
			{ 0x0432, "209" },
			{ 0x0434, "209" },
			{ 0x0435, "209" },
			{ 0x0436, "209" },
			{ 0x0437, "88" },
			{ 0x0438, "81" },
			{ 0x0439, "113" },
			{ 0x043a, "163" },
			{ 0x043b, "177" },
			{ 0x043e, "167" },
			{ 0x043f, "137" },
			{ 0x0440, "130" },
			{ 0x0441, "129" },
			{ 0x0442, "238" },
			{ 0x0443, "247" },
			{ 0x0444, "203" },
			{ 0x0445, "113" },
			{ 0x0446, "113" },
			{ 0x0447, "113" },
			{ 0x0448, "113" },
			{ 0x0449, "113" },
			{ 0x044a, "113" },
			{ 0x044b, "113" },
			{ 0x044c, "113" },
			{ 0x044d, "113" },
			{ 0x044e, "113" },
			{ 0x044f, "113" },
			{ 0x0450, "154" },
			{ 0x0451, "45" },
			{ 0x0452, "242" },
			{ 0x0453, "40" },
			{ 0x0454, "138" },
			{ 0x0456, "217" },
			{ 0x0457, "113" },
			{ 0x045a, "222" },
			{ 0x045b, "42" },
			{ 0x045d, "39" },
			{ 0x045e, "73" },
			{ 0x0461, "178" },
			{ 0x0462, "176" },
			{ 0x0463, "3" },
			{ 0x0464, "201" },
			{ 0x0465, "165" },
			{ 0x0468, "175" },
			{ 0x046a, "175" },
			{ 0x046b, "26" },
			{ 0x046c, "209" },
			{ 0x046d, "203" },
			{ 0x046e, "147" },
			{ 0x046f, "93" },
			{ 0x0470, "175" },
			{ 0x0478, "45" },
			{ 0x047a, "46" },
			{ 0x047c, "39" },
			{ 0x047e, "84" },
			{ 0x0480, "45" },
			{ 0x0481, "183" },
			{ 0x0482, "84" },
			{ 0x0483, "84" },
			{ 0x0484, "84" },
			{ 0x0485, "203" },
			{ 0x0486, "99" },
			{ 0x0487, "204" },
			{ 0x0488, "210" },
			{ 0x048c, "3" },
			{ 0x0491, "242" },
			{ 0x0801, "121" },
			{ 0x0804, "45" },
			{ 0x0807, "223" },
			{ 0x0809, "242" },
			{ 0x080a, "166" },
			{ 0x080c, "21" },
			{ 0x0810, "223" },
			{ 0x0813, "21" },
			{ 0x0814, "177" },
			{ 0x0816, "193" },
			{ 0x081a, "269" },
			{ 0x081d, "77" },
			{ 0x082c, "5" },
			{ 0x082e, "94" },
			{ 0x083b, "221" },
			{ 0x083c, "68" },
			{ 0x083e, "37" },
			{ 0x0843, "247" },
			{ 0x0845, "23" },
			{ 0x0850, "154" },
			{ 0x085d, "39" },
			{ 0x085f, "4" },
			{ 0x086b, "66" },
			{ 0x0c01, "67" },
			{ 0x0c04, "104" },
			{ 0x0c07, "14" },
			{ 0x0c09, "12" },
			{ 0x0c0a, "217" },
			{ 0x0c0c, "39" },
			{ 0x0c1a, "269" },
			{ 0x0c3b, "77" },
			{ 0x0c6b, "187" },
			{ 0x1001, "148" },
			{ 0x1004, "215" },
			{ 0x1007, "147" },
			{ 0x1009, "39" },
			{ 0x100a, "99" },
			{ 0x100c, "223" },
			{ 0x101a, "25" },
			{ 0x103b, "177" },
			{ 0x1401, "4" },
			{ 0x1404, "151" },
			{ 0x1407, "145" },
			{ 0x1409, "183" },
			{ 0x140a, "54" },
			{ 0x140c, "147" },
			{ 0x141a, "25" },
			{ 0x143b, "221" },
			{ 0x1801, "159" },
			{ 0x1809, "68" },
			{ 0x180a, "192" },
			{ 0x180c, "158" },
			{ 0x181a, "25" },
			{ 0x183b, "177" },
			{ 0x1c01, "234" },
			{ 0x1c09, "209" },
			{ 0x1c0a, "65" },
			{ 0x1c1a, "25" },
			{ 0x1c3b, "221" },
			{ 0x2001, "164" },
			{ 0x2009, "124" },
			{ 0x200a, "249" },
			{ 0x201a, "25" },
			{ 0x203b, "77" },
			{ 0x2401, "261" },
			{ 0x2409, "124" },
			{ 0x240a, "51" },
			{ 0x241a, "271" },
			{ 0x243b, "77" },
			{ 0x2801, "222" },
			{ 0x2809, "24" },
			{ 0x280a, "187" },
			{ 0x281a, "271" },
			{ 0x2c01, "126" },
			{ 0x2c09, "225" },
			{ 0x2c0a, "11" },
			{ 0x2c1a, "270" },
			{ 0x3001, "139" },
			{ 0x3009, "264" },
			{ 0x300a, "66" },
			{ 0x301a, "270" },
			{ 0x3401, "136" },
			{ 0x3409, "201" },
			{ 0x340a, "46" },
			{ 0x3801, "224" },
			{ 0x380a, "246" },
			{ 0x3c01, "17" },
			{ 0x3c0a, "185" },
			{ 0x4001, "197" },
			{ 0x4009, "113" },
			{ 0x400a, "26" },
			{ 0x4409, "167" },
			{ 0x440a, "72" },
			{ 0x4809, "215" },
			{ 0x480a, "106" },
			{ 0x4c0a, "182" },
			{ 0x500a, "202" },
			{ 0x540a, "244" },
			};


		public static void FillValues (int lcid, CultureInfoEntry ci)
		{
			var entry = DateTime[lcid];
			var dfe = ci.DateTimeFormatEntry;
			dfe.DateSeparator = entry[0];
			dfe.LongDatePattern = entry[1];
			dfe.LongTimePattern = entry[2];
			dfe.ShortDatePattern = entry[3];
			dfe.ShortTimePattern = entry[4];
			dfe.MonthDayPattern = entry[5];
			dfe.YearMonthPattern = entry[6];

			var entry_dt = DateTime2[lcid];
			entry_dt[0].CopyTo (dfe.ShortDatePatterns, 0);
			entry_dt[1].CopyTo (dfe.LongDatePatterns, 0);
			entry_dt[2].CopyTo (dfe.ShortTimePatterns, 0);
			entry_dt[3].CopyTo (dfe.LongTimePatterns, 0);

			var entry_te = Text[lcid];
			var te = ci.TextInfoEntry;
			te.ANSICodePage = entry_te[0];
			te.EBCDICCodePage = entry_te[1];
			te.IsRightToLeft = entry_te[2] == "1" ? true : false;
			te.ListSeparator = entry_te[3];
			te.MacCodePage = entry_te[4];
			te.OEMCodePage = entry_te[5];

			var entry_nf = Numbers[lcid];
			var nf = ci.NumberFormatEntry;
			nf.CurrencyNegativePattern = entry_nf[0];
			nf.CurrencyPositivePattern = entry_nf[1];
			nf.NumberNegativePattern = entry_nf[2];
			nf.PercentNegativePattern = entry_nf[3];
			nf.PercentPositivePattern = entry_nf[4];

			string[][] gsizes;
			if (!GroupSizes.TryGetValue (lcid, out gsizes)) {
				gsizes = new[] { new[] { "3" }, new[] { "3" }, new[] { "3" } };
			}

			gsizes[0].CopyTo (nf.CurrencyGroupSizes, 0);
			gsizes[1].CopyTo (nf.NumberGroupSizes, 0);
			gsizes[2].CopyTo (nf.PercentGroupSizes, 0);
		}

		public static void FillValues (int lcid, RegionInfoEntry ri)
		{
			var entry = Geo[lcid];
			ri.GeoId = entry;
		}
	}
}
