<!---
Thanks for filing an issue 😄! Before you submit, please read the following:

Search open/closed issues before submitting since someone might have asked the same thing before!
Our issues history stretches back to 2009, so the odds are good that your topic has come up.

If you have a support request or question please use Stack Overflow:
https://stackoverflow.com/questions/tagged/coffeescript

Issues on GitHub are only related to problems of the CoffeeScript compiler itself and we cannot answer
support questions here.
-->

Choose one: is this a bug report or feature request?

<!---
Provide a general summary of the issue in the title above.

For bugs, please also preface your title with “Bug:”. For feature requests, please preface your title
with “Proposal:”. Once your issue is reviewed, a maintainer will edit the title to refer to the part
of the codebase most relevant to the issue (if applicable).

If your request is that CoffeeScript support a new feature recently arrived to JavaScript, please note
that we generally only add features that have reached Stage 4 in the specification (in other words,
the syntax is finalized and the feature is approved to be part of the next ES release). You can still
open an issue, but it will likely be tagged with “[Awaiting Stage 4]” until the relevant ES feature is
approved for release. See https://coffeescript.org/#contributing

There are also a handful of JavaScript features that CoffeeScript intentionally does not support.
Please do not open issues regarding these. They’re listed in https://coffeescript.org/#unsupported
-->

### Input Code
<!--- If you're describing a bug, please let us know which sample code reproduces your problem. -->
<!--- If you have link from https://coffeescript.org/#try or a standalone repo please include that! -->

```coffee
your (code) => here
```

### Expected Behavior
<!--- If you’re describing a bug, tell us what should happen. -->
<!--- If you’re suggesting a change/improvement, tell us how it should work. -->

### Current Behavior
<!--- If describing a bug, tell us what happens instead of the expected behavior. -->
<!--- If suggesting a change/improvement, explain the difference from current behavior. -->

### Possible Solution
<!--- Not obligatory, but suggest a fix/reason for the bug, -->
<!--- or ideas how to implement the addition or change. -->

### Context
<!--- How has this issue affected you? What are you trying to accomplish? -->
<!--- Providing context helps us come up with a solution that is most useful in the real world. -->

### Environment
<!--- For bugs, please let us know what version of CoffeeScript you’re running: `coffee -v`. -->
<!--- If you think it might be relevant, please also let us know your version of Node. -->

* CoffeeScript version:
* Node.js version:
