/* CastosPodcastSearcher.h, (Created on 28.05.2024) */

/* Copyright (C) 2011-2024 Michael Lugmair
 *
 * This file is part of Sayonara Player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SAYONARA_PLAYER_CASTOSPODCASTSEARCHER_H
#define SAYONARA_PLAYER_CASTOSPODCASTSEARCHER_H

#include "StationSearcher.h"

class CastosPodcastSearcher :
	public StationSearcher
{
	public:
		explicit CastosPodcastSearcher(QObject* parent);
		~CastosPodcastSearcher() override;
		[[nodiscard]] QString serviceName() const override;
	protected:
		[[nodiscard]] QString
		buildUrl(const QString& searchtext, int serverIndex, Mode mode, int page, int maxEntries) const override;
		[[nodiscard]] QByteArray postData(const QString& searchtext) const override;
		[[nodiscard]] QMap<QByteArray, QByteArray> headers() const override;
		std::unique_ptr<StationParser> createStationParser() override;

};

#endif //SAYONARA_PLAYER_CASTOSPODCASTSEARCHER_H
