---
myst:
  html_meta:
    keywords: LuaTeX,callback,Lua,LuaLaTeX
---
# Qu'est-ce qu’un _callback_ ?

Les _callbacks_, ou _fonctions de rappel_ en bon français, sont des fonctions
accessibles par l’utilisateur qui implémentent les opérations internes de TeX ;
celles-ci peuvent être améliorées en les combinant avec d’autres fonctions ad
hoc, mais on peut aussi les remplacer complètement. Ces _callbacks_ ne sont
accessibles qu’avec le [moteur LuaTeX](luatex.md) qui est un moteur TeX
incluant un interpréteur Lua. Tous les _callbacks_ sont écrits en [Lua](wpfr:Lua).

Les fonctions enregistrées comme des _callbacks_ interviennent donc
dans une séquence d’actions qui constitue le traitement par le moteur TeX lors
de la composition d’un document.

Les _callbacks_ sont donc des portes d’entrées à différentes étapes de la
production d’un document. La plupart des fonctions des _callbacks_ recevront des
arguments (et doivent donc être définies pour les gérer) et, surtout, beaucoup
sont censées renvoyer des valeurs.

La liste des _callbacks_ accessibles [est
impressionnante](https://wiki.luatex.org/index.php/Callbacks). Ils permettent
d’avoir accès aux mécanismes :
- de recherche de fichiers ;
- de lecture de fichiers ;
- de traitement de fichiers ;
- de traitement des nœuds (notamment pour fabriquer les paragraphes, mais aussi
  pour la fabrication des pages) ;
- de traitement des rapports de TeX ;
- de gestion des fonctionnalités PDF ;
- etc.

 Pour lister l’ensemble des _callbacks_ disponibles à partir d’un document
 LuaTeX, on pourra compiler le document suivant :

 ```{noedit}
\documentclass{article}
  \usepackage[width=8cm]{geometry}
  \pagestyle{empty}

\begin{document}
\directlua{
    info = callback.list()
    for k, v in pairs(info) do
        print(k)
    end
}%
\end{document}
```
Ce code produit la liste suivante :
- `pre_dump`
- `show_lua_error_hook`
- `show_warning_message`
- `start_page_number`
- `open_read_file`
- `hpack_quality`
- `read_type1_file`
- `find_read_file`
- `process_input_buffer`
- `process_rule`
- `vpack_filter`
- `stop_run`
- `finish_pdffile`
- `read_enc_file`
- `find_font_file`
- `start_run`
- `find_cidmap_file`
- `finish_pdfpage`
- `read_truetype_file`
- `pre_linebreak_filter`
- `find_truetype_file`
- `start_file`
- `kerning`
- `read_opentype_file`
- `font_descriptor_objnum_provider`
- `read_data_file`
- `read_map_file`
- `input_level_string`
- `find_image_file`
- `glyph_not_found`
- `wrapup_run`
- `make_extensible`
- `process_jobname`
- `find_vf_file`
- `find_type1_file`
- `define_font`
- `find_output_file`
- `glyph_info`
- `process_output_buffer`
- `finish_synctex`
- `page_order_index`
- `append_to_vlist_filter`
- `provide_charproc_data`
- `find_pk_file`
- `read_pk_file`
- `process_pdf_image_content`
- `read_cidmap_file`
- `buildpage_filter`
- `new_graf`
- `hpack_filter`
- `glyph_stream_provider`
- `find_write_file`
- `find_format_file`
- `build_page_insert`
- `call_edit`
- `contribute_filter`
- `insert_local_par`
- `linebreak_filter`
- `find_opentype_file`
- `stop_page_number`
- `stop_file`
- `find_map_file`
- `read_vf_file`
- `vpack_quality`
- `find_enc_file`
- `hyphenate`
- `show_error_message`
- `mlist_to_hlist`
- `show_error_hook`
- `pre_output_filter`
- `read_font_file`
- `find_data_file`
- `ligaturing`
- `post_linebreak_filter`


## Enregistrer un _callback_

Il y a deux types de _callbacks_ : ceux qui étendent la fonctionnalité existante
avec une nouvelle, et ceux qui (quand cela est possible) remplacent la
fonctionnalité existante. Évidemment, lorsqu’on remplace la fonctionnalité
existante, il est attendu que notre nouvelle définition fonctionne de façon
similaire. Pour enregistrer un des _callbacks_ listés ci-dessus, on utilisera la
syntaxe (Lua) suivante :

```lua
id, error = callback.register(<string> callback_name, <function> func)
```
Si l’on souhaite rétablir le comportement par défaut, il suffira d’exécuter le
code suivant :

```lua
id, error = callback.register(<string> callback_name, nil)
```

## Avec LuaLaTeX

Les fonctions ci-dessus sont celles du moteur LuaTeX. L’utilisation du format
LaTeX peut poser quelques problèmes. David Carlisle et Joseph Wright ont
développé le package <ctanpkg:ltluatex> (présent dans le noyau LaTeX) qui fournit
des commandes TeX et des fonctions Lua adaptées au format. En particulier, on
utilisera les fonctions, aux noms plus explicites :
```lua
luatexbase.add_to_callback(<string> callback_name, <function> func, <string> description)
```
et
```lua
luatexbase.remove_from_callback(<string> callback, <string> description)
```


:::{sources}
[Maxime Chupin, _Lua(La)TeX : comment avoir accès à la fabrication d’un paragraphe ?_, la _Lettre GUTenberg_, numéro 53, p. 36-58](https://publications.gutenberg-asso.fr/lettre/article/view/169)
:::
