/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2024 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#pragma once

#include <glib.h>
#include <stdint.h>

G_BEGIN_DECLS

typedef struct _MctTimeSpan MctTimeSpan;

MctTimeSpan *mct_time_span_new (uint64_t start_time_secs,
                                uint64_t end_time_secs);

void mct_time_span_free (MctTimeSpan *self);

G_DEFINE_AUTOPTR_CLEANUP_FUNC (MctTimeSpan, mct_time_span_free)

MctTimeSpan *mct_time_span_copy (const MctTimeSpan *self);

int mct_time_span_compare (const MctTimeSpan *self,
                           const MctTimeSpan *other);

uint64_t mct_time_span_get_start_time_secs (const MctTimeSpan *self);
uint64_t mct_time_span_get_end_time_secs (const MctTimeSpan *self);

G_END_DECLS
