/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *  - Ignacy Kuchciński <ignacykuchcinski@gnome.org>
 */

#pragma once

#include <adwaita.h>
#include <libmalcontent/malcontent.h>

G_BEGIN_DECLS

#define MCT_TYPE_TIME_PAGE (mct_time_page_get_type ())
G_DECLARE_FINAL_TYPE (MctTimePage, mct_time_page, MCT, TIME_PAGE, AdwNavigationPage)

MctTimePage *mct_time_page_new (MctManager *policy_manager, GDBusConnection *connection);

MctUser *mct_time_page_get_user (MctTimePage *self);
void mct_time_page_set_user (MctTimePage *self, MctUser *user);

G_END_DECLS
