package org.rcsb.cif.schema.mm;

import org.rcsb.cif.model.FloatColumnBuilder;
import org.rcsb.cif.model.IntColumnBuilder;
import org.rcsb.cif.model.StrColumnBuilder;
import org.rcsb.cif.model.builder.CategoryBuilderImpl;
import org.rcsb.cif.model.builder.FloatColumnBuilderImpl;
import org.rcsb.cif.model.builder.IntColumnBuilderImpl;
import org.rcsb.cif.model.builder.StrColumnBuilderImpl;

import javax.annotation.Generated;

@Generated("org.rcsb.cif.schema.generator.SchemaGenerator")
public class MmCifCategoryBuilder extends CategoryBuilderImpl<MmCifBlockBuilder, MmCifFileBuilder> {
    public MmCifCategoryBuilder(String blockName, MmCifBlockBuilder parent) {
        super(blockName, parent);
    }

    public static class AtomSiteBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_site";

        public AtomSiteBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][1]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB11Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][1]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][2]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB12Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][3]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB13Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[2][2]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB22Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[2][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[2][3]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB23Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[2][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[3][3]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB33Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[3][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoRatio() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_ratio", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[1][1]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU11Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[1][1]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[1][2]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU12Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[1][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[1][3]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU13Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[1][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[2][2]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU22Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[2][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[2][3]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU23Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[2][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[3][3]", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoU33Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_U[3][3]_esd", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAttachedHydrogens() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "attached_hydrogens", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBEquivGeomMean() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_equiv_geom_mean", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBEquivGeomMeanEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_equiv_geom_mean_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoOrEquiv() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_or_equiv", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoOrEquivEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_or_equiv_esd", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCalcAttachedAtom() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "calc_attached_atom", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCalcFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "calc_flag", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnXEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_x_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnYEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_y_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnZEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_z_esd", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemicalConnNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "chemical_conn_number", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConstraints() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "constraints", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDisorderAssembly() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "disorder_assembly", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDisorderGroup() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "disorder_group", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFootnoteId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "footnote_id", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_x", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractXEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_x_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_y", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractYEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_y_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_z", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractZEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_z_esd", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterGroupPDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "group_PDB", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_entity_id", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_esd", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRestraints() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "restraints", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmetryMultiplicity() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "symmetry_multiplicity", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterThermalDisplaceType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "thermal_displace_type", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_symbol", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUEquivGeomMean() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_equiv_geom_mean", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUEquivGeomMeanEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_equiv_geom_mean_esd", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUIsoOrEquiv() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_iso_or_equiv", this);
        }

        public FloatColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUIsoOrEquivEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_iso_or_equiv_esd", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWyckoffSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "Wyckoff_symbol", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomAmbiguity() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_ambiguity", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAdpType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "adp_type", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefinementFlags() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "refinement_flags", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefinementFlagsAdp() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "refinement_flags_adp", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefinementFlagsOccupancy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "refinement_flags_occupancy", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefinementFlagsPosn() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "refinement_flags_posn", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_alt_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_ins_code", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_model_num", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBResidueNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_residue_no", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBResidueName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_residue_name", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_strand_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBAtomName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_atom_name", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAtomName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_atom_name", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormalCharge() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formal_charge", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_comp_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_asym_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_seq_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTlsGroupId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_tls_group_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNcsDomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ncs_dom_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStructGroupId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_struct_group_id", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxGroupNDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_group_NDB", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomGroup() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_group", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_seq_num", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNotInAsym() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_not_in_asym", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelIndex() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_index", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSiftsXrefDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_sifts_xref_db_name", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSiftsXrefDbAcc() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_sifts_xref_db_acc", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSiftsXrefDbNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_sifts_xref_db_num", this);
        }

        public StrColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSiftsXrefDbRes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_sifts_xref_db_res", this);
        }

        public IntColumnBuilder<AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIhmModelId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ihm_model_id", this);
        }

    }

    public static class AtomSiteAnisotropBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_site_anisotrop";

        public AtomSiteAnisotropBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[1][1]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB11Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[1][1]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[1][2]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB12Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[1][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[1][3]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB13Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[1][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[2][2]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB22Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[2][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[2][3]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB23Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[2][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[3][3]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB33Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B[3][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRatio() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ratio", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_symbol", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[1][1]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU11Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[1][1]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[1][2]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU12Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[1][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[1][3]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU13Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[1][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[2][2]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU22Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[2][2]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[2][3]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU23Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[2][3]_esd", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[3][3]", this);
        }

        public FloatColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterU33Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U[3][3]_esd", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_seq_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_alt_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_asym_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_atom_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_comp_id", this);
        }

        public IntColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_seq_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_alt_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_asym_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_atom_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_comp_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_ins_code", this);
        }

        public IntColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_model_num", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNotInAsym() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_not_in_asym", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBResidueNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_residue_no", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBResidueName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_residue_name", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_strand_id", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBAtomName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_atom_name", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAtomName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_atom_name", this);
        }

        public StrColumnBuilder<AtomSiteAnisotropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_ins_code", this);
        }

    }

    public static class AtomSitesBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_sites";

        public AtomSitesBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[1][1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[1][2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[1][3]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[2][1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[2][2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[2][3]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[3][1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[3][2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_matrix[3][3]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_vector[1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_vector[2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransfVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transf_vector[3]", this);
        }

        public StrColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnTransformAxes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_transform_axes", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[1][1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[1][2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[1][3]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[2][1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[2][2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[2][3]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[3][1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[3][2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_matrix[3][3]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_vector[1]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_vector[2]", this);
        }

        public FloatColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractTransfVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_transf_vector[3]", this);
        }

        public StrColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolutionPrimary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solution_primary", this);
        }

        public StrColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolutionSecondary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solution_secondary", this);
        }

        public StrColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolutionHydrogens() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solution_hydrogens", this);
        }

        public StrColumnBuilder<AtomSitesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpecialDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "special_details", this);
        }

    }

    public static class AtomSitesAltBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_sites_alt";

        public AtomSitesAltBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AtomSitesAltBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<AtomSitesAltBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

    }

    public static class AtomSitesAltEnsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_sites_alt_ens";

        public AtomSitesAltEnsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AtomSitesAltEnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<AtomSitesAltEnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

    }

    public static class AtomSitesAltGenBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_sites_alt_gen";

        public AtomSitesAltGenBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AtomSitesAltGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "alt_id", this);
        }

        public StrColumnBuilder<AtomSitesAltGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEnsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ens_id", this);
        }

    }

    public static class AtomSitesFootnoteBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_sites_footnote";

        public AtomSitesFootnoteBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AtomSitesFootnoteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<AtomSitesFootnoteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class AtomTypeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "atom_type";

        public AtomTypeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnalyticalMassPercent() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "analytical_mass_percent", this);
        }

        public StrColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "description", this);
        }

        public IntColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberInCell() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_in_cell", this);
        }

        public IntColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOxidationNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "oxidation_number", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRadiusBond() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "radius_bond", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRadiusContact() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "radius_contact", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannA1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_a1", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannA2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_a2", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannA3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_a3", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannA4() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_a4", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannB1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_b1", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannB2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_b2", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannB3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_b3", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannB4() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_b4", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatCromerMannC() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_Cromer_Mann_c", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatDispersionImag() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_dispersion_imag", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatDispersionReal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scat_dispersion_real", this);
        }

        public StrColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatLengthNeutron() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scat_length_neutron", this);
        }

        public StrColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scat_source", this);
        }

        public StrColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatVersusStolList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scat_versus_stol_list", this);
        }

        public StrColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "symbol", this);
        }

        public StrColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatDispersionSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scat_dispersion_source", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScatCromerMannA5() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scat_Cromer_Mann_a5", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScatCromerMannB5() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scat_Cromer_Mann_b5", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScatCromerMannA6() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scat_Cromer_Mann_a6", this);
        }

        public FloatColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScatCromerMannB6() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scat_Cromer_Mann_b6", this);
        }

        public IntColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScatZ() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scat_Z", this);
        }

        public IntColumnBuilder<AtomTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNElectrons() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_N_electrons", this);
        }

    }

    public static class AuditBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "audit";

        public AuditBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCreationDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "creation_date", this);
        }

        public StrColumnBuilder<AuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCreationMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "creation_method", this);
        }

        public StrColumnBuilder<AuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRevisionId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "revision_id", this);
        }

        public StrColumnBuilder<AuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUpdateRecord() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "update_record", this);
        }

    }

    public static class AuditAuthorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "audit_author";

        public AuditAuthorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AuditAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "address", this);
        }

        public StrColumnBuilder<AuditAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<AuditAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

        public StrColumnBuilder<AuditAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIdentifierORCID() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "identifier_ORCID", this);
        }

    }

    public static class AuditConformBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "audit_conform";

        public AuditConformBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AuditConformBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDictLocation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dict_location", this);
        }

        public StrColumnBuilder<AuditConformBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDictName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dict_name", this);
        }

        public StrColumnBuilder<AuditConformBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDictVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dict_version", this);
        }

    }

    public static class AuditContactAuthorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "audit_contact_author";

        public AuditContactAuthorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AuditContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "address", this);
        }

        public StrColumnBuilder<AuditContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "email", this);
        }

        public StrColumnBuilder<AuditContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFax() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "fax", this);
        }

        public StrColumnBuilder<AuditContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<AuditContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhone() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "phone", this);
        }

    }

    public static class CellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "cell";

        public CellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleAlpha() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_alpha", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleAlphaEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_alpha_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleBeta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_beta", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleBetaEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_beta_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleGamma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_gamma", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleGammaEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_gamma_esd", this);
        }

        public StrColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormulaUnitsZ() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "formula_units_Z", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLengthA() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "length_a", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLengthAEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "length_a_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLengthB() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "length_b", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLengthBEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "length_b_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLengthC() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "length_c", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLengthCEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "length_c_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolume() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume_esd", this);
        }

        public IntColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterZPDB() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "Z_PDB", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalAngleAlpha() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_angle_alpha", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalAngleBeta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_angle_beta", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalAngleGamma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_angle_gamma", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalAngleAlphaEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_angle_alpha_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalAngleBetaEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_angle_beta_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalAngleGammaEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_angle_gamma_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalLengthA() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_length_a", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalLengthB() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_length_b", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalLengthC() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_length_c", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalLengthAEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_length_a_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalLengthBEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_length_b_esd", this);
        }

        public FloatColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReciprocalLengthCEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reciprocal_length_c_esd", this);
        }

        public StrColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxUniqueAxis() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_unique_axis", this);
        }

        public StrColumnBuilder<CellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEsdMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_esd_method", this);
        }

    }

    public static class CellMeasurementBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "cell_measurement";

        public CellMeasurementBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPressure() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pressure", this);
        }

        public FloatColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPressureEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pressure_esd", this);
        }

        public StrColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRadiation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "radiation", this);
        }

        public IntColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsUsed() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_used", this);
        }

        public FloatColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemp() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temp", this);
        }

        public FloatColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTempEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temp_esd", this);
        }

        public FloatColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterThetaMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "theta_max", this);
        }

        public FloatColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterThetaMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "theta_min", this);
        }

        public FloatColumnBuilder<CellMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelength() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wavelength", this);
        }

    }

    public static class CellMeasurementReflnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "cell_measurement_refln";

        public CellMeasurementReflnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<CellMeasurementReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<CellMeasurementReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<CellMeasurementReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

        public FloatColumnBuilder<CellMeasurementReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTheta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "theta", this);
        }

    }

    public static class ChemCompBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp";

        public ChemCompBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormula() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "formula", this);
        }

        public FloatColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormulaWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "formula_weight", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "model_details", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelErf() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "model_erf", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "model_source", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonNstdClass() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_nstd_class", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonNstdDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_nstd_details", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonNstdFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_nstd_flag", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonNstdParent() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_nstd_parent", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonNstdParentCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_nstd_parent_comp_id", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_all", this);
        }

        public IntColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsNh() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_nh", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOneLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "one_letter_code", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterThreeLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "three_letter_code", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSynonyms() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_synonyms", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModificationDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_modification_details", this);
        }

        public IntColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxComponentNo() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_component_no", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_type", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAmbiguousFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ambiguous_flag", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReplacedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_replaced_by", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReplaces() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_replaces", this);
        }

        public IntColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormalCharge() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formal_charge", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSubcomponentList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_subcomponent_list", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelCoordinatesDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_coordinates_details", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelCoordinatesDbCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_coordinates_db_code", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxIdealCoordinatesDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ideal_coordinates_details", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxIdealCoordinatesMissingFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ideal_coordinates_missing_flag", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelCoordinatesMissingFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_coordinates_missing_flag", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxInitialDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_initial_date", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModifiedDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_modified_date", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReleaseStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_release_status", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxProcessingSite() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_processing_site", this);
        }

        public IntColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberSubcomponents() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_subcomponents", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxClass1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_class_1", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxClass2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_class_2", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCompType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_comp_type", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReservedName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_reserved_name", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_status", this);
        }

        public IntColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTypeModified() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_type_modified", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCasnum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_casnum", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSmiles() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_smiles", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNscnum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_nscnum", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPcm() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pcm", this);
        }

        public StrColumnBuilder<ChemCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaProvenance() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ma_provenance", this);
        }

    }

    public static class ChemCompAngleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_angle";

        public ChemCompAngleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_3", this);
        }

        public StrColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public FloatColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_angle", this);
        }

        public FloatColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueAngleEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_angle_esd", this);
        }

        public FloatColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist", this);
        }

        public FloatColumnBuilder<ChemCompAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist_esd", this);
        }

    }

    public static class ChemCompAtomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_atom";

        public ChemCompAtomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAltAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "alt_atom_id", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public IntColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCharge() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "charge", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelCartnX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "model_Cartn_x", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelCartnXEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "model_Cartn_x_esd", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelCartnY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "model_Cartn_y", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelCartnYEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "model_Cartn_y_esd", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelCartnZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "model_Cartn_z", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelCartnZEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "model_Cartn_z_esd", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPartialCharge() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "partial_charge", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSubstructCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "substruct_code", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_symbol", this);
        }

        public IntColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAlign() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_align", this);
        }

        public IntColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxComponentAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_component_atom_id", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxComponentCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_component_comp_id", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAltAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_alt_atom_id", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAltCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_alt_comp_id", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelCartnXIdeal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_Cartn_x_ideal", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelCartnYIdeal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_Cartn_y_ideal", this);
        }

        public FloatColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelCartnZIdeal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_Cartn_z_ideal", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStereoConfig() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_stereo_config", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAromaticFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aromatic_flag", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLeavingAtomFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_leaving_atom_flag", this);
        }

        public IntColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxResidueNumbering() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_residue_numbering", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPolymerType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_polymer_type", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ref_id", this);
        }

        public IntColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxComponentId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_component_id", this);
        }

        public IntColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxComponentEntityId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_component_entity_id", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStndAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_stnd_atom_id", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBackboneAtomFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_backbone_atom_flag", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNTerminalAtomFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_n_terminal_atom_flag", this);
        }

        public StrColumnBuilder<ChemCompAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCTerminalAtomFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_c_terminal_atom_flag", this);
        }

    }

    public static class ChemCompBondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_bond";

        public ChemCompBondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueOrder() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value_order", this);
        }

        public FloatColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist", this);
        }

        public FloatColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist_esd", this);
        }

        public IntColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

        public StrColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStereoConfig() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_stereo_config", this);
        }

        public StrColumnBuilder<ChemCompBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAromaticFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aromatic_flag", this);
        }

    }

    public static class ChemCompChirBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_chir";

        public ChemCompChirBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomConfig() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_config", this);
        }

        public StrColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_all", this);
        }

        public IntColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsNh() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_nh", this);
        }

        public StrColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "volume_flag", this);
        }

        public FloatColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeThree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume_three", this);
        }

        public FloatColumnBuilder<ChemCompChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeThreeEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume_three_esd", this);
        }

    }

    public static class ChemCompChirAtomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_chir_atom";

        public ChemCompChirAtomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<ChemCompChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChirId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chir_id", this);
        }

        public StrColumnBuilder<ChemCompChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public FloatColumnBuilder<ChemCompChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dev", this);
        }

    }

    public static class ChemCompLinkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_link";

        public ChemCompLinkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<ChemCompLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<ChemCompLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeComp1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_comp_1", this);
        }

        public StrColumnBuilder<ChemCompLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeComp2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_comp_2", this);
        }

    }

    public static class ChemCompPlaneBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_plane";

        public ChemCompPlaneBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemCompPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<ChemCompPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_all", this);
        }

        public IntColumnBuilder<ChemCompPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsNh() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_nh", this);
        }

    }

    public static class ChemCompPlaneAtomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_plane_atom";

        public ChemCompPlaneAtomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompPlaneAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<ChemCompPlaneAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<ChemCompPlaneAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPlaneId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "plane_id", this);
        }

        public FloatColumnBuilder<ChemCompPlaneAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_esd", this);
        }

    }

    public static class ChemCompTorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_tor";

        public ChemCompTorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<ChemCompTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<ChemCompTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_3", this);
        }

        public StrColumnBuilder<ChemCompTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_4", this);
        }

        public StrColumnBuilder<ChemCompTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemCompTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

    }

    public static class ChemCompTorValueBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_comp_tor_value";

        public ChemCompTorValueBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemCompTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<ChemCompTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTorId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "tor_id", this);
        }

        public FloatColumnBuilder<ChemCompTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle", this);
        }

        public FloatColumnBuilder<ChemCompTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_esd", this);
        }

        public FloatColumnBuilder<ChemCompTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist", this);
        }

        public FloatColumnBuilder<ChemCompTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_esd", this);
        }

    }

    public static class ChemLinkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link";

        public ChemLinkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class ChemLinkAngleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_angle";

        public ChemLinkAngleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom1CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_1_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom2CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_2_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom3CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_3_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_3", this);
        }

        public StrColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public FloatColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_angle", this);
        }

        public FloatColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueAngleEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_angle_esd", this);
        }

        public FloatColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist", this);
        }

        public FloatColumnBuilder<ChemLinkAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist_esd", this);
        }

    }

    public static class ChemLinkBondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_bond";

        public ChemLinkBondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom1CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_1_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom2CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_2_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public FloatColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist", this);
        }

        public FloatColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_dist_esd", this);
        }

        public StrColumnBuilder<ChemLinkBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueOrder() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value_order", this);
        }

    }

    public static class ChemLinkChirBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_chir";

        public ChemLinkChirBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomConfig() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_config", this);
        }

        public StrColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public IntColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_all", this);
        }

        public IntColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsNh() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_nh", this);
        }

        public StrColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "volume_flag", this);
        }

        public FloatColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeThree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume_three", this);
        }

        public FloatColumnBuilder<ChemLinkChirBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeThreeEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume_three_esd", this);
        }

    }

    public static class ChemLinkChirAtomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_chir_atom";

        public ChemLinkChirAtomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<ChemLinkChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChirId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chir_id", this);
        }

        public FloatColumnBuilder<ChemLinkChirAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dev", this);
        }

    }

    public static class ChemLinkPlaneBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_plane";

        public ChemLinkPlaneBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemLinkPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public IntColumnBuilder<ChemLinkPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_all", this);
        }

        public IntColumnBuilder<ChemLinkPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsNh() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_nh", this);
        }

    }

    public static class ChemLinkPlaneAtomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_plane_atom";

        public ChemLinkPlaneAtomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkPlaneAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkPlaneAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<ChemLinkPlaneAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPlaneId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "plane_id", this);
        }

    }

    public static class ChemLinkTorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_tor";

        public ChemLinkTorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom1CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_1_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom2CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_2_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom3CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_3_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom4CompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_4_comp_id", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_3", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_4", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ChemLinkTorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

    }

    public static class ChemLinkTorValueBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chem_link_tor_value";

        public ChemLinkTorValueBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemLinkTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTorId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "tor_id", this);
        }

        public FloatColumnBuilder<ChemLinkTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle", this);
        }

        public FloatColumnBuilder<ChemLinkTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_esd", this);
        }

        public FloatColumnBuilder<ChemLinkTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist", this);
        }

        public FloatColumnBuilder<ChemLinkTorValueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_esd", this);
        }

    }

    public static class ChemicalBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chemical";

        public ChemicalBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompoundSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "compound_source", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeltingPoint() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "melting_point", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameCommon() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_common", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameMineral() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_mineral", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameStructureType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_structure_type", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameSystematic() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_systematic", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbsoluteConfiguration() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "absolute_configuration", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeltingPointGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "melting_point_gt", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeltingPointLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "melting_point_lt", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOpticalRotation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "optical_rotation", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPropertiesBiological() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "properties_biological", this);
        }

        public StrColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPropertiesPhysical() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "properties_physical", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureDecomposition() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_decomposition", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureDecompositionEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_decomposition_esd", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureDecompositionGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_decomposition_gt", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureDecompositionLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_decomposition_lt", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureSublimation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_sublimation", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureSublimationEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_sublimation_esd", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureSublimationGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_sublimation_gt", this);
        }

        public FloatColumnBuilder<ChemicalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureSublimationLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_sublimation_lt", this);
        }

    }

    public static class ChemicalConnAtomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chemical_conn_atom";

        public ChemicalConnAtomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<ChemicalConnAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCharge() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "charge", this);
        }

        public FloatColumnBuilder<ChemicalConnAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDisplayX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "display_x", this);
        }

        public FloatColumnBuilder<ChemicalConnAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDisplayY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "display_y", this);
        }

        public IntColumnBuilder<ChemicalConnAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNCA() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NCA", this);
        }

        public IntColumnBuilder<ChemicalConnAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NH", this);
        }

        public IntColumnBuilder<ChemicalConnAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number", this);
        }

        public StrColumnBuilder<ChemicalConnAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_symbol", this);
        }

    }

    public static class ChemicalConnBondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chemical_conn_bond";

        public ChemicalConnBondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<ChemicalConnBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_1", this);
        }

        public IntColumnBuilder<ChemicalConnBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_2", this);
        }

        public StrColumnBuilder<ChemicalConnBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class ChemicalFormulaBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "chemical_formula";

        public ChemicalFormulaBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnalytical() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "analytical", this);
        }

        public StrColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIupac() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "iupac", this);
        }

        public StrColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMoiety() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "moiety", this);
        }

        public StrColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStructural() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "structural", this);
        }

        public StrColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sum", this);
        }

        public FloatColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "weight", this);
        }

        public FloatColumnBuilder<ChemicalFormulaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWeightMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "weight_meas", this);
        }

    }

    public static class CitationBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "citation";

        public CitationBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbstract() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "abstract", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbstractIdCAS() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "abstract_id_CAS", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBookIdISBN() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "book_id_ISBN", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBookPublisher() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "book_publisher", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBookPublisherCity() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "book_publisher_city", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBookTitle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "book_title", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoordinateLinkage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coordinate_linkage", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "country", this);
        }

        public IntColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDatabaseIdMedline() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "database_id_Medline", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalAbbrev() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_abbrev", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalIdASTM() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_id_ASTM", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalIdCSD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_id_CSD", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalIdISSN() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_id_ISSN", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalFull() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_full", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalIssue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_issue", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalVolume() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_volume", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLanguage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "language", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPageFirst() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "page_first", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPageLast() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "page_last", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTitle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "title", this);
        }

        public IntColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterYear() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "year", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDatabaseIdCSD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "database_id_CSD", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDatabaseIdDOI() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_database_id_DOI", this);
        }

        public IntColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDatabaseIdPubMed() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_database_id_PubMed", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDatabaseIdPatent() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_database_id_patent", this);
        }

        public StrColumnBuilder<CitationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUnpublishedFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "unpublished_flag", this);
        }

    }

    public static class CitationAuthorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "citation_author";

        public CitationAuthorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<CitationAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "citation_id", this);
        }

        public StrColumnBuilder<CitationAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<CitationAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<CitationAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIdentifierORCID() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "identifier_ORCID", this);
        }

    }

    public static class CitationEditorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "citation_editor";

        public CitationEditorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<CitationEditorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "citation_id", this);
        }

        public StrColumnBuilder<CitationEditorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<CitationEditorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

    }

    public static class ComputingBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "computing";

        public ComputingBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellRefinement() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "cell_refinement", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataCollection() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_collection", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataReduction() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_reduction", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMolecularGraphics() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "molecular_graphics", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPublicationMaterial() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "publication_material", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStructureRefinement() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "structure_refinement", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStructureSolution() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "structure_solution", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStructureRefinementMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_structure_refinement_method", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDataReductionIi() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_data_reduction_ii", this);
        }

        public StrColumnBuilder<ComputingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDataReductionDs() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_data_reduction_ds", this);
        }

    }

    public static class DatabaseBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database";

        public DatabaseBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalASTM() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_ASTM", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJournalCSD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "journal_CSD", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCSDHistory() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "CSD_history", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeCAS() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_CAS", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeCSD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_CSD", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeICSD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_ICSD", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeMDF() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_MDF", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeNBS() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_NBS", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodePDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_PDB", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodePDF() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_PDF", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeDepnumCcdcFiz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_depnum_ccdc_fiz", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeDepnumCcdcJournal() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_depnum_ccdc_journal", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodeDepnumCcdcArchive() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code_depnum_ccdc_archive", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCodeNDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_code_NDB", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCodePDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_code_PDB", this);
        }

        public StrColumnBuilder<DatabaseBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRelatedCodesPDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_related_codes_PDB", this);
        }

    }

    public static class Database2Builder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database_2";

        public Database2Builder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<Database2Builder, MmCifBlockBuilder, MmCifFileBuilder> enterDatabaseId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "database_id", this);
        }

        public StrColumnBuilder<Database2Builder, MmCifBlockBuilder, MmCifFileBuilder> enterDatabaseCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "database_code", this);
        }

        public StrColumnBuilder<Database2Builder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDatabaseAccession() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_database_accession", this);
        }

        public StrColumnBuilder<Database2Builder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDOI() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_DOI", this);
        }

    }

    public static class DatabasePDBCaveatBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database_PDB_caveat";

        public DatabasePDBCaveatBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<DatabasePDBCaveatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<DatabasePDBCaveatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class DatabasePDBMatrixBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database_PDB_matrix";

        public DatabasePDBMatrixBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[1][1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[1][2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[1][3]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[2][1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[2][2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[2][3]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[3][1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[3][2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigx33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx[3][3]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigxVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx_vector[1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigxVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx_vector[2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrigxVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origx_vector[3]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[1][1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[1][2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[1][3]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[2][1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[2][2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[2][3]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[3][1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[3][2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale[3][3]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScaleVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale_vector[1]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScaleVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale_vector[2]", this);
        }

        public FloatColumnBuilder<DatabasePDBMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScaleVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale_vector[3]", this);
        }

    }

    public static class DatabasePDBRemarkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database_PDB_remark";

        public DatabasePDBRemarkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<DatabasePDBRemarkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<DatabasePDBRemarkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class DatabasePDBRevBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database_PDB_rev";

        public DatabasePDBRevBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthorName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "author_name", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateOriginal() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_original", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mod_type", this);
        }

        public IntColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "num", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplacedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replaced_by", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplaces() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replaces", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRecordRevised1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_record_revised_1", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRecordRevised2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_record_revised_2", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRecordRevised3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_record_revised_3", this);
        }

        public StrColumnBuilder<DatabasePDBRevBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRecordRevised4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_record_revised_4", this);
        }

    }

    public static class DatabasePDBRevRecordBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database_PDB_rev_record";

        public DatabasePDBRevRecordBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DatabasePDBRevRecordBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<DatabasePDBRevRecordBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRevNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "rev_num", this);
        }

        public StrColumnBuilder<DatabasePDBRevRecordBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class DatabasePDBTvectBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "database_PDB_tvect";

        public DatabasePDBTvectBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DatabasePDBTvectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<DatabasePDBTvectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<DatabasePDBTvectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[1]", this);
        }

        public FloatColumnBuilder<DatabasePDBTvectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[2]", this);
        }

        public FloatColumnBuilder<DatabasePDBTvectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[3]", this);
        }

    }

    public static class DiffrnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn";

        public DiffrnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientEnvironment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ambient_environment", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientTemp() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_temp", this);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientTempDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ambient_temp_details", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientTempEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_temp_esd", this);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalSupport() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_support", this);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalTreatment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_treatment", this);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientPressure() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_pressure", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientPressureEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_pressure_esd", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientPressureGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_pressure_gt", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientPressureLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_pressure_lt", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientTempGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_temp_gt", this);
        }

        public FloatColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAmbientTempLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ambient_temp_lt", this);
        }

        public StrColumnBuilder<DiffrnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSerialCrystalExperiment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_serial_crystal_experiment", this);
        }

    }

    public static class DiffrnAttenuatorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_attenuator";

        public DiffrnAttenuatorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnAttenuatorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code", this);
        }

        public FloatColumnBuilder<DiffrnAttenuatorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScale() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale", this);
        }

        public StrColumnBuilder<DiffrnAttenuatorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaterial() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "material", this);
        }

    }

    public static class DiffrnDetectorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_detector";

        public DiffrnDetectorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetector() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "detector", this);
        }

        public StrColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public FloatColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAreaResolMean() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "area_resol_mean", this);
        }

        public FloatColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDtime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dtime", this);
        }

        public IntColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFramesTotal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_frames_total", this);
        }

        public FloatColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCollectionTimeTotal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_collection_time_total", this);
        }

        public StrColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCollectionDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_collection_date", this);
        }

        public FloatColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFrequency() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_frequency", this);
        }

        public StrColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<DiffrnDetectorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberOfAxes() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_of_axes", this);
        }

    }

    public static class DiffrnMeasurementBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_measurement";

        public DiffrnMeasurementBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDevice() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "device", this);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeviceDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "device_details", this);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeviceType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "device_type", this);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpecimenSupport() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "specimen_support", this);
        }

        public StrColumnBuilder<DiffrnMeasurementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_date", this);
        }

    }

    public static class DiffrnOrientMatrixBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_orient_matrix";

        public DiffrnOrientMatrixBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[1][1]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[1][2]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[1][3]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[2][1]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[2][2]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[2][3]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[3][1]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[3][2]", this);
        }

        public FloatColumnBuilder<DiffrnOrientMatrixBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUB33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "UB[3][3]", this);
        }

    }

    public static class DiffrnOrientReflnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_orient_refln";

        public DiffrnOrientReflnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleChi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_chi", this);
        }

        public FloatColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleKappa() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_kappa", this);
        }

        public FloatColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleOmega() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_omega", this);
        }

        public FloatColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnglePhi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_phi", this);
        }

        public FloatColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnglePsi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_psi", this);
        }

        public FloatColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleTheta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_theta", this);
        }

        public StrColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public IntColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<DiffrnOrientReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

    }

    public static class DiffrnRadiationBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_radiation";

        public DiffrnRadiationBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCollimation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "collimation", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public FloatColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFilterEdge() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "filter_edge", this);
        }

        public FloatColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInhomogeneity() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "inhomogeneity", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonochromator() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "monochromator", this);
        }

        public FloatColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPolarisnNorm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "polarisn_norm", this);
        }

        public FloatColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPolarisnRatio() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "polarisn_ratio", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProbe() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "probe", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterXraySymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "xray_symbol", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelengthId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "wavelength_id", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMonochromaticOrLaueML() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_monochromatic_or_laue_m_l", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxWavelengthList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_wavelength_list", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxWavelength() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_wavelength", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDiffrnProtocol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_diffrn_protocol", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnalyzer() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_analyzer", this);
        }

        public StrColumnBuilder<DiffrnRadiationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScatteringType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scattering_type", this);
        }

    }

    public static class DiffrnRadiationWavelengthBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_radiation_wavelength";

        public DiffrnRadiationWavelengthBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnRadiationWavelengthBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<DiffrnRadiationWavelengthBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelength() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wavelength", this);
        }

        public FloatColumnBuilder<DiffrnRadiationWavelengthBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wt", this);
        }

    }

    public static class DiffrnReflnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_refln";

        public DiffrnReflnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleChi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_chi", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleKappa() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_kappa", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleOmega() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_omega", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnglePhi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_phi", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnglePsi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_psi", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleTheta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_theta", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAttenuatorCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "attenuator_code", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountsBg1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "counts_bg_1", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountsBg2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "counts_bg_2", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountsNet() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "counts_net", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountsPeak() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "counts_peak", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountsTotal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "counts_total", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetectSlitHoriz() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "detect_slit_horiz", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetectSlitVert() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "detect_slit_vert", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterElapsedTime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "elapsed_time", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntensityNet() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "intensity_net", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntensitySigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "intensity_sigma", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScaleGroupCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scale_group_code", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScanMode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scan_mode", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScanModeBackgd() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scan_mode_backgd", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScanRate() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scan_rate", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScanTimeBackgd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scan_time_backgd", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScanWidth() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scan_width", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSintOverLambda() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sint_over_lambda", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStandardCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "standard_code", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelength() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wavelength", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelengthId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "wavelength_id", this);
        }

        public IntColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxImageId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_image_id", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScanAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scan_angle", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClassCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class_code", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntensityU() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "intensity_u", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetectorX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_detector_x", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetectorY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_detector_y", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRotationAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_rotation_angle", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScaleValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scale_value", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFrameId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "frame_id", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBatchId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_batch_id", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetectorObsFast() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_detector_obs_fast", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetectorObsSlow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_detector_obs_slow", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetectorCalcFast() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_detector_calc_fast", this);
        }

        public FloatColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetectorCalcSlow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_detector_calc_slow", this);
        }

        public StrColumnBuilder<DiffrnReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPanelMappingId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_panel_mapping_id", this);
        }

    }

    public static class DiffrnReflnsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_reflns";

        public DiffrnReflnsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAvREquivalents() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "av_R_equivalents", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAvSigmaIOverNetI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "av_sigmaI_over_netI", this);
        }

        public StrColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitHMax() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_h_max", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitHMin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_h_min", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitKMax() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_k_max", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitKMin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_k_min", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitLMax() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_l_max", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitLMin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_l_min", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number", this);
        }

        public StrColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReductionProcess() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reduction_process", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterThetaMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "theta_max", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterThetaMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "theta_min", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[1][1]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[1][2]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[1][3]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[2][1]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[2][2]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[2][3]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[3][1]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[3][2]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransfMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "transf_matrix[3][3]", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAvUnetI_netI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "av_unetI/netI", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_low", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_high", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_obs", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRmergeIObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rmerge_I_obs", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRsymValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rsym_value", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxChiSquared() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_chi_squared", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRedundancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_redundancy", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRejects() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_rejects", this);
        }

        public FloatColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxObservedCriterion() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_observed_criterion", this);
        }

        public IntColumnBuilder<DiffrnReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_obs", this);
        }

    }

    public static class DiffrnScaleGroupBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_scale_group";

        public DiffrnScaleGroupBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnScaleGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code", this);
        }

        public FloatColumnBuilder<DiffrnScaleGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterINet() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "I_net", this);
        }

    }

    public static class DiffrnSourceBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_source";

        public DiffrnSourceBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCurrent() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "current", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public FloatColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSize() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "size", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTarget() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "target", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public FloatColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVoltage() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "voltage", this);
        }

        public FloatColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTake_offAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "take-off_angle", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxWavelengthList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_wavelength_list", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxWavelength() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_wavelength", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSynchrotronBeamline() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_synchrotron_beamline", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSynchrotronSite() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_synchrotron_site", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSynchrotronYN() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_synchrotron_y_n", this);
        }

        public StrColumnBuilder<DiffrnSourceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSourceSpecificBeamline() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_source_specific_beamline", this);
        }

    }

    public static class DiffrnStandardReflnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_standard_refln";

        public DiffrnStandardReflnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnStandardReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code", this);
        }

        public StrColumnBuilder<DiffrnStandardReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public IntColumnBuilder<DiffrnStandardReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<DiffrnStandardReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<DiffrnStandardReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

    }

    public static class DiffrnStandardsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_standards";

        public DiffrnStandardsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<DiffrnStandardsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public FloatColumnBuilder<DiffrnStandardsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDecay() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "decay_%", this);
        }

        public IntColumnBuilder<DiffrnStandardsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntervalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "interval_count", this);
        }

        public FloatColumnBuilder<DiffrnStandardsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntervalTime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "interval_time", this);
        }

        public IntColumnBuilder<DiffrnStandardsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number", this);
        }

        public FloatColumnBuilder<DiffrnStandardsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScaleSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale_sigma", this);
        }

        public FloatColumnBuilder<DiffrnStandardsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScaleU() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "scale_u", this);
        }

    }

    public static class EntityBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entity";

        public EntityBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormulaWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "formula_weight", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSrcMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "src_method", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_description", this);
        }

        public IntColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberOfMolecules() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_of_molecules", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxParentEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_parent_entity_id", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMutation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_mutation", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFragment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fragment", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEc() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ec", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModification() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_modification", this);
        }

        public FloatColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormulaWeightExptl() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formula_weight_exptl", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormulaWeightExptlMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formula_weight_exptl_method", this);
        }

        public StrColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTargetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_target_id", this);
        }

        public FloatColumnBuilder<EntityBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEntitiesPerBiologicalUnit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_entities_per_biological_unit", this);
        }

    }

    public static class EntityKeywordsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entity_keywords";

        public EntityKeywordsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntityKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<EntityKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

        public StrColumnBuilder<EntityKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMutation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_mutation", this);
        }

        public StrColumnBuilder<EntityKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFragment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fragment", this);
        }

        public StrColumnBuilder<EntityKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEc() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ec", this);
        }

        public StrColumnBuilder<EntityKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAntibodyIsotype() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_antibody_isotype", this);
        }

    }

    public static class EntityLinkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entity_link";

        public EntityLinkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<EntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id_1", this);
        }

        public StrColumnBuilder<EntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id_2", this);
        }

        public IntColumnBuilder<EntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntitySeqNum1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "entity_seq_num_1", this);
        }

        public IntColumnBuilder<EntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntitySeqNum2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "entity_seq_num_2", this);
        }

    }

    public static class EntityNameComBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entity_name_com";

        public EntityNameComBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntityNameComBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<EntityNameComBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<EntityNameComBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxProvenance() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_provenance", this);
        }

    }

    public static class EntityNameSysBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entity_name_sys";

        public EntityNameSysBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntityNameSysBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<EntityNameSysBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<EntityNameSysBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSystem() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "system", this);
        }

    }

    public static class EntityPolyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entity_poly";

        public EntityPolyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNstdChirality() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "nstd_chirality", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNstdLinkage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "nstd_linkage", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNstdMonomer() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "nstd_monomer", this);
        }

        public IntColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberOfMonomers() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_of_monomers", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_details", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_strand_id", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqOneLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_one_letter_code", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqOneLetterCodeCan() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_one_letter_code_can", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTargetIdentifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_target_identifier", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqOneLetterCodeSample() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_one_letter_code_sample", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxExplicitLinkingFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_explicit_linking_flag", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSequenceEvidenceCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_sequence_evidence_code", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBuildSelfReference() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_build_self_reference", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNTerminalSeqOneLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_N_terminal_seq_one_letter_code", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCTerminalSeqOneLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_C_terminal_seq_one_letter_code", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqThreeLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_three_letter_code", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_db_name", this);
        }

        public StrColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqDbId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_db_id", this);
        }

        public IntColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqAlignBegin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_align_begin", this);
        }

        public IntColumnBuilder<EntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqAlignEnd() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_align_end", this);
        }

    }

    public static class EntityPolySeqBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entity_poly_seq";

        public EntityPolySeqBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<EntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHetero() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "hetero", this);
        }

        public StrColumnBuilder<EntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_id", this);
        }

        public IntColumnBuilder<EntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "num", this);
        }

    }

    public static class EntryBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entry";

        public EntryBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDOI() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_DOI", this);
        }

        public StrColumnBuilder<EntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaCollectionId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ma_collection_id", this);
        }

    }

    public static class EntryLinkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "entry_link";

        public EntryLinkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntryLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EntryLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EntryLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class ExptlBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "exptl";

        public ExptlBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbsorptCoefficientMu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "absorpt_coefficient_mu", this);
        }

        public FloatColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbsorptCorrectionTMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "absorpt_correction_T_max", this);
        }

        public FloatColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbsorptCorrectionTMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "absorpt_correction_T_min", this);
        }

        public StrColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbsorptCorrectionType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "absorpt_correction_type", this);
        }

        public StrColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAbsorptProcessDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "absorpt_process_details", this);
        }

        public StrColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalsNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "crystals_number", this);
        }

        public StrColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<ExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethodDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method_details", this);
        }

    }

    public static class ExptlCrystalBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "exptl_crystal";

        public ExptlCrystalBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterColour() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "colour", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityDiffrn() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_diffrn", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMatthews() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_Matthews", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "density_method", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityPercentSol() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_percent_sol", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "description", this);
        }

        public IntColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterF000() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "F_000", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreparation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "preparation", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSizeMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "size_max", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSizeMid() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "size_mid", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSizeMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "size_min", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSizeRad() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "size_rad", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterColourLustre() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "colour_lustre", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterColourModifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "colour_modifier", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterColourPrimary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "colour_primary", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeasEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas_esd", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeasGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas_gt", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeasLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas_lt", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeasTemp() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas_temp", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeasTempEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas_temp_esd", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeasTempGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas_temp_gt", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityMeasTempLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_meas_temp_lt", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalImageUrl() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_image_url", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalImageFormat() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_image_format", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMosaicity() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_mosaicity", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMosaicityEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_mosaicity_esd", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalImage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_image", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxX_rayImage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_x-ray_image", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxX_rayImageType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_x-ray_image_type", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalDiffrnLimit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_diffrn_limit", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalDiffrnLifetime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_diffrn_lifetime", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalDirection1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_direction_1", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalDirection2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_direction_2", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCrystalDirection3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_crystal_direction_3", this);
        }

        public StrColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMosaicMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_mosaic_method", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMosaicBlockSize() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_mosaic_block_size", this);
        }

        public FloatColumnBuilder<ExptlCrystalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMosaicBlockSizeEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_mosaic_block_size_esd", this);
        }

    }

    public static class ExptlCrystalFaceBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "exptl_crystal_face";

        public ExptlCrystalFaceBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public FloatColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrChi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diffr_chi", this);
        }

        public FloatColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrKappa() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diffr_kappa", this);
        }

        public FloatColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrPhi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diffr_phi", this);
        }

        public FloatColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrPsi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diffr_psi", this);
        }

        public IntColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

        public FloatColumnBuilder<ExptlCrystalFaceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPerpDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "perp_dist", this);
        }

    }

    public static class ExptlCrystalGrowBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "exptl_crystal_grow";

        public ExptlCrystalGrowBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterApparatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "apparatus", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtmosphere() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atmosphere", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethodRef() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method_ref", this);
        }

        public FloatColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPH() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pH", this);
        }

        public FloatColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPressure() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pressure", this);
        }

        public FloatColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPressureEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pressure_esd", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeeding() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seeding", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeedingRef() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seeding_ref", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTempDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "temp_details", this);
        }

        public FloatColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTempEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temp_esd", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTime() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_details", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPHRange() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pH_range", this);
        }

        public FloatColumnBuilder<ExptlCrystalGrowBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemp() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temp", this);
        }

    }

    public static class ExptlCrystalGrowCompBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "exptl_crystal_grow_comp";

        public ExptlCrystalGrowCompBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConc() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sol_id", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolume() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "volume", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxConcFinal() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_conc_final", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBath() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_bath", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSalt() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_salt", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSoakSalt() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_soak_salt", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSoakSolv() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_soak_solv", this);
        }

        public StrColumnBuilder<ExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSolv() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_solv", this);
        }

    }

    public static class GeomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "geom";

        public GeomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<GeomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<GeomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class GeomAngleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "geom_angle";

        public GeomAngleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_1", this);
        }

        public IntColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_2", this);
        }

        public IntColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_3", this);
        }

        public IntColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId3() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_3", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPublFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "publ_flag", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_3", this);
        }

        public FloatColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public FloatColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_esd", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_2", this);
        }

        public StrColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_3", this);
        }

        public IntColumnBuilder<GeomAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_model_num", this);
        }

    }

    public static class GeomBondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "geom_bond";

        public GeomBondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_1", this);
        }

        public IntColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_2", this);
        }

        public IntColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_2", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_2", this);
        }

        public FloatColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist", this);
        }

        public FloatColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_esd", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPublFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "publ_flag", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public IntColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValence() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "valence", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_2", this);
        }

        public IntColumnBuilder<GeomBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_model_num", this);
        }

    }

    public static class GeomContactBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "geom_contact";

        public GeomContactBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_1", this);
        }

        public IntColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_2", this);
        }

        public IntColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_2", this);
        }

        public FloatColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist", this);
        }

        public FloatColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_esd", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPublFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "publ_flag", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_2", this);
        }

        public IntColumnBuilder<GeomContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_model_num", this);
        }

    }

    public static class GeomHbondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "geom_hbond";

        public GeomHbondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleDHA() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_DHA", this);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleDHAEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_DHA_esd", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_A", this);
        }

        public IntColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqIdA() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_D", this);
        }

        public IntColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqIdD() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_H", this);
        }

        public IntColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqIdH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqIdA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqIdD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_H", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqIdH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_H", this);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistDA() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_DA", this);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistDAEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_DA_esd", this);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistDH() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_DH", this);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistDHEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_DH_esd", this);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistHA() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_HA", this);
        }

        public FloatColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistHAEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist_HA_esd", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPublFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "publ_flag", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetryA() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_A", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetryD() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_D", this);
        }

        public StrColumnBuilder<GeomHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetryH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_H", this);
        }

    }

    public static class GeomTorsionBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "geom_torsion";

        public GeomTorsionBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_1", this);
        }

        public IntColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_2", this);
        }

        public IntColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_3", this);
        }

        public IntColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId3() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAltId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_alt_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAtomId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_atom_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelCompId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_comp_id_4", this);
        }

        public IntColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelSeqId4() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_seq_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteLabelAsymId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_label_asym_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAtomId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_atom_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthAsymId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_asym_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthCompId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_comp_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomSiteAuthSeqId4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_site_auth_seq_id_4", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPublFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "publ_flag", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_4", this);
        }

        public FloatColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public FloatColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_esd", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_2", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_3", this);
        }

        public StrColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomSitePDBInsCode4() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_site_PDB_ins_code_4", this);
        }

        public IntColumnBuilder<GeomTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_model_num", this);
        }

    }

    public static class JournalBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "journal";

        public JournalBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodenASTM() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coden_ASTM", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCodenCambridge() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coden_Cambridge", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoeditorAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coeditor_address", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoeditorCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coeditor_code", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoeditorEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coeditor_email", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoeditorFax() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coeditor_fax", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoeditorName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coeditor_name", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoeditorNotes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coeditor_notes", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoeditorPhone() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coeditor_phone", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataValidationNumber() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_validation_number", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateAccepted() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_accepted", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateFromCoeditor() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_from_coeditor", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateToCoeditor() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_to_coeditor", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDatePrintersFinal() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_printers_final", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDatePrintersFirst() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_printers_first", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateProofsIn() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_proofs_in", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateProofsOut() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_proofs_out", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateRecdCopyright() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_recd_copyright", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateRecdElectronic() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_recd_electronic", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateRecdHardCopy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_recd_hard_copy", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIssue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "issue", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLanguage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "language", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameFull() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_full", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPageFirst() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "page_first", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPageLast() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "page_last", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPaperCategory() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "paper_category", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSupplPublNumber() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "suppl_publ_number", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSupplPublPages() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "suppl_publ_pages", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTecheditorAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "techeditor_address", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTecheditorCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "techeditor_code", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTecheditorEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "techeditor_email", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTecheditorFax() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "techeditor_fax", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTecheditorName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "techeditor_name", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTecheditorNotes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "techeditor_notes", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTecheditorPhone() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "techeditor_phone", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolume() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "volume", this);
        }

        public StrColumnBuilder<JournalBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterYear() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "year", this);
        }

    }

    public static class JournalIndexBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "journal_index";

        public JournalIndexBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<JournalIndexBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSubterm() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "subterm", this);
        }

        public StrColumnBuilder<JournalIndexBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTerm() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "term", this);
        }

        public StrColumnBuilder<JournalIndexBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class PhasingBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing";

        public PhasingBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

    }

    public static class PhasingAveragingBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_averaging";

        public PhasingAveragingBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingAveragingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PhasingAveragingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PhasingAveragingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

    }

    public static class PhasingIsomorphousBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_isomorphous";

        public PhasingIsomorphousBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingIsomorphousBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PhasingIsomorphousBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PhasingIsomorphousBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PhasingIsomorphousBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterParent() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "parent", this);
        }

    }

    public static class PhasingMADBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MAD";

        public PhasingMADBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_low", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_high", this);
        }

        public IntColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_reflns_acentric", this);
        }

        public IntColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_reflns_centric", this);
        }

        public IntColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_reflns", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom_acentric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom_centric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullisCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis_centric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullisAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_centric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKraut() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_centric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_acentric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLoc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPowerCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power_centric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPowerAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power_acentric", this);
        }

        public FloatColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power", this);
        }

        public IntColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberDataSets() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_data_sets", this);
        }

        public StrColumnBuilder<PhasingMADBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnomScatMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_anom_scat_method", this);
        }

    }

    public static class PhasingMADClustBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MAD_clust";

        public PhasingMADClustBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingMADClustBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "expt_id", this);
        }

        public StrColumnBuilder<PhasingMADClustBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PhasingMADClustBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberSet() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_set", this);
        }

    }

    public static class PhasingMADExptBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MAD_expt";

        public PhasingMADExptBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeltaDeltaPhi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta_delta_phi", this);
        }

        public FloatColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeltaPhi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta_phi", this);
        }

        public FloatColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeltaPhiSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta_phi_sigma", this);
        }

        public StrColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_fom", this);
        }

        public IntColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberClust() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_clust", this);
        }

        public FloatColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRNormalAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_normal_all", this);
        }

        public FloatColumnBuilder<PhasingMADExptBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRNormalAnomScat() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_normal_anom_scat", this);
        }

    }

    public static class PhasingMADRatioBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MAD_ratio";

        public PhasingMADRatioBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public StrColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "expt_id", this);
        }

        public StrColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClustId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "clust_id", this);
        }

        public FloatColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRatioOneWl() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ratio_one_wl", this);
        }

        public FloatColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRatioOneWlCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ratio_one_wl_centric", this);
        }

        public FloatColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRatioTwoWl() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ratio_two_wl", this);
        }

        public FloatColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelength1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wavelength_1", this);
        }

        public FloatColumnBuilder<PhasingMADRatioBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelength2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wavelength_2", this);
        }

    }

    public static class PhasingMADSetBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MAD_set";

        public PhasingMADSetBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClustId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "clust_id", this);
        }

        public FloatColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public StrColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "expt_id", this);
        }

        public FloatColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFDoublePrime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "f_double_prime", this);
        }

        public FloatColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFPrime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "f_prime", this);
        }

        public StrColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "set_id", this);
        }

        public FloatColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelength() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wavelength", this);
        }

        public StrColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelengthDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "wavelength_details", this);
        }

        public StrColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAtomType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_atom_type", this);
        }

        public FloatColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFPrimeRefined() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_f_prime_refined", this);
        }

        public FloatColumnBuilder<PhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFDoublePrimeRefined() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_f_double_prime_refined", this);
        }

    }

    public static class PhasingMIRBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MIR";

        public PhasingMIRBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public StrColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFOM() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "FOM", this);
        }

        public FloatColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFOMAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "FOM_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFOMCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "FOM_centric", this);
        }

        public StrColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public IntColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public IntColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public StrColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCriterion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reflns_criterion", this);
        }

        public IntColumnBuilder<PhasingMIRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberDerivatives() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_derivatives", this);
        }

    }

    public static class PhasingMIRDerBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MIR_der";

        public PhasingMIRDerBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public StrColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDerSetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "der_set_id", this);
        }

        public StrColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNativeSetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "native_set_id", this);
        }

        public IntColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberOfSites() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_of_sites", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_anomalous", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_centric", this);
        }

        public IntColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAnomalous() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_anomalous", this);
        }

        public IntColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public StrColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCriteria() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reflns_criteria", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKraut() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLoc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power", this);
        }

        public FloatColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis", this);
        }

        public IntColumnBuilder<PhasingMIRDerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_reflns", this);
        }

    }

    public static class PhasingMIRDerReflnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MIR_der_refln";

        public PhasingMIRDerReflnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDerId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "der_id", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_calc", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFCalcAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_calc_au", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_au", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_sigma", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasSigmaAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_sigma_au", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHLAIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "HL_A_iso", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHLBIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "HL_B_iso", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHLCIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "HL_C_iso", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHLDIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "HL_D_iso", this);
        }

        public IntColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

        public FloatColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhaseCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "phase_calc", this);
        }

        public StrColumnBuilder<PhasingMIRDerReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "set_id", this);
        }

    }

    public static class PhasingMIRDerShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MIR_der_shell";

        public PhasingMIRDerShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public StrColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDerId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "der_id", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHaAmpl() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ha_ampl", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLoc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhase() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "phase", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKraut() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut", this);
        }

        public IntColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullisCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullisAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPowerCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPowerAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fom_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReflnsCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_reflns_centric", this);
        }

        public IntColumnBuilder<PhasingMIRDerShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_reflns_acentric", this);
        }

    }

    public static class PhasingMIRDerSiteBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MIR_der_site";

        public PhasingMIRDerSiteBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomTypeSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_type_symbol", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_esd", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnXEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_x_esd", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnYEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_y_esd", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnZEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_z_esd", this);
        }

        public StrColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDerId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "der_id", this);
        }

        public StrColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_x", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractXEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_x_esd", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_y", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractYEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_y_esd", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_z", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractZEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_z_esd", this);
        }

        public StrColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyAnom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_anom", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyAnomSu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_anom_su", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_iso", this);
        }

        public FloatColumnBuilder<PhasingMIRDerSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyIsoSu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_iso_su", this);
        }

    }

    public static class PhasingMIRShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_MIR_shell";

        public PhasingMIRShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFOM() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "FOM", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFOMAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "FOM_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFOMCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "FOM_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLoc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanPhase() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_phase", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKraut() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut", this);
        }

        public IntColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public IntColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAnomalous() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_anomalous", this);
        }

        public IntColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLocAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_loc_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPowerCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPowerAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_power_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRKrautAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullisCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis_centric", this);
        }

        public FloatColumnBuilder<PhasingMIRShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRCullisAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_cullis_acentric", this);
        }

    }

    public static class PhasingSetBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_set";

        public PhasingSetBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellAngleAlpha() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cell_angle_alpha", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellAngleBeta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cell_angle_beta", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellAngleGamma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cell_angle_gamma", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellLengthA() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cell_length_a", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellLengthB() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cell_length_b", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellLengthC() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cell_length_c", this);
        }

        public StrColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetectorSpecific() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "detector_specific", this);
        }

        public StrColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetectorType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "detector_type", this);
        }

        public StrColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRadiationSourceSpecific() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "radiation_source_specific", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRadiationWavelength() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "radiation_wavelength", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemp() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temp", this);
        }

        public StrColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTempDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_temp_details", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_high", this);
        }

        public FloatColumnBuilder<PhasingSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_low", this);
        }

    }

    public static class PhasingSetReflnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "phasing_set_refln";

        public PhasingSetReflnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "set_id", this);
        }

        public FloatColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas", this);
        }

        public FloatColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_au", this);
        }

        public FloatColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_sigma", this);
        }

        public FloatColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasSigmaAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_sigma_au", this);
        }

        public IntColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<PhasingSetReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

    }

    public static class PublBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "publ";

        public PublBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthor() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthorAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author_address", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthorEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author_email", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthorFax() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author_fax", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthorName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author_name", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthorPhone() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author_phone", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactLetter() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_letter", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterManuscriptCreation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "manuscript_creation", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterManuscriptProcessed() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "manuscript_processed", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterManuscriptText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "manuscript_text", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRequestedCategory() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "requested_category", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRequestedCoeditorName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "requested_coeditor_name", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRequestedJournal() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "requested_journal", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionAbstract() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_abstract", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionAcknowledgements() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_acknowledgements", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionComment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_comment", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionDiscussion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_discussion", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionExperimental() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_experimental", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionExptlPrep() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_exptl_prep", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionExptlRefinement() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_exptl_refinement", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionExptlSolution() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_exptl_solution", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionFigureCaptions() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_figure_captions", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionIntroduction() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_introduction", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionReferences() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_references", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionSynopsis() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_synopsis", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionTableLegends() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_table_legends", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionTitle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_title", this);
        }

        public StrColumnBuilder<PublBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSectionTitleFootnote() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "section_title_footnote", this);
        }

    }

    public static class PublAuthorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "publ_author";

        public PublAuthorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PublAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "address", this);
        }

        public StrColumnBuilder<PublAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "email", this);
        }

        public StrColumnBuilder<PublAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFootnote() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "footnote", this);
        }

        public StrColumnBuilder<PublAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PublAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIdIucr() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id_iucr", this);
        }

    }

    public static class PublBodyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "publ_body";

        public PublBodyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PublBodyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContents() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contents", this);
        }

        public StrColumnBuilder<PublBodyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterElement() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "element", this);
        }

        public StrColumnBuilder<PublBodyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormat() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "format", this);
        }

        public StrColumnBuilder<PublBodyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PublBodyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTitle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "title", this);
        }

    }

    public static class PublManuscriptInclBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "publ_manuscript_incl";

        public PublManuscriptInclBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PublManuscriptInclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PublManuscriptInclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExtraDefn() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "extra_defn", this);
        }

        public StrColumnBuilder<PublManuscriptInclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExtraInfo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "extra_info", this);
        }

        public StrColumnBuilder<PublManuscriptInclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExtraItem() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "extra_item", this);
        }

    }

    public static class RefineBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine";

        public RefineBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][1]", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][2]", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[1][3]", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[2][2]", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[2][3]", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnisoB33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "aniso_B[3][3]", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_max", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoMean() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_mean", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_min", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffFoToFc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_Fo_to_Fc", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffFoToFcFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_Fo_to_Fc_free", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffDensityMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diff_density_max", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffDensityMaxEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diff_density_max_esd", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffDensityMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diff_density_min", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffDensityMinEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diff_density_min_esd", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffDensityRms() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diff_density_rms", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffDensityRmsEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "diff_density_rms_esd", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsAbsStructureDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_abs_structure_details", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsAbsStructureFlack() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_abs_structure_Flack", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsAbsStructureFlackEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_abs_structure_Flack_esd", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsAbsStructureRogers() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_abs_structure_Rogers", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsAbsStructureRogersEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_abs_structure_Rogers_esd", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_d_res_high", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_d_res_low", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsExtinctionCoef() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_extinction_coef", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsExtinctionCoefEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_extinction_coef_esd", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsExtinctionExpression() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_extinction_expression", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsExtinctionMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_extinction_method", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsGoodnessOfFitAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_goodness_of_fit_all", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsGoodnessOfFitAllEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_goodness_of_fit_all_esd", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsGoodnessOfFitObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_goodness_of_fit_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsGoodnessOfFitObsEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_goodness_of_fit_obs_esd", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsHydrogenTreatment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_hydrogen_treatment", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsMatrixType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_matrix_type", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsNumberConstraints() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ls_number_constraints", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsNumberParameters() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ls_number_parameters", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsNumberReflnsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ls_number_reflns_all", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsNumberReflnsObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ls_number_reflns_obs", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsNumberReflnsRFree() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ls_number_reflns_R_free", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsNumberReflnsRWork() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ls_number_reflns_R_work", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsNumberRestraints() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ls_number_restraints", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsPercentReflnsObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_percent_reflns_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsPercentReflnsRFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_percent_reflns_R_free", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_factor_all", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFactorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_factor_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFactorRFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_factor_R_free", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFactorRFreeError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_factor_R_free_error", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFactorRFreeErrorDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_factor_R_free_error_details", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFactorRWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_factor_R_work", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFsqdFactorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_Fsqd_factor_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRIFactorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_I_factor_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRedundancyReflnsAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_redundancy_reflns_all", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRedundancyReflnsObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_redundancy_reflns_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRestrainedSAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_restrained_S_all", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRestrainedSObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_restrained_S_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsShiftOverEsdMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_shift_over_esd_max", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsShiftOverEsdMean() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_shift_over_esd_mean", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsStructureFactorCoef() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_structure_factor_coef", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsWeightingDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_weighting_details", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsWeightingScheme() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ls_weighting_scheme", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsWRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_wR_factor_all", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsWRFactorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_wR_factor_obs", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsWRFactorRFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_wR_factor_R_free", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsWRFactorRWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_wR_factor_R_work", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_max", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_min", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolventModelDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solvent_model_details", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolventModelParamBsol() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "solvent_model_param_bsol", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolventModelParamKsol() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "solvent_model_param_ksol", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffIToFcsqdWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_I_to_Fcsqd_work", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffIToFcsqdFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_I_to_Fcsqd_free", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRComplete() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_complete", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsRFactorGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_R_factor_gt", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsGoodnessOfFitGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_goodness_of_fit_gt", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsGoodnessOfFitRef() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_goodness_of_fit_ref", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsShiftOverSuMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_shift_over_su_max", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsShiftOverSuMaxLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_shift_over_su_max_lt", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsShiftOverSuMean() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_shift_over_su_mean", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLsShiftOverSuMeanLt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ls_shift_over_su_mean_lt", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLsSigmaI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ls_sigma_I", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLsSigmaF() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ls_sigma_F", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLsSigmaFsqd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ls_sigma_Fsqd", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDataCutoffHighAbsF() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_data_cutoff_high_absF", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDataCutoffHighRmsAbsF() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_data_cutoff_high_rms_absF", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDataCutoffLowAbsF() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_data_cutoff_low_absF", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxIsotropicThermalModel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_isotropic_thermal_model", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLsCrossValidMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ls_cross_valid_method", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMethodToDetermineStruct() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_method_to_determine_struct", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStartingModel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_starting_model", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStereochemistryTargetValues() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_stereochemistry_target_values", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRFreeSelectionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_Free_selection_details", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStereochemTargetValSpecCase() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_stereochem_target_val_spec_case", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallESUR() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_ESU_R", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallESURFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_ESU_R_Free", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSolventVdwProbeRadii() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_solvent_vdw_probe_radii", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSolventIonProbeRadii() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_solvent_ion_probe_radii", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSolventShrinkageRadii() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_solvent_shrinkage_radii", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRealSpaceR() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_real_space_R", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDensityCorrelation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_density_correlation", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdNumberOfPowderPatterns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_number_of_powder_patterns", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdNumberOfPoints() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_number_of_points", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdMeasNumberOfPoints() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_meas_number_of_points", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdProcLsProfRFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_proc_ls_prof_R_factor", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdProcLsProfWRFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_proc_ls_prof_wR_factor", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdMarquardtCorrelationCoeff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_Marquardt_correlation_coeff", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdFsqrdRFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_Fsqrd_R_factor", this);
        }

        public IntColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdLsMatrixBandWidth() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pd_ls_matrix_band_width", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallPhaseError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_phase_error", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallSURFreeCruickshankDPI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_SU_R_free_Cruickshank_DPI", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallSURFreeBlowDPI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_SU_R_free_Blow_DPI", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallSURBlowDPI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_SU_R_Blow_DPI", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTLSResidualADPFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_TLS_residual_ADP_flag", this);
        }

        public StrColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_diffrn_id", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOverallSUB() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "overall_SU_B", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOverallSUML() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "overall_SU_ML", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOverallSURCruickshankDPI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "overall_SU_R_Cruickshank_DPI", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOverallSURFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "overall_SU_R_free", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOverallFOMFreeRSet() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "overall_FOM_free_R_set", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOverallFOMWorkRSet() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "overall_FOM_work_R_set", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAverageFscOverall() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_average_fsc_overall", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAverageFscWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_average_fsc_work", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAverageFscFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_average_fsc_free", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallESUB() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_ESU_B", this);
        }

        public FloatColumnBuilder<RefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOverallESUML() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_overall_ESU_ML", this);
        }

    }

    public static class RefineAnalyzeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_analyze";

        public RefineAnalyzeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiCoordinateErrorFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_coordinate_error_free", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiCoordinateErrorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_coordinate_error_obs", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiDResLowFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_d_res_low_free", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiDResLowObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_d_res_low_obs", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiSigmaAFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_sigma_a_free", this);
        }

        public StrColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiSigmaAFreeDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_sigma_a_free_details", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiSigmaAObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_sigma_a_obs", this);
        }

        public StrColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLuzzatiSigmaAObsDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "Luzzati_sigma_a_obs_details", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberDisorderedResidues() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "number_disordered_residues", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancySumHydrogen() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_sum_hydrogen", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancySumNonHydrogen() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_sum_non_hydrogen", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRGDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RG_d_res_high", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRGDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RG_d_res_low", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRGFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RG_free", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRGWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RG_work", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRGFreeWorkRatio() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RG_free_work_ratio", this);
        }

        public FloatColumnBuilder<RefineAnalyzeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLuzzatiDResHighObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Luzzati_d_res_high_obs", this);
        }

    }

    public static class RefineBIsoBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_B_iso";

        public RefineBIsoBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClazz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTreatment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "treatment", this);
        }

        public FloatColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxResidueName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_residue_name", this);
        }

        public StrColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStrand() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_strand", this);
        }

        public StrColumnBuilder<RefineBIsoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxResidueNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_residue_num", this);
        }

    }

    public static class RefineFunctMinimizedBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_funct_minimized";

        public RefineFunctMinimizedBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineFunctMinimizedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public IntColumnBuilder<RefineFunctMinimizedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberTerms() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_terms", this);
        }

        public FloatColumnBuilder<RefineFunctMinimizedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterResidual() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "residual", this);
        }

        public StrColumnBuilder<RefineFunctMinimizedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public FloatColumnBuilder<RefineFunctMinimizedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "weight", this);
        }

    }

    public static class RefineHistBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_hist";

        public RefineHistBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCycleId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "cycle_id", this);
        }

        public StrColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsSolvent() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_solvent", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAtomsTotal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_atoms_total", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_all", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_obs", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsRFree() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_R_free", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsRWork() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_R_work", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_all", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_obs", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorRFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_R_free", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorRWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_R_work", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberResiduesTotal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_residues_total", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBIsoMeanLigand() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_B_iso_mean_ligand", this);
        }

        public FloatColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBIsoMeanSolvent() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_B_iso_mean_solvent", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAtomsProtein() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_atoms_protein", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAtomsNucleicAcid() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_atoms_nucleic_acid", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAtomsLigand() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_atoms_ligand", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAtomsLipid() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_atoms_lipid", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAtomsCarb() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_atoms_carb", this);
        }

        public StrColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPseudoAtomDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pseudo_atom_details", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAtomsSolvent() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_atoms_solvent", this);
        }

        public IntColumnBuilder<RefineHistBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAtomsTotal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_atoms_total", this);
        }

    }

    public static class RefineLsRestrBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_ls_restr";

        public RefineLsRestrBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCriterion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "criterion", this);
        }

        public FloatColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDevIdeal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dev_ideal", this);
        }

        public FloatColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDevIdealTarget() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dev_ideal_target", this);
        }

        public IntColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number", this);
        }

        public IntColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRejects() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "rejects", this);
        }

        public StrColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public FloatColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "weight", this);
        }

        public StrColumnBuilder<RefineLsRestrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRestraintFunction() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_restraint_function", this);
        }

    }

    public static class RefineLsRestrNcsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_ls_restr_ncs";

        public RefineLsRestrNcsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dom_id", this);
        }

        public StrColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNcsModelDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ncs_model_details", this);
        }

        public FloatColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmsDevBIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rms_dev_B_iso", this);
        }

        public FloatColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmsDevPosition() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rms_dev_position", this);
        }

        public FloatColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWeightBIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "weight_B_iso", this);
        }

        public FloatColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWeightPosition() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "weight_position", this);
        }

        public IntColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

        public StrColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_type", this);
        }

        public StrColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_asym_id", this);
        }

        public StrColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_asym_id", this);
        }

        public IntColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number", this);
        }

        public FloatColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRms() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_rms", this);
        }

        public FloatColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_weight", this);
        }

        public StrColumnBuilder<RefineLsRestrNcsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEnsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ens_id", this);
        }

    }

    public static class RefineLsRestrTypeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_ls_restr_type";

        public RefineLsRestrTypeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<RefineLsRestrTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistanceCutoffHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "distance_cutoff_high", this);
        }

        public FloatColumnBuilder<RefineLsRestrTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistanceCutoffLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "distance_cutoff_low", this);
        }

        public StrColumnBuilder<RefineLsRestrTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class RefineLsShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_ls_shell";

        public RefineLsShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public IntColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_all", this);
        }

        public IntColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_obs", this);
        }

        public IntColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsRFree() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_R_free", this);
        }

        public IntColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsRWork() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_R_work", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPercentReflnsObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "percent_reflns_obs", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPercentReflnsRFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "percent_reflns_R_free", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_all", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_obs", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorRFreeError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_R_free_error", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorRWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_R_work", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRedundancyReflnsAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "redundancy_reflns_all", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRedundancyReflnsObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "redundancy_reflns_obs", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wR_factor_all", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWRFactorObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wR_factor_obs", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWRFactorRFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wR_factor_R_free", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWRFactorRWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wR_factor_R_work", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRComplete() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_complete", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffFoToFc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_Fo_to_Fc", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffFoToFcFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_Fo_to_Fc_free", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffIToFcsqdWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_I_to_Fcsqd_work", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffIToFcsqdFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_I_to_Fcsqd_free", this);
        }

        public IntColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTotalNumberOfBinsUsed() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_total_number_of_bins_used", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPhaseError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_phase_error", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFscWork() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fsc_work", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFscFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fsc_free", this);
        }

        public FloatColumnBuilder<RefineLsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorRFree() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_R_free", this);
        }

    }

    public static class RefineOccupancyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_occupancy";

        public RefineOccupancyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineOccupancyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<RefineOccupancyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClazz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<RefineOccupancyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<RefineOccupancyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTreatment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "treatment", this);
        }

        public FloatColumnBuilder<RefineOccupancyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

    }

    public static class ReflnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refln";

        public ReflnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterACalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "A_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterACalcAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "A_calc_au", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "A_meas", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAMeasAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "A_meas_au", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBCalcAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_calc_au", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_meas", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBMeasAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_meas_au", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFCalcAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_calc_au", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_au", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFMeasSigmaAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_meas_sigma_au", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFSquaredCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_squared_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFSquaredMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_squared_meas", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFSquaredSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "F_squared_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom", this);
        }

        public IntColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntensityCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "intensity_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntensityMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "intensity_meas", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntensitySigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "intensity_sigma", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhaseCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "phase_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhaseMeas() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "phase_meas", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefinementStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "refinement_status", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScaleGroupCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scale_group_code", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSintOverLambda() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sint_over_lambda", this);
        }

        public IntColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmetryEpsilon() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "symmetry_epsilon", this);
        }

        public IntColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmetryMultiplicity() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "symmetry_multiplicity", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelength() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wavelength", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWavelengthId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "wavelength_id", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClassCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class_code", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDSpacing() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_spacing", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIncludeStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "include_status", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanPathLengthTbar() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_path_length_tbar", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFCalcPartSolvent() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_F_calc_part_solvent", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPhaseCalcPartSolvent() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_phase_calc_part_solvent", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFCalcWithSolvent() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_F_calc_with_solvent", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPhaseCalcWithSolvent() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_phase_calc_with_solvent", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnomDifference() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_anom_difference", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnomDifferenceSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_anom_difference_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxIPlus() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_I_plus", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxIMinus() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_I_minus", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFPlus() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_F_plus", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFMinus() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_F_minus", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxIPlusSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_I_plus_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxIMinusSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_I_minus_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFMinusSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_F_minus_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFPlusSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_F_plus_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxHLAIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_HL_A_iso", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxHLBIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_HL_B_iso", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxHLCIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_HL_C_iso", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxHLDIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_HL_D_iso", this);
        }

        public IntColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFiberLayer() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fiber_layer", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFiberCoordinate() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fiber_coordinate", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFiberFMeasAu() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fiber_F_meas_au", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFWT() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_FWT", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPHWT() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PHWT", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDELFWT() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_DELFWT", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDELPHWT() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_DELPHWT", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_diffrn_id", this);
        }

        public IntColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRFreeFlag() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_r_free_flag", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnomalousDiff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_anomalous_diff", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnomalousDiffSigma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_anomalous_diff_sigma", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPhaseCycle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_phase_cycle", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCosPhaseCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_cos_phase_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSinPhaseCalc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_sin_phase_calc", this);
        }

        public FloatColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSignal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_signal", this);
        }

        public StrColumnBuilder<ReflnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSignalStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_signal_status", this);
        }

    }

    public static class ReflnSysAbsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refln_sys_abs";

        public ReflnSysAbsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<ReflnSysAbsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "I", this);
        }

        public FloatColumnBuilder<ReflnSysAbsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIOverSigmaI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "I_over_sigmaI", this);
        }

        public IntColumnBuilder<ReflnSysAbsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexH() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_h", this);
        }

        public IntColumnBuilder<ReflnSysAbsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexK() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_k", this);
        }

        public IntColumnBuilder<ReflnSysAbsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndexL() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "index_l", this);
        }

        public FloatColumnBuilder<ReflnSysAbsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSigmaI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sigmaI", this);
        }

    }

    public static class ReflnsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "reflns";

        public ReflnsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoWilsonEstimate() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_Wilson_estimate", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataReductionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_reduction_details", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataReductionMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_reduction_method", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResolutionHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_resolution_high", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResolutionLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_resolution_low", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitHMax() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_h_max", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitHMin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_h_min", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitKMax() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_k_max", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitKMin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_k_min", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitLMax() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_l_max", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLimitLMin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "limit_l_min", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_all", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_obs", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObservedCriterion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "observed_criterion", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObservedCriterionFMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "observed_criterion_F_max", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObservedCriterionFMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "observed_criterion_F_min", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObservedCriterionIMax() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "observed_criterion_I_max", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObservedCriterionIMin() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "observed_criterion_I_min", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObservedCriterionSigmaF() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "observed_criterion_sigma_F", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObservedCriterionSigmaI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "observed_criterion_sigma_I", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPercentPossibleObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "percent_possible_obs", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFreeDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "R_free_details", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeFAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_F_all", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeFObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_F_obs", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFriedelCoverage() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Friedel_coverage", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberGt() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_gt", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterThresholdExpression() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "threshold_expression", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRedundancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_redundancy", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNetIOverAvSigmaI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_netI_over_av_sigmaI", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNetIOverSigmaI() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_netI_over_sigmaI", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxResNetIOverAvSigmaI2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_res_netI_over_av_sigmaI_2", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxResNetIOverSigmaI2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_res_netI_over_sigmaI_2", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxChiSquared() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_chi_squared", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxScalingRejects() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_scaling_rejects", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResHighOpt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_high_opt", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResLowOpt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_low_opt", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDResOptMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_res_opt_method", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhaseCalculationDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "phase_calculation_details", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRrimIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rrim_I_all", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRpimIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rpim_I_all", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDOpt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_d_opt", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberMeasuredAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_measured_all", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_diffrn_id", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCCHalf() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CC_half", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCCStar() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CC_star", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRSplit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_split", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRedundancyReflnsObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_redundancy_reflns_obs", this);
        }

        public IntColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAnomalous() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRrimIAllAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rrim_I_all_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRpimIAllAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rpim_I_all_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRmergeIAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rmerge_I_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRmergeIObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rmerge_I_obs", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRmergeIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rmerge_I_all", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRsymValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rsym_value", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis1Ortho1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_1_ortho[1]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis1Ortho2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_1_ortho[2]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis1Ortho3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_1_ortho[3]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis2Ortho1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_2_ortho[1]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis2Ortho2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_2_ortho[2]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis2Ortho3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_2_ortho[3]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis3Ortho1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_3_ortho[1]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis3Ortho2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_3_ortho[2]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimitAxis3Ortho3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_axis_3_ortho[3]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimit1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_1", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimit2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_2", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoDiffractionLimit3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_diffraction_limit_3", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector1Ortho1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_1_ortho[1]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector1Ortho2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_1_ortho[2]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector1Ortho3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_1_ortho[3]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector2Ortho1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_2_ortho[1]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector2Ortho2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_2_ortho[2]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector2Ortho3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_2_ortho[3]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector3Ortho1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_3_ortho[1]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector3Ortho2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_3_ortho[2]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvector3Ortho3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvector_3_ortho[3]", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvalue1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvalue_1", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvalue2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvalue_2", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnisoBTensorEigenvalue3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aniso_B_tensor_eigenvalue_3", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrthogonalizationConvention() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_orthogonalization_convention", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleEllipsoidal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_ellipsoidal", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleSpherical() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_spherical", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleEllipsoidalAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_ellipsoidal_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleSphericalAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_spherical_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRedundancyAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_redundancy_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCCHalfAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CC_half_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAbsDiffOverSigmaAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_absDiff_over_sigma_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxObservedSignalThreshold() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_observed_signal_threshold", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSignalType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_signal_type", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSignalDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_signal_details", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSignalSoftwareId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_signal_software_id", this);
        }

        public StrColumnBuilder<ReflnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCCSplitMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CC_split_method", this);
        }

    }

    public static class ReflnsScaleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "reflns_scale";

        public ReflnsScaleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ReflnsScaleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterGroupCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "group_code", this);
        }

        public FloatColumnBuilder<ReflnsScaleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeasF() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meas_F", this);
        }

        public FloatColumnBuilder<ReflnsScaleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeasFSquared() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meas_F_squared", this);
        }

        public FloatColumnBuilder<ReflnsScaleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeasIntensity() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meas_intensity", this);
        }

    }

    public static class ReflnsShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "reflns_shell";

        public ReflnsShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanIOverSigIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meanI_over_sigI_all", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanIOverSigIObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meanI_over_sigI_obs", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberMeasuredAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_measured_all", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberMeasuredObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_measured_obs", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberPossible() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_possible", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberUniqueAll() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_unique_all", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberUniqueObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_unique_obs", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPercentPossibleObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "percent_possible_obs", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeFAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_F_all", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeFObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_F_obs", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanIOverSigIGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meanI_over_sigI_gt", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanIOverUIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meanI_over_uI_all", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanIOverUIGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "meanI_over_uI_gt", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberMeasuredGt() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_measured_gt", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberUniqueGt() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_unique_gt", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPercentPossibleGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "percent_possible_gt", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeFGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_F_gt", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeIGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_I_gt", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRedundancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_redundancy", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxChiSquared() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_chi_squared", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNetIOverSigmaIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_netI_over_sigmaI_all", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNetIOverSigmaIObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_netI_over_sigmaI_obs", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRrimIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rrim_I_all", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRpimIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rpim_I_all", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRejects() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_rejects", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

        public StrColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_diffrn_id", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCCHalf() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CC_half", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCCStar() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CC_star", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRSplit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_R_split", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRedundancyReflnsObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_redundancy_reflns_obs", this);
        }

        public IntColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumberAnomalous() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_number_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRrimIAllAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rrim_I_all_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRpimIAllAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rpim_I_all_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRmergeIAllAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rmerge_I_all_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPercentPossibleAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "percent_possible_all", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeIAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_I_all", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeIObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_I_obs", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRsymValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_Rsym_value", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleEllipsoidal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_ellipsoidal", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleSpherical() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_spherical", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleEllipsoidalAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_ellipsoidal_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleSphericalAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_spherical_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRedundancyAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_redundancy_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCCHalfAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CC_half_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAbsDiffOverSigmaAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_absDiff_over_sigma_anomalous", this);
        }

        public FloatColumnBuilder<ReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPercentPossibleAnomalous() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_percent_possible_anomalous", this);
        }

    }

    public static class SoftwareBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "software";

        public SoftwareBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "citation_id", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClassification() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "classification", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompilerName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "compiler_name", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompilerVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "compiler_version", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthor() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContactAuthorEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contact_author_email", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDependencies() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dependencies", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHardware() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "hardware", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLanguage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "language", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLocation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "location", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMods() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mods", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOs() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "os", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOsVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "os_version", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "version", this);
        }

        public IntColumnBuilder<SoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

    }

    public static class StructBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct";

        public StructBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTitle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "title", this);
        }

        public FloatColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCenterOfMassX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_center_of_mass_x", this);
        }

        public FloatColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCenterOfMassY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_center_of_mass_y", this);
        }

        public FloatColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCenterOfMassZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_center_of_mass_z", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStructureDeterminationMethodology() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_structure_determination_methodology", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDescriptor() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_descriptor", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_details", this);
        }

        public FloatColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormulaWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formula_weight", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormulaWeightMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formula_weight_method", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModelTypeDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_model_type_details", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxCASPFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_CASP_flag", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_details", this);
        }

        public StrColumnBuilder<StructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxTitleText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_title_text", this);
        }

    }

    public static class StructAsymBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_asym";

        public StructAsymBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxModified() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_modified", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBlankPDBChainidFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_blank_PDB_chainid_flag", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_id", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_alt_id", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_type", this);
        }

        public IntColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrder() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_order", this);
        }

        public StrColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFractionPerAsymUnit() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_fraction_per_asym_unit", this);
        }

        public IntColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMissingNumBeginOfChainNotInSeqres() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_missing_num_begin_of_chain_not_in_seqres", this);
        }

        public IntColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMissingNumEndOfChainNotInSeqres() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_missing_num_end_of_chain_not_in_seqres", this);
        }

        public IntColumnBuilder<StructAsymBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxMissingNumBeginOfChainInSeqres() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_missing_num_begin_of_chain_in_seqres", this);
        }

    }

    public static class StructBiolBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_biol";

        public StructBiolBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructBiolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructBiolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructBiolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxParentBiolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_parent_biol_id", this);
        }

        public FloatColumnBuilder<StructBiolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormulaWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formula_weight", this);
        }

        public StrColumnBuilder<StructBiolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFormulaWeightMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_formula_weight_method", this);
        }

        public StrColumnBuilder<StructBiolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAggregationState() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_aggregation_state", this);
        }

        public StrColumnBuilder<StructBiolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAssemblyMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_assembly_method", this);
        }

    }

    public static class StructBiolGenBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_biol_gen";

        public StructBiolGenBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBiolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "symmetry", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFullSymmetryOperation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_full_symmetry_operation", this);
        }

        public IntColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBOrder() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_order", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNewAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_new_asym_id", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNewPdbAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_new_pdb_asym_id", this);
        }

        public FloatColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxColorRed() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_color_red", this);
        }

        public FloatColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxColorGreen() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_color_green", this);
        }

        public FloatColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxColorBlue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_color_blue", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAfterBeginResidueNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_after_begin_residue_no", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAfterEndResidueNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_after_end_residue_no", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBeforeBeginResidueNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_before_begin_residue_no", this);
        }

        public StrColumnBuilder<StructBiolGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBeforeEndResidueNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_before_end_residue_no", this);
        }

    }

    public static class StructBiolKeywordsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_biol_keywords";

        public StructBiolKeywordsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructBiolKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBiolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<StructBiolKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class StructBiolViewBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_biol_view";

        public StructBiolViewBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBiolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[1][1]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[1][2]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[1][3]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[2][1]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[2][2]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[2][3]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[3][1]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[3][2]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[3][3]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_vector[1]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_vector[2]", this);
        }

        public FloatColumnBuilder<StructBiolViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_vector[3]", this);
        }

    }

    public static class StructConfBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_conf";

        public StructConfBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public IntColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConfTypeId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conf_type_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public IntColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBegPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_beg_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEndPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_end_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBHelixClass() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_helix_class", this);
        }

        public IntColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBHelixLength() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_helix_length", this);
        }

        public StrColumnBuilder<StructConfBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBHelixId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_helix_id", this);
        }

    }

    public static class StructConfTypeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_conf_type";

        public StructConfTypeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructConfTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCriteria() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "criteria", this);
        }

        public StrColumnBuilder<StructConfTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructConfTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReference() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reference", this);
        }

    }

    public static class StructConnBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_conn";

        public StructConnBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConnTypeId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conn_type_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_asym_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_comp_id", this);
        }

        public IntColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_seq_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_asym_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_comp_id", this);
        }

        public IntColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_seq_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1Role() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_role", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1Symmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_symmetry", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_asym_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_comp_id", this);
        }

        public IntColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_seq_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_asym_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_comp_id", this);
        }

        public IntColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_seq_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2Role() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_role", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2Symmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_symmetry", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1AuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_auth_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_label_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1StandardCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_standard_comp_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr2PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr2_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr2AuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr2_auth_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr2LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr2_label_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3AuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_auth_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_auth_asym_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_auth_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_auth_comp_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3AuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_auth_seq_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_label_alt_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_label_asym_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_label_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_label_comp_id", this);
        }

        public IntColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_label_seq_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_id", this);
        }

        public FloatColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDistValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_dist_value", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxValueOrder() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_value_order", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLeavingAtomFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_leaving_atom_flag", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1ModName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_mod_name", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1SugarName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_sugar_name", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1ReplacedAtom() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_replaced_atom", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr3AuthInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr3_auth_ins_code", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1AtomStereoConfig() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_atom_stereo_config", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr1LeavingAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr1_leaving_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr2AtomStereoConfig() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr2_atom_stereo_config", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPtnr2LeavingAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ptnr2_leaving_atom_id", this);
        }

        public StrColumnBuilder<StructConnBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRole() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_role", this);
        }

    }

    public static class StructConnTypeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_conn_type";

        public StructConnTypeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructConnTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCriteria() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "criteria", this);
        }

        public StrColumnBuilder<StructConnTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructConnTypeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReference() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reference", this);
        }

    }

    public static class StructKeywordsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_keywords";

        public StructKeywordsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<StructKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

        public StrColumnBuilder<StructKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxKeywords() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_keywords", this);
        }

        public StrColumnBuilder<StructKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_details", this);
        }

    }

    public static class StructMonDetailsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_mon_details";

        public StructMonDetailsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructMonDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<StructMonDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProtCis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "prot_cis", this);
        }

        public StrColumnBuilder<StructMonDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCC() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "RSCC", this);
        }

        public StrColumnBuilder<StructMonDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSR() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "RSR", this);
        }

    }

    public static class StructMonNuclBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_mon_nucl";

        public StructMonNuclBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAlpha() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "alpha", this);
        }

        public StrColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBeta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "beta", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChi1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi1", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChi2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi2", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDelta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEpsilon() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "epsilon", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterGamma() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "gamma", this);
        }

        public StrColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanBAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_B_all", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanBBase() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_B_base", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanBPhos() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_B_phos", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanBSugar() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_B_sugar", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNu0() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "nu0", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNu1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "nu1", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNu2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "nu2", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNu3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "nu3", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNu4() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "nu4", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterP() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "P", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCCAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSCC_all", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCCBase() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSCC_base", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCCPhos() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSCC_phos", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCCSugar() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSCC_sugar", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSRAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSR_all", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSRBase() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSR_base", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSRPhos() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSR_phos", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSRSugar() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSR_sugar", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTau0() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "tau0", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTau1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "tau1", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTau2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "tau2", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTau3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "tau3", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTau4() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "tau4", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTaum() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "taum", this);
        }

        public FloatColumnBuilder<StructMonNuclBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterZeta() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "zeta", this);
        }

    }

    public static class StructMonProtBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_mon_prot";

        public StructMonProtBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChi1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi1", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChi2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi2", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChi3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi3", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChi4() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi4", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChi5() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi5", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCCAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSCC_all", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCCMain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSCC_main", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSCCSide() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSCC_side", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSRAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSR_all", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSRMain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSR_main", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRSRSide() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "RSR_side", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanBAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_B_all", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanBMain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_B_main", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanBSide() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_B_side", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOmega() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "omega", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "phi", this);
        }

        public FloatColumnBuilder<StructMonProtBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPsi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "psi", this);
        }

    }

    public static class StructMonProtCisBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_mon_prot_cis";

        public StructMonProtCisBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_asym_id_2", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_comp_id_2", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_seq_id_2", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_asym_id_2", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_comp_id_2", this);
        }

        public IntColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxLabelSeqId2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_label_seq_id_2", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_ins_code_2", this);
        }

        public IntColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_model_num", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOmegaAngle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_omega_angle", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_id", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_ins_code", this);
        }

        public StrColumnBuilder<StructMonProtCisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_ins_code_2", this);
        }

    }

    public static class StructNcsDomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ncs_dom";

        public StructNcsDomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructNcsDomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructNcsDomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructNcsDomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEnsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ens_id", this);
        }

    }

    public static class StructNcsDomLimBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ncs_dom_lim";

        public StructNcsDomLimBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_alt_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dom_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_alt_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSelectionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "selection_details", this);
        }

        public IntColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxComponentId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_component_id", this);
        }

        public FloatColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineCode() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_code", this);
        }

        public StrColumnBuilder<StructNcsDomLimBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEnsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ens_id", this);
        }

    }

    public static class StructNcsEnsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ncs_ens";

        public StructNcsEnsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructNcsEnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructNcsEnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructNcsEnsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPointGroup() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "point_group", this);
        }

    }

    public static class StructNcsEnsGenBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ncs_ens_gen";

        public StructNcsEnsGenBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructNcsEnsGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dom_id_1", this);
        }

        public StrColumnBuilder<StructNcsEnsGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dom_id_2", this);
        }

        public StrColumnBuilder<StructNcsEnsGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEnsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ens_id", this);
        }

        public IntColumnBuilder<StructNcsEnsGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOperId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "oper_id", this);
        }

    }

    public static class StructNcsOperBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ncs_oper";

        public StructNcsOperBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code", this);
        }

        public StrColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][1]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][2]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][3]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][1]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][2]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][3]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][1]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][2]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][3]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[1]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[2]", this);
        }

        public FloatColumnBuilder<StructNcsOperBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[3]", this);
        }

    }

    public static class StructRefBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ref";

        public StructRefBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBiolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqAlign() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seq_align", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqDif() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seq_dif", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDbAccession() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_db_accession", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDbIsoform() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_db_isoform", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqOneLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_one_letter_code", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAlignBegin() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_align_begin", this);
        }

        public StrColumnBuilder<StructRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAlignEnd() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_align_end", this);
        }

    }

    public static class StructRefSeqBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ref_seq";

        public StructRefSeqBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAlignId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "align_id", this);
        }

        public IntColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbAlignBeg() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "db_align_beg", this);
        }

        public IntColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbAlignEnd() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "db_align_end", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_id", this);
        }

        public IntColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqAlignBeg() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "seq_align_beg", this);
        }

        public IntColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqAlignEnd() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "seq_align_end", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_strand_id", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDbAccession() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_db_accession", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDbAlignBegInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_db_align_beg_ins_code", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxDbAlignEndInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_db_align_end_ins_code", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPDBIdCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_PDB_id_code", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthSeqAlignBeg() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_seq_align_beg", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthSeqAlignEnd() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_seq_align_end", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqAlignBegInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_align_beg_ins_code", this);
        }

        public StrColumnBuilder<StructRefSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqAlignEndInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_align_end_ins_code", this);
        }

    }

    public static class StructRefSeqDifBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_ref_seq_dif";

        public StructRefSeqDifBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAlignId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "align_id", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_mon_id", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_id", this);
        }

        public IntColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "seq_num", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdbIdCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pdb_id_code", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdbStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pdb_strand_id", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxPdbInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_pdb_ins_code", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_seq_num", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_db_name", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqDbAccessionCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_db_accession_code", this);
        }

        public StrColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxSeqDbSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_seq_db_seq_num", this);
        }

        public IntColumnBuilder<StructRefSeqDifBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_ordinal", this);
        }

    }

    public static class StructSheetBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_sheet";

        public StructSheetBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructSheetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructSheetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<StructSheetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberStrands() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_strands", this);
        }

        public StrColumnBuilder<StructSheetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class StructSheetHbondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_sheet_hbond";

        public StructSheetHbondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1BegLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_beg_label_atom_id", this);
        }

        public IntColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1BegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "range_1_beg_label_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1EndLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_end_label_atom_id", this);
        }

        public IntColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1EndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "range_1_end_label_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2BegLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_beg_label_atom_id", this);
        }

        public IntColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2BegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "range_2_beg_label_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2EndLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_end_label_atom_id", this);
        }

        public IntColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2EndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "range_2_end_label_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1BegAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_beg_auth_atom_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1BegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_beg_auth_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1EndAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_end_auth_atom_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1EndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_end_auth_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2BegAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_beg_auth_atom_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2BegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_beg_auth_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2EndAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_end_auth_atom_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2EndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_end_auth_seq_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_1", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_2", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSheetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sheet_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1BegAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_beg_auth_comp_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1BegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_beg_auth_asym_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1EndAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_end_auth_comp_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1EndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_end_auth_asym_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1BegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_beg_label_comp_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1BegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_beg_label_asym_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1BegPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_beg_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1EndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_end_label_comp_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1EndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_end_label_asym_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange1EndPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_1_end_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange2BegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_2_beg_label_comp_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange2BegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_2_beg_label_asym_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange2BegPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_2_beg_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange2EndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_2_end_label_comp_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange2EndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_2_end_label_asym_id", this);
        }

        public StrColumnBuilder<StructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRange2EndLabelInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_range_2_end_label_ins_code", this);
        }

    }

    public static class StructSheetOrderBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_sheet_order";

        public StructSheetOrderBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<StructSheetOrderBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOffset() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "offset", this);
        }

        public StrColumnBuilder<StructSheetOrderBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_1", this);
        }

        public StrColumnBuilder<StructSheetOrderBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_2", this);
        }

        public StrColumnBuilder<StructSheetOrderBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSense() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sense", this);
        }

        public StrColumnBuilder<StructSheetOrderBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSheetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sheet_id", this);
        }

    }

    public static class StructSheetRangeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_sheet_range";

        public StructSheetRangeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public IntColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public IntColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSheetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sheet_id", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "symmetry", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxBegPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_beg_PDB_ins_code", this);
        }

        public StrColumnBuilder<StructSheetRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEndPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_end_PDB_ins_code", this);
        }

    }

    public static class StructSheetTopologyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_sheet_topology";

        public StructSheetTopologyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<StructSheetTopologyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOffset() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "offset", this);
        }

        public StrColumnBuilder<StructSheetTopologyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_1", this);
        }

        public StrColumnBuilder<StructSheetTopologyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_2", this);
        }

        public StrColumnBuilder<StructSheetTopologyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSense() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sense", this);
        }

        public StrColumnBuilder<StructSheetTopologyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSheetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sheet_id", this);
        }

    }

    public static class StructSiteBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_site";

        public StructSiteBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumResidues() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_num_residues", this);
        }

        public StrColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxEvidenceCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_evidence_code", this);
        }

        public StrColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_asym_id", this);
        }

        public StrColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_comp_id", this);
        }

        public StrColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_seq_id", this);
        }

        public StrColumnBuilder<StructSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_ins_code", this);
        }

    }

    public static class StructSiteGenBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_site_gen";

        public StructSiteGenBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_id", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "symmetry", this);
        }

        public StrColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAuthInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_auth_ins_code", this);
        }

        public IntColumnBuilder<StructSiteGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxNumRes() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_num_res", this);
        }

    }

    public static class StructSiteKeywordsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_site_keywords";

        public StructSiteKeywordsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructSiteKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_id", this);
        }

        public StrColumnBuilder<StructSiteKeywordsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class StructSiteViewBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "struct_site_view";

        public StructSiteViewBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[1][1]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[1][2]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[1][3]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[2][1]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[2][2]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[2][3]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[3][1]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[3][2]", this);
        }

        public FloatColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rot_matrix[3][3]", this);
        }

        public StrColumnBuilder<StructSiteViewBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_id", this);
        }

    }

    public static class SymmetryBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "symmetry";

        public SymmetryBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<SymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<SymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCellSetting() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "cell_setting", this);
        }

        public IntColumnBuilder<SymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIntTablesNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "Int_Tables_number", this);
        }

        public StrColumnBuilder<SymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpaceGroupNameHall() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "space_group_name_Hall", this);
        }

        public StrColumnBuilder<SymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpaceGroupNameH_M() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "space_group_name_H-M", this);
        }

        public StrColumnBuilder<SymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxFullSpaceGroupNameH_M() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_full_space_group_name_H-M", this);
        }

    }

    public static class SymmetryEquivBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "symmetry_equiv";

        public SymmetryEquivBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<SymmetryEquivBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<SymmetryEquivBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPosAsXyz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pos_as_xyz", this);
        }

    }

    public static class AuditLinkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "audit_link";

        public AuditLinkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<AuditLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBlockCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "block_code", this);
        }

        public StrColumnBuilder<AuditLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBlockDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "block_description", this);
        }

    }

    public static class DiffrnReflnsClassBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "diffrn_reflns_class";

        public DiffrnReflnsClassBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAvREq() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "av_R_eq", this);
        }

        public FloatColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAvSgI_I() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "av_sgI/I", this);
        }

        public FloatColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAvUI_I() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "av_uI/I", this);
        }

        public StrColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code", this);
        }

        public StrColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "description", this);
        }

        public FloatColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public IntColumnBuilder<DiffrnReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number", this);
        }

    }

    public static class RefineLsClassBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "refine_ls_class";

        public RefineLsClassBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code", this);
        }

        public FloatColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_gt", this);
        }

        public FloatColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_all", this);
        }

        public FloatColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFsqdFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_Fsqd_factor", this);
        }

        public FloatColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRIFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_I_factor", this);
        }

        public FloatColumnBuilder<RefineLsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wR_factor_all", this);
        }

    }

    public static class ReflnsClassBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "reflns_class";

        public ReflnsClassBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "code", this);
        }

        public StrColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "description", this);
        }

        public FloatColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public IntColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberGt() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_gt", this);
        }

        public IntColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberTotal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_total", this);
        }

        public FloatColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_all", this);
        }

        public FloatColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorGt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_gt", this);
        }

        public FloatColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFsqdFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_Fsqd_factor", this);
        }

        public FloatColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRIFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_I_factor", this);
        }

        public FloatColumnBuilder<ReflnsClassBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterWRFactorAll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "wR_factor_all", this);
        }

    }

    public static class SpaceGroupBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "space_group";

        public SpaceGroupBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<SpaceGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalSystem() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_system", this);
        }

        public StrColumnBuilder<SpaceGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<SpaceGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterITNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "IT_number", this);
        }

        public StrColumnBuilder<SpaceGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameHall() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_Hall", this);
        }

        public StrColumnBuilder<SpaceGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameH_MAlt() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_H-M_alt", this);
        }

    }

    public static class SpaceGroupSymopBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "space_group_symop";

        public SpaceGroupSymopBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<SpaceGroupSymopBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<SpaceGroupSymopBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOperationXyz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "operation_xyz", this);
        }

        public StrColumnBuilder<SpaceGroupSymopBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSgId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sg_id", this);
        }

    }

    public static class ValenceParamBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "valence_param";

        public ValenceParamBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_1", this);
        }

        public IntColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom1Valence() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_1_valence", this);
        }

        public StrColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_2", this);
        }

        public IntColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtom2Valence() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_2_valence", this);
        }

        public FloatColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterB() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B", this);
        }

        public StrColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_id", this);
        }

        public FloatColumnBuilder<ValenceParamBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRo() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Ro", this);
        }

    }

    public static class ValenceRefBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "valence_ref";

        public ValenceRefBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<ValenceRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<ValenceRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReference() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reference", this);
        }

    }

    public static class PdbxAuditBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit";

        public PdbxAuditBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCurrentVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "current_version", this);
        }

    }

    public static class PdbxVersionBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_version";

        public PdbxVersionBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxVersionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxVersionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRevisionDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "revision_date", this);
        }

        public IntColumnBuilder<PdbxVersionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMajorVersion() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "major_version", this);
        }

        public StrColumnBuilder<PdbxVersionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMinorVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "minor_version", this);
        }

        public StrColumnBuilder<PdbxVersionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxVersionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRevisionType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "revision_type", this);
        }

    }

    public static class PdbxAuditAuthorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_author";

        public PdbxAuditAuthorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxAuditAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "address", this);
        }

        public StrColumnBuilder<PdbxAuditAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<PdbxAuditAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

    }

    public static class PdbxDatabaseMessageBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_message";

        public PdbxDatabaseMessageBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMessageId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "message_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContentType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "content_type", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMessageType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "message_type", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSender() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sender", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSenderAddressFax() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sender_address_fax", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSenderAddressPhone() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sender_address_phone", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSenderAddressEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sender_address_email", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSenderAddressMail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sender_address_mail", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReceiver() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "receiver", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReceiverAddressFax() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "receiver_address_fax", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReceiverAddressPhone() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "receiver_address_phone", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReceiverAddressEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "receiver_address_email", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReceiverAddressMail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "receiver_address_mail", this);
        }

        public StrColumnBuilder<PdbxDatabaseMessageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMessage() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "message", this);
        }

    }

    public static class PdbxDatabasePDBObsSprBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_PDB_obs_spr";

        public PdbxDatabasePDBObsSprBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabasePDBObsSprBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxDatabasePDBObsSprBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxDatabasePDBObsSprBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_id", this);
        }

        public StrColumnBuilder<PdbxDatabasePDBObsSprBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplacePdbId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replace_pdb_id", this);
        }

        public StrColumnBuilder<PdbxDatabasePDBObsSprBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxDatabaseProcBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_proc";

        public PdbxDatabaseProcBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabaseProcBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseProcBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCycleId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "cycle_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseProcBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateBeginCycle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_begin_cycle", this);
        }

        public StrColumnBuilder<PdbxDatabaseProcBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateEndCycle() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_end_cycle", this);
        }

        public StrColumnBuilder<PdbxDatabaseProcBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxDatabaseRemarkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_remark";

        public PdbxDatabaseRemarkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDatabaseRemarkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxDatabaseRemarkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class PdbxDatabaseStatusBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_status";

        public PdbxDatabaseStatusBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatusCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status_code", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthorReleaseStatusCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "author_release_status_code", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatusCodeSf() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status_code_sf", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatusCodeMr() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status_code_mr", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDepReleaseCodeCoordinates() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dep_release_code_coordinates", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDepReleaseCodeSequence() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dep_release_code_sequence", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDepReleaseCodeStructFact() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dep_release_code_struct_fact", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDepReleaseCodeNmrConstraints() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dep_release_code_nmr_constraints", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdDepositForm() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_deposit_form", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateDepositionForm() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_deposition_form", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateBeginDeposition() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_begin_deposition", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateBeginProcessing() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_begin_processing", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateEndProcessing() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_end_processing", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateBeginReleasePreparation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_begin_release_preparation", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateAuthorReleaseRequest() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_author_release_request", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdCoordinates() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_coordinates", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateCoordinates() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_coordinates", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdStructFact() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_struct_fact", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateStructFact() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_struct_fact", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdNmrConstraints() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_nmr_constraints", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateNmrConstraints() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_nmr_constraints", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdInternalApproval() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_internal_approval", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdManuscript() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_manuscript", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateManuscript() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_manuscript", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameDepositor() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_depositor", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdAuthorApproval() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_author_approval", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthorApprovalType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "author_approval_type", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateAuthorApproval() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_author_approval", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdInitialDepositionDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_initial_deposition_date", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateSubmitted() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_submitted", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRcsbAnnotator() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "rcsb_annotator", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateOfSfRelease() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_of_sf_release", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateOfMrRelease() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_of_mr_release", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateOfPDBRelease() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_of_PDB_release", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateHoldCoordinates() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_hold_coordinates", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateHoldStructFact() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_hold_struct_fact", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateHoldNmrConstraints() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_hold_nmr_constraints", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHoldForPublication() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "hold_for_publication", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSGEntry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "SG_entry", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbDateOfAuthorApproval() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_date_of_author_approval", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDepositSite() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "deposit_site", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProcessSite() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "process_site", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDepReleaseCodeChemicalShifts() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dep_release_code_chemical_shifts", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdChemicalShifts() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_chemical_shifts", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateChemicalShifts() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_chemical_shifts", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateHoldChemicalShifts() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_hold_chemical_shifts", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatusCodeCs() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status_code_cs", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateOfCsRelease() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_of_cs_release", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateNmrData() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_nmr_data", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateHoldNmrData() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_hold_nmr_data", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateOfNmrDataRelease() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_of_nmr_data_release", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDepReleaseCodeNmrData() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dep_release_code_nmr_data", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecvdNmrData() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recvd_nmr_data", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatusCodeNmrData() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status_code_nmr_data", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethodsDevelopmentCategory() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "methods_development_category", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbFormatCompatible() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_format_compatible", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPostRelStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "post_rel_status", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPostRelRecvdCoord() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "post_rel_recvd_coord", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPostRelRecvdCoordDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "post_rel_recvd_coord_date", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthReqRelDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_req_rel_date", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNdbTid() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ndb_tid", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStatusCoordinatesInNDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "status_coordinates_in_NDB", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateRevised() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_revised", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplacedEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replaced_entry_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRevisionId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "revision_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRevisionDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "revision_description", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAnnotator() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_annotator", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateOfNDBRelease() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_of_NDB_release", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateReleasedToPDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_released_to_PDB", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSkipPDBREMARK500() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "skip_PDB_REMARK_500", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSkipPDBREMARK() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "skip_PDB_REMARK", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTitleSuppression() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "title_suppression", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDateAcceptedTermsAndConditions() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date_accepted_terms_and_conditions", this);
        }

    }

    public static class PdbxEntityNameBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_name";

        public PdbxEntityNameBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityNameBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityNameBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxEntityNameBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_type", this);
        }

    }

    public static class PdbxPrereleaseSeqBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_prerelease_seq";

        public PdbxPrereleaseSeqBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPrereleaseSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxPrereleaseSeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqOneLetterCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seq_one_letter_code", this);
        }

    }

    public static class PdbxPolySeqSchemeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_poly_seq_scheme";

        public PdbxPolySeqSchemeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "seq_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHetero() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "hetero", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public IntColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNdbSeqNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ndb_seq_num", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_seq_num", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_num", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_mon_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_ins_code", this);
        }

    }

    public static class PdbxNonpolySchemeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nonpoly_scheme";

        public PdbxNonpolySchemeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNdbSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ndb_seq_num", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_seq_num", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_num", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_mon_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_ins_code", this);
        }

    }

    public static class PdbxRefineBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine";

        public PdbxRefineBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorAllNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_all_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorObsNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_obs_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRFactor4sigCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_factor_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRFactorNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_factor_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRErrorNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_error_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRValTestSetSizePercNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_val_test_set_size_perc_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRValTestSetCtNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_val_test_set_ct_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsObsNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_obs_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorAll4sigCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_all_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactorObs4sigCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor_obs_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRVal4sigCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_val_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRValTestSetSizePerc4sigCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_val_test_set_size_perc_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRValTestSetCt4sigCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_val_test_set_ct_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberReflnsObs4sigCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "number_reflns_obs_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFreeRValNoCutoff() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "free_R_val_no_cutoff", this);
        }

    }

    public static class PdbxStructSheetHbondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_sheet_hbond";

        public PdbxStructSheetHbondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_1", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRangeId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_id_2", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSheetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sheet_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_label_atom_id", this);
        }

        public IntColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "range_1_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_label_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1AuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange1PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_1_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_label_atom_id", this);
        }

        public IntColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "range_2_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_label_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2AuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRange2PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "range_2_PDB_ins_code", this);
        }

    }

    public static class PdbxXplorFileBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_xplor_file";

        public PdbxXplorFileBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSerialNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "serial_no", this);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterParamFile() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "param_file", this);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTopolFile() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "topol_file", this);
        }

    }

    public static class PdbxRefineAuxFileBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_aux_file";

        public PdbxRefineAuxFileBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSerialNo() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "serial_no", this);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFileName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "file_name", this);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFileType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "file_type", this);
        }

    }

    public static class PdbxDatabaseRelatedBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_related";

        public PdbxDatabaseRelatedBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContentType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "content_type", this);
        }

    }

    public static class PdbxEntityAssemblyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_assembly";

        public PdbxEntityAssemblyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxEntityAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBiolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "biol_id", this);
        }

        public IntColumnBuilder<PdbxEntityAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumCopies() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "num_copies", this);
        }

    }

    public static class PdbxExptlCrystalGrowCompBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_crystal_grow_comp";

        public PdbxExptlCrystalGrowCompBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_name", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sol_id", this);
        }

        public FloatColumnBuilder<PdbxExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "conc", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcRange() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc_range", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc_units", this);
        }

    }

    public static class PdbxExptlCrystalGrowSolBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_crystal_grow_sol";

        public PdbxExptlCrystalGrowSolBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sol_id", this);
        }

        public FloatColumnBuilder<PdbxExptlCrystalGrowSolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolume() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumeUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "volume_units", this);
        }

        public FloatColumnBuilder<PdbxExptlCrystalGrowSolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPH() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pH", this);
        }

    }

    public static class PdbxExptlCrystalCryoTreatmentBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_crystal_cryo_treatment";

        public PdbxExptlCrystalCryoTreatmentBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFinalSolutionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "final_solution_details", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoakingDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "soaking_details", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoolingDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "cooling_details", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnnealingDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "annealing_details", this);
        }

    }

    public static class PdbxRefineTlsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_tls";

        public PdbxRefineTlsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOriginX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origin_x", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOriginY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origin_y", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOriginZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "origin_z", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[1][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT11Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[1][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[1][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT12Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[1][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[1][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT13Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[1][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[2][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT22Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[2][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[2][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT23Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[2][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[3][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterT33Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "T[3][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[1][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL11Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[1][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[1][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL12Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[1][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[1][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL13Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[1][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[2][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL22Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[2][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[2][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL23Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[2][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[3][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterL33Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "L[3][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[1][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS11Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[1][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[1][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS12Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[1][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[1][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS13Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[1][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[2][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS21Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[2][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[2][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS22Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[2][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[2][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS23Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[2][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[3][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS31Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[3][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[3][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS32Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[3][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[3][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterS33Esd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "S[3][3]_esd", this);
        }

    }

    public static class PdbxRefineTlsGroupBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_tls_group";

        public PdbxRefineTlsGroupBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefineTlsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "refine_tls_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public IntColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public IntColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSelection() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "selection", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSelectionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "selection_details", this);
        }

    }

    public static class PdbxContactAuthorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_contact_author";

        public PdbxContactAuthorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAddress1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "address_1", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAddress2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "address_2", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAddress3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "address_3", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLegacyAddress() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "legacy_address", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCity() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "city", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStateProvince() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "state_province", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPostalCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "postal_code", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEmail() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "email", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFax() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "fax", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameFirst() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_first", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameLast() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_last", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameMi() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_mi", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNameSalutation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name_salutation", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "country", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContinent() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "continent", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhone() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "phone", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRole() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "role", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrganizationType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "organization_type", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIdentifierORCID() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "identifier_ORCID", this);
        }

    }

    public static class PdbxSGProjectBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_SG_project";

        public PdbxSGProjectBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProjectName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "project_name", this);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFullNameOfCenter() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "full_name_of_center", this);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInitialOfCenter() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "initial_of_center", this);
        }

    }

    public static class PdbxAtomSiteAnisoTlsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_atom_site_aniso_tls";

        public PdbxAtomSiteAnisoTlsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_symbol", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTlsGroupId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "tls_group_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUTls11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_tls[1][1]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUTls22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_tls[2][2]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUTls33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_tls[3][3]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUTls12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_tls[1][2]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUTls13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_tls[1][3]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUTls23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "U_tls[2][3]", this);
        }

    }

    public static class PdbxNmrDetailsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_details";

        public PdbxNmrDetailsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class PdbxNmrSampleDetailsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_sample_details";

        public PdbxNmrSampleDetailsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolutionId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solution_id", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterContents() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "contents", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolventSystem() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solvent_system", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxNmrExptlSampleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_exptl_sample";

        public PdbxNmrExptlSampleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolutionId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solution_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterComponent() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "component", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcentration() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "concentration", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcentrationRange() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "concentration_range", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcentrationUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "concentration_units", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIsotopicLabeling() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "isotopic_labeling", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcentrationErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "concentration_err", this);
        }

    }

    public static class PdbxNmrExptlSampleConditionsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_exptl_sample_conditions";

        public PdbxNmrExptlSampleConditionsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConditionsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conditions_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "temperature", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPressureUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pressure_units", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPressure() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pressure", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPH() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pH", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIonicStrength() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ionic_strength", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIonicStrengthErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "ionic_strength_err", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIonicStrengthUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ionic_strength_units", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPHErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pH_err", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPHUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pH_units", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPressureErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pressure_err", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature_err", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperatureUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "temperature_units", this);
        }

    }

    public static class PdbxNmrSpectrometerBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_spectrometer";

        public PdbxNmrSpectrometerBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpectrometerId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "spectrometer_id", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "model", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterManufacturer() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "manufacturer", this);
        }

        public FloatColumnBuilder<PdbxNmrSpectrometerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFieldStrength() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "field_strength", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

    }

    public static class PdbxNmrExptlBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_exptl";

        public PdbxNmrExptlBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExperimentId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConditionsId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conditions_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolutionId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solution_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public IntColumnBuilder<PdbxNmrExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpectrometerId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "spectrometer_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSampleState() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sample_state", this);
        }

    }

    public static class PdbxNmrSoftwareBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_software";

        public PdbxNmrSoftwareBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClassification() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "classification", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "version", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthors() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "authors", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxNmrConstraintsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_constraints";

        public PdbxNmrConstraintsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOEConstraintsTotal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NOE_constraints_total", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOEIntraresidueTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NOE_intraresidue_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOEInterentityTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NOE_interentity_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOESequentialTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NOE_sequential_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOEMediumRangeTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NOE_medium_range_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOELongRangeTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NOE_long_range_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinPhiAngleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "protein_phi_angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinPsiAngleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "protein_psi_angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinChiAngleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "protein_chi_angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinOtherAngleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "protein_other_angle_constraints_total_count", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOEInterprotonDistanceEvaluation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "NOE_interproton_distance_evaluation", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOEPseudoatomCorrections() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "NOE_pseudoatom_corrections", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNOEMotionalAveragingCorrection() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "NOE_motional_averaging_correction", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHydrogenBondConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "hydrogen_bond_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDisulfideBondConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "disulfide_bond_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNAAlpha_angleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_alpha-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNABeta_angleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_beta-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNAGamma_angleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_gamma-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNADelta_angleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_delta-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNAEpsilon_angleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_epsilon-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNAChi_angleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_chi-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNAOther_angleConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_other-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNASugarPuckerConstraintsTotalCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "NA_sugar_pucker_constraints_total_count", this);
        }

    }

    public static class PdbxNmrEnsembleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_ensemble";

        public PdbxNmrEnsembleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConformersCalculatedTotalNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "conformers_calculated_total_number", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConformersSubmittedTotalNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "conformers_submitted_total_number", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConformerSelectionCriteria() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conformer_selection_criteria", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRepresentativeConformer() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "representative_conformer", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAverageConstraintsPerResidue() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "average_constraints_per_residue", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAverageConstraintViolationsPerResidue() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "average_constraint_violations_per_residue", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaximumDistanceConstraintViolation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "maximum_distance_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAverageDistanceConstraintViolation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "average_distance_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaximumUpperDistanceConstraintViolation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "maximum_upper_distance_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaximumLowerDistanceConstraintViolation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "maximum_lower_distance_constraint_violation", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistanceConstraintViolationMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "distance_constraint_violation_method", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaximumTorsionAngleConstraintViolation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "maximum_torsion_angle_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAverageTorsionAngleConstraintViolation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "average_torsion_angle_constraint_violation", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTorsionAngleConstraintViolationMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "torsion_angle_constraint_violation_method", this);
        }

    }

    public static class PdbxNmrEnsembleRmsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_ensemble_rms";

        public PdbxNmrEnsembleRmsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterResidueRangeBegin() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "residue_range_begin", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChainRangeBegin() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chain_range_begin", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterResidueRangeEnd() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "residue_range_end", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChainRangeEnd() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chain_range_end", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_type", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistanceRmsDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "distance_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDistanceRmsDevError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "distance_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentBondRmsDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "covalent_bond_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentBondRmsDevError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "covalent_bond_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBondAngleRmsDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "bond_angle_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBondAngleRmsDevError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "bond_angle_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterImproperTorsionAngleRmsDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "improper_torsion_angle_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterImproperTorsionAngleRmsDevError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "improper_torsion_angle_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPeptidePlanarityRmsDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "peptide_planarity_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPeptidePlanarityRmsDevError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "peptide_planarity_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDihedralAnglesRmsDev() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dihedral_angles_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDihedralAnglesRmsDevError() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dihedral_angles_rms_dev_error", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoordAverageRmsdMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coord_average_rmsd_method", this);
        }

    }

    public static class PdbxNmrRepresentativeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_representative";

        public PdbxNmrRepresentativeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrRepresentativeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrRepresentativeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConformerId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conformer_id", this);
        }

        public StrColumnBuilder<PdbxNmrRepresentativeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSelectionCriteria() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "selection_criteria", this);
        }

    }

    public static class PdbxNmrRefineBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_refine";

        public PdbxNmrRefineBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxNmrRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<PdbxNmrRefineBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "software_ordinal", this);
        }

    }

    public static class PdbxNmrForceConstantsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_force_constants";

        public PdbxNmrForceConstantsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlDistanceTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "exptl_distance_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlDistanceTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "exptl_distance_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlTorsionAnglesTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "exptl_torsion_angles_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlTorsionAnglesTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "exptl_torsion_angles_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlJCouplingTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "exptl_J_coupling_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlJCouplingTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "exptl_J_coupling_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptl13CShiftTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "exptl_13C_shift_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptl13CShiftTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "exptl_13C_shift_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptl1HShiftTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "exptl_1H_shift_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptl1HShiftTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "exptl_1H_shift_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlDipolarCouplingTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "exptl_dipolar_coupling_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlDipolarCouplingTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "exptl_dipolar_coupling_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlDIsotopeShiftTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "exptl_D_isotope_shift_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExptlDIsotopeShiftTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "exptl_D_isotope_shift_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentGeomBondTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "covalent_geom_bond_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentGeomBondTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "covalent_geom_bond_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentGeomAnglesTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "covalent_geom_angles_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentGeomAnglesTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "covalent_geom_angles_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentGeomImpropersTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "covalent_geom_impropers_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCovalentGeomImpropersTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "covalent_geom_impropers_term_units", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNon_bondedInterVanDerWaalsTermType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "non-bonded_inter_van_der_Waals_term_type", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNon_bondedInterVanDerWaalsTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "non-bonded_inter_van_der_Waals_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNon_bondedInterVanDerWaalsTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "non-bonded_inter_van_der_Waals_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNon_bondedInterConfDbPotentialTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "non-bonded_inter_conf_db_potential_term", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNon_bondedInterRadiusOfGyrationTerm() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "non-bonded_inter_radius_of_gyration_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNon_bondedInterRadiusOfGyrationTermUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "non-bonded_inter_radius_of_gyration_term_units", this);
        }

    }

    public static class NdbStructConfNaBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_conf_na";

        public NdbStructConfNaBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<NdbStructConfNaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<NdbStructConfNaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature", this);
        }

        public IntColumnBuilder<NdbStructConfNaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "feature_count", this);
        }

    }

    public static class NdbStructFeatureNaBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_feature_na";

        public NdbStructFeatureNaBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<NdbStructFeatureNaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<NdbStructFeatureNaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature", this);
        }

        public IntColumnBuilder<NdbStructFeatureNaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "feature_count", this);
        }

    }

    public static class NdbStructNaBasePairBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_na_base_pair";

        public NdbStructNaBasePairBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "model_number", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPairNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pair_number", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPairName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pair_name", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_label_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_label_comp_id", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "i_label_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterISymmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_symmetry", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_label_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_label_comp_id", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "j_label_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJSymmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_symmetry", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_auth_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_auth_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_PDB_ins_code", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_auth_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_auth_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_PDB_ins_code", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterShear() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "shear", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStretch() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "stretch", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStagger() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "stagger", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBuckle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "buckle", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPropeller() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "propeller", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOpening() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "opening", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHbondType12() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "hbond_type_12", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHbondType28() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "hbond_type_28", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHbondTypeLeontisWesthof() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "hbond_type_leontis_westhof", this);
        }

    }

    public static class NdbStructNaBasePairStepBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_na_base_pair_step";

        public NdbStructNaBasePairStepBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "model_number", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_number", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "step_name", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_label_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_label_comp_id_1", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelSeqId1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "i_label_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterISymmetry1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_symmetry_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_label_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_label_comp_id_1", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelSeqId1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "j_label_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJSymmetry1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_symmetry_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_label_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_label_comp_id_2", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterILabelSeqId2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "i_label_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterISymmetry2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_symmetry_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_label_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_label_comp_id_2", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJLabelSeqId2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "j_label_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJSymmetry2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_symmetry_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_auth_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_auth_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_auth_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_auth_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_auth_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_auth_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "i_PDB_ins_code_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_auth_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_auth_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterJPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "j_PDB_ins_code_2", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterShift() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "shift", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSlide() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "slide", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRise() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rise", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTilt() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "tilt", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRoll() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "roll", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTwist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "twist", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterXDisplacement() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "x_displacement", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterYDisplacement() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "y_displacement", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHelicalRise() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "helical_rise", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInclination() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "inclination", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTip() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "tip", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHelicalTwist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "helical_twist", this);
        }

    }

    public static class NdbOriginalNdbCoordinatesBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_original_ndb_coordinates";

        public NdbOriginalNdbCoordinatesBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<NdbOriginalNdbCoordinatesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCoordSection() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "coord_section", this);
        }

    }

    public static class PdbxEntityNonpolyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_nonpoly";

        public PdbxEntityNonpolyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaModelMode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ma_model_mode", this);
        }

    }

    public static class PdbxPhasingDmBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_dm";

        public PdbxPhasingDmBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaskType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mask_type", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom", this);
        }

        public IntColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeltaPhiInitial() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta_phi_initial", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeltaPhiFinal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta_phi_final", this);
        }

    }

    public static class PdbxPhasingDmShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_dm_shell";

        public PdbxPhasingDmShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom", this);
        }

        public IntColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeltaPhiInitial() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta_phi_initial", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDeltaPhiFinal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "delta_phi_final", this);
        }

    }

    public static class PdbxPhasingMADShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_shell";

        public PdbxPhasingMADShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKrautCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKrautAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKraut() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLocCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLocAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLoc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power", this);
        }

    }

    public static class PdbxPhasingMADSetBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_set";

        public PdbxPhasingMADSetBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberOfSites() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_of_sites", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKrautCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKrautAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKraut() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLocCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLocAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLoc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power", this);
        }

    }

    public static class PdbxPhasingMADSetShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_set_shell";

        public PdbxPhasingMADSetShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsAcentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsCentric() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflns() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFomCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFom() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullisAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRCullis() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKrautCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKrautAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRKraut() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_kraut", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLocCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLocAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLoc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerCentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPowerAcentric() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPower() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "power", this);
        }

    }

    public static class PdbxPhasingMADSetSiteBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_set_site";

        public PdbxPhasingMADSetSiteBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomTypeSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_type_symbol", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnXEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_x_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnYEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_y_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCartnZEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Cartn_z_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractX() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_x", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractY() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_y", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractZ() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_z", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractXEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_x_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractYEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_y_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFractZEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fract_z_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "b_iso", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "b_iso_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_esd", this);
        }

        public StrColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "set_id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_iso", this);
        }

    }

    public static class PdbxPhasingMRBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MR";

        public PdbxPhasingMRBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethodRotation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHighRotation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLowRotation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSigmaFRotation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sigma_F_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSigmaIRotation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sigma_I_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsPercentRotation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reflns_percent_rotation", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethodTranslation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHighTranslation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLowTranslation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSigmaFTranslation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sigma_F_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSigmaITranslation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sigma_I_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReflnsPercentTranslation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "reflns_percent_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffIoToIc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_Io_to_Ic", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationCoeffFoToFc() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_coeff_Fo_to_Fc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRFactor() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_factor", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRRigidBody() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "R_rigid_body", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPacking() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "packing", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModelDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "model_details", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNativeSetId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "native_set_id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHighFit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high_fit", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLowFit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low_fit", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterZscoreRotation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "zscore_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLLGainRotation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "LL_gain_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterZscoreTranslation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "zscore_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLLGainTranslation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "LL_gain_translation", this);
        }

    }

    public static class PdbxRefineComponentBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_component";

        public PdbxRefineComponentBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIso() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoMainChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBIsoSideChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "B_iso_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterShift() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "shift", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterShiftSideChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "shift_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterShiftMainChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "shift_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationSideChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrelationMainChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correlation_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRealSpaceR() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "real_space_R", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRealSpaceRSideChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "real_space_R_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRealSpaceRMainChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "real_space_R_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConnect() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "connect", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityIndex() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_index", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityIndexMainChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_index_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityIndexSideChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_index_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityRatio() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_ratio", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityRatioMainChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_ratio_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDensityRatioSideChain() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "density_ratio_side_chain", this);
        }

    }

    public static class PdbxEntityProdProtocolBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_prod_protocol";

        public PdbxEntityProdProtocolBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProtocol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "protocol", this);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProtocolType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "protocol_type", this);
        }

    }

    public static class PdbxEntitySrcGenProdOtherBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_other";

        public PdbxEntitySrcGenProdOtherBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProcessName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "process_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxEntitySrcGenProdOtherParameterBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_other_parameter";

        public PdbxEntitySrcGenProdOtherParameterBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterParameter() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "parameter", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxEntitySrcGenProdPcrBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_pcr";

        public PdbxEntitySrcGenProdPcrBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterForwardPrimerId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "forward_primer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReversePrimerId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reverse_primer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReactionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "reaction_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPurificationDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "purification_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSummary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "summary", this);
        }

    }

    public static class PdbxEntitySrcGenProdDigestBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_digest";

        public PdbxEntitySrcGenProdDigestBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRestrictionEnzyme1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "restriction_enzyme_1", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRestrictionEnzyme2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "restriction_enzyme_2", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPurificationDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "purification_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSummary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "summary", this);
        }

    }

    public static class PdbxEntitySrcGenCloneBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_clone";

        public PdbxEntitySrcGenCloneBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterGeneInsertMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "gene_insert_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVectorName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "vector_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVectorDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "vector_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTransformationMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "transformation_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMarker() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "marker", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVerificationMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "verification_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPurificationDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "purification_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSummary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "summary", this);
        }

    }

    public static class PdbxEntitySrcGenCloneLigationBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_clone_ligation";

        public PdbxEntitySrcGenCloneLigationBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCleavageEnzymes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "cleavage_enzymes", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLigationEnzymes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ligation_enzymes", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTime() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxEntitySrcGenCloneRecombinationBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_clone_recombination";

        public PdbxEntitySrcGenCloneRecombinationBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSystem() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "system", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRecombinationEnzymes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "recombination_enzymes", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxEntitySrcGenExpressBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_express";

        public PdbxEntitySrcGenExpressBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPromoterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "promoter_type", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPlasmidId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "plasmid_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVectorType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "vector_type", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNTerminalSeqTag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "N_terminal_seq_tag", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCTerminalSeqTag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "C_terminal_seq_tag", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgScientificName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_scientific_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgCommonName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_common_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgVariant() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_variant", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgStrain() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_strain", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgTissue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_tissue", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgCultureCollection() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_culture_collection", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgCellLine() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_cell_line", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgTaxId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_tax_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHostOrgDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "host_org_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCultureBaseMedia() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "culture_base_media", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCultureAdditives() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "culture_additives", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCultureVolume() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "culture_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCultureTime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "culture_time", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCultureTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "culture_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInducer() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "inducer", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInducerConcentration() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "inducer_concentration", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInductionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "induction_details", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMultiplicityOfInfection() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "multiplicity_of_infection", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInductionTimepoint() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "induction_timepoint", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInductionTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "induction_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHarvestingDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "harvesting_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStorageDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "storage_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSummary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "summary", this);
        }

    }

    public static class PdbxEntitySrcGenExpressTimepointBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_express_timepoint";

        public PdbxEntitySrcGenExpressTimepointBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSerial() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "serial", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOD() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "OD", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTime() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "time", this);
        }

    }

    public static class PdbxEntitySrcGenLysisBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_lysis";

        public PdbxEntitySrcGenLysisBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBufferVolume() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "buffer_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxEntitySrcGenRefoldBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_refold";

        public PdbxEntitySrcGenRefoldBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDenatureBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "denature_buffer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefoldBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "refold_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStorageBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "storage_buffer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxEntitySrcGenProteolysisBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_proteolysis";

        public PdbxEntitySrcGenProteolysisBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProtease() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "protease", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinProteaseRatio() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "protein_protease_ratio", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCleavageBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "cleavage_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCleavageTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cleavage_temperature", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCleavageTime() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "cleavage_time", this);
        }

    }

    public static class PdbxEntitySrcGenChromBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_chrom";

        public PdbxEntitySrcGenChromBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterColumnType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "column_type", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterColumnVolume() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "column_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterColumnTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "column_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEquilibrationBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "equilibration_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFlowRate() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "flow_rate", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterElutionBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "elution_buffer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterElutionProtocol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "elution_protocol", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSamplePrepDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sample_prep_details", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSampleVolume() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sample_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSampleConcentration() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sample_concentration", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSampleConcMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sample_conc_method", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolumePooledFractions() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "volume_pooled_fractions", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterYieldPooledFractions() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "yield_pooled_fractions", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterYieldMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "yield_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPostTreatment() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "post_treatment", this);
        }

    }

    public static class PdbxEntitySrcGenFractBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_fract";

        public PdbxEntitySrcGenFractBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNextStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinLocation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "protein_location", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinVolume() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "protein_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinYield() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "protein_yield", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinYieldMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "protein_yield_method", this);
        }

    }

    public static class PdbxEntitySrcGenPureBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_pure";

        public PdbxEntitySrcGenPureBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProductId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "product_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcDeviceId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc_device_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcAssayMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc_assay_method", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinConcentration() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "protein_concentration", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinYield() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "protein_yield", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinPurity() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "protein_purity", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinOligomericState() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "protein_oligomeric_state", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStorageBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "storage_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStorageTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "storage_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSummary() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "summary", this);
        }

    }

    public static class PdbxEntitySrcGenCharacterBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_character";

        public PdbxEntitySrcGenCharacterBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStepId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterResult() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "result", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxConstructBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_construct";

        public PdbxConstructBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrganisation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "organisation", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRobotId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClazz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeq() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seq", this);
        }

    }

    public static class PdbxConstructFeatureBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_construct_feature";

        public PdbxConstructFeatureBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConstructId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "construct_id", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxConstructFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStartSeq() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "start_seq", this);
        }

        public IntColumnBuilder<PdbxConstructFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndSeq() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_seq", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxRobotSystemBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_robot_system";

        public PdbxRobotSystemBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterModel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "model", this);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterManufacturer() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "manufacturer", this);
        }

    }

    public static class PdbxBufferBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_buffer";

        public PdbxBufferBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxBufferBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxBufferBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxBufferBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxBufferComponentsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_buffer_components";

        public PdbxBufferComponentsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBufferId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "buffer_id", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVolume() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "volume", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConc() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conc_units", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIsotopicLabeling() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "isotopic_labeling", this);
        }

    }

    public static class PdbxDomainBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_domain";

        public PdbxDomainBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

    }

    public static class PdbxDomainRangeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_domain_range";

        public PdbxDomainRangeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDomainId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "domain_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

    }

    public static class PdbxSequenceRangeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_sequence_range";

        public PdbxSequenceRangeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqRangeId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seq_range_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

    }

    public static class PdbxFeatureEntryBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_entry";

        public PdbxFeatureEntryBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_software_id", this);
        }

    }

    public static class PdbxFeatureDomainBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_domain";

        public PdbxFeatureDomainBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDomainId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "domain_id", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_software_id", this);
        }

    }

    public static class PdbxFeatureSequenceRangeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_sequence_range";

        public PdbxFeatureSequenceRangeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqRangeId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seq_range_id", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_software_id", this);
        }

    }

    public static class PdbxFeatureAssemblyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_assembly";

        public PdbxFeatureAssemblyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAssemblyId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_software_id", this);
        }

    }

    public static class PdbxFeatureMonomerBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_monomer";

        public PdbxFeatureMonomerBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeature() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_software_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

    }

    public static class PdbxExptlPdBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_pd";

        public PdbxExptlPdBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlPdBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<PdbxExptlPdBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpecPreparationPH() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "spec_preparation_pH", this);
        }

        public StrColumnBuilder<PdbxExptlPdBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpecPreparationPHRange() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "spec_preparation_pH_range", this);
        }

        public StrColumnBuilder<PdbxExptlPdBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSpecPreparation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "spec_preparation", this);
        }

    }

    public static class PdbxReflnsTwinBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reflns_twin";

        public PdbxReflnsTwinBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCrystalId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDomainId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "domain_id", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOperator() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "operator", this);
        }

        public FloatColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFraction() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "fraction", this);
        }

        public FloatColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanI2OverMeanISquare() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_I2_over_mean_I_square", this);
        }

        public FloatColumnBuilder<PdbxReflnsTwinBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanFSquareOverMeanF2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_F_square_over_mean_F2", this);
        }

    }

    public static class PdbxStructInfoBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_info";

        public PdbxStructInfoBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructInfoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructInfoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxStructInfoBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxReRefinementBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_re_refinement";

        public PdbxReRefinementBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReRefinementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxReRefinementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "citation_id", this);
        }

        public StrColumnBuilder<PdbxReRefinementBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxStructAssemblyPropBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_prop";

        public PdbxStructAssemblyPropBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBiolId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxStructRefSeqFeatureBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_feature";

        public PdbxStructRefSeqFeatureBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAlignId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "align_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_seq_num", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndSeqNum() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_seq_num", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegPdbInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_pdb_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndPdbInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_pdb_ins_code", this);
        }

    }

    public static class PdbxStructRefSeqFeaturePropBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_feature_prop";

        public PdbxStructRefSeqFeaturePropBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "feature_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPropertyId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "property_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegDbMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_db_mon_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndDbMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_db_mon_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegDbSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_db_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndDbSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_db_seq_id", this);
        }

    }

    public static class PdbxStructChemCompDiagnosticsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_chem_comp_diagnostics";

        public PdbxStructChemCompDiagnosticsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "seq_num", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_ins_code", this);
        }

        public IntColumnBuilder<PdbxStructChemCompDiagnosticsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

    }

    public static class PdbxChemCompSynonymsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_synonyms";

        public PdbxChemCompSynonymsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxChemCompSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProvenance() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "provenance", this);
        }

        public StrColumnBuilder<PdbxChemCompSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class PdbxChemCompFeatureBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_feature";

        public PdbxChemCompFeatureBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSupport() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "support", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source", this);
        }

    }

    public static class PdbxCoordinateModelBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_coordinate_model";

        public PdbxCoordinateModelBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxCoordinateModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxCoordinateModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class PdbxStructChemCompFeatureBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_chem_comp_feature";

        public PdbxStructChemCompFeatureBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbStrandId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "seq_num", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pdb_ins_code", this);
        }

        public IntColumnBuilder<PdbxStructChemCompFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

    }

    public static class PdbxDiffrnReflnsShellBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_diffrn_reflns_shell";

        public PdbxDiffrnReflnsShellBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDiffrnId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "diffrn_id", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResLow() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDResHigh() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPercentPossibleObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "percent_possible_obs", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmergeIObs() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rmerge_I_obs", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRsymValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "Rsym_value", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChiSquared() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chi_squared", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRedundancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "redundancy", this);
        }

        public IntColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRejects() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "rejects", this);
        }

        public IntColumnBuilder<PdbxDiffrnReflnsShellBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberObs() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_obs", this);
        }

    }

    public static class PdbxBondDistanceLimitsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_bond_distance_limits";

        public PdbxBondDistanceLimitsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxBondDistanceLimitsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomType1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_type_1", this);
        }

        public StrColumnBuilder<PdbxBondDistanceLimitsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomType2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_type_2", this);
        }

        public FloatColumnBuilder<PdbxBondDistanceLimitsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLowerLimit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "lower_limit", this);
        }

        public FloatColumnBuilder<PdbxBondDistanceLimitsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterUpperLimit() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "upper_limit", this);
        }

    }

    public static class PdbxSolnScatterBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_soln_scatter";

        public PdbxSolnScatterBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceBeamline() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source_beamline", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceBeamlineInstrument() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source_beamline_instrument", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetectorType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "detector_type", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetectorSpecific() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "detector_specific", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source_type", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceClass() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source_class", this);
        }

        public IntColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumTimeFrames() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "num_time_frames", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSamplePH() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "sample_pH", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTemperature() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "temperature", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConcentrationRange() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "concentration_range", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBufferName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "buffer_name", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanGuinerRadius() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_guiner_radius", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMeanGuinerRadiusEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "mean_guiner_radius_esd", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMinMeanCrossSectionalRadiiGyration() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "min_mean_cross_sectional_radii_gyration", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMinMeanCrossSectionalRadiiGyrationEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "min_mean_cross_sectional_radii_gyration_esd", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaxMeanCrossSectionalRadiiGyration() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "max_mean_cross_sectional_radii_gyration", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMaxMeanCrossSectionalRadiiGyrationEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "max_mean_cross_sectional_radii_gyration_esd", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProteinLength() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "protein_length", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataReductionSoftwareList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_reduction_software_list", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataAnalysisSoftwareList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_analysis_software_list", this);
        }

    }

    public static class PdbxSolnScatterModelBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_soln_scatter_model";

        public PdbxSolnScatterModelBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterScatterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "scatter_id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "software_list", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareAuthorList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "software_author_list", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryFittingList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_fitting_list", this);
        }

        public IntColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumConformersCalculated() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "num_conformers_calculated", this);
        }

        public IntColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumConformersSubmitted() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "num_conformers_submitted", this);
        }

        public IntColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRepresentativeConformer() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "representative_conformer", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConformerSelectionCriteria() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conformer_selection_criteria", this);
        }

    }

    public static class PdbxChemCompDescriptorBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_descriptor";

        public PdbxChemCompDescriptorBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescriptor() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "descriptor", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProgram() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "program", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProgramVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "program_version", this);
        }

        public IntColumnBuilder<PdbxChemCompDescriptorBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

    }

    public static class PdbxChemCompIdentifierBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_identifier";

        public PdbxChemCompIdentifierBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIdentifier() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "identifier", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProgram() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "program", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProgramVersion() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "program_version", this);
        }

        public IntColumnBuilder<PdbxChemCompIdentifierBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

    }

    public static class PdbxChemCompImportBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_import";

        public PdbxChemCompImportBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompImportBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

    }

    public static class PdbxChemCompAtomEditBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_atom_edit";

        public PdbxChemCompAtomEditBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompAtomEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEditOp() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "edit_op", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEditAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "edit_atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEditAtomValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "edit_atom_value", this);
        }

    }

    public static class PdbxChemCompBondEditBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_bond_edit";

        public PdbxChemCompBondEditBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompBondEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEditOp() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "edit_op", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEditBondValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "edit_bond_value", this);
        }

    }

    public static class PdbxChemCompAuditBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_audit";

        public PdbxChemCompAuditBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnnotator() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "annotator", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProcessingSite() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "processing_site", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterActionType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "action_type", this);
        }

    }

    public static class PdbxValidateCloseContactBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_close_contact";

        public PdbxValidateCloseContactBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmAsXyz1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "symm_as_xyz_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmAsXyz2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "symm_as_xyz_2", this);
        }

        public FloatColumnBuilder<PdbxValidateCloseContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist", this);
        }

    }

    public static class PdbxValidateSymmContactBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_symm_contact";

        public PdbxValidateSymmContactBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public FloatColumnBuilder<PdbxValidateSymmContactBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist", this);
        }

    }

    public static class PdbxValidateRmsdBondBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_rmsd_bond";

        public PdbxValidateRmsdBondBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBondDeviation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "bond_deviation", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBondValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "bond_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBondTargetValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "bond_target_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBondStandardDeviation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "bond_standard_deviation", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkerFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "linker_flag", this);
        }

    }

    public static class PdbxValidateRmsdAngleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_rmsd_angle";

        public PdbxValidateRmsdAngleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId3() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_3", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleDeviation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_deviation", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleTargetValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_target_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAngleStandardDeviation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "angle_standard_deviation", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkerFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "linker_flag", this);
        }

    }

    public static class PdbxValidateTorsionBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_torsion";

        public PdbxValidateTorsionBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public FloatColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "phi", this);
        }

        public FloatColumnBuilder<PdbxValidateTorsionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPsi() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "psi", this);
        }

    }

    public static class PdbxValidatePeptideOmegaBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_peptide_omega";

        public PdbxValidatePeptideOmegaBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public FloatColumnBuilder<PdbxValidatePeptideOmegaBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOmega() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "omega", this);
        }

    }

    public static class PdbxValidateChiralBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_chiral";

        public PdbxValidateChiralBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public FloatColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOmega() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "omega", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxValidatePlanesBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_planes";

        public PdbxValidatePlanesBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public FloatColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRmsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rmsd", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

    }

    public static class PdbxValidatePlanesAtomBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_planes_atom";

        public PdbxValidatePlanesAtomBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPlaneId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "plane_id", this);
        }

        public IntColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public FloatColumnBuilder<PdbxValidatePlanesAtomBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomDeviation() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "atom_deviation", this);
        }

    }

    public static class PdbxValidateMainChainPlaneBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_main_chain_plane";

        public PdbxValidateMainChainPlaneBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public FloatColumnBuilder<PdbxValidateMainChainPlaneBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterImproperTorsionAngle() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "improper_torsion_angle", this);
        }

    }

    public static class PdbxStructConnAngleBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_conn_angle";

        public PdbxStructConnAngleBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1Symmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_symmetry", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2Symmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_symmetry", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr1AuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr1_auth_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr2AuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr2_auth_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3AuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_auth_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3AuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3AuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3AuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3PDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3AuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3LabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3LabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3LabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3LabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3LabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPtnr3Symmetry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ptnr3_symmetry", this);
        }

        public FloatColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public FloatColumnBuilder<PdbxStructConnAngleBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueEsd() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "value_esd", this);
        }

    }

    public static class PdbxUnobsOrZeroOccResiduesBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_unobs_or_zero_occ_residues";

        public PdbxUnobsOrZeroOccResiduesBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPolymerFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "polymer_flag", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_flag", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

    }

    public static class PdbxUnobsOrZeroOccAtomsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_unobs_or_zero_occ_atoms";

        public PdbxUnobsOrZeroOccAtomsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPolymerFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "polymer_flag", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancyFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "occupancy_flag", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

    }

    public static class PdbxEntryDetailsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entry_details";

        public PdbxEntryDetailsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNonpolymerDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "nonpolymer_details", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSequenceDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sequence_details", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompoundDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "compound_details", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source_details", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHasLigandOfInterest() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "has_ligand_of_interest", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHasProteinModification() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "has_protein_modification", this);
        }

    }

    public static class PdbxStructModResidueBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_mod_residue";

        public PdbxStructModResidueBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterParentCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "parent_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxStructRefSeqInsertionBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_insertion";

        public PdbxStructRefSeqInsertionBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_name", this);
        }

    }

    public static class PdbxStructRefSeqDeletionBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_deletion";

        public PdbxStructRefSeqDeletionBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqDeletionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "db_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_name", this);
        }

    }

    public static class PdbxRemediationAtomSiteMappingBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_remediation_atom_site_mapping";

        public PdbxRemediationAtomSiteMappingBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterGroupPDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "group_PDB", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPdbxAlign() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pdbx_align", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pre_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pre_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pre_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pre_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrePDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pre_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreGroupPDB() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pre_group_PDB", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreAuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "pre_auth_alt_id", this);
        }

        public IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrePdbxAlign() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "pre_pdbx_align", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_alt_id", this);
        }

        public FloatColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOccupancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "occupancy", this);
        }

        public FloatColumnBuilder<PdbxRemediationAtomSiteMappingBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPreOccupancy() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "pre_occupancy", this);
        }

    }

    public static class PdbxValidatePolymerLinkageBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_polymer_linkage";

        public PdbxValidatePolymerLinkageBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public FloatColumnBuilder<PdbxValidatePolymerLinkageBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDist() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "dist", this);
        }

    }

    public static class PdbxHelicalSymmetryBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_helical_symmetry";

        public PdbxHelicalSymmetryBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxHelicalSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNumberOfOperations() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "number_of_operations", this);
        }

        public FloatColumnBuilder<PdbxHelicalSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRotationPerNSubunits() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rotation_per_n_subunits", this);
        }

        public FloatColumnBuilder<PdbxHelicalSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRisePerNSubunits() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "rise_per_n_subunits", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNSubunitsDivisor() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "n_subunits_divisor", this);
        }

        public StrColumnBuilder<PdbxHelicalSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDyadAxis() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "dyad_axis", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCircularSymmetry() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "circular_symmetry", this);
        }

    }

    public static class PdbxPointSymmetryBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_point_symmetry";

        public PdbxPointSymmetryBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPointSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPointSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSchoenfliesSymbol() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "Schoenflies_symbol", this);
        }

        public IntColumnBuilder<PdbxPointSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCircularSymmetry() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "circular_symmetry", this);
        }

        public StrColumnBuilder<PdbxPointSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterH_MNotation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "H-M_notation", this);
        }

    }

    public static class PdbxStructEntityInstBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_entity_inst";

        public PdbxStructEntityInstBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructEntityInstBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructEntityInstBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxStructEntityInstBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

    }

    public static class PdbxStructOperListBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_oper_list";

        public PdbxStructOperListBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSymmetryOperation() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "symmetry_operation", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[3]", this);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFullMatrix() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "full_matrix", this);
        }

    }

    public static class PdbxStructAssemblyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly";

        public PdbxStructAssemblyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMethodDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "method_details", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOligomericDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "oligomeric_details", this);
        }

        public IntColumnBuilder<PdbxStructAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOligomericCount() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "oligomeric_count", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

    }

    public static class PdbxStructAssemblyGenBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_gen";

        public PdbxStructAssemblyGenBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityInstId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_inst_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymIdList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id_list", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymIdList() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id_list", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAssemblyId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOperExpression() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "oper_expression", this);
        }

    }

    public static class PdbxStructAsymGenBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_asym_gen";

        public PdbxStructAsymGenBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAsymGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityInstId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_inst_id", this);
        }

        public StrColumnBuilder<PdbxStructAsymGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructAsymGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOperExpression() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "oper_expression", this);
        }

    }

    public static class PdbxStructMsymGenBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_msym_gen";

        public PdbxStructMsymGenBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructMsymGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntityInstId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entity_inst_id", this);
        }

        public StrColumnBuilder<PdbxStructMsymGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "msym_id", this);
        }

        public StrColumnBuilder<PdbxStructMsymGenBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOperExpression() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "oper_expression", this);
        }

    }

    public static class PdbxStructLegacyOperListBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_legacy_oper_list";

        public PdbxStructLegacyOperListBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix11() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix12() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix13() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[1][3]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix21() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix22() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix23() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[2][3]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix31() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix32() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMatrix33() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "matrix[3][3]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector1() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector2() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterVector3() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "vector[3]", this);
        }

    }

    public static class PdbxChemCompAtomFeatureBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_atom_feature";

        public PdbxChemCompAtomFeatureBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompAtomFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomFeatureBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFeatureType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "feature_type", this);
        }

    }

    public static class PdbxReferenceMoleculeFamilyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_family";

        public PdbxReferenceMoleculeFamilyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReleaseStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "release_status", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplaces() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replaces", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplacedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replaced_by", this);
        }

    }

    public static class PdbxReferenceMoleculeListBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_list";

        public PdbxReferenceMoleculeListBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

    }

    public static class PdbxReferenceMoleculeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule";

        public PdbxReferenceMoleculeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public FloatColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormulaWeight() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "formula_weight", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormula() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "formula", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTypeEvidenceCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type_evidence_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClazz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClassEvidenceCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class_evidence_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRepresentAs() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "represent_as", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chem_comp_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompoundDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "compound_details", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRepresentativePDBIdCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "representative_PDB_id_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReleaseStatus() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "release_status", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplaces() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replaces", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterReplacedBy() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "replaced_by", this);
        }

    }

    public static class PdbxReferenceEntityListBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_list";

        public PdbxReferenceEntityListBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterComponentId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "component_id", this);
        }

    }

    public static class PdbxReferenceEntityNonpolyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_nonpoly";

        public PdbxReferenceEntityNonpolyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chem_comp_id", this);
        }

    }

    public static class PdbxReferenceEntityLinkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_link";

        public PdbxReferenceEntityLinkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id_2", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntitySeqNum1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "entity_seq_num_1", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntitySeqNum2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "entity_seq_num_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueOrder() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value_order", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterComponent1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "component_1", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterComponent2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "component_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNonpolyResNum1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "nonpoly_res_num_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNonpolyResNum2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "nonpoly_res_num_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkClass() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "link_class", this);
        }

    }

    public static class PdbxReferenceEntityPolyLinkBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_poly_link";

        public PdbxReferenceEntityPolyLinkBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterComponentId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "component_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntitySeqNum1() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "entity_seq_num_1", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntitySeqNum2() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "entity_seq_num_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCompId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomId2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInsertCode1() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "insert_code_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInsertCode2() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "insert_code_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValueOrder() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value_order", this);
        }

    }

    public static class PdbxReferenceEntityPolyBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_poly";

        public PdbxReferenceEntityPolyBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_name", this);
        }

    }

    public static class PdbxReferenceEntityPolySeqBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_poly_seq";

        public PdbxReferenceEntityPolySeqBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mon_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterParentMonId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "parent_mon_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "num", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterObserved() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "observed", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterHetero() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "hetero", this);
        }

    }

    public static class PdbxReferenceEntitySequenceBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_sequence";

        public PdbxReferenceEntitySequenceBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNRPFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "NRP_flag", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOneLetterCodes() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "one_letter_codes", this);
        }

    }

    public static class PdbxReferenceEntitySrcNatBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_src_nat";

        public PdbxReferenceEntitySrcNatBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrganismScientific() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "organism_scientific", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStrain() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "strain", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTaxid() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "taxid", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtcc() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atcc", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source_id", this);
        }

    }

    public static class PdbxReferenceMoleculeDetailsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_details";

        public PdbxReferenceMoleculeDetailsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

    }

    public static class PdbxReferenceMoleculeSynonymsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_synonyms";

        public PdbxReferenceMoleculeSynonymsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chem_comp_id", this);
        }

    }

    public static class PdbxReferenceEntitySubcomponentsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_subcomponents";

        public PdbxReferenceEntitySubcomponentsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSeq() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "seq", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chem_comp_id", this);
        }

    }

    public static class PdbxReferenceMoleculeAnnotationBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_annotation";

        public PdbxReferenceMoleculeAnnotationBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterText() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "text", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSupport() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "support", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chem_comp_id", this);
        }

    }

    public static class PdbxReferenceMoleculeFeaturesBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_features";

        public PdbxReferenceMoleculeFeaturesBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSourceOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "source_ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSource() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chem_comp_id", this);
        }

    }

    public static class PdbxReferenceMoleculeRelatedStructuresBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_related_structures";

        public PdbxReferenceMoleculeRelatedStructuresBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDbAccession() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "db_accession", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFormula() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "formula", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCitationId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "citation_id", this);
        }

    }

    public static class PdbxStructGroupListBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_group_list";

        public PdbxStructGroupListBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStructGroupId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "struct_group_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterGroupEnumerationType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "group_enumeration_type", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDescription() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSelection() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "selection", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSelectionDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "selection_details", this);
        }

    }

    public static class PdbxStructGroupComponentsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_group_components";

        public PdbxStructGroupComponentsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStructGroupId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "struct_group_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

    }

    public static class PdbxStructGroupComponentRangeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_group_component_range";

        public PdbxStructGroupComponentRangeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStructGroupId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "struct_group_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterBegLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "beg_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_label_alt_id", this);
        }

    }

    public static class PdbxPrdAuditBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_prd_audit";

        public PdbxPrdAuditBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnnotator() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "annotator", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProcessingSite() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "processing_site", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterActionType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "action_type", this);
        }

    }

    public static class PdbxFamilyPrdAuditBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_family_prd_audit";

        public PdbxFamilyPrdAuditBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDate() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAnnotator() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "annotator", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProcessingSite() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "processing_site", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterActionType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "action_type", this);
        }

    }

    public static class PdbxMoleculeBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_molecule";

        public PdbxMoleculeBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterInstanceId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "instance_id", this);
        }

        public StrColumnBuilder<PdbxMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxMoleculeBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLinkedEntityId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "linked_entity_id", this);
        }

    }

    public static class PdbxMoleculeFeaturesBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_molecule_features";

        public PdbxMoleculeFeaturesBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterClazz() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

    }

    public static class PdbxFamilyGroupIndexBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_family_group_index";

        public PdbxFamilyGroupIndexBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFamilyGroupIndexBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFamilyGroupIndexBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterFamilyPrdId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "family_prd_id", this);
        }

    }

    public static class PdbxDistantSolventAtomsBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_distant_solvent_atoms";

        public PdbxDistantSolventAtomsBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAtomId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNeighborMacromoleculeDistance() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "neighbor_macromolecule_distance", this);
        }

        public FloatColumnBuilder<PdbxDistantSolventAtomsBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNeighborLigandDistance() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "neighbor_ligand_distance", this);
        }

    }

    public static class PdbxStructSpecialSymmetryBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_special_symmetry";

        public PdbxStructSpecialSymmetryBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBModelNum() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAuthSeqId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPDBInsCode() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAltId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelAsymId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelCompId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructSpecialSymmetryBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabelSeqId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "label_seq_id", this);
        }

    }

    public static class PdbxReferencePublicationListBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_publication_list";

        public PdbxReferencePublicationListBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPublicationAbbrev() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "publication_abbrev", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterASTMCodeType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ASTM_code_type", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterASTMCodeValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ASTM_code_value", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterISSNCodeType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ISSN_code_type", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterISSNCodeValue() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ISSN_code_value", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCountry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "country", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterStartYear() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "start_year", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEndYear() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "end_year", this);
        }

    }

    public static class PdbxNmrAssignedChemShiftListBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_assigned_chem_shift_list";

        public PdbxNmrAssignedChemShiftListBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShift13CErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_13C_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShift15NErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_15N_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShift19FErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_19F_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShift1HErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_1H_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShift2HErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_2H_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShift31PErr() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_31P_err", this);
        }

        public IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShiftReferenceId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_reference_id", this);
        }

        public IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConditionsId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "conditions_id", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDataFileName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "data_file_name", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterErrorDerivationMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "error_derivation_method", this);
        }

        public IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConditionsLabel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "conditions_label", this);
        }

    }

    public static class PdbxNmrChemShiftExperimentBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_experiment";

        public PdbxNmrChemShiftExperimentBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAssignedChemShiftListId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "assigned_chem_shift_list_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExperimentId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExperimentName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "experiment_name", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSampleState() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "sample_state", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolutionId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "solution_id", this);
        }

    }

    public static class PdbxNmrChemShiftRefBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_ref";

        public PdbxNmrChemShiftRefBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomGroup() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_group", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomIsotopeNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "atom_isotope_number", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAtomType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "atom_type", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShiftReferenceId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_reference_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShiftUnits() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_units", this);
        }

        public FloatColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterChemShiftVal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "chem_shift_val", this);
        }

        public FloatColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCorrectionVal() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "correction_val", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExternalRefAxis() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "external_ref_axis", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExternalRefLoc() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "external_ref_loc", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterExternalRefSampleGeometry() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "external_ref_sample_geometry", this);
        }

        public FloatColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterIndirectShiftRatio() {
            return new FloatColumnBuilderImpl<>(CATEGORY_NAME, "indirect_shift_ratio", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterMolCommonName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "mol_common_name", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRank() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "rank", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefCorrectionType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_correction_type", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefMethod() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_method", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterRefType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "ref_type", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSolvent() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "solvent", this);
        }

    }

    public static class PdbxNmrChemShiftReferenceBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_reference";

        public PdbxNmrChemShiftReferenceBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterCarbonShiftsFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "carbon_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterDetails() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterLabel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterNitrogenShiftsFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "nitrogen_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterOtherShiftsFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "other_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterPhosphorusShiftsFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "phosphorus_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterProtonShiftsFlag() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "proton_shifts_flag", this);
        }

    }

    public static class PdbxNmrChemShiftSoftwareBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_software";

        public PdbxNmrChemShiftSoftwareBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrChemShiftSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterAssignedChemShiftListId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "assigned_chem_shift_list_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "software_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftSoftwareBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareLabel() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "software_label", this);
        }

    }

    public static class PdbxNmrConstraintFileBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_constraint_file";

        public PdbxNmrConstraintFileBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConstraintFilename() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "constraint_filename", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConstraintNumber() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "constraint_number", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConstraintSubtype() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "constraint_subtype", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterConstraintType() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "constraint_type", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterId() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareName() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "software_name", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintFileBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "software_ordinal", this);
        }

    }

    public static class PdbxNmrSoftwareTaskBuilder extends MmCifCategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_software_task";

        public PdbxNmrSoftwareTaskBuilder(MmCifBlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSoftwareTaskBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterEntryId() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrSoftwareTaskBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterSoftwareOrdinal() {
            return new IntColumnBuilderImpl<>(CATEGORY_NAME, "software_ordinal", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareTaskBuilder, MmCifBlockBuilder, MmCifFileBuilder> enterTask() {
            return new StrColumnBuilderImpl<>(CATEGORY_NAME, "task", this);
        }

    }

    public static class PdbxNmrSpectralDimBuilder extends MmCifCategoryBuilder {
        pri