/*
 * Copyright 2021-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Command-line interface (CLI) for validating both XML formats, converting from
 * the event-based to the hierarchical format, and generating HTML reports
 *
 * @since 0.2.0
 */
module org.opentest4j.reporting.cli {

    requires static org.apiguardian.api;
    requires info.picocli;
    requires java.desktop;
    requires org.opentest4j.reporting.tooling.core;
    requires org.slf4j;

    exports org.opentest4j.reporting.cli;

    opens org.opentest4j.reporting.cli to info.picocli;
}
