﻿// Copyright (c) Microsoft Open Technologies, Inc. All rights reserved. See License.txt in the project root for license information.

namespace System.Reactive
{
    /// <summary>
    /// The <b>System.Reactive</b> namespace contains interfaces and classes used throughout the Reactive Extensions library.
    /// </summary>
    [System.Runtime.CompilerServices.CompilerGeneratedAttribute]
    class NamespaceDoc
    {
    }
}

namespace System.Reactive.Concurrency
{
    /// <summary>
    /// The <b>System.Reactive.Concurrency</b> namespace contains interfaces and classes that provide the scheduler infrastructure used by Reactive Extensions to construct and
    /// process event streams. Schedulers are used to parameterize the concurrency introduced by query operators, provide means to virtualize time, to process historical data,
    /// and to write unit tests for functionality built using Reactive Extensions constructs.
    /// </summary>
    [System.Runtime.CompilerServices.CompilerGeneratedAttribute]
    class NamespaceDoc
    {
    }
}

namespace System.Reactive.Disposables
{
    /// <summary>
    /// The <b>System.Reactive.Disposables</b> namespace contains interfaces and classes that provide a compositional set of constructs used to deal with resource and subscription
    /// management in Reactive Extensions. Those types are used extensively within the implementation of Reactive Extensions and are useful when writing custom query operators or
    /// schedulers.
    /// </summary>
    [System.Runtime.CompilerServices.CompilerGeneratedAttribute]
    class NamespaceDoc
    {
    }
}

namespace System.Reactive.Linq
{
    /// <summary>
    /// The <b>System.Reactive.Linq</b> namespace contains interfaces and classes that support expressing queries over observable sequences, using Language Integrated Query (LINQ).
    /// Query operators are made available as extension methods for IObservable&lt;T&gt; and IQbservable&lt;T&gt; defined on the Observable and Qbservable classes, respectively.
    /// </summary>
    [System.Runtime.CompilerServices.CompilerGeneratedAttribute]
    class NamespaceDoc
    {
    }
}

namespace System.Reactive.Subjects
{
    /// <summary>
    /// The <b>System.Reactive.Subjects</b> namespace contains interfaces and classes to represent subjects, which are objects implementing both IObservable&lt;T&gt; and IObserver&lt;T&gt;.
    /// Subjects are often used as sources of events, allowing one party to raise events and allowing another party to write queries over the event stream. Because of their ability to
    /// have multiple registered observers, subjects are also used as a facility to provide multicast behavior for event streams in queries.
    /// </summary>
    [System.Runtime.CompilerServices.CompilerGeneratedAttribute]
    class NamespaceDoc
    {
    }
}
