/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.User;
import org.chefproject.core.UserEdit;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.plugin.CompleteUdp;
import org.chefproject.plugin.PiggybackUdp;
import org.chefproject.plugin.UserDirectoryProvider;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericUserDirectoryService;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.Different;
import org.chefproject.util.OneWayHash;
import org.chefproject.util.Time;
import org.chefproject.util.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseUserDirectoryService
extends TurbineBaseService
implements GenericUserDirectoryService,
StorageUser,
CacheRefresher {
    protected Storage m_storage = null;
    protected Cache m_cache = null;
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;
    protected User m_anon = null;
    protected String m_providerClassName = null;
    protected UserDirectoryProvider m_provider = null;

    protected abstract Storage newStorage();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.m_relativeAccessPoint : this.m_accessPoint;
    }

    public String userReference(String id) {
        return this.getAccessPoint(true) + "/" + id;
    }

    protected String userId(String ref) {
        String start = this.getAccessPoint(true) + "/";
        int i = ref.indexOf(start);
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + start.length());
        return id;
    }

    protected boolean unlockCheck(String lock, String resource) {
        return SecurityService.unlock(lock, resource);
    }

    protected boolean unlockCheck2(String lock1, String lock2, String resource) {
        return SecurityService.unlock(lock1, resource) || SecurityService.unlock(lock2, resource);
    }

    protected void unlock(String lock, String resource) throws PermissionException {
        if (!this.unlockCheck(lock, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock, resource);
        }
    }

    protected void unlock2(String lock1, String lock2, String resource) throws PermissionException {
        if (!this.unlockCheck2(lock1, lock2, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock1 + "/" + lock2, resource);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        this.m_relativeAccessPoint = "/user";
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.m_relativeAccessPoint;
        this.m_providerClassName = this.getProperties().getProperty("provider");
        super.init(data);
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_cache = new Cache((CacheRefresher)this, this.userReference(""));
        this.m_anon = new BaseUser("");
        if (this.m_providerClassName != null) {
            try {
                this.m_provider = (UserDirectoryProvider)Class.forName(this.m_providerClassName).newInstance();
                Log.info("chef", this + ".init(): provider: " + this.m_providerClassName);
            }
            catch (Exception e) {
                Log.warn("chef", this + ".init(): trouble loading provider: " + e);
            }
        }
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        this.m_cache.clear();
        this.m_cache = null;
        this.m_storage.close();
        this.m_storage = null;
        this.m_provider = null;
        this.m_anon = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public User getUser(String id) throws IdUnusedException {
        if (id == null) {
            throw new IdUnusedException("null");
        }
        BaseUserEdit user = this.findUser(id);
        if (user == null && this.m_provider != null && this.m_provider instanceof CompleteUdp && !((CompleteUdp)this.m_provider).getUser(user = new BaseUserEdit(id))) {
            user = null;
        }
        if (user == null) {
            throw new IdUnusedException(id);
        }
        return user;
    }

    public boolean allowUpdateUser(String id) {
        if (id.equals(UsageSessionService.safelyGetSessionUserId())) {
            return this.unlockCheck2("user.upd.own", "user.upd.any", this.userReference(id));
        }
        return this.unlockCheck("user.upd.any", this.userReference(id));
    }

    public UserEdit editUser(String id) throws IdUnusedException, PermissionException, InUseException {
        if (id == null) {
            throw new IdUnusedException("null");
        }
        String function = null;
        if (id.equals(UsageSessionService.safelyGetSessionUserId())) {
            this.unlock2("user.upd.own", "user.upd.any", this.userReference(id));
            function = "user.upd.own";
        } else {
            this.unlock("user.upd.any", this.userReference(id));
            function = "user.upd.any";
        }
        if (this.m_cache.get(this.userReference(id)) == null && !this.m_storage.check(id)) {
            throw new IdUnusedException(id);
        }
        UserEdit user = this.m_storage.edit(id);
        if (user == null) {
            throw new InUseException(id);
        }
        ((BaseUserEdit)user).setEvent(function);
        return user;
    }

    public void commitEdit(UserEdit user) {
        if (!user.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed UserEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(user.getPropertiesEdit());
        this.m_storage.commit(user);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseUserEdit)user).getEvent(), user.getReference(), true));
        ((BaseUserEdit)user).closeEdit();
    }

    public void cancelEdit(UserEdit user) {
        if (!user.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed UserEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancel(user);
        ((BaseUserEdit)user).closeEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUsers() {
        List users = new Vector();
        if (this.m_cache.disabled()) {
            users = this.m_storage.getAll();
        } else if (this.m_cache.isComplete()) {
            users = this.m_cache.getAll();
        } else {
            Cache cache = this.m_cache;
            synchronized (cache) {
                block9: {
                    if (!this.m_cache.isComplete()) break block9;
                    users = this.m_cache.getAll();
                    List list = users;
                    return list;
                }
                this.m_cache.holdEvents();
                users = this.m_storage.getAll();
                int i = 0;
                while (i < users.size()) {
                    User user = (User)users.get(i);
                    this.m_cache.put(user.getReference(), user);
                    ++i;
                }
                this.m_cache.setComplete();
                this.m_cache.processEvents();
            }
        }
        return users;
    }

    public User findUserByEmail(String email) throws IdUnusedException {
        BaseUserEdit user;
        if (this.m_provider != null && this.m_provider instanceof CompleteUdp && ((CompleteUdp)this.m_provider).findUserByEmail(user = new BaseUserEdit((String)null), email)) {
            return user;
        }
        List users = this.getUsers();
        Iterator iUsers = users.iterator();
        while (iUsers.hasNext()) {
            User user2 = (User)iUsers.next();
            if (!user2.getEmail().equalsIgnoreCase(email)) continue;
            return user2;
        }
        return null;
    }

    public User getAnonymousUser() {
        return this.m_anon;
    }

    public boolean allowAddUser(String id) {
        return this.unlockCheck("user.add", this.userReference(id));
    }

    public UserEdit addUser(String id) throws IdInvalidException, IdUsedException, PermissionException {
        Validator.checkResourceId(id);
        this.unlock("user.add", this.userReference(id));
        if (this.m_provider != null && this.m_provider instanceof CompleteUdp && ((CompleteUdp)this.m_provider).userExists(id)) {
            throw new IdUsedException(id);
        }
        UserEdit user = this.m_storage.put(id);
        if (user == null) {
            throw new IdUsedException(id);
        }
        ((BaseUserEdit)user).setEvent("user.add");
        return user;
    }

    public UserEdit mergeUser(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseUser userFromXml = new BaseUser(el);
        Validator.checkResourceId(userFromXml.getId());
        this.unlock("user.add", userFromXml.getReference());
        if (this.m_provider != null && this.m_provider instanceof CompleteUdp && ((CompleteUdp)this.m_provider).userExists(userFromXml.getId())) {
            throw new IdUsedException(userFromXml.getId());
        }
        UserEdit user = this.m_storage.put(userFromXml.getId());
        if (user == null) {
            throw new IdUsedException(userFromXml.getId());
        }
        ((BaseUserEdit)user).set(userFromXml);
        ((BaseUserEdit)user).setEvent("user.add");
        return user;
    }

    public boolean allowRemoveUser(String id) {
        return this.unlockCheck("user.del", this.userReference(id));
    }

    public void removeUser(UserEdit user) throws PermissionException {
        if (!user.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeUser(): closed UserEdit", (Throwable)e);
                return;
            }
        }
        this.unlock("user.del", user.getReference());
        this.m_storage.remove(user);
        EventTrackingService.post(EventTrackingService.newEvent("user.del", user.getReference(), true));
        ((BaseUserEdit)user).closeEdit();
    }

    public boolean authenticate(String id, String password) {
        boolean authenticated = false;
        BaseUserEdit user = this.findUser(id);
        if (this.m_provider != null && this.m_provider instanceof CompleteUdp && user == null) {
            authenticated = ((CompleteUdp)this.m_provider).authenticateUser(id, password);
        }
        if (!authenticated && this.m_provider != null && this.m_provider instanceof PiggybackUdp && user != null && (authenticated = ((PiggybackUdp)this.m_provider).authenticateUser(user, password))) {
            BaseUserEdit edit = (BaseUserEdit)this.m_storage.edit(id);
            if (edit != null) {
                edit.setAll(user);
                edit.setEvent("user.upd.any");
                this.m_storage.commit(edit);
                EventTrackingService.post(EventTrackingService.newEvent(edit.getEvent(), edit.getReference(), true));
            } else {
                Log.warn("chef", this + ".authenticate(): could not save user after auth: " + id);
            }
        }
        if (!authenticated && user != null) {
            boolean containerAuthentication = "true".equals(ServerConfigurationService.getString("container.auth", "false"));
            if (containerAuthentication) {
                JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
                JetspeedRunData data = runDataService.getCurrentRunData();
                if (user.getId().equals(data.getRequest().getRemoteUser())) {
                    authenticated = true;
                }
            } else {
                authenticated = user.checkPassword(password);
            }
        }
        return authenticated;
    }

    protected BaseUserEdit findUser(String id) {
        BaseUserEdit user = null;
        String key = this.userReference(id);
        if (this.m_cache.containsKey(key)) {
            user = (BaseUserEdit)this.m_cache.get(key);
        } else {
            user = (BaseUserEdit)this.m_storage.get(id);
            this.m_cache.put(key, user);
        }
        return user;
    }

    protected void addLiveProperties(ResourcePropertiesEdit props) {
        String current = UsageSessionService.getSessionUser().getId();
        props.addProperty("CHEF:creator", current);
        props.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        props.addProperty("DAV:creationdate", now);
        props.addProperty("DAV:getlastmodified", now);
    }

    protected void addLiveUpdateProperties(ResourcePropertiesEdit props) {
        String current = UsageSessionService.getSessionUser().getId();
        props.addProperty("CHEF:modifiedby", current);
        props.addProperty("DAV:getlastmodified", new Time().toString());
    }

    public Resource newContainer(String ref) {
        return null;
    }

    public Resource newContainer(Element element) {
        return null;
    }

    public Resource newContainer(Resource other) {
        return null;
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseUserEdit(id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseUserEdit(element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseUserEdit((User)other);
    }

    public Edit newContainerEdit(String ref) {
        return null;
    }

    public Edit newContainerEdit(Element element) {
        return null;
    }

    public Edit newContainerEdit(Resource other) {
        return null;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseUserEdit e = new BaseUserEdit(id);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseUserEdit e = new BaseUserEdit(element);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseUserEdit e = new BaseUserEdit((User)other);
        e.activate();
        return e;
    }

    public Object[] storageFields(Resource r) {
        return null;
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        String id = this.userId((String)key);
        UserEdit user = this.m_storage.get(id);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".refresh(): " + key + " : " + id);
        }
        return user;
    }

    protected static interface Storage {
        public void open();

        public void close();

        public boolean check(String var1);

        public UserEdit get(String var1);

        public List getAll();

        public UserEdit put(String var1);

        public UserEdit edit(String var1);

        public void commit(UserEdit var1);

        public void cancel(UserEdit var1);

        public void remove(UserEdit var1);
    }

    public class BaseUserEdit
    extends BaseUser
    implements UserEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseUserEdit(String id) {
            super(id);
        }

        public BaseUserEdit(Element el) {
            super(el);
        }

        public BaseUserEdit(User user) {
            super(user);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseUserDirectoryService.this.cancelEdit(this);
            }
        }

        public void setId(String id) {
            if (this.m_id == null) {
                this.m_id = id;
            }
        }

        public void setFirstName(String name) {
            if (Different.different(name, this.m_firstName)) {
                this.m_firstName = name;
            }
        }

        public void setLastName(String name) {
            if (Different.different(name, this.m_lastName)) {
                this.m_lastName = name;
            }
        }

        public void setEmail(String email) {
            if (Different.different(email, this.m_email)) {
                this.m_email = email;
            }
        }

        public void setPassword(String pw) {
            String encoded = OneWayHash.encode(pw);
            if (Different.different(encoded, this.m_pw)) {
                this.m_pw = encoded;
            }
        }

        protected void set(User user) {
            this.setAll(user);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseUserDirectoryService.this.cancelEdit(this);
            }
        }
    }

    public class BaseUser
    implements User {
        protected String m_id = null;
        protected String m_firstName = null;
        protected String m_lastName = null;
        protected String m_email = null;
        protected String m_pw = null;
        protected ResourcePropertiesEdit m_properties = null;

        public BaseUser(String id) {
            this.m_id = id;
            BaseResourcePropertiesEdit props = new BaseResourcePropertiesEdit();
            this.m_properties = props;
            if (this.m_id != null && this.m_id.length() > 0) {
                BaseUserDirectoryService.this.addLiveProperties(props);
            }
        }

        public BaseUser(User user) {
            this.setAll(user);
        }

        public BaseUser(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            this.m_firstName = el.getAttribute("first-name");
            if (this.m_firstName.trim().length() == 0) {
                this.m_firstName = null;
            }
            this.m_lastName = el.getAttribute("last-name");
            if (this.m_lastName.trim().length() == 0) {
                this.m_lastName = null;
            }
            this.m_email = el.getAttribute("email");
            this.m_pw = el.getAttribute("pw");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
        }

        protected void setAll(User user) {
            this.m_id = user.getId();
            this.m_firstName = user.getFirstName();
            this.m_lastName = user.getLastName();
            this.m_email = user.getEmail();
            this.m_pw = ((BaseUser)user).m_pw;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(user.getProperties());
        }

        public Element toXml(Document doc, Stack stack) {
            Element user = doc.createElement("user");
            if (stack.isEmpty()) {
                doc.appendChild(user);
            } else {
                ((Element)stack.peek()).appendChild(user);
            }
            stack.push(user);
            user.setAttribute("id", this.getId());
            if (this.m_firstName != null) {
                user.setAttribute("first-name", this.m_firstName);
            }
            if (this.m_lastName != null) {
                user.setAttribute("last-name", this.m_lastName);
            }
            user.setAttribute("email", this.getEmail());
            user.setAttribute("pw", this.m_pw);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return user;
        }

        public String getId() {
            if (this.m_id == null) {
                return "";
            }
            return this.m_id;
        }

        public String getUrl() {
            return BaseUserDirectoryService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseUserDirectoryService.this.userReference(this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getDisplayName() {
            StringBuffer buf = new StringBuffer(128);
            if (this.m_firstName != null) {
                buf.append(this.m_firstName);
            }
            if (this.m_lastName != null) {
                buf.append(" ");
                buf.append(this.m_lastName);
            }
            if (buf.length() == 0) {
                return this.getId();
            }
            return buf.toString();
        }

        public String getFirstName() {
            if (this.m_firstName == null) {
                return "";
            }
            return this.m_firstName;
        }

        public String getLastName() {
            if (this.m_lastName == null) {
                return "";
            }
            return this.m_lastName;
        }

        public String getSortName() {
            StringBuffer buf = new StringBuffer(128);
            if (this.m_lastName != null) {
                buf.append(this.m_lastName);
            }
            if (this.m_firstName != null) {
                buf.append(", ");
                buf.append(this.m_firstName);
            }
            if (buf.length() == 0) {
                return this.getId();
            }
            return buf.toString();
        }

        public String getEmail() {
            if (this.m_email == null) {
                return "";
            }
            return this.m_email;
        }

        public boolean checkPassword(String pw) {
            String encoded = OneWayHash.encode(pw);
            return this.m_pw.equals(encoded);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof User)) {
                return false;
            }
            return ((User)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof User)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getSortName().compareTo(((User)obj).getSortName());
            if (compare == 0) {
                compare = this.getId().compareTo(((User)obj).getId());
            }
            return compare;
        }
    }
}

